# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SslArgs', 'Ssl']

@pulumi.input_type
class SslArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[_builtins.str],
                 key: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 chain: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Ssl resource.
        :param pulumi.Input[_builtins.str] certificate: Certificate
        :param pulumi.Input[_builtins.str] key: Certificate key
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] chain: Certificate chain
        :param pulumi.Input[_builtins.str] display_name: Readable label for loadbalancer ssl
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "service_name", service_name)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[_builtins.str]:
        """
        Certificate
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        Certificate key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate chain
        """
        return pulumi.get(self, "chain")

    @chain.setter
    def chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chain", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Readable label for loadbalancer ssl
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _SslState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 chain: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_date: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ssl resources.
        :param pulumi.Input[_builtins.str] certificate: Certificate
        :param pulumi.Input[_builtins.str] chain: Certificate chain
        :param pulumi.Input[_builtins.str] display_name: Readable label for loadbalancer ssl
        :param pulumi.Input[_builtins.str] expire_date: Expire date of your SSL certificate.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of your SSL certificate.
        :param pulumi.Input[_builtins.str] key: Certificate key
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: Subject Alternative Name of your SSL certificate.
        :param pulumi.Input[_builtins.str] serial: Serial of your SSL certificate (Deprecated, use fingerprint instead !)
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] subject: Subject of your SSL certificate.
        :param pulumi.Input[_builtins.str] type: Type of your SSL certificate. 'built' for SSL certificates managed by the IP Load Balancing. 'custom' for user manager certificates.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if expire_date is not None:
            pulumi.set(__self__, "expire_date", expire_date)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if sans is not None:
            pulumi.set(__self__, "sans", sans)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter
    def chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate chain
        """
        return pulumi.get(self, "chain")

    @chain.setter
    def chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chain", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Readable label for loadbalancer ssl
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="expireDate")
    def expire_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expire date of your SSL certificate.
        """
        return pulumi.get(self, "expire_date")

    @expire_date.setter
    def expire_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_date", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fingerprint of your SSL certificate.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Subject Alternative Name of your SSL certificate.
        """
        return pulumi.get(self, "sans")

    @sans.setter
    def sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sans", value)

    @_builtins.property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Serial of your SSL certificate (Deprecated, use fingerprint instead !)
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subject of your SSL certificate.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of your SSL certificate. 'built' for SSL certificates managed by the IP Load Balancing. 'custom' for user manager certificates.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("ovh:IpLoadBalancing/ssl:Ssl")
class Ssl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 chain: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a new custom SSL certificate on your IP Load Balancing

        ## Import

        SSL can be imported using the following format `service_name` and the `id` of the ssl, separated by "/" e.g.

        bash

        ```sh
        $ pulumi import ovh:IpLoadBalancing/ssl:Ssl sslname service_name/ssl_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate: Certificate
        :param pulumi.Input[_builtins.str] chain: Certificate chain
        :param pulumi.Input[_builtins.str] display_name: Readable label for loadbalancer ssl
        :param pulumi.Input[_builtins.str] key: Certificate key
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SslArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new custom SSL certificate on your IP Load Balancing

        ## Import

        SSL can be imported using the following format `service_name` and the `id` of the ssl, separated by "/" e.g.

        bash

        ```sh
        $ pulumi import ovh:IpLoadBalancing/ssl:Ssl sslname service_name/ssl_id
        ```

        :param str resource_name: The name of the resource.
        :param SslArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SslArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 chain: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SslArgs.__new__(SslArgs)

            if certificate is None and not opts.urn:
                raise TypeError("Missing required property 'certificate'")
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["chain"] = chain
            __props__.__dict__["display_name"] = display_name
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = None if key is None else pulumi.Output.secret(key)
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["expire_date"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["sans"] = None
            __props__.__dict__["serial"] = None
            __props__.__dict__["subject"] = None
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Ssl, __self__).__init__(
            'ovh:IpLoadBalancing/ssl:Ssl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            chain: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            expire_date: Optional[pulumi.Input[_builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            serial: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            subject: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Ssl':
        """
        Get an existing Ssl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate: Certificate
        :param pulumi.Input[_builtins.str] chain: Certificate chain
        :param pulumi.Input[_builtins.str] display_name: Readable label for loadbalancer ssl
        :param pulumi.Input[_builtins.str] expire_date: Expire date of your SSL certificate.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of your SSL certificate.
        :param pulumi.Input[_builtins.str] key: Certificate key
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: Subject Alternative Name of your SSL certificate.
        :param pulumi.Input[_builtins.str] serial: Serial of your SSL certificate (Deprecated, use fingerprint instead !)
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] subject: Subject of your SSL certificate.
        :param pulumi.Input[_builtins.str] type: Type of your SSL certificate. 'built' for SSL certificates managed by the IP Load Balancing. 'custom' for user manager certificates.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SslState.__new__(_SslState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["chain"] = chain
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["expire_date"] = expire_date
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["key"] = key
        __props__.__dict__["sans"] = sans
        __props__.__dict__["serial"] = serial
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["subject"] = subject
        __props__.__dict__["type"] = type
        return Ssl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter
    def chain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Certificate chain
        """
        return pulumi.get(self, "chain")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Readable label for loadbalancer ssl
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="expireDate")
    def expire_date(self) -> pulumi.Output[_builtins.str]:
        """
        Expire date of your SSL certificate.
        """
        return pulumi.get(self, "expire_date")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        Fingerprint of your SSL certificate.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate key
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def sans(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Subject Alternative Name of your SSL certificate.
        """
        return pulumi.get(self, "sans")

    @_builtins.property
    @pulumi.getter
    def serial(self) -> pulumi.Output[_builtins.str]:
        """
        Serial of your SSL certificate (Deprecated, use fingerprint instead !)
        """
        return pulumi.get(self, "serial")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Output[_builtins.str]:
        """
        Subject of your SSL certificate.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of your SSL certificate. 'built' for SSL certificates managed by the IP Load Balancing. 'custom' for user manager certificates.
        """
        return pulumi.get(self, "type")

