# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAPIOAuth2ClientResult',
    'AwaitableGetAPIOAuth2ClientResult',
    'get_apio_auth2_client',
    'get_apio_auth2_client_output',
]

@pulumi.output_type
class GetAPIOAuth2ClientResult:
    """
    A collection of values returned by getAPIOAuth2Client.
    """
    def __init__(__self__, callback_urls=None, client_id=None, description=None, flow=None, id=None, identity=None, name=None):
        if callback_urls and not isinstance(callback_urls, list):
            raise TypeError("Expected argument 'callback_urls' to be a list")
        pulumi.set(__self__, "callback_urls", callback_urls)
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if flow and not isinstance(flow, str):
            raise TypeError("Expected argument 'flow' to be a str")
        pulumi.set(__self__, "flow", flow)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity and not isinstance(identity, str):
            raise TypeError("Expected argument 'identity' to be a str")
        pulumi.set(__self__, "identity", identity)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="callbackUrls")
    def callback_urls(self) -> Sequence[_builtins.str]:
        """
        List of callback urls when configuring the `AUTHORIZATION_CODE` flow.
        """
        return pulumi.get(self, "callback_urls")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        Client ID of the created service account.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        OAuth2 client description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def flow(self) -> _builtins.str:
        """
        The OAuth2 flow to use. `AUTHORIZATION_CODE` or `CLIENT_CREDENTIALS` are supported at the moment.
        """
        return pulumi.get(self, "flow")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> _builtins.str:
        """
        Identity URN of the service account to be used inside an IAM policy.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        OAuth2 client name.
        """
        return pulumi.get(self, "name")


class AwaitableGetAPIOAuth2ClientResult(GetAPIOAuth2ClientResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAPIOAuth2ClientResult(
            callback_urls=self.callback_urls,
            client_id=self.client_id,
            description=self.description,
            flow=self.flow,
            id=self.id,
            identity=self.identity,
            name=self.name)


def get_apio_auth2_client(client_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAPIOAuth2ClientResult:
    """
    Use this data source to retrieve information about an existing OAuth2 service account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_oauth2_client = ovh.Me.get_apio_auth2_client(client_id="5f8969a993ec8b4b")
    ```


    :param _builtins.str client_id: Client ID of an existing OAuth2 service account.
    """
    __args__ = dict()
    __args__['clientId'] = client_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Me/getAPIOAuth2Client:getAPIOAuth2Client', __args__, opts=opts, typ=GetAPIOAuth2ClientResult).value

    return AwaitableGetAPIOAuth2ClientResult(
        callback_urls=pulumi.get(__ret__, 'callback_urls'),
        client_id=pulumi.get(__ret__, 'client_id'),
        description=pulumi.get(__ret__, 'description'),
        flow=pulumi.get(__ret__, 'flow'),
        id=pulumi.get(__ret__, 'id'),
        identity=pulumi.get(__ret__, 'identity'),
        name=pulumi.get(__ret__, 'name'))
def get_apio_auth2_client_output(client_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAPIOAuth2ClientResult]:
    """
    Use this data source to retrieve information about an existing OAuth2 service account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_oauth2_client = ovh.Me.get_apio_auth2_client(client_id="5f8969a993ec8b4b")
    ```


    :param _builtins.str client_id: Client ID of an existing OAuth2 service account.
    """
    __args__ = dict()
    __args__['clientId'] = client_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Me/getAPIOAuth2Client:getAPIOAuth2Client', __args__, opts=opts, typ=GetAPIOAuth2ClientResult)
    return __ret__.apply(lambda __response__: GetAPIOAuth2ClientResult(
        callback_urls=pulumi.get(__response__, 'callback_urls'),
        client_id=pulumi.get(__response__, 'client_id'),
        description=pulumi.get(__response__, 'description'),
        flow=pulumi.get(__response__, 'flow'),
        id=pulumi.get(__response__, 'id'),
        identity=pulumi.get(__response__, 'identity'),
        name=pulumi.get(__response__, 'name')))
