# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetIdentityGroupResult',
    'AwaitableGetIdentityGroupResult',
    'get_identity_group',
    'get_identity_group_output',
]

@pulumi.output_type
class GetIdentityGroupResult:
    """
    A collection of values returned by getIdentityGroup.
    """
    def __init__(__self__, group_urn=None, creation=None, default_group=None, description=None, id=None, last_update=None, name=None, role=None):
        if group_urn and not isinstance(group_urn, str):
            raise TypeError("Expected argument 'group_urn' to be a str")
        pulumi.set(__self__, "group_urn", group_urn)
        if creation and not isinstance(creation, str):
            raise TypeError("Expected argument 'creation' to be a str")
        pulumi.set(__self__, "creation", creation)
        if default_group and not isinstance(default_group, bool):
            raise TypeError("Expected argument 'default_group' to be a bool")
        pulumi.set(__self__, "default_group", default_group)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_update and not isinstance(last_update, str):
            raise TypeError("Expected argument 'last_update' to be a str")
        pulumi.set(__self__, "last_update", last_update)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter(name="GroupURN")
    def group_urn(self) -> _builtins.str:
        """
        Identity URN of the group.
        """
        return pulumi.get(self, "group_urn")

    @_builtins.property
    @pulumi.getter
    def creation(self) -> _builtins.str:
        """
        Creation date of this group.
        """
        return pulumi.get(self, "creation")

    @_builtins.property
    @pulumi.getter(name="defaultGroup")
    def default_group(self) -> _builtins.bool:
        """
        Is the group a default and immutable one.
        """
        return pulumi.get(self, "default_group")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Group description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> _builtins.str:
        """
        Date of the last update of this group.
        """
        return pulumi.get(self, "last_update")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        Role associated with the group. Valid roles are ADMIN, REGULAR, UNPRIVILEGED, and NONE.
        """
        return pulumi.get(self, "role")


class AwaitableGetIdentityGroupResult(GetIdentityGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIdentityGroupResult(
            group_urn=self.group_urn,
            creation=self.creation,
            default_group=self.default_group,
            description=self.description,
            id=self.id,
            last_update=self.last_update,
            name=self.name,
            role=self.role)


def get_identity_group(name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIdentityGroupResult:
    """
    Use this data source to retrieve information about an identity group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_group = ovh.Me.get_identity_group(name="my_group_name")
    ```


    :param _builtins.str name: Group name.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Me/getIdentityGroup:getIdentityGroup', __args__, opts=opts, typ=GetIdentityGroupResult).value

    return AwaitableGetIdentityGroupResult(
        group_urn=pulumi.get(__ret__, 'group_urn'),
        creation=pulumi.get(__ret__, 'creation'),
        default_group=pulumi.get(__ret__, 'default_group'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        last_update=pulumi.get(__ret__, 'last_update'),
        name=pulumi.get(__ret__, 'name'),
        role=pulumi.get(__ret__, 'role'))
def get_identity_group_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIdentityGroupResult]:
    """
    Use this data source to retrieve information about an identity group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_group = ovh.Me.get_identity_group(name="my_group_name")
    ```


    :param _builtins.str name: Group name.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Me/getIdentityGroup:getIdentityGroup', __args__, opts=opts, typ=GetIdentityGroupResult)
    return __ret__.apply(lambda __response__: GetIdentityGroupResult(
        group_urn=pulumi.get(__response__, 'group_urn'),
        creation=pulumi.get(__response__, 'creation'),
        default_group=pulumi.get(__response__, 'default_group'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        last_update=pulumi.get(__response__, 'last_update'),
        name=pulumi.get(__response__, 'name'),
        role=pulumi.get(__response__, 'role')))
