# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPaymentmeanBankAccountResult',
    'AwaitableGetPaymentmeanBankAccountResult',
    'get_paymentmean_bank_account',
    'get_paymentmean_bank_account_output',
]

@pulumi.output_type
class GetPaymentmeanBankAccountResult:
    """
    A collection of values returned by getPaymentmeanBankAccount.
    """
    def __init__(__self__, default=None, description=None, description_regexp=None, id=None, state=None, use_default=None, use_oldest=None):
        if default and not isinstance(default, bool):
            raise TypeError("Expected argument 'default' to be a bool")
        pulumi.set(__self__, "default", default)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if description_regexp and not isinstance(description_regexp, str):
            raise TypeError("Expected argument 'description_regexp' to be a str")
        pulumi.set(__self__, "description_regexp", description_regexp)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if use_default and not isinstance(use_default, bool):
            raise TypeError("Expected argument 'use_default' to be a bool")
        pulumi.set(__self__, "use_default", use_default)
        if use_oldest and not isinstance(use_oldest, bool):
            raise TypeError("Expected argument 'use_oldest' to be a bool")
        pulumi.set(__self__, "use_oldest", use_oldest)

    @_builtins.property
    @pulumi.getter
    def default(self) -> _builtins.bool:
        """
        a boolean which tells if the retrieved bank account is marked as the default payment mean
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        the description attribute of the bank account
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="descriptionRegexp")
    def description_regexp(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description_regexp")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "use_default")

    @_builtins.property
    @pulumi.getter(name="useOldest")
    def use_oldest(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "use_oldest")


class AwaitableGetPaymentmeanBankAccountResult(GetPaymentmeanBankAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPaymentmeanBankAccountResult(
            default=self.default,
            description=self.description,
            description_regexp=self.description_regexp,
            id=self.id,
            state=self.state,
            use_default=self.use_default,
            use_oldest=self.use_oldest)


def get_paymentmean_bank_account(description_regexp: Optional[_builtins.str] = None,
                                 state: Optional[_builtins.str] = None,
                                 use_default: Optional[_builtins.bool] = None,
                                 use_oldest: Optional[_builtins.bool] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPaymentmeanBankAccountResult:
    """
    Use this data source to retrieve information about a bank account payment mean associated with an OVHcloud account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    ba = ovh.Me.get_paymentmean_bank_account(use_default=True)
    ```


    :param _builtins.str description_regexp: a regexp used to filter bank accounts on their `description` attributes.
    :param _builtins.str state: Filter bank accounts on their `state` attribute. Can be "blockedForIncidents", "valid", "pendingValidation"
    :param _builtins.bool use_default: Retrieve bank account marked as default payment mean.
    :param _builtins.bool use_oldest: Retrieve oldest bank account. project.
    """
    __args__ = dict()
    __args__['descriptionRegexp'] = description_regexp
    __args__['state'] = state
    __args__['useDefault'] = use_default
    __args__['useOldest'] = use_oldest
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Me/getPaymentmeanBankAccount:getPaymentmeanBankAccount', __args__, opts=opts, typ=GetPaymentmeanBankAccountResult).value

    return AwaitableGetPaymentmeanBankAccountResult(
        default=pulumi.get(__ret__, 'default'),
        description=pulumi.get(__ret__, 'description'),
        description_regexp=pulumi.get(__ret__, 'description_regexp'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        use_default=pulumi.get(__ret__, 'use_default'),
        use_oldest=pulumi.get(__ret__, 'use_oldest'))
def get_paymentmean_bank_account_output(description_regexp: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        use_default: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                        use_oldest: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPaymentmeanBankAccountResult]:
    """
    Use this data source to retrieve information about a bank account payment mean associated with an OVHcloud account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    ba = ovh.Me.get_paymentmean_bank_account(use_default=True)
    ```


    :param _builtins.str description_regexp: a regexp used to filter bank accounts on their `description` attributes.
    :param _builtins.str state: Filter bank accounts on their `state` attribute. Can be "blockedForIncidents", "valid", "pendingValidation"
    :param _builtins.bool use_default: Retrieve bank account marked as default payment mean.
    :param _builtins.bool use_oldest: Retrieve oldest bank account. project.
    """
    __args__ = dict()
    __args__['descriptionRegexp'] = description_regexp
    __args__['state'] = state
    __args__['useDefault'] = use_default
    __args__['useOldest'] = use_oldest
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Me/getPaymentmeanBankAccount:getPaymentmeanBankAccount', __args__, opts=opts, typ=GetPaymentmeanBankAccountResult)
    return __ret__.apply(lambda __response__: GetPaymentmeanBankAccountResult(
        default=pulumi.get(__response__, 'default'),
        description=pulumi.get(__response__, 'description'),
        description_regexp=pulumi.get(__response__, 'description_regexp'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        use_default=pulumi.get(__response__, 'use_default'),
        use_oldest=pulumi.get(__response__, 'use_oldest')))
