# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOkmsResourceResult',
    'AwaitableGetOkmsResourceResult',
    'get_okms_resource',
    'get_okms_resource_output',
]

@pulumi.output_type
class GetOkmsResourceResult:
    """
    A collection of values returned by getOkmsResource.
    """
    def __init__(__self__, iam=None, id=None, kmip_endpoint=None, public_ca=None, region=None, rest_endpoint=None, swagger_endpoint=None):
        if iam and not isinstance(iam, dict):
            raise TypeError("Expected argument 'iam' to be a dict")
        pulumi.set(__self__, "iam", iam)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kmip_endpoint and not isinstance(kmip_endpoint, str):
            raise TypeError("Expected argument 'kmip_endpoint' to be a str")
        pulumi.set(__self__, "kmip_endpoint", kmip_endpoint)
        if public_ca and not isinstance(public_ca, str):
            raise TypeError("Expected argument 'public_ca' to be a str")
        pulumi.set(__self__, "public_ca", public_ca)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rest_endpoint and not isinstance(rest_endpoint, str):
            raise TypeError("Expected argument 'rest_endpoint' to be a str")
        pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if swagger_endpoint and not isinstance(swagger_endpoint, str):
            raise TypeError("Expected argument 'swagger_endpoint' to be a str")
        pulumi.set(__self__, "swagger_endpoint", swagger_endpoint)

    @_builtins.property
    @pulumi.getter
    def iam(self) -> 'outputs.GetOkmsResourceIamResult':
        """
        (Attributes) IAM resource metadata (see below for nested schema)
        """
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (String) Unique identifier of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmipEndpoint")
    def kmip_endpoint(self) -> _builtins.str:
        """
        (String) KMS kmip API endpoint
        """
        return pulumi.get(self, "kmip_endpoint")

    @_builtins.property
    @pulumi.getter(name="publicCa")
    def public_ca(self) -> _builtins.str:
        """
        (String) KMS public CA (Certificate Authority)
        """
        return pulumi.get(self, "public_ca")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        (String) Region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> _builtins.str:
        """
        (String) KMS rest API endpoint
        """
        return pulumi.get(self, "rest_endpoint")

    @_builtins.property
    @pulumi.getter(name="swaggerEndpoint")
    def swagger_endpoint(self) -> _builtins.str:
        """
        (String) KMS rest API swagger UI
        """
        return pulumi.get(self, "swagger_endpoint")


class AwaitableGetOkmsResourceResult(GetOkmsResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOkmsResourceResult(
            iam=self.iam,
            id=self.id,
            kmip_endpoint=self.kmip_endpoint,
            public_ca=self.public_ca,
            region=self.region,
            rest_endpoint=self.rest_endpoint,
            swagger_endpoint=self.swagger_endpoint)


def get_okms_resource(id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOkmsResourceResult:
    """
    Use this data source to retrieve information about a KMS associated with this account

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    kms = ovh.Okms.get_okms_resource(id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx")
    ```


    :param _builtins.str id: Should be set to the ID of your KMS
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Okms/getOkmsResource:getOkmsResource', __args__, opts=opts, typ=GetOkmsResourceResult).value

    return AwaitableGetOkmsResourceResult(
        iam=pulumi.get(__ret__, 'iam'),
        id=pulumi.get(__ret__, 'id'),
        kmip_endpoint=pulumi.get(__ret__, 'kmip_endpoint'),
        public_ca=pulumi.get(__ret__, 'public_ca'),
        region=pulumi.get(__ret__, 'region'),
        rest_endpoint=pulumi.get(__ret__, 'rest_endpoint'),
        swagger_endpoint=pulumi.get(__ret__, 'swagger_endpoint'))
def get_okms_resource_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOkmsResourceResult]:
    """
    Use this data source to retrieve information about a KMS associated with this account

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    kms = ovh.Okms.get_okms_resource(id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx")
    ```


    :param _builtins.str id: Should be set to the ID of your KMS
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Okms/getOkmsResource:getOkmsResource', __args__, opts=opts, typ=GetOkmsResourceResult)
    return __ret__.apply(lambda __response__: GetOkmsResourceResult(
        iam=pulumi.get(__response__, 'iam'),
        id=pulumi.get(__response__, 'id'),
        kmip_endpoint=pulumi.get(__response__, 'kmip_endpoint'),
        public_ca=pulumi.get(__response__, 'public_ca'),
        region=pulumi.get(__response__, 'region'),
        rest_endpoint=pulumi.get(__response__, 'rest_endpoint'),
        swagger_endpoint=pulumi.get(__response__, 'swagger_endpoint')))
