# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['StorageEfsShareArgs', 'StorageEfsShare']

@pulumi.input_type
class StorageEfsShareArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.float],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StorageEfsShare resource.
        :param pulumi.Input[_builtins.str] protocol: Share protocol
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.float] size: Share size in Gigabytes
        :param pulumi.Input[_builtins.str] description: Share description
        :param pulumi.Input[_builtins.str] mount_point_name: User-defined name used to generate human readable access path for the share
        :param pulumi.Input[_builtins.str] name: Share name
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID used to create the share
        """
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "size", size)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mount_point_name is not None:
            pulumi.set(__self__, "mount_point_name", mount_point_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Share protocol
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.float]:
        """
        Share size in Gigabytes
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Share description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="mountPointName")
    def mount_point_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined name used to generate human readable access path for the share
        """
        return pulumi.get(self, "mount_point_name")

    @mount_point_name.setter
    def mount_point_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount_point_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Share name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot ID used to create the share
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)


@pulumi.input_type
class _StorageEfsShareState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.float]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StorageEfsShare resources.
        :param pulumi.Input[_builtins.str] created_at: Share creation date
        :param pulumi.Input[_builtins.str] description: Share description
        :param pulumi.Input[_builtins.str] mount_point_name: User-defined name used to generate human readable access path for the share
        :param pulumi.Input[_builtins.str] name: Share name
        :param pulumi.Input[_builtins.str] protocol: Share protocol
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.float] size: Share size in Gigabytes
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID used to create the share
        :param pulumi.Input[_builtins.str] status: Share status
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mount_point_name is not None:
            pulumi.set(__self__, "mount_point_name", mount_point_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Share creation date
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Share description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="mountPointName")
    def mount_point_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined name used to generate human readable access path for the share
        """
        return pulumi.get(self, "mount_point_name")

    @mount_point_name.setter
    def mount_point_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount_point_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Share name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Share protocol
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Share size in Gigabytes
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot ID used to create the share
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Share status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("ovh:index/storageEfsShare:StorageEfsShare")
class StorageEfsShare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.float]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a share for an EFS service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        efs = ovh.get_storage_efs(service_name="XXX")
        share = ovh.StorageEfsShare("share",
            service_name=efs.service_name,
            name="share",
            description="My share",
            protocol="NFS",
            size=100)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Share description
        :param pulumi.Input[_builtins.str] mount_point_name: User-defined name used to generate human readable access path for the share
        :param pulumi.Input[_builtins.str] name: Share name
        :param pulumi.Input[_builtins.str] protocol: Share protocol
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.float] size: Share size in Gigabytes
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID used to create the share
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageEfsShareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a share for an EFS service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        efs = ovh.get_storage_efs(service_name="XXX")
        share = ovh.StorageEfsShare("share",
            service_name=efs.service_name,
            name="share",
            description="My share",
            protocol="NFS",
            size=100)
        ```

        :param str resource_name: The name of the resource.
        :param StorageEfsShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageEfsShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.float]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageEfsShareArgs.__new__(StorageEfsShareArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["mount_point_name"] = mount_point_name
            __props__.__dict__["name"] = name
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
        super(StorageEfsShare, __self__).__init__(
            'ovh:index/storageEfsShare:StorageEfsShare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            mount_point_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.float]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'StorageEfsShare':
        """
        Get an existing StorageEfsShare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Share creation date
        :param pulumi.Input[_builtins.str] description: Share description
        :param pulumi.Input[_builtins.str] mount_point_name: User-defined name used to generate human readable access path for the share
        :param pulumi.Input[_builtins.str] name: Share name
        :param pulumi.Input[_builtins.str] protocol: Share protocol
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.float] size: Share size in Gigabytes
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID used to create the share
        :param pulumi.Input[_builtins.str] status: Share status
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StorageEfsShareState.__new__(_StorageEfsShareState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["mount_point_name"] = mount_point_name
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["status"] = status
        return StorageEfsShare(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Share creation date
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Share description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="mountPointName")
    def mount_point_name(self) -> pulumi.Output[_builtins.str]:
        """
        User-defined name used to generate human readable access path for the share
        """
        return pulumi.get(self, "mount_point_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Share name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Share protocol
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.float]:
        """
        Share size in Gigabytes
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[_builtins.str]:
        """
        Snapshot ID used to create the share
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Share status
        """
        return pulumi.get(self, "status")

