# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['StorageEfsShareAclArgs', 'StorageEfsShareAcl']

@pulumi.input_type
class StorageEfsShareAclArgs:
    def __init__(__self__, *,
                 access_level: pulumi.Input[_builtins.str],
                 access_to: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 share_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a StorageEfsShareAcl resource.
        :param pulumi.Input[_builtins.str] access_level: Rule access level
        :param pulumi.Input[_builtins.str] access_to: Rule destination
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.str] share_id: Share ID
        """
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "access_to", access_to)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "share_id", share_id)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> pulumi.Input[_builtins.str]:
        """
        Rule access level
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_level", value)

    @_builtins.property
    @pulumi.getter(name="accessTo")
    def access_to(self) -> pulumi.Input[_builtins.str]:
        """
        Rule destination
        """
        return pulumi.get(self, "access_to")

    @access_to.setter
    def access_to(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_to", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> pulumi.Input[_builtins.str]:
        """
        Share ID
        """
        return pulumi.get(self, "share_id")

    @share_id.setter
    def share_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "share_id", value)


@pulumi.input_type
class _StorageEfsShareAclState:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 access_to: Optional[pulumi.Input[_builtins.str]] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StorageEfsShareAcl resources.
        :param pulumi.Input[_builtins.str] access_level: Rule access level
        :param pulumi.Input[_builtins.str] access_to: Rule destination
        :param pulumi.Input[_builtins.str] access_type: Rule access type
        :param pulumi.Input[_builtins.str] created_at: Rule creation date
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.str] share_id: Share ID
        :param pulumi.Input[_builtins.str] status: Rule status
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_to is not None:
            pulumi.set(__self__, "access_to", access_to)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if share_id is not None:
            pulumi.set(__self__, "share_id", share_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule access level
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_level", value)

    @_builtins.property
    @pulumi.getter(name="accessTo")
    def access_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule destination
        """
        return pulumi.get(self, "access_to")

    @access_to.setter
    def access_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_to", value)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule access type
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule creation date
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Share ID
        """
        return pulumi.get(self, "share_id")

    @share_id.setter
    def share_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("ovh:index/storageEfsShareAcl:StorageEfsShareAcl")
class StorageEfsShareAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 access_to: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates an ACL rule for an EFS share.

        Please take a look at the list of available `access_level` values in the `Required` section in order to know the list of supported access level configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        efs = ovh.get_storage_efs(service_name="XXX")
        share = ovh.StorageEfsShare("share",
            service_name=efs.service_name,
            name="share",
            description="My share",
            protocol="NFS",
            size=100)
        acl = ovh.StorageEfsShareAcl("acl",
            service_name=efs.service_name,
            share_id=share.id,
            access_level="ro",
            access_to="10.0.0.1")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_level: Rule access level
        :param pulumi.Input[_builtins.str] access_to: Rule destination
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.str] share_id: Share ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageEfsShareAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an ACL rule for an EFS share.

        Please take a look at the list of available `access_level` values in the `Required` section in order to know the list of supported access level configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        efs = ovh.get_storage_efs(service_name="XXX")
        share = ovh.StorageEfsShare("share",
            service_name=efs.service_name,
            name="share",
            description="My share",
            protocol="NFS",
            size=100)
        acl = ovh.StorageEfsShareAcl("acl",
            service_name=efs.service_name,
            share_id=share.id,
            access_level="ro",
            access_to="10.0.0.1")
        ```

        :param str resource_name: The name of the resource.
        :param StorageEfsShareAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageEfsShareAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 access_to: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageEfsShareAclArgs.__new__(StorageEfsShareAclArgs)

            if access_level is None and not opts.urn:
                raise TypeError("Missing required property 'access_level'")
            __props__.__dict__["access_level"] = access_level
            if access_to is None and not opts.urn:
                raise TypeError("Missing required property 'access_to'")
            __props__.__dict__["access_to"] = access_to
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if share_id is None and not opts.urn:
                raise TypeError("Missing required property 'share_id'")
            __props__.__dict__["share_id"] = share_id
            __props__.__dict__["access_type"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
        super(StorageEfsShareAcl, __self__).__init__(
            'ovh:index/storageEfsShareAcl:StorageEfsShareAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_level: Optional[pulumi.Input[_builtins.str]] = None,
            access_to: Optional[pulumi.Input[_builtins.str]] = None,
            access_type: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            share_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'StorageEfsShareAcl':
        """
        Get an existing StorageEfsShareAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_level: Rule access level
        :param pulumi.Input[_builtins.str] access_to: Rule destination
        :param pulumi.Input[_builtins.str] access_type: Rule access type
        :param pulumi.Input[_builtins.str] created_at: Rule creation date
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.str] share_id: Share ID
        :param pulumi.Input[_builtins.str] status: Rule status
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StorageEfsShareAclState.__new__(_StorageEfsShareAclState)

        __props__.__dict__["access_level"] = access_level
        __props__.__dict__["access_to"] = access_to
        __props__.__dict__["access_type"] = access_type
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["share_id"] = share_id
        __props__.__dict__["status"] = status
        return StorageEfsShareAcl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> pulumi.Output[_builtins.str]:
        """
        Rule access level
        """
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="accessTo")
    def access_to(self) -> pulumi.Output[_builtins.str]:
        """
        Rule destination
        """
        return pulumi.get(self, "access_to")

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Output[_builtins.str]:
        """
        Rule access type
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Rule creation date
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> pulumi.Output[_builtins.str]:
        """
        Share ID
        """
        return pulumi.get(self, "share_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Rule status
        """
        return pulumi.get(self, "status")

