# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpsArgs', 'Vps']

@pulumi.input_type
class VpsArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keymap: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 model: Optional[pulumi.Input['VpsModelArgs']] = None,
                 monitoring_ip_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netboot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 offer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanOptionArgs']]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanArgs']]]] = None,
                 public_ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sla_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vcore: Optional[pulumi.Input[_builtins.float]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Vps resource.
        :param pulumi.Input[_builtins.str] display_name: Custom display name
        :param pulumi.Input[_builtins.str] image_id: Id of the image to install on the VPS. This attribute is only useful to trigger a VPS reinstallation. The available values can be found using this [API call](https://eu.api.ovh.com/console/?section=%2Fvps&branch=v1#get-/vps/-serviceName-/images/available)
        :param pulumi.Input[_builtins.str] keymap: KVM keyboard layout on VPS Cloud
        :param pulumi.Input[_builtins.float] memory_limit: RAM of this VPS
        :param pulumi.Input['VpsModelArgs'] model: Structure describing characteristics of a VPS model
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] monitoring_ip_blocks: IP blocks for OVH monitoring servers
        :param pulumi.Input[_builtins.str] name: Name of the VPS
        :param pulumi.Input[_builtins.str] netboot_mode: VPS netboot mode (local┃rescue)
        :param pulumi.Input[_builtins.str] offer_type: All offers a VPS can have (beta-classic┃classic┃cloud┃cloudram┃game-classic┃lowlat┃ssd)
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json](https://eu.api.ovh.com/console-preview/?section=%2Fme&branch=v1#get-/me)
        :param pulumi.Input[Sequence[pulumi.Input['VpsPlanOptionArgs']]] plan_options: Product Plan to order
        :param pulumi.Input[Sequence[pulumi.Input['VpsPlanArgs']]] plans: Product Plan to order
        :param pulumi.Input[_builtins.str] public_ssh_key: Public SSH key to pre-install on your VPS - if set, then `image_id` must also be set
        :param pulumi.Input[_builtins.str] state: State of the VPS (backuping┃installing┃maintenance┃rebooting┃rescued┃running┃stopped┃stopping┃upgrading)
        :param pulumi.Input[_builtins.float] vcore: Number of vcores
        :param pulumi.Input[_builtins.str] zone: OpenStask region where the VPS is located
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if keymap is not None:
            pulumi.set(__self__, "keymap", keymap)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if monitoring_ip_blocks is not None:
            pulumi.set(__self__, "monitoring_ip_blocks", monitoring_ip_blocks)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if netboot_mode is not None:
            pulumi.set(__self__, "netboot_mode", netboot_mode)
        if offer_type is not None:
            pulumi.set(__self__, "offer_type", offer_type)
        if ovh_subsidiary is not None:
            pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if plan_options is not None:
            pulumi.set(__self__, "plan_options", plan_options)
        if plans is not None:
            pulumi.set(__self__, "plans", plans)
        if public_ssh_key is not None:
            pulumi.set(__self__, "public_ssh_key", public_ssh_key)
        if sla_monitoring is not None:
            pulumi.set(__self__, "sla_monitoring", sla_monitoring)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vcore is not None:
            pulumi.set(__self__, "vcore", vcore)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the image to install on the VPS. This attribute is only useful to trigger a VPS reinstallation. The available values can be found using this [API call](https://eu.api.ovh.com/console/?section=%2Fvps&branch=v1#get-/vps/-serviceName-/images/available)
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def keymap(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KVM keyboard layout on VPS Cloud
        """
        return pulumi.get(self, "keymap")

    @keymap.setter
    def keymap(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keymap", value)

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        RAM of this VPS
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory_limit", value)

    @_builtins.property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input['VpsModelArgs']]:
        """
        Structure describing characteristics of a VPS model
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input['VpsModelArgs']]):
        pulumi.set(self, "model", value)

    @_builtins.property
    @pulumi.getter(name="monitoringIpBlocks")
    def monitoring_ip_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IP blocks for OVH monitoring servers
        """
        return pulumi.get(self, "monitoring_ip_blocks")

    @monitoring_ip_blocks.setter
    def monitoring_ip_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "monitoring_ip_blocks", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the VPS
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="netbootMode")
    def netboot_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPS netboot mode (local┃rescue)
        """
        return pulumi.get(self, "netboot_mode")

    @netboot_mode.setter
    def netboot_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netboot_mode", value)

    @_builtins.property
    @pulumi.getter(name="offerType")
    def offer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        All offers a VPS can have (beta-classic┃classic┃cloud┃cloudram┃game-classic┃lowlat┃ssd)
        """
        return pulumi.get(self, "offer_type")

    @offer_type.setter
    def offer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "offer_type", value)

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json](https://eu.api.ovh.com/console-preview/?section=%2Fme&branch=v1#get-/me)
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ovh_subsidiary", value)

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanOptionArgs']]]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan_options")

    @plan_options.setter
    def plan_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanOptionArgs']]]]):
        pulumi.set(self, "plan_options", value)

    @_builtins.property
    @pulumi.getter
    def plans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanArgs']]]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plans")

    @plans.setter
    def plans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanArgs']]]]):
        pulumi.set(self, "plans", value)

    @_builtins.property
    @pulumi.getter(name="publicSshKey")
    def public_ssh_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Public SSH key to pre-install on your VPS - if set, then `image_id` must also be set
        """
        return pulumi.get(self, "public_ssh_key")

    @public_ssh_key.setter
    def public_ssh_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ssh_key", value)

    @_builtins.property
    @pulumi.getter(name="slaMonitoring")
    def sla_monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "sla_monitoring")

    @sla_monitoring.setter
    def sla_monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sla_monitoring", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the VPS (backuping┃installing┃maintenance┃rebooting┃rescued┃running┃stopped┃stopping┃upgrading)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def vcore(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Number of vcores
        """
        return pulumi.get(self, "vcore")

    @vcore.setter
    def vcore(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "vcore", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OpenStask region where the VPS is located
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _VpsState:
    def __init__(__self__, *,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 iam: Optional[pulumi.Input['VpsIamArgs']] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keymap: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 model: Optional[pulumi.Input['VpsModelArgs']] = None,
                 monitoring_ip_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netboot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 offer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 order: Optional[pulumi.Input['VpsOrderArgs']] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanOptionArgs']]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanArgs']]]] = None,
                 public_ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sla_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vcore: Optional[pulumi.Input[_builtins.float]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Vps resources.
        :param pulumi.Input[_builtins.str] cluster: VPS cluster
        :param pulumi.Input[_builtins.str] display_name: Custom display name
        :param pulumi.Input['VpsIamArgs'] iam: IAM resource information
        :param pulumi.Input[_builtins.str] image_id: Id of the image to install on the VPS. This attribute is only useful to trigger a VPS reinstallation. The available values can be found using this [API call](https://eu.api.ovh.com/console/?section=%2Fvps&branch=v1#get-/vps/-serviceName-/images/available)
        :param pulumi.Input[_builtins.str] keymap: KVM keyboard layout on VPS Cloud
        :param pulumi.Input[_builtins.float] memory_limit: RAM of this VPS
        :param pulumi.Input['VpsModelArgs'] model: Structure describing characteristics of a VPS model
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] monitoring_ip_blocks: IP blocks for OVH monitoring servers
        :param pulumi.Input[_builtins.str] name: Name of the VPS
        :param pulumi.Input[_builtins.str] netboot_mode: VPS netboot mode (local┃rescue)
        :param pulumi.Input[_builtins.str] offer_type: All offers a VPS can have (beta-classic┃classic┃cloud┃cloudram┃game-classic┃lowlat┃ssd)
        :param pulumi.Input['VpsOrderArgs'] order: Details about an Order
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json](https://eu.api.ovh.com/console-preview/?section=%2Fme&branch=v1#get-/me)
        :param pulumi.Input[Sequence[pulumi.Input['VpsPlanOptionArgs']]] plan_options: Product Plan to order
        :param pulumi.Input[Sequence[pulumi.Input['VpsPlanArgs']]] plans: Product Plan to order
        :param pulumi.Input[_builtins.str] public_ssh_key: Public SSH key to pre-install on your VPS - if set, then `image_id` must also be set
        :param pulumi.Input[_builtins.str] service_name: The internal name of your VPS offer
        :param pulumi.Input[_builtins.str] state: State of the VPS (backuping┃installing┃maintenance┃rebooting┃rescued┃running┃stopped┃stopping┃upgrading)
        :param pulumi.Input[_builtins.float] vcore: Number of vcores
        :param pulumi.Input[_builtins.str] zone: OpenStask region where the VPS is located
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if keymap is not None:
            pulumi.set(__self__, "keymap", keymap)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if monitoring_ip_blocks is not None:
            pulumi.set(__self__, "monitoring_ip_blocks", monitoring_ip_blocks)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if netboot_mode is not None:
            pulumi.set(__self__, "netboot_mode", netboot_mode)
        if offer_type is not None:
            pulumi.set(__self__, "offer_type", offer_type)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if ovh_subsidiary is not None:
            pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if plan_options is not None:
            pulumi.set(__self__, "plan_options", plan_options)
        if plans is not None:
            pulumi.set(__self__, "plans", plans)
        if public_ssh_key is not None:
            pulumi.set(__self__, "public_ssh_key", public_ssh_key)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if sla_monitoring is not None:
            pulumi.set(__self__, "sla_monitoring", sla_monitoring)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vcore is not None:
            pulumi.set(__self__, "vcore", vcore)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPS cluster
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input['VpsIamArgs']]:
        """
        IAM resource information
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input['VpsIamArgs']]):
        pulumi.set(self, "iam", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the image to install on the VPS. This attribute is only useful to trigger a VPS reinstallation. The available values can be found using this [API call](https://eu.api.ovh.com/console/?section=%2Fvps&branch=v1#get-/vps/-serviceName-/images/available)
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def keymap(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KVM keyboard layout on VPS Cloud
        """
        return pulumi.get(self, "keymap")

    @keymap.setter
    def keymap(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keymap", value)

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        RAM of this VPS
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory_limit", value)

    @_builtins.property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input['VpsModelArgs']]:
        """
        Structure describing characteristics of a VPS model
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input['VpsModelArgs']]):
        pulumi.set(self, "model", value)

    @_builtins.property
    @pulumi.getter(name="monitoringIpBlocks")
    def monitoring_ip_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IP blocks for OVH monitoring servers
        """
        return pulumi.get(self, "monitoring_ip_blocks")

    @monitoring_ip_blocks.setter
    def monitoring_ip_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "monitoring_ip_blocks", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the VPS
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="netbootMode")
    def netboot_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPS netboot mode (local┃rescue)
        """
        return pulumi.get(self, "netboot_mode")

    @netboot_mode.setter
    def netboot_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netboot_mode", value)

    @_builtins.property
    @pulumi.getter(name="offerType")
    def offer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        All offers a VPS can have (beta-classic┃classic┃cloud┃cloudram┃game-classic┃lowlat┃ssd)
        """
        return pulumi.get(self, "offer_type")

    @offer_type.setter
    def offer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "offer_type", value)

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input['VpsOrderArgs']]:
        """
        Details about an Order
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input['VpsOrderArgs']]):
        pulumi.set(self, "order", value)

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json](https://eu.api.ovh.com/console-preview/?section=%2Fme&branch=v1#get-/me)
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ovh_subsidiary", value)

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanOptionArgs']]]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan_options")

    @plan_options.setter
    def plan_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanOptionArgs']]]]):
        pulumi.set(self, "plan_options", value)

    @_builtins.property
    @pulumi.getter
    def plans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanArgs']]]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plans")

    @plans.setter
    def plans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpsPlanArgs']]]]):
        pulumi.set(self, "plans", value)

    @_builtins.property
    @pulumi.getter(name="publicSshKey")
    def public_ssh_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Public SSH key to pre-install on your VPS - if set, then `image_id` must also be set
        """
        return pulumi.get(self, "public_ssh_key")

    @public_ssh_key.setter
    def public_ssh_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ssh_key", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal name of your VPS offer
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="slaMonitoring")
    def sla_monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "sla_monitoring")

    @sla_monitoring.setter
    def sla_monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sla_monitoring", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the VPS (backuping┃installing┃maintenance┃rebooting┃rescued┃running┃stopped┃stopping┃upgrading)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def vcore(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Number of vcores
        """
        return pulumi.get(self, "vcore")

    @vcore.setter
    def vcore(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "vcore", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OpenStask region where the VPS is located
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("ovh:Vps/vps:Vps")
class Vps(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keymap: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 model: Optional[pulumi.Input[Union['VpsModelArgs', 'VpsModelArgsDict']]] = None,
                 monitoring_ip_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netboot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 offer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpsPlanOptionArgs', 'VpsPlanOptionArgsDict']]]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpsPlanArgs', 'VpsPlanArgsDict']]]]] = None,
                 public_ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sla_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vcore: Optional[pulumi.Input[_builtins.float]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Custom display name
        :param pulumi.Input[_builtins.str] image_id: Id of the image to install on the VPS. This attribute is only useful to trigger a VPS reinstallation. The available values can be found using this [API call](https://eu.api.ovh.com/console/?section=%2Fvps&branch=v1#get-/vps/-serviceName-/images/available)
        :param pulumi.Input[_builtins.str] keymap: KVM keyboard layout on VPS Cloud
        :param pulumi.Input[_builtins.float] memory_limit: RAM of this VPS
        :param pulumi.Input[Union['VpsModelArgs', 'VpsModelArgsDict']] model: Structure describing characteristics of a VPS model
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] monitoring_ip_blocks: IP blocks for OVH monitoring servers
        :param pulumi.Input[_builtins.str] name: Name of the VPS
        :param pulumi.Input[_builtins.str] netboot_mode: VPS netboot mode (local┃rescue)
        :param pulumi.Input[_builtins.str] offer_type: All offers a VPS can have (beta-classic┃classic┃cloud┃cloudram┃game-classic┃lowlat┃ssd)
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json](https://eu.api.ovh.com/console-preview/?section=%2Fme&branch=v1#get-/me)
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpsPlanOptionArgs', 'VpsPlanOptionArgsDict']]]] plan_options: Product Plan to order
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpsPlanArgs', 'VpsPlanArgsDict']]]] plans: Product Plan to order
        :param pulumi.Input[_builtins.str] public_ssh_key: Public SSH key to pre-install on your VPS - if set, then `image_id` must also be set
        :param pulumi.Input[_builtins.str] state: State of the VPS (backuping┃installing┃maintenance┃rebooting┃rescued┃running┃stopped┃stopping┃upgrading)
        :param pulumi.Input[_builtins.float] vcore: Number of vcores
        :param pulumi.Input[_builtins.str] zone: OpenStask region where the VPS is located
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param VpsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keymap: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 model: Optional[pulumi.Input[Union['VpsModelArgs', 'VpsModelArgsDict']]] = None,
                 monitoring_ip_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netboot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 offer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpsPlanOptionArgs', 'VpsPlanOptionArgsDict']]]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpsPlanArgs', 'VpsPlanArgsDict']]]]] = None,
                 public_ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sla_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vcore: Optional[pulumi.Input[_builtins.float]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpsArgs.__new__(VpsArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["keymap"] = keymap
            __props__.__dict__["memory_limit"] = memory_limit
            __props__.__dict__["model"] = model
            __props__.__dict__["monitoring_ip_blocks"] = monitoring_ip_blocks
            __props__.__dict__["name"] = name
            __props__.__dict__["netboot_mode"] = netboot_mode
            __props__.__dict__["offer_type"] = offer_type
            __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
            __props__.__dict__["plan_options"] = plan_options
            __props__.__dict__["plans"] = plans
            __props__.__dict__["public_ssh_key"] = public_ssh_key
            __props__.__dict__["sla_monitoring"] = sla_monitoring
            __props__.__dict__["state"] = state
            __props__.__dict__["vcore"] = vcore
            __props__.__dict__["zone"] = zone
            __props__.__dict__["cluster"] = None
            __props__.__dict__["iam"] = None
            __props__.__dict__["order"] = None
            __props__.__dict__["service_name"] = None
        super(Vps, __self__).__init__(
            'ovh:Vps/vps:Vps',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            iam: Optional[pulumi.Input[Union['VpsIamArgs', 'VpsIamArgsDict']]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            keymap: Optional[pulumi.Input[_builtins.str]] = None,
            memory_limit: Optional[pulumi.Input[_builtins.float]] = None,
            model: Optional[pulumi.Input[Union['VpsModelArgs', 'VpsModelArgsDict']]] = None,
            monitoring_ip_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            netboot_mode: Optional[pulumi.Input[_builtins.str]] = None,
            offer_type: Optional[pulumi.Input[_builtins.str]] = None,
            order: Optional[pulumi.Input[Union['VpsOrderArgs', 'VpsOrderArgsDict']]] = None,
            ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
            plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpsPlanOptionArgs', 'VpsPlanOptionArgsDict']]]]] = None,
            plans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpsPlanArgs', 'VpsPlanArgsDict']]]]] = None,
            public_ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            sla_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            vcore: Optional[pulumi.Input[_builtins.float]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'Vps':
        """
        Get an existing Vps resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster: VPS cluster
        :param pulumi.Input[_builtins.str] display_name: Custom display name
        :param pulumi.Input[Union['VpsIamArgs', 'VpsIamArgsDict']] iam: IAM resource information
        :param pulumi.Input[_builtins.str] image_id: Id of the image to install on the VPS. This attribute is only useful to trigger a VPS reinstallation. The available values can be found using this [API call](https://eu.api.ovh.com/console/?section=%2Fvps&branch=v1#get-/vps/-serviceName-/images/available)
        :param pulumi.Input[_builtins.str] keymap: KVM keyboard layout on VPS Cloud
        :param pulumi.Input[_builtins.float] memory_limit: RAM of this VPS
        :param pulumi.Input[Union['VpsModelArgs', 'VpsModelArgsDict']] model: Structure describing characteristics of a VPS model
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] monitoring_ip_blocks: IP blocks for OVH monitoring servers
        :param pulumi.Input[_builtins.str] name: Name of the VPS
        :param pulumi.Input[_builtins.str] netboot_mode: VPS netboot mode (local┃rescue)
        :param pulumi.Input[_builtins.str] offer_type: All offers a VPS can have (beta-classic┃classic┃cloud┃cloudram┃game-classic┃lowlat┃ssd)
        :param pulumi.Input[Union['VpsOrderArgs', 'VpsOrderArgsDict']] order: Details about an Order
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json](https://eu.api.ovh.com/console-preview/?section=%2Fme&branch=v1#get-/me)
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpsPlanOptionArgs', 'VpsPlanOptionArgsDict']]]] plan_options: Product Plan to order
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpsPlanArgs', 'VpsPlanArgsDict']]]] plans: Product Plan to order
        :param pulumi.Input[_builtins.str] public_ssh_key: Public SSH key to pre-install on your VPS - if set, then `image_id` must also be set
        :param pulumi.Input[_builtins.str] service_name: The internal name of your VPS offer
        :param pulumi.Input[_builtins.str] state: State of the VPS (backuping┃installing┃maintenance┃rebooting┃rescued┃running┃stopped┃stopping┃upgrading)
        :param pulumi.Input[_builtins.float] vcore: Number of vcores
        :param pulumi.Input[_builtins.str] zone: OpenStask region where the VPS is located
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpsState.__new__(_VpsState)

        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["iam"] = iam
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["keymap"] = keymap
        __props__.__dict__["memory_limit"] = memory_limit
        __props__.__dict__["model"] = model
        __props__.__dict__["monitoring_ip_blocks"] = monitoring_ip_blocks
        __props__.__dict__["name"] = name
        __props__.__dict__["netboot_mode"] = netboot_mode
        __props__.__dict__["offer_type"] = offer_type
        __props__.__dict__["order"] = order
        __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
        __props__.__dict__["plan_options"] = plan_options
        __props__.__dict__["plans"] = plans
        __props__.__dict__["public_ssh_key"] = public_ssh_key
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["sla_monitoring"] = sla_monitoring
        __props__.__dict__["state"] = state
        __props__.__dict__["vcore"] = vcore
        __props__.__dict__["zone"] = zone
        return Vps(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[_builtins.str]:
        """
        VPS cluster
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Custom display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def iam(self) -> pulumi.Output['outputs.VpsIam']:
        """
        IAM resource information
        """
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Id of the image to install on the VPS. This attribute is only useful to trigger a VPS reinstallation. The available values can be found using this [API call](https://eu.api.ovh.com/console/?section=%2Fvps&branch=v1#get-/vps/-serviceName-/images/available)
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter
    def keymap(self) -> pulumi.Output[_builtins.str]:
        """
        KVM keyboard layout on VPS Cloud
        """
        return pulumi.get(self, "keymap")

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> pulumi.Output[_builtins.float]:
        """
        RAM of this VPS
        """
        return pulumi.get(self, "memory_limit")

    @_builtins.property
    @pulumi.getter
    def model(self) -> pulumi.Output['outputs.VpsModel']:
        """
        Structure describing characteristics of a VPS model
        """
        return pulumi.get(self, "model")

    @_builtins.property
    @pulumi.getter(name="monitoringIpBlocks")
    def monitoring_ip_blocks(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        IP blocks for OVH monitoring servers
        """
        return pulumi.get(self, "monitoring_ip_blocks")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the VPS
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="netbootMode")
    def netboot_mode(self) -> pulumi.Output[_builtins.str]:
        """
        VPS netboot mode (local┃rescue)
        """
        return pulumi.get(self, "netboot_mode")

    @_builtins.property
    @pulumi.getter(name="offerType")
    def offer_type(self) -> pulumi.Output[_builtins.str]:
        """
        All offers a VPS can have (beta-classic┃classic┃cloud┃cloudram┃game-classic┃lowlat┃ssd)
        """
        return pulumi.get(self, "offer_type")

    @_builtins.property
    @pulumi.getter
    def order(self) -> pulumi.Output['outputs.VpsOrder']:
        """
        Details about an Order
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json](https://eu.api.ovh.com/console-preview/?section=%2Fme&branch=v1#get-/me)
        """
        return pulumi.get(self, "ovh_subsidiary")

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> pulumi.Output[Optional[Sequence['outputs.VpsPlanOption']]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan_options")

    @_builtins.property
    @pulumi.getter
    def plans(self) -> pulumi.Output[Optional[Sequence['outputs.VpsPlan']]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plans")

    @_builtins.property
    @pulumi.getter(name="publicSshKey")
    def public_ssh_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Public SSH key to pre-install on your VPS - if set, then `image_id` must also be set
        """
        return pulumi.get(self, "public_ssh_key")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The internal name of your VPS offer
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="slaMonitoring")
    def sla_monitoring(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "sla_monitoring")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the VPS (backuping┃installing┃maintenance┃rebooting┃rescued┃running┃stopped┃stopping┃upgrading)
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def vcore(self) -> pulumi.Output[_builtins.float]:
        """
        Number of vcores
        """
        return pulumi.get(self, "vcore")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        OpenStask region where the VPS is located
        """
        return pulumi.get(self, "zone")

