% Script to make all C code for looped Horner eval of kernels of all widths.
% writes to "ker" array, from a variable "z", and switches by width "w".
% Now does both upsampfacs.
% Resulting C code needs only including in a function.

% Barnett 4/23/18; now calling Ludvig's loop version from 4/25/18.
% version including low upsampfac, 6/17/18.
% Ludvig put in w=4n padding, 1/31/20. Mystery about why d was bigger 2/6/20.
% split out code for degree, beta, etc; loop upsampfacs Barnett 7/22/24.
clear
opts = struct();

for upsampfac = [2.0, 1.25];   % sigma: either 2 (default) or low (eg 5/4)
  fprintf('upsampfac = %g...\n',upsampfac)

  ws = 2:16;
  opts.wpad = false;    % pad kernel eval to multiple of 4

  if upsampfac==2, fid = fopen('../include/cufinufft/contrib/ker_horner_allw_loop.inc','w');
  else, fid = fopen('../include/cufinufft/contrib/ker_lowupsampfac_horner_allw_loop.inc','w');
  end
  fwrite(fid,sprintf('// Code generated by gen_all_horner_C_code.m in finufft/devel\n'));
  fwrite(fid,sprintf('// Authors: Alex Barnett & Ludvig af Klinteberg.\n// (C) The Simons Foundation, Inc.\n'));
  for j=1:numel(ws)
    w = ws(j);
    [d,beta] = get_degree_and_beta(w,upsampfac);
    fprintf('w=%d\td=%d\tbeta=%.3g\n',w,d,beta);
    str = gen_ker_horner_loop_C_code(w,d,beta,opts);
    if j==1                                % write switch statement
      fwrite(fid,sprintf('  if constexpr (w==%d) {\n',w));
    else
      fwrite(fid,sprintf('  } else if constexpr (w==%d) {\n',w));
    end
    for i=1:numel(str); fwrite(fid,['    ',str{i}]); end
  end
  fwrite(fid,sprintf('  } else\n    printf("width not implemented!\\n");\n'));
  fclose(fid);

end
