// Code generated by gen_all_horner_C_code.m in finufft/devel
// Authors: Alex Barnett & Ludvig af Klinteberg.
// (C) The Simons Foundation, Inc.
  if constexpr (w==2) {
    constexpr FLT c0[] = {5.5428559551548373E-01, 5.5428559551548395E-01};
    constexpr FLT c1[] = {7.0481840008800722E-01, -7.0481840008800745E-01};
    constexpr FLT c2[] = {-2.2584311526143652E-02, -2.2584311526143739E-02};
    constexpr FLT c3[] = {-2.5024197515954211E-01, 2.5024197515954222E-01};
    for (int i=0; i<2; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i])));
  } else if constexpr (w==3) {
    constexpr FLT c0[] = {1.7787237246937559E-01, 1.0000000000000009E+00, 1.7787237247678447E-01};
    constexpr FLT c1[] = {3.5966530797580953E-01, -1.4849044935138803E-16, -3.5966530796781021E-01};
    constexpr FLT c2[] = {2.0160576446392528E-01, -3.7666666666667314E-01, 2.0160576447145470E-01};
    constexpr FLT c3[] = {-1.7450587318669390E-02, -5.9740104982804636E-17, 1.7450587325767725E-02};
    constexpr FLT c4[] = {-4.2902993854032997E-02, 6.0475925925925503E-02, -4.2902993846219602E-02};
    constexpr FLT c5[] = {-4.5057857403455262E-03, -9.2753005973835603E-17, 4.5057857475245449E-03};
    for (int i=0; i<3; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i])))));
  } else if constexpr (w==4) {
    constexpr FLT c0[] = {3.9828257752799370E-02, 7.3911656575585749E-01, 7.3911656575585760E-01, 3.9828257752799363E-02};
    constexpr FLT c1[] = {1.0749328817387323E-01, 4.5419700247912237E-01, -4.5419700247912254E-01, -1.0749328817387323E-01};
    constexpr FLT c2[] = {1.0408888748149286E-01, -1.0268333881994479E-01, -1.0268333881994483E-01, 1.0408888748149285E-01};
    constexpr FLT c3[] = {3.7516840869185775E-02, -1.0412335657155619E-01, 1.0412335657155625E-01, -3.7516840869185754E-02};
    constexpr FLT c4[] = {-3.5432868834529784E-03, 2.8903049344237144E-03, 2.8903049344236845E-03, -3.5432868834529762E-03};
    constexpr FLT c5[] = {-5.7512181801491037E-03, 1.0945950376831656E-02, -1.0945950376831742E-02, 5.7512181801491037E-03};
    constexpr FLT c6[] = {-7.3657365672907186E-04, 3.7144674885203870E-04, 3.7144674885190496E-04, -7.3657365672909203E-04};
    for (int i=0; i<4; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i]))))));
  } else if constexpr (w==5) {
    constexpr FLT c0[] = {1.0051451410391413E-02, 3.8286382489474285E-01, 1.0000000000000004E+00, 3.8286382489474230E-01, 1.0051451410391404E-02};
    constexpr FLT c1[] = {3.0826052021380428E-02, 3.8431958613457951E-01, -1.6970337068730065E-16, -3.8431958613457923E-01, -3.0826052021380418E-02};
    constexpr FLT c2[] = {3.6562231959204314E-02, 7.8509612097392836E-02, -2.3000000000000087E-01, 7.8509612097392947E-02, 3.6562231959204314E-02};
    constexpr FLT c3[] = {2.0250135419918273E-02, -3.9381037339048630E-02, 4.5265089812433205E-17, 3.9381037339048575E-02, -2.0250135419918266E-02};
    constexpr FLT c4[] = {4.0593041193018563E-03, -1.6067481167759606E-02, 2.4150000000000001E-02, -1.6067481167759586E-02, 4.0593041193018580E-03};
    constexpr FLT c5[] = {-9.2488937959281099E-04, 1.2476700479674141E-03, -1.1417887700143805E-16, -1.2476700479675457E-03, 9.2488937959281511E-04};
    constexpr FLT c6[] = {-5.6059657038176559E-04, 1.2116190166775015E-03, -1.5448333333333995E-03, 1.2116190166774968E-03, -5.6059657038176679E-04};
    constexpr FLT c7[] = {-3.4201716508558133E-05, 2.3137115416426317E-05, -1.6211468115972233E-17, -2.3137115416398588E-05, 3.4201716508565797E-05};
    for (int i=0; i<5; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i])))))));
  } else if constexpr (w==6) {
    constexpr FLT c0[] = {2.0875119883113444E-03, 1.5741818314646622E-01, 8.2446837122968719E-01, 8.2446837122968786E-01, 1.5741818314646619E-01, 2.0875119883208707E-03};
    constexpr FLT c1[] = {7.2383827471879060E-03, 2.0903648995439425E-01, 3.2052935784357611E-01, -3.2052935784357595E-01, -2.0903648995439431E-01, -7.2383827471776199E-03};
    constexpr FLT c2[] = {1.0180085126333447E-02, 9.2337811484268992E-02, -1.0253741712233815E-01, -1.0253741712233826E-01, 9.2337811484268992E-02, 1.0180085126343148E-02};
    constexpr FLT c3[] = {7.3669955501269495E-03, 4.9102900025223368E-03, -5.1302324979469585E-02, 5.1302324979469453E-02, -4.9102900025223412E-03, -7.3669955501178205E-03};
    constexpr FLT c4[] = {2.7444270008043898E-03, -8.0004810696545064E-03, 5.2920367975572286E-03, 5.2920367975572606E-03, -8.0004810696545012E-03, 2.7444270008144416E-03};
    constexpr FLT c5[] = {3.2622379114949579E-04, -1.8514138516535774E-03, 3.8520985619444484E-03, -3.8520985619445560E-03, 1.8514138516535451E-03, -3.2622379114026316E-04};
    constexpr FLT c6[] = {-1.2239646122606804E-04, 2.2750660293439196E-04, -1.2702072030321002E-04, -1.2702072030313421E-04, 2.2750660293438364E-04, -1.2239646121695212E-04};
    constexpr FLT c7[] = {-4.6695893922773253E-05, 1.1717219021522327E-04, -1.8098268625867290E-04, 1.8098268625856663E-04, -1.1717219021521502E-04, 4.6695893931712934E-05};
    constexpr FLT c8[] = {-1.5875418082722892E-06, 7.2147850129502829E-07, -7.0930078290747281E-08, -7.0930078325137639E-08, 7.2147850125572373E-07, -1.5875417996328233E-06};
    for (int i=0; i<6; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i]))))))));
  } else if constexpr (w==7) {
    constexpr FLT c0[] = {4.0677823488318089E-04, 5.5714997521829533E-02, 5.1113018541287780E-01, 9.9999999999999967E-01, 5.1113018541287847E-01, 5.5714997521829547E-02, 4.0677823488475867E-04};
    constexpr FLT c1[] = {1.5569364307494542E-03, 8.9228372765633918E-02, 3.5049603091348147E-01, -1.4849044935138815E-16, -3.5049603091348169E-01, -8.9228372765633959E-02, -1.5569364307477609E-03};
    constexpr FLT c2[] = {2.4904843753404821E-03, 5.4888936725282347E-02, 2.4759577399513327E-02, -1.6428571428571428E-01, 2.4759577399513240E-02, 5.4888936725282347E-02, 2.4904843753420971E-03};
    constexpr FLT c3[] = {2.1552691780265237E-03, 1.3627105791872417E-02, -3.3718114813591105E-02, 6.0458598471891237E-18, 3.3718114813591230E-02, -1.3627105791872405E-02, -2.1552691780250205E-03};
    constexpr FLT c4[] = {1.0735311014902866E-03, -7.2030895675484409E-04, -6.6760503000564131E-03, 1.2656705539358644E-02, -6.6760503000563957E-03, -7.2030895675484919E-04, 1.0735311014919515E-03};
    constexpr FLT c5[] = {2.8413019973530577E-04, -1.1175797418592726E-03, 1.3906361031250946E-03, -1.1555014499291590E-16, -1.3906361031251887E-03, 1.1175797418592557E-03, -2.8413019973377786E-04};
    constexpr FLT c6[] = {1.6363160465887915E-05, -1.5802085209243292E-04, 4.4431051893376538E-04, -6.0985626028865671E-04, 4.4431051893374798E-04, -1.5802085209243606E-04, 1.6363160467395125E-05};
    constexpr FLT c7[] = {-1.2513684117291576E-05, 2.9105578584782810E-05, -2.8835295309289061E-05, 4.4580005943244268E-18, 2.8835295309367696E-05, -2.9105578584777121E-05, 1.2513684118771265E-05};
    constexpr FLT c8[] = {-3.2859430043343644E-06, 9.3570096164309209E-06, -1.7015821249889751E-05, 2.0688046128666583E-05, -1.7015821249932014E-05, 9.3570096164071294E-06, -3.2859430029065286E-06};
    constexpr FLT c9[] = {-1.5030958478324257E-08, -9.3540219420629153E-08, 1.3079704870578265E-07, -9.4759238230668171E-18, -1.3079704867810334E-07, 9.3540219423397084E-08, 1.5030959705595645E-08};
    for (int i=0; i<7; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i])))))))));
  } else if constexpr (w==8) {
    constexpr FLT c0[] = {7.5442178667263981E-05, 1.7659090182402842E-02, 2.6112828482312633E-01, 8.6561421087578250E-01, 8.6561421087578250E-01, 2.6112828482312633E-01, 1.7659090182402845E-02, 7.5442178667263791E-05};
    constexpr FLT c1[] = {3.1361556564941506E-04, 3.2518751351035623E-02, 2.4295266212395927E-01, 2.5083142126627173E-01, -2.5083142126627195E-01, -2.4295266212395936E-01, -3.2518751351035616E-02, -3.1361556564941478E-04};
    constexpr FLT c2[] = {5.5627094085228138E-04, 2.4604803324737464E-02, 6.5902977410162808E-02, -9.1064379250067620E-02, -9.1064379250067551E-02, 6.5902977410162836E-02, 2.4604803324737454E-02, 5.5627094085228138E-04};
    constexpr FLT c3[] = {5.5053208919074751E-04, 9.2359485489686994E-03, -6.2169545154250015E-03, -3.1386277864020519E-02, 3.1386277864020574E-02, 6.2169545154250197E-03, -9.2359485489686959E-03, -5.5053208919074741E-04};
    constexpr FLT c4[] = {3.3122072653963842E-04, 1.3353118718124391E-03, -5.9878504390517145E-03, 4.3217905833727848E-03, 4.3217905833727709E-03, -5.9878504390517232E-03, 1.3353118718124370E-03, 3.3122072653963820E-04};
    constexpr FLT c5[] = {1.2112223749399384E-04, -2.3174709024354235E-04, -5.1773322458170408E-04, 1.8691284471381068E-03, -1.8691284471383178E-03, 5.1773322458165399E-04, 2.3174709024354165E-04, -1.2112223749399399E-04};
    constexpr FLT c6[] = {2.3288943339077732E-05, -1.1810885265513068E-04, 2.1380000655375780E-04, -1.1905274322674535E-04, -1.1905274322671518E-04, 2.1380000655376477E-04, -1.1810885265513266E-04, 2.3288943339077745E-05};
    constexpr FLT c7[] = {8.7290223704851186E-08, -9.9551635569409828E-06, 3.9042123573726220E-05, -7.0647330846703837E-05, 7.0647330846726171E-05, -3.9042123573714680E-05, 9.9551635569465072E-06, -8.7290223704776620E-08};
    constexpr FLT c8[] = {-1.0444417486659137E-06, 2.8837147790388339E-06, -3.9445588398419149E-06, 1.9505656879770040E-06, 1.9505656878898172E-06, -3.9445588398656149E-06, 2.8837147790302746E-06, -1.0444417486661539E-06};
    constexpr FLT c9[] = {-1.9601350641696516E-07, 6.2981383505557520E-07, -1.3252363385038412E-06, 1.9071649677086494E-06, -1.9071649677307929E-06, 1.3252363384816978E-06, -6.2981383505661323E-07, 1.9601350641687865E-07};
    for (int i=0; i<8; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i])))))))));
  } else if constexpr (w==9) {
    constexpr FLT c0[] = {1.3445576990655699E-05, 5.1377966678943518E-03, 1.1569392196071665E-01, 5.9595989228910662E-01, 1.0000000000000004E+00, 5.9595989228910773E-01, 1.1569392196071666E-01, 5.1377966678943813E-03, 1.3445576990655628E-05};
    constexpr FLT c1[] = {6.0003223623206576E-05, 1.0569385595664981E-02, 1.3202059711663514E-01, 3.1241329121161548E-01, -8.4851685343650311E-17, -3.1241329121161582E-01, -1.3202059711663514E-01, -1.0569385595665021E-02, -6.0003223623206590E-05};
    constexpr FLT c2[] = {1.1601811379064814E-04, 9.2861699099147117E-03, 5.4760895870332289E-02, -2.7420112488906883E-04, -1.2777777777777805E-01, -2.7420112488927613E-04, 5.4760895870332275E-02, 9.2861699099147394E-03, 1.1601811379064824E-04};
    constexpr FLT c3[] = {1.2783089927061688E-04, 4.4048543606096807E-03, 6.4505427512762531E-03, -2.6627297241817630E-02, -3.2098550589665862E-17, 2.6627297241817914E-02, -6.4505427512762349E-03, -4.4048543606096903E-03, -1.2783089927061688E-04};
    constexpr FLT c4[] = {8.8459828362140113E-05, 1.1147546008569548E-03, -2.1200589329645964E-03, -2.9677441441082913E-03, 7.7692043895745072E-03, -2.9677441441080905E-03, -2.1200589329645829E-03, 1.1147546008569568E-03, 8.8459828362140100E-05};
    constexpr FLT c5[] = {3.9567294647305411E-05, 8.1817980646544931E-05, -7.2116754318333879E-04, 1.0390038161995874E-03, -1.0283042279864902E-16, -1.0390038161999537E-03, 7.2116754318329336E-04, -8.1817980646548062E-05, -3.9567294647305451E-05};
    constexpr FLT c6[] = {1.1032857092605819E-05, -3.4254477931957174E-05, -1.3557143976059904E-05, 1.8667778536558257E-04, -2.9974999576623664E-04, 1.8667778536542303E-04, -1.3557143976058785E-05, -3.4254477931959797E-05, 1.1032857092605870E-05};
    constexpr FLT c7[] = {1.5345430093718074E-06, -9.9308189188252872E-06, 2.3762810604656844E-05, -2.4017602201909826E-05, -5.2670367292513955E-17, 2.4017602202069285E-05, -2.3762810604655319E-05, 9.9308189188297425E-06, -1.5345430093717854E-06};
    constexpr FLT c8[] = {-8.1737159283252536E-08, -4.1540916378119670E-07, 2.6668107554329568E-06, -6.3261434127473353E-06, 8.2578681448991719E-06, -6.3261434126871112E-06, 2.6668107554144911E-06, -4.1540916378835333E-07, -8.1737159283297297E-08};
    constexpr FLT c9[] = {-7.3256982980638094E-08, 2.3321978963637828E-07, -4.0030411107409711E-07, 3.4388260963072595E-07, -5.0485268896210294E-17, -3.4388260995180581E-07, 4.0030411105610554E-07, -2.3321978963516732E-07, 7.3256982980616468E-08};
    constexpr FLT c10[] = {-1.0121400696640600E-08, 3.6191328860529519E-08, -8.7258577122732534E-08, 1.4622014475704781E-07, -1.7333902188617528E-07, 1.4622014472849038E-07, -8.7258577131531566E-08, 3.6191328857229922E-08, -1.0121400696612377E-08};
    for (int i=0; i<9; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i]))))))))));
  } else if constexpr (w==10) {
    constexpr FLT c0[] = {2.3186292807626317E-06, 1.3952040327729876E-03, 4.5894237568906815E-02, 3.4666431215091620E-01, 8.9110862394331991E-01, 8.9110862394331991E-01, 3.4666431215091603E-01, 4.5894237568906829E-02, 1.3952040327729781E-03, 2.3186292807626118E-06};
    constexpr FLT c1[] = {1.1010978063160384E-05, 3.1454190365985996E-03, 6.0943215953720244E-02, 2.5074802988370293E-01, 2.0598750885032677E-01, -2.0598750885032696E-01, -2.5074802988370298E-01, -6.0943215953720258E-02, -3.1454190365985870E-03, -1.1010978063160370E-05};
    constexpr FLT c2[] = {2.2925449299630712E-05, 3.1050615653861963E-03, 3.2337657329423480E-02, 4.4760550762170462E-02, -8.0226193254406539E-02, -8.0226193254406331E-02, 4.4760550762170441E-02, 3.2337657329423480E-02, 3.1050615653861863E-03, 2.2925449299630688E-05};
    constexpr FLT c3[] = {2.7622345748507543E-05, 1.7317590416004976E-03, 7.6620063086756561E-03, -9.8393115612840799E-03, -2.1163068654269191E-02, 2.1163068654269430E-02, 9.8393115612840625E-03, -7.6620063086756578E-03, -1.7317590416004915E-03, -2.7622345748507465E-05};
    constexpr FLT c4[] = {2.1363614860997120E-05, 5.7553475552091660E-04, 1.4813144535930209E-04, -4.1113061120762115E-03, 3.3662735809589788E-03, 3.3662735809589744E-03, -4.1113061120763477E-03, 1.4813144535929786E-04, 5.7553475552091303E-04, 2.1363614860997073E-05};
    constexpr FLT c5[] = {1.1063475580065288E-05, 1.0180053030149580E-04, -3.4137441280839747E-04, -4.9828659222695235E-05, 1.0442648308815685E-03, -1.0442648308818987E-03, 4.9828659222757584E-05, 3.4137441280838202E-04, -1.0180053030149428E-04, -1.1063475580065274E-05};
    constexpr FLT c6[] = {3.8359011440648767E-06, 1.3049698816909941E-06, -6.3791463619226925E-05, 1.4528730872072232E-04, -8.6630472952467041E-05, -8.6630472952443704E-05, 1.4528730872072487E-04, -6.3791463619226898E-05, 1.3049698816893206E-06, 3.8359011440648818E-06};
    constexpr FLT c7[] = {8.3366418668164029E-07, -3.5785601754608600E-06, 2.4539930904838721E-06, 1.2754336575774621E-05, -3.3000414536145769E-05, 3.3000414536255456E-05, -1.2754336575763307E-05, -2.4539930904908122E-06, 3.5785601754624753E-06, -8.3366418668162441E-07};
    constexpr FLT c8[] = {8.0572098823818831E-08, -6.8352224328304655E-07, 2.0695541423448143E-06, -2.9709579576719820E-06, 1.5005770225068746E-06, 1.5005770225918255E-06, -2.9709579578749849E-06, 2.0695541423337669E-06, -6.8352224328480012E-07, 8.0572098823799839E-08};
    constexpr FLT c9[] = {-1.0412910456853713E-08, -3.6228831479630466E-09, 1.3932530224464304E-07, -4.5071262431676362E-07, 7.5149884418071783E-07, -7.5149884434956146E-07, 4.5071262441364116E-07, -1.3932530225433080E-07, 3.6228831480495445E-09, 1.0412910456864524E-08};
    constexpr FLT c10[] = {-4.4291858217039330E-09, 1.5904364892603811E-08, -3.2603275117030568E-08, 3.8190045595613436E-08, -1.7631718285886992E-08, -1.7631718414100877E-08, 3.8190045567330887E-08, -3.2603275115773551E-08, 1.5904364892603811E-08, -4.4291858217086909E-09};
    constexpr FLT c11[] = {-4.4040059170691262E-10, 1.7857872831924088E-09, -4.9203237607399544E-09, 9.5125262237319707E-09, -1.3157194794825051E-08, 1.3157194847067723E-08, -9.5125262416193676E-09, 4.9203237493828085E-09, -1.7857872837247548E-09, 4.4040059171467111E-10};
    for (int i=0; i<10; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i])))))))))));
  } else if constexpr (w==11) {
    constexpr FLT c0[] = {3.8884809238313450E-07, 3.5785567372179962E-04, 1.6654951019551327E-02, 1.7692785324424565E-01, 6.5593328211813118E-01, 9.9999999999999967E-01, 6.5593328211813084E-01, 1.7692785324424556E-01, 1.6654951019551324E-02, 3.5785567372179918E-04, 3.8884809238312270E-07};
    constexpr FLT c1[] = {1.9516358260453343E-06, 8.7214421096705550E-04, 2.4929466432368069E-02, 1.5885079249667169E-01, 2.7894884556454913E-01, -8.4851685343650385E-17, -2.7894884556454930E-01, -1.5885079249667178E-01, -2.4929466432368076E-02, -8.7214421096705539E-04, -1.9516358260453157E-06};
    constexpr FLT c2[] = {4.3353827605930486E-06, 9.4705645354715496E-04, 1.5700144896729010E-02, 4.8428271550326765E-02, -1.2807080799297233E-02, -1.0454545454545465E-01, -1.2807080799297139E-02, 4.8428271550326821E-02, 1.5700144896729003E-02, 9.4705645354715550E-04, 4.3353827605930232E-06};
    constexpr FLT c3[] = {5.6395387871289838E-06, 5.9760549110825483E-04, 5.0911332059142269E-03, 1.6690038662948178E-03, -2.1030028251698023E-02, 4.0648251383670637E-17, 2.1030028251698085E-02, -1.6690038662948057E-03, -5.0911332059142252E-03, -5.9760549110825462E-04, -5.6395387871289525E-06};
    constexpr FLT c4[] = {4.7836299264887174E-06, 2.3732554180006424E-04, 7.1846854433598318E-04, -2.2660086673713543E-03, -1.3190061226035939E-03, 5.2488730277987635E-03, -1.3190061226035364E-03, -2.2660086673713794E-03, 7.1846854433598557E-04, 2.3732554180006394E-04, 4.7836299264886929E-06};
    constexpr FLT c5[] = {2.7801202330030043E-06, 5.8401836435975921E-05, -5.7255962675864676E-05, -4.1058481683298675E-04, 7.4543249761816952E-04, -1.1824261682570684E-17, -7.4543249761830374E-04, 4.1058481683291709E-04, 5.7255962675855183E-05, -5.8401836435976171E-05, -2.7801202330029916E-06};
    constexpr FLT c6[] = {1.1248609988572028E-06, 7.1593996360417151E-06, -3.7923443960744513E-05, 2.8219312687366578E-05, 8.5797383067800522E-05, -1.6875309167112642E-04, 8.5797383067676258E-05, 2.8219312687366561E-05, -3.7923443960745272E-05, 7.1593996360417574E-06, 1.1248609988571984E-06};
    constexpr FLT c7[] = {3.1074712008817415E-07, -3.7942806006667198E-07, -4.2327710785702258E-06, 1.4518421536658761E-05, -1.6373413879628303E-05, -3.1234901536718130E-17, 1.6373413879560473E-05, -1.4518421536624180E-05, 4.2327710785729931E-06, 3.7942806006691651E-07, -3.1074712008817188E-07};
    constexpr FLT c8[] = {5.3160526822192677E-08, -2.9438470061316177E-07, 4.4816653818369536E-07, 4.9835853876343515E-07, -2.6602444110742270E-06, 3.9090815374501741E-06, -2.6602444111213995E-06, 4.9835853870698559E-07, 4.4816653817806582E-07, -2.9438470061343044E-07, 5.3160526822190930E-08};
    constexpr FLT c9[] = {3.1778958300839193E-09, -3.9044067083716177E-08, 1.4726158787950358E-07, -2.7451209289276638E-07, 2.4544112216615996E-07, 8.3873022606577459E-18, -2.4544112211633722E-07, 2.7451209284571158E-07, -1.4726158788400146E-07, 3.9044067083597242E-08, -3.1778958300827369E-09};
    constexpr FLT c10[] = {-8.6163117991801527E-10, 1.2292710052700590E-09, 4.9928263017863946E-09, -2.5746199379526484E-08, 5.5054682142514025E-08, -6.9606951492905721E-08, 5.5054682071650699E-08, -2.5746199414722506E-08, 4.9928263008436627E-09, 1.2292710051718510E-09, -8.6163117991870545E-10};
    constexpr FLT c11[] = {-2.3293080872740411E-10, 9.3461130398706385E-10, -2.2220140843091046E-09, 3.2420144489205448E-09, -2.5573586346170970E-09, -3.1552257230018361E-17, 2.5573585789673351E-09, -3.2420144222313730E-09, 2.2220140838832191E-09, -9.3461130385397131E-10, 2.3293080872969065E-10};
    constexpr FLT c12[] = {-1.6776727230706402E-11, 7.5440974197914497E-11, -2.3911386243337562E-10, 5.3207181502105922E-10, -8.5057637343194789E-10, 9.9272871182573856E-10, -8.5057647960094213E-10, 5.3207179358287845E-10, -2.3911386766517342E-10, 7.5440974038380308E-11, -1.6776727232199783E-11};
    for (int i=0; i<11; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i]))))))))))));
  } else if constexpr (w==12) {
    constexpr FLT c0[] = {6.3667715563015875E-08, 8.7461142088576875E-05, 5.6146669497086563E-03, 8.1271316412301356E-02, 4.1627261402765720E-01, 9.0846375182673667E-01, 9.0846375182673689E-01, 4.1627261402765714E-01, 8.1271316412301522E-02, 5.6146669497086675E-03, 8.7461142088576766E-05, 6.3667715563034443E-08};
    constexpr FLT c1[] = {3.3587389488258561E-07, 2.2809471090022882E-04, 9.2744480587561903E-03, 8.5676487647659963E-02, 2.4720659158040598E-01, 1.7472997738461984E-01, -1.7472997738461982E-01, -2.4720659158040606E-01, -8.5676487647660074E-02, -9.2744480587562093E-03, -2.2809471090022882E-04, -3.3587389488256608E-07};
    constexpr FLT c2[] = {7.9035220764954472E-07, 2.6846594761214729E-04, 6.6557324960729129E-03, 3.4792641812076697E-02, 2.9454899103693716E-02, -7.1172529707069263E-02, -7.1172529707069318E-02, 2.9454899103693668E-02, 3.4792641812076690E-02, 6.6557324960729259E-03, 2.6846594761214735E-04, 7.9035220764956928E-07};
    constexpr FLT c3[] = {1.0993606197695963E-06, 1.8716155179384050E-04, 2.6329045000561373E-03, 5.3754303637599983E-03, -1.0591878410592564E-02, -1.5228395084945693E-02, 1.5228395084945721E-02, 1.0591878410592634E-02, -5.3754303637599515E-03, -2.6329045000561373E-03, -1.8716155179384044E-04, -1.0993606197695834E-06};
    constexpr FLT c4[] = {1.0091198513153346E-06, 8.4812954286468423E-05, 5.7431140218944417E-04, -5.0274672420765716E-04, -2.8008958990918590E-03, 2.6435090762444630E-03, 2.6435090762444709E-03, -2.8008958990918750E-03, -5.0274672420768665E-04, 5.7431140218944243E-04, 8.4812954286468410E-05, 1.0091198513153596E-06};
    constexpr FLT c5[] = {6.4507244019416542E-07, 2.5481132674301171E-05, 4.2795619387508642E-05, -3.0197159708156746E-04, 1.1080610219034021E-04, 6.4144454802687542E-04, -6.4144454802693245E-04, -1.1080610219044532E-04, 3.0197159708159055E-04, -4.2795619387510356E-05, -2.5481132674301232E-05, -6.4507244019414964E-07};
    constexpr FLT c6[] = {2.9426545129495870E-07, 4.7724106401924017E-06, -1.1001642128368620E-05, -2.6869692251298703E-05, 9.4483235217664095E-05, -6.1678458203335938E-05, -6.1678458203393943E-05, 9.4483235217639687E-05, -2.6869692251325618E-05, -1.1001642128368075E-05, 4.7724106401924466E-06, 2.9426545129497887E-07};
    constexpr FLT c7[] = {9.5799843879057143E-08, 3.7784160107128570E-07, -3.2256313018464523E-06, 5.0144058082807615E-06, 3.4886031174315520E-06, -1.7411974954248305E-05, 1.7411974954164805E-05, -3.4886031173927896E-06, -5.0144058082569217E-06, 3.2256313018479033E-06, -3.7784160107127585E-07, -9.5799843879039315E-08};
    constexpr FLT c8[] = {2.1473864761677977E-08, -5.7414008446866310E-08, -2.0134799316349550E-07, 1.1145247706237484E-06, -1.8840465965944781E-06, 1.0067804561525776E-06, 1.0067804560939612E-06, -1.8840465966553108E-06, 1.1145247706046697E-06, -2.0134799316649463E-07, -5.7414008446904168E-08, 2.1473864761695606E-08};
    constexpr FLT c9[] = {2.8867786924317360E-09, -2.0015791402122435E-08, 4.5306507658961618E-08, -7.8859059649942724E-09, -1.5755151476976810E-07, 3.4270221890477367E-07, -3.4270221894629257E-07, 1.5755151475039259E-07, 7.8859059622263425E-09, -4.5306507657577652E-08, 2.0015791402096756E-08, -2.8867786924175027E-09};
    constexpr FLT c10[] = {6.9986758891768954E-11, -1.8486004429312075E-09, 8.7658205616141919E-09, -2.0364661377054439E-08, 2.5396405363839655E-08, -1.2044441255258105E-08, -1.2044441287940056E-08, 2.5396405319216143E-08, -2.0364661357570944E-08, 8.7658205583145718E-09, -1.8486004429312099E-09, 6.9986758906969690E-11};
    constexpr FLT c11[] = {-5.6296594747769723E-11, 1.4066781270841427E-10, 4.6947621930829374E-11, -1.1526063712774952E-09, 3.3027593717047561E-09, -5.2174001478471531E-09, 5.2174000780009304E-09, -3.3027593677297393E-09, 1.1526063475695102E-09, -4.6947618807614674E-11, -1.4066781270398007E-10, 5.6296594761321533E-11};
    constexpr FLT c12[] = {-1.0870401167973640E-11, 4.8044744348002116E-11, -1.3004175664400734E-10, 2.2570502777621933E-10, -2.4006681200298005E-10, 1.0598000539497877E-10, 1.0597996456091133E-10, -2.4006685896251565E-10, 2.2570503237007147E-10, -1.3004176149304966E-10, 4.8044744298142519E-11, -1.0870401156024175E-11};
    constexpr FLT c13[] = {-4.7539080513361941E-13, 2.6787995685622948E-12, -1.0000146360885640E-11, 2.5777397611211484E-11, -4.7463678850231190E-11, 6.4012226087607112E-11, -6.4012244598782536E-11, 4.7463686292174809E-11, -2.5777393714330728E-11, 1.0000149173124785E-11, -2.6787995668897570E-12, 4.7539081135519811E-13};
    for (int i=0; i<12; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i] + z*(c13[i])))))))))))));
  } else if constexpr (w==13) {
    constexpr FLT c0[] = {1.0208956054983739E-08, 2.0506572462261991E-05, 1.7784497194617899E-03, 3.4214490279692991E-02, 2.3443634373410030E-01, 7.0049708882252748E-01, 9.9999999999999911E-01, 7.0049708882252648E-01, 2.3443634373410030E-01, 3.4214490279692901E-02, 1.7784497194617893E-03, 2.0506572462261737E-05, 1.0208956054983552E-08};
    constexpr FLT c1[] = {5.6353468219321909E-08, 5.6780128053894652E-05, 3.1934841481628300E-03, 4.0941461360716865E-02, 1.7436810648693329E-01, 2.5085467225681662E-01, -1.9091629202321336E-16, -2.5085467225681657E-01, -1.7436810648693327E-01, -4.0941461360716788E-02, -3.1934841481628291E-03, -5.6780128053894164E-05, -5.6353468219321955E-08};
    constexpr FLT c2[] = {1.3966266158866417E-07, 7.1655019336418701E-05, 2.5459504018621160E-03, 2.0160236969440630E-02, 4.0770064165298388E-02, -1.9317276988534474E-02, -8.8461538461538772E-02, -1.9317276988534395E-02, 4.0770064165298388E-02, 2.0160236969440602E-02, 2.5459504018621160E-03, 7.1655019336418227E-05, 1.3966266158866427E-07};
    constexpr FLT c3[] = {2.0618605552701914E-07, 5.4306747658367697E-05, 1.1637911071900929E-03, 4.7784706844645362E-03, -1.2004184173789185E-03, -1.6862510515566094E-02, 7.6857235047377246E-17, 1.6862510515566118E-02, 1.2004184173788478E-03, -4.7784706844645414E-03, -1.1637911071900923E-03, -5.4306747658367358E-05, -2.0618605552701911E-07};
    constexpr FLT c4[] = {2.0277547837406105E-07, 2.7328509487415500E-05, 3.2236608098850278E-04, 3.0859705461355795E-04, -2.0254394973525615E-03, -5.2398574644568101E-04, 3.7818616294948075E-03, -5.2398574644549009E-04, -2.0254394973524856E-03, 3.0859705461356413E-04, 3.2236608098850262E-04, 2.7328509487415354E-05, 2.0277547837406105E-07};
    constexpr FLT c5[] = {1.4058372037094495E-07, 9.4685595066535949E-06, 4.8682874512157492E-05, -1.1575111217136869E-04, -2.1811605515770685E-04, 5.4056763477026894E-04, -1.3413321890920493E-16, -5.4056763477036002E-04, 2.1811605515769839E-04, 1.1575111217134967E-04, -4.8682874512158421E-05, -9.4685595066535746E-06, -1.4058372037094500E-07};
    constexpr FLT c6[] = {7.0755520230584346E-08, 2.2298625886400052E-06, 7.8375383351888153E-07, -2.8394470622678048E-05, 3.5771256766222007E-05, 4.1631950912162111E-05, -1.0418619302475171E-04, 4.1631950912266106E-05, 3.5771256766155742E-05, -2.8394470622679332E-05, 7.8375383351906321E-07, 2.2298625886400366E-06, 7.0755520230584399E-08};
    constexpr FLT c7[] = {2.6111186487625288E-08, 3.2044561720738900E-07, -1.2220373462315751E-06, -8.5793794341938345E-07, 8.3299507234159490E-06, -1.0956754351193869E-05, -4.2133273481770268E-18, 1.0956754351102354E-05, -8.3299507234444127E-06, 8.5793794341977245E-07, 1.2220373462317335E-06, -3.2044561720742071E-07, -2.6111186487625245E-08};
    constexpr FLT c8[] = {6.9838095920570697E-09, 1.2796250155229052E-08, -2.1971713837869602E-07, 5.2791981730556338E-07, -1.4622692106232861E-07, -1.2222183756484325E-06, 2.0809248311023210E-06, -1.2222183757873931E-06, -1.4622692102353826E-07, 5.2791981729316091E-07, -2.1971713837932606E-07, 1.2796250155256654E-08, 6.9838095920570556E-09};
    constexpr FLT c9[] = {1.2845897306280754E-09, -5.2304801922932016E-09, -5.0548716988230519E-09, 6.7539942919701739E-08, -1.6027276236470508E-07, 1.5655092162587644E-07, -2.2699174111659530E-17, -1.5655092177811256E-07, 1.6027276234809751E-07, -6.7539942915549835E-08, 5.0548716980878199E-09, 5.2304801922361841E-09, -1.2845897306281492E-09};
    constexpr FLT c10[] = {1.3345700642130691E-10, -1.1551704392484999E-09, 3.4412362338210342E-09, -3.2850871134619081E-09, -6.1855159001258178E-09, 2.3119925528230141E-08, -3.2145944300982594E-08, 2.3119925902816086E-08, -6.1855159856018208E-09, -3.2850871404873946E-09, 3.4412362337817518E-09, -1.1551704392006267E-09, 1.3345700642135499E-10};
    constexpr FLT c11[] = {-1.9694481417431522E-12, -7.0630732014279091E-11, 4.4161967795289093E-10, -1.2581280884757657E-09, 2.0087583501084213E-09, -1.6557203641746698E-09, -1.8616541410779625E-17, 1.6557200876291340E-09, -2.0087583293639620E-09, 1.2581281110480127E-09, -4.4161967829005099E-10, 7.0630731978786787E-11, 1.9694481417649691E-12};
    constexpr FLT c12[] = {-3.1122514900790565E-12, 1.0235548901329534E-11, -1.0076717372694741E-11, -3.6278868512857559E-11, 1.6235814346711627E-10, -3.2356761019059813E-10, 4.0014579978425756E-10, -3.2356781027851721E-10, 1.6235814857129835E-10, -3.6278894672280772E-11, -1.0076717867175658E-11, 1.0235548921264714E-11, -3.1122514901015834E-12};
    constexpr FLT c13[] = {-4.4521627553552838E-13, 2.1830423143884514E-12, -6.6494703003945180E-12, 1.3364546946965736E-11, -1.7572531722265358E-11, 1.3087516537835037E-11, -7.1887842145401140E-18, -1.3087607686672063E-11, 1.7572520191874396E-11, -1.3364550808652903E-11, 6.6494701329325954E-12, -2.1830423491074722E-12, 4.4521627550943629E-13};
    constexpr FLT c14[] = {-1.1331825591755105E-14, 7.5442529734273508E-14, -3.5473139032624521E-13, 1.0827877935901268E-12, -2.3054249530059664E-12, 3.5752188140828952E-12, -4.1288740135932172E-12, 3.5754451352466983E-12, -2.3054565626769554E-12, 1.0827765983400355E-12, -3.5473149190201202E-13, 7.5442562556957494E-14, -1.1331825576920660E-14};
    for (int i=0; i<13; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i] + z*(c13[i] + z*(c14[i]))))))))))))));
  } else if constexpr (w==14) {
    constexpr FLT c0[] = {1.6070755785071679E-09, 4.6371263117318300E-06, 5.3392892770691446E-04, 1.3380163586766324E-02, 1.1960061568997654E-01, 4.7332499268789291E-01, 9.2104360429933807E-01, 9.2104360429933807E-01, 4.7332499268789280E-01, 1.1960061568997681E-01, 1.3380163586766324E-02, 5.3392892770691772E-04, 4.6371263117318300E-06, 1.6070755785075471E-09};
    constexpr FLT c1[] = {9.2475302076758724E-09, 1.3546865389183950E-05, 1.0306349751547574E-03, 1.7767594411827743E-02, 1.0518000824290007E-01, 2.3882936521395379E-01, 1.5170179567585820E-01, -1.5170179567585820E-01, -2.3882936521395384E-01, -1.0518000824290029E-01, -1.7767594411827743E-02, -1.0306349751547609E-03, -1.3546865389183968E-05, -9.2475302076757831E-09};
    constexpr FLT c2[] = {2.4024402573674970E-08, 1.8178651135370006E-05, 8.9712289901830574E-04, 1.0104692380253475E-02, 3.4193348251104448E-02, 1.8533380680638787E-02, -6.3746746886473971E-02, -6.3746746886473984E-02, 1.8533380680638711E-02, 3.4193348251104379E-02, 1.0104692380253475E-02, 8.9712289901830921E-04, 1.8178651135370046E-05, 2.4024402573675774E-08};
    constexpr FLT c3[] = {3.7419288907183508E-08, 1.4804264337309617E-05, 4.5929141335173139E-04, 3.0552592910038151E-03, 3.3079403387824180E-03, -1.0247716289024938E-02, -1.1480323948535189E-02, 1.1480323948535308E-02, 1.0247716289024964E-02, -3.3079403387824401E-03, -3.0552592910038159E-03, -4.5929141335173350E-04, -1.4804264337309641E-05, -3.7419288907183740E-08};
    constexpr FLT c4[] = {3.9124194363163294E-08, 8.1265227753122970E-06, 1.4975407030324897E-04, 4.4789439277602596E-04, -7.9407521150522923E-04, -1.9254008995687538E-03, 2.1136619999319122E-03, 2.1136619999319001E-03, -1.9254008995687199E-03, -7.9407521150516136E-04, 4.4789439277602650E-04, 1.4975407030324992E-04, 8.1265227753123038E-06, 3.9124194363164128E-08};
    constexpr FLT c5[] = {2.9113992252245372E-08, 3.1458937074171777E-06, 3.0585266291431484E-05, -6.5135387342584785E-06, -2.3196510408360701E-04, 1.5778347828054417E-04, 4.2181913759730018E-04, -4.2181913759742806E-04, -1.5778347828063221E-04, 2.3196510408354706E-04, 6.5135387342537318E-06, -3.0585266291431918E-05, -3.1458937074171849E-06, -2.9113992252245408E-08};
    constexpr FLT c6[] = {1.5927753226313462E-08, 8.6591441391883373E-07, 3.1186030532596436E-06, -1.4256326863802855E-05, -6.9192418278230890E-06, 6.1786486497546967E-05, -4.4611361914771356E-05, -4.4611361914751718E-05, 6.1786486497529485E-05, -6.9192418278288107E-06, -1.4256326863804007E-05, 3.1186030532597304E-06, 8.6591441391883235E-07, 1.5927753226313955E-08};
    constexpr FLT c7[] = {6.5072355972925020E-09, 1.6321871905299905E-07, -1.6208737249913681E-07, -2.0005919851675999E-06, 4.6289117401734085E-06, 1.5738407906137680E-07, -1.0033756087411173E-05, 1.0033756087382978E-05, -1.5738407906832162E-07, -4.6289117402499938E-06, 2.0005919851674550E-06, 1.6208737249922011E-07, -1.6321871905298894E-07, -6.5072355972922629E-09};
    constexpr FLT c8[] = {1.9857214221989477E-09, 1.7788899565186164E-08, -1.0133541198303713E-07, 4.4566342397467425E-08, 5.3564828267041993E-07, -1.1695093255347421E-06, 6.7085595108654188E-07, 6.7085595111459169E-07, -1.1695093255478542E-06, 5.3564828275006633E-07, 4.4566342393758532E-08, -1.0133541198341660E-07, 1.7788899565174329E-08, 1.9857214221992526E-09};
    constexpr FLT c9[] = {4.4289508956509546E-10, -2.3397558745655689E-11, -1.2203541602950612E-08, 4.1555456454833893E-08, -4.0387396870689535E-08, -5.2822132694649911E-08, 1.7383889346668610E-07, -1.7383889350128520E-07, 5.2822132655898894E-08, 4.0387396825018697E-08, -4.1555456456217858E-08, 1.2203541602961425E-08, 2.3397558742445808E-11, -4.4289508956485521E-10};
    constexpr FLT c10[] = {6.7195187479837397E-11, -3.6781600571601267E-10, 1.8909214069547874E-10, 3.2074788110424279E-09, -1.0777792237178902E-08, 1.5287295344040793E-08, -7.6060393515002415E-09, -7.6060394193782061E-09, 1.5287295315129795E-08, -1.0777792256033903E-08, 3.2074788100996828E-09, 1.8909214022410232E-10, -3.6781600571938840E-10, 6.7195187480072407E-11};
    constexpr FLT c11[] = {5.1753158905849938E-12, -5.7459004383367526E-11, 2.1373772926710777E-10, -3.3474981579266315E-10, -5.5056499021679011E-11, 1.1984997640436430E-09, -2.3401534450899741E-09, 2.3401534368560627E-09, -1.1984997614882759E-09, 5.5056481773059742E-11, 3.3474981494088389E-10, -2.1373772865488849E-10, 5.7459004398339857E-11, -5.1753158903399997E-12};
    constexpr FLT c12[] = {-3.4295334314887252E-13, -1.9669733997962757E-12, 1.8829710684156337E-11, -6.6063897345211508E-11, 1.2987243531465558E-10, -1.4723141559059891E-10, 6.6816638241450007E-11, 6.6816674992423938E-11, -1.4723144009120710E-10, 1.2987246389863218E-10, -6.6063899833524000E-11, 1.8829709790898323E-11, -1.9669734189872262E-12, -3.4295334295386873E-13};
    constexpr FLT c13[] = {-1.4925032356486504E-13, 5.9101412775720763E-13, -1.0473415580082965E-12, -3.4168975321644197E-13, 6.3681265546106545E-12, -1.6773501596110874E-11, 2.5499682861090652E-11, -2.5499676599540805E-11, 1.6773491089725712E-11, -6.3681491385782352E-12, 3.4168991639689697E-13, 1.0473415086930869E-12, -5.9101412527197903E-13, 1.4925032367463167E-13};
    constexpr FLT c14[] = {-1.6512890190412886E-14, 8.8250732077299682E-14, -3.0062088735298833E-13, 6.8819261910563679E-13, -1.0710344223118919E-12, 1.0658816851325112E-12, -4.5538510635793641E-13, -4.5542586230308239E-13, 1.0658698063253250E-12, -1.0710440527620932E-12, 6.8819219968244471E-13, -3.0062102913299402E-13, 8.8250727745177781E-14, -1.6512890091669500E-14};
    constexpr FLT c15[] = {1.6573977544796275E-16, 1.3350732982407589E-15, -1.0198568872965102E-14, 3.9099748138401563E-14, -9.7788768122723911E-14, 1.7463267454485294E-13, -2.3133010081886947E-13, 2.3135108981080239E-13, -1.7462349391883023E-13, 9.7794991333538680E-14, -3.9100183236637960E-14, 1.0198818425583603E-14, -1.3350638233291884E-15, -1.6573967606346456E-16};
    for (int i=0; i<14; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i] + z*(c13[i] + z*(c14[i] + z*(c15[i])))))))))))))));
  } else if constexpr (w==15) {
    constexpr FLT c0[] = {2.4886236238313694E-10, 1.0156314710024858E-06, 1.5297772142853732E-04, 4.9110296377727243E-03, 5.6121982134094014E-02, 2.8670951404936723E-01, 7.3488453954210675E-01, 1.0000000000000009E+00, 7.3488453954210664E-01, 2.8670951404936756E-01, 5.6121982134094153E-02, 4.9110296377727286E-03, 1.5297772142853721E-04, 1.0156314710024835E-06, 2.4886236238313125E-10};
    constexpr FLT c1[] = {1.4880454274285384E-09, 3.1146031777409656E-06, 3.1470309742465672E-04, 7.1215977556942697E-03, 5.6335374470954637E-02, 1.8245542837228401E-01, 2.2739494478010158E-01, -2.1212921335912513E-17, -2.2739494478010189E-01, -1.8245542837228415E-01, -5.6335374470954748E-02, -7.1215977556942818E-03, -3.1470309742465672E-04, -3.1146031777409634E-06, -1.4880454274285361E-09};
    constexpr FLT c2[] = {4.0364738474324382E-09, 4.4152383936309391E-06, 2.9537757977456607E-04, 4.5415629108243203E-03, 2.2685962261788539E-02, 3.3502333548319357E-02, -2.2696322242195973E-02, -7.6666666666667369E-02, -2.2696322242196015E-02, 3.3502333548319246E-02, 2.2685962261788574E-02, 4.5415629108243290E-03, 2.9537757977456613E-04, 4.4152383936309408E-06, 4.0364738474324415E-09};
    constexpr FLT c3[] = {6.6006259688120969E-09, 3.8297656275654666E-06, 1.6597029248061442E-04, 1.6248331197066931E-03, 4.0281119347582005E-03, -2.8399908290139731E-03, -1.3756562885831778E-02, 2.8214012620215877E-18, 1.3756562885831887E-02, 2.8399908290139960E-03, -4.0281119347581893E-03, -1.6248331197066925E-03, -1.6597029248061439E-04, -3.8297656275654657E-06, -6.6006259688120961E-09};
    constexpr FLT c4[] = {7.2920076887968800E-09, 2.2644150332986919E-06, 6.1226481435400998E-05, 3.3216368068303718E-04, 4.2258807580337500E-07, -1.7026747228854671E-03, -1.2026158633594345E-04, 2.8537037037042021E-03, -1.2026158633592798E-04, -1.7026747228854671E-03, 4.2258807579244642E-07, 3.3216368068303610E-04, 6.1226481435401012E-05, 2.2644150332986910E-06, 7.2920076887968800E-09};
    constexpr FLT c5[] = {5.7777535593445565E-09, 9.5996306286140452E-07, 1.5097159537535414E-05, 2.8094504791460675E-05, -1.2791075475387991E-04, -1.0516749004214654E-04, 4.0040320377514744E-04, -2.9254521903171209E-17, -4.0040320377523759E-04, 1.0516749004227534E-04, 1.2791075475386646E-04, -2.8094504791466567E-05, -1.5097159537535478E-05, -9.5996306286140431E-07, -5.7777535593445590E-09};
    constexpr FLT c6[] = {3.3986627004323946E-09, 2.9741452947022095E-07, 2.3232144780589999E-06, -3.5941523174528157E-06, -1.8171775676707950E-05, 3.2858338560946018E-05, 2.0665249075229327E-05, -6.8763374485729812E-05, 2.0665249075209737E-05, 3.2858338560891984E-05, -1.8171775676692009E-05, -3.5941523174462754E-06, 2.3232144780590639E-06, 2.9741452947022190E-07, 3.3986627004323966E-09};
    constexpr FLT c7[] = {1.5128957992049979E-09, 6.6672685257785398E-08, 1.4160936684828114E-07, -1.2611166225393906E-06, 6.6865545482379982E-07, 4.6861078169658144E-06, -7.4523870622697214E-06, -1.4396126433923030E-18, 7.4523870622821872E-06, -4.6861078171786771E-06, -6.6865545482258369E-07, 1.2611166225357075E-06, -1.4160936684821783E-07, -6.6672685257784604E-08, -1.5128957992049966E-09};
    constexpr FLT c8[] = {5.1310324414219137E-10, 1.0163871982746801E-08, -2.4441175134521862E-08, -1.0543632600130600E-07, 4.0979777877938960E-07, -2.9573937051795272E-07, -5.9824625884976530E-07, 1.2067769776046611E-06, -5.9824625884104414E-07, -2.9573937054198998E-07, 4.0979777874105681E-07, -1.0543632599939765E-07, -2.4441175134571291E-08, 1.0163871982744987E-08, 5.1310324414218920E-10};
    constexpr FLT c9[] = {1.3160883866734097E-10, 8.0584478671573275E-10, -6.7824252839632764E-09, 9.4471403078850365E-09, 2.4030590209056248E-08, -9.0522548467097150E-08, 9.9320303311968977E-08, 6.4801334061299793E-18, -9.9320303306433127E-08, 9.0522548602725707E-08, -2.4030590186912812E-08, -9.4471403125559170E-09, 6.7824252839227305E-09, -8.0584478671577494E-10, -1.3160883866734361E-10};
    constexpr FLT c10[] = {2.4734066313994419E-11, -4.3978001545939149E-11, -5.4975091409873009E-10, 2.6307942047565849E-09, -4.2001676325554839E-09, -1.8212710984882958E-10, 1.0547608679845328E-08, -1.6454374715311988E-08, 1.0547608656276595E-08, -1.8212716201433033E-10, -4.2001676495249784E-09, 2.6307942074277104E-09, -5.4975091408891053E-10, -4.3978001545785610E-11, 2.4734066313995337E-11};
    constexpr FLT c11[] = {3.0917581107104265E-12, -2.1504981480418787E-11, 3.4611945905203146E-11, 1.1082666507373995E-10, -5.8883840835118001E-10, 1.1304780041635263E-09, -1.0037911054750330E-09, 1.1228415117366755E-17, 1.0037911049071899E-09, -1.1304781011248302E-09, 5.8883843035557056E-10, -1.1082666656435723E-10, -3.4611945847530977E-11, 2.1504981481389192E-11, -3.0917581107093485E-12};
    constexpr FLT c12[] = {1.5997634038637621E-13, -2.4807970161781935E-12, 1.1275106698059214E-11, -2.3847055079858343E-11, 1.5364460008330925E-11, 4.4350562320757153E-11, -1.3563506321257987E-10, 1.8159081840923697E-10, -1.3563507137937324E-10, 4.4350478610403863E-11, 1.5364414580198884E-11, -2.3847054824637823E-11, 1.1275106650202108E-11, -2.4807970177976851E-12, 1.5997634038475929E-13};
    constexpr FLT c13[] = {-2.4800914618144935E-14, -2.0428592100498625E-14, 6.6720752625942027E-13, -2.9781126552009906E-12, 7.0947564462517667E-12, -1.0181661180942040E-11, 7.9189163961032134E-12, 3.7608949396856996E-18, -7.9189226029666706E-12, 1.0181683671234862E-11, -7.0947475521936810E-12, 2.9781099081789285E-12, -6.6720753193899847E-13, 2.0428592265940106E-14, 2.4800914617314154E-14};
    constexpr FLT c14[] = {-6.3774103676221929E-15, 2.8974955310173576E-14, -6.8422373638576966E-14, 5.3398642699701678E-14, 1.7893165730225197E-13, -7.2418999429507432E-13, 1.3713100656893202E-12, -1.6687865627694359E-12, 1.3712960091978784E-12, -7.2420254070755149E-13, 1.7892100253036837E-13, 5.3399727540394014E-14, -6.8422372503399220E-14, 2.8974955138269160E-14, -6.3774103674607597E-15};
    constexpr FLT c15[] = {-5.1635500234731389E-16, 3.1828109237030503E-15, -1.2111357125137462E-14, 3.1272789056801543E-14, -5.6177765027145775E-14, 6.8664184316750068E-14, -4.9010181633415173E-14, 1.5014404617227298E-17, 4.9025280117573159E-14, -6.8658963234056455E-14, 5.6191826354025916E-14, -3.1272848944295054E-14, 1.2111379512738901E-14, -3.1828103838144419E-15, 5.1635500252288918E-16};
    constexpr FLT c16[] = {4.5179133906197547E-18, -1.3721326906232784E-17, -2.0186815184489892E-16, 1.1791054601203943E-15, -3.5949764000106320E-15, 7.4864168939925667E-15, -1.1419241866991483E-14, 1.2981541205285921E-14, -1.1427309516992720E-14, 7.4238789517193859E-15, -3.6185770943210024E-15, 1.1784710847541274E-15, -2.0188535534452587E-16, -1.3721947132261775E-17, 4.5179130340389477E-18};
    for (int i=0; i<15; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i] + z*(c13[i] + z*(c14[i] + z*(c15[i] + z*(c16[i]))))))))))))))));
  } else if constexpr (w==16) {
    constexpr FLT c0[] = {3.7973138383476054E-11, 2.1620729770457883E-07, 4.2059935922517646E-05, 1.7055631615451748E-03, 2.4507833223051369E-02, 1.5833750021928350E-01, 5.2065761855025561E-01, 9.3058177132107789E-01, 9.3058177132107767E-01, 5.2065761855025572E-01, 1.5833750021928350E-01, 2.4507833223051376E-02, 1.7055631615451737E-03, 4.2059935922517646E-05, 2.1620729770457798E-07, 3.7973138383474981E-11};
    constexpr FLT c1[] = {2.3529614069937337E-10, 6.9307767643753052E-07, 9.1584555859393192E-05, 2.6688190455647245E-03, 2.7424935799146767E-02, 1.1980519064171591E-01, 2.2858769149343958E-01, 1.3403316930972956E-01, -1.3403316930972969E-01, -2.2858769149343969E-01, -1.1980519064171592E-01, -2.7424935799146788E-02, -2.6688190455647237E-03, -9.1584555859393192E-05, -6.9307767643753021E-07, -2.3529614069937312E-10};
    constexpr FLT c2[] = {6.6422278409342432E-10, 1.0324321112746623E-06, 9.1817488865684715E-05, 1.8711533829047159E-03, 1.2921996060610223E-02, 3.2047854205940286E-02, 1.0693035516337665E-02, -5.7626889750985524E-02, -5.7626889750985545E-02, 1.0693035516337648E-02, 3.2047854205940265E-02, 1.2921996060610218E-02, 1.8711533829047161E-03, 9.1817488865684715E-05, 1.0324321112746627E-06, 6.6422278409342463E-10};
    constexpr FLT c3[] = {1.1357078950958122E-09, 9.4728532805183445E-07, 5.5827161828283886E-05, 7.6087086075588375E-04, 3.0946204357507577E-03, 1.6729582927767672E-03, -9.5127691406673553E-03, -8.9630953638634506E-03, 8.9630953638635338E-03, 9.5127691406673709E-03, -1.6729582927767488E-03, -3.0946204357507586E-03, -7.6087086075588310E-04, -5.5827161828283886E-05, -9.4728532805183402E-07, -1.1357078950958117E-09};
    constexpr FLT c4[] = {1.3190161602522569E-09, 5.9764321317063357E-07, 2.2744388605472973E-05, 1.9073517322668065E-04, 2.8943142766412486E-04, -8.8625893129446582E-04, -1.3389167739521499E-03, 1.7216657535079746E-03, 1.7216657535078564E-03, -1.3389167739520829E-03, -8.8625893129448414E-04, 2.8943142766412616E-04, 1.9073517322668041E-04, 2.2744388605472987E-05, 5.9764321317063336E-07, 1.3190161602522567E-09};
    constexpr FLT c5[] = {1.1057322032863292E-09, 2.7364351668058849E-07, 6.4277990516969554E-06, 2.7144256967439121E-05, -3.6927862875725191E-05, -1.6756539822667264E-04, 1.6190404775905833E-04, 2.9203183363564066E-04, -2.9203183363584427E-04, -1.6190404775914360E-04, 1.6756539822664743E-04, 3.6927862875715480E-05, -2.7144256967439711E-05, -6.4277990516969706E-06, -2.7364351668058875E-07, -1.1057322032863290E-09};
    constexpr FLT c6[] = {6.9354916180818924E-10, 9.3269475195063537E-08, 1.2384428187212263E-06, 8.4996778392738158E-07, -1.3106613626292629E-05, 2.8218026703861212E-06, 4.1119875273697444E-05, -3.3017437945430103E-05, -3.3017437945470896E-05, 4.1119875273652538E-05, 2.8218026703968379E-06, -1.3106613626296861E-05, 8.4996778392750302E-07, 1.2384428187212206E-06, 9.3269475195063789E-08, 6.9354916180818945E-10};
    constexpr FLT c7[] = {3.3254260763956011E-10, 2.3748169129617005E-08, 1.4324995919585297E-07, -4.5855119979452145E-07, -9.5896649524105156E-07, 3.6155491754854889E-06, -9.8206137491907898E-07, -6.1812989820315811E-06, 6.1812989820368785E-06, 9.8206137490212540E-07, -3.6155491754921813E-06, 9.5896649524339805E-07, 4.5855119979457609E-07, -1.4324995919584945E-07, -2.3748169129616866E-08, -3.3254260763956011E-10};
    constexpr FLT c8[] = {1.2320735888479526E-10, 4.4066719437556721E-09, 2.9936173156487350E-09, -8.7082338359330349E-08, 1.2972939456230955E-07, 2.2882425902226497E-07, -7.3491924911512702E-07, 4.5592445665545743E-07, 4.5592445660747756E-07, -7.3491924910696321E-07, 2.2882425899779496E-07, 1.2972939455792574E-07, -8.7082338359903181E-08, 2.9936173156278789E-09, 4.4066719437554389E-09, 1.2320735888479485E-10};
    constexpr FLT c9[] = {3.5284250010876550E-11, 5.4380355945604351E-10, -2.1550460241930885E-09, -3.7344953352820494E-09, 2.7722604309424572E-08, -3.9597167050294061E-08, -1.3993916672829409E-08, 9.5626629212869654E-08, -9.5626629290371686E-08, 1.3993916672829409E-08, 3.9597167029534587E-08, -2.7722604309424572E-08, 3.7344953347198139E-09, 2.1550460241883579E-09, -5.4380355945631803E-10, -3.5284250010876550E-11};
    constexpr FLT c10[] = {7.7013760205811189E-12, 2.8123297626102908E-11, -3.7953802134156255E-10, 8.7573780433573970E-10, 5.1359846138839095E-10, -5.3609157638048723E-09, 9.1303304391922814E-09, -4.8150451469735769E-09, -4.8150451821695577E-09, 9.1303303785420424E-09, -5.3609157562628785E-09, 5.1359845683177007E-10, 8.7573780433573908E-10, -3.7953802135138315E-10, 2.8123297626198877E-11, 7.7013760205813484E-12};
    constexpr FLT c11[] = {1.2276300481457118E-12, -4.1769601372154706E-12, -1.9148402788514276E-11, 1.3822953664496548E-10, -3.0994363825898090E-10, 2.0316700162393117E-10, 4.3650570799977785E-10, -1.1534087411135158E-09, 1.1534087067582605E-09, -4.3650572872648811E-10, -2.0316702142789328E-10, 3.0994363982058370E-10, -1.3822953669820091E-10, 1.9148402794059297E-11, 4.1769601372328333E-12, -1.2276300481457027E-12};
    constexpr FLT c12[] = {1.2527329159238077E-13, -1.0816725478673842E-12, 2.7445378747019394E-12, 1.7839891961657867E-12, -2.6194652895800313E-11, 6.7446677647394068E-11, -8.5082148942419491E-11, 4.0255039228341312E-11, 4.0255014727829503E-11, -8.5082153025857524E-11, 6.7446659271937760E-11, -2.6194659020925783E-11, 1.7839886857347582E-12, 2.7445378507741848E-12, -1.0816725480072234E-12, 1.2527329159219117E-13};
    constexpr FLT c13[] = {3.2506946752584284E-15, -9.2845382012734022E-14, 5.1542690289651931E-13, -1.3678933550774322E-12, 1.6503394000353190E-12, 7.2548222075468971E-13, -6.2314783158857931E-12, 1.1299385029049823E-11, -1.1299412389378464E-11, 6.2314862503466412E-12, -7.2548671567597581E-13, -1.6503386065891033E-12, 1.3678930680384301E-12, -5.1542690417907497E-13, 9.2845381914947089E-14, -3.2506946753557064E-15};
    constexpr FLT c14[] = {-1.3523251102660285E-15, 1.9055798040664957E-15, 1.8430801809977217E-14, -1.1526991298447018E-13, 3.3348650134861527E-13, -5.8352626545764598E-13, 6.1749039614345018E-13, -2.7107869685672170E-13, -2.7109332004657512E-13, 6.1745916976419674E-13, -5.8352477326021082E-13, 3.3348496582397061E-13, -1.1526993239191820E-13, 1.8430798249970336E-14, 1.9055798150784046E-15, -1.3523251102071566E-15};
    constexpr FLT c15[] = {-2.4132931367237367E-16, 1.2442654957274558E-15, -3.5592524044067016E-15, 5.0959422961477296E-15, 1.6457864483481524E-15, -2.5291879718574400E-14, 6.2721101216839530E-14, -9.2634489356235131E-14, 9.2635738460845619E-14, -6.2719649383821551E-14, 2.5285060095240627E-14, -1.6450340241546609E-15, -5.0959072562256486E-15, 3.5592539403047753E-15, -1.2442654850132002E-15, 2.4132931369394181E-16};
    constexpr FLT c16[] = {-1.6052119792140307E-17, 1.0220935606483716E-16, -4.3668256960360204E-16, 1.2660776751946750E-15, -2.5887248648677308E-15, 3.7440553205498428E-15, -3.5013660863304473E-15, 1.4138716423669956E-15, 1.4075851421411128E-15, -3.5039069022876658E-15, 3.7371008060361623E-15, -2.5918828508224464E-15, 1.2658767163553955E-15, -4.3669235527279705E-16, 1.0220930333729136E-16, -1.6052119836268989E-17};
    constexpr FLT c17[] = {1.2307507765549609E-18, -2.6518644362922344E-18, -1.2515545353008470E-20, 2.6927650309286786E-17, -1.1524664511280185E-16, 2.7886896016078674E-16, -4.6727358397732244E-16, 6.5982664751885646E-16, -6.6441094913127157E-16, 4.6905833790076952E-16, -2.7865574777849670E-16, 1.1538444947333928E-16, -2.6987584488723839E-17, 1.2060311781417857E-20, 2.6518475285441206E-18, -1.2307508043854425E-18};
    for (int i=0; i<16; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i] + z*(c13[i] + z*(c14[i] + z*(c15[i] + z*(c16[i] + z*(c17[i])))))))))))))))));
  } else
    printf("width not implemented!\n");
