// Code generated by gen_all_horner_C_code.m in finufft/devel
// Authors: Alex Barnett & Ludvig af Klinteberg.
// (C) The Simons Foundation, Inc.
  if constexpr (w==2) {
    constexpr FLT c0[] = {6.1209111871385669E-01, 6.1209111871385680E-01};
    constexpr FLT c1[] = {6.4742429432896387E-01, -6.4742429432896387E-01};
    constexpr FLT c2[] = {-9.0411309581634763E-02, -9.0411309581634819E-02};
    constexpr FLT c3[] = {-1.9075708590566753E-01, 1.9075708590566756E-01};
    for (int i=0; i<2; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i])));
  } else if constexpr (w==3) {
    constexpr FLT c0[] = {2.4728112933307073E-01, 1.0000000000000040E+00, 2.4728112935494936E-01};
    constexpr FLT c1[] = {4.0470611346184499E-01, -1.6970337068730035E-16, -4.0470611343822127E-01};
    constexpr FLT c2[] = {1.4864411342268652E-01, -3.0473448739822778E-01, 1.4864411344492170E-01};
    constexpr FLT c3[] = {-4.4469294619149682E-02, 4.8015385165414327E-17, 4.4469294640111567E-02};
    constexpr FLT c4[] = {-2.9270010751775020E-02, 3.7966707032750471E-02, -2.9270010728701217E-02};
    for (int i=0; i<3; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i]))));
  } else if constexpr (w==4) {
    constexpr FLT c0[] = {8.4048892491849742E-02, 7.9275732207620841E-01, 7.9275732207620875E-01, 8.4048892491849783E-02};
    constexpr FLT c1[] = {1.7431588385887223E-01, 3.7425489538028367E-01, -3.7425489538028395E-01, -1.7431588385887223E-01};
    constexpr FLT c2[] = {1.1425598262146335E-01, -1.1126112046907141E-01, -1.1126112046907129E-01, 1.1425598262146333E-01};
    constexpr FLT c3[] = {1.5677587697716069E-02, -6.7022293289915769E-02, 6.7022293289915741E-02, -1.5677587697716048E-02};
    constexpr FLT c4[] = {-1.0401300825285637E-02, 6.3725646657137903E-03, 6.3725646657138996E-03, -1.0401300825285627E-02};
    constexpr FLT c5[] = {-3.0464394190490968E-03, 5.3247889205096637E-03, -5.3247889205097453E-03, 3.0464394190490743E-03};
    for (int i=0; i<4; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i])))));
  } else if constexpr (w==5) {
    constexpr FLT c0[] = {2.5811126752233300E-02, 4.6616226852477310E-01, 1.0000000000000004E+00, 4.6616226852477283E-01, 2.5811126752233279E-02};
    constexpr FLT c1[] = {6.2936773057387013E-02, 3.7198919402373987E-01, -1.2727752801547548E-16, -3.7198919402373976E-01, -6.2936773057386999E-02};
    constexpr FLT c2[] = {5.4855980576944546E-02, 3.7709308632020579E-02, -1.8284069243892631E-01, 3.7709308632020731E-02, 5.4855980576944560E-02};
    constexpr FLT c3[] = {1.8780973157032137E-02, -3.8322611720715702E-02, -3.0072186542941280E-17, 3.8322611720715730E-02, -1.8780973157032126E-02};
    constexpr FLT c4[] = {-2.3306908700113508E-05, -8.3858973028989696E-03, 1.4886952481383579E-02, -8.3858973028989054E-03, -2.3306908700115385E-05};
    constexpr FLT c5[] = {-1.5212353034890040E-03, 1.7151925122364340E-03, -1.0820256419442042E-16, -1.7151925122365530E-03, 1.5212353034889936E-03};
    for (int i=0; i<5; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i])))));
  } else if constexpr (w==6) {
    constexpr FLT c0[] = {7.3992041846532739E-03, 2.2998056434514014E-01, 8.5775196559356071E-01, 8.5775196559356048E-01, 2.2998056434514008E-01, 7.3992041847815992E-03};
    constexpr FLT c1[] = {2.0397684222696229E-02, 2.4277466601214714E-01, 2.6509440217151259E-01, -2.6509440217151231E-01, -2.4277466601214720E-01, -2.0397684222557680E-02};
    constexpr FLT c2[] = {2.1435449512033435E-02, 7.4190333865239919E-02, -9.5369600014193437E-02, -9.5369600014193354E-02, 7.4190333865239877E-02, 2.1435449512163880E-02};
    constexpr FLT c3[] = {1.0463664645794034E-02, -5.8671703446042016E-03, -3.4019677093840517E-02, 3.4019677093840572E-02, 5.8671703446042381E-03, -1.0463664645671085E-02};
    constexpr FLT c4[] = {1.9378826192716935E-03, -6.8365127179467822E-03, 4.7406536657958352E-03, 4.7406536657957372E-03, -6.8365127179468334E-03, 1.9378826194070343E-03};
    constexpr FLT c5[] = {-2.6471424081648518E-04, -5.6150758897076337E-04, 2.0099203466670337E-03, -2.0099203466670832E-03, 5.6150758897070309E-04, 2.6471424094084089E-04};
    constexpr FLT c6[] = {-1.6161497824910900E-04, 2.5924418389357582E-04, -1.3917099193220238E-04, -1.3917099193215624E-04, 2.5924418389355257E-04, -1.6161497812640228E-04};
    for (int i=0; i<6; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i]))))));
  } else if constexpr (w==7) {
    constexpr FLT c0[] = {2.0163149398992283E-03, 1.0071602557045124E-01, 5.8653557849806104E-01, 1.0000000000000000E+00, 5.8653557849806159E-01, 1.0071602557045128E-01, 2.0163149399332544E-03};
    constexpr FLT c1[] = {6.1353661835569159E-03, 1.2822551681002697E-01, 3.1973557271594322E-01, -8.4851685343650348E-17, -3.1973557271594344E-01, -1.2822551681002697E-01, -6.1353661835202083E-03};
    constexpr FLT c2[] = {7.4065234100227735E-03, 5.7825030729344376E-02, 1.0889852837580607E-04, -1.3060049459923290E-01, 1.0889852837579503E-04, 5.7825030729344355E-02, 7.4065234100573743E-03};
    constexpr FLT c3[] = {4.4924606632387740E-03, 7.2245566707420956E-03, -2.7743312484355645E-02, 4.8062139167337038E-18, 2.7743312484355763E-02, -7.2245566707421025E-03, -4.4924606632061890E-03};
    constexpr FLT c4[] = {1.3572774007773838E-03, -2.3954706749181576E-03, -2.9058644824981614E-03, 7.8619155407044367E-03, -2.9058644824981484E-03, -2.3954706749181576E-03, 1.3572774008132609E-03};
    constexpr FLT c5[] = {1.1260116639581245E-04, -7.8814564904714066E-04, 1.1036556706848430E-03, -1.0256120645547333E-16, -1.1036556706849785E-03, 7.8814564904712190E-04, -1.1260116636284711E-04};
    constexpr FLT c6[] = {-4.7399003259807427E-05, 2.0950491942974621E-06, 1.7484854214657133E-04, -2.9104069274777630E-04, 1.7484854214657890E-04, 2.0950491942817212E-06, -4.7399003227280379E-05};
    constexpr FLT c7[] = {-1.2555096177145360E-05, 2.7293834771960423E-05, -2.6660039700455961E-05, -5.0941873861390392E-17, 2.6660039700535064E-05, -2.7293834771960725E-05, 1.2555096209060891E-05};
    for (int i=0; i<7; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i])))))));
  } else if constexpr (w==8) {
    constexpr FLT c0[] = {5.2827275612461451E-04, 4.0402734444109217E-02, 3.4389230803369680E-01, 8.9161099745784878E-01, 8.9161099745784844E-01, 3.4389230803369675E-01, 4.0402734444109217E-02, 5.2827275612461397E-04};
    constexpr FLT c1[] = {1.7458301875074075E-03, 5.9145446836664499E-02, 2.5435204236257836E-01, 2.0538938722823202E-01, -2.0538938722823219E-01, -2.5435204236257830E-01, -5.9145446836664492E-02, -1.7458301875074073E-03};
    constexpr FLT c2[] = {2.3525728171808302E-03, 3.3585505340219701E-02, 4.4733940386002168E-02, -8.0668262921248846E-02, -8.0668262921248762E-02, 4.4733940386002147E-02, 3.3585505340219694E-02, 2.3525728171808306E-03};
    constexpr FLT c3[] = {1.6676293877589689E-03, 8.1606118103203923E-03, -1.0603838868224458E-02, -2.0559571166483832E-02, 2.0559571166483812E-02, 1.0603838868224439E-02, -8.1606118103203784E-03, -1.6676293877589683E-03};
    constexpr FLT c4[] = {6.5470478006265378E-04, 5.7029826102773115E-05, -4.0842122325118468E-03, 3.3746160664394906E-03, 3.3746160664395036E-03, -4.0842122325118451E-03, 5.7029826102771821E-05, 6.5470478006265345E-04};
    constexpr FLT c5[] = {1.2504911757628621E-04, -3.9351755557268033E-04, 2.3739384784364383E-05, 9.6592347103011448E-04, -9.6592347103028199E-04, -2.3739384784413348E-05, 3.9351755557267193E-04, -1.2504911757628642E-04};
    constexpr FLT c6[] = {-6.5665874015840706E-07, -6.1884865695206498E-05, 1.4476791315354124E-04, -8.6782118193463355E-05, -8.6782118193402314E-05, 1.4476791315355117E-04, -6.1884865695212461E-05, -6.5665874015819805E-07};
    constexpr FLT c7[] = {-5.1256159860503314E-06, 5.3292178505928552E-06, 8.7427989025428753E-06, -2.8404799465120154E-05, 2.8404799465045320E-05, -8.7427989025463803E-06, -5.3292178505922614E-06, 5.1256159860508015E-06};
    for (int i=0; i<8; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i])))))));
  } else if constexpr (w==9) {
    constexpr FLT c0[] = {1.3409415535124453E-04, 1.5141199617983750E-02, 1.8004032483820073E-01, 6.6268423293859624E-01, 1.0000000000000000E+00, 6.6268423293859713E-01, 1.8004032483820073E-01, 1.5141199617983806E-02, 1.3409415535124423E-04};
    constexpr FLT c1[] = {4.7572953640583380E-04, 2.4761567630011024E-02, 1.6332247709293538E-01, 2.7616213278983187E-01, -1.2727752801547551E-16, -2.7616213278983220E-01, -1.6332247709293540E-01, -2.4761567630011090E-02, -4.7572953640583358E-04};
    constexpr FLT c2[] = {7.0217948741779822E-04, 1.6533012331430414E-02, 4.8637875368588435E-02, -1.5084170630533118E-02, -1.0157816246607025E-01, -1.5084170630533399E-02, 4.8637875368588449E-02, 1.6533012331430449E-02, 7.0217948741779855E-04};
    constexpr FLT c3[] = {5.6197289626769645E-04, 5.4583505067802972E-03, 8.8722695781043152E-04, -2.0386313118366337E-02, 7.7339938432418739E-17, 2.0386313118366497E-02, -8.8722695781042523E-04, -5.4583505067803042E-03, -5.6197289626769623E-04};
    constexpr FLT c4[] = {2.6358216867957519E-04, 7.0803132065996725E-04, -2.3883045659485484E-03, -1.0047843626593107E-03, 4.8455486978738038E-03, -1.0047843626591504E-03, -2.3883045659485562E-03, 7.0803132065996670E-04, 2.6358216867957530E-04};
    constexpr FLT c5[] = {7.0565721004957736E-05, -9.0876125855053581E-05, -3.5965836571498310E-04, 7.0575785995715778E-04, -1.7863253875768360E-16, -7.0575785995748987E-04, 3.5965836571493544E-04, 9.0876125855052036E-05, -7.0565721004957886E-05};
    constexpr FLT c6[] = {7.9668965137352579E-06, -4.2137454928178333E-05, 3.9856859670039154E-05, 6.5639620808859397E-05, -1.4477186949857812E-04, 6.5639620808726203E-05, 3.9856859670047136E-05, -4.2137454928184303E-05, 7.9668965137354324E-06};
    constexpr FLT c7[] = {-9.3772917893887112E-07, -3.0575635011687597E-06, 1.2977675432519954E-05, -1.5241881422255193E-05, 1.6602960103597961E-17, 1.5241881422356022E-05, -1.2977675432524160E-05, 3.0575635011788267E-06, 9.3772917893911581E-07};
    constexpr FLT c8[] = {-4.1446092652953487E-07, 7.2790527337856297E-07, -2.5130319741045627E-08, -1.9002349620285069E-06, 3.0493470975570654E-06, -1.9002349619475500E-06, -2.5130319785472300E-08, 7.2790527336840831E-07, -4.1446092652968940E-07};
    for (int i=0; i<9; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i]))))))));
  } else if constexpr (w==10) {
    constexpr FLT c0[] = {3.3157481538170376E-05, 5.3715860775974400E-03, 8.6328042282845727E-02, 4.3077092326437977E-01, 9.1242439930731056E-01, 9.1242439930731056E-01, 4.3077092326437955E-01, 8.6328042282845727E-02, 5.3715860775974157E-03, 3.3157481538170227E-05};
    constexpr FLT c1[] = {1.2517797191066970E-04, 9.6269418565961325E-03, 9.1130577457178341E-02, 2.4769645835465337E-01, 1.6766875916810506E-01, -1.6766875916810528E-01, -2.4769645835465337E-01, -9.1130577457178355E-02, -9.6269418565961048E-03, -1.2517797191066943E-04};
    constexpr FLT c2[] = {1.9968216068682134E-04, 7.2783782301876591E-03, 3.5949398124193926E-02, 2.5847993600195424E-02, -6.9275634160640739E-02, -6.9275634160640559E-02, 2.5847993600195397E-02, 3.5949398124193920E-02, 7.2783782301876392E-03, 1.9968216068682104E-04};
    constexpr FLT c3[] = {1.7649923565147245E-04, 2.9221990881931085E-03, 4.9086823797165040E-03, -1.0940556313145984E-02, -1.3762152424114743E-02, 1.3762152424114974E-02, 1.0940556313146011E-02, -4.9086823797165093E-03, -2.9221990881930998E-03, -1.7649923565147212E-04};
    constexpr FLT c4[] = {9.4710355505531893E-05, 6.0621452710061488E-04, -7.0118560592791126E-04, -2.4750745659639292E-03, 2.4757076628500714E-03, 2.4757076628500606E-03, -2.4750745659640741E-03, -7.0118560592790562E-04, 6.0621452710060925E-04, 9.4710355505531690E-05};
    constexpr FLT c5[] = {3.1258610702677723E-05, 2.8169545035122152E-05, -2.9881406711978152E-04, 1.5956798534229568E-04, 5.3653099874320198E-04, -5.3653099874341719E-04, -1.5956798534230856E-04, 2.9881406711976336E-04, -2.8169545035121613E-05, -3.1258610702677696E-05};
    constexpr FLT c6[] = {5.7780052154064796E-06, -1.5636835808663068E-05, -1.6121807313045479E-05, 8.1230533420404926E-05, -5.5456530742904635E-05, -5.5456530742895771E-05, 8.1230533420387498E-05, -1.6121807313057897E-05, -1.5636835808665389E-05, 5.7780052154065305E-06};
    constexpr FLT c7[] = {2.7742147829407355E-07, -3.2550081973293079E-06, 5.9212960378138431E-06, 8.5495977198199636E-07, -1.3248468528094739E-05, 1.3248468528222524E-05, -8.5495977193841556E-07, -5.9212960378138668E-06, 3.2550081973309296E-06, -2.7742147829403215E-07};
    constexpr FLT c8[] = {-1.2089379439828256E-07, -3.4743143855636537E-08, 8.2889801007672424E-07, -1.5830293784962681E-06, 8.7461219394036447E-07, 8.7461219389667727E-07, -1.5830293787035047E-06, 8.2889801007086076E-07, -3.4743143856988507E-08, -1.2089379439837777E-07};
    constexpr FLT c9[] = {-2.5033479260940706E-08, 6.3042298324612022E-08, -5.2303271564055656E-08, -7.6226091805053197E-08, 2.3316553100830421E-07, -2.3316553113839693E-07, 7.6226091857643871E-08, 5.2303271557135834E-08, -6.3042298326514974E-08, 2.5033479260977198E-08};
    for (int i=0; i<10; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i])))))))));
  } else if constexpr (w==11) {
    constexpr FLT c0[] = {8.0191950887587910E-06, 1.8211144887695892E-03, 3.8565497751765689E-02, 2.5236459439543657E-01, 7.1517256669690410E-01, 9.9999999999999967E-01, 7.1517256669690377E-01, 2.5236459439543635E-01, 3.8565497751765709E-02, 1.8211144887695895E-03, 8.0191950887586503E-06};
    constexpr FLT c1[] = {3.1996260415636067E-05, 3.5282769389657614E-03, 4.5889527487056443E-02, 1.8012194355267477E-01, 2.4178022040260364E-01, -4.2425842671825205E-17, -2.4178022040260411E-01, -1.8012194355267475E-01, -4.5889527487056443E-02, -3.5282769389657627E-03, -3.1996260415635823E-05};
    constexpr FLT c2[] = {5.4612928019025129E-05, 2.9497743530118277E-03, 2.1858479505161194E-02, 3.8333708936616494E-02, -2.1641923687039349E-02, -8.3109405654057333E-02, -2.1641923687039270E-02, 3.8333708936616494E-02, 2.1858479505161191E-02, 2.9497743530118282E-03, 5.4612928019024878E-05};
    constexpr FLT c3[] = {5.2504054888010184E-05, 1.3660648269306136E-03, 4.7357572177382659E-03, -2.2373255422689052E-03, -1.5459233729560849E-02, 3.9859385791562669E-17, 1.5459233729560927E-02, 2.2373255422689529E-03, -4.7357572177382625E-03, -1.3660648269306131E-03, -5.2504054888009940E-05};
    constexpr FLT c4[] = {3.1396100602888591E-05, 3.6443237253636095E-04, 1.5906780001786113E-04, -1.9495384184342966E-03, -2.4621376046567064E-04, 3.2818730060398637E-03, -2.4621376046565297E-04, -1.9495384184343234E-03, 1.5906780001786160E-04, 3.6443237253636095E-04, 3.1396100602888456E-05};
    constexpr FLT c5[] = {1.2057435171015747E-05, 4.6687328398361512E-05, -1.3963494372749242E-04, -1.4877651674418728E-04, 4.6954815721681679E-04, -3.4103624816061268E-17, -4.6954815721704350E-04, 1.4877651674414814E-04, 1.3963494372748253E-04, -4.6687328398363077E-05, -1.2057435171015720E-05};
    constexpr FLT c6[] = {2.8888404081262352E-06, -1.8976367884810240E-06, -2.4767547607265331E-05, 3.8337725458121597E-05, 2.6462355617062251E-05, -8.2113719362918427E-05, 2.6462355616970796E-05, 3.8337725458125717E-05, -2.4767547607267571E-05, -1.8976367884806328E-06, 2.8888404081262331E-06};
    constexpr FLT c7[] = {3.5729663467788187E-07, -1.6085054296200635E-06, 4.5672370508001001E-07, 6.0608527683362192E-06, -9.0233724844422414E-06, -6.1104635753534212E-18, 9.0233724844321685E-06, -6.0608527683014282E-06, -4.5672370507820282E-07, 1.6085054296207566E-06, -3.5729663467788679E-07};
    constexpr FLT c8[] = {-7.7890073973106060E-09, -1.8340559948668337E-07, 5.4451797329480613E-07, -3.5830285713357727E-07, -7.3873233537270032E-07, 1.4648976902855600E-06, -7.3873233541090648E-07, -3.5830285716766383E-07, 5.4451797328800011E-07, -1.8340559948752225E-07, -7.7890073973213941E-09};
    constexpr FLT c9[] = {-9.8984999695258830E-09, 1.0194946773891284E-08, 3.5279000671976206E-08, -1.1638771468206141E-07, 1.2326133615274268E-07, -5.5758054629440675E-18, -1.2326133614167095E-07, 1.1638771462947075E-07, -3.5279000679588014E-08, -1.0194946774453520E-08, 9.8984999695123669E-09};
    for (int i=0; i<11; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i])))))))));
  } else if constexpr (w==12) {
    constexpr FLT c0[] = {1.9028495068410063E-06, 5.9416527261081902E-04, 1.6248140264385581E-02, 1.3597036436097903E-01, 4.9821957378204806E-01, 9.2652305802242907E-01, 9.2652305802242907E-01, 4.9821957378204812E-01, 1.3597036436097931E-01, 1.6248140264385608E-02, 5.9416527261081859E-04, 1.9028495068454166E-06};
    constexpr FLT c1[] = {7.9801239249145855E-06, 1.2318344820958845E-03, 2.1335987794357178E-02, 1.1394981969310444E-01, 2.3520579283187454E-01, 1.4166451219687673E-01, -1.4166451219687676E-01, -2.3520579283187454E-01, -1.1394981969310453E-01, -2.1335987794357209E-02, -1.2318344820958838E-03, -7.9801239249098489E-06};
    constexpr FLT c2[] = {1.4462226804444722E-05, 1.1205076408888253E-03, 1.1698445222077601E-02, 3.3958877046121619E-02, 1.3705098421608761E-02, -6.0497400607811530E-02, -6.0497400607811475E-02, 1.3705098421608780E-02, 3.3958877046121570E-02, 1.1698445222077622E-02, 1.1205076408888253E-03, 1.4462226804449270E-05};
    constexpr FLT c3[] = {1.4953735432776095E-05, 5.8049865432805109E-04, 3.2684769908807700E-03, 2.3619245295514145E-03, -1.0074268581043166E-02, -9.8551520939613255E-03, 9.8551520939613533E-03, 1.0074268581043166E-02, -2.3619245295513481E-03, -3.2684769908807652E-03, -5.8049865432805131E-04, -1.4953735432771914E-05};
    constexpr FLT c4[] = {9.7900673700200693E-06, 1.8351475200221882E-04, 3.8725987583789119E-04, -9.2229408802590768E-04, -1.5383560041742821E-03, 1.8800996948120981E-03, 1.8800996948121530E-03, -1.5383560041743090E-03, -9.2229408802591386E-04, 3.8725987583788620E-04, 1.8351475200221876E-04, 9.7900673700247567E-06};
    constexpr FLT c5[] = {4.2345162286123860E-06, 3.3664241555333734E-05, -3.0535096226560294E-05, -1.9795772057292226E-04, 1.7526295499594152E-04, 3.2830037656731109E-04, -3.2830037656744667E-04, -1.7526295499600649E-04, 1.9795772057293708E-04, 3.0535096226557868E-05, -3.3664241555334059E-05, -4.2345162286081238E-06};
    constexpr FLT c6[] = {1.2088615636792264E-06, 2.2204932634071259E-06, -1.5559909809165443E-05, 1.8771595438476344E-06, 4.7304527720868753E-05, -3.7055029721580005E-05, -3.7055029721527014E-05, 4.7304527720873781E-05, 1.8771595438202391E-06, -1.5559909809166056E-05, 2.2204932634071048E-06, 1.2088615636834573E-06};
    constexpr FLT c7[] = {2.1206307767331438E-07, -4.5869687934386224E-07, -1.3462277877514610E-06, 4.2970047520315825E-06, -1.1214870287791455E-06, -6.9831974682806686E-06, 6.9831974682536424E-06, 1.1214870287442797E-06, -4.2970047519973843E-06, 1.3462277877581536E-06, 4.5869687934387902E-07, -2.1206307766916990E-07};
    constexpr FLT c8[] = {1.5395324498812247E-08, -1.2022118042082968E-07, 1.5464523856734829E-07, 2.7605497718584214E-07, -8.4964626032687232E-07, 5.2067203458870276E-07, 5.2067203459885582E-07, -8.4964626035081063E-07, 2.7605497714687566E-07, 1.5464523855816190E-07, -1.2022118042113675E-07, 1.5395324502810954E-08};
    constexpr FLT c9[] = {-2.0816585198676747E-09, -6.8192670392830079E-09, 3.6338774645243295E-08, -4.9464520971991661E-08, -1.3242031032754055E-08, 1.0671664853980193E-07, -1.0671664859377656E-07, 1.3242030994003039E-08, 4.9464520976143551E-08, -3.6338774640745405E-08, 6.8192670390883880E-09, 2.0816585232941368E-09};
    constexpr FLT c10[] = {-6.3791929313743717E-10, 1.2240176130963314E-09, 5.3586929812854596E-10, -6.2807355943243368E-09, 1.0600657314581666E-08, -5.5585209501851270E-09, -5.5585209225311209E-09, 1.0600657309553665E-08, -6.2807355855253437E-09, 5.3586928838680225E-10, 1.2240176129588461E-09, -6.3791928984134226E-10};
    for (int i=0; i<12; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i]))))))))));
  } else if constexpr (w==13) {
    constexpr FLT c0[] = {4.4408051211162845E-07, 1.8756193861873413E-04, 6.5146989208011647E-03, 6.8352802598867821E-02, 3.1564238810082473E-01, 7.5353649746793916E-01, 9.9999999999999911E-01, 7.5353649746793805E-01, 3.1564238810082468E-01, 6.8352802598867654E-02, 6.5146989208011647E-03, 1.8756193861873245E-04, 4.4408051211162560E-07};
    constexpr FLT c1[] = {1.9487148068106031E-06, 4.1285069961250658E-04, 9.2995630713278675E-03, 6.5021145064983493E-02, 1.8663042875529987E-01, 2.1451870821533786E-01, -8.4851685343650422E-17, -2.1451870821533786E-01, -1.8663042875529984E-01, -6.5021145064983382E-02, -9.2995630713278675E-03, -4.1285069961250398E-04, -1.9487148068106023E-06};
    constexpr FLT c2[] = {3.7267581324409613E-06, 4.0381251792508718E-04, 5.7019503038218417E-03, 2.4040868593456794E-02, 2.9406233528281669E-02, -2.4394921635639406E-02, -7.0323343245741035E-02, -2.4394921635639197E-02, 2.9406233528281669E-02, 2.4040868593456784E-02, 5.7019503038218391E-03, 4.0381251792508517E-04, 3.7267581324409634E-06};
    constexpr FLT c3[] = {4.1089519307370176E-06, 2.2941839162878732E-04, 1.8941440042457441E-03, 3.5673079836347735E-03, -3.6880489041049131E-03, -1.2074156718545290E-02, 2.5879613397797189E-18, 1.2074156718545309E-02, 3.6880489041048650E-03, -3.5673079836347895E-03, -1.8941440042457428E-03, -2.2941839162878632E-04, -4.1089519307370168E-06};
    constexpr FLT c4[] = {2.9080869014384416E-06, 8.2405696428180852E-05, 3.3386109283452606E-04, -1.7130036080581002E-04, -1.5108662980937166E-03, 7.8665018928577543E-05, 2.3686576883603064E-03, 7.8665018928625479E-05, -1.5108662980936988E-03, -1.7130036080582076E-04, 3.3386109283452714E-04, 8.2405696428180622E-05, 2.9080869014384416E-06};
    constexpr FLT c5[] = {1.3873038503072792E-06, 1.8694798962849680E-05, 1.4885937076473728E-05, -1.3109520271108061E-04, -4.6797213058848897E-05, 3.2555441892417972E-04, -4.6307891541053687E-17, -3.2555441892426857E-04, 4.6797213058873732E-05, 1.3109520271107364E-04, -1.4885937076475722E-05, -1.8694798962849945E-05, -1.3873038503072794E-06};
    constexpr FLT c6[] = {4.5216719173889313E-07, 2.3203195635244226E-06, -6.0547210914045186E-06, -1.2111482379357380E-05, 3.0238388566365154E-05, 1.0632529352020189E-05, -5.0954659549824471E-05, 1.0632529352183524E-05, 3.0238388566276076E-05, -1.2111482379361646E-05, -6.0547210914053648E-06, 2.3203195635247182E-06, 4.5216719173889350E-07};
    constexpr FLT c7[] = {9.7956192761412040E-08, 9.2080334896145121E-09, -1.2031586234320926E-06, 1.3860784486078430E-06, 2.8079238803383842E-06, -5.6034103145900825E-06, -1.8688507553468845E-18, 5.6034103144765343E-06, -2.8079238803764495E-06, -1.3860784486165916E-06, 1.2031586234329267E-06, -9.2080334898328828E-09, -9.7956192761411590E-08};
    constexpr FLT c8[] = {1.2350515865276535E-08, -4.7668301905096242E-08, -3.2637845350574011E-08, 3.2101904614218007E-07, -3.3650826992335862E-07, -3.1117289070051007E-07, 7.8771611533075144E-07, -3.1117289086091704E-07, -3.3650826988353573E-07, 3.2101904611210855E-07, -3.2637845351216048E-08, -4.7668301904904800E-08, 1.2350515865275286E-08};
    constexpr FLT c9[] = {2.7912946705524691E-10, -6.8584366112738666E-09, 1.5876438438624186E-08, 2.2894800340215993E-09, -5.4355139634661042E-08, 6.9215572145029099E-08, -1.8889191980602000E-17, -6.9215572300033164E-08, 5.4355139615285534E-08, -2.2894800243338452E-09, -1.5876438440267642E-08, 6.8584366109440936E-09, -2.7912946705533138E-10};
    constexpr FLT c10[] = {-1.9473100882674590E-10, -6.0076128557162250E-11, 1.8131864338418081E-09, -3.9994904625900363E-09, 2.0334605572691713E-09, 5.0274131302017483E-09, -9.3367592069973016E-09, 5.0274134843614371E-09, 2.0334604856201788E-09, -3.9994904962147793E-09, 1.8131864331347476E-09, -6.0076128257643601E-11, -1.9473100882626639E-10};
    constexpr FLT c11[] = {-2.9813639428048576E-11, 8.8416967288090687E-11, -6.1944898026433027E-11, -2.3424445580726660E-10, 6.6123636775224220E-10, -6.5395825191702606E-10, 1.1351922232346565E-17, 6.5395800007317743E-10, -6.6123637406963074E-10, 2.3424447837951271E-10, 6.1944899055672989E-11, -8.8416967523218366E-11, 2.9813639427979028E-11};
    for (int i=0; i<13; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i])))))))))));
  } else if constexpr (w==14) {
    constexpr FLT c0[] = {1.0213002307223099E-07, 5.7528591418445659E-05, 2.5031206020280070E-03, 3.2405046511689226E-02, 1.8485678142025505E-01, 5.5177865704975260E-01, 9.3670793123951679E-01, 9.3670793123951657E-01, 5.5177865704975282E-01, 1.8485678142025541E-01, 3.2405046511689233E-02, 2.5031206020280157E-03, 5.7528591418445747E-05, 1.0213002307242220E-07};
    constexpr FLT c1[] = {4.6718564624239740E-07, 1.3360375098030145E-04, 3.8410346178215263E-03, 3.4207779106833411E-02, 1.2923501383683475E-01, 2.2132894130184272E-01, 1.2264779624530245E-01, -1.2264779624530252E-01, -2.2132894130184286E-01, -1.2923501383683494E-01, -3.4207779106833397E-02, -3.8410346178215349E-03, -1.3360375098030170E-04, -4.6718564624220221E-07};
    constexpr FLT c2[] = {9.3810713124204495E-07, 1.3926941499858519E-04, 2.5833386162538992E-03, 1.4797516242328836E-02, 3.0361769467151925E-02, 5.7261067343618525E-03, -5.3608938764866769E-02, -5.3608938764866901E-02, 5.7261067343618776E-03, 3.0361769467151856E-02, 1.4797516242328839E-02, 2.5833386162539074E-03, 1.3926941499858541E-04, 9.3810713124224803E-07};
    constexpr FLT c3[] = {1.0954436997682027E-06, 8.5568590196649221E-05, 9.7778250562911557E-04, 3.0692948752812743E-03, 6.0463237460739363E-04, -8.9532302111319344E-03, -7.4040784665310487E-03, 7.4040784665310947E-03, 8.9532302111319205E-03, -6.0463237460742344E-04, -3.0692948752812769E-03, -9.7778250562911883E-04, -8.5568590196649329E-05, -1.0954436997680335E-06};
    constexpr FLT c4[] = {8.3014334976692652E-07, 3.4045323043173907E-05, 2.1660980714121198E-04, 1.7421792587401570E-04, -9.2118064021565335E-04, -9.7597008655077061E-04, 1.4714477548412753E-03, 1.4714477548412239E-03, -9.7597008655075674E-04, -9.2118064021558829E-04, 1.7421792587401792E-04, 2.1660980714121350E-04, 3.4045323043173961E-05, 8.3014334976713193E-07};
    constexpr FLT c5[] = {4.3045614796951603E-07, 8.9716871724549834E-06, 2.3377513570379932E-05, -5.5213296993551241E-05, -1.2391624765756808E-04, 1.5869855385552151E-04, 2.1530382494143235E-04, -2.1530382494149448E-04, -1.5869855385556634E-04, 1.2391624765755097E-04, 5.5213296993546240E-05, -2.3377513570381768E-05, -8.9716871724550257E-06, -4.3045614796933741E-07};
    constexpr FLT c6[] = {1.5611302559652602E-07, 1.4859455506706615E-06, -8.5826557923829850E-07, -1.1616353402592116E-05, 8.0333594878813938E-06, 2.8616079443283100E-05, -2.5816776957767652E-05, -2.5816776957766372E-05, 2.8616079443288531E-05, 8.0333594878547106E-06, -1.1616353402592575E-05, -8.5826557923815948E-07, 1.4859455506706291E-06, 1.5611302559670753E-07};
    constexpr FLT c7[] = {3.9336515129721677E-08, 1.1257285216180971E-07, -6.2406181937583209E-07, -2.6873173854847655E-07, 2.8292088258418352E-06, -1.4598715517537821E-06, -4.0212462691065446E-06, 4.0212462690602856E-06, 1.4598715517232874E-06, -2.8292088259432636E-06, 2.6873173854950209E-07, 6.2406181937597503E-07, -1.1257285216174927E-07, -3.9336515129545587E-08};
    constexpr FLT c8[] = {6.5041263396091917E-09, -9.9149367808629461E-09, -6.6845758889170809E-08, 1.6286641993610469E-07, 5.8507874918728810E-08, -4.7688540980072603E-07, 3.2559878510565369E-07, 3.2559878507638357E-07, -4.7688540979996857E-07, 5.8507875007784286E-08, 1.6286641992908438E-07, -6.6845758890639352E-08, -9.9149367809316500E-09, 6.5041263397792741E-09};
    constexpr FLT c9[] = {5.5138523621066947E-10, -3.4792607432875080E-09, 2.1621109678029579E-09, 1.6802313211955381E-08, -3.4440501485590873E-08, 3.6408052172286002E-09, 5.4274262273949518E-08, -5.4274262358371372E-08, -3.6408052172286002E-09, 3.4440501466215365E-08, -1.6802313212993354E-08, -2.1621109678462066E-09, 3.4792607432848052E-09, -5.5138523606411313E-10};
    constexpr FLT c10[] = {-2.3785683828684552E-11, -2.9453404126079047E-10, 1.0997757891923789E-09, -8.6020468735967815E-10, -2.2974593186348686E-09, 5.5064436653871647E-09, -3.1470907051089416E-09, -3.1470906717984420E-09, 5.5064436660942271E-09, -2.2974593374898691E-09, -8.6020469175917524E-10, 1.0997757873068796E-09, -2.9453404132707798E-10, -2.3785683688860141E-11};
    constexpr FLT c11[] = {-1.2240623323305377E-11, 1.4269095094657965E-11, 6.3689196104514816E-11, -2.3523038822634284E-10, 2.6546833799145628E-10, 9.4137178072301786E-11, -5.6473803862315189E-10, 5.6473798283135854E-10, -9.4137201354365380E-11, -2.6546836658830022E-10, 2.3523038971696211E-10, -6.3689194667129632E-11, -1.4269094983749057E-11, 1.2240623457522869E-11};
    constexpr FLT c12[] = {-1.4791529083698136E-12, 4.8147158489874929E-12, -7.1247151365331094E-12, -3.7363553968273554E-12, 3.0923952752421019E-11, -4.7998353757330678E-11, 2.4268818966431809E-11, 2.4268806716180134E-11, -4.7998370091044259E-11, 3.0923989503259558E-11, -3.7363621599957160E-12, -7.1247176727239074E-12, 4.8147157293535152E-12, -1.4791527916039239E-12};
    for (int i=0; i<14; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i]))))))))))));
  } else if constexpr (w==15) {
    constexpr FLT c0[] = {2.3183302143948842E-08, 1.7202745817468652E-05, 9.2668857465754795E-04, 1.4607490553401931E-02, 1.0130044556641114E-01, 3.7041488405244660E-01, 7.8279781886019173E-01, 1.0000000000000009E+00, 7.8279781886019184E-01, 3.7041488405244710E-01, 1.0130044556641132E-01, 1.4607490553401952E-02, 9.2668857465754849E-04, 1.7202745817468621E-05, 2.3183302143948631E-08};
    constexpr FLT c1[] = {1.1019919454791570E-07, 4.1938159428224099E-05, 1.5154850601194960E-03, 1.6839357628952667E-02, 8.0835952724673157E-02, 1.8739074372244086E-01, 1.9255567517255706E-01, -1.2727752801547544E-16, -1.9255567517255720E-01, -1.8739074372244102E-01, -8.0835952724673296E-02, -1.6839357628952695E-02, -1.5154850601194960E-03, -4.1938159428224085E-05, -1.1019919454791562E-07};
    constexpr FLT c2[] = {2.3137327105312783E-07, 4.6266060425611198E-05, 1.1028009511991968E-03, 8.2352859806754733E-03, 2.4233386066663389E-02, 2.2182889945939421E-02, -2.5327411650385150E-02, -6.0946897479642458E-02, -2.5327411650385059E-02, 2.2182889945939335E-02, 2.4233386066663410E-02, 8.2352859806754854E-03, 1.1028009511991972E-03, 4.6266060425611211E-05, 2.3137327105312794E-07};
    constexpr FLT c3[] = {2.8457821671573279E-07, 3.0427184404092306E-05, 4.6337319534911855E-04, 2.1072304367244915E-03, 2.4342755210407414E-03, -4.2814200474568876E-03, -9.6703299158782969E-03, 3.9043785854177514E-17, 9.6703299158782969E-03, 4.2814200474568772E-03, -2.4342755210407176E-03, -2.1072304367244893E-03, -4.6337319534911855E-04, -3.0427184404092299E-05, -2.8457821671573274E-07};
    constexpr FLT c4[] = {2.2919642176438710E-07, 1.3183839322479992E-05, 1.2030953406839326E-04, 2.4905754342428356E-04, -3.4193403196994986E-04, -1.1551611179404832E-03, 2.1954335627552253E-04, 1.7895433812200067E-03, 2.1954335627561873E-04, -1.1551611179404482E-03, -3.4193403196996477E-04, 2.4905754342428507E-04, 1.2030953406839333E-04, 1.3183839322479986E-05, 2.2919642176438702E-07};
    constexpr FLT c5[] = {1.2779800356186581E-07, 3.8997040140349194E-06, 1.8264189394307068E-05, -8.3632912035152412E-06, -1.0687544349168481E-04, 2.2123224043759331E-06, 2.3404180714502455E-04, -8.9283573250376576E-17, -2.3404180714513341E-04, -2.2123224043065501E-06, 1.0687544349165996E-04, 8.3632912035017057E-06, -1.8264189394307319E-05, -3.8997040140349262E-06, -1.2779800356186586E-07};
    constexpr FLT c6[] = {5.0693377499403665E-08, 7.7594237801399526E-07, 9.4933483676662116E-07, -6.6987818302435208E-06, -4.5889941143450991E-06, 2.2647907184643285E-05, 3.7412856034685821E-06, -3.3754692339572014E-05, 3.7412856034970381E-06, 2.2647907184613792E-05, -4.5889941143207909E-06, -6.6987818302368428E-06, 9.4933483676682646E-07, 7.7594237801399970E-07, 5.0693377499403770E-08};
    constexpr FLT c7[] = {1.4373673262756888E-08, 9.2554419735730244E-08, -2.0417866965606358E-07, -6.8820764686333942E-07, 1.4165168644143546E-06, 1.2531774951245720E-06, -3.6383191328704321E-06, -2.0897699832877811E-17, 3.6383191329551320E-06, -1.2531774953500551E-06, -1.4165168644039183E-06, 6.8820764685736064E-07, 2.0417866965590807E-07, -9.2554419735735446E-08, -1.4373673262756828E-08};
    constexpr FLT c8[] = {2.8405432421064975E-09, 2.6648052024114868E-09, -4.5328290134560965E-08, 3.2089634829231624E-08, 1.7241593347641002E-07, -2.5816631652190980E-07, -1.3664009514358830E-07, 4.6017883222989653E-07, -1.3664009512350994E-07, -2.5816631659332659E-07, 1.7241593342393075E-07, 3.2089634833589152E-08, -4.5328290134813698E-08, 2.6648052024069750E-09, 2.8405432421063999E-09};
    constexpr FLT c9[] = {3.5447644664513494E-10, -1.1390658479693891E-09, -2.4324028602392776E-09, 1.2152005526514109E-08, -7.1102518507904692E-09, -2.5878341876005089E-08, 4.0855407136706484E-08, -5.9210554646947549E-17, -4.0855407178225432E-08, 2.5878341947971261E-08, 7.1102518757018364E-09, -1.2152005536547854E-08, 2.4324028600230332E-09, 1.1390658479612798E-09, -3.5447644664519832E-10};
    constexpr FLT c10[] = {1.6106092880537325E-11, -1.9612809867698403E-10, 3.3667881349219601E-10, 5.4740705595869105E-10, -2.3219918283669447E-09, 1.8783264163278577E-09, 2.1531914277141704E-09, -4.8374639764226820E-09, 2.1531914717091667E-09, 1.8783263625911151E-09, -2.3219918478504417E-09, 5.4740705910119197E-10, 3.3667881361003942E-10, -1.9612809867146024E-10, 1.6106092880601503E-11};
    constexpr FLT c11[] = {-2.9809392327917833E-12, -8.3268200023262531E-12, 5.7687950510146423E-11, -9.1929196737224722E-11, -3.9289932155730767E-11, 3.0713727283761530E-10, -3.5332673786726851E-10, -2.2557302724000076E-17, 3.5332680970097469E-10, -3.0713736397839930E-10, 3.9289960867914983E-11, 9.1929193649511812E-11, -5.7687950740837273E-11, 8.3268200012169312E-12, 2.9809392328567880E-12};
    constexpr FLT c12[] = {-6.7275763607221558E-13, 1.4037883829462834E-12, 1.0122749261648481E-12, -1.0507010154740660E-11, 1.9186628665524953E-11, -7.9757821000062307E-12, -2.2999174722289432E-11, 4.0853175824354315E-11, -2.2999195139407817E-11, -7.9759168531799436E-12, 1.9186570476657097E-11, -1.0507008495839712E-11, 1.0122746789244087E-12, 1.4037883764654859E-12, -6.7275763614208155E-13};
    for (int i=0; i<15; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i]))))))))))));
  } else if constexpr (w==16) {
    constexpr FLT c0[] = {5.2012152104084216E-09, 5.0291159580938711E-06, 3.3201112337137893E-04, 6.3015433246683310E-03, 5.2427915343763398E-02, 2.3104762006593366E-01, 5.9521037322997195E-01, 9.4441119081353830E-01, 9.4441119081353853E-01, 5.9521037322997183E-01, 2.3104762006593366E-01, 5.2427915343763384E-02, 6.3015433246683319E-03, 3.3201112337137898E-04, 5.0291159580938651E-06, 5.2012152104083678E-09};
    constexpr FLT c1[] = {2.5620581163903688E-08, 1.2815874111792776E-05, 5.7471335914300616E-04, 7.8386860177525469E-03, 4.6638901641906920E-02, 1.3897554029141554E-01, 2.0773808644544120E-01, 1.0813440420918309E-01, -1.0813440420918333E-01, -2.0773808644544134E-01, -1.3897554029141557E-01, -4.6638901641906934E-02, -7.8386860177525487E-03, -5.7471335914300616E-04, -1.2815874111792776E-05, -2.5620581163903665E-08};
    constexpr FLT c2[] = {5.6049296769722354E-08, 1.4879146623074257E-05, 4.4787865139353375E-04, 4.2383440773521705E-03, 1.6624620601556186E-02, 2.6395394769117647E-02, 3.6740117889103615E-04, -4.8088574473126817E-02, -4.8088574473126838E-02, 3.6740117889102304E-04, 2.6395394769117623E-02, 1.6624620601556190E-02, 4.2383440773521705E-03, 4.4787865139353375E-04, 1.4879146623074262E-05, 5.6049296769722407E-08};
    constexpr FLT c3[] = {7.2283166867263396E-08, 1.0391634193778177E-05, 2.0529674430143889E-04, 1.2618687081127943E-03, 2.6256301814801125E-03, -5.5040645592547600E-04, -7.8709464111364428E-03, -5.7657980103486724E-03, 5.7657980103487556E-03, 7.8709464111365469E-03, 5.5040645592550766E-04, -2.6256301814801082E-03, -1.2618687081127936E-03, -2.0529674430143870E-04, -1.0391634193778174E-05, -7.2283166867263369E-08};
    constexpr FLT c4[] = {6.1501023800531295E-08, 4.8443034242391141E-06, 6.0167136036954428E-05, 2.0573318254802012E-04, 1.2811955521411533E-05, -8.3782209201443785E-04, -6.2669687707138247E-04, 1.1809008871738562E-03, 1.1809008871738887E-03, -6.2669687707137044E-04, -8.3782209201442733E-04, 1.2811955521412302E-05, 2.0573318254801866E-04, 6.0167136036954374E-05, 4.8443034242391115E-06, 6.1501023800531295E-08};
    constexpr FLT c5[] = {3.6571939291734554E-08, 1.5742222553115364E-06, 1.1217451065775625E-05, 1.0668471374316040E-05, -6.0694020243076541E-05, -7.4268888177684097E-05, 1.3567546096376892E-04, 1.4875477215024236E-04, -1.4875477215050417E-04, -1.3567546096388268E-04, 7.4268888177625266E-05, 6.0694020243062074E-05, -1.0668471374318224E-05, -1.1217451065775730E-05, -1.5742222553115388E-06, -3.6571939291734560E-08};
    constexpr FLT c6[] = {1.5672684443241253E-08, 3.5812571134852896E-07, 1.1292168823202123E-06, -2.5215449854190674E-06, -7.6275609266474487E-06, 9.3973092319731781E-06, 1.7891569285056421E-05, -1.8642776809505442E-05, -1.8642776809471432E-05, 1.7891569285033097E-05, 9.3973092319544841E-06, -7.6275609266469057E-06, -2.5215449854189081E-06, 1.1292168823202494E-06, 3.5812571134853351E-07, 1.5672684443241289E-08};
    constexpr FLT c7[] = {4.8970459380161428E-09, 5.4304148291624194E-08, -1.0066736763072382E-08, -5.3239387743769898E-07, 2.2987809872759821E-07, 1.8048974519708698E-06, -1.3449315565748933E-06, -2.4760016204359734E-06, 2.4760016204603713E-06, 1.3449315565910754E-06, -1.8048974519599853E-06, -2.2987809872813671E-07, 5.3239387743785653E-07, 1.0066736763187962E-08, -5.4304148291621945E-08, -4.8970459380161354E-09};
    constexpr FLT c8[] = {1.1055703983904660E-09, 4.3691209554212191E-09, -2.0201061499396576E-08, -2.3275033896957558E-08, 1.2633562932116967E-07, -2.2021804058048667E-08, -2.7912172398215538E-07, 2.1280289570094432E-07, 2.1280289560039370E-07, -2.7912172401993432E-07, -2.2021804058375159E-08, 1.2633562931645146E-07, -2.3275033899474533E-08, -2.0201061499488096E-08, 4.3691209554177036E-09, 1.1055703983904669E-09};
    constexpr FLT c9[] = {1.7210848751138681E-10, -1.3819378018658845E-10, -2.4707116696395422E-09, 4.6626394237380811E-09, 6.2513494800647907E-09, -2.2225751680364230E-08, 7.2716681499015802E-09, 2.9914504847745958E-08, -2.9914504929399881E-08, -7.2716682190998235E-09, 2.2225751651300968E-08, -6.2513494835247027E-09, -4.6626394241705700E-09, 2.4707116695422323E-09, 1.3819378018447668E-10, -1.7210848751140263E-10};
    constexpr FLT c10[] = {1.5548426850855142E-11, -8.2967690041189158E-11, -2.0776280294645870E-11, 6.5818716237227536E-10, -9.7473366701243995E-10, -7.2114134107195186E-10, 2.9974008482669047E-09, -1.8729408099935154E-09, -1.8729408458180050E-09, 2.9974008300895111E-09, -7.2114135112795265E-10, -9.7473366984068834E-10, 6.5818716150808865E-10, -2.0776280304466481E-11, -8.2967690039194425E-11, 1.5548426850879734E-11};
    constexpr FLT c11[] = {1.7715918249318497E-14, -8.7094275472987195E-12, 2.5402078659077626E-11, 5.6643185861776250E-13, -1.1273397189051321E-10, 1.7831200266308735E-10, 2.2125788695759232E-13, -2.7985820464955105E-10, 2.7985821061203020E-10, -2.2125561553264423E-13, -1.7831201299095762E-10, 1.1273397203247594E-10, -5.6643244421784287E-13, -2.5402078579222992E-11, 8.7094275478531680E-12, -1.7715918246051124E-14};
    constexpr FLT c12[] = {-2.1496737416796769E-13, -2.2214973169845399E-14, 2.3291736435064423E-12, -5.9732908832747121E-12, 3.0556773879593299E-12, 1.1858139990185910E-11, -2.4316386830832370E-11, 1.3235593905851255E-11, 1.3235467319571833E-11, -2.4316433790261075E-11, 1.1858129781598945E-11, 3.0556712628198899E-12, -5.9732929568879531E-12, 2.3291735079222313E-12, -2.2214976659196139E-14, -2.1496737416785529E-13};
    constexpr FLT c13[] = {-2.3198933267726957E-14, 8.4680084110917159E-14, -5.5120422834884429E-14, -3.4224862020134189E-13, 1.0093466820639831E-12, -9.9670059417301577E-13, -4.1953332933742669E-13, 2.1120539454092368E-12, -2.1120647488999610E-12, 4.1950459318924021E-13, 9.9668795371011618E-13, -1.0093471667352018E-12, 3.4224875797881982E-13, 5.5120389367396242E-14, -8.4680084697278088E-14, 2.3198933261276072E-14};
    for (int i=0; i<16; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i] + z*(c13[i])))))))))))));
  } else
    printf("width not implemented!\n");
