/* --------------------------------------------------- */
/* Automatically generated by mwrap                    */
/* --------------------------------------------------- */

/* Code generated by mwrap 1.1 */
/*
  Copyright statement for mwrap:

  mwrap -- MEX file generation for MATLAB and Octave
  Copyright (c) 2007-2008 David Bindel

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  You may distribute a work that contains part or all of the source code
  generated by mwrap under the terms of your choice.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include <stdio.h>
#include <string.h>
#include <stddef.h>

#include <mex.h>

#if MX_HAS_INTERLEAVED_COMPLEX
#include <matrix.h>
#endif


/*
 * Records for call profile.
 */
int* mexprofrecord_= NULL;

double mxWrapGetChar(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxCHAR_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid char argument";
        return 0;
    }
    return (char) (*mxGetChars(a));
}

/*
 * Support routines for copying data into and out of the MEX stubs, R2018a
 */

#if MX_HAS_INTERLEAVED_COMPLEX

void* mxWrapGetP(const mxArray* a, const char* fmt, const char** e)
{
    void* p = NULL;
#ifdef R2008OO
    mxArray* ap;
#endif
    if (mxGetClassID(a) == mxDOUBLE_CLASS && mxIsComplex(a) )
    {
        if( mxGetM(a)*mxGetN(a) == 1 && (*mxGetComplexDoubles(a)).real == 0 )
        return NULL;
    }
    if (mxGetClassID(a) == mxDOUBLE_CLASS && !mxIsComplex(a) )
    {
        if( mxGetM(a)*mxGetN(a) == 1 && *mxGetDoubles(a) == 0)
        return NULL;
    }
    if (mxIsChar(a)) {
        char pbuf[128];
        mxGetString(a, pbuf, sizeof(pbuf));
        sscanf(pbuf, fmt, &p);
    }
#ifdef R2008OO
    else if (ap = mxGetProperty(a, 0, "mwptr")) {
        return mxWrapGetP(ap, fmt, e);
    }
#endif
    if (p == 0)
        *e = "Invalid pointer";
    return p;
}

mxArray* mxWrapCreateP(void* p, const char* fmt)
{
    if (p == 0) {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetDoubles(z) = 0;
        return z;
    } else {
        char pbuf[128];
        sprintf(pbuf, fmt, p);
        return mxCreateString(pbuf);
    }
}

mxArray* mxWrapStrncpy(const char* s)
{
    if (s) {
        return mxCreateString(s);
    } else {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetDoubles(z) = 0;
        return z;
    }
}

char* mxWrapGetString(const mxArray* a, const char** e)
{
    char* s;
    mwSize slen;
    if (!a || (!mxIsChar(a) && mxGetM(a)*mxGetN(a) > 0)) {
        *e = "Invalid string argument";
        return NULL;
    }
    slen = mxGetM(a)*mxGetN(a) + 1;
    s = (char*) mxMalloc(slen);
    if (mxGetM(a)*mxGetN(a) == 0)
        *s = 0;
    else
        mxGetString(a, s, slen);
    return s;
}


double mxWrapGetScalar(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid scalar argument";
        return 0;
    }
    if( mxIsComplex(a) )
      return (double) (*mxGetComplexDoubles(a)).real;
    else
      return (double) (*mxGetDoubles(a));
}

#define mxWrapGetArrayDef(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    double* q; \
    mxComplexDouble* z; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument, mxDOUBLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexDoubles(a);	   \
	for (i = 0; i < arraylen; ++i)		\
	  *p++ = (T) (*z++).real;			\
      } \
    else \
      {				   \
	q = mxGetDoubles(a);	   \
	for (i = 0; i < arraylen; ++i)		\
	  *p++ = (T) (*q++);			\
      } \
    return array; \
}


#define mxWrapCopyDef(func, T) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    double* p;	\
    mxComplexDouble* z; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexDoubles(a);	   \
	for (i = 0; i < n; ++i)		\
	  (*z++).real = (double) *q++;	\
	  (*z++).imag = 0;	\
      } \
    else \
      {				   \
	p = mxGetDoubles(a);	   \
	for (i = 0; i < n; ++i)		\
	  *p++ = (double) *q++;		\
      } \
}


#define mxWrapReturnDef(func, T) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    double* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxREAL); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxREAL); \
        p = mxGetDoubles(a); \
        for (i = 0; i < m*n; ++i) \
	  *p++ = (double) *q++;	  \
        return a; \
    } \
}


#define mxWrapGetScalarZDef(func, T, ZT, setz)	\
void func(T* z, const mxArray* a) \
{ \
    if( mxIsComplex(a) ) \
      { \
  setz(z, (ZT) (*mxGetComplexDoubles(a)).real, (ZT) (*mxGetComplexDoubles(a)).imag); \
      } \
    else \
      {				   \
  setz(z, (ZT) (*mxGetComplexDoubles(a)).real, (ZT) 0);	\
      } \
}


#define mxWrapGetArrayZDef(func, T, ZT, setz)      \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    double* q; \
    mxComplexDouble* z; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument, mxDOUBLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexDoubles(a);	   \
	for (i = 0; i < arraylen; ++i) {	\
	  setz(p, (ZT) (*z).real, (ZT) (*z).imag);	\
  	  ++p; ++z; }					\
      } \
    else \
      {				   \
	q = mxGetDoubles(a);	   \
	for (i = 0; i < arraylen; ++i)	{	\
	  setz(p, (ZT) (*q), (ZT) 0 );		\
          ++p; ++q; }			\
      }						\
    return array; \
}


#define mxWrapCopyZDef(func, T, freal, fimag)	    \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    double* p;	\
    mxComplexDouble* z; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexDoubles(a);	   \
	for (i = 0; i < n; ++i)	{		\
          (*z).real = freal(*q);			\
	  (*z).imag = fimag(*q);			\
	  ++z; ++q; 	}			\
      } \
    else \
      {				   \
	p = mxGetDoubles(a);	   \
	for (i = 0; i < n; ++i)		\
	  *p++ = freal(*q++);		\
      } \
}


#define mxWrapReturnZDef(func, T, freal, fimag)	      \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    mxComplexDouble* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxCOMPLEX); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxCOMPLEX); \
        p = mxGetComplexDoubles(a); \
        for (i = 0; i < m*n; ++i) {	  \
          (*p).real = freal(*q);			\
	  (*p).imag = fimag(*q);			\
	  ++p; ++q; 	}			\
        return a; \
    } \
}






void* mxWrapGetP_single(const mxArray* a, const char* fmt, const char** e)
{
    void* p = NULL;
#ifdef R2008OO
    mxArray* ap;
#endif
    if (mxGetClassID(a) == mxSINGLE_CLASS && mxIsComplex(a) )
    {
        if( mxGetM(a)*mxGetN(a) == 1 && (*mxGetComplexSingles(a)).real == 0 )
        return NULL;
    }
    if (mxGetClassID(a) == mxSINGLE_CLASS && !mxIsComplex(a) )
    {
        if( mxGetM(a)*mxGetN(a) == 1 && *mxGetSingles(a) == 0)
        return NULL;
    }
    if (mxIsChar(a)) {
        char pbuf[128];
        mxGetString(a, pbuf, sizeof(pbuf));
        sscanf(pbuf, fmt, &p);
    }
#ifdef R2008OO
    else if (ap = mxGetProperty(a, 0, "mwptr")) {
        return mxWrapGetP(ap, fmt, e);
    }
#endif
    if (p == 0)
        *e = "Invalid pointer";
    return p;
}

mxArray* mxWrapCreateP_single(void* p, const char* fmt)
{
    if (p == 0) {
        mxArray* z = mxCreateNumericMatrix(1,1, mxSINGLE_CLASS, mxREAL);
        *mxGetSingles(z) = 0;
        return z;
    } else {
        char pbuf[128];
        sprintf(pbuf, fmt, p);
        return mxCreateString(pbuf);
    }
}

mxArray* mxWrapStrncpy_single(const char* s)
{
    if (s) {
        return mxCreateString(s);
    } else {
        mxArray* z = mxCreateNumericMatrix(1,1, mxSINGLE_CLASS, mxREAL);
        *mxGetSingles(z) = 0;
        return z;
    }
}

float mxWrapGetScalar_single(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid scalar argument";
        return 0;
    }
    if( mxIsComplex(a) )
      return (float) (*mxGetComplexSingles(a)).real;
    else
      return (float) (*mxGetSingles(a));
}


char* mxWrapGetString_single(const mxArray* a, const char** e)
{
    char* s;
    mwSize slen;
    if (!a || (!mxIsChar(a) && mxGetM(a)*mxGetN(a) > 0)) {
        *e = "Invalid string argument";
        return NULL;
    }
    slen = mxGetM(a)*mxGetN(a) + 1;
    s = (char*) mxMalloc(slen);
    if (mxGetM(a)*mxGetN(a) == 0)
        *s = 0;
    else
        mxGetString(a, s, slen);
    return s;
}

#define mxWrapGetArrayDef_single(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    float* q; \
    mxComplexSingle* z; \
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS) { \
        *e = "Invalid array argument, mxSINGLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexSingles(a);	   \
	for (i = 0; i < arraylen; ++i)		\
	  *p++ = (T) (*z++).real;			\
      } \
    else \
      {				   \
	q = mxGetSingles(a);	   \
	for (i = 0; i < arraylen; ++i)		\
	  *p++ = (T) (*q++);			\
      } \
    return array; \
}


#define mxWrapCopyDef_single(func, T) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    float* p;	\
    mxComplexSingle* z; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexSingles(a);	   \
	for (i = 0; i < n; ++i)		\
	  (*z++).real = (float) *q++;	\
	  (*z++).imag = 0;	\
      } \
    else \
      {				   \
	p = mxGetSingles(a);	   \
	for (i = 0; i < n; ++i)		\
	  *p++ = (float) *q++;		\
      } \
}


#define mxWrapReturnDef_single(func, T) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    float* p; \
    if (!q) { \
        return mxCreateNumericMatrix(0,0, mxSINGLE_CLASS, mxREAL); \
    } else { \
        mxArray* a = mxCreateNumericMatrix(m,n, mxSINGLE_CLASS, mxREAL); \
        p = mxGetSingles(a); \
        for (i = 0; i < m*n; ++i) \
	  *p++ = (float) *q++;	  \
        return a; \
    } \
}


#define mxWrapGetScalarZDef_single(func, T, ZT, setz)	\
void func(T* z, const mxArray* a) \
{ \
    if( mxIsComplex(a) ) \
      { \
  setz(z, (ZT) (*mxGetComplexSingles(a)).real, (ZT) (*mxGetComplexSingles(a)).imag); \
      } \
    else \
      {				   \
  setz(z, (ZT) (*mxGetComplexSingles(a)).real, (ZT) 0);	\
      } \
}


#define mxWrapGetArrayZDef_single(func, T, ZT, setz)      \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    float* q; \
    mxComplexSingle* z; \
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS) { \
        *e = "Invalid array argument, mxSINGLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexSingles(a);	   \
	for (i = 0; i < arraylen; ++i) {	\
	  setz(p, (ZT) (*z).real, (ZT) (*z).imag);	\
  	  ++p; ++z; }					\
      } \
    else \
      {				   \
	q = mxGetSingles(a);	   \
	for (i = 0; i < arraylen; ++i)	{	\
	  setz(p, (ZT) (*q), (ZT) 0 );		\
          ++p; ++q; }			\
      }						\
    return array; \
}


#define mxWrapCopyZDef_single(func, T, freal, fimag)	    \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    float* p;	\
    mxComplexSingle* z; \
    if( mxIsComplex(a) ) \
      { \
	z = mxGetComplexSingles(a);	   \
	for (i = 0; i < n; ++i)	{		\
          (*z).real = freal(*q);			\
	  (*z).imag = fimag(*q);			\
	  ++z; ++q; 	}			\
      } \
    else \
      {				   \
	p = mxGetSingles(a);	   \
	for (i = 0; i < n; ++i)		\
	  *p++ = freal(*q++);		\
      } \
}


#define mxWrapReturnZDef_single(func, T, freal, fimag)	      \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    mxComplexSingle* p; \
    if (!q) { \
        return mxCreateNumericMatrix(0,0, mxSINGLE_CLASS, mxCOMPLEX); \
    } else { \
        mxArray* a = mxCreateNumericMatrix(m,n, mxSINGLE_CLASS, mxCOMPLEX); \
        p = mxGetComplexSingles(a); \
        for (i = 0; i < m*n; ++i) {	  \
          (*p).real = freal(*q);			\
	  (*p).imag = fimag(*q);			\
	  ++p; ++q; 	}			\
        return a; \
    } \
}



#else

/*
 * Support routines for copying data into and out of the MEX stubs, -R2017b
 */

void* mxWrapGetP(const mxArray* a, const char* fmt, const char** e)
{
    void* p = 0;
#ifdef R2008OO
    mxArray* ap;
#endif
    if (mxGetClassID(a) == mxDOUBLE_CLASS &&
        mxGetM(a)*mxGetN(a) == 1 && *mxGetPr(a) == 0)
        return p;
    if (mxIsChar(a)) {
        char pbuf[128];
        mxGetString(a, pbuf, sizeof(pbuf));
        sscanf(pbuf, fmt, &p);
    }
#ifdef R2008OO
    else if (ap = mxGetProperty(a, 0, "mwptr")) {
        return mxWrapGetP(ap, fmt, e);
    }
#endif
    if (p == 0)
        *e = "Invalid pointer";
    return p;
}

mxArray* mxWrapCreateP(void* p, const char* fmt)
{
    if (p == 0) {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetPr(z) = 0;
        return z;
    } else {
        char pbuf[128];
        sprintf(pbuf, fmt, p);
        return mxCreateString(pbuf);
    }
}

mxArray* mxWrapStrncpy(const char* s)
{
    if (s) {
        return mxCreateString(s);
    } else {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetPr(z) = 0;
        return z;
    }
}

double mxWrapGetScalar(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid scalar argument";
        return 0;
    }
    return *mxGetPr(a);
}

char* mxWrapGetString(const mxArray* a, const char** e)
{
    char* s;
    mwSize slen;
    if (!a || (!mxIsChar(a) && mxGetM(a)*mxGetN(a) > 0)) {
        *e = "Invalid string argument";
        return NULL;
    }
    slen = mxGetM(a)*mxGetN(a) + 1;
    s = (char*) mxMalloc(slen);
    if (mxGetM(a)*mxGetN(a) == 0)
        *s = 0;
    else
        mxGetString(a, s, slen);
    return s;
}


#define mxWrapGetArrayDef(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    double* q; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument, mxDOUBLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    q = mxGetPr(a); \
    for (i = 0; i < arraylen; ++i) \
        *p++ = (T) (*q++); \
    return array; \
}


#define mxWrapCopyDef(func, T) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    double* p = mxGetPr(a); \
    for (i = 0; i < n; ++i) \
        *p++ = *q++; \
}


#define mxWrapReturnDef(func, T) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    double* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxREAL); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxREAL); \
        p = mxGetPr(a); \
        for (i = 0; i < m*n; ++i) \
            *p++ = *q++; \
        return a; \
    } \
}


#define mxWrapGetScalarZDef(func, T, ZT, setz) \
void func(T* z, const mxArray* a) \
{ \
    double* pr = mxGetPr(a); \
    double* pi = mxGetPi(a); \
    setz(z, (ZT) *pr, (pi ? (ZT) *pi : (ZT) 0)); \
}


#define mxWrapGetArrayZDef(func, T, ZT, setz) \
T* func(const mxArray* a, const char** e) \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    double* qr; \
    double* qi; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument, mxDOUBLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    qr = mxGetPr(a); \
    qi = mxGetPi(a); \
    for (i = 0; i < arraylen; ++i) { \
        ZT val_qr = *qr++; \
        ZT val_qi = (qi ? (ZT) *qi++ : (ZT) 0); \
        setz(p, val_qr, val_qi); \
        ++p; \
    } \
    return array; \
}


#define mxWrapCopyZDef(func, T, real, imag) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    double* pr = mxGetPr(a); \
    double* pi = mxGetPi(a); \
    for (i = 0; i < n; ++i) { \
        *pr++ = real(*q); \
        *pi++ = imag(*q); \
        ++q; \
    } \
}


#define mxWrapReturnZDef(func, T, real, imag) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    double* pr; \
    double* pi; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxCOMPLEX); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxCOMPLEX); \
        pr = mxGetPr(a); \
        pi = mxGetPi(a); \
        for (i = 0; i < m*n; ++i) { \
            *pr++ = real(*q); \
            *pi++ = imag(*q); \
            ++q; \
        } \
        return a; \
    } \
}






void* mxWrapGetP_single(const mxArray* a, const char* fmt, const char** e)
{
    void* p = 0;
#ifdef R2008OO
    mxArray* ap;
#endif
    if (mxGetClassID(a) == mxSINGLE_CLASS &&
        mxGetM(a)*mxGetN(a) == 1 && *((float*)mxGetData(a)) == 0)
        return p;
    if (mxIsChar(a)) {
        char pbuf[128];
        mxGetString(a, pbuf, sizeof(pbuf));
        sscanf(pbuf, fmt, &p);
    }
#ifdef R2008OO
    else if (ap = mxGetProperty(a, 0, "mwptr")) {
        return mxWrapGetP(ap, fmt, e);
    }
#endif
    if (p == 0)
        *e = "Invalid pointer";
    return p;
}

mxArray* mxWrapCreateP_single(void* p, const char* fmt)
{
    if (p == 0) {
        mxArray* z = mxCreateNumericMatrix(1,1, mxSINGLE_CLASS, mxREAL);
        *((float*)mxGetData(z)) = 0;
        return z;
    } else {
        char pbuf[128];
        sprintf(pbuf, fmt, p);
        return mxCreateString(pbuf);
    }
}
mxArray* mxWrapStrncpy_single(const char* s)
{
    if (s) {
        return mxCreateString(s);
    } else {
        mxArray* z = mxCreateNumericMatrix(1,1, mxSINGLE_CLASS, mxREAL);
        *((float*)mxGetData(z)) = 0;
        return z;
    }
}

float mxWrapGetScalar_single(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid scalar argument";
        return 0;
    }
    return *((float*)mxGetData(a));
}

char* mxWrapGetString_single(const mxArray* a, const char** e)
{
    char* s;
    mwSize slen;
    if (!a || (!mxIsChar(a) && mxGetM(a)*mxGetN(a) > 0)) {
        *e = "Invalid string argument, mxSINGLE_CLASS expected";
        return NULL;
    }
    slen = mxGetM(a)*mxGetN(a) + 1;
    s = (char*) mxMalloc(slen);
    if (mxGetM(a)*mxGetN(a) == 0)
        *s = 0;
    else
        mxGetString(a, s, slen);
    return s;
}


#define mxWrapGetArrayDef_single(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    float* q; \
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS) { \
        *e = "Invalid array argument, mxSINGLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    q = (float*) mxGetData(a);	   \
    for (i = 0; i < arraylen; ++i) \
        *p++ = (T) (*q++); \
    return array; \
}


#define mxWrapCopyDef_single(func, T) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    float* p = (float*) mxGetData(a);		\
    for (i = 0; i < n; ++i) \
        *p++ = *q++; \
}


#define mxWrapReturnDef_single(func, T) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    float* p; \
    if (!q) { \
      return mxCreateNumericMatrix(0,0, mxSINGLE_CLASS, mxREAL); \
    } else { \
        mxArray* a = mxCreateNumericMatrix(m,n, mxSINGLE_CLASS, mxREAL);\
        p = (float*) mxGetData(a);				\
        for (i = 0; i < m*n; ++i) \
            *p++ = *q++; \
        return a; \
    } \
}


#define mxWrapGetScalarZDef_single(func, T, ZT, setz) \
void func(T* z, const mxArray* a) \
{ \
    float* pr = (float*) mxGetData(a);		\
    float* pi = (float*) mxGetImagData(a);		 \
    setz(z, (ZT) *pr, (pi ? (ZT) *pi : (ZT) 0)); \
}


#define mxWrapGetArrayZDef_single(func, T, ZT, setz) \
T* func(const mxArray* a, const char** e) \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    float* qr; \
    float* qi; \
    if (!a || mxGetClassID(a) != mxSINGLE_CLASS) { \
        *e = "Invalid array argument, mxSINGLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    qr = (float*) mxGetData(a);			\
    qi = (float*) mxGetImagData(a);			\
    for (i = 0; i < arraylen; ++i) { \
        ZT val_qr = *qr++; \
        ZT val_qi = (qi ? (ZT) *qi++ : (ZT) 0); \
        setz(p, val_qr, val_qi); \
        ++p; \
    } \
    return array; \
}


#define mxWrapCopyZDef_single(func, T, real, imag) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    float* pr = (float*) mxGetData(a);		\
    float* pi = (float*) mxGetImagData(a);		\
    for (i = 0; i < n; ++i) { \
        *pr++ = real(*q); \
        *pi++ = imag(*q); \
        ++q; \
    } \
}


#define mxWrapReturnZDef_single(func, T, real, imag) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    float* pr; \
    float* pi; \
    if (!q) { \
      return mxCreateNumericMatrix(0,0, mxSINGLE_CLASS, mxCOMPLEX); \
    } else { \
        mxArray* a = mxCreateNumericMatrix(m,n, mxSINGLE_CLASS, mxCOMPLEX);\
        pr = (float*) mxGetData(a);					\
        pi = (float*) mxGetImagData(a);					\
        for (i = 0; i < m*n; ++i) { \
            *pr++ = real(*q); \
            *pi++ = imag(*q); \
            ++q; \
        } \
        return a; \
    } \
}





#endif

#define mxWrapGetGPUArrayDef(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    double* q; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument, mxDOUBLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    q = mxGetPr(a); \
    for (i = 0; i < arraylen; ++i) \
        *p++ = (T) (*q++); \
    return array; \
}


#define mxWrapCopyGPUArrayDef(func, T) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    double* p = mxGetPr(a); \
    for (i = 0; i < n; ++i) \
        *p++ = *q++; \
}


#define mxWrapReturnGPUArrayDef(func, T) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    double* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxREAL); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxREAL); \
        p = mxGetPr(a); \
        for (i = 0; i < m*n; ++i) \
            *p++ = *q++; \
        return a; \
    } \
}

#define mxWrapReturnGPUArrayPDef(func, T) \
T* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    double* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxREAL); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxREAL); \
        p = mxGetPr(a); \
        for (i = 0; i < m*n; ++i) \
            *p++ = *q++; \
        return a; \
    } \
}

#define mxWrapGetGPUArrayDef_single(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    mwSize arraylen; \
    mwIndex i; \
    T* p; \
    double* q; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument, mxDOUBLE_CLASS expected"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    q = mxGetPr(a); \
    for (i = 0; i < arraylen; ++i) \
        *p++ = (T) (*q++); \
    return array; \
}


#define mxWrapCopyGPUArrayDef_single(func, T) \
void func(mxArray* a, const T* q, mwSize n) \
{ \
    mwIndex i; \
    double* p = mxGetPr(a); \
    for (i = 0; i < n; ++i) \
        *p++ = *q++; \
}


#define mxWrapReturnGPUArrayDef_single(func, T) \
mxArray* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    double* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxREAL); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxREAL); \
        p = mxGetPr(a); \
        for (i = 0; i < m*n; ++i) \
            *p++ = *q++; \
        return a; \
    } \
}

#define mxWrapReturnGPUArrayPDef_single(func, T) \
T* func(const T* q, mwSize m, mwSize n) \
{ \
    mwIndex i; \
    double* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxREAL); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxREAL); \
        p = mxGetPr(a); \
        for (i = 0; i < m*n; ++i) \
            *p++ = *q++; \
        return a; \
    } \
}

#include <gpu/mxGPUArray.h>

#include <cuComplex.h>

#include <complex>

typedef std::complex<double> dcomplex;
#define real_dcomplex(z) std::real(z)
#define imag_dcomplex(z) std::imag(z)
#define setz_dcomplex(z,r,i)  *z = dcomplex(r,i)

typedef std::complex<float> fcomplex;
#define real_fcomplex(z) std::real(z)
#define imag_fcomplex(z) std::imag(z)
#define setz_fcomplex(z,r,i)  *z = fcomplex(r,i)

 #include <cufinufft.h>
 #include <mex.h>
 #include <iostream>
 #include <cstring>
 #include <math.h>
 void copy_cufinufft_opts(const mxArray* om, cufinufft_opts *oc) {
   if(!mxIsStruct(om))
     mexErrMsgIdAndTxt("FINUFFT:inputNotStruct",
                       "copy_cufinufft_opts: opts input must be a structure.");
   mwIndex idx = 0;
   int ifield, nfields;
   const char **fname;
   nfields = mxGetNumberOfFields(om);
   fname = (const char**)mxCalloc(nfields, sizeof(*fname));
   for(ifield=0; ifield<nfields; ifield++) {
     fname[ifield] = mxGetFieldNameByNumber(om,ifield);
     if (strcmp(fname[ifield],"debug") == 0) {
       oc->debug = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else if (strcmp(fname[ifield],"gpu_sort") == 0) {
       oc->gpu_sort = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else if (strcmp(fname[ifield],"gpu_kerevalmeth") == 0) {
       oc->gpu_kerevalmeth = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else if (strcmp(fname[ifield],"gpu_spreadinterponly") == 0) {
       oc->gpu_spreadinterponly = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else if (strcmp(fname[ifield],"modeord") == 0) {
       oc->modeord = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else if (strcmp(fname[ifield],"upsampfac") == 0) {
       oc->upsampfac = (double)*mxGetPr(mxGetFieldByNumber(om,idx,ifield));
     }
     else if (strcmp(fname[ifield],"gpu_maxbatchsize") == 0) {
       oc->gpu_maxbatchsize = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else if (strcmp(fname[ifield],"gpu_maxsubprobsize") == 0) {
       oc->gpu_maxsubprobsize = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else if (strcmp(fname[ifield],"gpu_method") == 0) {
       oc->gpu_method = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else if (strcmp(fname[ifield],"gpu_binsizex") == 0) {
       oc->gpu_binsizex = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else if (strcmp(fname[ifield],"gpu_binsizey") == 0) {
       oc->gpu_binsizey = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else if (strcmp(fname[ifield],"gpu_binsizez") == 0) {
       oc->gpu_binsizez = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else if (strcmp(fname[ifield],"gpu_device_id") == 0) {
       oc->gpu_device_id = (int)round(*mxGetPr(mxGetFieldByNumber(om,idx,ifield)));
     }
     else
       continue;
   }
   mxFree(fname);
 }



/* Array copier definitions */
mxWrapGetArrayDef(mxWrapGetArray_bool, bool)
mxWrapCopyDef    (mxWrapCopy_bool,     bool)
mxWrapReturnDef  (mxWrapReturn_bool,   bool)
mxWrapGetArrayDef_single(mxWrapGetArray_single_bool, bool)
mxWrapCopyDef_single    (mxWrapCopy_single_bool,     bool)
mxWrapReturnDef_single  (mxWrapReturn_single_bool,   bool)
mxWrapGetGPUArrayDef(mxWrapGetGPUArray_bool, bool)
mxWrapCopyGPUArrayDef    (mxWrapCopyGPUArray_bool,     bool)
mxWrapReturnGPUArrayDef  (mxWrapReturnGPUArray_bool,   bool)
mxWrapGetGPUArrayDef_single(mxWrapGetGPUArray_single_bool, bool)
mxWrapCopyGPUArrayDef_single    (mxWrapGPUArrayCopy_single_bool,     bool)
mxWrapReturnGPUArrayDef_single  (mxWrapReturnGPUArray_single_bool,   bool)
mxWrapGetArrayDef(mxWrapGetArray_char, char)
mxWrapCopyDef    (mxWrapCopy_char,     char)
mxWrapReturnDef  (mxWrapReturn_char,   char)
mxWrapGetArrayDef_single(mxWrapGetArray_single_char, char)
mxWrapCopyDef_single    (mxWrapCopy_single_char,     char)
mxWrapReturnDef_single  (mxWrapReturn_single_char,   char)
mxWrapGetGPUArrayDef(mxWrapGetGPUArray_char, char)
mxWrapCopyGPUArrayDef    (mxWrapCopyGPUArray_char,     char)
mxWrapReturnGPUArrayDef  (mxWrapReturnGPUArray_char,   char)
mxWrapGetGPUArrayDef_single(mxWrapGetGPUArray_single_char, char)
mxWrapCopyGPUArrayDef_single    (mxWrapGPUArrayCopy_single_char,     char)
mxWrapReturnGPUArrayDef_single  (mxWrapReturnGPUArray_single_char,   char)
mxWrapGetArrayDef(mxWrapGetArray_double, double)
mxWrapCopyDef    (mxWrapCopy_double,     double)
mxWrapReturnDef  (mxWrapReturn_double,   double)
mxWrapGetArrayDef_single(mxWrapGetArray_single_double, double)
mxWrapCopyDef_single    (mxWrapCopy_single_double,     double)
mxWrapReturnDef_single  (mxWrapReturn_single_double,   double)
mxWrapGetGPUArrayDef(mxWrapGetGPUArray_double, double)
mxWrapCopyGPUArrayDef    (mxWrapCopyGPUArray_double,     double)
mxWrapReturnGPUArrayDef  (mxWrapReturnGPUArray_double,   double)
mxWrapGetGPUArrayDef_single(mxWrapGetGPUArray_single_double, double)
mxWrapCopyGPUArrayDef_single    (mxWrapGPUArrayCopy_single_double,     double)
mxWrapReturnGPUArrayDef_single  (mxWrapReturnGPUArray_single_double,   double)
mxWrapGetArrayDef(mxWrapGetArray_float, float)
mxWrapCopyDef    (mxWrapCopy_float,     float)
mxWrapReturnDef  (mxWrapReturn_float,   float)
mxWrapGetArrayDef_single(mxWrapGetArray_single_float, float)
mxWrapCopyDef_single    (mxWrapCopy_single_float,     float)
mxWrapReturnDef_single  (mxWrapReturn_single_float,   float)
mxWrapGetGPUArrayDef(mxWrapGetGPUArray_float, float)
mxWrapCopyGPUArrayDef    (mxWrapCopyGPUArray_float,     float)
mxWrapReturnGPUArrayDef  (mxWrapReturnGPUArray_float,   float)
mxWrapGetGPUArrayDef_single(mxWrapGetGPUArray_single_float, float)
mxWrapCopyGPUArrayDef_single    (mxWrapGPUArrayCopy_single_float,     float)
mxWrapReturnGPUArrayDef_single  (mxWrapReturnGPUArray_single_float,   float)
mxWrapGetArrayDef(mxWrapGetArray_int, int)
mxWrapCopyDef    (mxWrapCopy_int,     int)
mxWrapReturnDef  (mxWrapReturn_int,   int)
mxWrapGetArrayDef_single(mxWrapGetArray_single_int, int)
mxWrapCopyDef_single    (mxWrapCopy_single_int,     int)
mxWrapReturnDef_single  (mxWrapReturn_single_int,   int)
mxWrapGetGPUArrayDef(mxWrapGetGPUArray_int, int)
mxWrapCopyGPUArrayDef    (mxWrapCopyGPUArray_int,     int)
mxWrapReturnGPUArrayDef  (mxWrapReturnGPUArray_int,   int)
mxWrapGetGPUArrayDef_single(mxWrapGetGPUArray_single_int, int)
mxWrapCopyGPUArrayDef_single    (mxWrapGPUArrayCopy_single_int,     int)
mxWrapReturnGPUArrayDef_single  (mxWrapReturnGPUArray_single_int,   int)
mxWrapGetArrayDef(mxWrapGetArray_int64_t, int64_t)
mxWrapCopyDef    (mxWrapCopy_int64_t,     int64_t)
mxWrapReturnDef  (mxWrapReturn_int64_t,   int64_t)
mxWrapGetArrayDef_single(mxWrapGetArray_single_int64_t, int64_t)
mxWrapCopyDef_single    (mxWrapCopy_single_int64_t,     int64_t)
mxWrapReturnDef_single  (mxWrapReturn_single_int64_t,   int64_t)
mxWrapGetGPUArrayDef(mxWrapGetGPUArray_int64_t, int64_t)
mxWrapCopyGPUArrayDef    (mxWrapCopyGPUArray_int64_t,     int64_t)
mxWrapReturnGPUArrayDef  (mxWrapReturnGPUArray_int64_t,   int64_t)
mxWrapGetGPUArrayDef_single(mxWrapGetGPUArray_single_int64_t, int64_t)
mxWrapCopyGPUArrayDef_single    (mxWrapGPUArrayCopy_single_int64_t,     int64_t)
mxWrapReturnGPUArrayDef_single  (mxWrapReturnGPUArray_single_int64_t,   int64_t)
mxWrapGetArrayDef(mxWrapGetArray_long, long)
mxWrapCopyDef    (mxWrapCopy_long,     long)
mxWrapReturnDef  (mxWrapReturn_long,   long)
mxWrapGetArrayDef_single(mxWrapGetArray_single_long, long)
mxWrapCopyDef_single    (mxWrapCopy_single_long,     long)
mxWrapReturnDef_single  (mxWrapReturn_single_long,   long)
mxWrapGetGPUArrayDef(mxWrapGetGPUArray_long, long)
mxWrapCopyGPUArrayDef    (mxWrapCopyGPUArray_long,     long)
mxWrapReturnGPUArrayDef  (mxWrapReturnGPUArray_long,   long)
mxWrapGetGPUArrayDef_single(mxWrapGetGPUArray_single_long, long)
mxWrapCopyGPUArrayDef_single    (mxWrapGPUArrayCopy_single_long,     long)
mxWrapReturnGPUArrayDef_single  (mxWrapReturnGPUArray_single_long,   long)
mxWrapGetArrayDef(mxWrapGetArray_ptrdiff_t, ptrdiff_t)
mxWrapCopyDef    (mxWrapCopy_ptrdiff_t,     ptrdiff_t)
mxWrapReturnDef  (mxWrapReturn_ptrdiff_t,   ptrdiff_t)
mxWrapGetArrayDef_single(mxWrapGetArray_single_ptrdiff_t, ptrdiff_t)
mxWrapCopyDef_single    (mxWrapCopy_single_ptrdiff_t,     ptrdiff_t)
mxWrapReturnDef_single  (mxWrapReturn_single_ptrdiff_t,   ptrdiff_t)
mxWrapGetGPUArrayDef(mxWrapGetGPUArray_ptrdiff_t, ptrdiff_t)
mxWrapCopyGPUArrayDef    (mxWrapCopyGPUArray_ptrdiff_t,     ptrdiff_t)
mxWrapReturnGPUArrayDef  (mxWrapReturnGPUArray_ptrdiff_t,   ptrdiff_t)
mxWrapGetGPUArrayDef_single(mxWrapGetGPUArray_single_ptrdiff_t, ptrdiff_t)
mxWrapCopyGPUArrayDef_single    (mxWrapGPUArrayCopy_single_ptrdiff_t,     ptrdiff_t)
mxWrapReturnGPUArrayDef_single  (mxWrapReturnGPUArray_single_ptrdiff_t,   ptrdiff_t)
mxWrapGetArrayDef(mxWrapGetArray_short, short)
mxWrapCopyDef    (mxWrapCopy_short,     short)
mxWrapReturnDef  (mxWrapReturn_short,   short)
mxWrapGetArrayDef_single(mxWrapGetArray_single_short, short)
mxWrapCopyDef_single    (mxWrapCopy_single_short,     short)
mxWrapReturnDef_single  (mxWrapReturn_single_short,   short)
mxWrapGetGPUArrayDef(mxWrapGetGPUArray_short, short)
mxWrapCopyGPUArrayDef    (mxWrapCopyGPUArray_short,     short)
mxWrapReturnGPUArrayDef  (mxWrapReturnGPUArray_short,   short)
mxWrapGetGPUArrayDef_single(mxWrapGetGPUArray_single_short, short)
mxWrapCopyGPUArrayDef_single    (mxWrapGPUArrayCopy_single_short,     short)
mxWrapReturnGPUArrayDef_single  (mxWrapReturnGPUArray_single_short,   short)
mxWrapGetArrayDef(mxWrapGetArray_size_t, size_t)
mxWrapCopyDef    (mxWrapCopy_size_t,     size_t)
mxWrapReturnDef  (mxWrapReturn_size_t,   size_t)
mxWrapGetArrayDef_single(mxWrapGetArray_single_size_t, size_t)
mxWrapCopyDef_single    (mxWrapCopy_single_size_t,     size_t)
mxWrapReturnDef_single  (mxWrapReturn_single_size_t,   size_t)
mxWrapGetGPUArrayDef(mxWrapGetGPUArray_size_t, size_t)
mxWrapCopyGPUArrayDef    (mxWrapCopyGPUArray_size_t,     size_t)
mxWrapReturnGPUArrayDef  (mxWrapReturnGPUArray_size_t,   size_t)
mxWrapGetGPUArrayDef_single(mxWrapGetGPUArray_single_size_t, size_t)
mxWrapCopyGPUArrayDef_single    (mxWrapGPUArrayCopy_single_size_t,     size_t)
mxWrapReturnGPUArrayDef_single  (mxWrapReturnGPUArray_single_size_t,   size_t)
mxWrapGetScalarZDef(mxWrapGetScalar_fcomplex, fcomplex,
                    float, setz_fcomplex)
mxWrapGetArrayZDef (mxWrapGetArray_fcomplex, fcomplex,
                    float, setz_fcomplex)
mxWrapCopyZDef     (mxWrapCopy_fcomplex, fcomplex,
                    real_fcomplex, imag_fcomplex)
mxWrapReturnZDef   (mxWrapReturn_fcomplex, fcomplex,
                    real_fcomplex, imag_fcomplex)
mxWrapGetScalarZDef_single(mxWrapGetScalar_single_fcomplex, fcomplex,
                    float, setz_fcomplex)
mxWrapGetArrayZDef_single (mxWrapGetArray_single_fcomplex, fcomplex,
                    float, setz_fcomplex)
mxWrapCopyZDef_single     (mxWrapCopy_single_fcomplex, fcomplex,
                    real_fcomplex, imag_fcomplex)
mxWrapReturnZDef_single   (mxWrapReturn_single_fcomplex, fcomplex,
                    real_fcomplex, imag_fcomplex)
mxWrapGetScalarZDef(mxWrapGetScalar_dcomplex, dcomplex,
                    double, setz_dcomplex)
mxWrapGetArrayZDef (mxWrapGetArray_dcomplex, dcomplex,
                    double, setz_dcomplex)
mxWrapCopyZDef     (mxWrapCopy_dcomplex, dcomplex,
                    real_dcomplex, imag_dcomplex)
mxWrapReturnZDef   (mxWrapReturn_dcomplex, dcomplex,
                    real_dcomplex, imag_dcomplex)
mxWrapGetScalarZDef_single(mxWrapGetScalar_single_dcomplex, dcomplex,
                    double, setz_dcomplex)
mxWrapGetArrayZDef_single (mxWrapGetArray_single_dcomplex, dcomplex,
                    double, setz_dcomplex)
mxWrapCopyZDef_single     (mxWrapCopy_single_dcomplex, dcomplex,
                    real_dcomplex, imag_dcomplex)
mxWrapReturnZDef_single   (mxWrapReturn_single_dcomplex, dcomplex,
                    real_dcomplex, imag_dcomplex)

/* ---- cufinufft.mw: 153 ----
 * cufinufft_opts* o = new();
 */
static const char* stubids1_ = "c o cufinufft_opts* = new()";

void mexStub1(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufft_opts*  out0_=0; /* o          */

    if (mexprofrecord_)
        mexprofrecord_[1]++;
    out0_ = new cufinufft_opts();
    plhs[0] = mxWrapCreateP(out0_, "cufinufft_opts:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 155 ----
 * cufinufft_plan* p = new();
 */
static const char* stubids2_ = "c o cufinufft_plan* = new()";

void mexStub2(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufft_plan*  out0_=0; /* p          */

    if (mexprofrecord_)
        mexprofrecord_[2]++;
    out0_ = new cufinufft_plan();
    plhs[0] = mxWrapCreateP(out0_, "cufinufft_plan:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 156 ----
 * cufinufft_default_opts(cufinufft_opts* o);
 * Also at cufinufft.mw: 159
 */
static const char* stubids3_ = "cufinufft_default_opts(c i cufinufft_opts*)";

void mexStub3(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufft_opts*  in0_ =0; /* o          */

    in0_ = (cufinufft_opts*) mxWrapGetP(prhs[0], "cufinufft_opts:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[3]++;
    cufinufft_default_opts(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 158 ----
 * cufinufftf_plan* p = new();
 */
static const char* stubids4_ = "c o cufinufftf_plan* = new()";

void mexStub4(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufftf_plan*  out0_=0; /* p          */

    if (mexprofrecord_)
        mexprofrecord_[4]++;
    out0_ = new cufinufftf_plan();
    plhs[0] = mxWrapCreateP(out0_, "cufinufftf_plan:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 170 ----
 * copy_cufinufft_opts(mxArray opts, cufinufft_opts* o);
 */
static const char* stubids6_ = "copy_cufinufft_opts(c i mxArray, c i cufinufft_opts*)";

void mexStub6(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    const mxArray*  in0_;    /* opts       */
    cufinufft_opts*  in1_ =0; /* o          */

    in0_ = prhs[0];

    in1_ = (cufinufft_opts*) mxWrapGetP(prhs[1], "cufinufft_opts:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[6]++;
    copy_cufinufft_opts(in0_, in1_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 173 ----
 * int ier = cufinufft_makeplan(int type, int dim, int64_t[3] n_modes, int iflag, int n_trans, double tol, cufinufft_plan* plan, cufinufft_opts* o);
 */
static const char* stubids7_ = "c o int = cufinufft_makeplan(c i int, c i int, c i int64_t[x], c i int, c i int, c i double, c i cufinufft_plan*, c i cufinufft_opts*)";

void mexStub7(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* type       */
    int         in1_;    /* dim        */
    int64_t*    in2_ =0; /* n_modes    */
    int         in3_;    /* iflag      */
    int         in4_;    /* n_trans    */
    double      in5_;    /* tol        */
    cufinufft_plan*  in6_ =0; /* plan       */
    cufinufft_opts*  in7_ =0; /* o          */
    int         out0_;   /* ier        */
    mwSize      dim8_;   /* 3          */

    dim8_ = (mwSize) mxWrapGetScalar(prhs[8], &mw_err_txt_);

    if (mxGetM(prhs[2])*mxGetN(prhs[2]) != dim8_) {
        mw_err_txt_ = "Bad argument size: n_modes";        goto mw_err_label;
    }

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[1]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mxGetM(prhs[2])*mxGetN(prhs[2]) != 0) {
        in2_ = mxWrapGetArray_int64_t(prhs[2], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in2_ = NULL;

    if( mxGetClassID(prhs[3]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in3_ = (int) mxWrapGetScalar(prhs[3], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[4]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in4_ = (int) mxWrapGetScalar(prhs[4], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[5]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in5_ = (double) mxWrapGetScalar(prhs[5], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    in6_ = (cufinufft_plan*) mxWrapGetP(prhs[6], "cufinufft_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    in7_ = (cufinufft_opts*) mxWrapGetP(prhs[7], "cufinufft_opts:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[7]++;
    out0_ = cufinufft_makeplan(in0_, in1_, in2_, in3_, in4_, in5_, in6_, in7_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (in2_)  mxFree(in2_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 176 ----
 * int ier = cufinufftf_makeplan(int type, int dim, int64_t[3] n_modes, int iflag, int n_trans, float tol, cufinufftf_plan* plan, cufinufft_opts* o);
 */
static const char* stubids8_ = "c o int = cufinufftf_makeplan(c i int, c i int, c i int64_t[x], c i int, c i int, c i float, c i cufinufftf_plan*, c i cufinufft_opts*)";

void mexStub8(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* type       */
    int         in1_;    /* dim        */
    int64_t*    in2_ =0; /* n_modes    */
    int         in3_;    /* iflag      */
    int         in4_;    /* n_trans    */
    float       in5_;    /* tol        */
    cufinufftf_plan*  in6_ =0; /* plan       */
    cufinufft_opts*  in7_ =0; /* o          */
    int         out0_;   /* ier        */
    mwSize      dim8_;   /* 3          */

    dim8_ = (mwSize) mxWrapGetScalar(prhs[8], &mw_err_txt_);

    if (mxGetM(prhs[2])*mxGetN(prhs[2]) != dim8_) {
        mw_err_txt_ = "Bad argument size: n_modes";        goto mw_err_label;
    }

    if( mxGetClassID(prhs[0]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[1]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mxGetM(prhs[2])*mxGetN(prhs[2]) != 0) {
        in2_ = mxWrapGetArray_int64_t(prhs[2], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in2_ = NULL;

    if( mxGetClassID(prhs[3]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in3_ = (int) mxWrapGetScalar(prhs[3], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[4]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in4_ = (int) mxWrapGetScalar(prhs[4], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[5]) != mxSINGLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxSINGLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in5_ = (float) mxWrapGetScalar_single(prhs[5], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    in6_ = (cufinufftf_plan*) mxWrapGetP(prhs[6], "cufinufftf_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    in7_ = (cufinufft_opts*) mxWrapGetP(prhs[7], "cufinufft_opts:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[8]++;
    out0_ = cufinufftf_makeplan(in0_, in1_, in2_, in3_, in4_, in5_, in6_, in7_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (in2_)  mxFree(in2_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 178 ----
 * delete(cufinufft_opts* o);
 */
static const char* stubids9_ = "delete(c i cufinufft_opts*)";

void mexStub9(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufft_opts*  in0_ =0; /* o          */

    in0_ = (cufinufft_opts*) mxWrapGetP(prhs[0], "cufinufft_opts:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (mexprofrecord_)
        mexprofrecord_[9]++;
    delete(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 208 ----
 * int ier = cufinufft_setpts(cufinufft_plan plan, int nj, gpu double[] xj, gpu double[] yj, gpu double[] zj, int nk, gpu double[] s, gpu double[] t, gpu double[] u);
 */
static const char* stubids10_ = "c o int = cufinufft_setpts(c i cufinufft_plan, c i int, g i double[], g i double[], g i double[], c i int, g i double[], g i double[], g i double[])";

void mexStub10(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufft_plan*  in0_ =0; /* plan       */
    int         in1_;    /* nj         */
    double*     in2_ =0; /* xj         */
    mxGPUArray const *mxGPUArray_in2_ =0; /* xj         */
    double*     in3_ =0; /* yj         */
    mxGPUArray const *mxGPUArray_in3_ =0; /* yj         */
    double*     in4_ =0; /* zj         */
    mxGPUArray const *mxGPUArray_in4_ =0; /* zj         */
    int         in5_;    /* nk         */
    double*     in6_ =0; /* s          */
    mxGPUArray const *mxGPUArray_in6_ =0; /* s          */
    double*     in7_ =0; /* t          */
    mxGPUArray const *mxGPUArray_in7_ =0; /* t          */
    double*     in8_ =0; /* u          */
    mxGPUArray const *mxGPUArray_in8_ =0; /* u          */
    int         out0_;   /* ier        */

    in0_ = (cufinufft_plan*) mxWrapGetP(prhs[0], "cufinufft_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[1]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[2])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in2_ = mxGPUCreateFromMxArray(prhs[2]);
    in2_ = (double *)mxGPUGetDataReadOnly(mxGPUArray_in2_);

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[3])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in3_ = mxGPUCreateFromMxArray(prhs[3]);
    in3_ = (double *)mxGPUGetDataReadOnly(mxGPUArray_in3_);

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[4])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in4_ = mxGPUCreateFromMxArray(prhs[4]);
    in4_ = (double *)mxGPUGetDataReadOnly(mxGPUArray_in4_);

    if( mxGetClassID(prhs[5]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in5_ = (int) mxWrapGetScalar(prhs[5], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[6])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in6_ = mxGPUCreateFromMxArray(prhs[6]);
    in6_ = (double *)mxGPUGetDataReadOnly(mxGPUArray_in6_);

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[7])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in7_ = mxGPUCreateFromMxArray(prhs[7]);
    in7_ = (double *)mxGPUGetDataReadOnly(mxGPUArray_in7_);

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[8])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in8_ = mxGPUCreateFromMxArray(prhs[8]);
    in8_ = (double *)mxGPUGetDataReadOnly(mxGPUArray_in8_);

    if (!in0_) {
        mw_err_txt_ = "Argument plan cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[10]++;
    out0_ = cufinufft_setpts(*in0_, in1_, in2_, in3_, in4_, in5_, in6_, in7_, in8_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mxGPUArray_in2_)  mxGPUDestroyGPUArray(mxGPUArray_in2_);
    if (mxGPUArray_in3_)  mxGPUDestroyGPUArray(mxGPUArray_in3_);
    if (mxGPUArray_in4_)  mxGPUDestroyGPUArray(mxGPUArray_in4_);
    if (mxGPUArray_in6_)  mxGPUDestroyGPUArray(mxGPUArray_in6_);
    if (mxGPUArray_in7_)  mxGPUDestroyGPUArray(mxGPUArray_in7_);
    if (mxGPUArray_in8_)  mxGPUDestroyGPUArray(mxGPUArray_in8_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 210 ----
 * int ier = cufinufftf_setpts(cufinufftf_plan plan, int nj, gpu float[] xj, gpu float[] yj, gpu float[] zj, int nk, gpu float[] s, gpu float[] t, gpu float[] u);
 */
static const char* stubids11_ = "c o int = cufinufftf_setpts(c i cufinufftf_plan, c i int, g i float[], g i float[], g i float[], c i int, g i float[], g i float[], g i float[])";

void mexStub11(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufftf_plan*  in0_ =0; /* plan       */
    int         in1_;    /* nj         */
    float*      in2_ =0; /* xj         */
    mxGPUArray const *mxGPUArray_in2_ =0; /* xj         */
    float*      in3_ =0; /* yj         */
    mxGPUArray const *mxGPUArray_in3_ =0; /* yj         */
    float*      in4_ =0; /* zj         */
    mxGPUArray const *mxGPUArray_in4_ =0; /* zj         */
    int         in5_;    /* nk         */
    float*      in6_ =0; /* s          */
    mxGPUArray const *mxGPUArray_in6_ =0; /* s          */
    float*      in7_ =0; /* t          */
    mxGPUArray const *mxGPUArray_in7_ =0; /* t          */
    float*      in8_ =0; /* u          */
    mxGPUArray const *mxGPUArray_in8_ =0; /* u          */
    int         out0_;   /* ier        */

    in0_ = (cufinufftf_plan*) mxWrapGetP(prhs[0], "cufinufftf_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if( mxGetClassID(prhs[1]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[2])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in2_ = mxGPUCreateFromMxArray(prhs[2]);
    in2_ = (float *)mxGPUGetDataReadOnly(mxGPUArray_in2_);

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[3])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in3_ = mxGPUCreateFromMxArray(prhs[3]);
    in3_ = (float *)mxGPUGetDataReadOnly(mxGPUArray_in3_);

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[4])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in4_ = mxGPUCreateFromMxArray(prhs[4]);
    in4_ = (float *)mxGPUGetDataReadOnly(mxGPUArray_in4_);

    if( mxGetClassID(prhs[5]) != mxDOUBLE_CLASS )
        mw_err_txt_ = "Invalid scalar argument, mxDOUBLE_CLASS expected";
    if (mw_err_txt_) goto mw_err_label;
    in5_ = (int) mxWrapGetScalar(prhs[5], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[6])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in6_ = mxGPUCreateFromMxArray(prhs[6]);
    in6_ = (float *)mxGPUGetDataReadOnly(mxGPUArray_in6_);

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[7])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in7_ = mxGPUCreateFromMxArray(prhs[7]);
    in7_ = (float *)mxGPUGetDataReadOnly(mxGPUArray_in7_);

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[8])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in8_ = mxGPUCreateFromMxArray(prhs[8]);
    in8_ = (float *)mxGPUGetDataReadOnly(mxGPUArray_in8_);

    if (!in0_) {
        mw_err_txt_ = "Argument plan cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[11]++;
    out0_ = cufinufftf_setpts(*in0_, in1_, in2_, in3_, in4_, in5_, in6_, in7_, in8_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif

mw_err_label:
    if (mxGPUArray_in2_)  mxGPUDestroyGPUArray(mxGPUArray_in2_);
    if (mxGPUArray_in3_)  mxGPUDestroyGPUArray(mxGPUArray_in3_);
    if (mxGPUArray_in4_)  mxGPUDestroyGPUArray(mxGPUArray_in4_);
    if (mxGPUArray_in6_)  mxGPUDestroyGPUArray(mxGPUArray_in6_);
    if (mxGPUArray_in7_)  mxGPUDestroyGPUArray(mxGPUArray_in7_);
    if (mxGPUArray_in8_)  mxGPUDestroyGPUArray(mxGPUArray_in8_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 242 ----
 * int ier = cufinufft_execute(cufinufft_plan plan, gpu dcomplex[] data_in, gpu output dcomplex[ncoeffs] result);
 */
static const char* stubids12_ = "c o int = cufinufft_execute(c i cufinufft_plan, g i dcomplex[], g o dcomplex[x])";

void mexStub12(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufft_plan*  in0_ =0; /* plan       */
    cuDoubleComplex*  in1_ =0; /* data_in    */
    mxGPUArray const *mxGPUArray_in1_ =0; /* data_in    */
    int         out0_;   /* ier        */
    cuDoubleComplex*  out1_=0; /* result     */
    mxGPUArray *mxGPUArray_out1_ =0; /* result     */
    mwSize     gpu_outdims1_[2] = {0,0}; /* result     dims*/
    mwSize      dim2_;   /* ncoeffs    */

    dim2_ = (mwSize) mxWrapGetScalar(prhs[2], &mw_err_txt_);

    in0_ = (cufinufft_plan*) mxWrapGetP(prhs[0], "cufinufft_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[1])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in1_ = mxGPUCreateFromMxArray(prhs[1]);
    in1_ = (cuDoubleComplex *)mxGPUGetDataReadOnly(mxGPUArray_in1_);

    if (!in0_) {
        mw_err_txt_ = "Argument plan cannot be null";
        goto mw_err_label;
    }
    gpu_outdims1_[0] = dim2_;
    mxGPUArray_out1_ = mxGPUCreateGPUArray(1, gpu_outdims1_, mxDOUBLE_CLASS, mxCOMPLEX, MX_GPU_DO_NOT_INITIALIZE);
    out1_ = (cuDoubleComplex *)mxGPUGetData(mxGPUArray_out1_);

    if (mexprofrecord_)
        mexprofrecord_[12]++;
    out0_ = cufinufft_execute(*in0_, in1_, out1_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif
    plhs[1] = mxGPUCreateMxArrayOnGPU(mxGPUArray_out1_);

mw_err_label:
    if (mxGPUArray_in1_)  mxGPUDestroyGPUArray(mxGPUArray_in1_);
    if (mxGPUArray_out1_)  mxGPUDestroyGPUArray(mxGPUArray_out1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 244 ----
 * int ier = cufinufftf_execute(cufinufftf_plan plan, gpu fcomplex[] data_in, gpu output fcomplex[ncoeffs] result);
 */
static const char* stubids13_ = "c o int = cufinufftf_execute(c i cufinufftf_plan, g i fcomplex[], g o fcomplex[x])";

void mexStub13(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufftf_plan*  in0_ =0; /* plan       */
    cuFloatComplex*  in1_ =0; /* data_in    */
    mxGPUArray const *mxGPUArray_in1_ =0; /* data_in    */
    int         out0_;   /* ier        */
    cuFloatComplex*  out1_=0; /* result     */
    mxGPUArray *mxGPUArray_out1_ =0; /* result     */
    mwSize     gpu_outdims1_[2] = {0,0}; /* result     dims*/
    mwSize      dim2_;   /* ncoeffs    */

    dim2_ = (mwSize) mxWrapGetScalar(prhs[2], &mw_err_txt_);

    in0_ = (cufinufftf_plan*) mxWrapGetP(prhs[0], "cufinufftf_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[1])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in1_ = mxGPUCreateFromMxArray(prhs[1]);
    in1_ = (cuFloatComplex *)mxGPUGetDataReadOnly(mxGPUArray_in1_);

    if (!in0_) {
        mw_err_txt_ = "Argument plan cannot be null";
        goto mw_err_label;
    }
    gpu_outdims1_[0] = dim2_;
    mxGPUArray_out1_ = mxGPUCreateGPUArray(1, gpu_outdims1_, mxSINGLE_CLASS, mxCOMPLEX, MX_GPU_DO_NOT_INITIALIZE);
    out1_ = (cuFloatComplex *)mxGPUGetData(mxGPUArray_out1_);

    if (mexprofrecord_)
        mexprofrecord_[13]++;
    out0_ = cufinufftf_execute(*in0_, in1_, out1_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif
    plhs[1] = mxGPUCreateMxArrayOnGPU(mxGPUArray_out1_);

mw_err_label:
    if (mxGPUArray_in1_)  mxGPUDestroyGPUArray(mxGPUArray_in1_);
    if (mxGPUArray_out1_)  mxGPUDestroyGPUArray(mxGPUArray_out1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 250 ----
 * int ier = cufinufft_execute(cufinufft_plan plan, gpu output dcomplex[nj, n_trans] result, gpu dcomplex[] data_in);
 */
static const char* stubids14_ = "c o int = cufinufft_execute(c i cufinufft_plan, g o dcomplex[xx], g i dcomplex[])";

void mexStub14(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufft_plan*  in0_ =0; /* plan       */
    cuDoubleComplex*  in1_ =0; /* data_in    */
    mxGPUArray const *mxGPUArray_in1_ =0; /* data_in    */
    int         out0_;   /* ier        */
    cuDoubleComplex*  out1_=0; /* result     */
    mxGPUArray *mxGPUArray_out1_ =0; /* result     */
    mwSize     gpu_outdims1_[2] = {0,0}; /* result     dims*/
    mwSize      dim2_;   /* nj         */
    mwSize      dim3_;   /* n_trans    */

    dim2_ = (mwSize) mxWrapGetScalar(prhs[2], &mw_err_txt_);
    dim3_ = (mwSize) mxWrapGetScalar(prhs[3], &mw_err_txt_);

    in0_ = (cufinufft_plan*) mxWrapGetP(prhs[0], "cufinufft_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[1])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in1_ = mxGPUCreateFromMxArray(prhs[1]);
    in1_ = (cuDoubleComplex *)mxGPUGetDataReadOnly(mxGPUArray_in1_);

    if (!in0_) {
        mw_err_txt_ = "Argument plan cannot be null";
        goto mw_err_label;
    }
    gpu_outdims1_[0] = dim2_; gpu_outdims1_[1] = dim3_;
    mxGPUArray_out1_ = mxGPUCreateGPUArray(2, gpu_outdims1_, mxDOUBLE_CLASS, mxCOMPLEX, MX_GPU_DO_NOT_INITIALIZE);
    out1_ = (cuDoubleComplex *)mxGPUGetData(mxGPUArray_out1_);

    if (mexprofrecord_)
        mexprofrecord_[14]++;
    out0_ = cufinufft_execute(*in0_, out1_, in1_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif
    plhs[1] = mxGPUCreateMxArrayOnGPU(mxGPUArray_out1_);

mw_err_label:
    if (mxGPUArray_out1_)  mxGPUDestroyGPUArray(mxGPUArray_out1_);
    if (mxGPUArray_in1_)  mxGPUDestroyGPUArray(mxGPUArray_in1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 252 ----
 * int ier = cufinufftf_execute(cufinufftf_plan plan, gpu output fcomplex[nj, n_trans] result, gpu fcomplex[] data_in);
 */
static const char* stubids15_ = "c o int = cufinufftf_execute(c i cufinufftf_plan, g o fcomplex[xx], g i fcomplex[])";

void mexStub15(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufftf_plan*  in0_ =0; /* plan       */
    cuFloatComplex*  in1_ =0; /* data_in    */
    mxGPUArray const *mxGPUArray_in1_ =0; /* data_in    */
    int         out0_;   /* ier        */
    cuFloatComplex*  out1_=0; /* result     */
    mxGPUArray *mxGPUArray_out1_ =0; /* result     */
    mwSize     gpu_outdims1_[2] = {0,0}; /* result     dims*/
    mwSize      dim2_;   /* nj         */
    mwSize      dim3_;   /* n_trans    */

    dim2_ = (mwSize) mxWrapGetScalar(prhs[2], &mw_err_txt_);
    dim3_ = (mwSize) mxWrapGetScalar(prhs[3], &mw_err_txt_);

    in0_ = (cufinufftf_plan*) mxWrapGetP(prhs[0], "cufinufftf_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[1])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in1_ = mxGPUCreateFromMxArray(prhs[1]);
    in1_ = (cuFloatComplex *)mxGPUGetDataReadOnly(mxGPUArray_in1_);

    if (!in0_) {
        mw_err_txt_ = "Argument plan cannot be null";
        goto mw_err_label;
    }
    gpu_outdims1_[0] = dim2_; gpu_outdims1_[1] = dim3_;
    mxGPUArray_out1_ = mxGPUCreateGPUArray(2, gpu_outdims1_, mxSINGLE_CLASS, mxCOMPLEX, MX_GPU_DO_NOT_INITIALIZE);
    out1_ = (cuFloatComplex *)mxGPUGetData(mxGPUArray_out1_);

    if (mexprofrecord_)
        mexprofrecord_[15]++;
    out0_ = cufinufftf_execute(*in0_, out1_, in1_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif
    plhs[1] = mxGPUCreateMxArrayOnGPU(mxGPUArray_out1_);

mw_err_label:
    if (mxGPUArray_out1_)  mxGPUDestroyGPUArray(mxGPUArray_out1_);
    if (mxGPUArray_in1_)  mxGPUDestroyGPUArray(mxGPUArray_in1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 256 ----
 * int ier = cufinufft_execute(cufinufft_plan plan, gpu dcomplex[] data_in, gpu output dcomplex[nk, n_trans] result);
 */
static const char* stubids16_ = "c o int = cufinufft_execute(c i cufinufft_plan, g i dcomplex[], g o dcomplex[xx])";

void mexStub16(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufft_plan*  in0_ =0; /* plan       */
    cuDoubleComplex*  in1_ =0; /* data_in    */
    mxGPUArray const *mxGPUArray_in1_ =0; /* data_in    */
    int         out0_;   /* ier        */
    cuDoubleComplex*  out1_=0; /* result     */
    mxGPUArray *mxGPUArray_out1_ =0; /* result     */
    mwSize     gpu_outdims1_[2] = {0,0}; /* result     dims*/
    mwSize      dim2_;   /* nk         */
    mwSize      dim3_;   /* n_trans    */

    dim2_ = (mwSize) mxWrapGetScalar(prhs[2], &mw_err_txt_);
    dim3_ = (mwSize) mxWrapGetScalar(prhs[3], &mw_err_txt_);

    in0_ = (cufinufft_plan*) mxWrapGetP(prhs[0], "cufinufft_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[1])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in1_ = mxGPUCreateFromMxArray(prhs[1]);
    in1_ = (cuDoubleComplex *)mxGPUGetDataReadOnly(mxGPUArray_in1_);

    if (!in0_) {
        mw_err_txt_ = "Argument plan cannot be null";
        goto mw_err_label;
    }
    gpu_outdims1_[0] = dim2_; gpu_outdims1_[1] = dim3_;
    mxGPUArray_out1_ = mxGPUCreateGPUArray(2, gpu_outdims1_, mxDOUBLE_CLASS, mxCOMPLEX, MX_GPU_DO_NOT_INITIALIZE);
    out1_ = (cuDoubleComplex *)mxGPUGetData(mxGPUArray_out1_);

    if (mexprofrecord_)
        mexprofrecord_[16]++;
    out0_ = cufinufft_execute(*in0_, in1_, out1_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif
    plhs[1] = mxGPUCreateMxArrayOnGPU(mxGPUArray_out1_);

mw_err_label:
    if (mxGPUArray_in1_)  mxGPUDestroyGPUArray(mxGPUArray_in1_);
    if (mxGPUArray_out1_)  mxGPUDestroyGPUArray(mxGPUArray_out1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 258 ----
 * int ier = cufinufftf_execute(cufinufftf_plan plan, gpu fcomplex[] data_in, gpu output fcomplex[nk, n_trans] result);
 */
static const char* stubids17_ = "c o int = cufinufftf_execute(c i cufinufftf_plan, g i fcomplex[], g o fcomplex[xx])";

void mexStub17(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufftf_plan*  in0_ =0; /* plan       */
    cuFloatComplex*  in1_ =0; /* data_in    */
    mxGPUArray const *mxGPUArray_in1_ =0; /* data_in    */
    int         out0_;   /* ier        */
    cuFloatComplex*  out1_=0; /* result     */
    mxGPUArray *mxGPUArray_out1_ =0; /* result     */
    mwSize     gpu_outdims1_[2] = {0,0}; /* result     dims*/
    mwSize      dim2_;   /* nk         */
    mwSize      dim3_;   /* n_trans    */

    dim2_ = (mwSize) mxWrapGetScalar(prhs[2], &mw_err_txt_);
    dim3_ = (mwSize) mxWrapGetScalar(prhs[3], &mw_err_txt_);

    in0_ = (cufinufftf_plan*) mxWrapGetP(prhs[0], "cufinufftf_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    // extract input GPU array pointer
    if(!(mxIsGPUArray(prhs[1])))
        mw_err_txt_ = "Invalid array argument, gpuArray expected";
    if (mw_err_txt_) goto mw_err_label;
    mxGPUArray_in1_ = mxGPUCreateFromMxArray(prhs[1]);
    in1_ = (cuFloatComplex *)mxGPUGetDataReadOnly(mxGPUArray_in1_);

    if (!in0_) {
        mw_err_txt_ = "Argument plan cannot be null";
        goto mw_err_label;
    }
    gpu_outdims1_[0] = dim2_; gpu_outdims1_[1] = dim3_;
    mxGPUArray_out1_ = mxGPUCreateGPUArray(2, gpu_outdims1_, mxSINGLE_CLASS, mxCOMPLEX, MX_GPU_DO_NOT_INITIALIZE);
    out1_ = (cuFloatComplex *)mxGPUGetData(mxGPUArray_out1_);

    if (mexprofrecord_)
        mexprofrecord_[17]++;
    out0_ = cufinufftf_execute(*in0_, in1_, out1_);
#if MX_HAS_INTERLEAVED_COMPLEX
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetDoubles(plhs[0]) = out0_;
#else
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;
#endif
    plhs[1] = mxGPUCreateMxArrayOnGPU(mxGPUArray_out1_);

mw_err_label:
    if (mxGPUArray_in1_)  mxGPUDestroyGPUArray(mxGPUArray_in1_);
    if (mxGPUArray_out1_)  mxGPUDestroyGPUArray(mxGPUArray_out1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 270 ----
 * cufinufft_destroy(cufinufft_plan plan);
 */
static const char* stubids18_ = "cufinufft_destroy(c i cufinufft_plan)";

void mexStub18(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufft_plan*  in0_ =0; /* plan       */

    in0_ = (cufinufft_plan*) mxWrapGetP(prhs[0], "cufinufft_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument plan cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[18]++;
    cufinufft_destroy(*in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- cufinufft.mw: 272 ----
 * cufinufftf_destroy(cufinufftf_plan plan);
 */
static const char* stubids19_ = "cufinufftf_destroy(c i cufinufftf_plan)";

void mexStub19(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    cufinufftf_plan*  in0_ =0; /* plan       */

    in0_ = (cufinufftf_plan*) mxWrapGetP(prhs[0], "cufinufftf_plan:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;

    if (!in0_) {
        mw_err_txt_ = "Argument plan cannot be null";
        goto mw_err_label;
    }
    if (mexprofrecord_)
        mexprofrecord_[19]++;
    cufinufftf_destroy(*in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ----
 */
void mexFunction(int nlhs, mxArray* plhs[],
                 int nrhs, const mxArray* prhs[])
{
    char id[1024];
    if (nrhs == 0) {
        mexPrintf("Mex function installed\n");
        return;
    }


    mxInitGPU();

    if (mxGetString(prhs[0], id, sizeof(id)) != 0)
        mexErrMsgTxt("Identifier should be a string");
    else if (strcmp(id, stubids1_) == 0)
        mexStub1(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids2_) == 0)
        mexStub2(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids3_) == 0)
        mexStub3(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids4_) == 0)
        mexStub4(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids6_) == 0)
        mexStub6(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids7_) == 0)
        mexStub7(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids8_) == 0)
        mexStub8(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids9_) == 0)
        mexStub9(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids10_) == 0)
        mexStub10(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids11_) == 0)
        mexStub11(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids12_) == 0)
        mexStub12(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids13_) == 0)
        mexStub13(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids14_) == 0)
        mexStub14(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids15_) == 0)
        mexStub15(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids16_) == 0)
        mexStub16(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids17_) == 0)
        mexStub17(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids18_) == 0)
        mexStub18(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids19_) == 0)
        mexStub19(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, "*profile on*") == 0) {
        if (!mexprofrecord_) {
            mexprofrecord_ = (int*) malloc(20 * sizeof(int));
            mexLock();
        }
        memset(mexprofrecord_, 0, 20 * sizeof(int));
    } else if (strcmp(id, "*profile off*") == 0) {
        if (mexprofrecord_) {
            free(mexprofrecord_);
            mexUnlock();
        }
        mexprofrecord_ = NULL;
    } else if (strcmp(id, "*profile report*") == 0) {
        if (!mexprofrecord_)
            mexPrintf("Profiler inactive\n");
        mexPrintf("%d calls to cufinufft.mw:153\n", mexprofrecord_[1]);
        mexPrintf("%d calls to cufinufft.mw:155\n", mexprofrecord_[2]);
        mexPrintf("%d calls to cufinufft.mw:156 (cufinufft.mw:159)\n", mexprofrecord_[3]);
        mexPrintf("%d calls to cufinufft.mw:158\n", mexprofrecord_[4]);
        mexPrintf("%d calls to cufinufft.mw:170\n", mexprofrecord_[6]);
        mexPrintf("%d calls to cufinufft.mw:173\n", mexprofrecord_[7]);
        mexPrintf("%d calls to cufinufft.mw:176\n", mexprofrecord_[8]);
        mexPrintf("%d calls to cufinufft.mw:178\n", mexprofrecord_[9]);
        mexPrintf("%d calls to cufinufft.mw:208\n", mexprofrecord_[10]);
        mexPrintf("%d calls to cufinufft.mw:210\n", mexprofrecord_[11]);
        mexPrintf("%d calls to cufinufft.mw:242\n", mexprofrecord_[12]);
        mexPrintf("%d calls to cufinufft.mw:244\n", mexprofrecord_[13]);
        mexPrintf("%d calls to cufinufft.mw:250\n", mexprofrecord_[14]);
        mexPrintf("%d calls to cufinufft.mw:252\n", mexprofrecord_[15]);
        mexPrintf("%d calls to cufinufft.mw:256\n", mexprofrecord_[16]);
        mexPrintf("%d calls to cufinufft.mw:258\n", mexprofrecord_[17]);
        mexPrintf("%d calls to cufinufft.mw:270\n", mexprofrecord_[18]);
        mexPrintf("%d calls to cufinufft.mw:272\n", mexprofrecord_[19]);
    } else if (strcmp(id, "*profile log*") == 0) {
        FILE* logfp;
        if (nrhs != 2 || mxGetString(prhs[1], id, sizeof(id)) != 0)
            mexErrMsgTxt("Must have two string arguments");
        logfp = fopen(id, "w+");
        if (!logfp)
            mexErrMsgTxt("Cannot open log for output");
        if (!mexprofrecord_)
            fprintf(logfp, "Profiler inactive\n");
        fprintf(logfp, "%d calls to cufinufft.mw:153\n", mexprofrecord_[1]);
        fprintf(logfp, "%d calls to cufinufft.mw:155\n", mexprofrecord_[2]);
        fprintf(logfp, "%d calls to cufinufft.mw:156 (cufinufft.mw:159)\n", mexprofrecord_[3]);
        fprintf(logfp, "%d calls to cufinufft.mw:158\n", mexprofrecord_[4]);
        fprintf(logfp, "%d calls to cufinufft.mw:170\n", mexprofrecord_[6]);
        fprintf(logfp, "%d calls to cufinufft.mw:173\n", mexprofrecord_[7]);
        fprintf(logfp, "%d calls to cufinufft.mw:176\n", mexprofrecord_[8]);
        fprintf(logfp, "%d calls to cufinufft.mw:178\n", mexprofrecord_[9]);
        fprintf(logfp, "%d calls to cufinufft.mw:208\n", mexprofrecord_[10]);
        fprintf(logfp, "%d calls to cufinufft.mw:210\n", mexprofrecord_[11]);
        fprintf(logfp, "%d calls to cufinufft.mw:242\n", mexprofrecord_[12]);
        fprintf(logfp, "%d calls to cufinufft.mw:244\n", mexprofrecord_[13]);
        fprintf(logfp, "%d calls to cufinufft.mw:250\n", mexprofrecord_[14]);
        fprintf(logfp, "%d calls to cufinufft.mw:252\n", mexprofrecord_[15]);
        fprintf(logfp, "%d calls to cufinufft.mw:256\n", mexprofrecord_[16]);
        fprintf(logfp, "%d calls to cufinufft.mw:258\n", mexprofrecord_[17]);
        fprintf(logfp, "%d calls to cufinufft.mw:270\n", mexprofrecord_[18]);
        fprintf(logfp, "%d calls to cufinufft.mw:272\n", mexprofrecord_[19]);
        fclose(logfp);
    } else
        mexErrMsgTxt("Unknown identifier");
}
