// Header of static arrays of monomial coeffs of spreading kernel function in each
// fine-grid interval. Generated by gen_all_horner_cpp_header.m in devel/
// Authors: Alex Barnett, Ludvig af Klinteberg, Marco Barbone & Libin Lu.
// (C) 2018--2024 The Simons Foundation, Inc.
#include <array>

template<class T, uint8_t w> constexpr auto get_horner_coeffs_200() noexcept {
  if constexpr (w == 2) {
    return std::array<std::array<T, w>, 4>{{
        {-2.5024197515954172E-01, 2.5024197515954183E-01},
        {-2.2584311526143722E-02, -2.2584311526143454E-02},
        {7.0481840008800800E-01, -7.0481840008800789E-01},
        {5.5428559551548429E-01, 5.5428559551548384E-01},
    }};
  } else if constexpr (w == 3) {
    return std::array<std::array<T, w>, 6>{{
        {-4.5057857403454230E-03, -2.2085344902082910E-17, 4.5057857475245119E-03},
        {-4.2902993854032984E-02, 6.0475925925925544E-02, -4.2902993846219581E-02},
        {-1.7450587318669355E-02, 4.7841151834284663E-18, 1.7450587325767687E-02},
        {2.0160576446392525E-01, -3.7666666666667292E-01, 2.0160576447145476E-01},
        {3.5966530797580987E-01, 2.1212921335912769E-17, -3.5966530796781049E-01},
        {1.7787237246937579E-01, 1.0000000000000013E+00, 1.7787237247678458E-01},
    }};
  } else if constexpr (w == 4) {
    return std::array<std::array<T, w>, 7>{{
        {-7.3657365672905517E-04, 3.7144674885204070E-04, 3.7144674885202628E-04,
         -7.3657365672907674E-04},
        {-5.7512181801490803E-03, 1.0945950376831749E-02, -1.0945950376831702E-02,
         5.7512181801490803E-03},
        {-3.5432868834529780E-03, 2.8903049344238094E-03, 2.8903049344237578E-03,
         -3.5432868834529736E-03},
        {3.7516840869185726E-02, -1.0412335657155609E-01, 1.0412335657155619E-01,
         -3.7516840869185719E-02},
        {1.0408888748149286E-01, -1.0268333881994469E-01, -1.0268333881994463E-01,
         1.0408888748149286E-01},
        {1.0749328817387331E-01, 4.5419700247912276E-01, -4.5419700247912287E-01,
         -1.0749328817387331E-01},
        {3.9828257752799377E-02, 7.3911656575585805E-01, 7.3911656575585805E-01,
         3.9828257752799384E-02},
    }};
  } else if constexpr (w == 5) {
    return std::array<std::array<T, w>, 8>{{
        {-3.4201716508580047E-05, 2.3137115416451718E-05, 2.5987213744756162E-17,
         -2.3137115416372002E-05, 3.4201716508570079E-05},
        {-5.6059657038176342E-04, 1.2116190166775124E-03, -1.5448333333332248E-03,
         1.2116190166775590E-03, -5.6059657038177242E-04},
        {-9.2488937959280416E-04, 1.2476700479676119E-03, -2.7206380314284564E-17,
         -1.2476700479676119E-03, 9.2488937959280416E-04},
        {4.0593041193018580E-03, -1.6067481167759527E-02, 2.4150000000000067E-02,
         -1.6067481167759551E-02, 4.0593041193018554E-03},
        {2.0250135419918228E-02, -3.9381037339048575E-02, 2.5392611358194196E-17,
         3.9381037339048602E-02, -2.0250135419918248E-02},
        {3.6562231959204307E-02, 7.8509612097392850E-02, -2.3000000000000043E-01,
         7.8509612097392975E-02, 3.6562231959204300E-02},
        {3.0826052021380449E-02, 3.8431958613457989E-01, -1.0606460667956290E-16,
         -3.8431958613457956E-01, -3.0826052021380446E-02},
        {1.0051451410391413E-02, 3.8286382489474302E-01, 1.0000000000000007E+00,
         3.8286382489474247E-01, 1.0051451410391420E-02},
    }};
  } else if constexpr (w == 6) {
    return std::array<std::array<T, w>, 9>{{
        {-1.5875418082720764E-06, 7.2147850126235124E-07, -7.0930078220514644E-08,
         -7.0930078220514644E-08, 7.2147850127765077E-07, -1.5875417996313146E-06},
        {-4.6695893922777881E-05, 1.1717219021518970E-04, -1.8098268625854635E-04,
         1.8098268625862607E-04, -1.1717219021518182E-04, 4.6695893931715671E-05},
        {-1.2239646122606701E-04, 2.2750660293441327E-04, -1.2702072030312787E-04,
         -1.2702072030306311E-04, 2.2750660293440248E-04, -1.2239646121695602E-04},
        {3.2622379114950018E-04, -1.8514138516535202E-03, 3.8520985619445395E-03,
         -3.8520985619445863E-03, 1.8514138516535124E-03, -3.2622379114026403E-04},
        {2.7444270008043924E-03, -8.0004810696544873E-03, 5.2920367975574324E-03,
         5.2920367975573977E-03, -8.0004810696544925E-03, 2.7444270008144425E-03},
        {7.3669955501269365E-03, 4.9102900025223429E-03, -5.1302324979469460E-02,
         5.1302324979469523E-02, -4.9102900025223065E-03, -7.3669955501178136E-03},
        {1.0180085126333447E-02, 9.2337811484268964E-02, -1.0253741712233809E-01,
         -1.0253741712233820E-01, 9.2337811484268992E-02, 1.0180085126343141E-02},
        {7.2383827471879155E-03, 2.0903648995439442E-01, 3.2052935784357639E-01,
         -3.2052935784357617E-01, -2.0903648995439442E-01, -7.2383827471776269E-03},
        {2.0875119883113405E-03, 1.5741818314646630E-01, 8.2446837122968764E-01,
         8.2446837122968797E-01, 1.5741818314646627E-01, 2.0875119883208733E-03},
    }};
  } else if constexpr (w == 7) {
    return std::array<std::array<T, w>, 10>{{
        {-1.5030958477791755E-08, -9.3540219413709317E-08, 1.3079704875006950E-07,
         -3.2241315608379925E-17, -1.3079704868363920E-07, 9.3540219416477249E-08,
         1.5030959705495632E-08},
        {-3.2859430043338334E-06, 9.3570096164196706E-06, -1.7015821249913417E-05,
         2.0688046128709321E-05, -1.7015821249913417E-05, 9.3570096164234958E-06,
         -3.2859430029059141E-06},
        {-1.2513684117292326E-05, 2.9105578584771500E-05, -2.8835295309280147E-05,
         3.4204613883790509E-17, 2.8835295309401381E-05, -2.9105578584773161E-05,
         1.2513684118771961E-05},
        {1.6363160465888369E-05, -1.5802085209242327E-04, 4.4431051893381075E-04,
         -6.0985626028862202E-04, 4.4431051893372624E-04, -1.5802085209243048E-04,
         1.6363160467394535E-05},
        {2.8413019973530621E-04, -1.1175797418592197E-03, 1.3906361031251863E-03,
         -3.3449040113448959E-17, -1.3906361031251863E-03, 1.1175797418592314E-03,
         -2.8413019973377808E-04},
        {1.0735311014902873E-03, -7.2030895675482935E-04, -6.6760503000562778E-03,
         1.2656705539358897E-02, -6.6760503000563636E-03, -7.2030895675483466E-04,
         1.0735311014919515E-03},
        {2.1552691780265211E-03, 1.3627105791872403E-02, -3.3718114813591091E-02,
         9.1739351594304141E-17, 3.3718114813591160E-02, -1.3627105791872408E-02,
         -2.1552691780250184E-03},
        {2.4904843753404821E-03, 5.4888936725282354E-02, 2.4759577399513299E-02,
         -1.6428571428571420E-01, 2.4759577399513219E-02, 5.4888936725282375E-02,
         2.4904843753420958E-03},
        {1.5569364307494555E-03, 8.9228372765634070E-02, 3.5049603091348175E-01,
         -1.2727752801547551E-16, -3.5049603091348197E-01, -8.9228372765634056E-02,
         -1.5569364307477628E-03},
        {4.0677823488318105E-04, 5.5714997521829554E-02, 5.1113018541287836E-01,
         1.0000000000000004E+00, 5.1113018541287858E-01, 5.5714997521829540E-02,
         4.0677823488476019E-04},
    }};
  } else if constexpr (w == 8) {
    return std::array<std::array<T, w>, 10>{{
        {-1.9601350641697596E-07, 6.2981383505349922E-07, -1.3252363384678579E-06,
         1.9071649677086492E-06, -1.9071649677418643E-06, 1.3252363384844655E-06,
         -6.2981383506145699E-07, 1.9601350641688405E-07},
        {-1.0444417486660109E-06, 2.8837147790363758E-06, -3.9445588398358392E-06,
         1.9505656879865072E-06, 1.9505656879375492E-06, -3.9445588398358392E-06,
         2.8837147790380012E-06, -1.0444417486659870E-06},
        {8.7290223704599643E-08, -9.9551635569511269E-06, 3.9042123573727561E-05,
         -7.0647330846731457E-05, 7.0647330846733124E-05, -3.9042123573704312E-05,
         9.9551635569469747E-06, -8.7290223704651537E-08},
        {2.3288943339077674E-05, -1.1810885265513386E-04, 2.1380000655379325E-04,
         -1.1905274322671857E-04, -1.1905274322666821E-04, 2.1380000655377886E-04,
         -1.1810885265513567E-04, 2.3288943339077756E-05},
        {1.2112223749399396E-04, -2.3174709024353631E-04, -5.1773322458159175E-04,
         1.8691284471382202E-03, -1.8691284471382202E-03, 5.1773322458161506E-04,
         2.3174709024353533E-04, -1.2112223749399399E-04},
        {3.3122072653963831E-04, 1.3353118718124433E-03, -5.9878504390516426E-03,
         4.3217905833729652E-03, 4.3217905833728282E-03, -5.9878504390516859E-03,
         1.3353118718124383E-03, 3.3122072653963847E-04},
        {5.5053208919074686E-04, 9.2359485489686838E-03, -6.2169545154249859E-03,
         -3.1386277864020484E-02, 3.1386277864020540E-02, 6.2169545154249963E-03,
         -9.2359485489686872E-03, -5.5053208919074697E-04},
        {5.5627094085228127E-04, 2.4604803324737454E-02, 6.5902977410162808E-02,
         -9.1064379250067509E-02, -9.1064379250067509E-02, 6.5902977410162836E-02,
         2.4604803324737447E-02, 5.5627094085228149E-04},
        {3.1361556564941533E-04, 3.2518751351035650E-02, 2.4295266212395961E-01,
         2.5083142126627189E-01, -2.5083142126627200E-01, -2.4295266212395961E-01,
         -3.2518751351035650E-02, -3.1361556564941516E-04},
        {7.5442178667263954E-05, 1.7659090182402852E-02, 2.6112828482312656E-01,
         8.6561421087578294E-01, 8.6561421087578283E-01, 2.6112828482312644E-01,
         1.7659090182402852E-02, 7.5442178667263873E-05},
    }};
  } else if constexpr (w == 9) {
    return std::array<std::array<T, w>, 11>{{
        {-1.0121400696639382E-08, 3.6191328859115424E-08, -8.7258577130274595E-08,
         1.4622014472389451E-07, -1.7333902183589538E-07, 1.4622014475109679E-07,
         -8.7258577123989584E-08, 3.6191328857387053E-08, -1.0121400696607466E-08},
        {-7.3256982980632681E-08, 2.3321978963689725E-07, -4.0030411107271311E-07,
         3.4388260962519006E-07, -1.6867455797025957E-17, -3.4388260995180576E-07,
         4.0030411105472155E-07, -2.3321978963603227E-07, 7.3256982980605642E-08},
        {-8.1737159283255514E-08, -4.1540916378286498E-07, 2.6668107554239935E-06,
         -6.3261434127972289E-06, 8.2578681450047054E-06, -6.3261434126197552E-06,
         2.6668107554392931E-06, -4.1540916378625952E-07, -8.1737159283261483E-08},
        {1.5345430093717280E-06, -9.9308189188290649E-06, 2.3762810604644528E-05,
         -2.4017602201901366E-05, -1.1468142860888204E-17, 2.4017602202089031E-05,
         -2.3762810604641208E-05, 9.9308189188344622E-06, -1.5345430093717798E-06},
        {1.1032857092605834E-05, -3.4254477931957202E-05, -1.3557143976035342E-05,
         1.8667778536559447E-04, -2.9974999576615630E-04, 1.8667778536541582E-04,
         -1.3557143976042535E-05, -3.4254477931960353E-05, 1.1032857092605854E-05},
        {3.9567294647305451E-05, 8.1817980646548685E-05, -7.2116754318329347E-04,
         1.0390038161996692E-03, 1.3900173479267018E-17, -1.0390038161999335E-03,
         7.2116754318327797E-04, -8.1817980646548685E-05, -3.9567294647305479E-05},
        {8.8459828362140154E-05, 1.1147546008569563E-03, -2.1200589329645721E-03,
         -2.9677441441083030E-03, 7.7692043895745341E-03, -2.9677441441080454E-03,
         -2.1200589329645721E-03, 1.1147546008569587E-03, 8.8459828362140127E-05},
        {1.2783089927061671E-04, 4.4048543606096746E-03, 6.4505427512762383E-03,
         -2.6627297241817623E-02, 5.0907892336476291E-17, 2.6627297241817893E-02,
         -6.4505427512762392E-03, -4.4048543606096851E-03, -1.2783089927061677E-04},
        {1.1601811379064815E-04, 9.2861699099147117E-03, 5.4760895870332296E-02,
         -2.7420112488899190E-04, -1.2777777777777782E-01, -2.7420112488923623E-04,
         5.4760895870332310E-02, 9.2861699099147411E-03, 1.1601811379064820E-04},
        {6.0003223623206657E-05, 1.0569385595664994E-02, 1.3202059711663527E-01,
         3.1241329121161582E-01, -6.3638764007737742E-17, -3.1241329121161615E-01,
         -1.3202059711663530E-01, -1.0569385595665030E-02, -6.0003223623206657E-05},
        {1.3445576990655669E-05, 5.1377966678943553E-03, 1.1569392196071673E-01,
         5.9595989228910684E-01, 1.0000000000000004E+00, 5.9595989228910784E-01,
         1.1569392196071668E-01, 5.1377966678943891E-03, 1.3445576990655669E-05},
    }};
  } else if constexpr (w == 10) {
    return std::array<std::array<T, w>, 12>{{
        {-4.4040059171412067E-10, 1.7857872824825793E-09, -4.9203237628693688E-09,
         9.5125261839819949E-09, -1.3157194845364040E-08, 1.3157194812996284E-08,
         -9.5125262237318697E-09, 4.9203237570488512E-09, -1.7857872831569075E-09,
         4.4040059171633886E-10},
        {-4.4291858217017104E-09, 1.5904364892171725E-08, -3.2603275107603078E-08,
         3.8190045579900928E-08, -1.7631718328624946E-08, -1.7631718392731933E-08,
         3.8190045599384427E-08, -3.2603275104460579E-08, 1.5904364893271601E-08,
         -4.4291858217152902E-09},
        {-1.0412910456846279E-08, -3.6228831478765483E-09, 1.3932530225087088E-07,
         -4.5071262435551458E-07, 7.5149884412259115E-07, -7.5149884433295379E-07,
         4.5071262442194489E-07, -1.3932530225640674E-07, 3.6228831474873082E-09,
         1.0412910456862496E-08},
        {8.0572098823824191E-08, -6.8352224328347800E-07, 2.0695541423476481E-06,
         -2.9709579577199207E-06, 1.5005770225504653E-06, 1.5005770225994236E-06,
         -2.9709579578790350E-06, 2.0695541423461179E-06, -6.8352224328405176E-07,
         8.0572098823813736E-08},
        {8.3366418668162695E-07, -3.5785601754620480E-06, 2.4539930904838030E-06,
         1.2754336575757957E-05, -3.3000414536134188E-05, 3.3000414536278678E-05,
         -1.2754336575753804E-05, -2.4539930904804814E-06, 3.5785601754631898E-06,
         -8.3366418668162208E-07},
        {3.8359011440648835E-06, 1.3049698816908465E-06, -6.3791463619209036E-05,
         1.4528730872073815E-04, -8.6630472952427834E-05, -8.6630472952399048E-05,
         1.4528730872079033E-04, -6.3791463619214443E-05, 1.3049698816899472E-06,
         3.8359011440648708E-06},
        {1.1063475580065303E-05, 1.0180053030149664E-04, -3.4137441280837188E-04,
         -4.9828659222659531E-05, 1.0442648308816227E-03, -1.0442648308818948E-03,
         4.9828659222721751E-05, 3.4137441280836993E-04, -1.0180053030149543E-04,
         -1.1063475580065282E-05},
        {2.1363614860997127E-05, 5.7553475552091639E-04, 1.4813144535930596E-04,
         -4.1113061120761881E-03, 3.3662735809591028E-03, 3.3662735809590343E-03,
         -4.1113061120763173E-03, 1.4813144535930382E-04, 5.7553475552091368E-04,
         2.1363614860997080E-05},
        {2.7622345748507502E-05, 1.7317590416004948E-03, 7.6620063086756491E-03,
         -9.8393115612840920E-03, -2.1163068654269146E-02, 2.1163068654269441E-02,
         9.8393115612840434E-03, -7.6620063086756422E-03, -1.7317590416004902E-03,
         -2.7622345748507452E-05},
        {2.2925449299630729E-05, 3.1050615653861954E-03, 3.2337657329423494E-02,
         4.4760550762170469E-02, -8.0226193254406372E-02, -8.0226193254406220E-02,
         4.4760550762170517E-02, 3.2337657329423487E-02, 3.1050615653861859E-03,
         2.2925449299630675E-05},
        {1.1010978063160392E-05, 3.1454190365986022E-03, 6.0943215953720313E-02,
         2.5074802988370321E-01, 2.0598750885032696E-01, -2.0598750885032721E-01,
         -2.5074802988370321E-01, -6.0943215953720313E-02, -3.1454190365985909E-03,
         -1.1010978063160389E-05},
        {2.3186292807626206E-06, 1.3952040327729878E-03, 4.5894237568906808E-02,
         3.4666431215091636E-01, 8.9110862394332080E-01, 8.9110862394332024E-01,
         3.4666431215091609E-01, 4.5894237568906815E-02, 1.3952040327729794E-03,
         2.3186292807626312E-06},
    }};
  } else if constexpr (w == 11) {
    return std::array<std::array<T, w>, 13>{{
        {-1.6776727231328416E-11, 7.5440974158024552E-11, -2.3911386524068553E-10,
         5.3207180481239914E-10, -8.5057642651644847E-10, 9.9272871999260090E-10,
         -8.5057648776788347E-10, 5.3207179256211214E-10, -2.3911386498547126E-10,
         7.5440974102196413E-11, -1.6776727230829949E-11},
        {-2.3293080872927463E-10, 9.3461130373861974E-10, -2.2220140858706851E-09,
         3.2420144189661432E-09, -2.5573586925383353E-09, -5.6612065112108297E-17,
         2.5573586278028237E-09, -3.2420144306071784E-09, 2.2220140837412273E-09,
         -9.3461130374749249E-10, 2.3293080872975987E-10},
        {-8.6163117991759351E-10, 1.2292710052307758E-09, 4.9928263030434056E-09,
         -2.5746199383297511E-08, 5.5054682067879709E-08, -6.9606951448910763E-08,
         5.5054682119416694E-08, -2.5746199404038006E-08, 4.9928263027291555E-09,
         1.2292710051522133E-09, -8.6163117991951154E-10},
        {3.1778958300840877E-09, -3.9044067083629674E-08, 1.4726158788157950E-07,
         -2.7451209287892671E-07, 2.4544112211910511E-07, -1.2096711311755274E-17,
         -2.4544112210526550E-07, 2.7451209284571153E-07, -1.4726158788330946E-07,
         3.9044067083510739E-08, -3.1778958300837498E-09},
        {5.3160526822192399E-08, -2.9438470061320831E-07, 4.4816653818040024E-07,
         4.9835853876401780E-07, -2.6602444110713340E-06, 3.9090815375281570E-06,
         -2.6602444110835736E-06, 4.9835853872423912E-07, 4.4816653818231268E-07,
         -2.9438470061324415E-07, 5.3160526822193524E-08},
        {3.1074712008817151E-07, -3.7942806006715527E-07, -4.2327710785732912E-06,
         1.4518421536638065E-05, -1.6373413879626877E-05, -2.5348737439255354E-17,
         1.6373413879625217E-05, -1.4518421536614087E-05, 4.2327710785712152E-06,
         3.7942806006725903E-07, -3.1074712008816986E-07},
        {1.1248609988572039E-06, 7.1593996360417439E-06, -3.7923443960739139E-05,
         2.8219312687374916E-05, 8.5797383067766139E-05, -1.6875309167107462E-04,
         8.5797383067713081E-05, 2.8219312687382113E-05, -3.7923443960742731E-05,
         7.1593996360415194E-06, 1.1248609988571965E-06},
        {2.7801202330030060E-06, 5.8401836435976375E-05, -5.7255962675852127E-05,
         -4.1058481683293790E-04, 7.4543249761820096E-04, -1.1763859565712905E-17,
         -7.4543249761829431E-04, 4.1058481683289903E-04, 5.7255962675851158E-05,
         -5.8401836435976402E-05, -2.7801202330029937E-06},
        {4.7836299264887183E-06, 2.3732554180006435E-04, 7.1846854433599121E-04,
         -2.2660086673713040E-03, -1.3190061226034701E-03, 5.2488730277989084E-03,
         -1.3190061226034527E-03, -2.2660086673713599E-03, 7.1846854433598741E-04,
         2.3732554180006416E-04, 4.7836299264886963E-06},
        {5.6395387871289762E-06, 5.9760549110825397E-04, 5.0911332059142217E-03,
         1.6690038662948302E-03, -2.1030028251698030E-02, -6.2059675980830466E-17,
         2.1030028251698099E-02, -1.6690038662947877E-03, -5.0911332059142252E-03,
         -5.9760549110825386E-04, -5.6395387871289448E-06},
        {4.3353827605930494E-06, 9.4705645354715528E-04, 1.5700144896729010E-02,
         4.8428271550326779E-02, -1.2807080799297177E-02, -1.0454545454545444E-01,
         -1.2807080799297078E-02, 4.8428271550326855E-02, 1.5700144896729010E-02,
         9.4705645354715518E-04, 4.3353827605930206E-06},
        {1.9516358260453373E-06, 8.7214421096705637E-04, 2.4929466432368100E-02,
         1.5885079249667186E-01, 2.7894884556454935E-01, -4.2425842671825161E-17,
         -2.7894884556454946E-01, -1.5885079249667192E-01, -2.4929466432368107E-02,
         -8.7214421096705637E-04, -1.9516358260453182E-06},
        {3.8884809238313185E-07, 3.5785567372179962E-04, 1.6654951019551330E-02,
         1.7692785324424576E-01, 6.5593328211813140E-01, 1.0000000000000002E+00,
         6.5593328211813118E-01, 1.7692785324424568E-01, 1.6654951019551327E-02,
         3.5785567372179962E-04, 3.8884809238312624E-07},
    }};
  } else if constexpr (w == 12) {
    return std::array<std::array<T, w>, 14>{{
        {-4.7539080515542580E-13, 2.6787995697670693E-12, -1.0000146136716776E-11,
         2.5777402448424271E-11, -4.7463679303544195E-11, 6.4012208879125011E-11,
         -6.4012248551446094E-11, 4.7463663434615762E-11, -2.5777396894299317E-11,
         1.0000149211321660E-11, -2.6787995790652696E-12, 4.7539081135422603E-13},
        {-1.0870401168050591E-11, 4.8044744326063225E-11, -1.3004175788816287E-10,
         2.2570502165107441E-10, -2.4006684671217922E-10, 1.0597990739279489E-10,
         1.0597992372651088E-10, -2.4006685283732272E-10, 2.2570503824000470E-10,
         -1.3004176146116325E-10, 4.8044744334038674E-11, -1.0870401155791457E-11},
        {-5.6296594748046544E-11, 1.4066781263743013E-10, 4.6947620085301740E-11,
         -1.1526063790854956E-09, 3.3027593311030557E-09, -5.2174001589202684E-09,
         5.2174000697669761E-09, -3.3027593717047144E-09, 1.1526063504087998E-09,
         -4.6947618097807960E-11, -1.4066781268623019E-10, 5.6296594761372986E-11},
        {6.9986758891654079E-11, -1.8486004429655807E-09, 8.7658205605928853E-09,
         -2.0364661375797448E-08, 2.5396405344356160E-08, -1.2044441220062096E-08,
         -1.2044441164754107E-08, 2.5396405365096656E-08, -2.0364661348771956E-08,
         8.7658205579217619E-09, -1.8486004429017487E-09, 6.9986758906816106E-11},
        {2.8867786924316934E-09, -2.0015791402110268E-08, 4.5306507659307604E-08,
         -7.8859059636103066E-09, -1.5755151475869637E-07, 3.4270221889093394E-07,
         -3.4270221896290014E-07, 1.5755151472824914E-07, 7.8859059580744467E-09,
         -4.5306507657318156E-08, 2.0015791402056882E-08, -2.8867786924176715E-09},
        {2.1473864761678232E-08, -5.7414008446893210E-08, -2.0134799316449521E-07,
         1.1145247706155282E-06, -1.8840465966169550E-06, 1.0067804560971022E-06,
         1.0067804560971022E-06, -1.8840465966230748E-06, 1.1145247706170582E-06,
         -2.0134799316564268E-07, -5.7414008446863325E-08, 2.1473864761695973E-08},
        {9.5799843879056626E-08, 3.7784160107118267E-07, -3.2256313018480346E-06,
         5.0144058082789751E-06, 3.4886031174209264E-06, -1.7411974954214207E-05,
         1.7411974954235796E-05, -3.4886031174051491E-06, -5.0144058082478364E-06,
         3.2256313018492801E-06, -3.7784160107122159E-07, -9.5799843879039130E-08},
        {2.9426545129495859E-07, 4.7724106401924093E-06, -1.1001642128367906E-05,
         -2.6869692251292144E-05, 9.4483235217683692E-05, -6.1678458203290321E-05,
         -6.1678458203254352E-05, 9.4483235217685495E-05, -2.6869692251315525E-05,
         -1.1001642128368805E-05, 4.7724106401924229E-06, 2.9426545129497829E-07},
        {6.4507244019416563E-07, 2.5481132674301245E-05, 4.2795619387511915E-05,
         -3.0197159708155482E-04, 1.1080610219043500E-04, 6.4144454802694513E-04,
         -6.4144454802697625E-04, -1.1080610219045833E-04, 3.0197159708158204E-04,
         -4.2795619387510939E-05, -2.5481132674301316E-05, -6.4507244019415007E-07},
        {1.0091198513153350E-06, 8.4812954286468410E-05, 5.7431140218944536E-04,
         -5.0274672420764957E-04, -2.8008958990917753E-03, 2.6435090762446183E-03,
         2.6435090762445667E-03, -2.8008958990918438E-03, -5.0274672420767526E-04,
         5.7431140218944330E-04, 8.4812954286468437E-05, 1.0091198513153600E-06},
        {1.0993606197695949E-06, 1.8716155179384023E-04, 2.6329045000561338E-03,
         5.3754303637599914E-03, -1.0591878410592578E-02, -1.5228395084945702E-02,
         1.5228395084945730E-02, 1.0591878410592587E-02, -5.3754303637599428E-03,
         -2.6329045000561338E-03, -1.8716155179384034E-04, -1.0993606197695828E-06},
        {7.9035220764954430E-07, 2.6846594761214740E-04, 6.6557324960729147E-03,
         3.4792641812076711E-02, 2.9454899103693734E-02, -7.1172529707069124E-02,
         -7.1172529707069096E-02, 2.9454899103693782E-02, 3.4792641812076718E-02,
         6.6557324960729259E-03, 2.6846594761214735E-04, 7.9035220764956854E-07},
        {3.3587389488258577E-07, 2.2809471090022899E-04, 9.2744480587562007E-03,
         8.5676487647660032E-02, 2.4720659158040617E-01, 1.7472997738461996E-01,
         -1.7472997738462001E-01, -2.4720659158040628E-01, -8.5676487647660143E-02,
         -9.2744480587562180E-03, -2.2809471090022904E-04, -3.3587389488256655E-07},
        {6.3667715563015570E-08, 8.7461142088576766E-05, 5.6146669497086606E-03,
         8.1271316412301384E-02, 4.1627261402765736E-01, 9.0846375182673733E-01,
         9.0846375182673733E-01, 4.1627261402765731E-01, 8.1271316412301550E-02,
         5.6146669497086693E-03, 8.7461142088576834E-05, 6.3667715563034920E-08},
    }};
  } else if constexpr (w == 13) {
    return std::array<std::array<T, w>, 15>{{
        {-1.1331825570440727E-14, 7.5442530545509575E-14, -3.5473155765082429E-13,
         1.0827877815183058E-12, -2.3054260653186393E-12, 3.5752119738669225E-12,
         -4.1288702029291516E-12, 3.5754810437391768E-12, -2.3054322758177103E-12,
         1.0827809499693276E-12, -3.5473128594148992E-13, 7.5442566328658522E-14,
         -1.1331825569256169E-14},
        {-4.4521627552749709E-13, 2.1830423159171809E-12, -6.6494701742631481E-12,
         1.3364546912215633E-11, -1.7572522963316000E-11, 1.3087514697366595E-11,
         -8.4435734857040533E-18, -1.3087609910937195E-11, 1.7572511855066095E-11,
         -1.3364550482724530E-11, 6.6494700750823452E-12, -2.1830423529162694E-12,
         4.4521627549722952E-13},
        {-3.1122514900942224E-12, 1.0235548890361649E-11, -1.0076717484352820E-11,
         -3.6278870299335626E-11, 1.6235810773706083E-10, -3.2356767144198370E-10,
         4.0014568953167669E-10, -3.2356778577799558E-10, 1.6235815163392255E-10,
         -3.6278895693159697E-11, -1.0076717659812659E-11, 1.0235548935223541E-11,
         -3.1122514900513855E-12},
        {-1.9694481417906755E-12, -7.0630732029806550E-11, 4.4161967738503258E-10,
         -1.2581280904632460E-09, 2.0087583294349134E-09, -1.6557204113066525E-09,
         -2.4838776856226866E-17, 1.6557200331149790E-09, -2.0087583290445127E-09,
         1.2581281109060392E-09, -4.4161967758023283E-10, 7.0630731987661026E-11,
         1.9694481417581824E-12},
        {1.3345700642135977E-10, -1.1551704392497283E-09, 3.4412362337817539E-09,
         -3.2850871137761556E-09, -6.1855158894413326E-09, 2.3119925542057157E-08,
         -3.2145944250702619E-08, 2.3119925991120319E-08, -6.1855159390928232E-09,
         -3.2850871338881514E-09, 3.4412362340567228E-09, -1.1551704392030819E-09,
         1.3345700642135018E-10},
        {1.2845897306281068E-09, -5.2304801922931164E-09, -5.0548716984338105E-09,
         6.7539942920393712E-08, -1.6027276235916921E-07, 1.5655092163694814E-07,
         -2.0049126746331200E-17, -1.5655092175596911E-07, 1.6027276234256162E-07,
         -6.7539942914165863E-08, 5.0548716981743173E-09, 5.2304801922274408E-09,
         -1.2845897306281596E-09},
        {6.9838095920571053E-09, 1.2796250155223251E-08, -2.1971713837867670E-07,
         5.2791981730845992E-07, -1.4622692109166607E-07, -1.2222183756557477E-06,
         2.0809248310447731E-06, -1.2222183757291852E-06, -1.4622692100904889E-07,
         5.2791981729507288E-07, -2.1971713837877233E-07, 1.2796250155280027E-08,
         6.9838095920571284E-09},
        {2.6111186487625189E-08, 3.2044561720736560E-07, -1.2220373462324990E-06,
         -8.5793794342312014E-07, 8.3299507234022271E-06, -1.0956754351203854E-05,
         4.2374504788607687E-17, 1.0956754351086770E-05, -8.3299507234225711E-06,
         8.5793794342312014E-07, 1.2220373462324990E-06, -3.2044561720740451E-07,
         -2.6111186487625219E-08},
        {7.0755520230584412E-08, 2.2298625886400112E-06, 7.8375383351921547E-07,
         -2.8394470622678201E-05, 3.5771256766246747E-05, 4.1631950912197713E-05,
         -1.0418619302464089E-04, 4.1631950912400947E-05, 3.5771256766178408E-05,
         -2.8394470622675504E-05, 7.8375383351932791E-07, 2.2298625886400150E-06,
         7.0755520230584359E-08},
        {1.4058372037094500E-07, 9.4685595066536152E-06, 4.8682874512158753E-05,
         -1.1575111217135236E-04, -2.1811605515766828E-04, 5.4056763477039569E-04,
         1.9368559350380580E-17, -5.4056763477032576E-04, 2.1811605515769940E-04,
         1.1575111217134847E-04, -4.8682874512158509E-05, -9.4685595066535983E-06,
         -1.4058372037094503E-07},
        {2.0277547837406113E-07, 2.7328509487415513E-05, 3.2236608098850332E-04,
         3.0859705461357004E-04, -2.0254394973525094E-03, -5.2398574644554148E-04,
         3.7818616294950373E-03, -5.2398574644547274E-04, -2.0254394973524665E-03,
         3.0859705461356787E-04, 3.2236608098850332E-04, 2.7328509487415378E-05,
         2.0277547837406113E-07},
        {2.0618605552701890E-07, 5.4306747658367629E-05, 1.1637911071900912E-03,
         4.7784706844645301E-03, -1.2004184173789252E-03, -1.6862510515566049E-02,
         9.7663889839209053E-18, 1.6862510515566097E-02, 1.2004184173788634E-03,
         -4.7784706844645371E-03, -1.1637911071900916E-03, -5.4306747658367324E-05,
         -2.0618605552701893E-07},
        {1.3966266158866419E-07, 7.1655019336418715E-05, 2.5459504018621160E-03,
         2.0160236969440630E-02, 4.0770064165298381E-02, -1.9317276988534519E-02,
         -8.8461538461538702E-02, -1.9317276988534231E-02, 4.0770064165298381E-02,
         2.0160236969440609E-02, 2.5459504018621169E-03, 7.1655019336418200E-05,
         1.3966266158866422E-07},
        {5.6353468219321982E-08, 5.6780128053894706E-05, 3.1934841481628330E-03,
         4.0941461360716913E-02, 1.7436810648693343E-01, 2.5085467225681685E-01,
         -4.2425842671825272E-17, -2.5085467225681662E-01, -1.7436810648693341E-01,
         -4.0941461360716816E-02, -3.1934841481628322E-03, -5.6780128053894245E-05,
         -5.6353468219322028E-08},
        {1.0208956054983660E-08, 2.0506572462261995E-05, 1.7784497194617914E-03,
         3.4214490279693019E-02, 2.3443634373410052E-01, 7.0049708882252781E-01,
         9.9999999999999956E-01, 7.0049708882252670E-01, 2.3443634373410033E-01,
         3.4214490279692915E-02, 1.7784497194617914E-03, 2.0506572462261771E-05,
         1.0208956054983704E-08},
    }};
  } else if constexpr (w == 14) {
    return std::array<std::array<T, w>, 16>{{
        {1.6573977048758373E-16, 1.3350705098663598E-15, -1.0198682011443083E-14,
         3.9098729470330932E-14, -9.7793954863110993E-14, 1.7461760909376988E-13,
         -2.3139300803193430E-13, 2.3133712649617930E-13, -1.7464512743103152E-13,
         9.7793532432495125E-14, -3.9100087283024766E-14, 1.0198847966327885E-14,
         -1.3350639093879870E-15, -1.6573967195923749E-16},
        {-1.6512890189653285E-14, 8.8250732683937202E-14, -3.0062086690296025E-13,
         6.8819285466437257E-13, -1.0710400014754661E-12, 1.0658737978231948E-12,
         -4.5539043383551768E-13, -4.5538732858598216E-13, 1.0658669662742166E-12,
         -1.0710350330762092E-12, 6.8819363097675645E-13, -3.0062096394200824E-13,
         8.8250729348219931E-14, -1.6512890096369287E-14},
        {-1.4925032356594262E-13, 5.9101412859019032E-13, -1.0473415219044306E-12,
         -3.4168917194284013E-13, 6.3681359177110198E-12, -1.6773482744373957E-11,
         2.5499660495751048E-11, -2.5499681125358013E-11, 1.6773489091945331E-11,
         -6.3681446456216585E-12, 3.4168897358123469E-13, 1.0473414475188284E-12,
         -5.9101412655620904E-13, 1.4925032367339251E-13},
        {-3.4295334315359932E-13, -1.9669734025378269E-12, 1.8829710628324230E-11,
         -6.6063899195501951E-11, 1.2987243582507169E-10, -1.4723144009119097E-10,
         6.6816630074648980E-11, 6.6816585156930012E-11, -1.4723144213290547E-10,
         1.2987245930478841E-10, -6.6063899004091207E-11, 1.8829709958386662E-11,
         -1.9669734162456265E-12, -3.4295334295109775E-13},
        {5.1753158905731111E-12, -5.7459004388635483E-11, 2.1373772903641436E-10,
         -3.3474981778015193E-10, -5.5056512295298501E-11, 1.1984997396258443E-09,
         -2.3401535495753279E-09, 2.3401534462256513E-09, -1.1984997901649717E-09,
         5.5056485464132478E-11, 3.3474981628953162E-10, -2.1373772851292269E-10,
         5.7459004398894591E-11, -5.1753158903325276E-12},
        {6.7195187479838651E-11, -3.6781600571601283E-10, 1.8909214073475932E-10,
         3.2074788108853071E-09, -1.0777792240321408E-08, 1.5287295334927549E-08,
         -7.6060393527572334E-09, -7.6060393515002332E-09, 1.5287295319215051E-08,
         -1.0777792242206908E-08, 3.2074788110424317E-09, 1.8909214034194689E-10,
         -3.6781600571877484E-10, 6.7195187480061628E-11},
        {4.4289508956510068E-10, -2.3397558744219687E-11, -1.2203541602842489E-08,
         4.1555456454833886E-08, -4.0387396856849884E-08, -5.2822132680810253E-08,
         1.7383889339056799E-07, -1.7383889348606158E-07, 5.2822132664202676E-08,
         4.0387396840242307E-08, -4.1555456456217852E-08, 1.2203541602842489E-08,
         2.3397558739320396E-11, -4.4289508956485780E-10},
        {1.9857214221989461E-09, 1.7788899565182485E-08, -1.0133541198304996E-07,
         4.4566342393624423E-08, 5.3564828267956768E-07, -1.1695093255217001E-06,
         6.7085595112856254E-07, 6.7085595109184377E-07, -1.1695093255400593E-06,
         5.3564828275147516E-07, 4.4566342396301834E-08, -1.0133541198318143E-07,
         1.7788899565178749E-08, 1.9857214221992583E-09},
        {6.5072355972924813E-09, 1.6321871905298928E-07, -1.6208737249938854E-07,
         -2.0005919851713336E-06, 4.6289117401622691E-06, 1.5738407906772272E-07,
         -1.0033756087449713E-05, 1.0033756087433936E-05, -1.5738407907104422E-07,
         -4.6289117402421935E-06, 2.0005919851702955E-06, 1.6208737249954423E-07,
         -1.6321871905298441E-07, -6.5072355972922497E-09},
        {1.5927753226313465E-08, 8.6591441391883585E-07, 3.1186030532597906E-06,
         -1.4256326863804729E-05, -6.9192418278078509E-06, 6.1786486497531192E-05,
         -4.4611361914715045E-05, -4.4611361914675478E-05, 6.1786486497559070E-05,
         -6.9192418278168430E-06, -1.4256326863804280E-05, 3.1186030532597906E-06,
         8.6591441391883140E-07, 1.5927753226313942E-08},
        {2.9113992252245392E-08, 3.1458937074171811E-06, 3.0585266291431803E-05,
         -6.5135387342531804E-06, -2.3196510408356695E-04, 1.5778347828059787E-04,
         4.2181913759730289E-04, -4.2181913759743511E-04, -1.5778347828065232E-04,
         2.3196510408355917E-04, 6.5135387342541527E-06, -3.0585266291432135E-05,
         -3.1458937074171904E-06, -2.9113992252245418E-08},
        {3.9124194363163294E-08, 8.1265227753122953E-06, 1.4975407030324924E-04,
         4.4789439277602671E-04, -7.9407521150519009E-04, -1.9254008995686696E-03,
         2.1136619999319452E-03, 2.1136619999320310E-03, -1.9254008995687039E-03,
         -7.9407521150514065E-04, 4.4789439277602807E-04, 1.4975407030325019E-04,
         8.1265227753123105E-06, 3.9124194363164148E-08},
        {3.7419288907183448E-08, 1.4804264337309593E-05, 4.5929141335173085E-04,
         3.0552592910038081E-03, 3.3079403387824137E-03, -1.0247716289024917E-02,
         -1.1480323948535254E-02, 1.1480323948535244E-02, 1.0247716289024917E-02,
         -3.3079403387824436E-03, -3.0552592910038129E-03, -4.5929141335173296E-04,
         -1.4804264337309631E-05, -3.7419288907183713E-08},
        {2.4024402573674993E-08, 1.8178651135370016E-05, 8.9712289901830596E-04,
         1.0104692380253471E-02, 3.4193348251104448E-02, 1.8533380680638742E-02,
         -6.3746746886473818E-02, -6.3746746886473721E-02, 1.8533380680638804E-02,
         3.4193348251104413E-02, 1.0104692380253476E-02, 8.9712289901830910E-04,
         1.8178651135370050E-05, 2.4024402573675764E-08},
        {9.2475302076758741E-09, 1.3546865389183958E-05, 1.0306349751547583E-03,
         1.7767594411827761E-02, 1.0518000824290018E-01, 2.3882936521395406E-01,
         1.5170179567585840E-01, -1.5170179567585848E-01, -2.3882936521395406E-01,
         -1.0518000824290037E-01, -1.7767594411827757E-02, -1.0306349751547620E-03,
         -1.3546865389183984E-05, -9.2475302076758013E-09},
        {1.6070755785071470E-09, 4.6371263117318249E-06, 5.3392892770691479E-04,
         1.3380163586766325E-02, 1.1960061568997662E-01, 4.7332499268789302E-01,
         9.2104360429933840E-01, 9.2104360429933885E-01, 4.7332499268789296E-01,
         1.1960061568997690E-01, 1.3380163586766332E-02, 5.3392892770691815E-04,
         4.6371263117318359E-06, 1.6070755785075478E-09},
    }};
  } else if constexpr (w == 15) {
    return std::array<std::array<T, w>, 17>{{
        {4.5179136270516879E-18, -1.3721567983016968E-17, -2.0188039379638457E-16,
         1.1787961810528452E-15, -3.6002979849300605E-15, 7.4771830629950721E-15,
         -1.1466606614177747E-14, 1.2929793395674386E-14, -1.1481537091539957E-14,
         7.4099959148651253E-15, -3.6189610816328235E-15, 1.1783179391998368E-15,
         -2.0189132920460885E-16, -1.3721681893519305E-17, 4.5179138940294278E-18},
        {-5.1635500303423897E-16, 3.1828102524634415E-15, -1.2111395036223793E-14,
         3.1272176408626341E-14, -5.6181159756113080E-14, 6.8652488307259956E-14,
         -4.9059039919968102E-14, -1.9388362148879701E-17, 4.9009555190681807E-14,
         -6.8669083795740107E-14, 5.6191961910432889E-14, -3.1272613926049905E-14,
         1.2111362976757412E-14, -3.1828104881948118E-15, 5.1635500248749881E-16},
        {-6.3774103677168823E-15, 2.8974955180500696E-14, -6.8422375867171716E-14,
         5.3398530878603272E-14, 1.7893255188637643E-13, -7.2419108095498065E-13,
         1.3713257052105891E-12, -1.6687592372473224E-12, 1.3713291209850782E-12,
         -7.2419667040414461E-13, 1.7892478876253759E-13, 5.3400510475182175E-14,
         -6.8422363737290718E-14, 2.8974955332124205E-14, -6.3774103674947777E-15},
        {-2.4800914617581790E-14, -2.0428591850792014E-14, 6.6720754938105064E-13,
         -2.9781124760980002E-12, 7.0947582817473084E-12, -1.0181652063894561E-11,
         7.9189094930423407E-12, -9.8394354439677929E-18, -7.9189221881850869E-12,
         1.0181666345930150E-11, -7.0947471734974048E-12, 2.9781096494451229E-12,
         -6.6720756797745112E-13, 2.0428591947648267E-14, 2.4800914616825102E-14},
        {1.5997634038702646E-13, -2.4807970167387033E-12, 1.1275106680112280E-11,
         -2.3847055462676874E-11, 1.5364449544552166E-11, 4.4350560279013230E-11,
         -1.3563512446398317E-10, 1.8159082249266700E-10, -1.3563514079769914E-10,
         4.4350479631290549E-11, 1.5364417897977443E-11, -2.3847054792739306E-11,
         1.1275106670142972E-11, -2.4807970166140870E-12, 1.5997634038751326E-13},
        {3.0917581107079110E-12, -2.1504981482082260E-11, 3.4611945847529536E-11,
         1.1082666372508343E-10, -5.8883841601722089E-10, 1.1304779835787544E-09,
         -1.0037911764569433E-09, -3.0283968181148084E-17, 1.0037910961054091E-09,
         -1.1304781035382004E-09, 5.8883843170422537E-10, -1.1082666581905009E-10,
         -3.4611945887456865E-11, 2.1504981481250442E-11, -3.0917581107099418E-12},
        {2.4734066313993841E-11, -4.3978001546130925E-11, -5.4975091407909014E-10,
         2.6307942053065240E-09, -4.2001676300414851E-09, -1.8212709476483809E-10,
         1.0547608728554078E-08, -1.6454374657490009E-08, 1.0547608700900084E-08,
         -1.8212715510082630E-10, -4.2001676441827325E-09, 2.6307942080562109E-09,
         -5.4975091408400028E-10, -4.3978001546169286E-11, 2.4734066313994739E-11},
        {1.3160883866734162E-10, 8.0584478671628169E-10, -6.7824252839146209E-09,
         9.4471403085770161E-09, 2.4030590210440211E-08, -9.0522548461561274E-08,
         9.9320303281521742E-08, -3.3235747494939870E-17, -9.9320303331344472E-08,
         9.0522548575046391E-08, -2.4030590184144877E-08, -9.4471403129019068E-09,
         6.7824252838551532E-09, -8.0584478671661959E-10, -1.3160883866734426E-10},
        {5.1310324414219323E-10, 1.0163871982746417E-08, -2.4441175134513117E-08,
         -1.0543632600128869E-07, 4.0979777876948477E-07, -2.9573937050886787E-07,
         -5.9824625885776880E-07, 1.2067769777215239E-06, -5.9824625888224795E-07,
         -2.9573937051804759E-07, 4.0979777875189036E-07, -1.0543632599908938E-07,
         -2.4441175134504150E-08, 1.0163871982746604E-08, 5.1310324414219250E-10},
        {1.5128957992049935E-09, 6.6672685257782830E-08, 1.4160936684819443E-07,
         -1.2611166225406650E-06, 6.6865545481274985E-07, 4.6861078169603807E-06,
         -7.4523870622367549E-06, 3.4449326618851042E-17, 7.4523870622915596E-06,
         -4.6861078171685983E-06, -6.6865545481586376E-07, 1.2611166225370321E-06,
         -1.4160936684822037E-07, -6.6672685257784048E-08, -1.5128957992049958E-09},
        {3.3986627004323941E-09, 2.9741452947022137E-07, 2.3232144780590986E-06,
         -3.5941523174517531E-06, -1.8171775676703349E-05, 3.2858338560999192E-05,
         2.0665249075282785E-05, -6.8763374485658282E-05, 2.0665249075243218E-05,
         3.2858338560903870E-05, -1.8171775676688959E-05, -3.5941523174468073E-06,
         2.3232144780590283E-06, 2.9741452947022068E-07, 3.3986627004323950E-09},
        {5.7777535593445582E-09, 9.5996306286140537E-07, 1.5097159537535539E-05,
         2.8094504791463487E-05, -1.2791075475385979E-04, -1.0516749004206970E-04,
         4.0040320377523060E-04, -5.3767305800596667E-17, -4.0040320377526947E-04,
         1.0516749004224858E-04, 1.2791075475386367E-04, -2.8094504791466405E-05,
         -1.5097159537535578E-05, -9.5996306286140621E-07, -5.7777535593445615E-09},
        {7.2920076887968842E-09, 2.2644150332986927E-06, 6.1226481435401080E-05,
         3.3216368068303837E-04, 4.2258807580772573E-07, -1.7026747228854225E-03,
         -1.2026158633577104E-04, 2.8537037037045169E-03, -1.2026158633587413E-04,
         -1.7026747228854396E-03, 4.2258807580342979E-07, 3.3216368068303599E-04,
         6.1226481435401053E-05, 2.2644150332986923E-06, 7.2920076887968825E-09},
        {6.6006259688120903E-09, 3.8297656275654615E-06, 1.6597029248061418E-04,
         1.6248331197066910E-03, 4.0281119347581806E-03, -2.8399908290139670E-03,
         -1.3756562885831731E-02, 8.4642037860646445E-18, 1.3756562885831830E-02,
         2.8399908290139726E-03, -4.0281119347581763E-03, -1.6248331197066903E-03,
         -1.6597029248061428E-04, -3.8297656275654632E-06, -6.6006259688120903E-09},
        {4.0364738474324407E-09, 4.4152383936309399E-06, 2.9537757977456613E-04,
         4.5415629108243203E-03, 2.2685962261788536E-02, 3.3502333548319392E-02,
         -2.2696322242195928E-02, -7.6666666666667105E-02, -2.2696322242195890E-02,
         3.3502333548319295E-02, 2.2685962261788574E-02, 4.5415629108243290E-03,
         2.9537757977456602E-04, 4.4152383936309408E-06, 4.0364738474324407E-09},
        {1.4880454274285380E-09, 3.1146031777409664E-06, 3.1470309742465704E-04,
         7.1215977556942766E-03, 5.6335374470954699E-02, 1.8245542837228426E-01,
         2.2739494478010194E-01, -8.4851685343650138E-17, -2.2739494478010203E-01,
         -1.8245542837228429E-01, -5.6335374470954797E-02, -7.1215977556942861E-03,
         -3.1470309742465704E-04, -3.1146031777409677E-06, -1.4880454274285417E-09},
        {2.4886236238313275E-10, 1.0156314710024850E-06, 1.5297772142853732E-04,
         4.9110296377727252E-03, 5.6121982134094042E-02, 2.8670951404936740E-01,
         7.3488453954210708E-01, 1.0000000000000018E+00, 7.3488453954210708E-01,
         2.8670951404936773E-01, 5.6121982134094160E-02, 4.9110296377727304E-03,
         1.5297772142853735E-04, 1.0156314710024854E-06, 2.4886236238313405E-10},
    }};
  } else if constexpr (w == 16) {
    return std::array<std::array<T, w>, 18>{{
        {1.2307507958064464E-18, -2.6518508071733353E-18, -1.1738826401341014E-20,
         2.6948814943373302E-17, -1.1509910460329600E-16, 2.8279944900173787E-16,
         -4.6726530883316867E-16, 6.6203450429457653E-16, -6.6004614127826513E-16,
         4.7069975404316101E-16, -2.8081108598542653E-16, 1.1491834432908588E-16,
         -2.6954463701942368E-17, 1.1451975380255613E-20, 2.6518459803532692E-18,
         -1.2307508038870603E-18},
        {-1.6052119849944121E-17, 1.0220931367339573E-16, -4.3668875981049212E-16,
         1.2658945204775534E-15, -2.5919308700797615E-15, 3.7378450076294255E-15,
         -3.5206065620092615E-15, 1.3556873444887233E-15, 1.3825622037407022E-15,
         -3.5235926574817036E-15, 3.7296332450802098E-15, -2.5925840784643585E-15,
         1.2657662116877219E-15, -4.3668857755368841E-16, 1.0220931367339573E-16,
         -1.6052119749827469E-17},
        {-2.4132931376483073E-16, 1.2442653568449662E-15, -3.5592674167315351E-15,
         5.0955768471980872E-15, 1.6433757901515860E-15, -2.5292369304993825E-14,
         6.2705842006972340E-14, -9.2647844753490817E-14, 9.2624309333464405E-14,
         -6.2708738674052505E-14, 2.5283784911407270E-14, -1.6454577696154606E-15,
         -5.0957126284674709E-15, 3.5592589304021987E-15, -1.2442654599774408E-15,
         2.4132931371807006E-16},
        {-1.3523251102433609E-15, 1.9055797797121101E-15, 1.8430802267160460E-14,
         -1.1526994860082207E-13, 3.3348703176907399E-13, -5.8352482961996788E-13,
         6.1748228591582172E-13, -2.7106468455582230E-13, -2.7107027400498627E-13,
         6.1750014110065109E-13, -5.8352296647024653E-13, 3.3348780808145787E-13,
         -1.1526990978520290E-13, 1.8430803480148559E-14, 1.9055798650003358E-15,
         -1.3523251103173957E-15},
        {3.2506946752710782E-15, -9.2845381976413515E-14, 5.1542690454602287E-13,
         -1.3678932749752010E-12, 1.6503393979160946E-12, 7.2550201768889120E-13,
         -6.2314790536140772E-12, 1.1299389559457127E-11, -1.1299395907028501E-11,
         6.2314933356496677E-12, -7.2549567011751778E-13, -1.6503411831705432E-12,
         1.3678932005895990E-12, -5.1542690687057296E-13, 9.2845381921931865E-14,
         -3.2506946753420181E-15},
        {1.2527329159245277E-13, -1.0816725478983629E-12, 2.7445378617411554E-12,
         1.7839887814412696E-12, -2.6194657489648952E-11, 6.7446676626524242E-11,
         -8.5082169359569567E-11, 4.0254977976937753E-11, 4.0255018811227722E-11,
         -8.5082173442998567E-11, 6.7446660803236882E-11, -2.6194658255291886E-11,
         1.7839886059814300E-12, 2.7445378627380862E-12, -1.0816725479139400E-12,
         1.2527329159255924E-13},
        {1.2276300481455858E-12, -4.1769601374580106E-12, -1.9148402820678083E-11,
         1.3822953605936348E-10, -3.0994364315672905E-10, 2.0316700797680967E-10,
         4.3650567492219507E-10, -1.1534087876776367E-09, 1.1534087287626426E-09,
         -4.3650568826679616E-10, -2.0316702022119098E-10, 3.0994363911075959E-10,
         -1.3822953621907280E-10, 1.9148402809587158E-11, 4.1769601372500562E-12,
         -1.2276300481457296E-12},
        {7.7013760205810495E-12, 2.8123297626112544E-11, -3.7953802134892808E-10,
         8.7573780433573981E-10, 5.1359846170264275E-10, -5.3609157562628785E-09,
         9.1303304588329059E-09, -4.8150451155485792E-09, -4.8150451281185763E-09,
         9.1303304734455279E-09, -5.3609157606623776E-09, 5.1359846248826757E-10,
         8.7573780425717729E-10, -3.7953802134524547E-10, 2.8123297626093363E-11,
         7.7013760205810866E-12},
        {3.5284250010876544E-11, 5.4380355945615962E-10, -2.1550460241863304E-09,
         -3.7344953350225554E-09, 2.7722604309770562E-08, -3.9597167025382683E-08,
         -1.3993916658989759E-08, 9.5626629211485668E-08, -9.5626629251620657E-08,
         1.3993916686669056E-08, 3.9597167023998724E-08, -2.7722604313576463E-08,
         3.7344953348063106E-09, 2.1550460241816002E-09, -5.4380355945633912E-10,
         -3.5284250010876789E-11},
        {1.2320735888479567E-10, 4.4066719437555919E-09, 2.9936173156415513E-09,
         -8.7082338359625540E-08, 1.2972939456024976E-07, 2.2882425901978947E-07,
         -7.3491924909951292E-07, 4.5592445663881905E-07, 4.5592445668777740E-07,
         -7.3491924909951292E-07, 2.2882425901519963E-07, 1.2972939456177968E-07,
         -8.7082338359685309E-08, 2.9936173156430456E-09, 4.4066719437555919E-09,
         1.2320735888479557E-10},
        {3.3254260763955980E-10, 2.3748169129616548E-08, 1.4324995919581946E-07,
         -4.5855119979513952E-07, -9.5896649524474271E-07, 3.6155491754929462E-06,
         -9.8206137492975964E-07, -6.1812989820939710E-06, 6.1812989821267707E-06,
         9.8206137495882303E-07, -3.6155491754861996E-06, 9.5896649524349715E-07,
         4.5855119979513952E-07, -1.4324995919581623E-07, -2.3748169129616750E-08,
         -3.3254260763955995E-10},
        {6.9354916180818914E-10, 9.3269475195063855E-08, 1.2384428187212307E-06,
         8.4996778392780880E-07, -1.3106613626291306E-05, 2.8218026704008473E-06,
         4.1119875273747256E-05, -3.3017437945364753E-05, -3.3017437945361154E-05,
         4.1119875273773338E-05, 2.8218026703918548E-06, -1.3106613626292205E-05,
         8.4996778392747158E-07, 1.2384428187212307E-06, 9.3269475195063524E-08,
         6.9354916180818924E-10},
        {1.1057322032863294E-09, 2.7364351668058891E-07, 6.4277990516970045E-06,
         2.7144256967440260E-05, -3.6927862875713990E-05, -1.6756539822665589E-04,
         1.6190404775919697E-04, 2.9203183363573547E-04, -2.9203183363575488E-04,
         -1.6190404775916586E-04, 1.6756539822664033E-04, 3.6927862875711076E-05,
         -2.7144256967440016E-05, -6.4277990516969969E-06, -2.7364351668058902E-07,
         -1.1057322032863298E-09},
        {1.3190161602522575E-09, 5.9764321317063347E-07, 2.2744388605473007E-05,
         1.9073517322668122E-04, 2.8943142766412957E-04, -8.8625893129445996E-04,
         -1.3389167739520143E-03, 1.7216657535079883E-03, 1.7216657535080399E-03,
         -1.3389167739520486E-03, -8.8625893129445140E-04, 2.8943142766413012E-04,
         1.9073517322668078E-04, 2.2744388605472990E-05, 5.9764321317063347E-07,
         1.3190161602522575E-09},
        {1.1357078950958105E-09, 9.4728532805183307E-07, 5.5827161828283832E-05,
         7.6087086075588245E-04, 3.0946204357507547E-03, 1.6729582927767583E-03,
         -9.5127691406673535E-03, -8.9630953638635182E-03, 8.9630953638635789E-03,
         9.5127691406673934E-03, -1.6729582927767586E-03, -3.0946204357507555E-03,
         -7.6087086075588234E-04, -5.5827161828283825E-05, -9.4728532805183349E-07,
         -1.1357078950958109E-09},
        {6.6422278409342463E-10, 1.0324321112746625E-06, 9.1817488865684755E-05,
         1.8711533829047159E-03, 1.2921996060610222E-02, 3.2047854205940307E-02,
         1.0693035516337730E-02, -5.7626889750985288E-02, -5.7626889750985406E-02,
         1.0693035516337771E-02, 3.2047854205940300E-02, 1.2921996060610223E-02,
         1.8711533829047159E-03, 9.1817488865684755E-05, 1.0324321112746625E-06,
         6.6422278409342463E-10},
        {2.3529614069937343E-10, 6.9307767643753116E-07, 9.1584555859393314E-05,
         2.6688190455647263E-03, 2.7424935799146798E-02, 1.1980519064171602E-01,
         2.2858769149343988E-01, 1.3403316930972972E-01, -1.3403316930972986E-01,
         -2.2858769149343991E-01, -1.1980519064171602E-01, -2.7424935799146809E-02,
         -2.6688190455647263E-03, -9.1584555859393314E-05, -6.9307767643753127E-07,
         -2.3529614069937420E-10},
        {3.7973138383475537E-11, 2.1620729770457849E-07, 4.2059935922517660E-05,
         1.7055631615451750E-03, 2.4507833223051386E-02, 1.5833750021928361E-01,
         5.2065761855025594E-01, 9.3058177132107822E-01, 9.3058177132107800E-01,
         5.2065761855025572E-01, 1.5833750021928361E-01, 2.4507833223051390E-02,
         1.7055631615451755E-03, 4.2059935922517687E-05, 2.1620729770457854E-07,
         3.7973138383475505E-11},
    }};
  }
  static_assert(w >= 2, "w must be >= 2");
  static_assert(w <= 16, "w must be <= 16");
};
