from __future__ import annotations

from enum import Enum

from mixam_sdk.item_specification.models.value_based import ValueBased


class StandardSize(ValueBased, Enum):

    NONE = (0, -1)

    MM_10_X_30 = (149, 9)
    MM_15_X_35 = (151, 9)
    MM_15_X_45 = (158, 9)
    MM_20_X_40 = (156, 9)
    MM_20_X_50 = (161, 9)
    MM_21_X_68 = (169, 8)
    MM_25_X_50 = (162, 9)
    MM_30_X_70 = (192, 8)
    MM_35_X_105 = (153, 7)
    MM_35_X_210 = (154, 5)
    MM_35_X_316 = (155, 4)
    MM_40_X_50 = (163, 8)
    MM_48_X_70 = (160, 8)
    MM_51_X_298 = (165, 4)
    MM_51_X_420 = (166, 3)
    MM_52_X_210 = (209, 5)
    MM_55_X_85 = (167, 8)
    MM_55_X_148 = (207, 6)
    MM_55_X_173 = (208, 6)
    MM_71_X_96 = (171, 7)
    MM_95_X_145 = (175, 6)
    MM_95_X_45 = (173, 7)
    MM_95_X_210 = (231, 5)
    MM_98_X_210 = (180, 5)
    MM_98_X_420 = (176, 3)
    MM_105_X_297 = (10, 4)
    MM_120_X_125 = (177, 6)
    MM_124_X_140 = (179, 6)
    MM_130_X_150 = (190, 5)
    MM_130_X_190 = (194, 5)
    MM_135_X_210 = (221, 5)
    MM_138_X_297 = (191, 4)
    MM_140_X_297 = (178, 4)
    MM_150_X_265 = (20, 4)
    MM_160_X_240 = (222, 5)
    MM_168_X_240 = (223, 5)
    MM_170_X_240 = (42, 5)
    MM_170_X_590 = (39, 2)
    MM_183_X_273 = (19, 4)
    MM_193_X_260 = (224, 4)
    MM_199_X_210 = (193, 4)
    MM_200_X_200 = (99, 4)
    MM_210_X_280 = (7, 4)
    MM_200_X_250 = (100, 4)
    MM_240_X_340 = (196, 4)
    MM_200_X_300 = (101, 4)
    MM_200_X_600 = (102, 2)
    MM_300_X_300 = (103, 3)
    MM_300_X_400 = (104, 3)
    MM_300_X_600 = (105, 2)
    MM_300_X_800 = (197, 1)
    MM_300_X_1000 = (106, 1)
    MM_400_X_400 = (107, 2)
    MM_400_X_500 = (108, 2)
    MM_400_X_600 = (109, 2)
    MM_400_X_1500 = (198, 0)
    MM_500_X_500 = (110, 2)
    MM_500_X_600 = (111, 2)
    MM_500_X_700 = (112, 2)
    MM_500_X_750 = (113, 1)
    MM_500_X_1000 = (114, 1)
    MM_600_X_600 = (115, 1)
    MM_600_X_750 = (116, 1)
    MM_600_X_800 = (117, 1)
    MM_750_X_750 = (199, 1)
    MM_750_X_1000 = (118, 1)
    MM_800_X_1200 = (203, 0)
    MM_895_X_1280 = (187, 0)
    MM_700_X_1000 = (188, 1)
    MM_1000_X_1000 = (200, 0)
    MM_1000_X_1400 = (189, 0)
    MM_1000_X_1200 = (204, 0)
    MM_1000_X_1500 = (201, 0)
    MM_1000_X_2000 = (202, 0)
    MM_1185_X_1750 = (40, 0)
    MM_135_X_205 = (211, 5)
    MM_125_X_190 = (212, 5)
    MM_115_X_185 = (213, 5)
    MM_114_X_172 = (214, 6)
    MM_148_X_156 = (215, 5)
    MM_294_X_300 = (216, 3)
    MM_120_X_190 = (217, 5)

    # Sizes in IN
    IN_2_X_3_5 = (205, 8)
    IN_2_X_6 = (206, 6)
    IN_2_X_8 = (136, 5)
    IN_3_X_4 = (138, 7)
    IN_3_5_X_8_5 = (121, 5)
    IN_3_66_X_4_25 = (137, 6)
    IN_4_X_4 = (139, 6)
    IN_4_X_6 = (50, 6)
    IN_4_X_9 = (135, 5)
    IN_4_125_X_5_875 = (186, 6)
    IN_4_25_X_55 = (49, 6)
    IN_4_25_X_6_87 = (95, 6)
    IN_4_25_X_11 = (122, 4)
    IN_5_X_7 = (51, 5)
    IN_5_X_8 = (69, 5)
    IN_5_06_X_7_81 = (70, 5)
    IN_5_125X_7 = (185, 5)
    IN_5_25_X_8 = (71, 5)
    IN_5_25_X_8_375 = (143, 5)
    IN_5_375_X_8_375 = (142, 5)
    IN_5_5_X_8_5 = (46, 5)
    IN_5_5_X_10 = (218, 4)
    IN_5_8_X_9_25 = (140, 4)
    IN_6_X_8 = (219, 5)
    IN_6_63_X_10_25 = (184, 4)

    # Deprecated: Use US_TRADE instead.
    IN_6_X_9 = (52, 5)

    IN_6_X_11 = (54, 4)
    IN_6_14_X_9_21 = (72, 5)
    IN_6_125_X_9_25 = (232, 5)
    IN_6_69_X_9_61 = (73, 5)
    IN_7_X_8_5 = (123, 4)
    IN_7_X_9 = (98, 4)
    IN_7_X_10 = (74, 4)
    IN_7_25_X_9_5 = (94, 4)
    IN_7_44_X_9_69 = (75, 4)
    IN_7_5_X_8_5 = (124, 4)
    IN_7_5_X_9_25 = (76, 4)
    IN_8_X_10 = (53, 4)
    IN_8_X_11 = (87, 4)
    IN_8_X_12 = (131, 4)
    IN_8_25_X_6 = (77, 5)
    IN_8_25_X_11 = (233, 4)
    IN_8_375_X_10_875 = (141, 4)

    # Deprecated: Use IN_3_5_X_8_5
    IN_8_5_X_3_5 = (134, 5)
    # Deprecated: Use IN_5_5_X_8_5
    IN_8_5_X_5_5 = (133, 5)

    IN_8_5_X_11 = (47, 4)
    IN_8_5_X_14 = (65, 3)
    IN_8_5_X_17 = (127, 3)
    IN_8_5_X_22 = (48, 2)
    IN_8_75_X_11 = (183, 4)
    IN_9_X_12 = (125, 4)
    IN_9_X_16 = (126, 3)
    IN_9_5_X_12 = (97, 4)
    IN_10_X_15 = (132, 4)
    IN_11_X_14 = (88, 3)
    IN_11_X_17 = (55, 3)
    IN_11_X_25_5 = (130, 2)
    IN_11_5_X_17_5 = (128, 3)
    IN_12_X_16 = (220, 3)
    IN_12_X_18 = (59, 3)
    IN_13_X_19 = (60, 3)
    IN_17_X_22 = (129, 2)
    IN_18_X_24 = (61, 2)
    IN_19_X_27 = (62, 2)
    IN_20_X_30 = (43, 1)
    IN_24_X_36 = (63, 1)
    IN_26_X_39 = (64, 1)
    IN_30_X_40 = (44, 0)
    IN_40_X_60 = (45, 0)

    # Square Sizes
    SQUARE_10_MM = (144, 9)
    SQUARE_15_MM = (145, 9)
    SQUARE_20_MM = (146, 9)
    SQUARE_21_MM = (147, 9)
    SQUARE_25_MM = (148, 9)
    SQUARE_30_MM = (150, 9)
    SQUARE_35_MM = (152, 9)
    SQUARE_40_MM = (157, 9)
    SQUARE_45_MM = (159, 8)
    SQUARE_50_MM = (164, 8)
    SQUARE_55_MM = (32, 8)
    SQUARE_60_MM = (168, 8)
    SQUARE_70_MM = (170, 7)
    SQUARE_80_MM = (172, 7)
    SQUARE_95_MM = (174, 6)
    SQUARE_98_MM = (35, 6)
    SQUARE_100_MM = (21, 6)
    SQUARE_105_MM = (12, 6)
    SQUARE_120_MM = (13, 5)
    SQUARE_140_MM = (81, 5)
    SQUARE_148_MM = (11, 5)
    SQUARE_210_MM = (6, 4)
    SQUARE_280_MM = (93, 3)
    SQUARE_297_MM = (195, 3)

    SQUARE_4_75_IN = (58, 5)
    SQUARE_6_IN = (56, 5)
    SQUARE_7_IN = (80, 4)
    SQUARE_7_5_IN = (96, 4)
    SQUARE_8_IN = (89, 4)
    SQUARE_8_25_IN = (78, 4)
    SQUARE_8_5_IN = (79, 4)
    SQUARE_10_IN = (119, 3)
    SQUARE_11_8_IN = (120, 3)
    SQUARE_12_IN = (57, 3)

    # Envelope Sizes
    ENVELOPE_C5 = (24, 4)
    ENVELOPE_C4 = (25, 3)
    ENVELOPE_DL = (23, 4)

    # Miscellaneous Sizes
    A1_LONG = (14, 0)
    A2_LONG = (15, 1)
    A5_LONG = (10, 4)
    A6_LONG = (36, 5)
    A7_LONG = (37, 6)
    A7_MINI = (41, 7)
    AB = (225, 4)
    B0 = (38, 0)
    B1 = (17, 1)
    B2 = (18, 2)
    B5 = (226, 4)
    B6 = (82, 5)
    DL = (9, 4)
    DL_SMALL_99_MM = (16, 4)
    DL_SMALL_100_MM = (8, 4)
    BUSINESS_CARD = (22, 7)
    BUSINESS_CARD_2 = (30, 7)
    BUSINESS_CARD_3 = (31, 8)
    UK_STANDARD = (66, 4)
    US_STANDARD = (67, 4)
    US_TRADE = (83, 4)
    US_BUSINESS_CARD = (84, 7)
    US_POSTCARD_550 = (85, 6)
    US_POSTCARD_425 = (86, 6)
    MANGA_STANDARD = (68, 5)
    B_FORMAT_UK = (90, 5)
    PINCHED_CROWN_QUARTO = (91, 5)
    CROWN_QUARTO = (92, 4)
    NOVEL = (1, 5)
    STANDARD_BOOK = (2, 5)
    DEMY = (3, 4)
    SILVER_AGE = (181, 4)
    GOLDEN_AGE = (182, 4)
    JIS_B5 = (227, 4)
    JIS_B40 = (228, 5)
    HAN_46 = (229, 5)
    HOBONICHI = (230, 5)
    US_ROYAL = (4, 4)
    ROYAL = (5, 4)
    KITCHEN = (210, 3)

    def __init__(self, value_id: int, format: int):
        self._value_ = value_id
        self._format = format

    def get_value(self) -> int:
        return int(self.value)

    def get_format(self) -> int:
        if self is StandardSize.NONE:
            raise RuntimeError("StandardSize.NONE has no format")
        return self._format
