# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hokusai',
 'hokusai.cli',
 'hokusai.commands',
 'hokusai.lib',
 'hokusai.services']

package_data = \
{'': ['*'], 'hokusai': ['templates/*', 'templates/hokusai/*']}

install_requires = \
['Jinja2==3.1.1',
 'MarkupSafe==2.1.1',
 'PyYAML==6.0.1',
 'boto3==1.21.28',
 'click-repl==0.2.0',
 'click==8.1.0',
 'packaging==21.3',
 'prompt-toolkit==3.0.28',
 'termcolor==1.1.0']

entry_points = \
{'console_scripts': ['hokusai = hokusai.command_line:main']}

setup_kwargs = {
    'name': 'hokusai',
    'version': '1.2.0',
    'description': 'Artsy Docker development toolkit',
    'long_description': '## HOKUSAI [![CircleCI](https://circleci.com/gh/artsy/hokusai/tree/main.svg?style=svg)](https://circleci.com/gh/artsy/hokusai/tree/main)\n\n<a href="https://en.wikipedia.org/wiki/Hokusai"><img height="300" src="hokusai.jpg"></a>\n\nHokusai is a Docker + Kubernetes CLI for application developers.\n\nHokusai "dockerizes" applications and manages their lifecycle throughout development, testing, and release cycles.\n\nHokusai wraps calls to [Kubectl](https://kubernetes.io/), [Docker](https://www.docker.com/), [Docker-Compose](https://docs.docker.com/compose/) and [Git](https://git-scm.com/) with a CLI, and defines a CI workflow.\n\nHokusai currently only supports Kubernetes deployments on AWS, configured to pull from ECS container repositories (ECR), although other providers may be added in the future.\n\n### Why Hokusai?\n\nAt [Artsy](http://www.artsy.net), as we began working with Kubernetes, while impressed with its design, capabilities, and flexibility, we were in need of tooling we could deliver to agile development teams that addressed the day-to-day tasks of application development, delivery, introspection and maintenance, while providing a clean and uncomplicated interface.\n\nTransitioning teams to the Docker / Kubernetes ecosystem can be intimidating, and comes with a steep learning curve. We set out to create a Heroku-like CLI that would shepherd the application developer into the ecosystems of Docker and Kubernetes, and while introducing new tooling and concepts, outlining a clear practice for dependency management, local development, testing and CI, image repository structure, deployment and orchestration.\n\n## Installation\n\n### MacOS\n\nWe recommend installing via Homebrew:\n\n```\n$ brew update\n$ brew tap artsy/formulas\n$ brew install hokusai\n```\n\nIf you previously installed Hokusai via an alternate installation method, you may need to force the `link` step.\n\n```\n$ brew link --overwrite hokusai\n```\n\nIf you previously installed Hokusai via Pip, you may want to first uninstall it:\n\n```\n$ pip uninstall hokusai\n```\n\n### Linux\n\n```\ncurl -sSL https://raw.githubusercontent.com/artsy/hokusai/main/get-hokusai.sh | sudo bash\n```\n\nNote: This method installs Hokusai to `/usr/local/bin/hokusai`.\n\n### Pip\n\nHokusai can be installed via Pip, on MacOS or Linux. If you do so, please first go through [Pyenv](#Pyenv), [Python](#Python), and [Virtualenv](#Virtualenv) steps.\n\nPython 3.7+ is required.\n\n```\npip install hokusai\n```\n\nNote: If Pip fails at upgrading your system Python packages, try:\n\n```\npip install hokusai --ignore-installed\n```\n\n### Docker\n\nWe also maintain [Hokusai Docker images](https://hub.docker.com/r/artsy/hokusai) for running Hokusai in Docker.\n\n### Github\n\nRelease artifacts are available on [Github](https://github.com/artsy/hokusai/releases).\n\n### AWS S3\n\nRelease artifacts are also available in AWS S3. You can use this [convenience script](get-hokusai.sh) or Curl to fetch them.\n\n### A note on Python 2.x\n\nHokusai currently supports Python 3.7+ only. The last version that supported Python 2.x was [v0.5.18](https://github.com/artsy/hokusai/tree/v0.5.18).\n\n## Setup\n\nWe assume that you already have Kubernetes cluster, Git, Docker, and Docker-Compose set up, and that you have an AWS account. Perform the following steps to setup Hokusai:\n\n1. [Configure AWS credentials](https://boto3.amazonaws.com/v1/documentation/api/latest/guide/configuration.html#configuring-credentials).\n\n2. Configure Hokusai\n\n    ```\n    hokusai configure --kubectl-version <kubectl version> --s3-bucket <bucket name> --s3-key <file key>\n    ```\n\n    Provide the Kubectl version matching that of your Kubernetes clusters, as well as the S3 bucket name/key where your org\'s Kubectl config file is stored.\n\n    For system administrators: see [Administering Hokusai](./docs/Administering_Hokusai.md) for instructions on preparing AWS and Kubernetes, and on publishing a Kubectl config file.\n\n    For Artsy developers: see [artsy/README](https://github.com/artsy/README/blob/main/playbooks/hokusai.md) for the current way of installing and configuring hokusai.\n\n3. Enable Bash autocompletion:\n\n    ```\n    eval "$(_HOKUSAI_COMPLETE=source hokusai)"\n    ```\n\n## Getting Started\n\nSee [Getting Started](./docs/Getting_Started.md) to start using Hokusai for your project.\n\n## Command Reference\n\nA full command reference can be found in [Command Reference](./docs/Command_Reference.md).\n\n## Review Apps\n\nHokusai can be used to simplify the process of spinning up a "review app" instance of your project, based on a feature branch or pull request.\n\nFull details are in the [Review App reference](./docs/Review_Apps.md).\n\n## Developing Hokusai\n\nTo work on Hokusai itself, please set up:\n\n### Pyenv\n\nWe recommend using [Pyenv](https://github.com/pyenv/pyenv) to install the correct version of Python. For a tutorial of Pyenv, see [this guide](https://realpython.com/intro-to-pyenv/).\n\nWhen installing on MacOS, please make sure to use brew-installed `openssl` and `readline` libraries, and xcode-installed `zlib` library. And make sure these libraries are correctly linked. Like so:\n\n```\nbrew install openssl readline zlib\n\necho \'export PATH="/usr/local/opt/openssl@1.1/bin:$PATH"\' >> ~/.bash_profile\necho \'export LDFLAGS="-L/usr/local/opt/openssl@1.1/lib"\' >> ~/.bash_profile\necho \'export CPPFLAGS="-I/usr/local/opt/openssl@1.1/include"\' >> ~/.bash_profile\necho \'export PKG_CONFIG_PATH="/usr/local/opt/openssl@1.1/lib/pkgconfig"\' >> ~/.bash_profile\n```\n\n### Python\n\nHokusai is currently tested on Python 3.9.10 so we recommend using that Python version.\n\nIf you use Pyenv to install Python, you should see an output similar to this:\n\n```\npyenv install 3.9.10\n\n    python-build: use openssl from homebrew\n    python-build: use readline from homebrew\n\n    Downloading Python-3.9.10.tar.xz...\n    -> https://www.python.org/ftp/python/3.9.10/Python-3.9.10.tar.xz\n    Installing Python-3.9.10...\n    python-build: use tcl-tk from homebrew\n    python-build: use readline from homebrew\n    python-build: use zlib from xcode sdk\n\n    Installed Python-3.9.10 to $HOME/.pyenv/versions/3.9.10\n```\n\nWith the desired Python version installed, activate it globally:\n\n```\npyenv global 3.9.10\n```\n\nNote: If you want to create a PyInstaller distribution, Python must be installed with development libraries. Use the environment variable `PYTHON_CONFIGURE_OPTS="--enable-framework"` on Darwin and `PYTHON_CONFIGURE_OPTS="--enable-shared"` on Linux when running `pyenv install`.\n\n### Virtualenv\n\nWe recommend using a virtual environment to isolate Hokusai\'s dependencies from that of other projects on your local environment.\n\nThe Pyenv install comes with [pyenv-virtualenv](https://github.com/pyenv/pyenv-virtualenv) which can be used to create virtual environments.\n\n### Poetry\n\nUse [Poetry](https://python-poetry.org/) to install Hokusai\'s dependencies as well as Hokusai itself in [editable mode](https://pip-python3.readthedocs.io/en/latest/reference/pip_install.html#editable-installs). See [this guide](https://python-poetry.org/docs/basic-usage/) for working with Poetry.\n\nInstall Poetry:\n\n```\npip install poetry\n```\n\nInstall dependencies and Hokusai in editable mode:\n\n```\npoetry install\n```\n\nTo update dependencies:\n\n```\npoetry lock\n```\n\n## Testing\n\n### Install Minikube\n\n[Minikube](https://minikube.sigs.k8s.io/docs/start/) is used for integration tests.\n\n```\nbrew install minikube\nminikube start --kubernetes-version=<version of your Kubernetes clusters, example: v1.2.3>\n```\n\n### Run tests\n\nTo run all tests:\n\n```\nmake tests\n```\n\nTo run only unit tests:\n\n```\nmake test\n```\n\nOnly integration tests:\n\n```\nmake integration\n```\n\nOnly specific modules, TestClasses, or even methods:\n\n```\npython -m unittest test.unit.test_module.TestClass.test_method\n```\n\nTip: Set `DEBUG=1` environment variable to print boto logging\n\n\n## Distributing Hokusai\n\n### Beta Release\n\nMerging a branch into `main` automatically creates a beta version useful for testing.\n\nTo install the beta:\n\n#### MacOS\n\n```\n$ brew uninstall hokusai\n$ brew uninstall hokusai-beta\n$ brew update\n$ brew tap artsy/formulas\n$ brew install hokusai-beta\n```\n\n#### Linux\n\n```\ncurl -sSL https://raw.githubusercontent.com/artsy/hokusai/main/get-hokusai.sh | sudo bash -s beta\n```\n\n### Official Release\n\nTo create an official release, such as `v1.2.3`, perform the following:\n\n- Create a branch named `prepare-v1.2.3` and make the following changes:\n  - Bump version in [RELEASE_VERSION](./RELEASE_VERSION) file.\n  - Upate [CHANGELOG](./CHANGELOG.md).\n  - Open a PR to merge into `main`. Please see [past PRs](https://github.com/artsy/hokusai/pulls?q=is%3Apr+Release+is%3Aclosed+%22prepare+version%22) for example.\n\n- Open a PR to merge `main` into `release`. Please see [past PRs](https://github.com/artsy/hokusai/pulls?q=is%3Apr+is%3Aclosed+%22release+version%22) for example.\n\n## The Name\n\nThe project is named for the great Japanese artist [Katsushika Hokusai](https://www.artsy.net/article/artsy-editorial-7-things-hokusai-creator-great-wave) (1760-1849).\n\n## About Artsy\n\n<a href="https://www.artsy.net/">\n  <img align="left" src="https://avatars2.githubusercontent.com/u/546231?s=200&v=4"/>\n</a>\n\nThis project is the work of engineers at [Artsy][footer_website], the world\'s\nleading and largest online art marketplace and platform for discovering art.\nOne of our core [Engineering Principles][footer_principles] is being [Open\nSource by Default][footer_open] which means we strive to share as many details\nof our work as possible.\n\nYou can learn more about this work from [our blog][footer_blog] and by following\n[@ArtsyOpenSource][footer_twitter] or explore our public data by checking out\n[our API][footer_api]. If you\'re interested in a career at Artsy, read through\nour [job postings][footer_jobs]!\n\n[footer_website]: https://www.artsy.net/\n[footer_principles]: https://github.com/artsy/README/blob/main/culture/engineering-principles.md\n[footer_open]: https://github.com/artsy/README/blob/main/culture/engineering-principles.md\n[footer_blog]: https://artsy.github.io/\n[footer_twitter]: https://twitter.com/ArtsyOpenSource\n[footer_api]: https://developers.artsy.net/\n[footer_jobs]: https://www.artsy.net/jobs\n',
    'author': 'Isac Petruzzi',
    'author_email': 'isac@artsymail.com',
    'maintainer': 'Jian-Feng Xu',
    'maintainer_email': 'jian-feng@artsymail.com',
    'url': 'http://github.com/artsy/hokusai',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '==3.9.10',
}


setup(**setup_kwargs)
