#!/usr/bin/env python3
# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

from botorch.test_functions.multi_fidelity import (
    AugmentedBranin,
    AugmentedHartmann,
    AugmentedRosenbrock,
)
from botorch.test_functions.multi_objective import (
    BNH,
    BraninCurrin,
    C2DTLZ2,
    CarSideImpact,
    CONSTR,
    ConstrainedBraninCurrin,
    DiscBrake,
    DTLZ1,
    DTLZ2,
    DTLZ3,
    DTLZ4,
    DTLZ5,
    DTLZ7,
    GMM,
    MW7,
    OSY,
    Penicillin,
    SRN,
    ToyRobust,
    VehicleSafety,
    WeldedBeam,
    ZDT1,
    ZDT2,
    ZDT3,
)
from botorch.test_functions.multi_objective_multi_fidelity import (
    MOMFBraninCurrin,
    MOMFPark,
)
from botorch.test_functions.synthetic import (
    Ackley,
    Beale,
    Branin,
    Bukin,
    Cosine8,
    DixonPrice,
    DropWave,
    EggHolder,
    Griewank,
    Hartmann,
    HolderTable,
    Levy,
    Michalewicz,
    Powell,
    PressureVessel,
    Rastrigin,
    Rosenbrock,
    Shekel,
    SixHumpCamel,
    SpeedReducer,
    StyblinskiTang,
    SyntheticTestFunction,
    TensionCompressionString,
    ThreeHumpCamel,
    WeldedBeamSO,
)


__all__ = [
    "Ackley",
    "AugmentedBranin",
    "AugmentedHartmann",
    "AugmentedRosenbrock",
    "Beale",
    "BNH",
    "Branin",
    "BraninCurrin",
    "Bukin",
    "CONSTR",
    "Cosine8",
    "CarSideImpact",
    "ConstrainedBraninCurrin",
    "C2DTLZ2",
    "DiscBrake",
    "DixonPrice",
    "DropWave",
    "DTLZ1",
    "DTLZ2",
    "DTLZ3",
    "DTLZ4",
    "DTLZ5",
    "DTLZ7",
    "EggHolder",
    "GMM",
    "Griewank",
    "Hartmann",
    "HolderTable",
    "Levy",
    "Michalewicz",
    "MW7",
    "OSY",
    "Penicillin",
    "Powell",
    "PressureVessel",
    "Rastrigin",
    "Rosenbrock",
    "Shekel",
    "SixHumpCamel",
    "SpeedReducer",
    "SRN",
    "StyblinskiTang",
    "SyntheticTestFunction",
    "TensionCompressionString",
    "ThreeHumpCamel",
    "ToyRobust",
    "VehicleSafety",
    "WeldedBeam",
    "WeldedBeamSO",
    "ZDT1",
    "ZDT2",
    "ZDT3",
    "MOMFBraninCurrin",
    "MOMFPark",
]
