# Copyright 2023 Cisco Systems, Inc. and its affiliates

from catalystwan.api.templates.models.cisco_system import (
    AffinityPerVrf,
    CiscoSystemModel,
    DeviceVariable,
    MobileNumber,
    Object,
    ObjectTrack,
    Tracker,
    Vrf,
)

default_cisco_system = CiscoSystemModel(
    template_name="default_cisco_system", template_description="default", device_models=["vedge-C8000V"]
)  # type: ignore

cisco_system_complex = CiscoSystemModel(
    template_name="cisco_system_complex",
    template_description="cisco_system_complex",
    timezone="UTC",
    description="Example desc",
    hostname=DeviceVariable(name="sdwan-hostname"),
    location="Data Center A",
    latitude=37.7749,
    longitude=-122.4194,
    range=10,
    enable_fencing=True,
    mobile_number=[MobileNumber(number="+12345678901"), MobileNumber(number="+10987654321")],
    enable_sms=True,
    device_groups=["group1", "group2"],
    controller_group_list=[1, 3],
    system_ip=DeviceVariable(name="192.0.2.1"),
    overlay_id=1,
    site_id=1001,
    site_type=["branch", "spoke"],
    port_offset=1000,
    port_hop=True,
    control_session_pps=500,
    track_transport=True,
    track_interface_tag=1,
    console_baud_rate="9600",
    max_omp_sessions=50,
    multi_tenant=False,
    track_default_gateway=False,
    admin_tech_on_failure=True,
    enable_tunnel=True,
    idle_timeout=300,
    on_demand_idle_timeout_min=60,
    tracker=[
        Tracker(
            name="tracker1",
            endpoint_ip="203.0.113.1",
            endpoint_ip_transport_port="8080",
            protocol="tcp",
            port=443,
            endpoint_dns_name=None,
            endpoint_api_url=None,
            elements=["element1, element2"],
            boolean="and",
            threshold=10,
            interval=30,
            multiplier=3,
            type="static-route",
        )
    ],
    object_track=[
        ObjectTrack(
            object_number=10,
            interface="GigabitEthernet0/0/0",
            sig="100",
            ip="192.0.2.1",
            mask="255.255.255.0",
            vpn=1,
            object=[Object(number=101)],
            boolean="and",
        ),
        ObjectTrack(
            object_number=20,
            interface="GigabitEthernet0/0/0",
            sig="100",
            ip="192.0.2.1",
            mask="255.255.255.0",
            vpn=1,
            object=[Object(number=101)],
            boolean="and",
        ),
        ObjectTrack(
            object_number=30,
            interface="GigabitEthernet0/0/1",
            sig="200",
            ip="198.51.100.1",
            mask="255.255.255.0",
            vpn=2,
            object=[Object(number=201)],
            boolean="or",
        ),
    ],
    region_id=None,
    secondary_region=None,
    role="edge-router",
    affinity_group_number=1,
    preference=[1],
    preference_auto=True,
    affinity_per_vrf=[AffinityPerVrf(affinity_group_number=1, vrf_range="22")],
    transport_gateway=True,
    enable_mrf_migration="enabled",
    migration_bgp_community=65535,
    enable_management_region=True,
    vrf=[Vrf(vrf_id=1, gateway_preference=[4, 5]), Vrf(vrf_id=2, gateway_preference=[12, 13])],
    management_gateway=None,
    epfr="conservative",
)
