# Generated by ORMatic

from __future__ import annotations
from sqlalchemy import Column, ForeignKey, Integer, String, Float, Boolean, DateTime, Enum, JSON
from sqlalchemy.orm import relationship, Mapped, mapped_column, DeclarativeBase
from typing_extensions import Optional, List, Type

import classes.example_classes
import datetime
from classes.example_classes import Element

from ormatic.dao import DataAccessObject
from ormatic.custom_types import TypeType

class Base(DeclarativeBase):
    type_mappings = {
        Type: TypeType,
        classes.example_classes.PhysicalObject: classes.example_classes.ConceptType,
    }


class AlternativeMappingAggregatorDAO(Base, DataAccessObject[classes.example_classes.AlternativeMappingAggregator]):
    __tablename__ = 'AlternativeMappingAggregatorDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)




    entities1: Mapped[List[CustomEntityDAO]] = relationship('CustomEntityDAO', foreign_keys='[CustomEntityDAO.alternativemappingaggregatordao_entities1_id]', post_update=True)
    entities2: Mapped[List[CustomEntityDAO]] = relationship('CustomEntityDAO', foreign_keys='[CustomEntityDAO.alternativemappingaggregatordao_entities2_id]', post_update=True)


class AtomDAO(Base, DataAccessObject[classes.example_classes.Atom]):
    __tablename__ = 'AtomDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)

    element: Mapped[classes.example_classes.Element]
    type: Mapped[int]
    charge: Mapped[float]
    timestamp: Mapped[datetime.datetime]





class BackreferenceMappingDAO(Base, DataAccessObject[classes.example_classes.BackreferenceMapping]):
    __tablename__ = 'BackreferenceMappingDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)


    values: Mapped[List[int]] = mapped_column(JSON, nullable=False)

    reference_id: Mapped[int] = mapped_column(ForeignKey('ReferenceDAO.id', use_alter=True), nullable=True)

    reference: Mapped[ReferenceDAO] = relationship('ReferenceDAO', uselist=False, foreign_keys=[reference_id], post_update=True)


class ParentBaseMappingDAO(Base, DataAccessObject[classes.example_classes.ParentBaseMapping]):
    __tablename__ = 'ParentBaseMappingDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)


    name: Mapped[str] = mapped_column(String(255), nullable=False)
    polymorphic_type: Mapped[str] = mapped_column(String(255), nullable=False)



    __mapper_args__ = {
        'polymorphic_on': 'polymorphic_type',
        'polymorphic_identity': 'ParentBaseMappingDAO',
    }

class ParentDAO(Base, DataAccessObject[classes.example_classes.Parent]):
    __tablename__ = 'ParentDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)


    name: Mapped[str] = mapped_column(String(255), nullable=False)
    polymorphic_type: Mapped[str] = mapped_column(String(255), nullable=False)



    __mapper_args__ = {
        'polymorphic_on': 'polymorphic_type',
        'polymorphic_identity': 'ParentDAO',
    }

class ContainerDAO(Base, DataAccessObject[classes.example_classes.Container]):
    __tablename__ = 'ContainerDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)




    items: Mapped[List[ItemWithBackreferenceDAO]] = relationship('ItemWithBackreferenceDAO', foreign_keys='[ItemWithBackreferenceDAO.containerdao_items_id]', post_update=True)


class CustomEntityDAO(Base, DataAccessObject[classes.example_classes.CustomEntity]):
    __tablename__ = 'CustomEntityDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)


    overwritten_name: Mapped[str] = mapped_column(String(255), nullable=False)
    polymorphic_type: Mapped[str] = mapped_column(String(255), nullable=False)

    alternativemappingaggregatordao_entities1_id: Mapped[Optional[int]] = mapped_column(ForeignKey('AlternativeMappingAggregatorDAO.id', use_alter=True), nullable=True)
    alternativemappingaggregatordao_entities2_id: Mapped[Optional[int]] = mapped_column(ForeignKey('AlternativeMappingAggregatorDAO.id', use_alter=True), nullable=True)


    __mapper_args__ = {
        'polymorphic_on': 'polymorphic_type',
        'polymorphic_identity': 'CustomEntityDAO',
    }

class DoublePositionAggregatorDAO(Base, DataAccessObject[classes.example_classes.DoublePositionAggregator]):
    __tablename__ = 'DoublePositionAggregatorDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)




    positions1: Mapped[List[PositionDAO]] = relationship('PositionDAO', foreign_keys='[PositionDAO.doublepositionaggregatordao_positions1_id]', post_update=True)
    positions2: Mapped[List[PositionDAO]] = relationship('PositionDAO', foreign_keys='[PositionDAO.doublepositionaggregatordao_positions2_id]', post_update=True)


class EntityAssociationDAO(Base, DataAccessObject[classes.example_classes.EntityAssociation]):
    __tablename__ = 'EntityAssociationDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)


    a: Mapped[List[str]] = mapped_column(JSON, nullable=False)

    entity_id: Mapped[int] = mapped_column(ForeignKey('CustomEntityDAO.id', use_alter=True), nullable=True)

    entity: Mapped[CustomEntityDAO] = relationship('CustomEntityDAO', uselist=False, foreign_keys=[entity_id], post_update=True)


class ItemWithBackreferenceDAO(Base, DataAccessObject[classes.example_classes.ItemWithBackreference]):
    __tablename__ = 'ItemWithBackreferenceDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)

    value: Mapped[int]


    containerdao_items_id: Mapped[Optional[int]] = mapped_column(ForeignKey('ContainerDAO.id', use_alter=True), nullable=True)
    container_id: Mapped[int] = mapped_column(ForeignKey('ContainerDAO.id', use_alter=True), nullable=True)

    container: Mapped[ContainerDAO] = relationship('ContainerDAO', uselist=False, foreign_keys=[container_id], post_update=True)


class KinematicChainDAO(Base, DataAccessObject[classes.example_classes.KinematicChain]):
    __tablename__ = 'KinematicChainDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)


    name: Mapped[str] = mapped_column(String(255), nullable=False)
    polymorphic_type: Mapped[str] = mapped_column(String(255), nullable=False)

    torsodao_kinematic_chains_id: Mapped[Optional[int]] = mapped_column(ForeignKey('TorsoDAO.id', use_alter=True), nullable=True)


    __mapper_args__ = {
        'polymorphic_on': 'polymorphic_type',
        'polymorphic_identity': 'KinematicChainDAO',
    }

class MoreShapesDAO(Base, DataAccessObject[classes.example_classes.MoreShapes]):
    __tablename__ = 'MoreShapesDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)




    shapes: Mapped[List[ShapesDAO]] = relationship('ShapesDAO', foreign_keys='[ShapesDAO.moreshapesdao_shapes_id]', post_update=True)


class NodeDAO(Base, DataAccessObject[classes.example_classes.Node]):
    __tablename__ = 'NodeDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)



    parent_id: Mapped[Optional[int]] = mapped_column(ForeignKey('NodeDAO.id', use_alter=True), nullable=True)

    parent: Mapped[NodeDAO] = relationship('NodeDAO', uselist=False, foreign_keys=[parent_id], post_update=True)


class ObjectAnnotationDAO(Base, DataAccessObject[classes.example_classes.ObjectAnnotation]):
    __tablename__ = 'ObjectAnnotationDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)



    object_reference_id: Mapped[int] = mapped_column(ForeignKey('OriginalSimulatedObjectDAO.id', use_alter=True), nullable=True)

    object_reference: Mapped[OriginalSimulatedObjectDAO] = relationship('OriginalSimulatedObjectDAO', uselist=False, foreign_keys=[object_reference_id], post_update=True)


class OrientationDAO(Base, DataAccessObject[classes.example_classes.Orientation]):
    __tablename__ = 'OrientationDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)

    x: Mapped[float]
    y: Mapped[float]
    z: Mapped[float]
    w: Mapped[Optional[float]]





class OriginalSimulatedObjectDAO(Base, DataAccessObject[classes.example_classes.OriginalSimulatedObject]):
    __tablename__ = 'OriginalSimulatedObjectDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)

    placeholder: Mapped[float]

    concept: Mapped[classes.example_classes.ConceptType] = mapped_column(classes.example_classes.ConceptType, nullable=False)




class PoseDAO(Base, DataAccessObject[classes.example_classes.Pose]):
    __tablename__ = 'PoseDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)



    position_id: Mapped[int] = mapped_column(ForeignKey('PositionDAO.id', use_alter=True), nullable=True)
    orientation_id: Mapped[int] = mapped_column(ForeignKey('OrientationDAO.id', use_alter=True), nullable=True)

    position: Mapped[PositionDAO] = relationship('PositionDAO', uselist=False, foreign_keys=[position_id], post_update=True)
    orientation: Mapped[OrientationDAO] = relationship('OrientationDAO', uselist=False, foreign_keys=[orientation_id], post_update=True)


class PositionDAO(Base, DataAccessObject[classes.example_classes.Position]):
    __tablename__ = 'PositionDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)

    x: Mapped[float]
    y: Mapped[float]
    z: Mapped[float]

    polymorphic_type: Mapped[str] = mapped_column(String(255), nullable=False)

    doublepositionaggregatordao_positions1_id: Mapped[Optional[int]] = mapped_column(ForeignKey('DoublePositionAggregatorDAO.id', use_alter=True), nullable=True)
    doublepositionaggregatordao_positions2_id: Mapped[Optional[int]] = mapped_column(ForeignKey('DoublePositionAggregatorDAO.id', use_alter=True), nullable=True)
    positionsdao_positions_id: Mapped[Optional[int]] = mapped_column(ForeignKey('PositionsDAO.id', use_alter=True), nullable=True)


    __mapper_args__ = {
        'polymorphic_on': 'polymorphic_type',
        'polymorphic_identity': 'PositionDAO',
    }

class PositionTypeWrapperDAO(Base, DataAccessObject[classes.example_classes.PositionTypeWrapper]):
    __tablename__ = 'PositionTypeWrapperDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)


    position_type: Mapped[TypeType] = mapped_column(TypeType, nullable=False)




class PositionsDAO(Base, DataAccessObject[classes.example_classes.Positions]):
    __tablename__ = 'PositionsDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)


    some_strings: Mapped[List[str]] = mapped_column(JSON, nullable=False)
    polymorphic_type: Mapped[str] = mapped_column(String(255), nullable=False)


    positions: Mapped[List[PositionDAO]] = relationship('PositionDAO', foreign_keys='[PositionDAO.positionsdao_positions_id]', post_update=True)

    __mapper_args__ = {
        'polymorphic_on': 'polymorphic_type',
        'polymorphic_identity': 'PositionsDAO',
    }

class PrivateDefaultFactoryDAO(Base, DataAccessObject[classes.example_classes.PrivateDefaultFactory]):
    __tablename__ = 'PrivateDefaultFactoryDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)

    public_value: Mapped[int]





class ReferenceDAO(Base, DataAccessObject[classes.example_classes.Reference]):
    __tablename__ = 'ReferenceDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)

    value: Mapped[int]


    backreference_id: Mapped[Optional[int]] = mapped_column(ForeignKey('BackreferenceMappingDAO.id', use_alter=True), nullable=True)

    backreference: Mapped[BackreferenceMappingDAO] = relationship('BackreferenceMappingDAO', uselist=False, foreign_keys=[backreference_id], post_update=True)


class RotationMappedDAO(Base, DataAccessObject[classes.example_classes.RotationMapped]):
    __tablename__ = 'RotationMappedDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)

    angle: Mapped[float]





class ShapeDAO(Base, DataAccessObject[classes.example_classes.Shape]):
    __tablename__ = 'ShapeDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)


    name: Mapped[str] = mapped_column(String(255), nullable=False)

    origin_id: Mapped[int] = mapped_column(ForeignKey('TransformationMappedDAO.id', use_alter=True), nullable=True)
    shapesdao_shapes_id: Mapped[Optional[int]] = mapped_column(ForeignKey('ShapesDAO.id', use_alter=True), nullable=True)

    origin: Mapped[TransformationMappedDAO] = relationship('TransformationMappedDAO', uselist=False, foreign_keys=[origin_id], post_update=True)


class ShapesDAO(Base, DataAccessObject[classes.example_classes.Shapes]):
    __tablename__ = 'ShapesDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)



    moreshapesdao_shapes_id: Mapped[Optional[int]] = mapped_column(ForeignKey('MoreShapesDAO.id', use_alter=True), nullable=True)

    shapes: Mapped[List[ShapeDAO]] = relationship('ShapeDAO', foreign_keys='[ShapeDAO.shapesdao_shapes_id]', post_update=True)


class TransformationMappedDAO(Base, DataAccessObject[classes.example_classes.TransformationMapped]):
    __tablename__ = 'TransformationMappedDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)



    vector_id: Mapped[int] = mapped_column(ForeignKey('VectorMappedDAO.id', use_alter=True), nullable=True)
    rotation_id: Mapped[int] = mapped_column(ForeignKey('RotationMappedDAO.id', use_alter=True), nullable=True)

    vector: Mapped[VectorMappedDAO] = relationship('VectorMappedDAO', uselist=False, foreign_keys=[vector_id], post_update=True)
    rotation: Mapped[RotationMappedDAO] = relationship('RotationMappedDAO', uselist=False, foreign_keys=[rotation_id], post_update=True)


class VectorMappedDAO(Base, DataAccessObject[classes.example_classes.VectorMapped]):
    __tablename__ = 'VectorMappedDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)

    x: Mapped[float]


    vectorswithpropertymappeddao_vectors_id: Mapped[Optional[int]] = mapped_column(ForeignKey('VectorsWithPropertyMappedDAO.id', use_alter=True), nullable=True)



class VectorsWithPropertyMappedDAO(Base, DataAccessObject[classes.example_classes.VectorsWithPropertyMapped]):
    __tablename__ = 'VectorsWithPropertyMappedDAO'

    id: Mapped[int] = mapped_column(Integer, primary_key=True)




    vectors: Mapped[List[VectorMappedDAO]] = relationship('VectorMappedDAO', foreign_keys='[VectorMappedDAO.vectorswithpropertymappeddao_vectors_id]', post_update=True)


class ChildBaseMappingDAO(ParentBaseMappingDAO, DataAccessObject[classes.example_classes.ChildBaseMapping]):
    __tablename__ = 'ChildBaseMappingDAO'

    id: Mapped[int] = mapped_column(ForeignKey(ParentBaseMappingDAO.id), primary_key=True)





    __mapper_args__ = {
        'polymorphic_identity': 'ChildBaseMappingDAO',
        'inherit_condition': id == ParentBaseMappingDAO.id,
    }

class ChildMappedDAO(ParentDAO, DataAccessObject[classes.example_classes.ChildMapped]):
    __tablename__ = 'ChildMappedDAO'

    id: Mapped[int] = mapped_column(ForeignKey(ParentDAO.id), primary_key=True)

    attribute1: Mapped[int]




    __mapper_args__ = {
        'polymorphic_identity': 'ChildMappedDAO',
        'inherit_condition': id == ParentDAO.id,
    }

class DerivedEntityDAO(CustomEntityDAO, DataAccessObject[classes.example_classes.DerivedEntity]):
    __tablename__ = 'DerivedEntityDAO'

    id: Mapped[int] = mapped_column(ForeignKey(CustomEntityDAO.id), primary_key=True)


    description: Mapped[str] = mapped_column(String(255), nullable=False)



    __mapper_args__ = {
        'polymorphic_identity': 'DerivedEntityDAO',
        'inherit_condition': id == CustomEntityDAO.id,
    }

class TorsoDAO(KinematicChainDAO, DataAccessObject[classes.example_classes.Torso]):
    __tablename__ = 'TorsoDAO'

    id: Mapped[int] = mapped_column(ForeignKey(KinematicChainDAO.id), primary_key=True)




    kinematic_chains: Mapped[List[KinematicChainDAO]] = relationship('KinematicChainDAO', foreign_keys='[KinematicChainDAO.torsodao_kinematic_chains_id]', post_update=True)

    __mapper_args__ = {
        'polymorphic_identity': 'TorsoDAO',
        'inherit_condition': id == KinematicChainDAO.id,
    }

class Position4DDAO(PositionDAO, DataAccessObject[classes.example_classes.Position4D]):
    __tablename__ = 'Position4DDAO'

    id: Mapped[int] = mapped_column(ForeignKey(PositionDAO.id), primary_key=True)

    w: Mapped[float]




    __mapper_args__ = {
        'polymorphic_identity': 'Position4DDAO',
        'inherit_condition': id == PositionDAO.id,
    }

class PositionsSubclassWithAnotherPositionDAO(PositionsDAO, DataAccessObject[classes.example_classes.PositionsSubclassWithAnotherPosition]):
    __tablename__ = 'PositionsSubclassWithAnotherPositionDAO'

    id: Mapped[int] = mapped_column(ForeignKey(PositionsDAO.id), primary_key=True)



    positions2_id: Mapped[int] = mapped_column(ForeignKey('PositionDAO.id', use_alter=True), nullable=True)

    positions2: Mapped[PositionDAO] = relationship('PositionDAO', uselist=False, foreign_keys=[positions2_id], post_update=True)

    __mapper_args__ = {
        'polymorphic_identity': 'PositionsSubclassWithAnotherPositionDAO',
        'inherit_condition': id == PositionsDAO.id,
    }

class Position5DDAO(Position4DDAO, DataAccessObject[classes.example_classes.Position5D]):
    __tablename__ = 'Position5DDAO'

    id: Mapped[int] = mapped_column(ForeignKey(Position4DDAO.id), primary_key=True)

    v: Mapped[float]




    __mapper_args__ = {
        'polymorphic_identity': 'Position5DDAO',
        'inherit_condition': id == Position4DDAO.id,
    }

