import numpy as np
import pandas as pd

beam_2d_squ_nodes = pd.DataFrame(
    data=np.array([[-30., 25., 0.],
                   [-25., 25., 0.],
                   [-20., 25., 0.],
                   [-15., 25., 0.],
                   [-10., 25., 0.],
                   [-5., 25., 0.],
                   [0., 25., 0.],
                   [5., 25., 0.],
                   [10., 25., 0.],
                   [-30., 30., 0.],
                   [-25., 30., 0.],
                   [-20., 30., 0.],
                   [-15., 30., 0.],
                   [-10., 30., 0.],
                   [-5., 30., 0.],
                   [0., 30., 0.],
                   [5., 30., 0.],
                   [10., 30., 0.]]),
    columns=['x', 'y', 'z'],
    index=pd.Index(np.arange(1, 19), name="node_id", dtype=np.int32)
)

beam_2d_squ_mesh_index = pd.MultiIndex.from_arrays(
    [
        [1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8],
        [1, 2, 11, 10, 2, 3, 12, 11, 3, 4, 13, 12, 4, 5, 14, 13, 5, 6, 15, 14, 6, 7, 16, 15, 7, 8, 17, 16, 8, 9, 18, 17]
    ],
    names=['element_id', 'node_id']
)

beam_2d_squ_mesh_index_load = pd.MultiIndex.from_arrays(
    [
        [8],
        [9]
    ],
    names=['element_id', 'node_id']
)

beam_2d_squ_mesh_index_fix = pd.MultiIndex.from_arrays(
    [
        [1, 1],
        [1, 10]
    ],
    names=['element_id', 'node_id']
)

rotsym_quad_mesh_index_ysym = pd.MultiIndex.from_arrays(
    [
        [7, 7, 7, 7, 8, 8, 8, 8],
        [5, 4, 13, 14, 14, 13, 2, 6]
    ],
    names=['element_id', 'node_id']
)

rotsym_quad_mesh_coords_ysym = pd.DataFrame(
    data=np.array([
        [5.0, 10., 0.0],
        [7.5, 12.5, 0.0],
        [4.70654774, 12.4430714, 0.0],
        [2.5, 10., 0.0],
        [2.5, 10., 0.0],
        [4.70654774, 12.4430714, 0.0],
        [2.66258526, 12.3712873, 0.0],
        [0.0, 10., 0.0],
    ]),
    columns=['x', 'y', 'z'],
    index=rotsym_quad_mesh_index_ysym
)

rotsym_quad_stress_cauchy = pd.DataFrame(
    data=np.array([
        [-3.284145e+07, -68454408.0, 7530090.0, -57887692.0, 0.0, 0.0],
        [-3.284145e+07, -68454408.0, 7530090.0, -57887692.0, 0.0, 0.0],
        [-3.284145e+07, -68454408.0, 7530090.0, -57887692.0, 0.0, 0.0],
        [-3.284145e+07, -68454408.0, 7530090.0, -57887692.0, 0.0, 0.0],
        [4.888547e+06, -68804624.0, 29415748.0, -27465756.0, 0.0, 0.0],
        [4.888547e+06, -68804624.0, 29415748.0, -27465756.0, 0.0, 0.0],
        [4.888547e+06, -68804624.0, 29415748.0, -27465756.0, 0.0, 0.0],
        [4.888547e+06, -68804624.0, 29415748.0, -27465756.0, 0.0, 0.0],
        [6.864822e+06, -93171472.0, 36264708.0, -10031535.0, 0.0, 0.0],
        [6.864822e+06, -93171472.0, 36264708.0, -10031535.0, 0.0, 0.0],
        [6.864822e+06, -93171472.0, 36264708.0, -10031535.0, 0.0, 0.0],
        [6.864822e+06, -93171472.0, 36264708.0, -10031535.0, 0.0, 0.0],
        [-6.003653e+06, -259111728.0, -35755684.0, -68525928.0, 0.0, 0.0],
        [-6.003653e+06, -259111728.0, -35755684.0, -68525928.0, 0.0, 0.0],
        [-6.003653e+06, -259111728.0, -35755684.0, -68525928.0, 0.0, 0.0],
        [-6.003653e+06, -259111728.0, -35755684.0, -68525928.0, 0.0, 0.0],
        [1.262036e+07, -140693424.0, 22133048.0, -62435780.0, 0.0, 0.0],
        [1.262036e+07, -140693424.0, 22133048.0, -62435780.0, 0.0, 0.0],
        [1.262036e+07, -140693424.0, 22133048.0, -62435780.0, 0.0, 0.0],
        [1.262036e+07, -140693424.0, 22133048.0, -62435780.0, 0.0, 0.0],
        [3.393907e+07, -103849112.0, 58507512.0, -25443218.0, 0.0, 0.0],
        [3.393907e+07, -103849112.0, 58507512.0, -25443218.0, 0.0, 0.0],
        [3.393907e+07, -103849112.0, 58507512.0, -25443218.0, 0.0, 0.0],
        [3.393907e+07, -103849112.0, 58507512.0, -25443218.0, 0.0, 0.0],
        [-9.841458e+07, -257062992.0, -87320816.0, -94479832.0, 0.0, 0.0],
        [-9.841458e+07, -257062992.0, -87320816.0, -94479832.0, 0.0, 0.0],
        [-9.841458e+07, -257062992.0, -87320816.0, -94479832.0, 0.0, 0.0],
        [-9.841458e+07, -257062992.0, -87320816.0, -94479832.0, 0.0, 0.0],
        [-6.229298e+07, -272502592.0, -82643808.0, 15466551.0, 0.0, 0.0],
        [-6.229298e+07, -272502592.0, -82643808.0, 15466551.0, 0.0, 0.0],
        [-6.229298e+07, -272502592.0, -82643808.0, 15466551.0, 0.0, 0.0],
        [-6.229298e+07, -272502592.0, -82643808.0, 15466551.0, 0.0, 0.0],
        [-5.494630e+07, -156407904.0, -39763184.0, 45185840.0, 0.0, 0.0],
        [-5.494630e+07, -156407904.0, -39763184.0, 45185840.0, 0.0, 0.0],
        [-5.494630e+07, -156407904.0, -39763184.0, 45185840.0, 0.0, 0.0],
        [-5.494630e+07, -156407904.0, -39763184.0, 45185840.0, 0.0, 0.0],
        [-1.266122e+06, -202149280.0, 5385842.5, -27361616.0, 0.0, 0.0],
        [-1.266122e+06, -202149280.0, 5385842.5, -27361616.0, 0.0, 0.0],
        [-1.266122e+06, -202149280.0, 5385842.5, -27361616.0, 0.0, 0.0],
        [-1.266122e+06, -202149280.0, 5385842.5, -27361616.0, 0.0, 0.0],
        [7.847147e+07, -129699864.0, 78872944.0, -21347140.0, 0.0, 0.0],
        [7.847147e+07, -129699864.0, 78872944.0, -21347140.0, 0.0, 0.0],
        [7.847147e+07, -129699864.0, 78872944.0, -21347140.0, 0.0, 0.0],
        [7.847147e+07, -129699864.0, 78872944.0, -21347140.0, 0.0, 0.0],
    ]),
    columns=['S11', 'S22', 'S33', 'S12', 'S13', 'S23'],
    index=pd.MultiIndex.from_tuples([
        (1, 4),
        (1, 8),
        (1, 17),
        (1, 13),
        (2, 8),
        (2, 9),
        (2, 18),
        (2, 17),
        (3, 9),
        (3, 1),
        (3, 10),
        (3, 18),
        (4, 13),
        (4, 17),
        (4, 11),
        (4, 2),
        (5, 17),
        (5, 18),
        (5, 12),
        (5, 11),
        (6, 18),
        (6, 10),
        (6, 3),
        (6, 12),
        (7, 5),
        (7, 4),
        (7, 13),
        (7, 14),
        (8, 14),
        (8, 13),
        (8, 2),
        (8, 6),
        (9, 2),
        (9, 11),
        (9, 15),
        (9, 6),
        (10, 11),
        (10, 12),
        (10, 16),
        (10, 15),
        (11, 12),
        (11, 3),
        (11, 7),
        (11, 16)],
        names=['element_id', 'node_id'])
)

beam_2d_squ_mesh_coords = pd.DataFrame(data=np.array(
    [
        [-30., 25., 0.],  # 1
        [-25., 25., 0.],  # 2
        [-25., 30., 0.],  # 11
        [-30., 30., 0.],  # 10
        [-25., 25., 0.],  # 2
        [-20., 25., 0.],  # 3
        [-20., 30., 0.],  # 12
        [-25., 30., 0.],  # 11
        [-20., 25., 0.],  # 3
        [-15., 25., 0.],  # 4
        [-15., 30., 0.],  # 13
        [-20., 30., 0.],  # 12
        [-15., 25., 0.],  # 4
        [-10., 25., 0.],  # 5
        [-10., 30., 0.],  # 14
        [-15., 30., 0.],  # 13
        [-10., 25., 0.],  # 5
        [-5., 25., 0.],  # 6
        [-5., 30., 0.],  # 15
        [-10., 30., 0.],  # 14
        [-5., 25., 0.],  # 6
        [0., 25., 0.],  # 7
        [0., 30., 0.],  # 16
        [-5., 30., 0.],  # 15
        [0., 25., 0.],  # 7
        [5., 25., 0.],  # 8
        [5., 30., 0.],  # 17
        [0., 30., 0.],  # 16
        [5., 25., 0.],  # 8
        [10., 25., 0.],  # 9
        [10., 30., 0.],  # 18
        [5., 30., 0.],  # 17
    ]),
    columns=['x', 'y', 'z'],
    index=beam_2d_squ_mesh_index
)

beam_2d_squ_node_displacement = pd.DataFrame(
    data=np.array(
        [
            [-800.000E-36, -94.4166E-36, 0.0],
            [-7.79987E-06, -7.80086E-06, 0.0],
            [-14.5600E-06, -30.1635E-06, 0.0],
            [-20.2799E-06, -65.0026E-06, 0.0],
            [-24.9600E-06, -110.247E-06, 0.0],
            [-28.5999E-06, -163.804E-06, 0.0],
            [-31.2000E-06, -223.611E-06, 0.0],
            [-32.7599E-06, -287.566E-06, 0.0],
            [-33.2800E-06, -353.614E-06, 0.0],
            [800.000E-36, -5.58338E-36, 0.0],
            [7.80013E-06, -7.80174E-06, 0.0],
            [14.5600E-06, -30.1617E-06, 0.0],
            [20.2801E-06, -65.0052E-06, 0.0],
            [24.9600E-06, -110.243E-06, 0.0],
            [28.6001E-06, -163.809E-06, 0.0],
            [31.2000E-06, -223.605E-06, 0.0],
            [32.7601E-06, -287.572E-06, 0.0],
            [33.2800E-06, -353.607E-06, 0.0]
        ]
    ),
    columns=['dx', 'dy', 'dz'],
    index=pd.Index(np.arange(1, 19), name="node_id")
)

beam_3d_hex_element_volume = pd.DataFrame(
    data=[1e3, 1e3, 1e3, 1e3],
    columns=['Ve'],
    index=pd.Index([1, 2, 3, 4], name='element_id')
)

beam_3d_hex_stress_element_volume = pd.DataFrame(
    data=np.array([
        [4.534151e-13, 1.795928, 0.056395, -2.0, 1.488919e-12, -2.761504e-12, 1e3],
        [4.534151e-13, 1.795928, 0.056395, -2.0, 1.488919e-12, -2.761504e-12, 1e3],
        [4.534151e-13, 1.795928, 0.056395, -2.0, 1.488919e-12, -2.761504e-12, 1e3],
        [4.534151e-13, 1.795928, 0.056395, -2.0, 1.488919e-12, -2.761504e-12, 1e3],
        [4.534151e-13, 1.795928, 0.056395, -2.0, 1.488919e-12, -2.761504e-12, 1e3],
        [4.534151e-13, 1.795928, 0.056395, -2.0, 1.488919e-12, -2.761504e-12, 1e3],
        [4.534151e-13, 1.795928, 0.056395, -2.0, 1.488919e-12, -2.761504e-12, 1e3],
        [4.534151e-13, 1.795928, 0.056395, -2.0, 1.488919e-12, -2.761504e-12, 1e3],
        [4.690692e-14, -1.821834, -0.049344, -2.0, -1.056252e-12, -2.583355e-12, 1e3],
        [4.690692e-14, -1.821834, -0.049344, -2.0, -1.056252e-12, -2.583355e-12, 1e3],
        [4.690692e-14, -1.821834, -0.049344, -2.0, -1.056252e-12, -2.583355e-12, 1e3],
        [4.690692e-14, -1.821834, -0.049344, -2.0, -1.056252e-12, -2.583355e-12, 1e3],
        [4.690692e-14, -1.821834, -0.049344, -2.0, -1.056252e-12, -2.583355e-12, 1e3],
        [4.690692e-14, -1.821834, -0.049344, -2.0, -1.056252e-12, -2.583355e-12, 1e3],
        [4.690692e-14, -1.821834, -0.049344, -2.0, -1.056252e-12, -2.583355e-12, 1e3],
        [4.690692e-14, -1.821834, -0.049344, -2.0, -1.056252e-12, -2.583355e-12, 1e3],
        [8.767431e-13, 1.874053, 0.035027, -2.0, 2.519726e-12, -1.425290e-12, 1e3],
        [8.767431e-13, 1.874053, 0.035027, -2.0, 2.519726e-12, -1.425290e-12, 1e3],
        [8.767431e-13, 1.874053, 0.035027, -2.0, 2.519726e-12, -1.425290e-12, 1e3],
        [8.767431e-13, 1.874053, 0.035027, -2.0, 2.519726e-12, -1.425290e-12, 1e3],
        [8.767431e-13, 1.874053, 0.035027, -2.0, 2.519726e-12, -1.425290e-12, 1e3],
        [8.767431e-13, 1.874053, 0.035027, -2.0, 2.519726e-12, -1.425290e-12, 1e3],
        [8.767431e-13, 1.874053, 0.035027, -2.0, 2.519726e-12, -1.425290e-12, 1e3],
        [8.767431e-13, 1.874053, 0.035027, -2.0, 2.519726e-12, -1.425290e-12, 1e3],
        [2.789879e-12, -1.953409, -0.013005, -2.0, 2.059563e-12, 4.052017e-13, 1e3],
        [2.789879e-12, -1.953409, -0.013005, -2.0, 2.059563e-12, 4.052017e-13, 1e3],
        [2.789879e-12, -1.953409, -0.013005, -2.0, 2.059563e-12, 4.052017e-13, 1e3],
        [2.789879e-12, -1.953409, -0.013005, -2.0, 2.059563e-12, 4.052017e-13, 1e3],
        [2.789879e-12, -1.953409, -0.013005, -2.0, 2.059563e-12, 4.052017e-13, 1e3],
        [2.789879e-12, -1.953409, -0.013005, -2.0, 2.059563e-12, 4.052017e-13, 1e3],
        [2.789879e-12, -1.953409, -0.013005, -2.0, 2.059563e-12, 4.052017e-13, 1e3],
        [2.789879e-12, -1.953409, -0.013005, -2.0, 2.059563e-12, 4.052017e-13, 1e3],
    ]),
    columns=['S11', 'S22', 'S33', 'S12', 'S13', 'S23', 'V_e'],
    index=pd.MultiIndex.from_arrays(np.array([
        [1, 5],
        [1, 6],
        [1, 8],
        [1, 7],
        [1, 1],
        [1, 2],
        [1, 4],
        [1, 3],
        [2, 9],
        [2, 10],
        [2, 12],
        [2, 11],
        [2, 5],
        [2, 6],
        [2, 8],
        [2, 7],
        [3, 13],
        [3, 14],
        [3, 16],
        [3, 15],
        [3, 9],
        [3, 10],
        [3, 12],
        [3, 11],
        [4, 17],
        [4, 18],
        [4, 20],
        [4, 19],
        [4, 13],
        [4, 14],
        [4, 16],
        [4, 15],
    ]).T, names=['element_id', 'node_id'])
)

beam_2d_squ_element_nodal_stress = pd.DataFrame(
    data=[
        [-390.938E-12, -17.7838, 0., -20., 0., 0.],
        [-393.265E-12, -17.7838, 0., -20., 0., 0.],
        [-393.265E-12, -17.7838, 0., -20., 0., 0.],
        [-390.938E-12, -17.7838, 0., -20., 0., 0.],
        [-393.265E-12, 17.8522, 0., -20., 0., 0.],
        [-300.185E-12, 17.8522, 0., -20., 0., 0.],
        [-300.185E-12, 17.8522, 0., -20., 0., 0.],
        [-393.265E-12, 17.8522, 0., -20., 0., 0.],
        [-300.185E-12, -17.9894, 0., -20., 0., 0.],
        [-316.474E-12, -17.9894, 0., -20., 0., 0.],
        [-316.474E-12, -17.9894, 0., -20., 0., 0.],
        [-300.185E-12, -17.9894, 0., -20., 0., 0.],
        [-316.474E-12, 18.1959, 0., -20., 0., 0.],
        [-37.2320E-12, 18.1959, 0., -20., 0., 0.],
        [-37.2320E-12, 18.1959, 0., -20., 0., 0.],
        [-316.474E-12, 18.1959, 0., -20., 0., 0.],
        [-37.2320E-12, -18.4724, 0., -20., 0., 0.],
        [567.792E-12, -18.4724, 0., -20., 0., 0.],
        [567.792E-12, -18.4724, 0., -20., 0., 0.],
        [-37.2320E-12, -18.4724, 0., -20., 0., 0.],
        [567.792E-12, 18.8200, 0., -20., 0., 0.],
        [353.706E-12, 18.8200, 0., -20., 0., 0.],
        [353.706E-12, 18.8200, 0., -20., 0., 0.],
        [567.792E-12, 18.8200, 0., -20., 0., 0.],
        [353.706E-12, -19.2400, 0., -20., 0., 0.],
        [-195.469E-12, -19.2400, 0., -20., 0., 0.],
        [-195.469E-12, -19.2400, 0., -20., 0., 0.],
        [353.706E-12, -19.2400, 0., -20., 0., 0.],
        [-195.469E-12, 19.7342, 0., -20., 0., 0.],
        [-316.474E-12, 19.7342, 0., -20., 0., 0.],
        [-316.474E-12, 19.7342, 0., -20., 0., 0.],
        [-195.469E-12, 19.7342, 0., -20., 0., 0.],
    ],
    columns=['S11', 'S22', 'S33', 'S12', 'S13', 'S23'],
    index=beam_2d_squ_mesh_index
)

beam_2d_squ_element_nodal_strain = pd.DataFrame(
    data=[
        [26.6756E-12, -88.9187E-12, 0., -260.000E-12, 0., 0.],
        [26.6756E-12, -88.9187E-12, 0., -260.000E-12, 0., 0.],
        [26.6756E-12, -88.9187E-12, 0., -260.000E-12, 0., 0.],
        [26.6756E-12, -88.9187E-12, 0., -260.000E-12, 0., 0.],
        [-26.7783E-12, 89.2611E-12, 0., -260.000E-12, 0., 0.],
        [-26.7783E-12, 89.2611E-12, 0., -260.000E-12, 0., 0.],
        [-26.7783E-12, 89.2611E-12, 0., -260.000E-12, 0., 0.],
        [-26.7783E-12, 89.2611E-12, 0., -260.000E-12, 0., 0.],
        [26.9841E-12, -89.9470E-12, 0., -260.000E-12, 0., 0.],
        [26.9841E-12, -89.9470E-12, 0., -260.000E-12, 0., 0.],
        [26.9841E-12, -89.9470E-12, 0., -260.000E-12, 0., 0.],
        [26.9841E-12, -89.9470E-12, 0., -260.000E-12, 0., 0.],
        [-27.2938E-12, 90.9793E-12, 0., -260.000E-12, 0., 0.],
        [-27.2938E-12, 90.9793E-12, 0., -260.000E-12, 0., 0.],
        [-27.2938E-12, 90.9793E-12, 0., -260.000E-12, 0., 0.],
        [-27.2938E-12, 90.9793E-12, 0., -260.000E-12, 0., 0.],
        [27.7085E-12, -92.3618E-12, 0., -260.000E-12, 0., 0.],
        [27.7085E-12, -92.3618E-12, 0., -260.000E-12, 0., 0.],
        [27.7085E-12, -92.3618E-12, 0., -260.000E-12, 0., 0.],
        [27.7085E-12, -92.3618E-12, 0., -260.000E-12, 0., 0.],
        [-28.2300E-12, 94.0999E-12, 0., -260.000E-12, 0., 0.],
        [-28.2300E-12, 94.0999E-12, 0., -260.000E-12, 0., 0.],
        [-28.2300E-12, 94.0999E-12, 0., -260.000E-12, 0., 0.],
        [-28.2300E-12, 94.0999E-12, 0., -260.000E-12, 0., 0.],
        [28.8601E-12, -96.2002E-12, 0., -260.000E-12, 0., 0.],
        [28.8601E-12, -96.2002E-12, 0., -260.000E-12, 0., 0.],
        [28.8601E-12, -96.2002E-12, 0., -260.000E-12, 0., 0.],
        [28.8601E-12, -96.2002E-12, 0., -260.000E-12, 0., 0.],
        [-29.6013E-12, 98.6710E-12, 0., -260.000E-12, 0., 0.],
        [-29.6013E-12, 98.6710E-12, 0., -260.000E-12, 0., 0.],
        [-29.6013E-12, 98.6710E-12, 0., -260.000E-12, 0., 0.],
        [-29.6013E-12, 98.6710E-12, 0., -260.000E-12, 0., 0.]
    ],
    columns=['E11', 'E22', 'E33', 'E12', 'E13', 'E23'],
    index=beam_2d_squ_mesh_index
)

integration_type_content = {
    'TYPE1': [0, 'GAUSS_TRIANGLE_3', 3, 2, 0.0,
              [0.166667, 0.166667, 0.666667, 0.166667, 0.166667, 0.666667],
              [0.333333, 0.333333, 0.333333], []],
    'TYPE2': [1, 'GAUSS_QUAD_9', 9, 2, 0.0,
              [-0.774597, -0.774597, 0, -0.774597, 0.774597, -0.774597, -0.774597, 0, 0, 0,
               0.774597, 0, -0.774597, 0.774597, 0, 0.774597, 0.774597, 0.774597],
              [0.308642, 0.493827, 0.308642, 0.493827, 0.790123, 0.493827, 0.308642, 0.493827, 0.308642], []]
}
