import edlib
import Bio
from Bio import Seq

def do_align():
    seqa = "AACTTCCATTTGCTGCTGGTGGACGAGGCGCACTTCATCAAGAAAGAGGCCTTCAACACCATTCTGGGGTTCCTGGCCCAGAATACCACCAAGATCATCTTCATATCGTCCACCAACACTACCAGTGACGCCACGTGTTTCTTGACGCGCCTCAACAATGCGCCCTTTGACATGCTCAACGTGGTCTCTTACGTGTGCGAAGAGCACCTGCACAGCTTCACGGAGAAGGGCGACGCCACGGCGTGTCCTTGCTACCGACTGCACAAGCCCACCTTCATCAGCCTCAACTCGCAGGTGCGCAAGACGGCCAACATGTTTATGCCGGGCGCTTTCATGGACGAGATCATCGGCGGTACCAATAAAATCTCGCAGAACACCGTGCTCATCACGGACCAGAGCCGCGAAGAGTTCGATATTTTGCGTTACAGCACGCTCAACACCAACGCCTACGATTATTTCGGCAAGACGCTTTACGTGTATCTGGACCCGGCCTTCACCACCAACCGCAAGGCCTCGGGCACGGGCGTGGCGGCCGTAGGCGCCTACCGACACCAGTTTCTCATTTACGGCCTAGAGCATTTCTTTTTGCGCGACCTCTCCGAGAGTTCTGAGGTAGCCATCGCCGAGTGCGCGGCGCACATGATCATCTCGGTGCTGAGCCTGCACCCTTACCTGGACGAACTGCGTATCGCCGTGGAGGGCAACACCAACCAGGCGGCGGCCGTGCGCATCGCCTGCCTCATCCGACAGAGCGTGCAGAGCAGCACGCTCATCCGCGTGCTCTTCTACCACACGCCCGACCAGAACCACATCGAACAGCCCTTCTACCTCATGGGCCGCGACAAGGCGCTGGCCGTGGAACAGTTCATCTCGCGTTTCAACTCGGG"
    seqb = "AACTTCCATTTGCTGCTGGTGGACGAGGCGCACTTCATCAAGAAAGAGGCCTTCCATACCATTCTGGGGTTCCTGGCCCAGAATACCACCAAGATCATCTTCATATCGTCCACCAACACTACCAGTGAAGCCACGTGTTTCTTGACGCGCCTCAACAATGCGCCCTTTGACATTCTCAACGTGGTCTCTTACGTGTGCGAAGAGCACCTGCACAGCTTCACGGAGAAGGGCGACGCCACGGCGTGTCCTTGCTACCGACTGCACAAGCCCACCTTCATCAGCCTCAACTCGCAGGTGCGCAAGACGGCCAACATGTTTATGCCGGGCGCTTTCATGGACGAGATCATCGGCGGTACCAATAAAATCTCGCAGAACACCGTGCTCATCACGGACCAGAGCCGCGAAGAGTTCGATATTTTGCGTTACAGCACGCTCAACACCAACGCCTACGATTATTTCGGCAAGACGCTTTACGTGTATCTGGACCCGGCCTTCACCACCAACCGCAAGGCCTCGGGCACGGGCGTGGCGGCCGTAGGCGCCTACCGACACCAGTTTCTCATTTACGGCCTAGAGCATTTCTTTTTGCGCGACCTCTCCGAGAGTTCTGAGGTAGCCATCGCCGAGTGCGCGGCGCACATGATCATCTCGGTGCTGAGCCTGCACCCTTACCTGGACGAACTGCGTATCGCCGTGGAGGGCAACACCAACCAGGCGGCGGCCGTGCGCATCGCCTGCCTCATCCGACAGAGCGTGCAGAGCAGCACGCTCATCCGCGTGCTCTTCTACCACACGCCCGACCAGAACCACATCGAACAGCCCTTCTACCTCATGGGCCGCGACAAGGCGCTGGCCGTGGAACAGTTCATCTCGCGTTTCAACTCGGG"
    
    # seqb = Seq.reverse_complement(seqb)
    
    result = edlib.align(seqa, seqb, mode="NW", task="path")
    print(result)
    
    nice = edlib.getNiceAlignment(result, seqa, seqb)
    print("\n".join(nice.values()))
    
    pass


if __name__ == "__main__":
    do_align()
    pass