# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertV2Args', 'AlertV2']

@pulumi.input_type
class AlertV2Args:
    def __init__(__self__, *,
                 custom_description: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_summary: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 evaluation: Optional[pulumi.Input['AlertV2EvaluationArgs']] = None,
                 parent_path: Optional[pulumi.Input[_builtins.str]] = None,
                 query_text: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input['AlertV2ScheduleArgs']] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AlertV2 resource.
        :param pulumi.Input[_builtins.str] custom_description: Custom description for the alert. support mustache template
        :param pulumi.Input[_builtins.str] custom_summary: Custom summary for the alert. support mustache template
        :param pulumi.Input[_builtins.str] display_name: The display name of the alert
        :param pulumi.Input[_builtins.str] parent_path: The workspace path of the folder containing the alert. Can only be set on create, and cannot be updated
        :param pulumi.Input[_builtins.str] query_text: Text of the query to be run
        :param pulumi.Input[_builtins.str] warehouse_id: ID of the SQL warehouse attached to the alert
        """
        if custom_description is not None:
            pulumi.set(__self__, "custom_description", custom_description)
        if custom_summary is not None:
            pulumi.set(__self__, "custom_summary", custom_summary)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if evaluation is not None:
            pulumi.set(__self__, "evaluation", evaluation)
        if parent_path is not None:
            pulumi.set(__self__, "parent_path", parent_path)
        if query_text is not None:
            pulumi.set(__self__, "query_text", query_text)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if warehouse_id is not None:
            pulumi.set(__self__, "warehouse_id", warehouse_id)

    @_builtins.property
    @pulumi.getter(name="customDescription")
    def custom_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom description for the alert. support mustache template
        """
        return pulumi.get(self, "custom_description")

    @custom_description.setter
    def custom_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_description", value)

    @_builtins.property
    @pulumi.getter(name="customSummary")
    def custom_summary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom summary for the alert. support mustache template
        """
        return pulumi.get(self, "custom_summary")

    @custom_summary.setter
    def custom_summary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_summary", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the alert
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def evaluation(self) -> Optional[pulumi.Input['AlertV2EvaluationArgs']]:
        return pulumi.get(self, "evaluation")

    @evaluation.setter
    def evaluation(self, value: Optional[pulumi.Input['AlertV2EvaluationArgs']]):
        pulumi.set(self, "evaluation", value)

    @_builtins.property
    @pulumi.getter(name="parentPath")
    def parent_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workspace path of the folder containing the alert. Can only be set on create, and cannot be updated
        """
        return pulumi.get(self, "parent_path")

    @parent_path.setter
    def parent_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_path", value)

    @_builtins.property
    @pulumi.getter(name="queryText")
    def query_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Text of the query to be run
        """
        return pulumi.get(self, "query_text")

    @query_text.setter
    def query_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_text", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['AlertV2ScheduleArgs']]:
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['AlertV2ScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the SQL warehouse attached to the alert
        """
        return pulumi.get(self, "warehouse_id")

    @warehouse_id.setter
    def warehouse_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse_id", value)


@pulumi.input_type
class _AlertV2State:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_description: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_summary: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 evaluation: Optional[pulumi.Input['AlertV2EvaluationArgs']] = None,
                 lifecycle_state: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_path: Optional[pulumi.Input[_builtins.str]] = None,
                 query_text: Optional[pulumi.Input[_builtins.str]] = None,
                 run_as_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input['AlertV2ScheduleArgs']] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AlertV2 resources.
        :param pulumi.Input[_builtins.str] create_time: (string) - The timestamp indicating when the alert was created
        :param pulumi.Input[_builtins.str] custom_description: Custom description for the alert. support mustache template
        :param pulumi.Input[_builtins.str] custom_summary: Custom summary for the alert. support mustache template
        :param pulumi.Input[_builtins.str] display_name: The display name of the alert
        :param pulumi.Input[_builtins.str] lifecycle_state: (string) - Indicates whether the query is trashed. Possible values are: `ACTIVE`, `TRASHED`
        :param pulumi.Input[_builtins.str] owner_user_name: (string) - The owner's username. This field is set to "Unavailable" if the user has been deleted
        :param pulumi.Input[_builtins.str] parent_path: The workspace path of the folder containing the alert. Can only be set on create, and cannot be updated
        :param pulumi.Input[_builtins.str] query_text: Text of the query to be run
        :param pulumi.Input[_builtins.str] run_as_user_name: (string) - The run as username. This field is set to "Unavailable" if the user has been deleted
        :param pulumi.Input[_builtins.str] update_time: (string) - The timestamp indicating when the alert was updated
        :param pulumi.Input[_builtins.str] warehouse_id: ID of the SQL warehouse attached to the alert
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_description is not None:
            pulumi.set(__self__, "custom_description", custom_description)
        if custom_summary is not None:
            pulumi.set(__self__, "custom_summary", custom_summary)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if evaluation is not None:
            pulumi.set(__self__, "evaluation", evaluation)
        if lifecycle_state is not None:
            pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if owner_user_name is not None:
            pulumi.set(__self__, "owner_user_name", owner_user_name)
        if parent_path is not None:
            pulumi.set(__self__, "parent_path", parent_path)
        if query_text is not None:
            pulumi.set(__self__, "query_text", query_text)
        if run_as_user_name is not None:
            pulumi.set(__self__, "run_as_user_name", run_as_user_name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if warehouse_id is not None:
            pulumi.set(__self__, "warehouse_id", warehouse_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The timestamp indicating when the alert was created
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customDescription")
    def custom_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom description for the alert. support mustache template
        """
        return pulumi.get(self, "custom_description")

    @custom_description.setter
    def custom_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_description", value)

    @_builtins.property
    @pulumi.getter(name="customSummary")
    def custom_summary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom summary for the alert. support mustache template
        """
        return pulumi.get(self, "custom_summary")

    @custom_summary.setter
    def custom_summary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_summary", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the alert
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def evaluation(self) -> Optional[pulumi.Input['AlertV2EvaluationArgs']]:
        return pulumi.get(self, "evaluation")

    @evaluation.setter
    def evaluation(self, value: Optional[pulumi.Input['AlertV2EvaluationArgs']]):
        pulumi.set(self, "evaluation", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Indicates whether the query is trashed. Possible values are: `ACTIVE`, `TRASHED`
        """
        return pulumi.get(self, "lifecycle_state")

    @lifecycle_state.setter
    def lifecycle_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_state", value)

    @_builtins.property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The owner's username. This field is set to "Unavailable" if the user has been deleted
        """
        return pulumi.get(self, "owner_user_name")

    @owner_user_name.setter
    def owner_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_user_name", value)

    @_builtins.property
    @pulumi.getter(name="parentPath")
    def parent_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workspace path of the folder containing the alert. Can only be set on create, and cannot be updated
        """
        return pulumi.get(self, "parent_path")

    @parent_path.setter
    def parent_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_path", value)

    @_builtins.property
    @pulumi.getter(name="queryText")
    def query_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Text of the query to be run
        """
        return pulumi.get(self, "query_text")

    @query_text.setter
    def query_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_text", value)

    @_builtins.property
    @pulumi.getter(name="runAsUserName")
    def run_as_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The run as username. This field is set to "Unavailable" if the user has been deleted
        """
        return pulumi.get(self, "run_as_user_name")

    @run_as_user_name.setter
    def run_as_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_as_user_name", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['AlertV2ScheduleArgs']]:
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['AlertV2ScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The timestamp indicating when the alert was updated
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the SQL warehouse attached to the alert
        """
        return pulumi.get(self, "warehouse_id")

    @warehouse_id.setter
    def warehouse_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse_id", value)


@pulumi.type_token("databricks:index/alertV2:AlertV2")
class AlertV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_description: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_summary: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 evaluation: Optional[pulumi.Input[Union['AlertV2EvaluationArgs', 'AlertV2EvaluationArgsDict']]] = None,
                 parent_path: Optional[pulumi.Input[_builtins.str]] = None,
                 query_text: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['AlertV2ScheduleArgs', 'AlertV2ScheduleArgsDict']]] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The Alert v2 resource allows you to manage SQL alerts in Databricks SQL. Alerts monitor query results and notify you when specific conditions are met.

        Alerts run on a schedule and evaluate query results against defined thresholds. When an alert is triggered, notifications can be sent to specified users or destinations.

        ## Example Usage

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = id

          to = databricks_alert_v2.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/alertV2:AlertV2 databricks_alert_v2 id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_description: Custom description for the alert. support mustache template
        :param pulumi.Input[_builtins.str] custom_summary: Custom summary for the alert. support mustache template
        :param pulumi.Input[_builtins.str] display_name: The display name of the alert
        :param pulumi.Input[_builtins.str] parent_path: The workspace path of the folder containing the alert. Can only be set on create, and cannot be updated
        :param pulumi.Input[_builtins.str] query_text: Text of the query to be run
        :param pulumi.Input[_builtins.str] warehouse_id: ID of the SQL warehouse attached to the alert
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AlertV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Alert v2 resource allows you to manage SQL alerts in Databricks SQL. Alerts monitor query results and notify you when specific conditions are met.

        Alerts run on a schedule and evaluate query results against defined thresholds. When an alert is triggered, notifications can be sent to specified users or destinations.

        ## Example Usage

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = id

          to = databricks_alert_v2.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/alertV2:AlertV2 databricks_alert_v2 id
        ```

        :param str resource_name: The name of the resource.
        :param AlertV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_description: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_summary: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 evaluation: Optional[pulumi.Input[Union['AlertV2EvaluationArgs', 'AlertV2EvaluationArgsDict']]] = None,
                 parent_path: Optional[pulumi.Input[_builtins.str]] = None,
                 query_text: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['AlertV2ScheduleArgs', 'AlertV2ScheduleArgsDict']]] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertV2Args.__new__(AlertV2Args)

            __props__.__dict__["custom_description"] = custom_description
            __props__.__dict__["custom_summary"] = custom_summary
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["evaluation"] = evaluation
            __props__.__dict__["parent_path"] = parent_path
            __props__.__dict__["query_text"] = query_text
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["warehouse_id"] = warehouse_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["lifecycle_state"] = None
            __props__.__dict__["owner_user_name"] = None
            __props__.__dict__["run_as_user_name"] = None
            __props__.__dict__["update_time"] = None
        super(AlertV2, __self__).__init__(
            'databricks:index/alertV2:AlertV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            custom_description: Optional[pulumi.Input[_builtins.str]] = None,
            custom_summary: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            evaluation: Optional[pulumi.Input[Union['AlertV2EvaluationArgs', 'AlertV2EvaluationArgsDict']]] = None,
            lifecycle_state: Optional[pulumi.Input[_builtins.str]] = None,
            owner_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_path: Optional[pulumi.Input[_builtins.str]] = None,
            query_text: Optional[pulumi.Input[_builtins.str]] = None,
            run_as_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            schedule: Optional[pulumi.Input[Union['AlertV2ScheduleArgs', 'AlertV2ScheduleArgsDict']]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            warehouse_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AlertV2':
        """
        Get an existing AlertV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: (string) - The timestamp indicating when the alert was created
        :param pulumi.Input[_builtins.str] custom_description: Custom description for the alert. support mustache template
        :param pulumi.Input[_builtins.str] custom_summary: Custom summary for the alert. support mustache template
        :param pulumi.Input[_builtins.str] display_name: The display name of the alert
        :param pulumi.Input[_builtins.str] lifecycle_state: (string) - Indicates whether the query is trashed. Possible values are: `ACTIVE`, `TRASHED`
        :param pulumi.Input[_builtins.str] owner_user_name: (string) - The owner's username. This field is set to "Unavailable" if the user has been deleted
        :param pulumi.Input[_builtins.str] parent_path: The workspace path of the folder containing the alert. Can only be set on create, and cannot be updated
        :param pulumi.Input[_builtins.str] query_text: Text of the query to be run
        :param pulumi.Input[_builtins.str] run_as_user_name: (string) - The run as username. This field is set to "Unavailable" if the user has been deleted
        :param pulumi.Input[_builtins.str] update_time: (string) - The timestamp indicating when the alert was updated
        :param pulumi.Input[_builtins.str] warehouse_id: ID of the SQL warehouse attached to the alert
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertV2State.__new__(_AlertV2State)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_description"] = custom_description
        __props__.__dict__["custom_summary"] = custom_summary
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["evaluation"] = evaluation
        __props__.__dict__["lifecycle_state"] = lifecycle_state
        __props__.__dict__["owner_user_name"] = owner_user_name
        __props__.__dict__["parent_path"] = parent_path
        __props__.__dict__["query_text"] = query_text
        __props__.__dict__["run_as_user_name"] = run_as_user_name
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["warehouse_id"] = warehouse_id
        return AlertV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The timestamp indicating when the alert was created
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customDescription")
    def custom_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom description for the alert. support mustache template
        """
        return pulumi.get(self, "custom_description")

    @_builtins.property
    @pulumi.getter(name="customSummary")
    def custom_summary(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom summary for the alert. support mustache template
        """
        return pulumi.get(self, "custom_summary")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The display name of the alert
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def evaluation(self) -> pulumi.Output[Optional['outputs.AlertV2Evaluation']]:
        return pulumi.get(self, "evaluation")

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Indicates whether the query is trashed. Possible values are: `ACTIVE`, `TRASHED`
        """
        return pulumi.get(self, "lifecycle_state")

    @_builtins.property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The owner's username. This field is set to "Unavailable" if the user has been deleted
        """
        return pulumi.get(self, "owner_user_name")

    @_builtins.property
    @pulumi.getter(name="parentPath")
    def parent_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The workspace path of the folder containing the alert. Can only be set on create, and cannot be updated
        """
        return pulumi.get(self, "parent_path")

    @_builtins.property
    @pulumi.getter(name="queryText")
    def query_text(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Text of the query to be run
        """
        return pulumi.get(self, "query_text")

    @_builtins.property
    @pulumi.getter(name="runAsUserName")
    def run_as_user_name(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The run as username. This field is set to "Unavailable" if the user has been deleted
        """
        return pulumi.get(self, "run_as_user_name")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.AlertV2Schedule']]:
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The timestamp indicating when the alert was updated
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the SQL warehouse attached to the alert
        """
        return pulumi.get(self, "warehouse_id")

