# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DbfsFileArgs', 'DbfsFile']

@pulumi.input_type
class DbfsFileArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[_builtins.str],
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DbfsFile resource.
        :param pulumi.Input[_builtins.str] path: The path of the file in which you wish to save.
        :param pulumi.Input[_builtins.str] content_base64: Encoded file contents. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a data pipeline configuration file.
        :param pulumi.Input[_builtins.str] source: The full absolute path to the file. Conflicts with `content_base64`.
        """
        pulumi.set(__self__, "path", path)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The path of the file in which you wish to save.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Encoded file contents. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a data pipeline configuration file.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter
    def md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "md5")

    @md5.setter
    def md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "md5", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full absolute path to the file. Conflicts with `content_base64`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _DbfsFileState:
    def __init__(__self__, *,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 dbfs_path: Optional[pulumi.Input[_builtins.str]] = None,
                 file_size: Optional[pulumi.Input[_builtins.int]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbfsFile resources.
        :param pulumi.Input[_builtins.str] content_base64: Encoded file contents. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a data pipeline configuration file.
        :param pulumi.Input[_builtins.str] dbfs_path: Path, but with `dbfs:` prefix.
        :param pulumi.Input[_builtins.int] file_size: The file size of the file that is being tracked by this resource in bytes.
        :param pulumi.Input[_builtins.str] path: The path of the file in which you wish to save.
        :param pulumi.Input[_builtins.str] source: The full absolute path to the file. Conflicts with `content_base64`.
        """
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if dbfs_path is not None:
            pulumi.set(__self__, "dbfs_path", dbfs_path)
        if file_size is not None:
            pulumi.set(__self__, "file_size", file_size)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Encoded file contents. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a data pipeline configuration file.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter(name="dbfsPath")
    def dbfs_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path, but with `dbfs:` prefix.
        """
        return pulumi.get(self, "dbfs_path")

    @dbfs_path.setter
    def dbfs_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbfs_path", value)

    @_builtins.property
    @pulumi.getter(name="fileSize")
    def file_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The file size of the file that is being tracked by this resource in bytes.
        """
        return pulumi.get(self, "file_size")

    @file_size.setter
    def file_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "file_size", value)

    @_builtins.property
    @pulumi.getter
    def md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "md5")

    @md5.setter
    def md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "md5", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of the file in which you wish to save.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full absolute path to the file. Conflicts with `content_base64`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.type_token("databricks:index/dbfsFile:DbfsFile")
class DbfsFile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This is a resource that lets you manage relatively small files on [Databricks File System (DBFS)](https://docs.databricks.com/data/databricks-file-system.html). The best use cases are libraries for Cluster or databricks_job. You can also use DbfsFile and get_dbfs_file_paths data sources.

        > This resource can only be used with a workspace-level provider!

        ## Import

        The resource dbfs file can be imported using the path of the file:

        hcl

        import {

          to = databricks_dbfs_file.this

          id = "<path>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/dbfsFile:DbfsFile this <path>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content_base64: Encoded file contents. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a data pipeline configuration file.
        :param pulumi.Input[_builtins.str] path: The path of the file in which you wish to save.
        :param pulumi.Input[_builtins.str] source: The full absolute path to the file. Conflicts with `content_base64`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbfsFileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This is a resource that lets you manage relatively small files on [Databricks File System (DBFS)](https://docs.databricks.com/data/databricks-file-system.html). The best use cases are libraries for Cluster or databricks_job. You can also use DbfsFile and get_dbfs_file_paths data sources.

        > This resource can only be used with a workspace-level provider!

        ## Import

        The resource dbfs file can be imported using the path of the file:

        hcl

        import {

          to = databricks_dbfs_file.this

          id = "<path>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/dbfsFile:DbfsFile this <path>
        ```

        :param str resource_name: The name of the resource.
        :param DbfsFileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbfsFileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbfsFileArgs.__new__(DbfsFileArgs)

            __props__.__dict__["content_base64"] = content_base64
            __props__.__dict__["md5"] = md5
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["source"] = source
            __props__.__dict__["dbfs_path"] = None
            __props__.__dict__["file_size"] = None
        super(DbfsFile, __self__).__init__(
            'databricks:index/dbfsFile:DbfsFile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content_base64: Optional[pulumi.Input[_builtins.str]] = None,
            dbfs_path: Optional[pulumi.Input[_builtins.str]] = None,
            file_size: Optional[pulumi.Input[_builtins.int]] = None,
            md5: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None) -> 'DbfsFile':
        """
        Get an existing DbfsFile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content_base64: Encoded file contents. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a data pipeline configuration file.
        :param pulumi.Input[_builtins.str] dbfs_path: Path, but with `dbfs:` prefix.
        :param pulumi.Input[_builtins.int] file_size: The file size of the file that is being tracked by this resource in bytes.
        :param pulumi.Input[_builtins.str] path: The path of the file in which you wish to save.
        :param pulumi.Input[_builtins.str] source: The full absolute path to the file. Conflicts with `content_base64`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbfsFileState.__new__(_DbfsFileState)

        __props__.__dict__["content_base64"] = content_base64
        __props__.__dict__["dbfs_path"] = dbfs_path
        __props__.__dict__["file_size"] = file_size
        __props__.__dict__["md5"] = md5
        __props__.__dict__["path"] = path
        __props__.__dict__["source"] = source
        return DbfsFile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Encoded file contents. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a data pipeline configuration file.
        """
        return pulumi.get(self, "content_base64")

    @_builtins.property
    @pulumi.getter(name="dbfsPath")
    def dbfs_path(self) -> pulumi.Output[_builtins.str]:
        """
        Path, but with `dbfs:` prefix.
        """
        return pulumi.get(self, "dbfs_path")

    @_builtins.property
    @pulumi.getter(name="fileSize")
    def file_size(self) -> pulumi.Output[_builtins.int]:
        """
        The file size of the file that is being tracked by this resource in bytes.
        """
        return pulumi.get(self, "file_size")

    @_builtins.property
    @pulumi.getter
    def md5(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "md5")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        The path of the file in which you wish to save.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The full absolute path to the file. Conflicts with `content_base64`.
        """
        return pulumi.get(self, "source")

