# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DirectoryArgs', 'Directory']

@pulumi.input_type
class DirectoryArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[_builtins.str],
                 delete_recursive: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Directory resource.
        :param pulumi.Input[_builtins.str] path: The absolute path of the directory, beginning with "/", e.g. "/Demo".
        :param pulumi.Input[_builtins.bool] delete_recursive: Whether or not to trigger a recursive delete of this directory and its resources when deleting this on Pulumi. Defaults to `false`
        :param pulumi.Input[_builtins.int] object_id: Unique identifier for a DIRECTORY
        """
        pulumi.set(__self__, "path", path)
        if delete_recursive is not None:
            pulumi.set(__self__, "delete_recursive", delete_recursive)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The absolute path of the directory, beginning with "/", e.g. "/Demo".
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="deleteRecursive")
    def delete_recursive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to trigger a recursive delete of this directory and its resources when deleting this on Pulumi. Defaults to `false`
        """
        return pulumi.get(self, "delete_recursive")

    @delete_recursive.setter
    def delete_recursive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_recursive", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier for a DIRECTORY
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "object_id", value)


@pulumi.input_type
class _DirectoryState:
    def __init__(__self__, *,
                 delete_recursive: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_id: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Directory resources.
        :param pulumi.Input[_builtins.bool] delete_recursive: Whether or not to trigger a recursive delete of this directory and its resources when deleting this on Pulumi. Defaults to `false`
        :param pulumi.Input[_builtins.int] object_id: Unique identifier for a DIRECTORY
        :param pulumi.Input[_builtins.str] path: The absolute path of the directory, beginning with "/", e.g. "/Demo".
        :param pulumi.Input[_builtins.str] workspace_path: path on Workspace File System (WSFS) in form of `/Workspace` + `path`
        """
        if delete_recursive is not None:
            pulumi.set(__self__, "delete_recursive", delete_recursive)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if workspace_path is not None:
            pulumi.set(__self__, "workspace_path", workspace_path)

    @_builtins.property
    @pulumi.getter(name="deleteRecursive")
    def delete_recursive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to trigger a recursive delete of this directory and its resources when deleting this on Pulumi. Defaults to `false`
        """
        return pulumi.get(self, "delete_recursive")

    @delete_recursive.setter
    def delete_recursive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_recursive", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier for a DIRECTORY
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The absolute path of the directory, beginning with "/", e.g. "/Demo".
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="workspacePath")
    def workspace_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        path on Workspace File System (WSFS) in form of `/Workspace` + `path`
        """
        return pulumi.get(self, "workspace_path")

    @workspace_path.setter
    def workspace_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_path", value)


@pulumi.type_token("databricks:index/directory:Directory")
class Directory(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_recursive: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_id: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to manage directories in [Databricks Workpace](https://docs.databricks.com/workspace/workspace-objects.html).

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        You can declare a Pulumi-managed directory by specifying the `path` attribute of the corresponding directory.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        my_custom_directory = databricks.Directory("my_custom_directory", path="/my_custom_directory")
        ```

        ## Access Control

        - Permissions can control which groups or individual users can access folders.

        ## Related Resources

        The following resources are often used in the same context:

        - End to end workspace management guide.
        - Notebook to manage [Databricks Notebooks](https://docs.databricks.com/notebooks/index.html).
        - Notebook data to export a notebook from Databricks Workspace.
        - get_notebook_paths data to list notebooks in Databricks Workspace.
        - Repo to manage [Databricks Repos](https://docs.databricks.com/repos.html).
        - get_spark_version data to get [Databricks Runtime (DBR)](https://docs.databricks.com/runtime/dbr.html) version that could be used for `spark_version` parameter in Cluster and other resources.
        - WorkspaceConf to manage workspace configuration for expert usage.

        ## Import

        The resource directory can be imported using directory path:

        hcl

        import {

          to = databricks_directory.this

          id = "/path/to/directory"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/directory:Directory this /path/to/directory
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] delete_recursive: Whether or not to trigger a recursive delete of this directory and its resources when deleting this on Pulumi. Defaults to `false`
        :param pulumi.Input[_builtins.int] object_id: Unique identifier for a DIRECTORY
        :param pulumi.Input[_builtins.str] path: The absolute path of the directory, beginning with "/", e.g. "/Demo".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DirectoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage directories in [Databricks Workpace](https://docs.databricks.com/workspace/workspace-objects.html).

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        You can declare a Pulumi-managed directory by specifying the `path` attribute of the corresponding directory.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        my_custom_directory = databricks.Directory("my_custom_directory", path="/my_custom_directory")
        ```

        ## Access Control

        - Permissions can control which groups or individual users can access folders.

        ## Related Resources

        The following resources are often used in the same context:

        - End to end workspace management guide.
        - Notebook to manage [Databricks Notebooks](https://docs.databricks.com/notebooks/index.html).
        - Notebook data to export a notebook from Databricks Workspace.
        - get_notebook_paths data to list notebooks in Databricks Workspace.
        - Repo to manage [Databricks Repos](https://docs.databricks.com/repos.html).
        - get_spark_version data to get [Databricks Runtime (DBR)](https://docs.databricks.com/runtime/dbr.html) version that could be used for `spark_version` parameter in Cluster and other resources.
        - WorkspaceConf to manage workspace configuration for expert usage.

        ## Import

        The resource directory can be imported using directory path:

        hcl

        import {

          to = databricks_directory.this

          id = "/path/to/directory"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/directory:Directory this /path/to/directory
        ```

        :param str resource_name: The name of the resource.
        :param DirectoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DirectoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_recursive: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_id: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DirectoryArgs.__new__(DirectoryArgs)

            __props__.__dict__["delete_recursive"] = delete_recursive
            __props__.__dict__["object_id"] = object_id
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["workspace_path"] = None
        super(Directory, __self__).__init__(
            'databricks:index/directory:Directory',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delete_recursive: Optional[pulumi.Input[_builtins.bool]] = None,
            object_id: Optional[pulumi.Input[_builtins.int]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_path: Optional[pulumi.Input[_builtins.str]] = None) -> 'Directory':
        """
        Get an existing Directory resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] delete_recursive: Whether or not to trigger a recursive delete of this directory and its resources when deleting this on Pulumi. Defaults to `false`
        :param pulumi.Input[_builtins.int] object_id: Unique identifier for a DIRECTORY
        :param pulumi.Input[_builtins.str] path: The absolute path of the directory, beginning with "/", e.g. "/Demo".
        :param pulumi.Input[_builtins.str] workspace_path: path on Workspace File System (WSFS) in form of `/Workspace` + `path`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DirectoryState.__new__(_DirectoryState)

        __props__.__dict__["delete_recursive"] = delete_recursive
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["path"] = path
        __props__.__dict__["workspace_path"] = workspace_path
        return Directory(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deleteRecursive")
    def delete_recursive(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to trigger a recursive delete of this directory and its resources when deleting this on Pulumi. Defaults to `false`
        """
        return pulumi.get(self, "delete_recursive")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier for a DIRECTORY
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        The absolute path of the directory, beginning with "/", e.g. "/Demo".
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="workspacePath")
    def workspace_path(self) -> pulumi.Output[_builtins.str]:
        """
        path on Workspace File System (WSFS) in form of `/Workspace` + `path`
        """
        return pulumi.get(self, "workspace_path")

