# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDatabaseInstanceResult',
    'AwaitableGetDatabaseInstanceResult',
    'get_database_instance',
    'get_database_instance_output',
]

@pulumi.output_type
class GetDatabaseInstanceResult:
    """
    A collection of values returned by getDatabaseInstance.
    """
    def __init__(__self__, capacity=None, creation_time=None, creator=None, effective_stopped=None, id=None, name=None, pg_version=None, read_write_dns=None, state=None, stopped=None, uid=None):
        if capacity and not isinstance(capacity, str):
            raise TypeError("Expected argument 'capacity' to be a str")
        pulumi.set(__self__, "capacity", capacity)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if creator and not isinstance(creator, str):
            raise TypeError("Expected argument 'creator' to be a str")
        pulumi.set(__self__, "creator", creator)
        if effective_stopped and not isinstance(effective_stopped, bool):
            raise TypeError("Expected argument 'effective_stopped' to be a bool")
        pulumi.set(__self__, "effective_stopped", effective_stopped)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pg_version and not isinstance(pg_version, str):
            raise TypeError("Expected argument 'pg_version' to be a str")
        pulumi.set(__self__, "pg_version", pg_version)
        if read_write_dns and not isinstance(read_write_dns, str):
            raise TypeError("Expected argument 'read_write_dns' to be a str")
        pulumi.set(__self__, "read_write_dns", read_write_dns)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stopped and not isinstance(stopped, bool):
            raise TypeError("Expected argument 'stopped' to be a bool")
        pulumi.set(__self__, "stopped", stopped)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[_builtins.str]:
        """
        (string) - The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        (string) - The timestamp when the instance was created
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> _builtins.str:
        """
        (string) - The email of the creator of the instance
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter(name="effectiveStopped")
    def effective_stopped(self) -> _builtins.bool:
        """
        (boolean) - xref AIP-129. `stopped` is owned by the client, while `effective_stopped` is owned by the server.
        `stopped` will only be set in Create/Update response messages if and only if the user provides the field via the request.
        `effective_stopped` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        """
        return pulumi.get(self, "effective_stopped")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (string) - The name of the instance. This is the unique identifier for the instance
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pgVersion")
    def pg_version(self) -> _builtins.str:
        """
        (string) - The version of Postgres running on the instance
        """
        return pulumi.get(self, "pg_version")

    @_builtins.property
    @pulumi.getter(name="readWriteDns")
    def read_write_dns(self) -> _builtins.str:
        """
        (string) - The DNS endpoint to connect to the instance for read+write access
        """
        return pulumi.get(self, "read_write_dns")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        (string) - The current state of the instance. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def stopped(self) -> Optional[_builtins.bool]:
        """
        (boolean) - Whether the instance is stopped
        """
        return pulumi.get(self, "stopped")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        (string) - An immutable UUID identifier for the instance
        """
        return pulumi.get(self, "uid")


class AwaitableGetDatabaseInstanceResult(GetDatabaseInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseInstanceResult(
            capacity=self.capacity,
            creation_time=self.creation_time,
            creator=self.creator,
            effective_stopped=self.effective_stopped,
            id=self.id,
            name=self.name,
            pg_version=self.pg_version,
            read_write_dns=self.read_write_dns,
            state=self.state,
            stopped=self.stopped,
            uid=self.uid)


def get_database_instance(capacity: Optional[_builtins.str] = None,
                          name: Optional[_builtins.str] = None,
                          stopped: Optional[_builtins.bool] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseInstanceResult:
    """
    This data source can be used to get a single Database Instance.

    ## Example Usage

    Referring to a Database Instance by name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_database_instance(name="my-database-instance")
    ```


    :param _builtins.str capacity: (string) - The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
    :param _builtins.str name: The name of the instance. This is the unique identifier for the instance
    :param _builtins.bool stopped: (boolean) - Whether the instance is stopped
    """
    __args__ = dict()
    __args__['capacity'] = capacity
    __args__['name'] = name
    __args__['stopped'] = stopped
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getDatabaseInstance:getDatabaseInstance', __args__, opts=opts, typ=GetDatabaseInstanceResult).value

    return AwaitableGetDatabaseInstanceResult(
        capacity=pulumi.get(__ret__, 'capacity'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        creator=pulumi.get(__ret__, 'creator'),
        effective_stopped=pulumi.get(__ret__, 'effective_stopped'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        pg_version=pulumi.get(__ret__, 'pg_version'),
        read_write_dns=pulumi.get(__ret__, 'read_write_dns'),
        state=pulumi.get(__ret__, 'state'),
        stopped=pulumi.get(__ret__, 'stopped'),
        uid=pulumi.get(__ret__, 'uid'))
def get_database_instance_output(capacity: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 name: Optional[pulumi.Input[_builtins.str]] = None,
                                 stopped: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseInstanceResult]:
    """
    This data source can be used to get a single Database Instance.

    ## Example Usage

    Referring to a Database Instance by name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_database_instance(name="my-database-instance")
    ```


    :param _builtins.str capacity: (string) - The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
    :param _builtins.str name: The name of the instance. This is the unique identifier for the instance
    :param _builtins.bool stopped: (boolean) - Whether the instance is stopped
    """
    __args__ = dict()
    __args__['capacity'] = capacity
    __args__['name'] = name
    __args__['stopped'] = stopped
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getDatabaseInstance:getDatabaseInstance', __args__, opts=opts, typ=GetDatabaseInstanceResult)
    return __ret__.apply(lambda __response__: GetDatabaseInstanceResult(
        capacity=pulumi.get(__response__, 'capacity'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        creator=pulumi.get(__response__, 'creator'),
        effective_stopped=pulumi.get(__response__, 'effective_stopped'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        pg_version=pulumi.get(__response__, 'pg_version'),
        read_write_dns=pulumi.get(__response__, 'read_write_dns'),
        state=pulumi.get(__response__, 'state'),
        stopped=pulumi.get(__response__, 'stopped'),
        uid=pulumi.get(__response__, 'uid')))
