# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GlobalInitScriptArgs', 'GlobalInitScript']

@pulumi.input_type
class GlobalInitScriptArgs:
    def __init__(__self__, *,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.int]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GlobalInitScript resource.
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded source code global init script. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances
        :param pulumi.Input[_builtins.bool] enabled: specifies if the script is enabled for execution, or not
        :param pulumi.Input[_builtins.str] name: the name of the script.  It should be unique
        :param pulumi.Input[_builtins.int] position: the position of a global init script, where `0` represents the first global init script to run, `1` is the second global init script to run, and so on. When omitted, the script gets the last position.
        :param pulumi.Input[_builtins.str] source: Path to script's source code on local filesystem. Conflicts with `content_base64`
        """
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded source code global init script. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        specifies if the script is enabled for execution, or not
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "md5")

    @md5.setter
    def md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "md5", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the name of the script.  It should be unique
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        the position of a global init script, where `0` represents the first global init script to run, `1` is the second global init script to run, and so on. When omitted, the script gets the last position.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to script's source code on local filesystem. Conflicts with `content_base64`
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _GlobalInitScriptState:
    def __init__(__self__, *,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.int]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GlobalInitScript resources.
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded source code global init script. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances
        :param pulumi.Input[_builtins.bool] enabled: specifies if the script is enabled for execution, or not
        :param pulumi.Input[_builtins.str] name: the name of the script.  It should be unique
        :param pulumi.Input[_builtins.int] position: the position of a global init script, where `0` represents the first global init script to run, `1` is the second global init script to run, and so on. When omitted, the script gets the last position.
        :param pulumi.Input[_builtins.str] source: Path to script's source code on local filesystem. Conflicts with `content_base64`
        """
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded source code global init script. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        specifies if the script is enabled for execution, or not
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "md5")

    @md5.setter
    def md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "md5", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the name of the script.  It should be unique
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        the position of a global init script, where `0` represents the first global init script to run, `1` is the second global init script to run, and so on. When omitted, the script gets the last position.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to script's source code on local filesystem. Conflicts with `content_base64`
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.type_token("databricks:index/globalInitScript:GlobalInitScript")
class GlobalInitScript(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.int]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to manage [global init scripts](https://docs.databricks.com/clusters/init-scripts.html#global-init-scripts), which are run on all Cluster and databricks_job.

        > This resource can only be used with a workspace-level provider!

        ## Import

        The resource global init script can be imported using script ID:

        hcl

        import {

          to = databricks_global_init_script.this

          id = "script_id"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/globalInitScript:GlobalInitScript this script_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded source code global init script. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances
        :param pulumi.Input[_builtins.bool] enabled: specifies if the script is enabled for execution, or not
        :param pulumi.Input[_builtins.str] name: the name of the script.  It should be unique
        :param pulumi.Input[_builtins.int] position: the position of a global init script, where `0` represents the first global init script to run, `1` is the second global init script to run, and so on. When omitted, the script gets the last position.
        :param pulumi.Input[_builtins.str] source: Path to script's source code on local filesystem. Conflicts with `content_base64`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GlobalInitScriptArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage [global init scripts](https://docs.databricks.com/clusters/init-scripts.html#global-init-scripts), which are run on all Cluster and databricks_job.

        > This resource can only be used with a workspace-level provider!

        ## Import

        The resource global init script can be imported using script ID:

        hcl

        import {

          to = databricks_global_init_script.this

          id = "script_id"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/globalInitScript:GlobalInitScript this script_id
        ```

        :param str resource_name: The name of the resource.
        :param GlobalInitScriptArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalInitScriptArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.int]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalInitScriptArgs.__new__(GlobalInitScriptArgs)

            __props__.__dict__["content_base64"] = content_base64
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["md5"] = md5
            __props__.__dict__["name"] = name
            __props__.__dict__["position"] = position
            __props__.__dict__["source"] = source
        super(GlobalInitScript, __self__).__init__(
            'databricks:index/globalInitScript:GlobalInitScript',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content_base64: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            md5: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            position: Optional[pulumi.Input[_builtins.int]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None) -> 'GlobalInitScript':
        """
        Get an existing GlobalInitScript resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded source code global init script. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances
        :param pulumi.Input[_builtins.bool] enabled: specifies if the script is enabled for execution, or not
        :param pulumi.Input[_builtins.str] name: the name of the script.  It should be unique
        :param pulumi.Input[_builtins.int] position: the position of a global init script, where `0` represents the first global init script to run, `1` is the second global init script to run, and so on. When omitted, the script gets the last position.
        :param pulumi.Input[_builtins.str] source: Path to script's source code on local filesystem. Conflicts with `content_base64`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalInitScriptState.__new__(_GlobalInitScriptState)

        __props__.__dict__["content_base64"] = content_base64
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["md5"] = md5
        __props__.__dict__["name"] = name
        __props__.__dict__["position"] = position
        __props__.__dict__["source"] = source
        return GlobalInitScript(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The base64-encoded source code global init script. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances
        """
        return pulumi.get(self, "content_base64")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        specifies if the script is enabled for execution, or not
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def md5(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "md5")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        the name of the script.  It should be unique
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Output[_builtins.int]:
        """
        the position of a global init script, where `0` represents the first global init script to run, `1` is the second global init script to run, and so on. When omitted, the script gets the last position.
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to script's source code on local filesystem. Conflicts with `content_base64`
        """
        return pulumi.get(self, "source")

