# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstancePoolArgs', 'InstancePool']

@pulumi.input_type
class InstancePoolArgs:
    def __init__(__self__, *,
                 idle_instance_autotermination_minutes: pulumi.Input[_builtins.int],
                 instance_pool_name: pulumi.Input[_builtins.str],
                 aws_attributes: Optional[pulumi.Input['InstancePoolAwsAttributesArgs']] = None,
                 azure_attributes: Optional[pulumi.Input['InstancePoolAzureAttributesArgs']] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 disk_spec: Optional[pulumi.Input['InstancePoolDiskSpecArgs']] = None,
                 enable_elastic_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcp_attributes: Optional[pulumi.Input['InstancePoolGcpAttributesArgs']] = None,
                 instance_pool_fleet_attributes: Optional[pulumi.Input['InstancePoolInstancePoolFleetAttributesArgs']] = None,
                 instance_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 min_idle_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 node_type_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preloaded_docker_images: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolPreloadedDockerImageArgs']]]] = None,
                 preloaded_spark_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a InstancePool resource.
        :param pulumi.Input[_builtins.int] idle_instance_autotermination_minutes: (Integer) The number of minutes that idle instances in excess of the min_idle_instances are maintained by the pool before being terminated. If not specified, excess idle instances are terminated automatically after a default timeout period. If specified, the time must be between 0 and 10000 minutes. If you specify 0, excess idle instances are removed as soon as possible.
        :param pulumi.Input[_builtins.str] instance_pool_name: (String) The name of the instance pool. This is required for create and edit operations. It must be unique, non-empty, and less than 100 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: (Map) Additional tags for instance pool resources. Databricks tags all pool resources (e.g. AWS & Azure instances and Disk volumes). The tags of the instance pool will propagate to the clusters using the pool (see the [official documentation](https://docs.databricks.com/administration-guide/account-settings/usage-detail-tags-aws.html#tag-propagation)). Attempting to set the same tags in both cluster and instance pool will raise an error. *Databricks allows at most 43 custom tags.*
        :param pulumi.Input[_builtins.bool] enable_elastic_disk: (Bool) Autoscaling Local Storage: when enabled, the instances in the pool dynamically acquire additional disk space when they are running low on disk space.
        :param pulumi.Input[_builtins.int] max_capacity: (Integer) The maximum number of instances the pool can contain, including both idle instances and ones in use by clusters. Once the maximum capacity is reached, you cannot create new clusters from the pool and existing clusters cannot autoscale up until some instances are made idle in the pool via cluster termination or down-scaling. There is no default limit, but as a [best practice](https://docs.databricks.com/clusters/instance-pools/pool-best-practices.html#configure-pools-to-control-cost), this should be set based on anticipated usage.
        :param pulumi.Input[_builtins.int] min_idle_instances: (Integer) The minimum number of idle instances maintained by the pool. This is in addition to any instances in use by active clusters.
        :param pulumi.Input[_builtins.str] node_type_id: (String) The node type for the instances in the pool. All clusters attached to the pool inherit this node type and the pool's idle instances are allocated based on this type. You can retrieve a list of available node types by using the [List Node Types API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistnodetypes) call.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preloaded_spark_versions: (List) A list with at most one runtime version the pool installs on each instance. Pool clusters that use a preloaded runtime version start faster as they do not have to wait for the image to download. You can retrieve them via get_spark_version data source or via  [Runtime Versions API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistsparkversions) call.
        """
        pulumi.set(__self__, "idle_instance_autotermination_minutes", idle_instance_autotermination_minutes)
        pulumi.set(__self__, "instance_pool_name", instance_pool_name)
        if aws_attributes is not None:
            pulumi.set(__self__, "aws_attributes", aws_attributes)
        if azure_attributes is not None:
            pulumi.set(__self__, "azure_attributes", azure_attributes)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if disk_spec is not None:
            pulumi.set(__self__, "disk_spec", disk_spec)
        if enable_elastic_disk is not None:
            pulumi.set(__self__, "enable_elastic_disk", enable_elastic_disk)
        if gcp_attributes is not None:
            pulumi.set(__self__, "gcp_attributes", gcp_attributes)
        if instance_pool_fleet_attributes is not None:
            pulumi.set(__self__, "instance_pool_fleet_attributes", instance_pool_fleet_attributes)
        if instance_pool_id is not None:
            pulumi.set(__self__, "instance_pool_id", instance_pool_id)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_idle_instances is not None:
            pulumi.set(__self__, "min_idle_instances", min_idle_instances)
        if node_type_id is not None:
            pulumi.set(__self__, "node_type_id", node_type_id)
        if preloaded_docker_images is not None:
            pulumi.set(__self__, "preloaded_docker_images", preloaded_docker_images)
        if preloaded_spark_versions is not None:
            pulumi.set(__self__, "preloaded_spark_versions", preloaded_spark_versions)

    @_builtins.property
    @pulumi.getter(name="idleInstanceAutoterminationMinutes")
    def idle_instance_autotermination_minutes(self) -> pulumi.Input[_builtins.int]:
        """
        (Integer) The number of minutes that idle instances in excess of the min_idle_instances are maintained by the pool before being terminated. If not specified, excess idle instances are terminated automatically after a default timeout period. If specified, the time must be between 0 and 10000 minutes. If you specify 0, excess idle instances are removed as soon as possible.
        """
        return pulumi.get(self, "idle_instance_autotermination_minutes")

    @idle_instance_autotermination_minutes.setter
    def idle_instance_autotermination_minutes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "idle_instance_autotermination_minutes", value)

    @_builtins.property
    @pulumi.getter(name="instancePoolName")
    def instance_pool_name(self) -> pulumi.Input[_builtins.str]:
        """
        (String) The name of the instance pool. This is required for create and edit operations. It must be unique, non-empty, and less than 100 characters.
        """
        return pulumi.get(self, "instance_pool_name")

    @instance_pool_name.setter
    def instance_pool_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="awsAttributes")
    def aws_attributes(self) -> Optional[pulumi.Input['InstancePoolAwsAttributesArgs']]:
        return pulumi.get(self, "aws_attributes")

    @aws_attributes.setter
    def aws_attributes(self, value: Optional[pulumi.Input['InstancePoolAwsAttributesArgs']]):
        pulumi.set(self, "aws_attributes", value)

    @_builtins.property
    @pulumi.getter(name="azureAttributes")
    def azure_attributes(self) -> Optional[pulumi.Input['InstancePoolAzureAttributesArgs']]:
        return pulumi.get(self, "azure_attributes")

    @azure_attributes.setter
    def azure_attributes(self, value: Optional[pulumi.Input['InstancePoolAzureAttributesArgs']]):
        pulumi.set(self, "azure_attributes", value)

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Map) Additional tags for instance pool resources. Databricks tags all pool resources (e.g. AWS & Azure instances and Disk volumes). The tags of the instance pool will propagate to the clusters using the pool (see the [official documentation](https://docs.databricks.com/administration-guide/account-settings/usage-detail-tags-aws.html#tag-propagation)). Attempting to set the same tags in both cluster and instance pool will raise an error. *Databricks allows at most 43 custom tags.*
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_tags", value)

    @_builtins.property
    @pulumi.getter(name="diskSpec")
    def disk_spec(self) -> Optional[pulumi.Input['InstancePoolDiskSpecArgs']]:
        return pulumi.get(self, "disk_spec")

    @disk_spec.setter
    def disk_spec(self, value: Optional[pulumi.Input['InstancePoolDiskSpecArgs']]):
        pulumi.set(self, "disk_spec", value)

    @_builtins.property
    @pulumi.getter(name="enableElasticDisk")
    def enable_elastic_disk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Bool) Autoscaling Local Storage: when enabled, the instances in the pool dynamically acquire additional disk space when they are running low on disk space.
        """
        return pulumi.get(self, "enable_elastic_disk")

    @enable_elastic_disk.setter
    def enable_elastic_disk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_elastic_disk", value)

    @_builtins.property
    @pulumi.getter(name="gcpAttributes")
    def gcp_attributes(self) -> Optional[pulumi.Input['InstancePoolGcpAttributesArgs']]:
        return pulumi.get(self, "gcp_attributes")

    @gcp_attributes.setter
    def gcp_attributes(self, value: Optional[pulumi.Input['InstancePoolGcpAttributesArgs']]):
        pulumi.set(self, "gcp_attributes", value)

    @_builtins.property
    @pulumi.getter(name="instancePoolFleetAttributes")
    def instance_pool_fleet_attributes(self) -> Optional[pulumi.Input['InstancePoolInstancePoolFleetAttributesArgs']]:
        return pulumi.get(self, "instance_pool_fleet_attributes")

    @instance_pool_fleet_attributes.setter
    def instance_pool_fleet_attributes(self, value: Optional[pulumi.Input['InstancePoolInstancePoolFleetAttributesArgs']]):
        pulumi.set(self, "instance_pool_fleet_attributes", value)

    @_builtins.property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "instance_pool_id")

    @instance_pool_id.setter
    def instance_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Integer) The maximum number of instances the pool can contain, including both idle instances and ones in use by clusters. Once the maximum capacity is reached, you cannot create new clusters from the pool and existing clusters cannot autoscale up until some instances are made idle in the pool via cluster termination or down-scaling. There is no default limit, but as a [best practice](https://docs.databricks.com/clusters/instance-pools/pool-best-practices.html#configure-pools-to-control-cost), this should be set based on anticipated usage.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_capacity", value)

    @_builtins.property
    @pulumi.getter(name="minIdleInstances")
    def min_idle_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Integer) The minimum number of idle instances maintained by the pool. This is in addition to any instances in use by active clusters.
        """
        return pulumi.get(self, "min_idle_instances")

    @min_idle_instances.setter
    def min_idle_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_idle_instances", value)

    @_builtins.property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) The node type for the instances in the pool. All clusters attached to the pool inherit this node type and the pool's idle instances are allocated based on this type. You can retrieve a list of available node types by using the [List Node Types API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistnodetypes) call.
        """
        return pulumi.get(self, "node_type_id")

    @node_type_id.setter
    def node_type_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type_id", value)

    @_builtins.property
    @pulumi.getter(name="preloadedDockerImages")
    def preloaded_docker_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolPreloadedDockerImageArgs']]]]:
        return pulumi.get(self, "preloaded_docker_images")

    @preloaded_docker_images.setter
    def preloaded_docker_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolPreloadedDockerImageArgs']]]]):
        pulumi.set(self, "preloaded_docker_images", value)

    @_builtins.property
    @pulumi.getter(name="preloadedSparkVersions")
    def preloaded_spark_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (List) A list with at most one runtime version the pool installs on each instance. Pool clusters that use a preloaded runtime version start faster as they do not have to wait for the image to download. You can retrieve them via get_spark_version data source or via  [Runtime Versions API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistsparkversions) call.
        """
        return pulumi.get(self, "preloaded_spark_versions")

    @preloaded_spark_versions.setter
    def preloaded_spark_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preloaded_spark_versions", value)


@pulumi.input_type
class _InstancePoolState:
    def __init__(__self__, *,
                 aws_attributes: Optional[pulumi.Input['InstancePoolAwsAttributesArgs']] = None,
                 azure_attributes: Optional[pulumi.Input['InstancePoolAzureAttributesArgs']] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 disk_spec: Optional[pulumi.Input['InstancePoolDiskSpecArgs']] = None,
                 enable_elastic_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcp_attributes: Optional[pulumi.Input['InstancePoolGcpAttributesArgs']] = None,
                 idle_instance_autotermination_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_pool_fleet_attributes: Optional[pulumi.Input['InstancePoolInstancePoolFleetAttributesArgs']] = None,
                 instance_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 min_idle_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 node_type_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preloaded_docker_images: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolPreloadedDockerImageArgs']]]] = None,
                 preloaded_spark_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering InstancePool resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: (Map) Additional tags for instance pool resources. Databricks tags all pool resources (e.g. AWS & Azure instances and Disk volumes). The tags of the instance pool will propagate to the clusters using the pool (see the [official documentation](https://docs.databricks.com/administration-guide/account-settings/usage-detail-tags-aws.html#tag-propagation)). Attempting to set the same tags in both cluster and instance pool will raise an error. *Databricks allows at most 43 custom tags.*
        :param pulumi.Input[_builtins.bool] enable_elastic_disk: (Bool) Autoscaling Local Storage: when enabled, the instances in the pool dynamically acquire additional disk space when they are running low on disk space.
        :param pulumi.Input[_builtins.int] idle_instance_autotermination_minutes: (Integer) The number of minutes that idle instances in excess of the min_idle_instances are maintained by the pool before being terminated. If not specified, excess idle instances are terminated automatically after a default timeout period. If specified, the time must be between 0 and 10000 minutes. If you specify 0, excess idle instances are removed as soon as possible.
        :param pulumi.Input[_builtins.str] instance_pool_name: (String) The name of the instance pool. This is required for create and edit operations. It must be unique, non-empty, and less than 100 characters.
        :param pulumi.Input[_builtins.int] max_capacity: (Integer) The maximum number of instances the pool can contain, including both idle instances and ones in use by clusters. Once the maximum capacity is reached, you cannot create new clusters from the pool and existing clusters cannot autoscale up until some instances are made idle in the pool via cluster termination or down-scaling. There is no default limit, but as a [best practice](https://docs.databricks.com/clusters/instance-pools/pool-best-practices.html#configure-pools-to-control-cost), this should be set based on anticipated usage.
        :param pulumi.Input[_builtins.int] min_idle_instances: (Integer) The minimum number of idle instances maintained by the pool. This is in addition to any instances in use by active clusters.
        :param pulumi.Input[_builtins.str] node_type_id: (String) The node type for the instances in the pool. All clusters attached to the pool inherit this node type and the pool's idle instances are allocated based on this type. You can retrieve a list of available node types by using the [List Node Types API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistnodetypes) call.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preloaded_spark_versions: (List) A list with at most one runtime version the pool installs on each instance. Pool clusters that use a preloaded runtime version start faster as they do not have to wait for the image to download. You can retrieve them via get_spark_version data source or via  [Runtime Versions API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistsparkversions) call.
        """
        if aws_attributes is not None:
            pulumi.set(__self__, "aws_attributes", aws_attributes)
        if azure_attributes is not None:
            pulumi.set(__self__, "azure_attributes", azure_attributes)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if disk_spec is not None:
            pulumi.set(__self__, "disk_spec", disk_spec)
        if enable_elastic_disk is not None:
            pulumi.set(__self__, "enable_elastic_disk", enable_elastic_disk)
        if gcp_attributes is not None:
            pulumi.set(__self__, "gcp_attributes", gcp_attributes)
        if idle_instance_autotermination_minutes is not None:
            pulumi.set(__self__, "idle_instance_autotermination_minutes", idle_instance_autotermination_minutes)
        if instance_pool_fleet_attributes is not None:
            pulumi.set(__self__, "instance_pool_fleet_attributes", instance_pool_fleet_attributes)
        if instance_pool_id is not None:
            pulumi.set(__self__, "instance_pool_id", instance_pool_id)
        if instance_pool_name is not None:
            pulumi.set(__self__, "instance_pool_name", instance_pool_name)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_idle_instances is not None:
            pulumi.set(__self__, "min_idle_instances", min_idle_instances)
        if node_type_id is not None:
            pulumi.set(__self__, "node_type_id", node_type_id)
        if preloaded_docker_images is not None:
            pulumi.set(__self__, "preloaded_docker_images", preloaded_docker_images)
        if preloaded_spark_versions is not None:
            pulumi.set(__self__, "preloaded_spark_versions", preloaded_spark_versions)

    @_builtins.property
    @pulumi.getter(name="awsAttributes")
    def aws_attributes(self) -> Optional[pulumi.Input['InstancePoolAwsAttributesArgs']]:
        return pulumi.get(self, "aws_attributes")

    @aws_attributes.setter
    def aws_attributes(self, value: Optional[pulumi.Input['InstancePoolAwsAttributesArgs']]):
        pulumi.set(self, "aws_attributes", value)

    @_builtins.property
    @pulumi.getter(name="azureAttributes")
    def azure_attributes(self) -> Optional[pulumi.Input['InstancePoolAzureAttributesArgs']]:
        return pulumi.get(self, "azure_attributes")

    @azure_attributes.setter
    def azure_attributes(self, value: Optional[pulumi.Input['InstancePoolAzureAttributesArgs']]):
        pulumi.set(self, "azure_attributes", value)

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Map) Additional tags for instance pool resources. Databricks tags all pool resources (e.g. AWS & Azure instances and Disk volumes). The tags of the instance pool will propagate to the clusters using the pool (see the [official documentation](https://docs.databricks.com/administration-guide/account-settings/usage-detail-tags-aws.html#tag-propagation)). Attempting to set the same tags in both cluster and instance pool will raise an error. *Databricks allows at most 43 custom tags.*
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_tags", value)

    @_builtins.property
    @pulumi.getter(name="diskSpec")
    def disk_spec(self) -> Optional[pulumi.Input['InstancePoolDiskSpecArgs']]:
        return pulumi.get(self, "disk_spec")

    @disk_spec.setter
    def disk_spec(self, value: Optional[pulumi.Input['InstancePoolDiskSpecArgs']]):
        pulumi.set(self, "disk_spec", value)

    @_builtins.property
    @pulumi.getter(name="enableElasticDisk")
    def enable_elastic_disk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Bool) Autoscaling Local Storage: when enabled, the instances in the pool dynamically acquire additional disk space when they are running low on disk space.
        """
        return pulumi.get(self, "enable_elastic_disk")

    @enable_elastic_disk.setter
    def enable_elastic_disk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_elastic_disk", value)

    @_builtins.property
    @pulumi.getter(name="gcpAttributes")
    def gcp_attributes(self) -> Optional[pulumi.Input['InstancePoolGcpAttributesArgs']]:
        return pulumi.get(self, "gcp_attributes")

    @gcp_attributes.setter
    def gcp_attributes(self, value: Optional[pulumi.Input['InstancePoolGcpAttributesArgs']]):
        pulumi.set(self, "gcp_attributes", value)

    @_builtins.property
    @pulumi.getter(name="idleInstanceAutoterminationMinutes")
    def idle_instance_autotermination_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Integer) The number of minutes that idle instances in excess of the min_idle_instances are maintained by the pool before being terminated. If not specified, excess idle instances are terminated automatically after a default timeout period. If specified, the time must be between 0 and 10000 minutes. If you specify 0, excess idle instances are removed as soon as possible.
        """
        return pulumi.get(self, "idle_instance_autotermination_minutes")

    @idle_instance_autotermination_minutes.setter
    def idle_instance_autotermination_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_instance_autotermination_minutes", value)

    @_builtins.property
    @pulumi.getter(name="instancePoolFleetAttributes")
    def instance_pool_fleet_attributes(self) -> Optional[pulumi.Input['InstancePoolInstancePoolFleetAttributesArgs']]:
        return pulumi.get(self, "instance_pool_fleet_attributes")

    @instance_pool_fleet_attributes.setter
    def instance_pool_fleet_attributes(self, value: Optional[pulumi.Input['InstancePoolInstancePoolFleetAttributesArgs']]):
        pulumi.set(self, "instance_pool_fleet_attributes", value)

    @_builtins.property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "instance_pool_id")

    @instance_pool_id.setter
    def instance_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="instancePoolName")
    def instance_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) The name of the instance pool. This is required for create and edit operations. It must be unique, non-empty, and less than 100 characters.
        """
        return pulumi.get(self, "instance_pool_name")

    @instance_pool_name.setter
    def instance_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Integer) The maximum number of instances the pool can contain, including both idle instances and ones in use by clusters. Once the maximum capacity is reached, you cannot create new clusters from the pool and existing clusters cannot autoscale up until some instances are made idle in the pool via cluster termination or down-scaling. There is no default limit, but as a [best practice](https://docs.databricks.com/clusters/instance-pools/pool-best-practices.html#configure-pools-to-control-cost), this should be set based on anticipated usage.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_capacity", value)

    @_builtins.property
    @pulumi.getter(name="minIdleInstances")
    def min_idle_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Integer) The minimum number of idle instances maintained by the pool. This is in addition to any instances in use by active clusters.
        """
        return pulumi.get(self, "min_idle_instances")

    @min_idle_instances.setter
    def min_idle_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_idle_instances", value)

    @_builtins.property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) The node type for the instances in the pool. All clusters attached to the pool inherit this node type and the pool's idle instances are allocated based on this type. You can retrieve a list of available node types by using the [List Node Types API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistnodetypes) call.
        """
        return pulumi.get(self, "node_type_id")

    @node_type_id.setter
    def node_type_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type_id", value)

    @_builtins.property
    @pulumi.getter(name="preloadedDockerImages")
    def preloaded_docker_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolPreloadedDockerImageArgs']]]]:
        return pulumi.get(self, "preloaded_docker_images")

    @preloaded_docker_images.setter
    def preloaded_docker_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolPreloadedDockerImageArgs']]]]):
        pulumi.set(self, "preloaded_docker_images", value)

    @_builtins.property
    @pulumi.getter(name="preloadedSparkVersions")
    def preloaded_spark_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (List) A list with at most one runtime version the pool installs on each instance. Pool clusters that use a preloaded runtime version start faster as they do not have to wait for the image to download. You can retrieve them via get_spark_version data source or via  [Runtime Versions API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistsparkversions) call.
        """
        return pulumi.get(self, "preloaded_spark_versions")

    @preloaded_spark_versions.setter
    def preloaded_spark_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preloaded_spark_versions", value)


@pulumi.type_token("databricks:index/instancePool:InstancePool")
class InstancePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_attributes: Optional[pulumi.Input[Union['InstancePoolAwsAttributesArgs', 'InstancePoolAwsAttributesArgsDict']]] = None,
                 azure_attributes: Optional[pulumi.Input[Union['InstancePoolAzureAttributesArgs', 'InstancePoolAzureAttributesArgsDict']]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 disk_spec: Optional[pulumi.Input[Union['InstancePoolDiskSpecArgs', 'InstancePoolDiskSpecArgsDict']]] = None,
                 enable_elastic_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcp_attributes: Optional[pulumi.Input[Union['InstancePoolGcpAttributesArgs', 'InstancePoolGcpAttributesArgsDict']]] = None,
                 idle_instance_autotermination_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_pool_fleet_attributes: Optional[pulumi.Input[Union['InstancePoolInstancePoolFleetAttributesArgs', 'InstancePoolInstancePoolFleetAttributesArgsDict']]] = None,
                 instance_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 min_idle_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 node_type_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preloaded_docker_images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePoolPreloadedDockerImageArgs', 'InstancePoolPreloadedDockerImageArgsDict']]]]] = None,
                 preloaded_spark_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        This resource allows you to manage [instance pools](https://docs.databricks.com/clusters/instance-pools/index.html) to reduce cluster start and auto-scaling times by maintaining a set of idle, ready-to-use instances. An instance pool reduces cluster start and auto-scaling times by maintaining a set of idle, ready-to-use cloud instances. When a cluster attached to a pool needs an instance, it first attempts to allocate one of the pool's idle instances. If the pool has no idle instances, it expands by allocating a new instance from the instance provider in order to accommodate the cluster's request. When a cluster releases an instance, it returns to the pool and is free for another cluster to use. Only clusters attached to a pool can use that pool's idle instances.

        > This resource can only be used with a workspace-level provider!

        > It is important to know that different cloud service providers have different `node_type_id`, `disk_specs` and potentially other configurations.

        > "auto" `zone_id` is only supported for fleet node types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        smallest = databricks.get_node_type()
        smallest_nodes = databricks.InstancePool("smallest_nodes",
            instance_pool_name="Smallest Nodes",
            min_idle_instances=0,
            max_capacity=300,
            node_type_id=smallest.id,
            aws_attributes={
                "availability": "ON_DEMAND",
                "zone_id": "us-east-1a",
                "spot_bid_price_percent": 100,
            },
            idle_instance_autotermination_minutes=10,
            disk_spec={
                "disk_type": {
                    "ebs_volume_type": "GENERAL_PURPOSE_SSD",
                },
                "disk_size": 80,
                "disk_count": 1,
            })
        ```

        ## Access Control

        * Group and User can control which groups or individual users can create instance pools.
        * Permissions can control which groups or individual users can *Manage* or *Attach to* individual instance pools.

        ## Import

        The resource instance pool can be imported using its id:

        hcl

        import {

          to = databricks_instance_pool.this

          id = "<instance-pool-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/instancePool:InstancePool this <instance-pool-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: (Map) Additional tags for instance pool resources. Databricks tags all pool resources (e.g. AWS & Azure instances and Disk volumes). The tags of the instance pool will propagate to the clusters using the pool (see the [official documentation](https://docs.databricks.com/administration-guide/account-settings/usage-detail-tags-aws.html#tag-propagation)). Attempting to set the same tags in both cluster and instance pool will raise an error. *Databricks allows at most 43 custom tags.*
        :param pulumi.Input[_builtins.bool] enable_elastic_disk: (Bool) Autoscaling Local Storage: when enabled, the instances in the pool dynamically acquire additional disk space when they are running low on disk space.
        :param pulumi.Input[_builtins.int] idle_instance_autotermination_minutes: (Integer) The number of minutes that idle instances in excess of the min_idle_instances are maintained by the pool before being terminated. If not specified, excess idle instances are terminated automatically after a default timeout period. If specified, the time must be between 0 and 10000 minutes. If you specify 0, excess idle instances are removed as soon as possible.
        :param pulumi.Input[_builtins.str] instance_pool_name: (String) The name of the instance pool. This is required for create and edit operations. It must be unique, non-empty, and less than 100 characters.
        :param pulumi.Input[_builtins.int] max_capacity: (Integer) The maximum number of instances the pool can contain, including both idle instances and ones in use by clusters. Once the maximum capacity is reached, you cannot create new clusters from the pool and existing clusters cannot autoscale up until some instances are made idle in the pool via cluster termination or down-scaling. There is no default limit, but as a [best practice](https://docs.databricks.com/clusters/instance-pools/pool-best-practices.html#configure-pools-to-control-cost), this should be set based on anticipated usage.
        :param pulumi.Input[_builtins.int] min_idle_instances: (Integer) The minimum number of idle instances maintained by the pool. This is in addition to any instances in use by active clusters.
        :param pulumi.Input[_builtins.str] node_type_id: (String) The node type for the instances in the pool. All clusters attached to the pool inherit this node type and the pool's idle instances are allocated based on this type. You can retrieve a list of available node types by using the [List Node Types API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistnodetypes) call.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preloaded_spark_versions: (List) A list with at most one runtime version the pool installs on each instance. Pool clusters that use a preloaded runtime version start faster as they do not have to wait for the image to download. You can retrieve them via get_spark_version data source or via  [Runtime Versions API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistsparkversions) call.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstancePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage [instance pools](https://docs.databricks.com/clusters/instance-pools/index.html) to reduce cluster start and auto-scaling times by maintaining a set of idle, ready-to-use instances. An instance pool reduces cluster start and auto-scaling times by maintaining a set of idle, ready-to-use cloud instances. When a cluster attached to a pool needs an instance, it first attempts to allocate one of the pool's idle instances. If the pool has no idle instances, it expands by allocating a new instance from the instance provider in order to accommodate the cluster's request. When a cluster releases an instance, it returns to the pool and is free for another cluster to use. Only clusters attached to a pool can use that pool's idle instances.

        > This resource can only be used with a workspace-level provider!

        > It is important to know that different cloud service providers have different `node_type_id`, `disk_specs` and potentially other configurations.

        > "auto" `zone_id` is only supported for fleet node types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        smallest = databricks.get_node_type()
        smallest_nodes = databricks.InstancePool("smallest_nodes",
            instance_pool_name="Smallest Nodes",
            min_idle_instances=0,
            max_capacity=300,
            node_type_id=smallest.id,
            aws_attributes={
                "availability": "ON_DEMAND",
                "zone_id": "us-east-1a",
                "spot_bid_price_percent": 100,
            },
            idle_instance_autotermination_minutes=10,
            disk_spec={
                "disk_type": {
                    "ebs_volume_type": "GENERAL_PURPOSE_SSD",
                },
                "disk_size": 80,
                "disk_count": 1,
            })
        ```

        ## Access Control

        * Group and User can control which groups or individual users can create instance pools.
        * Permissions can control which groups or individual users can *Manage* or *Attach to* individual instance pools.

        ## Import

        The resource instance pool can be imported using its id:

        hcl

        import {

          to = databricks_instance_pool.this

          id = "<instance-pool-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/instancePool:InstancePool this <instance-pool-id>
        ```

        :param str resource_name: The name of the resource.
        :param InstancePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstancePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_attributes: Optional[pulumi.Input[Union['InstancePoolAwsAttributesArgs', 'InstancePoolAwsAttributesArgsDict']]] = None,
                 azure_attributes: Optional[pulumi.Input[Union['InstancePoolAzureAttributesArgs', 'InstancePoolAzureAttributesArgsDict']]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 disk_spec: Optional[pulumi.Input[Union['InstancePoolDiskSpecArgs', 'InstancePoolDiskSpecArgsDict']]] = None,
                 enable_elastic_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcp_attributes: Optional[pulumi.Input[Union['InstancePoolGcpAttributesArgs', 'InstancePoolGcpAttributesArgsDict']]] = None,
                 idle_instance_autotermination_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_pool_fleet_attributes: Optional[pulumi.Input[Union['InstancePoolInstancePoolFleetAttributesArgs', 'InstancePoolInstancePoolFleetAttributesArgsDict']]] = None,
                 instance_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 min_idle_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 node_type_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preloaded_docker_images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePoolPreloadedDockerImageArgs', 'InstancePoolPreloadedDockerImageArgsDict']]]]] = None,
                 preloaded_spark_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstancePoolArgs.__new__(InstancePoolArgs)

            __props__.__dict__["aws_attributes"] = aws_attributes
            __props__.__dict__["azure_attributes"] = azure_attributes
            __props__.__dict__["custom_tags"] = custom_tags
            __props__.__dict__["disk_spec"] = disk_spec
            __props__.__dict__["enable_elastic_disk"] = enable_elastic_disk
            __props__.__dict__["gcp_attributes"] = gcp_attributes
            if idle_instance_autotermination_minutes is None and not opts.urn:
                raise TypeError("Missing required property 'idle_instance_autotermination_minutes'")
            __props__.__dict__["idle_instance_autotermination_minutes"] = idle_instance_autotermination_minutes
            __props__.__dict__["instance_pool_fleet_attributes"] = instance_pool_fleet_attributes
            __props__.__dict__["instance_pool_id"] = instance_pool_id
            if instance_pool_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_pool_name'")
            __props__.__dict__["instance_pool_name"] = instance_pool_name
            __props__.__dict__["max_capacity"] = max_capacity
            __props__.__dict__["min_idle_instances"] = min_idle_instances
            __props__.__dict__["node_type_id"] = node_type_id
            __props__.__dict__["preloaded_docker_images"] = preloaded_docker_images
            __props__.__dict__["preloaded_spark_versions"] = preloaded_spark_versions
        super(InstancePool, __self__).__init__(
            'databricks:index/instancePool:InstancePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_attributes: Optional[pulumi.Input[Union['InstancePoolAwsAttributesArgs', 'InstancePoolAwsAttributesArgsDict']]] = None,
            azure_attributes: Optional[pulumi.Input[Union['InstancePoolAzureAttributesArgs', 'InstancePoolAzureAttributesArgsDict']]] = None,
            custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            disk_spec: Optional[pulumi.Input[Union['InstancePoolDiskSpecArgs', 'InstancePoolDiskSpecArgsDict']]] = None,
            enable_elastic_disk: Optional[pulumi.Input[_builtins.bool]] = None,
            gcp_attributes: Optional[pulumi.Input[Union['InstancePoolGcpAttributesArgs', 'InstancePoolGcpAttributesArgsDict']]] = None,
            idle_instance_autotermination_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            instance_pool_fleet_attributes: Optional[pulumi.Input[Union['InstancePoolInstancePoolFleetAttributesArgs', 'InstancePoolInstancePoolFleetAttributesArgsDict']]] = None,
            instance_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
            max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            min_idle_instances: Optional[pulumi.Input[_builtins.int]] = None,
            node_type_id: Optional[pulumi.Input[_builtins.str]] = None,
            preloaded_docker_images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePoolPreloadedDockerImageArgs', 'InstancePoolPreloadedDockerImageArgsDict']]]]] = None,
            preloaded_spark_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'InstancePool':
        """
        Get an existing InstancePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: (Map) Additional tags for instance pool resources. Databricks tags all pool resources (e.g. AWS & Azure instances and Disk volumes). The tags of the instance pool will propagate to the clusters using the pool (see the [official documentation](https://docs.databricks.com/administration-guide/account-settings/usage-detail-tags-aws.html#tag-propagation)). Attempting to set the same tags in both cluster and instance pool will raise an error. *Databricks allows at most 43 custom tags.*
        :param pulumi.Input[_builtins.bool] enable_elastic_disk: (Bool) Autoscaling Local Storage: when enabled, the instances in the pool dynamically acquire additional disk space when they are running low on disk space.
        :param pulumi.Input[_builtins.int] idle_instance_autotermination_minutes: (Integer) The number of minutes that idle instances in excess of the min_idle_instances are maintained by the pool before being terminated. If not specified, excess idle instances are terminated automatically after a default timeout period. If specified, the time must be between 0 and 10000 minutes. If you specify 0, excess idle instances are removed as soon as possible.
        :param pulumi.Input[_builtins.str] instance_pool_name: (String) The name of the instance pool. This is required for create and edit operations. It must be unique, non-empty, and less than 100 characters.
        :param pulumi.Input[_builtins.int] max_capacity: (Integer) The maximum number of instances the pool can contain, including both idle instances and ones in use by clusters. Once the maximum capacity is reached, you cannot create new clusters from the pool and existing clusters cannot autoscale up until some instances are made idle in the pool via cluster termination or down-scaling. There is no default limit, but as a [best practice](https://docs.databricks.com/clusters/instance-pools/pool-best-practices.html#configure-pools-to-control-cost), this should be set based on anticipated usage.
        :param pulumi.Input[_builtins.int] min_idle_instances: (Integer) The minimum number of idle instances maintained by the pool. This is in addition to any instances in use by active clusters.
        :param pulumi.Input[_builtins.str] node_type_id: (String) The node type for the instances in the pool. All clusters attached to the pool inherit this node type and the pool's idle instances are allocated based on this type. You can retrieve a list of available node types by using the [List Node Types API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistnodetypes) call.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preloaded_spark_versions: (List) A list with at most one runtime version the pool installs on each instance. Pool clusters that use a preloaded runtime version start faster as they do not have to wait for the image to download. You can retrieve them via get_spark_version data source or via  [Runtime Versions API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistsparkversions) call.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstancePoolState.__new__(_InstancePoolState)

        __props__.__dict__["aws_attributes"] = aws_attributes
        __props__.__dict__["azure_attributes"] = azure_attributes
        __props__.__dict__["custom_tags"] = custom_tags
        __props__.__dict__["disk_spec"] = disk_spec
        __props__.__dict__["enable_elastic_disk"] = enable_elastic_disk
        __props__.__dict__["gcp_attributes"] = gcp_attributes
        __props__.__dict__["idle_instance_autotermination_minutes"] = idle_instance_autotermination_minutes
        __props__.__dict__["instance_pool_fleet_attributes"] = instance_pool_fleet_attributes
        __props__.__dict__["instance_pool_id"] = instance_pool_id
        __props__.__dict__["instance_pool_name"] = instance_pool_name
        __props__.__dict__["max_capacity"] = max_capacity
        __props__.__dict__["min_idle_instances"] = min_idle_instances
        __props__.__dict__["node_type_id"] = node_type_id
        __props__.__dict__["preloaded_docker_images"] = preloaded_docker_images
        __props__.__dict__["preloaded_spark_versions"] = preloaded_spark_versions
        return InstancePool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsAttributes")
    def aws_attributes(self) -> pulumi.Output[Optional['outputs.InstancePoolAwsAttributes']]:
        return pulumi.get(self, "aws_attributes")

    @_builtins.property
    @pulumi.getter(name="azureAttributes")
    def azure_attributes(self) -> pulumi.Output[Optional['outputs.InstancePoolAzureAttributes']]:
        return pulumi.get(self, "azure_attributes")

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        (Map) Additional tags for instance pool resources. Databricks tags all pool resources (e.g. AWS & Azure instances and Disk volumes). The tags of the instance pool will propagate to the clusters using the pool (see the [official documentation](https://docs.databricks.com/administration-guide/account-settings/usage-detail-tags-aws.html#tag-propagation)). Attempting to set the same tags in both cluster and instance pool will raise an error. *Databricks allows at most 43 custom tags.*
        """
        return pulumi.get(self, "custom_tags")

    @_builtins.property
    @pulumi.getter(name="diskSpec")
    def disk_spec(self) -> pulumi.Output[Optional['outputs.InstancePoolDiskSpec']]:
        return pulumi.get(self, "disk_spec")

    @_builtins.property
    @pulumi.getter(name="enableElasticDisk")
    def enable_elastic_disk(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Bool) Autoscaling Local Storage: when enabled, the instances in the pool dynamically acquire additional disk space when they are running low on disk space.
        """
        return pulumi.get(self, "enable_elastic_disk")

    @_builtins.property
    @pulumi.getter(name="gcpAttributes")
    def gcp_attributes(self) -> pulumi.Output[Optional['outputs.InstancePoolGcpAttributes']]:
        return pulumi.get(self, "gcp_attributes")

    @_builtins.property
    @pulumi.getter(name="idleInstanceAutoterminationMinutes")
    def idle_instance_autotermination_minutes(self) -> pulumi.Output[_builtins.int]:
        """
        (Integer) The number of minutes that idle instances in excess of the min_idle_instances are maintained by the pool before being terminated. If not specified, excess idle instances are terminated automatically after a default timeout period. If specified, the time must be between 0 and 10000 minutes. If you specify 0, excess idle instances are removed as soon as possible.
        """
        return pulumi.get(self, "idle_instance_autotermination_minutes")

    @_builtins.property
    @pulumi.getter(name="instancePoolFleetAttributes")
    def instance_pool_fleet_attributes(self) -> pulumi.Output[Optional['outputs.InstancePoolInstancePoolFleetAttributes']]:
        return pulumi.get(self, "instance_pool_fleet_attributes")

    @_builtins.property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "instance_pool_id")

    @_builtins.property
    @pulumi.getter(name="instancePoolName")
    def instance_pool_name(self) -> pulumi.Output[_builtins.str]:
        """
        (String) The name of the instance pool. This is required for create and edit operations. It must be unique, non-empty, and less than 100 characters.
        """
        return pulumi.get(self, "instance_pool_name")

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Integer) The maximum number of instances the pool can contain, including both idle instances and ones in use by clusters. Once the maximum capacity is reached, you cannot create new clusters from the pool and existing clusters cannot autoscale up until some instances are made idle in the pool via cluster termination or down-scaling. There is no default limit, but as a [best practice](https://docs.databricks.com/clusters/instance-pools/pool-best-practices.html#configure-pools-to-control-cost), this should be set based on anticipated usage.
        """
        return pulumi.get(self, "max_capacity")

    @_builtins.property
    @pulumi.getter(name="minIdleInstances")
    def min_idle_instances(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Integer) The minimum number of idle instances maintained by the pool. This is in addition to any instances in use by active clusters.
        """
        return pulumi.get(self, "min_idle_instances")

    @_builtins.property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (String) The node type for the instances in the pool. All clusters attached to the pool inherit this node type and the pool's idle instances are allocated based on this type. You can retrieve a list of available node types by using the [List Node Types API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistnodetypes) call.
        """
        return pulumi.get(self, "node_type_id")

    @_builtins.property
    @pulumi.getter(name="preloadedDockerImages")
    def preloaded_docker_images(self) -> pulumi.Output[Optional[Sequence['outputs.InstancePoolPreloadedDockerImage']]]:
        return pulumi.get(self, "preloaded_docker_images")

    @_builtins.property
    @pulumi.getter(name="preloadedSparkVersions")
    def preloaded_spark_versions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        (List) A list with at most one runtime version the pool installs on each instance. Pool clusters that use a preloaded runtime version start faster as they do not have to wait for the image to download. You can retrieve them via get_spark_version data source or via  [Runtime Versions API](https://docs.databricks.com/dev-tools/api/latest/clusters.html#clusterclusterservicelistsparkversions) call.
        """
        return pulumi.get(self, "preloaded_spark_versions")

