# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlAlertArgs', 'SqlAlert']

@pulumi.input_type
class SqlAlertArgs:
    def __init__(__self__, *,
                 options: pulumi.Input['SqlAlertOptionsArgs'],
                 query_id: pulumi.Input[_builtins.str],
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 rearm: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SqlAlert resource.
        :param pulumi.Input['SqlAlertOptionsArgs'] options: Alert configuration options.
        :param pulumi.Input[_builtins.str] query_id: ID of the query evaluated by the alert.
        :param pulumi.Input[_builtins.str] name: Name of the alert.
        :param pulumi.Input[_builtins.str] parent: The identifier of the workspace folder containing the alert. The default is ther user's home folder. The folder identifier is formatted as `folder/<folder_id>`.
        :param pulumi.Input[_builtins.int] rearm: Number of seconds after being triggered before the alert rearms itself and can be triggered again. If not defined, alert will never be triggered again.
        """
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "query_id", query_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if rearm is not None:
            pulumi.set(__self__, "rearm", rearm)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Input['SqlAlertOptionsArgs']:
        """
        Alert configuration options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: pulumi.Input['SqlAlertOptionsArgs']):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="queryId")
    def query_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the query evaluated by the alert.
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "query_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the alert.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the workspace folder containing the alert. The default is ther user's home folder. The folder identifier is formatted as `folder/<folder_id>`.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def rearm(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds after being triggered before the alert rearms itself and can be triggered again. If not defined, alert will never be triggered again.
        """
        return pulumi.get(self, "rearm")

    @rearm.setter
    def rearm(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rearm", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.input_type
class _SqlAlertState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input['SqlAlertOptionsArgs']] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rearm: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlAlert resources.
        :param pulumi.Input[_builtins.str] name: Name of the alert.
        :param pulumi.Input['SqlAlertOptionsArgs'] options: Alert configuration options.
        :param pulumi.Input[_builtins.str] parent: The identifier of the workspace folder containing the alert. The default is ther user's home folder. The folder identifier is formatted as `folder/<folder_id>`.
        :param pulumi.Input[_builtins.str] query_id: ID of the query evaluated by the alert.
        :param pulumi.Input[_builtins.int] rearm: Number of seconds after being triggered before the alert rearms itself and can be triggered again. If not defined, alert will never be triggered again.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)
        if rearm is not None:
            pulumi.set(__self__, "rearm", rearm)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the alert.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['SqlAlertOptionsArgs']]:
        """
        Alert configuration options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['SqlAlertOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the workspace folder containing the alert. The default is ther user's home folder. The folder identifier is formatted as `folder/<folder_id>`.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the query evaluated by the alert.
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_id", value)

    @_builtins.property
    @pulumi.getter
    def rearm(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds after being triggered before the alert rearms itself and can be triggered again. If not defined, alert will never be triggered again.
        """
        return pulumi.get(self, "rearm")

    @rearm.setter
    def rearm(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rearm", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("databricks:index/sqlAlert:SqlAlert")
class SqlAlert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['SqlAlertOptionsArgs', 'SqlAlertOptionsArgsDict']]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rearm: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        !> This resource is deprecated! Please switch to databricks_alert.

        This resource allows you to manage [Databricks SQL Alerts](https://docs.databricks.com/sql/user/queries/index.html).

        > To manage [SQLA resources](https://docs.databricks.com/sql/get-started/concepts.html) you must have `databricks_sql_access` on your Group or databricks_user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        shared_dir = databricks.Directory("shared_dir", path="/Shared/Queries")
        this = databricks.SqlQuery("this",
            data_source_id=example["dataSourceId"],
            name="My Query Name",
            query="SELECT 1 AS p1, 2 as p2",
            parent=shared_dir.object_id.apply(lambda object_id: f"folders/{object_id}"))
        alert = databricks.SqlAlert("alert",
            query_id=this.id,
            name="My Alert",
            parent=shared_dir.object_id.apply(lambda object_id: f"folders/{object_id}"),
            rearm=1,
            options={
                "column": "p1",
                "op": "==",
                "value": "2",
                "muted": False,
            })
        ```

        ## Access Control

        Permissions can control which groups or individual users can *Manage*, *Edit*, *Run* or *View* individual alerts.

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * SqlQuery to manage Databricks SQL [Queries](https://docs.databricks.com/sql/user/queries/index.html).
        * SqlEndpoint to manage Databricks SQL [Endpoints](https://docs.databricks.com/sql/admin/sql-endpoints.html).
        * Directory to manage directories in [Databricks Workpace](https://docs.databricks.com/workspace/workspace-objects.html).

        ## Import

        This resource can be imported using alert ID:

        hcl

        import {

          to = databricks_sql_alert.this

          id = "<alert-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/sqlAlert:SqlAlert this "<alert-id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the alert.
        :param pulumi.Input[Union['SqlAlertOptionsArgs', 'SqlAlertOptionsArgsDict']] options: Alert configuration options.
        :param pulumi.Input[_builtins.str] parent: The identifier of the workspace folder containing the alert. The default is ther user's home folder. The folder identifier is formatted as `folder/<folder_id>`.
        :param pulumi.Input[_builtins.str] query_id: ID of the query evaluated by the alert.
        :param pulumi.Input[_builtins.int] rearm: Number of seconds after being triggered before the alert rearms itself and can be triggered again. If not defined, alert will never be triggered again.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlAlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> This resource is deprecated! Please switch to databricks_alert.

        This resource allows you to manage [Databricks SQL Alerts](https://docs.databricks.com/sql/user/queries/index.html).

        > To manage [SQLA resources](https://docs.databricks.com/sql/get-started/concepts.html) you must have `databricks_sql_access` on your Group or databricks_user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        shared_dir = databricks.Directory("shared_dir", path="/Shared/Queries")
        this = databricks.SqlQuery("this",
            data_source_id=example["dataSourceId"],
            name="My Query Name",
            query="SELECT 1 AS p1, 2 as p2",
            parent=shared_dir.object_id.apply(lambda object_id: f"folders/{object_id}"))
        alert = databricks.SqlAlert("alert",
            query_id=this.id,
            name="My Alert",
            parent=shared_dir.object_id.apply(lambda object_id: f"folders/{object_id}"),
            rearm=1,
            options={
                "column": "p1",
                "op": "==",
                "value": "2",
                "muted": False,
            })
        ```

        ## Access Control

        Permissions can control which groups or individual users can *Manage*, *Edit*, *Run* or *View* individual alerts.

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * SqlQuery to manage Databricks SQL [Queries](https://docs.databricks.com/sql/user/queries/index.html).
        * SqlEndpoint to manage Databricks SQL [Endpoints](https://docs.databricks.com/sql/admin/sql-endpoints.html).
        * Directory to manage directories in [Databricks Workpace](https://docs.databricks.com/workspace/workspace-objects.html).

        ## Import

        This resource can be imported using alert ID:

        hcl

        import {

          to = databricks_sql_alert.this

          id = "<alert-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/sqlAlert:SqlAlert this "<alert-id>"
        ```

        :param str resource_name: The name of the resource.
        :param SqlAlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlAlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['SqlAlertOptionsArgs', 'SqlAlertOptionsArgsDict']]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rearm: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlAlertArgs.__new__(SqlAlertArgs)

            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["name"] = name
            if options is None and not opts.urn:
                raise TypeError("Missing required property 'options'")
            __props__.__dict__["options"] = options
            __props__.__dict__["parent"] = parent
            if query_id is None and not opts.urn:
                raise TypeError("Missing required property 'query_id'")
            __props__.__dict__["query_id"] = query_id
            __props__.__dict__["rearm"] = rearm
            __props__.__dict__["updated_at"] = updated_at
        super(SqlAlert, __self__).__init__(
            'databricks:index/sqlAlert:SqlAlert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Union['SqlAlertOptionsArgs', 'SqlAlertOptionsArgsDict']]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            query_id: Optional[pulumi.Input[_builtins.str]] = None,
            rearm: Optional[pulumi.Input[_builtins.int]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'SqlAlert':
        """
        Get an existing SqlAlert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the alert.
        :param pulumi.Input[Union['SqlAlertOptionsArgs', 'SqlAlertOptionsArgsDict']] options: Alert configuration options.
        :param pulumi.Input[_builtins.str] parent: The identifier of the workspace folder containing the alert. The default is ther user's home folder. The folder identifier is formatted as `folder/<folder_id>`.
        :param pulumi.Input[_builtins.str] query_id: ID of the query evaluated by the alert.
        :param pulumi.Input[_builtins.int] rearm: Number of seconds after being triggered before the alert rearms itself and can be triggered again. If not defined, alert will never be triggered again.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlAlertState.__new__(_SqlAlertState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["parent"] = parent
        __props__.__dict__["query_id"] = query_id
        __props__.__dict__["rearm"] = rearm
        __props__.__dict__["updated_at"] = updated_at
        return SqlAlert(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the alert.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output['outputs.SqlAlertOptions']:
        """
        Alert configuration options.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier of the workspace folder containing the alert. The default is ther user's home folder. The folder identifier is formatted as `folder/<folder_id>`.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="queryId")
    def query_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the query evaluated by the alert.
        """
        return pulumi.get(self, "query_id")

    @_builtins.property
    @pulumi.getter
    def rearm(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of seconds after being triggered before the alert rearms itself and can be triggered again. If not defined, alert will never be triggered again.
        """
        return pulumi.get(self, "rearm")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

