# mypy-boto3-iam

Type annotations for
[boto3.IAM 1.10.48](https://boto3.amazonaws.com/v1/documentation/api/1.10.48/reference/services/iam.html#IAM) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

More information can be found [here](https://vemel.github.io/mypy_boto3/).

- [mypy-boto3-iam](#mypy-boto3-iam)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
    - [Code auto-complete](#code-auto-complete)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `IAM` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-iam]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import iam
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_iam as iam

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("iam")
client: iam.IAMClient = boto3.client("iam")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: iam.IAMClient = session.client("iam")

# Do you prefer resource approach? We've got you covered!
resource: iam.IAMServiceResource = boto3.resource("iam")

# Waiters need type annotation on creation
instance_profile_exists_waiter: iam.InstanceProfileExistsWaiter = client.get_waiter("instance_profile_exists")
policy_exists_waiter: iam.PolicyExistsWaiter = client.get_waiter("policy_exists")
role_exists_waiter: iam.RoleExistsWaiter = client.get_waiter("role_exists")
user_exists_waiter: iam.UserExistsWaiter = client.get_waiter("user_exists")

# Paginators need type annotation on creation
get_account_authorization_details_paginator: iam.GetAccountAuthorizationDetailsPaginator = client.get_paginator("get_account_authorization_details")
get_group_paginator: iam.GetGroupPaginator = client.get_paginator("get_group")
list_access_keys_paginator: iam.ListAccessKeysPaginator = client.get_paginator("list_access_keys")
list_account_aliases_paginator: iam.ListAccountAliasesPaginator = client.get_paginator("list_account_aliases")
list_attached_group_policies_paginator: iam.ListAttachedGroupPoliciesPaginator = client.get_paginator("list_attached_group_policies")
list_attached_role_policies_paginator: iam.ListAttachedRolePoliciesPaginator = client.get_paginator("list_attached_role_policies")
list_attached_user_policies_paginator: iam.ListAttachedUserPoliciesPaginator = client.get_paginator("list_attached_user_policies")
list_entities_for_policy_paginator: iam.ListEntitiesForPolicyPaginator = client.get_paginator("list_entities_for_policy")
list_group_policies_paginator: iam.ListGroupPoliciesPaginator = client.get_paginator("list_group_policies")
list_groups_paginator: iam.ListGroupsPaginator = client.get_paginator("list_groups")
list_groups_for_user_paginator: iam.ListGroupsForUserPaginator = client.get_paginator("list_groups_for_user")
list_instance_profiles_paginator: iam.ListInstanceProfilesPaginator = client.get_paginator("list_instance_profiles")
list_instance_profiles_for_role_paginator: iam.ListInstanceProfilesForRolePaginator = client.get_paginator("list_instance_profiles_for_role")
list_mfa_devices_paginator: iam.ListMFADevicesPaginator = client.get_paginator("list_mfa_devices")
list_policies_paginator: iam.ListPoliciesPaginator = client.get_paginator("list_policies")
list_policy_versions_paginator: iam.ListPolicyVersionsPaginator = client.get_paginator("list_policy_versions")
list_role_policies_paginator: iam.ListRolePoliciesPaginator = client.get_paginator("list_role_policies")
list_roles_paginator: iam.ListRolesPaginator = client.get_paginator("list_roles")
list_ssh_public_keys_paginator: iam.ListSSHPublicKeysPaginator = client.get_paginator("list_ssh_public_keys")
list_server_certificates_paginator: iam.ListServerCertificatesPaginator = client.get_paginator("list_server_certificates")
list_signing_certificates_paginator: iam.ListSigningCertificatesPaginator = client.get_paginator("list_signing_certificates")
list_user_policies_paginator: iam.ListUserPoliciesPaginator = client.get_paginator("list_user_policies")
list_users_paginator: iam.ListUsersPaginator = client.get_paginator("list_users")
list_virtual_mfa_devices_paginator: iam.ListVirtualMFADevicesPaginator = client.get_paginator("list_virtual_mfa_devices")
simulate_custom_policy_paginator: iam.SimulateCustomPolicyPaginator = client.get_paginator("simulate_custom_policy")
simulate_principal_policy_paginator: iam.SimulatePrincipalPolicyPaginator = client.get_paginator("simulate_principal_policy")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.