"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InferenceJob = exports.InferenceJobProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const paiplugin_generated_1 = require("./paiplugin.generated");
Object.defineProperty(exports, "InferenceJobProperty", { enumerable: true, get: function () { return paiplugin_generated_1.RosInferenceJob; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAIPlugin::InferenceJob`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosInferenceJob`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-paiplugin-inferencejob
 */
class InferenceJob extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosInferenceJob = new paiplugin_generated_1.RosInferenceJob(this, id, {
            dataPath: props.dataPath,
            trainingJobId: props.trainingJobId,
            campaignId: props.campaignId,
            targetPath: props.targetPath,
            userConfig: props.userConfig,
            algorithm: props.algorithm,
            waitForInferenceFinish: props.waitForInferenceFinish === undefined || props.waitForInferenceFinish === null ? true : props.waitForInferenceFinish,
            remark: props.remark,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInferenceJob;
        this.attrGroupId = rosInferenceJob.attrGroupId;
        this.attrInferenceJobId = rosInferenceJob.attrInferenceJobId;
    }
}
exports.InferenceJob = InferenceJob;
//# sourceMappingURL=data:application/json;base64,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