# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['locasticsearch', 'locasticsearch.client', 'locasticsearch.helpers']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'locasticsearch',
    'version': '0.0.3',
    'description': 'Serverless full text search in Python',
    'long_description': '# Locasticsearch\n\n<p align="center">\n    <em>Serverless full text search in Python</em>\n</p>\n\n> ⚠️ **alpha status**: 🚧 Come back in a couple weekends 🚧\n\nLocasticsearch provides serverless full text search powered by [sqlite full text search capabilities](https://www.sqlite.org/fts5.html) but trying to be compatible with (a subset of) the elasticsearch API.\n\nThat way you can comfortably develop your text search appplication without needing to set up services and smoothly transition to Elasticsearch for scale or more features without changing your code.\n\nThat said, if you are only doing basic search operations within the subset supported by this library, and dont have a lot of documents (~million) that would justify going for a cluster deployment, Locasticsearch [can be a faster](benchmarks) alternative to Elasticsearch.\n\n<p align="center">\n<a href="https://github.com/elyase/locasticsearch/actions?query=workflow%3ATest" target="_blank">\n    <img src="https://github.com/elyase/locasticsearch/workflows/Test/badge.svg" alt="Test">\n</a>\n<a href="https://github.com/elyase/locasticsearch/actions?query=workflow%3APublish" target="_blank">\n    <img src="https://github.com/elyase/locasticsearch/workflows/Publish/badge.svg" alt="Publish">\n</a>\n<a href="https://codecov.io/gh/elyase/locasticsearch" target="_blank">\n    <img src="https://img.shields.io/codecov/c/github/elyase/locasticsearch?color=%2334D058" alt="Coverage">\n</a>\n<a href="https://pypi.org/project/locasticsearch" target="_blank">\n    <img src="https://img.shields.io/pypi/v/locasticsearch?color=%2334D058&label=pypi%20package" alt="Package version">\n</a>\n<a href="https://pypi.org/project/locasticsearch/" target="_blank">\n    <img src="https://img.shields.io/pypi/pyversions/locasticsearch.svg" alt="Python Versions">\n</a>\n</p>\n\n\n## Getting started\n\n```\nfrom locasticsearch import Locasticsearch\nfrom datetime import datetime\n\nes = Locasticsearch()\n\ndoc = {\n    "author": "kimchy",\n    "text": "Elasticsearch: cool. bonsai cool.",\n    "timestamp": datetime(2010, 10, 10, 10, 10, 10),\n}\nres = es.index(index="test-index", doc_type="tweet", id=1, body=doc)\n\nres = es.get(index="test-index", doc_type="tweet", id=1)\nprint(res["_source"])\n\n# this will get ignored in Locasticsearch\nes.indices.refresh(index="test-index")\n\nres = es.search(index="test-index", body={"query": {"match_all": {}}})\nprint("Got %d Hits:" % res["hits"]["total"]["value"])\nfor hit in res["hits"]["hits"]:\n    print("%(timestamp)s %(author)s: %(text)s" % hit["_source"])\n```\n\nWe are also adding a simplified API that can be converted to Elasticsearch.\n\n## Features\n\n- 💯% local, no server management\n- ✨ Lightweight pure python, no external dependencies\n- ⚡ Super fast searches thanks to [sqlite full text search capabilities](https://www.sqlite.org/fts5.html)\n- 🔗 No lock in. Thanks to the API compatiblity with the official client, you can smoothly transition to Elasticsearch for scale or more features without changing your code.\n\n## Install\n\n```bash\npip install locasticsearch\n```\n\n## To use or not to use\n\nYou should NOT use Locasticsearch if:\n\n- you are deploying a security sensitive application. Locasticsearch code is very prone to SQL injection attacks. This should improve in future releases.\n- Your searches are more complicated than what you would find in a 5 min Elasticsearch tutorial. Elasticsearch has a huge API and it is very unlikely that we can support even a sizable portion of that.\n- You hate buggy libraries. Locasticsearch is a very young project so bugs are guaranteed. You can check the tests to see if your needs are covered. \n\nYou should use Locasticsearch if:\n\n- you dont want a docker or an elasticsearch service using precious resources in your laptop\n- you only need basic text search and Elasticsearch would be overkill\n- you want very easy deployments that only involve pip installs\n- using Java from a python program makes you feel dirty\n\n\n## Next steps\n\n- [] Add a real query DSL parsing\n- [] Add simplified non ES compatible interface for easy JSON ingestion, querying\n- [] Document supported vs unsupported query types\n\n\n## Comparison to similar libraries\n\n### [whoosh](https://whoosh.readthedocs.io/en/latest/intro.html)\n\nThe most full featured **pure python** text search library by far:\n\n- 👍 Supports highlight, analyzers, query expansion, several ranking functions, ...  \n- 👎 Unmaintained for a long time might see a revival at https://github.com/whoosh-community/whoosh \n- 👍 Pure python so doesnt scale as well (still fast enough for small medium datasets) \n\n### [elasticsearch](https://www.elastic.co)\n\nThe big champion of full text search. This is what you should be using in production:\n\n- 👍 Lots of features to accomodate any use case\n- 👍 Battle tested, scalable, performant\n- 👎 Non python native: more complex to deploy/integrate with python project for easy use cases\n\n\n### [django haystack](https://django-haystack.readthedocs.io/en/master/)\n\nDjango Haystack provides an unified API that allows you to plug in different search backends (such as Solr, Elasticsearch, Whoosh, Xapian, etc.) without having to modify your code:\n\n- 👍 Many features, boosting, highlight, autocomplete (some backend dependent though)\n- 👍 Possibility to switch backends\n- 👎 Library lock in.\n- 👎 Despite supporting several backends, Whoosh is the only one that is python native.\n\n\n### [xapian](https://xapian.org/docs/bindings/python/)\n\n- 👍 Very fast and full featured (C++) \n- 👎 No pip installable (needs system level compilation)\n- 👎 The python bindings and the documentation are not that user friendly\n\n\n### [gensim](https://radimrehurek.com/gensim/)\n\nWhile gensim focuses on topic modeling you can use `TfidfModel` and `SparseMatrixSimilarity` for text search. That said this is doesnt use an inverted index (linear search) so it has limited scalability.\n\n- 👍 Unique features such as approximate search\n- 👎 Focus is on topic modeling, so no intuitive APIs for full text ingestion/search\n- 👎 Doesnt support inverted indexes search (mostly full scan and approximate)\n\n\n### [peewee](http://docs.peewee-orm.com/en/latest/)\n\nPeewee is actually a more general ORM but offers abstractions to use full text search on Sqlite.\n\n- 👍 Support for full text search using several SQL backends (no elasticsearch though)\n- 👍 Custom ranking and analyzer functions\n- 👎 No elasticsearch compatible API\n\n\n',
    'author': 'Yaser Martinez',
    'author_email': 'yaser.martinez@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
