"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.aaa_user_agent import AaaUserAgent
    globals()['AaaUserAgent'] = AaaUserAgent


class AaaAbstractAuditRecordAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'AAA.AUDITRECORD': "aaa.AuditRecord",
        },
        ('object_type',): {
            'AAA.AUDITRECORD': "aaa.AuditRecord",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'event': (str,),  # noqa: E501
            'http_operation': (str,),  # noqa: E501
            'http_response_code': (int,),  # noqa: E501
            'http_response_payload': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'mo_display_names': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'mo_type': (str,),  # noqa: E501
            'object_moid': (str,),  # noqa: E501
            'request': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'trace_id': (str,),  # noqa: E501
            'user_agent': (AaaUserAgent,),  # noqa: E501
            'user_agent_string': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'event': 'Event',  # noqa: E501
        'http_operation': 'HttpOperation',  # noqa: E501
        'http_response_code': 'HttpResponseCode',  # noqa: E501
        'http_response_payload': 'HttpResponsePayload',  # noqa: E501
        'mo_display_names': 'MoDisplayNames',  # noqa: E501
        'mo_type': 'MoType',  # noqa: E501
        'object_moid': 'ObjectMoid',  # noqa: E501
        'request': 'Request',  # noqa: E501
        'trace_id': 'TraceId',  # noqa: E501
        'user_agent': 'UserAgent',  # noqa: E501
        'user_agent_string': 'UserAgentString',  # noqa: E501
    }

    read_only_vars = {
        'event',  # noqa: E501
        'http_operation',  # noqa: E501
        'http_response_code',  # noqa: E501
        'http_response_payload',  # noqa: E501
        'mo_display_names',  # noqa: E501
        'mo_type',  # noqa: E501
        'object_moid',  # noqa: E501
        'request',  # noqa: E501
        'trace_id',  # noqa: E501
        'user_agent_string',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """AaaAbstractAuditRecordAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.. defaults to "aaa.AuditRecord", must be one of ["aaa.AuditRecord", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.. defaults to "aaa.AuditRecord", must be one of ["aaa.AuditRecord", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            event (str): The operation that was performed on this Managed Object. The event is a compound string that includes the CRUD operation such as Create, Modify, Delete, and a string representing the Managed Object type.. [optional]  # noqa: E501
            http_operation (str): The REST URL for the operation.. [optional]  # noqa: E501
            http_response_code (int): The response code of the operation.. [optional]  # noqa: E501
            http_response_payload (bool, date, datetime, dict, float, int, list, str, none_type): The response body of the operation, with JSON truncated to 2 nested levels when its size exceeds 10KB.. [optional]  # noqa: E501
            mo_display_names (bool, date, datetime, dict, float, int, list, str, none_type): The user-friendly names of the changed MO.. [optional]  # noqa: E501
            mo_type (str): The object type of the REST resource that was created, modified or deleted.. [optional]  # noqa: E501
            object_moid (str): The Moid of the REST resource that was created, modified or deleted.. [optional]  # noqa: E501
            request (bool, date, datetime, dict, float, int, list, str, none_type): The body of the REST request that was received from a client to create or modify a REST resource, represented as a JSON document.. [optional]  # noqa: E501
            trace_id (str): The trace id of the request that was used to create, modify or delete a REST resource. A trace id is a unique identifier for one particular REST request. It may be used for troubleshooting purpose by the Intersight technical support team.. [optional]  # noqa: E501
            user_agent (AaaUserAgent): [optional]  # noqa: E501
            user_agent_string (str): The raw, string representation of the user agent of the request from the user-agent http request header.. [optional]  # noqa: E501
        """

        class_id = "aaa.AuditRecord" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "aaa.AuditRecord")
        object_type = "aaa.AuditRecord" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "aaa.AuditRecord")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """AaaAbstractAuditRecordAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.. defaults to "aaa.AuditRecord", must be one of ["aaa.AuditRecord", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.. defaults to "aaa.AuditRecord", must be one of ["aaa.AuditRecord", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            event (str): The operation that was performed on this Managed Object. The event is a compound string that includes the CRUD operation such as Create, Modify, Delete, and a string representing the Managed Object type.. [optional]  # noqa: E501
            http_operation (str): The REST URL for the operation.. [optional]  # noqa: E501
            http_response_code (int): The response code of the operation.. [optional]  # noqa: E501
            http_response_payload (bool, date, datetime, dict, float, int, list, str, none_type): The response body of the operation, with JSON truncated to 2 nested levels when its size exceeds 10KB.. [optional]  # noqa: E501
            mo_display_names (bool, date, datetime, dict, float, int, list, str, none_type): The user-friendly names of the changed MO.. [optional]  # noqa: E501
            mo_type (str): The object type of the REST resource that was created, modified or deleted.. [optional]  # noqa: E501
            object_moid (str): The Moid of the REST resource that was created, modified or deleted.. [optional]  # noqa: E501
            request (bool, date, datetime, dict, float, int, list, str, none_type): The body of the REST request that was received from a client to create or modify a REST resource, represented as a JSON document.. [optional]  # noqa: E501
            trace_id (str): The trace id of the request that was used to create, modify or delete a REST resource. A trace id is a unique identifier for one particular REST request. It may be used for troubleshooting purpose by the Intersight technical support team.. [optional]  # noqa: E501
            user_agent (AaaUserAgent): [optional]  # noqa: E501
            user_agent_string (str): The raw, string representation of the user agent of the request from the user-agent http request header.. [optional]  # noqa: E501
        """

        class_id = "aaa.AuditRecord" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "aaa.AuditRecord")
        object_type = "aaa.AuditRecord" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "aaa.AuditRecord")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
