"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_claim_signature import AssetClaimSignature
    from intersight.model.asset_cluster_member_relationship import AssetClusterMemberRelationship
    from intersight.model.asset_device_claim_relationship import AssetDeviceClaimRelationship
    from intersight.model.asset_device_configuration_relationship import AssetDeviceConfigurationRelationship
    from intersight.model.asset_device_connection import AssetDeviceConnection
    from intersight.model.asset_device_registration_all_of import AssetDeviceRegistrationAllOf
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.asset_target_relationship import AssetTargetRelationship
    from intersight.model.display_names import DisplayNames
    from intersight.model.iam_account_relationship import IamAccountRelationship
    from intersight.model.iam_domain_group_relationship import IamDomainGroupRelationship
    from intersight.model.iam_user_relationship import IamUserRelationship
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    globals()['AssetClaimSignature'] = AssetClaimSignature
    globals()['AssetClusterMemberRelationship'] = AssetClusterMemberRelationship
    globals()['AssetDeviceClaimRelationship'] = AssetDeviceClaimRelationship
    globals()['AssetDeviceConfigurationRelationship'] = AssetDeviceConfigurationRelationship
    globals()['AssetDeviceConnection'] = AssetDeviceConnection
    globals()['AssetDeviceRegistrationAllOf'] = AssetDeviceRegistrationAllOf
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['AssetTargetRelationship'] = AssetTargetRelationship
    globals()['DisplayNames'] = DisplayNames
    globals()['IamAccountRelationship'] = IamAccountRelationship
    globals()['IamDomainGroupRelationship'] = IamDomainGroupRelationship
    globals()['IamUserRelationship'] = IamUserRelationship
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext


class AssetDeviceRegistration(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'ASSET.DEVICEREGISTRATION': "asset.DeviceRegistration",
        },
        ('object_type',): {
            'ASSET.DEVICEREGISTRATION': "asset.DeviceRegistration",
        },
        ('execution_mode',): {
            'EMPTY': "",
            'NORMAL': "Normal",
            'EMULATOR': "Emulator",
            'CONTAINEREMULATOR': "ContainerEmulator",
        },
        ('platform_type',): {
            'EMPTY': "",
            'APIC': "APIC",
            'CAPIC': "CAPIC",
            'DCNM': "DCNM",
            'UCSFI': "UCSFI",
            'UCSFIISM': "UCSFIISM",
            'IMC': "IMC",
            'IMCM4': "IMCM4",
            'IMCM5': "IMCM5",
            'IMCRACK': "IMCRack",
            'UCSIOM': "UCSIOM",
            'UCSPCIENODE': "UCSPCIeNODE",
            'UCSXFM': "UCSXFM",
            'HX': "HX",
            'UCSD': "UCSD",
            'UCSXECMC': "UCSXECMC",
            'INTERSIGHTAPPLIANCE': "IntersightAppliance",
            'INTERSIGHTASSIST': "IntersightAssist",
            'PURESTORAGEFLASHARRAY': "PureStorageFlashArray",
            'NEXUSDEVICE': "NexusDevice",
            'ACISWITCH': "ACISwitch",
            'NEXUSSWITCH': "NexusSwitch",
            'MDSSWITCH': "MDSSwitch",
            'MDSDEVICE': "MDSDevice",
            'UCSC885': "UCSC885",
            'CAI845A': "CAI845A",
            'UCSC890': "UCSC890",
            'REDFISHSERVER': "RedfishServer",
            'NETAPPONTAP': "NetAppOntap",
            'NETAPPACTIVEIQUNIFIEDMANAGER': "NetAppActiveIqUnifiedManager",
            'EMCSCALEIO': "EmcScaleIo",
            'EMCVMAX': "EmcVmax",
            'EMCVPLEX': "EmcVplex",
            'EMCXTREMIO': "EmcXtremIo",
            'VMWAREVCENTER': "VmwareVcenter",
            'MICROSOFTHYPERV': "MicrosoftHyperV",
            'APPDYNAMICS': "AppDynamics",
            'DYNATRACE': "Dynatrace",
            'NEWRELIC': "NewRelic",
            'SERVICENOW': "ServiceNow",
            'UMBRELLA': "Umbrella",
            'CLOUDFOUNDRY': "CloudFoundry",
            'MICROSOFTAZUREAPPLICATIONINSIGHTS': "MicrosoftAzureApplicationInsights",
            'OPENSTACK': "OpenStack",
            'MICROSOFTSQLSERVER': "MicrosoftSqlServer",
            'MYSQLSERVER': "MySqlServer",
            'ORACLEDATABASESERVER': "OracleDatabaseServer",
            'IBMWEBSPHEREAPPLICATIONSERVER': "IBMWebSphereApplicationServer",
            'ORACLEWEBLOGICSERVER': "OracleWebLogicServer",
            'APACHETOMCATSERVER': "ApacheTomcatServer",
            'JAVAVIRTUALMACHINE': "JavaVirtualMachine",
            'REDHATJBOSSAPPLICATIONSERVER': "RedHatJBossApplicationServer",
            'KUBERNETES': "Kubernetes",
            'AMAZONWEBSERVICE': "AmazonWebService",
            'AMAZONWEBSERVICEBILLING': "AmazonWebServiceBilling",
            'GOOGLECLOUDPLATFORM': "GoogleCloudPlatform",
            'GOOGLECLOUDPLATFORMBILLING': "GoogleCloudPlatformBilling",
            'MICROSOFTAZURESERVICEPRINCIPAL': "MicrosoftAzureServicePrincipal",
            'MICROSOFTAZUREENTERPRISEAGREEMENT': "MicrosoftAzureEnterpriseAgreement",
            'MICROSOFTAZUREBILLING': "MicrosoftAzureBilling",
            'DELLCOMPELLENT': "DellCompellent",
            'HPE3PAR': "HPE3Par",
            'REDHATENTERPRISEVIRTUALIZATION': "RedHatEnterpriseVirtualization",
            'NUTANIXACROPOLIS': "NutanixAcropolis",
            'NUTANIXPRISMCENTRAL': "NutanixPrismCentral",
            'HPEONEVIEW': "HPEOneView",
            'SERVICEENGINE': "ServiceEngine",
            'HITACHIVIRTUALSTORAGEPLATFORM': "HitachiVirtualStoragePlatform",
            'GENERICTARGET': "GenericTarget",
            'IMCBLADE': "IMCBlade",
            'TERRAFORMCLOUD': "TerraformCloud",
            'TERRAFORMAGENT': "TerraformAgent",
            'CUSTOMTARGET': "CustomTarget",
            'ANSIBLEENDPOINT': "AnsibleEndpoint",
            'HTTPENDPOINT': "HTTPEndpoint",
            'SSHENDPOINT': "SSHEndpoint",
            'CISCOCATALYST': "CiscoCatalyst",
            'POWERSHELLENDPOINT': "PowerShellEndpoint",
            'CISCODNAC': "CiscoDNAC",
            'CISCOFMC': "CiscoFMC",
            'VIPTELACLOUD': "ViptelaCloud",
            'MERAKICLOUD': "MerakiCloud",
            'CISCOISE': "CiscoISE",
        },
        ('connection_status',): {
            'EMPTY': "",
            'CONNECTED': "Connected",
            'NOTCONNECTED': "NotConnected",
            'CLAIMINPROGRESS': "ClaimInProgress",
            'UNCLAIMINPROGRESS': "UnclaimInProgress",
            'UNCLAIMED': "Unclaimed",
            'CLAIMED': "Claimed",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'access_key_id': (str,),  # noqa: E501
            'claimed_by_user_name': (str,),  # noqa: E501
            'claimed_time': (datetime,),  # noqa: E501
            'device_hostname': ([str], none_type,),  # noqa: E501
            'device_ip_address': ([str], none_type,),  # noqa: E501
            'execution_mode': (str,),  # noqa: E501
            'parent_signature': (AssetClaimSignature,),  # noqa: E501
            'pid': ([str], none_type,),  # noqa: E501
            'platform_type': (str,),  # noqa: E501
            'public_access_key': (str,),  # noqa: E501
            'public_access_key_rotated': (str,),  # noqa: E501
            'public_encryption_key': (str,),  # noqa: E501
            'read_only': (bool,),  # noqa: E501
            'rotate_access_key': (bool,),  # noqa: E501
            'serial': ([str], none_type,),  # noqa: E501
            'vendor': (str,),  # noqa: E501
            'account': (IamAccountRelationship,),  # noqa: E501
            'claimed_by_user': (IamUserRelationship,),  # noqa: E501
            'cluster_members': ([AssetClusterMemberRelationship], none_type,),  # noqa: E501
            'custom_permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'device_claim': (AssetDeviceClaimRelationship,),  # noqa: E501
            'device_configuration': (AssetDeviceConfigurationRelationship,),  # noqa: E501
            'domain_group': (IamDomainGroupRelationship,),  # noqa: E501
            'parent_connection': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'target': (AssetTargetRelationship,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'api_version': (int,),  # noqa: E501
            'app_partition_number': (int,),  # noqa: E501
            'connection_id': (str,),  # noqa: E501
            'connection_reason': (str,),  # noqa: E501
            'connection_status': (str,),  # noqa: E501
            'connection_status_last_change_time': (datetime,),  # noqa: E501
            'connector_version': (str,),  # noqa: E501
            'device_external_ip_address': (str,),  # noqa: E501
            'proxy_app': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        val = {
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'access_key_id': 'AccessKeyId',  # noqa: E501
        'claimed_by_user_name': 'ClaimedByUserName',  # noqa: E501
        'claimed_time': 'ClaimedTime',  # noqa: E501
        'device_hostname': 'DeviceHostname',  # noqa: E501
        'device_ip_address': 'DeviceIpAddress',  # noqa: E501
        'execution_mode': 'ExecutionMode',  # noqa: E501
        'parent_signature': 'ParentSignature',  # noqa: E501
        'pid': 'Pid',  # noqa: E501
        'platform_type': 'PlatformType',  # noqa: E501
        'public_access_key': 'PublicAccessKey',  # noqa: E501
        'public_access_key_rotated': 'PublicAccessKeyRotated',  # noqa: E501
        'public_encryption_key': 'PublicEncryptionKey',  # noqa: E501
        'read_only': 'ReadOnly',  # noqa: E501
        'rotate_access_key': 'RotateAccessKey',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'vendor': 'Vendor',  # noqa: E501
        'account': 'Account',  # noqa: E501
        'claimed_by_user': 'ClaimedByUser',  # noqa: E501
        'cluster_members': 'ClusterMembers',  # noqa: E501
        'custom_permission_resources': 'CustomPermissionResources',  # noqa: E501
        'device_claim': 'DeviceClaim',  # noqa: E501
        'device_configuration': 'DeviceConfiguration',  # noqa: E501
        'domain_group': 'DomainGroup',  # noqa: E501
        'parent_connection': 'ParentConnection',  # noqa: E501
        'target': 'Target',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'api_version': 'ApiVersion',  # noqa: E501
        'app_partition_number': 'AppPartitionNumber',  # noqa: E501
        'connection_id': 'ConnectionId',  # noqa: E501
        'connection_reason': 'ConnectionReason',  # noqa: E501
        'connection_status': 'ConnectionStatus',  # noqa: E501
        'connection_status_last_change_time': 'ConnectionStatusLastChangeTime',  # noqa: E501
        'connector_version': 'ConnectorVersion',  # noqa: E501
        'device_external_ip_address': 'DeviceExternalIpAddress',  # noqa: E501
        'proxy_app': 'ProxyApp',  # noqa: E501
    }

    read_only_vars = {
        'claimed_by_user_name',  # noqa: E501
        'claimed_time',  # noqa: E501
        'public_access_key',  # noqa: E501
        'public_access_key_rotated',  # noqa: E501
        'public_encryption_key',  # noqa: E501
        'read_only',  # noqa: E501
        'vendor',  # noqa: E501
        'cluster_members',  # noqa: E501
        'custom_permission_resources',  # noqa: E501
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
        'api_version',  # noqa: E501
        'app_partition_number',  # noqa: E501
        'connection_id',  # noqa: E501
        'connection_reason',  # noqa: E501
        'connection_status',  # noqa: E501
        'connection_status_last_change_time',  # noqa: E501
        'connector_version',  # noqa: E501
        'device_external_ip_address',  # noqa: E501
        'proxy_app',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """AssetDeviceRegistration - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "asset.DeviceRegistration", must be one of ["asset.DeviceRegistration", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "asset.DeviceRegistration", must be one of ["asset.DeviceRegistration", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            access_key_id (str): An identifier for the credential used by the device connector to authenticate with the Intersight web socket gateway.. [optional]  # noqa: E501
            claimed_by_user_name (str): The name of the user who claimed the device for the account.. [optional]  # noqa: E501
            claimed_time (datetime): The date and time at which the device was claimed to this account.. [optional]  # noqa: E501
            device_hostname ([str], none_type): [optional]  # noqa: E501
            device_ip_address ([str], none_type): [optional]  # noqa: E501
            execution_mode (str): Indicates if the platform is an actual device or an emulated device for testing, demos, etc. Permitted values are [Normal, Emulator, ContainerEmulator]. * `` - The device reported an empty or unrecognized executionMode. * `Normal` - The device connector is running in normal mode, i.e. it is not a simulation. * `Emulator` - The device connector is running in simulation mode inside an emulated device. * `ContainerEmulator` - The device connector is running in simulation mode inside a containerized emulated device.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            parent_signature (AssetClaimSignature): [optional]  # noqa: E501
            pid ([str], none_type): [optional]  # noqa: E501
            platform_type (str): The platform type on which device connector is executing. * `` - An unrecognized platform type. * `APIC` - A Cisco Application Policy Infrastructure Controller (APIC) cluster. * `CAPIC` - A Cisco Cloud Application Policy Infrastructure Controller (Cloud APIC) instance. * `DCNM` - A Cisco Data Center Network Manager (DCNM) instance. * `UCSFI` - A Cisco UCS Fabric Interconnect that is managed by Cisco UCS Manager (UCSM). * `UCSFIISM` - A Cisco UCS Fabric Interconnect that is managed by Cisco Intersight. * `IMC` - A standalone Cisco UCS rack server (Deprecated). * `IMCM4` - A standalone Cisco UCS C-Series or S-Series M4 server. * `IMCM5` - A standalone Cisco UCS C-Series or S-Series M5 server. * `IMCRack` - A standalone Cisco UCS C-Series or S-Series M6 or newer server. * `UCSIOM` - A Cisco UCS Blade Chassis I/O Module (IOM). * `UCSPCIeNODE` - A Cisco UCS PCIe Node in a blade form factor. * `UCSXFM` - A Cisco UCS Fabric Extender Module (XFM). * `HX` - A Cisco HyperFlex (HX) cluster. * `UCSD` - A Cisco UCS Director (UCSD) instance. * `UCSXECMC` - A Cisco UCSXE Chassis Management Controller. * `IntersightAppliance` - A Cisco Intersight Connected Virtual Appliance instance. * `IntersightAssist` - A Cisco Intersight Assist instance. * `PureStorageFlashArray` - A Pure Storage FlashArray that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer and storage management features are supported on this device. * `NexusDevice` - A Cisco Nexus Network Switch that is managed using Cisco Intersight Assist. * `ACISwitch` - A Cisco Nexus Network Switch with the embedded Device Connector and is a part of the Cisco ACI fabric. * `NexusSwitch` - A standalone Cisco Nexus Network Switch with the embedded Device Connector. * `MDSSwitch` - A Cisco MDS Switch that is managed using the embedded Device Connector. * `MDSDevice` - A Cisco MDS Switch that is managed using Cisco Intersight Assist. * `UCSC885` - A standalone Cisco UCS C885 Server. * `CAI845A` - A standalone Cisco AI 845A Server. * `UCSC890` - A standalone Cisco UCS C890 server managed using Cisco Intersight Assist. * `RedfishServer` - A generic target type for servers that support Redfish APIs and is managed using Cisco Intersight Assist. Support is limited to HPE and Dell Servers. * `NetAppOntap` - A Netapp ONTAP Storage system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `NetAppActiveIqUnifiedManager` - A NetApp Active IQ Unified Manager (AIQUM) that is managed using Cisco Intersight Assist. * `EmcScaleIo` - An EMC ScaleIO Software Defined Storage system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `EmcVmax` - An EMC VMAX 2 or 3 series enterprise storage array that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `EmcVplex` - An EMC VPLEX virtual storage system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `EmcXtremIo` - An EMC XtremIO SSD storage system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `VmwareVcenter` - A VMware vCenter instance that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer and Virtualization features are supported on this hypervisor. * `MicrosoftHyperV` - A Microsoft Hyper-V host that is managed using Cisco Intersight Assist. Optionally, other hosts in the cluster can be discovered through this host. Cisco Intersight Workload Optimizer features are supported on this hypervisor. * `AppDynamics` - An AppDynamics controller running in a SaaS or on-prem datacenter. On-prem AppDynamics instance is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this controller. * `Dynatrace` - A Dynatrace Server instance running in a SaaS or on-prem datacenter. On-prem Dynatrace instance is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this server. * `NewRelic` - A NewRelic user account. The NewRelic instance monitors the application infrastructure. Cisco Intersight Workload Optimizer features are supported on this server. * `ServiceNow` - A cloud-based workflow automation platform that enables enterprise organizations to improve operational efficiencies by streamlining and automating routine work tasks. * `Umbrella` - Umbrella cloud target that discovers and monitors an organization. It discovers entities like Datacenters, Devices, Tunnels, Networks, etc. * `CloudFoundry` - An open source cloud platform on which developers can build, deploy, run and scale applications. * `MicrosoftAzureApplicationInsights` - A feature of Azure Monitor, is an extensible Application Performance Management service for developers and DevOps professionals to monitor their live applications. * `OpenStack` - An OpenStack target manages Virtual Machines, Physical Machines, Datacenters and Virtual Datacenters using different OpenStack services as administrative endpoints. * `MicrosoftSqlServer` - A Microsoft SQL database server that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this database. * `MySqlServer` - A MySQL database server that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this database. * `OracleDatabaseServer` - An Oracle database server that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this database. * `IBMWebSphereApplicationServer` - An IBM WebSphere Application server that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this application server. * `OracleWebLogicServer` - Oracle WebLogic Server is a unified and extensible platform for developing, deploying and running enterprise applications, such as Java, for on-premises and in the cloud. WebLogic Server offers a robust, mature, and scalable implementation of Java Enterprise Edition (EE) and Jakarta EE. * `ApacheTomcatServer` - An Apache Tomcat server that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this server. * `JavaVirtualMachine` - A JVM Application with JMX configured that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this application. * `RedHatJBossApplicationServer` - JBoss Application Server is an open-source, cross-platform Java application server developed by JBoss, a division of Red Hat Inc. It is an open-source implementation of Java 2 Enterprise Edition (J2EE) that is used for implementing Java applications and other Web-based applications and software. * `Kubernetes` - A Kubernetes cluster that runs containerized applications, with Kubernetes Collector installed. Cisco Intersight Workload Optimizer features are supported on Kubernetes cluster. * `AmazonWebService` - An Amazon Web Service cloud account. Cisco Intersight Workload Optimizer and Virtualization features are supported on this cloud. * `AmazonWebServiceBilling` - An Amazon Web Service cloud billing account used to retrieve billing information stored in S3 bucket. Cisco Intersight Workload Optimizer features are supported on this cloud. * `GoogleCloudPlatform` - A Google Cloud Platform service account with access to one or more projects. Cisco Intersight Workload Optimizer features are supported on this cloud. * `GoogleCloudPlatformBilling` - A Google Cloud Platform service account used to retrieve billing information from BigQuery. Cisco Intersight Workload Optimizer features are supported on this cloud. * `MicrosoftAzureServicePrincipal` - A Microsoft Azure Service Principal account with access to Azure subscriptions. Cisco Intersight Workload Optimizer features are supported on this cloud. * `MicrosoftAzureEnterpriseAgreement` - A Microsoft Azure Enterprise Agreement enrolment used to retrieve pricing and billing information. Cisco Intersight Workload Optimizer features are supported on this cloud. * `MicrosoftAzureBilling` - A Microsoft Azure Service Principal account with access to billing information. Cisco Intersight Workload Optimizer features are supported on this cloud. * `DellCompellent` - A Dell EMC SC Series (Compellent) storage system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `HPE3Par` - A HPE 3PAR StoreServ system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `RedHatEnterpriseVirtualization` - A Red Hat Enterprise Virtualization Hypervisor system that manages Virtual Machines. * `NutanixAcropolis` - A Nutanix Acropolis cluster that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this cluster. * `NutanixPrismCentral` - A Nutanix Prism Central cluster. Prism central is a virtual appliance for managing Nutanix clusters and services. * `HPEOneView` - A HPE OneView system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this system. * `ServiceEngine` - Cisco Application Services Engine. Cisco Application Services Engine is a platform to deploy and manage applications. * `HitachiVirtualStoragePlatform` - A Hitachi Virtual Storage Platform (Hitachi VSP) that is managed using Cisco Intersight Assist. * `GenericTarget` - A generic third-party target supported only in Partner Integration Appliance. This target type is used for development purposes and will not be supported in production environment. * `IMCBlade` - A Cisco UCS blade server managed by Cisco Intersight. * `TerraformCloud` - A Terraform Cloud Business Tier account. * `TerraformAgent` - A Terraform Cloud Agent that will be deployed on Cisco Intersight Assist. The agent can be used to plan and apply Terraform runs from a Terraform Cloud workspace. * `CustomTarget` - CustomTarget is deprecated. Use HTTPEndpoint type to claim HTTP endpoints. * `AnsibleEndpoint` - An external endpoint that is added as a target which can be accessed through Ansible in Intersight Cloud Orchestrator automation workflows. * `HTTPEndpoint` - An HTTP endpoint that can be accessed in Intersight Orchestrator workflows directly or using Cisco Intersight Assist. Authentication Schemes supported are Basic and Bearer Token. * `SSHEndpoint` - An SSH endpoint that can be accessed in Intersight Orchestrator workflows using Cisco Intersight Assist. * `CiscoCatalyst` - A Cisco Catalyst networking switch device. * `PowerShellEndpoint` - A Windows operating system server on which PowerShell scripts can be executed using Cisco Intersight Assist. * `CiscoDNAC` - A Cisco Digital Network Architecture (DNA) Center appliance. * `CiscoFMC` - A Cisco Secure Firewall Management Center. * `ViptelaCloud` - A Cisco Viptela SD-WAN Cloud. * `MerakiCloud` - A Cisco Meraki Organization. * `CiscoISE` - A Cisco Identity Services Engine (ISE) target.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            public_access_key (str): The device connector's public key used by Intersight to authenticate a connection from the device connector. The public key is used to verify that the signature a device connector sends on connect has been signed by the connector's private key stored on the device's filesystem. Must be a PEM encoded RSA or Ed22519 public key string.. [optional]  # noqa: E501
            public_access_key_rotated (str): The device connectors rotated public key. The device connector may rotate its key pair in conditions where it has been determined the key may have been compromised or if the key type is changing (e.g. moving from RSA to elliptical curve). The device connector will rotate its key in a two step process in order to ensure Intersight has received and committed the new key before invalidating the previous. Device connectors will first send the new public key on PublicAccessKeyRotated, the public key string will also be signed by the current private key. On receipt of a 200 response from Intersight the device connector commits the new key to its local database and will use it for all future authentication requests. Intersight will then allow both the previous and rotated key periods until the device connects with the rotated key, at which point the previous key is invalidated and removed.. [optional]  # noqa: E501
            public_encryption_key (str): The device connector public key used by Intersight for encryption. The public key is used to encrypt ephemeral aes keys to be used for decrypting sensitive data from Intersight. Must be a PEM encoded RSA public key string.. [optional]  # noqa: E501
            read_only (bool): Flag reported by devices to indicate an administrator of the device has disabled management operations of the device connector and only monitoring is permitted.. [optional]  # noqa: E501
            rotate_access_key (bool): Request the device to rotate its key pair. SRE team may set this field to trigger the device to rotate its key pair in conditions where it has been identified that the device's key has been compromised. When RotateAccessKey is set to true the device will be forced to re-connect and rotate its key.. [optional]  # noqa: E501
            serial ([str], none_type): [optional]  # noqa: E501
            vendor (str): The vendor of the managed device.. [optional]  # noqa: E501
            account (IamAccountRelationship): [optional]  # noqa: E501
            claimed_by_user (IamUserRelationship): [optional]  # noqa: E501
            cluster_members ([AssetClusterMemberRelationship], none_type): An array of relationships to assetClusterMember resources.. [optional]  # noqa: E501
            custom_permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            device_claim (AssetDeviceClaimRelationship): [optional]  # noqa: E501
            device_configuration (AssetDeviceConfigurationRelationship): [optional]  # noqa: E501
            domain_group (IamDomainGroupRelationship): [optional]  # noqa: E501
            parent_connection (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            target (AssetTargetRelationship): [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            api_version (int): The version of the connector API, describes the capability of the connector's framework. If the version is lower than the current minimum supported version defined in the service managing the connection, the device connector will be connected with limited capabilities until the device connector is upgraded to a fully supported version. For example if a device connector that was released without delta inventory capabilities registers and connects to Intersight, inventory collection may be disabled until it has been upgraded.. [optional]  # noqa: E501
            app_partition_number (int): The partition number corresponding to the instance of the Proxy App which is managing the web-socket to the device connector.. [optional]  # noqa: E501
            connection_id (str): The unique identifier for the current connection. The identifier persists across network connectivity loss and is reset on device connector process restart or platform administrator toggle of the Intersight connectivity. The connectionId can be used by services that need to interact with stateful plugins running in the device connector process. For example if a service schedules an inventory in a devices job scheduler plugin at registration it is not necessary to reschedule the job if the device loses network connectivity due to an Intersight service upgrade or intermittent network issues in the devices datacenter.. [optional]  # noqa: E501
            connection_reason (str): If 'connectionStatus' is not equal to Connected, connectionReason provides further details about why the device is not connected with Intersight.. [optional]  # noqa: E501
            connection_status (str): The status of the persistent connection between the device connector and Intersight. * `` - The target details have been persisted but Intersight has not yet attempted to connect to the target. * `Connected` - Intersight is able to establish a connection to the target and initiate management activities. * `NotConnected` - Intersight is unable to establish a connection to the target. * `ClaimInProgress` - Claim of the target is in progress. A connection to the target has not been fully established. * `UnclaimInProgress` - Unclaim of the target is in progress. Intersight is able to connect to the target and all management operations are supported. * `Unclaimed` - The device was un-claimed from the users account by an Administrator of the device. Also indicates the failure to claim Targets of type HTTP Endpoint in Intersight. * `Claimed` - Target of type HTTP Endpoint is successfully claimed in Intersight. Currently no validation is performed to verify the Target connectivity from Intersight at the time of creation. However invoking API from Intersight Orchestrator fails if this Target is not reachable from Intersight or if Target API credentials are incorrect.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            connection_status_last_change_time (datetime): The last time at which the 'connectionStatus' property value changed. If connectionStatus is Connected, this time can be interpreted as the starting time since which a persistent connection has been maintained between Intersight and Device Connector. If connectionStatus is NotConnected, this time can be interpreted as the last time the device connector was connected with Intersight.. [optional]  # noqa: E501
            connector_version (str): The version of the device connector running on the managed device.. [optional]  # noqa: E501
            device_external_ip_address (str): The IP Address of the managed device as seen from Intersight at the time of registration. This could be the IP address of the managed device's interface which has a route to the internet or a NAT IP address when the managed device is deployed in a private network.. [optional]  # noqa: E501
            proxy_app (str): The name of the app which will proxy the messages to the device connector.. [optional]  # noqa: E501
        """

        class_id = "asset.DeviceRegistration" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "asset.DeviceRegistration")
        object_type = "asset.DeviceRegistration" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "asset.DeviceRegistration")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """AssetDeviceRegistration - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "asset.DeviceRegistration", must be one of ["asset.DeviceRegistration", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "asset.DeviceRegistration", must be one of ["asset.DeviceRegistration", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            access_key_id (str): An identifier for the credential used by the device connector to authenticate with the Intersight web socket gateway.. [optional]  # noqa: E501
            claimed_by_user_name (str): The name of the user who claimed the device for the account.. [optional]  # noqa: E501
            claimed_time (datetime): The date and time at which the device was claimed to this account.. [optional]  # noqa: E501
            device_hostname ([str], none_type): [optional]  # noqa: E501
            device_ip_address ([str], none_type): [optional]  # noqa: E501
            execution_mode (str): Indicates if the platform is an actual device or an emulated device for testing, demos, etc. Permitted values are [Normal, Emulator, ContainerEmulator]. * `` - The device reported an empty or unrecognized executionMode. * `Normal` - The device connector is running in normal mode, i.e. it is not a simulation. * `Emulator` - The device connector is running in simulation mode inside an emulated device. * `ContainerEmulator` - The device connector is running in simulation mode inside a containerized emulated device.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            parent_signature (AssetClaimSignature): [optional]  # noqa: E501
            pid ([str], none_type): [optional]  # noqa: E501
            platform_type (str): The platform type on which device connector is executing. * `` - An unrecognized platform type. * `APIC` - A Cisco Application Policy Infrastructure Controller (APIC) cluster. * `CAPIC` - A Cisco Cloud Application Policy Infrastructure Controller (Cloud APIC) instance. * `DCNM` - A Cisco Data Center Network Manager (DCNM) instance. * `UCSFI` - A Cisco UCS Fabric Interconnect that is managed by Cisco UCS Manager (UCSM). * `UCSFIISM` - A Cisco UCS Fabric Interconnect that is managed by Cisco Intersight. * `IMC` - A standalone Cisco UCS rack server (Deprecated). * `IMCM4` - A standalone Cisco UCS C-Series or S-Series M4 server. * `IMCM5` - A standalone Cisco UCS C-Series or S-Series M5 server. * `IMCRack` - A standalone Cisco UCS C-Series or S-Series M6 or newer server. * `UCSIOM` - A Cisco UCS Blade Chassis I/O Module (IOM). * `UCSPCIeNODE` - A Cisco UCS PCIe Node in a blade form factor. * `UCSXFM` - A Cisco UCS Fabric Extender Module (XFM). * `HX` - A Cisco HyperFlex (HX) cluster. * `UCSD` - A Cisco UCS Director (UCSD) instance. * `UCSXECMC` - A Cisco UCSXE Chassis Management Controller. * `IntersightAppliance` - A Cisco Intersight Connected Virtual Appliance instance. * `IntersightAssist` - A Cisco Intersight Assist instance. * `PureStorageFlashArray` - A Pure Storage FlashArray that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer and storage management features are supported on this device. * `NexusDevice` - A Cisco Nexus Network Switch that is managed using Cisco Intersight Assist. * `ACISwitch` - A Cisco Nexus Network Switch with the embedded Device Connector and is a part of the Cisco ACI fabric. * `NexusSwitch` - A standalone Cisco Nexus Network Switch with the embedded Device Connector. * `MDSSwitch` - A Cisco MDS Switch that is managed using the embedded Device Connector. * `MDSDevice` - A Cisco MDS Switch that is managed using Cisco Intersight Assist. * `UCSC885` - A standalone Cisco UCS C885 Server. * `CAI845A` - A standalone Cisco AI 845A Server. * `UCSC890` - A standalone Cisco UCS C890 server managed using Cisco Intersight Assist. * `RedfishServer` - A generic target type for servers that support Redfish APIs and is managed using Cisco Intersight Assist. Support is limited to HPE and Dell Servers. * `NetAppOntap` - A Netapp ONTAP Storage system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `NetAppActiveIqUnifiedManager` - A NetApp Active IQ Unified Manager (AIQUM) that is managed using Cisco Intersight Assist. * `EmcScaleIo` - An EMC ScaleIO Software Defined Storage system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `EmcVmax` - An EMC VMAX 2 or 3 series enterprise storage array that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `EmcVplex` - An EMC VPLEX virtual storage system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `EmcXtremIo` - An EMC XtremIO SSD storage system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `VmwareVcenter` - A VMware vCenter instance that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer and Virtualization features are supported on this hypervisor. * `MicrosoftHyperV` - A Microsoft Hyper-V host that is managed using Cisco Intersight Assist. Optionally, other hosts in the cluster can be discovered through this host. Cisco Intersight Workload Optimizer features are supported on this hypervisor. * `AppDynamics` - An AppDynamics controller running in a SaaS or on-prem datacenter. On-prem AppDynamics instance is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this controller. * `Dynatrace` - A Dynatrace Server instance running in a SaaS or on-prem datacenter. On-prem Dynatrace instance is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this server. * `NewRelic` - A NewRelic user account. The NewRelic instance monitors the application infrastructure. Cisco Intersight Workload Optimizer features are supported on this server. * `ServiceNow` - A cloud-based workflow automation platform that enables enterprise organizations to improve operational efficiencies by streamlining and automating routine work tasks. * `Umbrella` - Umbrella cloud target that discovers and monitors an organization. It discovers entities like Datacenters, Devices, Tunnels, Networks, etc. * `CloudFoundry` - An open source cloud platform on which developers can build, deploy, run and scale applications. * `MicrosoftAzureApplicationInsights` - A feature of Azure Monitor, is an extensible Application Performance Management service for developers and DevOps professionals to monitor their live applications. * `OpenStack` - An OpenStack target manages Virtual Machines, Physical Machines, Datacenters and Virtual Datacenters using different OpenStack services as administrative endpoints. * `MicrosoftSqlServer` - A Microsoft SQL database server that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this database. * `MySqlServer` - A MySQL database server that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this database. * `OracleDatabaseServer` - An Oracle database server that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this database. * `IBMWebSphereApplicationServer` - An IBM WebSphere Application server that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this application server. * `OracleWebLogicServer` - Oracle WebLogic Server is a unified and extensible platform for developing, deploying and running enterprise applications, such as Java, for on-premises and in the cloud. WebLogic Server offers a robust, mature, and scalable implementation of Java Enterprise Edition (EE) and Jakarta EE. * `ApacheTomcatServer` - An Apache Tomcat server that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this server. * `JavaVirtualMachine` - A JVM Application with JMX configured that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this application. * `RedHatJBossApplicationServer` - JBoss Application Server is an open-source, cross-platform Java application server developed by JBoss, a division of Red Hat Inc. It is an open-source implementation of Java 2 Enterprise Edition (J2EE) that is used for implementing Java applications and other Web-based applications and software. * `Kubernetes` - A Kubernetes cluster that runs containerized applications, with Kubernetes Collector installed. Cisco Intersight Workload Optimizer features are supported on Kubernetes cluster. * `AmazonWebService` - An Amazon Web Service cloud account. Cisco Intersight Workload Optimizer and Virtualization features are supported on this cloud. * `AmazonWebServiceBilling` - An Amazon Web Service cloud billing account used to retrieve billing information stored in S3 bucket. Cisco Intersight Workload Optimizer features are supported on this cloud. * `GoogleCloudPlatform` - A Google Cloud Platform service account with access to one or more projects. Cisco Intersight Workload Optimizer features are supported on this cloud. * `GoogleCloudPlatformBilling` - A Google Cloud Platform service account used to retrieve billing information from BigQuery. Cisco Intersight Workload Optimizer features are supported on this cloud. * `MicrosoftAzureServicePrincipal` - A Microsoft Azure Service Principal account with access to Azure subscriptions. Cisco Intersight Workload Optimizer features are supported on this cloud. * `MicrosoftAzureEnterpriseAgreement` - A Microsoft Azure Enterprise Agreement enrolment used to retrieve pricing and billing information. Cisco Intersight Workload Optimizer features are supported on this cloud. * `MicrosoftAzureBilling` - A Microsoft Azure Service Principal account with access to billing information. Cisco Intersight Workload Optimizer features are supported on this cloud. * `DellCompellent` - A Dell EMC SC Series (Compellent) storage system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `HPE3Par` - A HPE 3PAR StoreServ system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this device. * `RedHatEnterpriseVirtualization` - A Red Hat Enterprise Virtualization Hypervisor system that manages Virtual Machines. * `NutanixAcropolis` - A Nutanix Acropolis cluster that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this cluster. * `NutanixPrismCentral` - A Nutanix Prism Central cluster. Prism central is a virtual appliance for managing Nutanix clusters and services. * `HPEOneView` - A HPE OneView system that is managed using Cisco Intersight Assist. Cisco Intersight Workload Optimizer features are supported on this system. * `ServiceEngine` - Cisco Application Services Engine. Cisco Application Services Engine is a platform to deploy and manage applications. * `HitachiVirtualStoragePlatform` - A Hitachi Virtual Storage Platform (Hitachi VSP) that is managed using Cisco Intersight Assist. * `GenericTarget` - A generic third-party target supported only in Partner Integration Appliance. This target type is used for development purposes and will not be supported in production environment. * `IMCBlade` - A Cisco UCS blade server managed by Cisco Intersight. * `TerraformCloud` - A Terraform Cloud Business Tier account. * `TerraformAgent` - A Terraform Cloud Agent that will be deployed on Cisco Intersight Assist. The agent can be used to plan and apply Terraform runs from a Terraform Cloud workspace. * `CustomTarget` - CustomTarget is deprecated. Use HTTPEndpoint type to claim HTTP endpoints. * `AnsibleEndpoint` - An external endpoint that is added as a target which can be accessed through Ansible in Intersight Cloud Orchestrator automation workflows. * `HTTPEndpoint` - An HTTP endpoint that can be accessed in Intersight Orchestrator workflows directly or using Cisco Intersight Assist. Authentication Schemes supported are Basic and Bearer Token. * `SSHEndpoint` - An SSH endpoint that can be accessed in Intersight Orchestrator workflows using Cisco Intersight Assist. * `CiscoCatalyst` - A Cisco Catalyst networking switch device. * `PowerShellEndpoint` - A Windows operating system server on which PowerShell scripts can be executed using Cisco Intersight Assist. * `CiscoDNAC` - A Cisco Digital Network Architecture (DNA) Center appliance. * `CiscoFMC` - A Cisco Secure Firewall Management Center. * `ViptelaCloud` - A Cisco Viptela SD-WAN Cloud. * `MerakiCloud` - A Cisco Meraki Organization. * `CiscoISE` - A Cisco Identity Services Engine (ISE) target.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            public_access_key (str): The device connector's public key used by Intersight to authenticate a connection from the device connector. The public key is used to verify that the signature a device connector sends on connect has been signed by the connector's private key stored on the device's filesystem. Must be a PEM encoded RSA or Ed22519 public key string.. [optional]  # noqa: E501
            public_access_key_rotated (str): The device connectors rotated public key. The device connector may rotate its key pair in conditions where it has been determined the key may have been compromised or if the key type is changing (e.g. moving from RSA to elliptical curve). The device connector will rotate its key in a two step process in order to ensure Intersight has received and committed the new key before invalidating the previous. Device connectors will first send the new public key on PublicAccessKeyRotated, the public key string will also be signed by the current private key. On receipt of a 200 response from Intersight the device connector commits the new key to its local database and will use it for all future authentication requests. Intersight will then allow both the previous and rotated key periods until the device connects with the rotated key, at which point the previous key is invalidated and removed.. [optional]  # noqa: E501
            public_encryption_key (str): The device connector public key used by Intersight for encryption. The public key is used to encrypt ephemeral aes keys to be used for decrypting sensitive data from Intersight. Must be a PEM encoded RSA public key string.. [optional]  # noqa: E501
            read_only (bool): Flag reported by devices to indicate an administrator of the device has disabled management operations of the device connector and only monitoring is permitted.. [optional]  # noqa: E501
            rotate_access_key (bool): Request the device to rotate its key pair. SRE team may set this field to trigger the device to rotate its key pair in conditions where it has been identified that the device's key has been compromised. When RotateAccessKey is set to true the device will be forced to re-connect and rotate its key.. [optional]  # noqa: E501
            serial ([str], none_type): [optional]  # noqa: E501
            vendor (str): The vendor of the managed device.. [optional]  # noqa: E501
            account (IamAccountRelationship): [optional]  # noqa: E501
            claimed_by_user (IamUserRelationship): [optional]  # noqa: E501
            cluster_members ([AssetClusterMemberRelationship], none_type): An array of relationships to assetClusterMember resources.. [optional]  # noqa: E501
            custom_permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            device_claim (AssetDeviceClaimRelationship): [optional]  # noqa: E501
            device_configuration (AssetDeviceConfigurationRelationship): [optional]  # noqa: E501
            domain_group (IamDomainGroupRelationship): [optional]  # noqa: E501
            parent_connection (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            target (AssetTargetRelationship): [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            api_version (int): The version of the connector API, describes the capability of the connector's framework. If the version is lower than the current minimum supported version defined in the service managing the connection, the device connector will be connected with limited capabilities until the device connector is upgraded to a fully supported version. For example if a device connector that was released without delta inventory capabilities registers and connects to Intersight, inventory collection may be disabled until it has been upgraded.. [optional]  # noqa: E501
            app_partition_number (int): The partition number corresponding to the instance of the Proxy App which is managing the web-socket to the device connector.. [optional]  # noqa: E501
            connection_id (str): The unique identifier for the current connection. The identifier persists across network connectivity loss and is reset on device connector process restart or platform administrator toggle of the Intersight connectivity. The connectionId can be used by services that need to interact with stateful plugins running in the device connector process. For example if a service schedules an inventory in a devices job scheduler plugin at registration it is not necessary to reschedule the job if the device loses network connectivity due to an Intersight service upgrade or intermittent network issues in the devices datacenter.. [optional]  # noqa: E501
            connection_reason (str): If 'connectionStatus' is not equal to Connected, connectionReason provides further details about why the device is not connected with Intersight.. [optional]  # noqa: E501
            connection_status (str): The status of the persistent connection between the device connector and Intersight. * `` - The target details have been persisted but Intersight has not yet attempted to connect to the target. * `Connected` - Intersight is able to establish a connection to the target and initiate management activities. * `NotConnected` - Intersight is unable to establish a connection to the target. * `ClaimInProgress` - Claim of the target is in progress. A connection to the target has not been fully established. * `UnclaimInProgress` - Unclaim of the target is in progress. Intersight is able to connect to the target and all management operations are supported. * `Unclaimed` - The device was un-claimed from the users account by an Administrator of the device. Also indicates the failure to claim Targets of type HTTP Endpoint in Intersight. * `Claimed` - Target of type HTTP Endpoint is successfully claimed in Intersight. Currently no validation is performed to verify the Target connectivity from Intersight at the time of creation. However invoking API from Intersight Orchestrator fails if this Target is not reachable from Intersight or if Target API credentials are incorrect.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            connection_status_last_change_time (datetime): The last time at which the 'connectionStatus' property value changed. If connectionStatus is Connected, this time can be interpreted as the starting time since which a persistent connection has been maintained between Intersight and Device Connector. If connectionStatus is NotConnected, this time can be interpreted as the last time the device connector was connected with Intersight.. [optional]  # noqa: E501
            connector_version (str): The version of the device connector running on the managed device.. [optional]  # noqa: E501
            device_external_ip_address (str): The IP Address of the managed device as seen from Intersight at the time of registration. This could be the IP address of the managed device's interface which has a route to the internet or a NAT IP address when the managed device is deployed in a private network.. [optional]  # noqa: E501
            proxy_app (str): The name of the app which will proxy the messages to the device connector.. [optional]  # noqa: E501
        """

        class_id = "asset.DeviceRegistration" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "asset.DeviceRegistration")
        object_type = "asset.DeviceRegistration" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "asset.DeviceRegistration")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              AssetDeviceConnection,
              AssetDeviceRegistrationAllOf,
          ],
          'oneOf': [
          ],
        }
