"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.comm_physical_address_all_of import CommPhysicalAddressAllOf
    from intersight.model.mo_base_complex_type import MoBaseComplexType
    globals()['CommPhysicalAddressAllOf'] = CommPhysicalAddressAllOf
    globals()['MoBaseComplexType'] = MoBaseComplexType


class CommPhysicalAddress(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'COMM.PHYSICALADDRESS': "comm.PhysicalAddress",
        },
        ('object_type',): {
            'COMM.PHYSICALADDRESS': "comm.PhysicalAddress",
        },
        ('country',): {
            'UNKNOWN': "Unknown",
            'AD': "AD",
            'AE': "AE",
            'AF': "AF",
            'AG': "AG",
            'AI': "AI",
            'AL': "AL",
            'AM': "AM",
            'AO': "AO",
            'AQ': "AQ",
            'AR': "AR",
            'AS': "AS",
            'AT': "AT",
            'AU': "AU",
            'AW': "AW",
            'AX': "AX",
            'AZ': "AZ",
            'BA': "BA",
            'BB': "BB",
            'BD': "BD",
            'BE': "BE",
            'BF': "BF",
            'BG': "BG",
            'BH': "BH",
            'BI': "BI",
            'BJ': "BJ",
            'BL': "BL",
            'BM': "BM",
            'BN': "BN",
            'BO': "BO",
            'BQ': "BQ",
            'BR': "BR",
            'BS': "BS",
            'BT': "BT",
            'BV': "BV",
            'BW': "BW",
            'BY': "BY",
            'BZ': "BZ",
            'CA': "CA",
            'CC': "CC",
            'CD': "CD",
            'CF': "CF",
            'CG': "CG",
            'CH': "CH",
            'CI': "CI",
            'CK': "CK",
            'CL': "CL",
            'CM': "CM",
            'CN': "CN",
            'CO': "CO",
            'CR': "CR",
            'CU': "CU",
            'CV': "CV",
            'CW': "CW",
            'CX': "CX",
            'CY': "CY",
            'CZ': "CZ",
            'DE': "DE",
            'DJ': "DJ",
            'DK': "DK",
            'DM': "DM",
            'DO': "DO",
            'DZ': "DZ",
            'EC': "EC",
            'EE': "EE",
            'EG': "EG",
            'EH': "EH",
            'ER': "ER",
            'ES': "ES",
            'ET': "ET",
            'FI': "FI",
            'FJ': "FJ",
            'FK': "FK",
            'FM': "FM",
            'FO': "FO",
            'FR': "FR",
            'GA': "GA",
            'GB': "GB",
            'GD': "GD",
            'GE': "GE",
            'GF': "GF",
            'GG': "GG",
            'GH': "GH",
            'GI': "GI",
            'GL': "GL",
            'GM': "GM",
            'GN': "GN",
            'GP': "GP",
            'GQ': "GQ",
            'GR': "GR",
            'GS': "GS",
            'GT': "GT",
            'GU': "GU",
            'GW': "GW",
            'GY': "GY",
            'HK': "HK",
            'HM': "HM",
            'HN': "HN",
            'HR': "HR",
            'HT': "HT",
            'HU': "HU",
            'ID': "ID",
            'IE': "IE",
            'IL': "IL",
            'IM': "IM",
            'IN': "IN",
            'IO': "IO",
            'IQ': "IQ",
            'IR': "IR",
            'IS': "IS",
            'IT': "IT",
            'JE': "JE",
            'JM': "JM",
            'JO': "JO",
            'JP': "JP",
            'KE': "KE",
            'KG': "KG",
            'KH': "KH",
            'KI': "KI",
            'KM': "KM",
            'KN': "KN",
            'KP': "KP",
            'KR': "KR",
            'KW': "KW",
            'KY': "KY",
            'KZ': "KZ",
            'LA': "LA",
            'LB': "LB",
            'LC': "LC",
            'LI': "LI",
            'LK': "LK",
            'LR': "LR",
            'LS': "LS",
            'LT': "LT",
            'LU': "LU",
            'LV': "LV",
            'LY': "LY",
            'MA': "MA",
            'MC': "MC",
            'MD': "MD",
            'ME': "ME",
            'MF': "MF",
            'MG': "MG",
            'MH': "MH",
            'MK': "MK",
            'ML': "ML",
            'MM': "MM",
            'MN': "MN",
            'MO': "MO",
            'MP': "MP",
            'MQ': "MQ",
            'MR': "MR",
            'MS': "MS",
            'MT': "MT",
            'MU': "MU",
            'MV': "MV",
            'MW': "MW",
            'MX': "MX",
            'MY': "MY",
            'MZ': "MZ",
            'NA': "NA",
            'NC': "NC",
            'NE': "NE",
            'NF': "NF",
            'NG': "NG",
            'NI': "NI",
            'NL': "NL",
            'NO': "NO",
            'NP': "NP",
            'NR': "NR",
            'NU': "NU",
            'NZ': "NZ",
            'OM': "OM",
            'PA': "PA",
            'PE': "PE",
            'PF': "PF",
            'PG': "PG",
            'PH': "PH",
            'PK': "PK",
            'PL': "PL",
            'PM': "PM",
            'PN': "PN",
            'PR': "PR",
            'PS': "PS",
            'PT': "PT",
            'PW': "PW",
            'PY': "PY",
            'QA': "QA",
            'RE': "RE",
            'RO': "RO",
            'RS': "RS",
            'RU': "RU",
            'RW': "RW",
            'SA': "SA",
            'SB': "SB",
            'SC': "SC",
            'SD': "SD",
            'SE': "SE",
            'SG': "SG",
            'SH': "SH",
            'SI': "SI",
            'SJ': "SJ",
            'SK': "SK",
            'SL': "SL",
            'SM': "SM",
            'SN': "SN",
            'SO': "SO",
            'SR': "SR",
            'SS': "SS",
            'ST': "ST",
            'SV': "SV",
            'SX': "SX",
            'SY': "SY",
            'SZ': "SZ",
            'TC': "TC",
            'TD': "TD",
            'TF': "TF",
            'TG': "TG",
            'TH': "TH",
            'TJ': "TJ",
            'TK': "TK",
            'TL': "TL",
            'TM': "TM",
            'TN': "TN",
            'TO': "TO",
            'TR': "TR",
            'TT': "TT",
            'TV': "TV",
            'TW': "TW",
            'TZ': "TZ",
            'UA': "UA",
            'UG': "UG",
            'UM': "UM",
            'US': "US",
            'UY': "UY",
            'UZ': "UZ",
            'VA': "VA",
            'VC': "VC",
            'VE': "VE",
            'VG': "VG",
            'VI': "VI",
            'VN': "VN",
            'VU': "VU",
            'WF': "WF",
            'WS': "WS",
            'YE': "YE",
            'YT': "YT",
            'ZA': "ZA",
            'ZM': "ZM",
            'ZW': "ZW",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = True

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'address1': (str,),  # noqa: E501
            'address2': (str,),  # noqa: E501
            'city': (str,),  # noqa: E501
            'country': (str,),  # noqa: E501
            'postal_code': (str,),  # noqa: E501
            'state_province': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        val = {
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'address1': 'Address1',  # noqa: E501
        'address2': 'Address2',  # noqa: E501
        'city': 'City',  # noqa: E501
        'country': 'Country',  # noqa: E501
        'postal_code': 'PostalCode',  # noqa: E501
        'state_province': 'StateProvince',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """CommPhysicalAddress - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "comm.PhysicalAddress", must be one of ["comm.PhysicalAddress", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "comm.PhysicalAddress", must be one of ["comm.PhysicalAddress", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            address1 (str): The primary street address.. [optional]  # noqa: E501
            address2 (str): Additional address information, such as suite number or floor.. [optional]  # noqa: E501
            city (str): The city where the address is located.. [optional]  # noqa: E501
            country (str): The country code in ISO 3166-1 alpha-2 format. * `Unknown` - The value Unknown is used when the country code is not known or applicable. * `AD` - The country code for Andorra. * `AE` - The country code for United Arab Emirates. * `AF` - The country code for Afghanistan. * `AG` - The country code for Antigua and Barbuda. * `AI` - The country code for Anguilla. * `AL` - The country code for Albania. * `AM` - The country code for Armenia. * `AO` - The country code for Angola. * `AQ` - The country code for Antarctica. * `AR` - The country code for Argentina. * `AS` - The country code for American Samoa. * `AT` - The country code for Austria. * `AU` - The country code for Australia. * `AW` - The country code for Aruba. * `AX` - The country code for Åland Islands. * `AZ` - The country code for Azerbaijan. * `BA` - The country code for Bosnia and Herzegovina. * `BB` - The country code for Barbados. * `BD` - The country code for Bangladesh. * `BE` - The country code for Belgium. * `BF` - The country code for Burkina Faso. * `BG` - The country code for Bulgaria. * `BH` - The country code for Bahrain. * `BI` - The country code for Burundi. * `BJ` - The country code for Benin. * `BL` - The country code for Saint Barthélemy. * `BM` - The country code for Bermuda. * `BN` - The country code for Brunei Darussalam. * `BO` - The country code for Plurinational State of Bolivia. * `BQ` - The country code for Sint Eustatius and Saba Bonaire. * `BR` - The country code for Brazil. * `BS` - The country code for Bahamas. * `BT` - The country code for Bhutan. * `BV` - The country code for Bouvet Island. * `BW` - The country code for Botswana. * `BY` - The country code for Belarus. * `BZ` - The country code for Belize. * `CA` - The country code for Canada. * `CC` - The country code for Cocos (Keeling) Islands. * `CD` - The country code for Democratic Republic of the Congo. * `CF` - The country code for Central African Republic. * `CG` - The country code for Congo. * `CH` - The country code for Switzerland. * `CI` - The country code for Côte d'Ivoire. * `CK` - The country code for Cook Islands. * `CL` - The country code for Chile. * `CM` - The country code for Cameroon. * `CN` - The country code for China. * `CO` - The country code for Colombia. * `CR` - The country code for Costa Rica. * `CU` - The country code for Cuba. * `CV` - The country code for Cabo Verde. * `CW` - The country code for Curaçao. * `CX` - The country code for Christmas Island. * `CY` - The country code for Cyprus. * `CZ` - The country code for Czechia. * `DE` - The country code for Germany. * `DJ` - The country code for Djibouti. * `DK` - The country code for Denmark. * `DM` - The country code for Dominica. * `DO` - The country code for Dominican Republic. * `DZ` - The country code for Algeria. * `EC` - The country code for Ecuador. * `EE` - The country code for Estonia. * `EG` - The country code for Egypt. * `EH` - The country code for Western Sahara. * `ER` - The country code for Eritrea. * `ES` - The country code for Spain. * `ET` - The country code for Ethiopia. * `FI` - The country code for Finland. * `FJ` - The country code for Fiji. * `FK` - The country code for Falkland Islands (Malvinas). * `FM` - The country code for Federated States of Micronesia. * `FO` - The country code for Faroe Islands. * `FR` - The country code for France. * `GA` - The country code for Gabon. * `GB` - The country code for United Kingdom of Great Britain and Northern Ireland. * `GD` - The country code for Grenada. * `GE` - The country code for Georgia. * `GF` - The country code for French Guiana. * `GG` - The country code for Guernsey. * `GH` - The country code for Ghana. * `GI` - The country code for Gibraltar. * `GL` - The country code for Greenland. * `GM` - The country code for Gambia. * `GN` - The country code for Guinea. * `GP` - The country code for Guadeloupe. * `GQ` - The country code for Equatorial Guinea. * `GR` - The country code for Greece. * `GS` - The country code for South Georgia and the South Sandwich Islands. * `GT` - The country code for Guatemala. * `GU` - The country code for Guam. * `GW` - The country code for Guinea-Bissau. * `GY` - The country code for Guyana. * `HK` - The country code for Hong Kong. * `HM` - The country code for Heard Island and McDonald Islands. * `HN` - The country code for Honduras. * `HR` - The country code for Croatia. * `HT` - The country code for Haiti. * `HU` - The country code for Hungary. * `ID` - The country code for Indonesia. * `IE` - The country code for Ireland. * `IL` - The country code for Israel. * `IM` - The country code for Isle of Man. * `IN` - The country code for India. * `IO` - The country code for British Indian Ocean Territory. * `IQ` - The country code for Iraq. * `IR` - The country code for Islamic Republic of Iran. * `IS` - The country code for Iceland. * `IT` - The country code for Italy. * `JE` - The country code for Jersey. * `JM` - The country code for Jamaica. * `JO` - The country code for Jordan. * `JP` - The country code for Japan. * `KE` - The country code for Kenya. * `KG` - The country code for Kyrgyzstan. * `KH` - The country code for Cambodia. * `KI` - The country code for Kiribati. * `KM` - The country code for Comoros. * `KN` - The country code for Saint Kitts and Nevis. * `KP` - The country code for Democratic People's Republic of Korea. * `KR` - The country code for Republic of Korea. * `KW` - The country code for Kuwait. * `KY` - The country code for Cayman Islands. * `KZ` - The country code for Kazakhstan. * `LA` - The country code for Lao People's Democratic Republic. * `LB` - The country code for Lebanon. * `LC` - The country code for Saint Lucia. * `LI` - The country code for Liechtenstein. * `LK` - The country code for Sri Lanka. * `LR` - The country code for Liberia. * `LS` - The country code for Lesotho. * `LT` - The country code for Lithuania. * `LU` - The country code for Luxembourg. * `LV` - The country code for Latvia. * `LY` - The country code for Libya. * `MA` - The country code for Morocco. * `MC` - The country code for Monaco. * `MD` - The country code for Republic of Moldova. * `ME` - The country code for Montenegro. * `MF` - The country code for Saint Martin (French part). * `MG` - The country code for Madagascar. * `MH` - The country code for Marshall Islands. * `MK` - The country code for North Macedonia. * `ML` - The country code for Mali. * `MM` - The country code for Myanmar. * `MN` - The country code for Mongolia. * `MO` - The country code for Macao. * `MP` - The country code for Northern Mariana Islands. * `MQ` - The country code for Martinique. * `MR` - The country code for Mauritania. * `MS` - The country code for Montserrat. * `MT` - The country code for Malta. * `MU` - The country code for Mauritius. * `MV` - The country code for Maldives. * `MW` - The country code for Malawi. * `MX` - The country code for Mexico. * `MY` - The country code for Malaysia. * `MZ` - The country code for Mozambique. * `NA` - The country code for Namibia. * `NC` - The country code for New Caledonia. * `NE` - The country code for Niger. * `NF` - The country code for Norfolk Island. * `NG` - The country code for Nigeria. * `NI` - The country code for Nicaragua. * `NL` - The country code for Kingdom of the Netherlands. * `NO` - The country code for Norway. * `NP` - The country code for Nepal. * `NR` - The country code for Nauru. * `NU` - The country code for Niue. * `NZ` - The country code for New Zealand. * `OM` - The country code for Oman. * `PA` - The country code for Panama. * `PE` - The country code for Peru. * `PF` - The country code for French Polynesia. * `PG` - The country code for Papua New Guinea. * `PH` - The country code for Philippines. * `PK` - The country code for Pakistan. * `PL` - The country code for Poland. * `PM` - The country code for Saint Pierre and Miquelon. * `PN` - The country code for Pitcairn. * `PR` - The country code for Puerto Rico. * `PS` - The country code for State of Palestine. * `PT` - The country code for Portugal. * `PW` - The country code for Palau. * `PY` - The country code for Paraguay. * `QA` - The country code for Qatar. * `RE` - The country code for Réunion. * `RO` - The country code for Romania. * `RS` - The country code for Serbia. * `RU` - The country code for Russian Federation. * `RW` - The country code for Rwanda. * `SA` - The country code for Saudi Arabia. * `SB` - The country code for Solomon Islands. * `SC` - The country code for Seychelles. * `SD` - The country code for Sudan. * `SE` - The country code for Sweden. * `SG` - The country code for Singapore. * `SH` - The country code for Ascension and Tristan da Cunha Saint Helena. * `SI` - The country code for Slovenia. * `SJ` - The country code for Svalbard and Jan Mayen. * `SK` - The country code for Slovakia. * `SL` - The country code for Sierra Leone. * `SM` - The country code for San Marino. * `SN` - The country code for Senegal. * `SO` - The country code for Somalia. * `SR` - The country code for Suriname. * `SS` - The country code for South Sudan. * `ST` - The country code for Sao Tome and Principe. * `SV` - The country code for El Salvador. * `SX` - The country code for Sint Maarten (Dutch part). * `SY` - The country code for Syrian Arab Republic. * `SZ` - The country code for Eswatini. * `TC` - The country code for Turks and Caicos Islands. * `TD` - The country code for Chad. * `TF` - The country code for French Southern Territories. * `TG` - The country code for Togo. * `TH` - The country code for Thailand. * `TJ` - The country code for Tajikistan. * `TK` - The country code for Tokelau. * `TL` - The country code for Timor-Leste. * `TM` - The country code for Turkmenistan. * `TN` - The country code for Tunisia. * `TO` - The country code for Tonga. * `TR` - The country code for Türkiye. * `TT` - The country code for Trinidad and Tobago. * `TV` - The country code for Tuvalu. * `TW` - The country code for Province of China Taiwan. * `TZ` - The country code for United Republic of Tanzania. * `UA` - The country code for Ukraine. * `UG` - The country code for Uganda. * `UM` - The country code for United States Minor Outlying Islands. * `US` - The country code for United States of America. * `UY` - The country code for Uruguay. * `UZ` - The country code for Uzbekistan. * `VA` - The country code for Holy See. * `VC` - The country code for Saint Vincent and the Grenadines. * `VE` - The country code for Bolivarian Republic of Venezuela. * `VG` - The country code for Virgin Islands (British). * `VI` - The country code for Virgin Islands (U.S.). * `VN` - The country code for Viet Nam. * `VU` - The country code for Vanuatu. * `WF` - The country code for Wallis and Futuna. * `WS` - The country code for Samoa. * `YE` - The country code for Yemen. * `YT` - The country code for Mayotte. * `ZA` - The country code for South Africa. * `ZM` - The country code for Zambia. * `ZW` - The country code for Zimbabwe.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            postal_code (str): The postal or ZIP code for the address.. [optional]  # noqa: E501
            state_province (str): The state or province where the address is located.. [optional]  # noqa: E501
        """

        class_id = "comm.PhysicalAddress" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "comm.PhysicalAddress")
        object_type = "comm.PhysicalAddress" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "comm.PhysicalAddress")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """CommPhysicalAddress - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "comm.PhysicalAddress", must be one of ["comm.PhysicalAddress", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "comm.PhysicalAddress", must be one of ["comm.PhysicalAddress", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            address1 (str): The primary street address.. [optional]  # noqa: E501
            address2 (str): Additional address information, such as suite number or floor.. [optional]  # noqa: E501
            city (str): The city where the address is located.. [optional]  # noqa: E501
            country (str): The country code in ISO 3166-1 alpha-2 format. * `Unknown` - The value Unknown is used when the country code is not known or applicable. * `AD` - The country code for Andorra. * `AE` - The country code for United Arab Emirates. * `AF` - The country code for Afghanistan. * `AG` - The country code for Antigua and Barbuda. * `AI` - The country code for Anguilla. * `AL` - The country code for Albania. * `AM` - The country code for Armenia. * `AO` - The country code for Angola. * `AQ` - The country code for Antarctica. * `AR` - The country code for Argentina. * `AS` - The country code for American Samoa. * `AT` - The country code for Austria. * `AU` - The country code for Australia. * `AW` - The country code for Aruba. * `AX` - The country code for Åland Islands. * `AZ` - The country code for Azerbaijan. * `BA` - The country code for Bosnia and Herzegovina. * `BB` - The country code for Barbados. * `BD` - The country code for Bangladesh. * `BE` - The country code for Belgium. * `BF` - The country code for Burkina Faso. * `BG` - The country code for Bulgaria. * `BH` - The country code for Bahrain. * `BI` - The country code for Burundi. * `BJ` - The country code for Benin. * `BL` - The country code for Saint Barthélemy. * `BM` - The country code for Bermuda. * `BN` - The country code for Brunei Darussalam. * `BO` - The country code for Plurinational State of Bolivia. * `BQ` - The country code for Sint Eustatius and Saba Bonaire. * `BR` - The country code for Brazil. * `BS` - The country code for Bahamas. * `BT` - The country code for Bhutan. * `BV` - The country code for Bouvet Island. * `BW` - The country code for Botswana. * `BY` - The country code for Belarus. * `BZ` - The country code for Belize. * `CA` - The country code for Canada. * `CC` - The country code for Cocos (Keeling) Islands. * `CD` - The country code for Democratic Republic of the Congo. * `CF` - The country code for Central African Republic. * `CG` - The country code for Congo. * `CH` - The country code for Switzerland. * `CI` - The country code for Côte d'Ivoire. * `CK` - The country code for Cook Islands. * `CL` - The country code for Chile. * `CM` - The country code for Cameroon. * `CN` - The country code for China. * `CO` - The country code for Colombia. * `CR` - The country code for Costa Rica. * `CU` - The country code for Cuba. * `CV` - The country code for Cabo Verde. * `CW` - The country code for Curaçao. * `CX` - The country code for Christmas Island. * `CY` - The country code for Cyprus. * `CZ` - The country code for Czechia. * `DE` - The country code for Germany. * `DJ` - The country code for Djibouti. * `DK` - The country code for Denmark. * `DM` - The country code for Dominica. * `DO` - The country code for Dominican Republic. * `DZ` - The country code for Algeria. * `EC` - The country code for Ecuador. * `EE` - The country code for Estonia. * `EG` - The country code for Egypt. * `EH` - The country code for Western Sahara. * `ER` - The country code for Eritrea. * `ES` - The country code for Spain. * `ET` - The country code for Ethiopia. * `FI` - The country code for Finland. * `FJ` - The country code for Fiji. * `FK` - The country code for Falkland Islands (Malvinas). * `FM` - The country code for Federated States of Micronesia. * `FO` - The country code for Faroe Islands. * `FR` - The country code for France. * `GA` - The country code for Gabon. * `GB` - The country code for United Kingdom of Great Britain and Northern Ireland. * `GD` - The country code for Grenada. * `GE` - The country code for Georgia. * `GF` - The country code for French Guiana. * `GG` - The country code for Guernsey. * `GH` - The country code for Ghana. * `GI` - The country code for Gibraltar. * `GL` - The country code for Greenland. * `GM` - The country code for Gambia. * `GN` - The country code for Guinea. * `GP` - The country code for Guadeloupe. * `GQ` - The country code for Equatorial Guinea. * `GR` - The country code for Greece. * `GS` - The country code for South Georgia and the South Sandwich Islands. * `GT` - The country code for Guatemala. * `GU` - The country code for Guam. * `GW` - The country code for Guinea-Bissau. * `GY` - The country code for Guyana. * `HK` - The country code for Hong Kong. * `HM` - The country code for Heard Island and McDonald Islands. * `HN` - The country code for Honduras. * `HR` - The country code for Croatia. * `HT` - The country code for Haiti. * `HU` - The country code for Hungary. * `ID` - The country code for Indonesia. * `IE` - The country code for Ireland. * `IL` - The country code for Israel. * `IM` - The country code for Isle of Man. * `IN` - The country code for India. * `IO` - The country code for British Indian Ocean Territory. * `IQ` - The country code for Iraq. * `IR` - The country code for Islamic Republic of Iran. * `IS` - The country code for Iceland. * `IT` - The country code for Italy. * `JE` - The country code for Jersey. * `JM` - The country code for Jamaica. * `JO` - The country code for Jordan. * `JP` - The country code for Japan. * `KE` - The country code for Kenya. * `KG` - The country code for Kyrgyzstan. * `KH` - The country code for Cambodia. * `KI` - The country code for Kiribati. * `KM` - The country code for Comoros. * `KN` - The country code for Saint Kitts and Nevis. * `KP` - The country code for Democratic People's Republic of Korea. * `KR` - The country code for Republic of Korea. * `KW` - The country code for Kuwait. * `KY` - The country code for Cayman Islands. * `KZ` - The country code for Kazakhstan. * `LA` - The country code for Lao People's Democratic Republic. * `LB` - The country code for Lebanon. * `LC` - The country code for Saint Lucia. * `LI` - The country code for Liechtenstein. * `LK` - The country code for Sri Lanka. * `LR` - The country code for Liberia. * `LS` - The country code for Lesotho. * `LT` - The country code for Lithuania. * `LU` - The country code for Luxembourg. * `LV` - The country code for Latvia. * `LY` - The country code for Libya. * `MA` - The country code for Morocco. * `MC` - The country code for Monaco. * `MD` - The country code for Republic of Moldova. * `ME` - The country code for Montenegro. * `MF` - The country code for Saint Martin (French part). * `MG` - The country code for Madagascar. * `MH` - The country code for Marshall Islands. * `MK` - The country code for North Macedonia. * `ML` - The country code for Mali. * `MM` - The country code for Myanmar. * `MN` - The country code for Mongolia. * `MO` - The country code for Macao. * `MP` - The country code for Northern Mariana Islands. * `MQ` - The country code for Martinique. * `MR` - The country code for Mauritania. * `MS` - The country code for Montserrat. * `MT` - The country code for Malta. * `MU` - The country code for Mauritius. * `MV` - The country code for Maldives. * `MW` - The country code for Malawi. * `MX` - The country code for Mexico. * `MY` - The country code for Malaysia. * `MZ` - The country code for Mozambique. * `NA` - The country code for Namibia. * `NC` - The country code for New Caledonia. * `NE` - The country code for Niger. * `NF` - The country code for Norfolk Island. * `NG` - The country code for Nigeria. * `NI` - The country code for Nicaragua. * `NL` - The country code for Kingdom of the Netherlands. * `NO` - The country code for Norway. * `NP` - The country code for Nepal. * `NR` - The country code for Nauru. * `NU` - The country code for Niue. * `NZ` - The country code for New Zealand. * `OM` - The country code for Oman. * `PA` - The country code for Panama. * `PE` - The country code for Peru. * `PF` - The country code for French Polynesia. * `PG` - The country code for Papua New Guinea. * `PH` - The country code for Philippines. * `PK` - The country code for Pakistan. * `PL` - The country code for Poland. * `PM` - The country code for Saint Pierre and Miquelon. * `PN` - The country code for Pitcairn. * `PR` - The country code for Puerto Rico. * `PS` - The country code for State of Palestine. * `PT` - The country code for Portugal. * `PW` - The country code for Palau. * `PY` - The country code for Paraguay. * `QA` - The country code for Qatar. * `RE` - The country code for Réunion. * `RO` - The country code for Romania. * `RS` - The country code for Serbia. * `RU` - The country code for Russian Federation. * `RW` - The country code for Rwanda. * `SA` - The country code for Saudi Arabia. * `SB` - The country code for Solomon Islands. * `SC` - The country code for Seychelles. * `SD` - The country code for Sudan. * `SE` - The country code for Sweden. * `SG` - The country code for Singapore. * `SH` - The country code for Ascension and Tristan da Cunha Saint Helena. * `SI` - The country code for Slovenia. * `SJ` - The country code for Svalbard and Jan Mayen. * `SK` - The country code for Slovakia. * `SL` - The country code for Sierra Leone. * `SM` - The country code for San Marino. * `SN` - The country code for Senegal. * `SO` - The country code for Somalia. * `SR` - The country code for Suriname. * `SS` - The country code for South Sudan. * `ST` - The country code for Sao Tome and Principe. * `SV` - The country code for El Salvador. * `SX` - The country code for Sint Maarten (Dutch part). * `SY` - The country code for Syrian Arab Republic. * `SZ` - The country code for Eswatini. * `TC` - The country code for Turks and Caicos Islands. * `TD` - The country code for Chad. * `TF` - The country code for French Southern Territories. * `TG` - The country code for Togo. * `TH` - The country code for Thailand. * `TJ` - The country code for Tajikistan. * `TK` - The country code for Tokelau. * `TL` - The country code for Timor-Leste. * `TM` - The country code for Turkmenistan. * `TN` - The country code for Tunisia. * `TO` - The country code for Tonga. * `TR` - The country code for Türkiye. * `TT` - The country code for Trinidad and Tobago. * `TV` - The country code for Tuvalu. * `TW` - The country code for Province of China Taiwan. * `TZ` - The country code for United Republic of Tanzania. * `UA` - The country code for Ukraine. * `UG` - The country code for Uganda. * `UM` - The country code for United States Minor Outlying Islands. * `US` - The country code for United States of America. * `UY` - The country code for Uruguay. * `UZ` - The country code for Uzbekistan. * `VA` - The country code for Holy See. * `VC` - The country code for Saint Vincent and the Grenadines. * `VE` - The country code for Bolivarian Republic of Venezuela. * `VG` - The country code for Virgin Islands (British). * `VI` - The country code for Virgin Islands (U.S.). * `VN` - The country code for Viet Nam. * `VU` - The country code for Vanuatu. * `WF` - The country code for Wallis and Futuna. * `WS` - The country code for Samoa. * `YE` - The country code for Yemen. * `YT` - The country code for Mayotte. * `ZA` - The country code for South Africa. * `ZM` - The country code for Zambia. * `ZW` - The country code for Zimbabwe.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            postal_code (str): The postal or ZIP code for the address.. [optional]  # noqa: E501
            state_province (str): The state or province where the address is located.. [optional]  # noqa: E501
        """

        class_id = "comm.PhysicalAddress" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "comm.PhysicalAddress")
        object_type = "comm.PhysicalAddress" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "comm.PhysicalAddress")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              CommPhysicalAddressAllOf,
              MoBaseComplexType,
          ],
          'oneOf': [
          ],
        }
