"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError



class ConvergedinfraBaseComplianceDetailsAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'ADAPTERCOMPLIANCEDETAILS': "convergedinfra.AdapterComplianceDetails",
            'PODCOMPLIANCEINFO': "convergedinfra.PodComplianceInfo",
            'SERVERCOMPLIANCEDETAILS': "convergedinfra.ServerComplianceDetails",
            'STORAGECOMPLIANCEDETAILS': "convergedinfra.StorageComplianceDetails",
            'SWITCHCOMPLIANCEDETAILS': "convergedinfra.SwitchComplianceDetails",
        },
        ('object_type',): {
            'ADAPTERCOMPLIANCEDETAILS': "convergedinfra.AdapterComplianceDetails",
            'PODCOMPLIANCEINFO': "convergedinfra.PodComplianceInfo",
            'SERVERCOMPLIANCEDETAILS': "convergedinfra.ServerComplianceDetails",
            'STORAGECOMPLIANCEDETAILS': "convergedinfra.StorageComplianceDetails",
            'SWITCHCOMPLIANCEDETAILS': "convergedinfra.SwitchComplianceDetails",
        },
        ('reason',): {
            'NOTEVALUATED': "NotEvaluated",
            'MISSING-OS-INFO': "Missing-Os-Info",
            'INCOMPATIBLE-STORAGE-OS': "Incompatible-Storage-Os",
            'INCOMPATIBLE-OS-INFO': "Incompatible-Os-Info",
            'INCOMPATIBLE-PROCESSOR': "Incompatible-Processor",
            'INCOMPATIBLE-SERVER-PLATFORM': "Incompatible-Server-Platform",
            'INCOMPATIBLE-SERVER-MODEL': "Incompatible-Server-Model",
            'INCOMPATIBLE-ADAPTER-MODEL': "Incompatible-Adapter-Model",
            'INCOMPATIBLE-SWITCH-MODEL': "Incompatible-Switch-Model",
            'INCOMPATIBLE-SERVER-FIRMWARE': "Incompatible-Server-Firmware",
            'INCOMPATIBLE-SWITCH-FIRMWARE': "Incompatible-Switch-Firmware",
            'INCOMPATIBLE-FIRMWARE': "Incompatible-Firmware",
            'INCOMPATIBLE-DRIVER': "Incompatible-Driver",
            'INCOMPATIBLE-FIRMWARE-DRIVER': "Incompatible-Firmware-Driver",
            'MISSING-OS-DRIVER-INFO': "Missing-Os-Driver-Info",
            'MISSING-OS-OR-DRIVER-INFO': "Missing-Os-Or-Driver-Info",
            'INCOMPATIBLE-COMPONENTS': "Incompatible-Components",
            'COMPATIBLE': "Compatible",
        },
        ('status',): {
            'NOTEVALUATED': "NotEvaluated",
            'APPROVED': "Approved",
            'NOTAPPROVED': "NotApproved",
            'INCOMPLETE': "Incomplete",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'reason': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'reason': 'Reason',  # noqa: E501
        'status': 'Status',  # noqa: E501
    }

    read_only_vars = {
        'name',  # noqa: E501
        'reason',  # noqa: E501
        'status',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, class_id, object_type, *args, **kwargs):  # noqa: E501
        """ConvergedinfraBaseComplianceDetailsAllOf - a model defined in OpenAPI

        Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): The name of the component for which the compliance is evaluated.. [optional]  # noqa: E501
            reason (str): Reason for the status, when the status is Incomplete or NotApproved. Reason should help to identify the component that is not compliant. * `NotEvaluated` - The validation for the HCL or Interop status is yet to be performed. * `Missing-Os-Info` - This means the Interop status for the sever cannot be computed because we have missing OS information. Either install ucstools vib or use power shell scripts to tag proper OS information. * `Incompatible-Storage-Os` - The validation failed because the given storage name and version combination is not found in Interop matrix. * `Incompatible-Os-Info` - The validation failed because the given OS name and version combination is not found in HCL. * `Incompatible-Processor` - The validation failed because the given processor is not found for the given server PID in HCL. * `Incompatible-Server-Platform` - The validation failed because the given server platform is not found in the Interop matrix. * `Incompatible-Server-Model` - The validation failed because the given server model is not found in the Interop matrix. * `Incompatible-Adapter-Model` - The validation failed because the given adapter model is not found in the Interop matrix. * `Incompatible-Switch-Model` - The validation failed because the given switch model is not found in the Interop matrix. * `Incompatible-Server-Firmware` - The validation failed because the given server firmware version is not found in HCL. * `Incompatible-Switch-Firmware` - The validation failed because the given switch firmware version is not found in Interop matrix. * `Incompatible-Firmware` - The validation failed because the given adapter firmware version is not found in either HCL or Interop matrix. * `Incompatible-Driver` - The validation failed because the given driver version is not found in either HCL or Interop matrix. * `Incompatible-Firmware-Driver` - The validation failed because the given adapter firmware and driver version is not found in either HCL or Interop matrix. * `Missing-Os-Driver-Info` - The validation failed because the given server has no OS driver information available in the inventory. Either install ucstools vib or use power shell scripts to tag proper OS information. * `Missing-Os-Or-Driver-Info` - This means the Interop status for the switch or storage array cannot be computed because we have either missing Host OS information or missing required driver information. Either install ucstools vib or use power shell scripts to tag proper OS information or install required drivers. * `Incompatible-Components` - The validation failed for the given server because one or more of its components failed validation. * `Compatible` - This means the HCL status and Interop status for the component have passed all validations for all of its related components.. [optional] if omitted the server will use the default value of "NotEvaluated"  # noqa: E501
            status (str): Compliance status for the component. * `NotEvaluated` - The interoperability compliance for the component has not be checked. * `Approved` - The component is valid as per the interoperability compliance check. * `NotApproved` - The component is not valid as per the interoperability compliance check. * `Incomplete` - The interoperability compliance check could not be completed for the component due to incomplete data.. [optional] if omitted the server will use the default value of "NotEvaluated"  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """ConvergedinfraBaseComplianceDetailsAllOf - a model defined in OpenAPI

        Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): The name of the component for which the compliance is evaluated.. [optional]  # noqa: E501
            reason (str): Reason for the status, when the status is Incomplete or NotApproved. Reason should help to identify the component that is not compliant. * `NotEvaluated` - The validation for the HCL or Interop status is yet to be performed. * `Missing-Os-Info` - This means the Interop status for the sever cannot be computed because we have missing OS information. Either install ucstools vib or use power shell scripts to tag proper OS information. * `Incompatible-Storage-Os` - The validation failed because the given storage name and version combination is not found in Interop matrix. * `Incompatible-Os-Info` - The validation failed because the given OS name and version combination is not found in HCL. * `Incompatible-Processor` - The validation failed because the given processor is not found for the given server PID in HCL. * `Incompatible-Server-Platform` - The validation failed because the given server platform is not found in the Interop matrix. * `Incompatible-Server-Model` - The validation failed because the given server model is not found in the Interop matrix. * `Incompatible-Adapter-Model` - The validation failed because the given adapter model is not found in the Interop matrix. * `Incompatible-Switch-Model` - The validation failed because the given switch model is not found in the Interop matrix. * `Incompatible-Server-Firmware` - The validation failed because the given server firmware version is not found in HCL. * `Incompatible-Switch-Firmware` - The validation failed because the given switch firmware version is not found in Interop matrix. * `Incompatible-Firmware` - The validation failed because the given adapter firmware version is not found in either HCL or Interop matrix. * `Incompatible-Driver` - The validation failed because the given driver version is not found in either HCL or Interop matrix. * `Incompatible-Firmware-Driver` - The validation failed because the given adapter firmware and driver version is not found in either HCL or Interop matrix. * `Missing-Os-Driver-Info` - The validation failed because the given server has no OS driver information available in the inventory. Either install ucstools vib or use power shell scripts to tag proper OS information. * `Missing-Os-Or-Driver-Info` - This means the Interop status for the switch or storage array cannot be computed because we have either missing Host OS information or missing required driver information. Either install ucstools vib or use power shell scripts to tag proper OS information or install required drivers. * `Incompatible-Components` - The validation failed for the given server because one or more of its components failed validation. * `Compatible` - This means the HCL status and Interop status for the component have passed all validations for all of its related components.. [optional] if omitted the server will use the default value of "NotEvaluated"  # noqa: E501
            status (str): Compliance status for the component. * `NotEvaluated` - The interoperability compliance for the component has not be checked. * `Approved` - The component is valid as per the interoperability compliance check. * `NotApproved` - The component is not valid as per the interoperability compliance check. * `Incomplete` - The interoperability compliance check could not be completed for the component due to incomplete data.. [optional] if omitted the server will use the default value of "NotEvaluated"  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
