"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.compute_ip_address import ComputeIpAddress
    from intersight.model.display_names import DisplayNames
    from intersight.model.equipment_chassis_relationship import EquipmentChassisRelationship
    from intersight.model.equipment_fan_module_relationship import EquipmentFanModuleRelationship
    from intersight.model.equipment_fex_relationship import EquipmentFexRelationship
    from intersight.model.equipment_fru_relationship import EquipmentFruRelationship
    from intersight.model.equipment_io_card_all_of import EquipmentIoCardAllOf
    from intersight.model.equipment_io_card_base import EquipmentIoCardBase
    from intersight.model.ether_host_port_relationship import EtherHostPortRelationship
    from intersight.model.ether_network_port_relationship import EtherNetworkPortRelationship
    from intersight.model.inventory_device_info_relationship import InventoryDeviceInfoRelationship
    from intersight.model.management_controller_relationship import ManagementControllerRelationship
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.port_sub_group_relationship import PortSubGroupRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['ComputeIpAddress'] = ComputeIpAddress
    globals()['DisplayNames'] = DisplayNames
    globals()['EquipmentChassisRelationship'] = EquipmentChassisRelationship
    globals()['EquipmentFanModuleRelationship'] = EquipmentFanModuleRelationship
    globals()['EquipmentFexRelationship'] = EquipmentFexRelationship
    globals()['EquipmentFruRelationship'] = EquipmentFruRelationship
    globals()['EquipmentIoCardAllOf'] = EquipmentIoCardAllOf
    globals()['EquipmentIoCardBase'] = EquipmentIoCardBase
    globals()['EtherHostPortRelationship'] = EtherHostPortRelationship
    globals()['EtherNetworkPortRelationship'] = EtherNetworkPortRelationship
    globals()['InventoryDeviceInfoRelationship'] = InventoryDeviceInfoRelationship
    globals()['ManagementControllerRelationship'] = ManagementControllerRelationship
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['PortSubGroupRelationship'] = PortSubGroupRelationship


class EquipmentIoCard(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'EQUIPMENT.IOCARD': "equipment.IoCard",
        },
        ('object_type',): {
            'EQUIPMENT.IOCARD': "equipment.IoCard",
        },
        ('oper_reason',): {
            'None': None,
            'UNKNOWN': "Unknown",
            'OK': "OK",
            'OFFLINE': "Offline",
            'MISSING': "Missing",
            'HEALTHWARNING': "HealthWarning",
            'HEALTHCRITICAL': "HealthCritical",
            'TEMPERATUREWARNING': "TemperatureWarning",
            'TEMPERATURECRITICAL': "TemperatureCritical",
            'INPUTVOLTAGEWARNING': "InputVoltageWarning",
            'INPUTVOLTAGECRITICAL': "InputVoltageCritical",
            'OUTPUTVOLTAGEWARNING': "OutputVoltageWarning",
            'OUTPUTVOLTAGECRITICAL': "OutputVoltageCritical",
            'OUTPUTCURRENTWARNING': "OutputCurrentWarning",
            'OUTPUTCURRENTCRITICAL': "OutputCurrentCritical",
            'SPEEDWARNING': "SpeedWarning",
            'SPEEDCRITICAL': "SpeedCritical",
            'FANMISSINGWARNING': "FanMissingWarning",
            'FANSMISSINGCRITICAL': "FansMissingCritical",
            'IOCARDPOSTWARNING': "IocardPostWarning",
            'ASICPOSTWARNING': "AsicPostWarning",
            'FRUSTATECRITICAL': "FruStateCritical",
            'FRUSTATEWARNING': "FruStateWarning",
            'ALTERNATEIMAGEWARNING': "AlternateImageWarning",
            'SELECTEDIMAGEWARNING': "SelectedImageWarning",
            'LOWMEMORYCRITICAL': "LowMemoryCritical",
            'LOWMEMORYWARNING': "LowMemoryWarning",
            'POWERCRITICAL': "PowerCritical",
            'POWERWARNING': "PowerWarning",
            'THERMALSAFEMODECRITICAL': "ThermalSafeModeCritical",
            'PSUREDUNDANCYLOSTCRITICAL': "PsuRedundancyLostCritical",
            'INPUTPOWERWARNING': "InputPowerWarning",
            'INPUTPOWERCRITICAL': "InputPowerCritical",
            'OUTPUTPOWERWARNING': "OutputPowerWarning",
            'OUTPUTPOWERCRITICAL': "OutputPowerCritical",
            'FANGENERALCRITICAL': "FanGeneralCritical",
            'POWERSUPPLYGENERALCRITICAL': "PowerSupplyGeneralCritical",
            'POWERSUPPLYINPUTWARNING': "PowerSupplyInputWarning",
            'POWERSUPPLYOUTPUTCRITICAL': "PowerSupplyOutputCritical",
            'POWERSUPPLYINPUTLOSTWARNING': "PowerSupplyInputLostWarning",
            'POWERSUPPLYUNRESPONSIVECRITICAL': "PowerSupplyUnresponsiveCritical",
            'POWERSUPPLYPREDICTIVEFAILURE': "PowerSupplyPredictiveFailure",
            'POWERSUPPLYDETECTIONFAILURE': "PowerSupplyDetectionFailure",
            'PSUFASTOVERCURRENTWARNING': "PsuFastOverCurrentWarning",
            'FANUNRESPONSIVECRITICAL': "FanUnresponsiveCritical",
            'MEMORYUNCORRECTABLEERROR': "MemoryUncorrectableError",
            'MEMORYTEMPERATUREWARNING': "MemoryTemperatureWarning",
            'MEMORYTEMPERATURECRITICAL': "MemoryTemperatureCritical",
            'MEMORYBANKERROR': "MemoryBankError",
            'MEMORYRANKERROR': "MemoryRankError",
            'MEMORYPOPERROR': "MemoryPopError",
            'MEMORYRASERROR': "MemoryRasError",
            'MEMORYMISMATCHERROR': "MemoryMismatchError",
            'MEMORYSPDERROR': "MemorySpdError",
            'MEMORYBISTERROR': "MemoryBistError",
            'MEMORYTYPEERROR': "MemoryTypeError",
            'MOTHERBOARDPOWERCRITICAL': "MotherBoardPowerCritical",
            'MOTHERBOARDTEMPERATUREWARNING': "MotherBoardTemperatureWarning",
            'MOTHERBOARDTEMPERATURECRITICAL': "MotherBoardTemperatureCritical",
            'MOTHERBOARDVOLTAGEWARNING': "MotherBoardVoltageWarning",
            'MOTHERBOARDVOLTAGECRITICAL': "MotherBoardVoltageCritical",
            'MOTHERBOARDPCHFUSEFAIL': "MotherBoardPCHFuseFail",
            'MOTHERBOARDCPLDIMAGEVERIFICATIONFAIL': "MotherBoardCPLDImageVerificationFail",
            'LOWLEVELCOMPONENTFAILURE': "LowLevelComponentFailure",
            'PROCESSORCATERR': "ProcessorCatErr",
            'PROCESSORTHERMTRIP': "ProcessorThermTrip",
            'COMPONENTNOTOPERATIONAL': "ComponentNotOperational",
            'OPERATIONALTHROUGHFAILOVER': "OperationalThroughFailover",
            'COMPONENTNOTREACHABLE': "ComponentNotReachable",
            'PROCESSORTEMPERATUREWARNING': "ProcessorTemperatureWarning",
            'PROCESSORTEMPERATURECRITICAL': "ProcessorTemperatureCritical",
            'PROCESSORPOWERCRITICAL': "ProcessorPowerCritical",
            'PROCESSORINTERNALERROR': "ProcessorInternalError",
            'PROCESSORBISTFAILURE': "ProcessorBISTFailure",
            'PROCESSORHANGINPOSTFAILURE': "ProcessorHangInPOSTFailure",
            'PROCESSORINITFAILURE': "ProcessorInitFailure",
            'PROCESSORCONFIGURATIONFAILURE': "ProcessorConfigurationFailure",
            'PROCESSORSMBIOSUNCORRECTABLECPUCOMPLEXERROR': "ProcessorSMBIOSUncorrectableCPUComplexError",
            'PCIENODERISERMISMATCH': "PCIeNodeRiserMismatch",
            'PCIENODERISER1MISSING': "PCIeNodeRiser1Missing",
            'PCIENODERISER2PRESENTCPU2ABSENT': "PCIeNodeRiser2PresentCPU2Absent",
            'PCIENODEPCIELINKCONFIGISSUE': "PCIeNodePCIeLinkConfigIssue",
            'PCIENODERISER1POWERFAULT': "PCIeNodeRiser1PowerFault",
            'PCIENODERISER2POWERFAULT': "PCIeNodeRiser2PowerFault",
            'PCIENODEPOWERFAULT': "PCIeNodePowerFault",
            'PCIENODEUNSUPPORTEDPCIECARDPRESENTONRISER1': "PCIeNodeUnsupportedPCIeCardPresentOnRiser1",
            'PCIENODEUNSUPPORTEDPCIECARDPRESENTONRISER2': "PCIeNodeUnsupportedPCIeCardPresentOnRiser2",
            'PCIENODEUNKNOWNPCIECARDPRESENTONRISER1': "PCIeNodeUnknownPCIeCardPresentOnRiser1",
            'PCIENODEUNKNOWNPCIECARDPRESENTONRISER2': "PCIeNodeUnknownPCIeCardPresentOnRiser2",
            'PCIENODEPRESENTXFM1ABSENT': "PCIeNodePresentXFM1Absent",
            'INVALIDCONNECTIONS': "InvalidConnections",
            'FEXREPLACED': "FexReplaced",
            'THERMALSAFEMODECRITICALSERVERSLOT1': "ThermalSafeModeCriticalServerSlot1",
            'THERMALSAFEMODECRITICALSERVERSLOT2': "ThermalSafeModeCriticalServerSlot2",
            'THERMALSAFEMODECRITICALSERVERSLOT3': "ThermalSafeModeCriticalServerSlot3",
            'THERMALSAFEMODECRITICALSERVERSLOT4': "ThermalSafeModeCriticalServerSlot4",
            'THERMALSAFEMODECRITICALSERVERSLOT5': "ThermalSafeModeCriticalServerSlot5",
            'THERMALSAFEMODECRITICALSERVERSLOT6': "ThermalSafeModeCriticalServerSlot6",
            'THERMALSAFEMODECRITICALSERVERSLOT7': "ThermalSafeModeCriticalServerSlot7",
            'THERMALSAFEMODECRITICALSERVERSLOT8': "ThermalSafeModeCriticalServerSlot8",
            'THERMALSAFEMODECRITICALXFM1': "ThermalSafeModeCriticalXFM1",
            'THERMALSAFEMODECRITICALXFM2': "ThermalSafeModeCriticalXFM2",
            'THERMALSAFEMODECRITICALIFM1': "ThermalSafeModeCriticalIFM1",
            'THERMALSAFEMODECRITICALIFM2': "ThermalSafeModeCriticalIFM2",
            'CHASSISAVAILABLEPOWERINSUFFICIENT': "ChassisAvailablePowerInsufficient",
            'CHASSISPOWERBUDGETINSUFFICIENT': "ChassisPowerBudgetInsufficient",
            'CHASSISPOWERINSUFFICIENT': "ChassisPowerInsufficient",
            'POWERBACKUPFAILEDCRITICAL': "PowerBackupFailedCritical",
            'POWERBACKUPFAILEDWARNING': "PowerBackupFailedWarning",
            'SPARECAPACITYWORNOUTCRITICAL': "SpareCapacityWornOutCritical",
            'SPARECAPACITYWORNOUTWARNING': "SpareCapacityWornOutWarning",
            'MEDIAINREADONLYCRITICAL': "MediaInReadOnlyCritical",
            'MEDIAINREADONLYWARNING': "MediaInReadOnlyWarning",
            'OVERALLSUBSYSTEMDEGRADEDCRITICAL': "OverallSubsystemDegradedCritical",
            'OVERALLSUBSYSTEMDEGRADEDWARNING': "OverallSubsystemDegradedWarning",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'connection_path': (str,),  # noqa: E501
            'dc_supported': (bool,),  # noqa: E501
            'inband_ip_addresses': ([ComputeIpAddress], none_type,),  # noqa: E501
            'out_of_band_ip_addresses': ([ComputeIpAddress], none_type,),  # noqa: E501
            'side': (str,),  # noqa: E501
            'equipment_chassis': (EquipmentChassisRelationship,),  # noqa: E501
            'equipment_fex': (EquipmentFexRelationship,),  # noqa: E501
            'fan_modules': ([EquipmentFanModuleRelationship], none_type,),  # noqa: E501
            'inventory_device_info': (InventoryDeviceInfoRelationship,),  # noqa: E501
            'physical_device_registration': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'device_mo_id': (str,),  # noqa: E501
            'dn': (str,),  # noqa: E501
            'rn': (str,),  # noqa: E501
            'is_upgraded': (bool,),  # noqa: E501
            'model': (str,),  # noqa: E501
            'presence': (str,),  # noqa: E501
            'revision': (str,),  # noqa: E501
            'serial': (str,),  # noqa: E501
            'vendor': (str,),  # noqa: E501
            'previous_fru': (EquipmentFruRelationship,),  # noqa: E501
            'connection_status': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'module_id': (int,),  # noqa: E501
            'oper_reason': ([str], none_type,),  # noqa: E501
            'oper_state': (str,),  # noqa: E501
            'part_number': (str,),  # noqa: E501
            'pid': (str,),  # noqa: E501
            'product_name': (str,),  # noqa: E501
            'sku': (str,),  # noqa: E501
            'version': (str,),  # noqa: E501
            'vid': (str,),  # noqa: E501
            'host_ports': ([EtherHostPortRelationship], none_type,),  # noqa: E501
            'mgmt_controller': (ManagementControllerRelationship,),  # noqa: E501
            'network_ports': ([EtherNetworkPortRelationship], none_type,),  # noqa: E501
            'sub_group': ([PortSubGroupRelationship], none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        val = {
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'connection_path': 'ConnectionPath',  # noqa: E501
        'dc_supported': 'DcSupported',  # noqa: E501
        'inband_ip_addresses': 'InbandIpAddresses',  # noqa: E501
        'out_of_band_ip_addresses': 'OutOfBandIpAddresses',  # noqa: E501
        'side': 'Side',  # noqa: E501
        'equipment_chassis': 'EquipmentChassis',  # noqa: E501
        'equipment_fex': 'EquipmentFex',  # noqa: E501
        'fan_modules': 'FanModules',  # noqa: E501
        'inventory_device_info': 'InventoryDeviceInfo',  # noqa: E501
        'physical_device_registration': 'PhysicalDeviceRegistration',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'device_mo_id': 'DeviceMoId',  # noqa: E501
        'dn': 'Dn',  # noqa: E501
        'rn': 'Rn',  # noqa: E501
        'is_upgraded': 'IsUpgraded',  # noqa: E501
        'model': 'Model',  # noqa: E501
        'presence': 'Presence',  # noqa: E501
        'revision': 'Revision',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'vendor': 'Vendor',  # noqa: E501
        'previous_fru': 'PreviousFru',  # noqa: E501
        'connection_status': 'ConnectionStatus',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'module_id': 'ModuleId',  # noqa: E501
        'oper_reason': 'OperReason',  # noqa: E501
        'oper_state': 'OperState',  # noqa: E501
        'part_number': 'PartNumber',  # noqa: E501
        'pid': 'Pid',  # noqa: E501
        'product_name': 'ProductName',  # noqa: E501
        'sku': 'Sku',  # noqa: E501
        'version': 'Version',  # noqa: E501
        'vid': 'Vid',  # noqa: E501
        'host_ports': 'HostPorts',  # noqa: E501
        'mgmt_controller': 'MgmtController',  # noqa: E501
        'network_ports': 'NetworkPorts',  # noqa: E501
        'sub_group': 'SubGroup',  # noqa: E501
    }

    read_only_vars = {
        'connection_path',  # noqa: E501
        'dc_supported',  # noqa: E501
        'side',  # noqa: E501
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
        'device_mo_id',  # noqa: E501
        'dn',  # noqa: E501
        'rn',  # noqa: E501
        'is_upgraded',  # noqa: E501
        'model',  # noqa: E501
        'presence',  # noqa: E501
        'revision',  # noqa: E501
        'serial',  # noqa: E501
        'vendor',  # noqa: E501
        'description',  # noqa: E501
        'module_id',  # noqa: E501
        'oper_state',  # noqa: E501
        'part_number',  # noqa: E501
        'pid',  # noqa: E501
        'product_name',  # noqa: E501
        'sku',  # noqa: E501
        'version',  # noqa: E501
        'vid',  # noqa: E501
        'sub_group',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """EquipmentIoCard - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "equipment.IoCard", must be one of ["equipment.IoCard", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "equipment.IoCard", must be one of ["equipment.IoCard", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            connection_path (str): Switch Id to which the IOM is connected to. The value can be A or B.. [optional]  # noqa: E501
            dc_supported (bool): IOM device connector support.. [optional]  # noqa: E501
            inband_ip_addresses ([ComputeIpAddress], none_type): [optional]  # noqa: E501
            out_of_band_ip_addresses ([ComputeIpAddress], none_type): [optional]  # noqa: E501
            side (str): Location of IOM within a chassis. The value can be left or right.. [optional]  # noqa: E501
            equipment_chassis (EquipmentChassisRelationship): [optional]  # noqa: E501
            equipment_fex (EquipmentFexRelationship): [optional]  # noqa: E501
            fan_modules ([EquipmentFanModuleRelationship], none_type): An array of relationships to equipmentFanModule resources.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            physical_device_registration (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            is_upgraded (bool): This field indicates the compute status of the catalog values for the associated component or hardware.. [optional] if omitted the server will use the default value of False  # noqa: E501
            model (str): This field displays the model number of the associated component or hardware.. [optional]  # noqa: E501
            presence (str): This field indicates the presence (equipped) or absence (absent) of the associated component or hardware.. [optional]  # noqa: E501
            revision (str): This field displays the revised version of the associated component or hardware (if any).. [optional]  # noqa: E501
            serial (str): This field displays the serial number of the associated component or hardware.. [optional]  # noqa: E501
            vendor (str): This field displays the vendor information of the associated component or hardware.. [optional]  # noqa: E501
            previous_fru (EquipmentFruRelationship): [optional]  # noqa: E501
            connection_status (str): Connectivity Status of FEX/IOM to Switch - A or B or AB.. [optional]  # noqa: E501
            description (str): This field is to provide description for the iocard module model.. [optional]  # noqa: E501
            module_id (int): Module Identifier for the IO module.. [optional]  # noqa: E501
            oper_reason ([str], none_type): [optional]  # noqa: E501
            oper_state (str): Operational state of IO card or fabric extender.. [optional]  # noqa: E501
            part_number (str): Part Number identifier for the IO module.. [optional]  # noqa: E501
            pid (str): This field identifies the Product ID for the IO module.. [optional]  # noqa: E501
            product_name (str): This field identifies the Product Name for the iocard module model.. [optional]  # noqa: E501
            sku (str): This field identifies the Stock Keeping Unit for the IO card module.. [optional]  # noqa: E501
            version (str): This field identifies the version of the IO card module.. [optional]  # noqa: E501
            vid (str): This field identifies the Vendor ID for the IO card module.. [optional]  # noqa: E501
            host_ports ([EtherHostPortRelationship], none_type): An array of relationships to etherHostPort resources.. [optional]  # noqa: E501
            mgmt_controller (ManagementControllerRelationship): [optional]  # noqa: E501
            network_ports ([EtherNetworkPortRelationship], none_type): An array of relationships to etherNetworkPort resources.. [optional]  # noqa: E501
            sub_group ([PortSubGroupRelationship], none_type): An array of relationships to portSubGroup resources.. [optional]  # noqa: E501
        """

        class_id = "equipment.IoCard" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "equipment.IoCard")
        object_type = "equipment.IoCard" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "equipment.IoCard")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """EquipmentIoCard - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "equipment.IoCard", must be one of ["equipment.IoCard", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "equipment.IoCard", must be one of ["equipment.IoCard", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            connection_path (str): Switch Id to which the IOM is connected to. The value can be A or B.. [optional]  # noqa: E501
            dc_supported (bool): IOM device connector support.. [optional]  # noqa: E501
            inband_ip_addresses ([ComputeIpAddress], none_type): [optional]  # noqa: E501
            out_of_band_ip_addresses ([ComputeIpAddress], none_type): [optional]  # noqa: E501
            side (str): Location of IOM within a chassis. The value can be left or right.. [optional]  # noqa: E501
            equipment_chassis (EquipmentChassisRelationship): [optional]  # noqa: E501
            equipment_fex (EquipmentFexRelationship): [optional]  # noqa: E501
            fan_modules ([EquipmentFanModuleRelationship], none_type): An array of relationships to equipmentFanModule resources.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            physical_device_registration (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            is_upgraded (bool): This field indicates the compute status of the catalog values for the associated component or hardware.. [optional] if omitted the server will use the default value of False  # noqa: E501
            model (str): This field displays the model number of the associated component or hardware.. [optional]  # noqa: E501
            presence (str): This field indicates the presence (equipped) or absence (absent) of the associated component or hardware.. [optional]  # noqa: E501
            revision (str): This field displays the revised version of the associated component or hardware (if any).. [optional]  # noqa: E501
            serial (str): This field displays the serial number of the associated component or hardware.. [optional]  # noqa: E501
            vendor (str): This field displays the vendor information of the associated component or hardware.. [optional]  # noqa: E501
            previous_fru (EquipmentFruRelationship): [optional]  # noqa: E501
            connection_status (str): Connectivity Status of FEX/IOM to Switch - A or B or AB.. [optional]  # noqa: E501
            description (str): This field is to provide description for the iocard module model.. [optional]  # noqa: E501
            module_id (int): Module Identifier for the IO module.. [optional]  # noqa: E501
            oper_reason ([str], none_type): [optional]  # noqa: E501
            oper_state (str): Operational state of IO card or fabric extender.. [optional]  # noqa: E501
            part_number (str): Part Number identifier for the IO module.. [optional]  # noqa: E501
            pid (str): This field identifies the Product ID for the IO module.. [optional]  # noqa: E501
            product_name (str): This field identifies the Product Name for the iocard module model.. [optional]  # noqa: E501
            sku (str): This field identifies the Stock Keeping Unit for the IO card module.. [optional]  # noqa: E501
            version (str): This field identifies the version of the IO card module.. [optional]  # noqa: E501
            vid (str): This field identifies the Vendor ID for the IO card module.. [optional]  # noqa: E501
            host_ports ([EtherHostPortRelationship], none_type): An array of relationships to etherHostPort resources.. [optional]  # noqa: E501
            mgmt_controller (ManagementControllerRelationship): [optional]  # noqa: E501
            network_ports ([EtherNetworkPortRelationship], none_type): An array of relationships to etherNetworkPort resources.. [optional]  # noqa: E501
            sub_group ([PortSubGroupRelationship], none_type): An array of relationships to portSubGroup resources.. [optional]  # noqa: E501
        """

        class_id = "equipment.IoCard" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "equipment.IoCard")
        object_type = "equipment.IoCard" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "equipment.IoCard")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              EquipmentIoCardAllOf,
              EquipmentIoCardBase,
          ],
          'oneOf': [
          ],
        }
