"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.network_element_relationship import NetworkElementRelationship
    globals()['NetworkElementRelationship'] = NetworkElementRelationship


class FabricAbstractSpanSessionAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'FABRIC.SPANSESSION': "fabric.SpanSession",
        },
        ('object_type',): {
            'FABRIC.SPANSESSION': "fabric.SpanSession",
        },
        ('admin_state',): {
            'DISABLED': "Disabled",
            'ENABLED': "Enabled",
        },
        ('config_state',): {
            'NONE': "None",
            'APPLIED': "Applied",
            'APPLYING': "Applying",
            'FAILED': "Failed",
        },
        ('oper_state',): {
            'UNKNOWN': "Unknown",
            'UP': "Up",
            'DOWN': "Down",
            'ERROR': "Error",
        },
        ('oper_state_reason',): {
            'UNKNOWN': "Unknown",
            'ACTIVE': "Active",
            'NOHARDWARERESOURCE': "NoHardwareResource",
            'NOOPERATIONALSRCDST': "NoOperationalSrcDst",
            'GENERICERROR': "GenericError",
            'NOSOURCESCONFIGURED': "NoSourcesConfigured",
            'NODESTINATIONCONFIGURED': "NoDestinationConfigured",
            'NOSOURCEDESTINATIONCONFIGURED': "NoSourceDestinationConfigured",
            'SESSIONADMINSHUT': "SessionAdminShut",
            'WRONGDESTINATIONMODE': "WrongDestinationMode",
            'WRONGSOURCEMODE': "WrongSourceMode",
            'TUNNELMISCONFDOWN': "TunnelMisconfDown",
            'NOFLOWIDSPECIFIED': "NoFlowIdSpecified",
        },
        ('span_control_packets',): {
            'DISABLED': "Disabled",
            'ENABLED': "Enabled",
        },
        ('switch_id',): {
            'A': "A",
            'B': "B",
        },
    }

    validations = {
        ('name',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9_.:-]{1,64}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'admin_state': (str,),  # noqa: E501
            'config_state': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'oper_state': (str,),  # noqa: E501
            'oper_state_reason': (str,),  # noqa: E501
            'session_id': (int,),  # noqa: E501
            'source_count': (int,),  # noqa: E501
            'span_control_packets': (str,),  # noqa: E501
            'switch_id': (str,),  # noqa: E501
            'network_element': (NetworkElementRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'admin_state': 'AdminState',  # noqa: E501
        'config_state': 'ConfigState',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'oper_state': 'OperState',  # noqa: E501
        'oper_state_reason': 'OperStateReason',  # noqa: E501
        'session_id': 'SessionId',  # noqa: E501
        'source_count': 'SourceCount',  # noqa: E501
        'span_control_packets': 'SpanControlPackets',  # noqa: E501
        'switch_id': 'SwitchId',  # noqa: E501
        'network_element': 'NetworkElement',  # noqa: E501
    }

    read_only_vars = {
        'config_state',  # noqa: E501
        'oper_state',  # noqa: E501
        'oper_state_reason',  # noqa: E501
        'session_id',  # noqa: E501
        'source_count',  # noqa: E501
        'switch_id',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """FabricAbstractSpanSessionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.. defaults to "fabric.SpanSession", must be one of ["fabric.SpanSession", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.. defaults to "fabric.SpanSession", must be one of ["fabric.SpanSession", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            admin_state (str): Admin state to enable or disable the SPAN session. * `Disabled` - Admin configured Disabled State. * `Enabled` - Admin configured Enabled State.. [optional] if omitted the server will use the default value of "Disabled"  # noqa: E501
            config_state (str): The configured state of SPAN configuration. If the configuration fails to deploy to the Fabric Interconnect, it can be redeployed by toggling the admin state. * `None` - Nil value when no action has been triggered by the user. * `Applied` - User configured settings are in applied state. * `Applying` - User settings are being applied on the target server. * `Failed` - User configured settings could not be applied.. [optional] if omitted the server will use the default value of "None"  # noqa: E501
            name (str): Name of the SPAN session. The name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.) or an underscore (_).. [optional]  # noqa: E501
            oper_state (str): Operational state of the SPAN session. * `Unknown` - SPAN session operational state is Unknown. * `Up` - SPAN session operational state is Up. * `Down` - SPAN session operational state is Down. * `Error` - SPAN session operational state is Error.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            oper_state_reason (str): Operational state reason of the SPAN session. * `Unknown` - Unknown operational state. * `Active` - Active and operational SPAN session. * `NoHardwareResource` - No hardware resources available. * `NoOperationalSrcDst` - No operational SPAN source or destination. * `GenericError` - Generic operational error. * `NoSourcesConfigured` - No source interfaces configured. * `NoDestinationConfigured` - No destination port configured. * `NoSourceDestinationConfigured` - No source or destination interface configured. * `SessionAdminShut` - Session is administratively disabled. * `WrongDestinationMode` - Wrong Destination mode configured. * `WrongSourceMode` - Wrong Source mode configured. * `TunnelMisconfDown` - Tunnel Misconfigured or Down. * `NoFlowIdSpecified` - No Flow ID specified for ERSPAN.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            session_id (int): Session ID identifies the SPAN session on the Fabric Interconnect.. [optional]  # noqa: E501
            source_count (int): Count of total number of sources in the SPAN session.. [optional]  # noqa: E501
            span_control_packets (str): Admin state to enable or disable spanning control packets. * `Disabled` - Admin configured Disabled State. * `Enabled` - Admin configured Enabled State.. [optional] if omitted the server will use the default value of "Disabled"  # noqa: E501
            switch_id (str): Switch ID (A or B) corresponding to network element. * `A` - Switch Identifier of Fabric Interconnect A. * `B` - Switch Identifier of Fabric Interconnect B.. [optional] if omitted the server will use the default value of "A"  # noqa: E501
            network_element (NetworkElementRelationship): [optional]  # noqa: E501
        """

        class_id = "fabric.SpanSession" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "fabric.SpanSession")
        object_type = "fabric.SpanSession" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "fabric.SpanSession")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """FabricAbstractSpanSessionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.. defaults to "fabric.SpanSession", must be one of ["fabric.SpanSession", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.. defaults to "fabric.SpanSession", must be one of ["fabric.SpanSession", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            admin_state (str): Admin state to enable or disable the SPAN session. * `Disabled` - Admin configured Disabled State. * `Enabled` - Admin configured Enabled State.. [optional] if omitted the server will use the default value of "Disabled"  # noqa: E501
            config_state (str): The configured state of SPAN configuration. If the configuration fails to deploy to the Fabric Interconnect, it can be redeployed by toggling the admin state. * `None` - Nil value when no action has been triggered by the user. * `Applied` - User configured settings are in applied state. * `Applying` - User settings are being applied on the target server. * `Failed` - User configured settings could not be applied.. [optional] if omitted the server will use the default value of "None"  # noqa: E501
            name (str): Name of the SPAN session. The name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.) or an underscore (_).. [optional]  # noqa: E501
            oper_state (str): Operational state of the SPAN session. * `Unknown` - SPAN session operational state is Unknown. * `Up` - SPAN session operational state is Up. * `Down` - SPAN session operational state is Down. * `Error` - SPAN session operational state is Error.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            oper_state_reason (str): Operational state reason of the SPAN session. * `Unknown` - Unknown operational state. * `Active` - Active and operational SPAN session. * `NoHardwareResource` - No hardware resources available. * `NoOperationalSrcDst` - No operational SPAN source or destination. * `GenericError` - Generic operational error. * `NoSourcesConfigured` - No source interfaces configured. * `NoDestinationConfigured` - No destination port configured. * `NoSourceDestinationConfigured` - No source or destination interface configured. * `SessionAdminShut` - Session is administratively disabled. * `WrongDestinationMode` - Wrong Destination mode configured. * `WrongSourceMode` - Wrong Source mode configured. * `TunnelMisconfDown` - Tunnel Misconfigured or Down. * `NoFlowIdSpecified` - No Flow ID specified for ERSPAN.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            session_id (int): Session ID identifies the SPAN session on the Fabric Interconnect.. [optional]  # noqa: E501
            source_count (int): Count of total number of sources in the SPAN session.. [optional]  # noqa: E501
            span_control_packets (str): Admin state to enable or disable spanning control packets. * `Disabled` - Admin configured Disabled State. * `Enabled` - Admin configured Enabled State.. [optional] if omitted the server will use the default value of "Disabled"  # noqa: E501
            switch_id (str): Switch ID (A or B) corresponding to network element. * `A` - Switch Identifier of Fabric Interconnect A. * `B` - Switch Identifier of Fabric Interconnect B.. [optional] if omitted the server will use the default value of "A"  # noqa: E501
            network_element (NetworkElementRelationship): [optional]  # noqa: E501
        """

        class_id = "fabric.SpanSession" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "fabric.SpanSession")
        object_type = "fabric.SpanSession" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "fabric.SpanSession")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
