"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025051220
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.functions_runtime_component import FunctionsRuntimeComponent
    from intersight.model.workflow_catalog_relationship import WorkflowCatalogRelationship
    globals()['FunctionsRuntimeComponent'] = FunctionsRuntimeComponent
    globals()['WorkflowCatalogRelationship'] = WorkflowCatalogRelationship


class FunctionsRuntimeAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'FUNCTIONS.RUNTIME': "functions.Runtime",
        },
        ('object_type',): {
            'FUNCTIONS.RUNTIME': "functions.Runtime",
        },
        ('action',): {
            'NONE': "None",
            'DISABLE': "Disable",
            'DEPRECATE': "Deprecate",
            'FLAGINSECURE': "FlagInsecure",
        },
        ('language_name',): {
            'PYTHON': "Python",
        },
    }

    validations = {
        ('code_file_name',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9]{1}[a-zA-Z0-9_.-]{0,63}$',  # noqa: E501
            },
        },
        ('display_name',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9]{1}[\sa-zA-Z0-9_.:-]{0,91}$',  # noqa: E501
            },
        },
        ('language_version',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9](.{0,62}\S)?$',  # noqa: E501
            },
        },
        ('name',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9]{1}[a-zA-Z0-9_.-]{0,63}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'action': (str,),  # noqa: E501
            'code_file_name': (str,),  # noqa: E501
            'code_template': (str,),  # noqa: E501
            'components': ([FunctionsRuntimeComponent], none_type,),  # noqa: E501
            'create_user': (str,),  # noqa: E501
            'deprecated': (bool,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'display_name': (str,),  # noqa: E501
            'enabled': (bool,),  # noqa: E501
            'insecure': (bool,),  # noqa: E501
            'language_name': (str,),  # noqa: E501
            'language_version': (str,),  # noqa: E501
            'mod_user': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'note': (str,),  # noqa: E501
            'runtime_file_path': (str,),  # noqa: E501
            'runtime_upload_moid': (str,),  # noqa: E501
            'catalog': (WorkflowCatalogRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'action': 'Action',  # noqa: E501
        'code_file_name': 'CodeFileName',  # noqa: E501
        'code_template': 'CodeTemplate',  # noqa: E501
        'components': 'Components',  # noqa: E501
        'create_user': 'CreateUser',  # noqa: E501
        'deprecated': 'Deprecated',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'display_name': 'DisplayName',  # noqa: E501
        'enabled': 'Enabled',  # noqa: E501
        'insecure': 'Insecure',  # noqa: E501
        'language_name': 'LanguageName',  # noqa: E501
        'language_version': 'LanguageVersion',  # noqa: E501
        'mod_user': 'ModUser',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'note': 'Note',  # noqa: E501
        'runtime_file_path': 'RuntimeFilePath',  # noqa: E501
        'runtime_upload_moid': 'RuntimeUploadMoid',  # noqa: E501
        'catalog': 'Catalog',  # noqa: E501
    }

    read_only_vars = {
        'create_user',  # noqa: E501
        'deprecated',  # noqa: E501
        'enabled',  # noqa: E501
        'insecure',  # noqa: E501
        'mod_user',  # noqa: E501
        'runtime_file_path',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """FunctionsRuntimeAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "functions.Runtime", must be one of ["functions.Runtime", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "functions.Runtime", must be one of ["functions.Runtime", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            action (str): Action against the Runtime. * `None` - No action is set, this is the default value for action field. * `Disable` - Disable an instance of a Runtime. * `Deprecate` - Deprecate an instance of a Runtime. * `FlagInsecure` - Flag an instance of a Runtime as insecure.. [optional] if omitted the server will use the default value of "None"  # noqa: E501
            code_file_name (str): Name of file containing function source code.. [optional]  # noqa: E501
            code_template (str): Template to guide on how to compose code.. [optional]  # noqa: E501
            components ([FunctionsRuntimeComponent], none_type): [optional]  # noqa: E501
            create_user (str): The user identifier who created the language runtime.. [optional]  # noqa: E501
            deprecated (bool): Indicate if this language runtime is deprecated.. [optional]  # noqa: E501
            description (str): Description of the language runtime.. [optional]  # noqa: E501
            display_name (str): The display name of the language runtime. Display name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:), space ( ) or an underscore (_).. [optional]  # noqa: E501
            enabled (bool): Indicate if this language runtime is enabled. If not, the runtime is not usable at all.. [optional]  # noqa: E501
            insecure (bool): Indicate if this language runtime is insecure due to vulnerabilities.. [optional]  # noqa: E501
            language_name (str): The official name of the programming language. * `Python` - Python programming language.. [optional] if omitted the server will use the default value of "Python"  # noqa: E501
            language_version (str): The version of the programming language.. [optional]  # noqa: E501
            mod_user (str): The user identifier who last updated the language runtime.. [optional]  # noqa: E501
            name (str): The name of the language runtime. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.) or an underscore (_).. [optional]  # noqa: E501
            note (str): A note to bring user's attention to the status of this language runtime.. [optional]  # noqa: E501
            runtime_file_path (str): Path to the runtime file.. [optional]  # noqa: E501
            runtime_upload_moid (str): Moid of Upload which represents the uploaded runtime file.. [optional]  # noqa: E501
            catalog (WorkflowCatalogRelationship): [optional]  # noqa: E501
        """

        class_id = "functions.Runtime" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "functions.Runtime")
        object_type = "functions.Runtime" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "functions.Runtime")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """FunctionsRuntimeAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "functions.Runtime", must be one of ["functions.Runtime", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "functions.Runtime", must be one of ["functions.Runtime", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            action (str): Action against the Runtime. * `None` - No action is set, this is the default value for action field. * `Disable` - Disable an instance of a Runtime. * `Deprecate` - Deprecate an instance of a Runtime. * `FlagInsecure` - Flag an instance of a Runtime as insecure.. [optional] if omitted the server will use the default value of "None"  # noqa: E501
            code_file_name (str): Name of file containing function source code.. [optional]  # noqa: E501
            code_template (str): Template to guide on how to compose code.. [optional]  # noqa: E501
            components ([FunctionsRuntimeComponent], none_type): [optional]  # noqa: E501
            create_user (str): The user identifier who created the language runtime.. [optional]  # noqa: E501
            deprecated (bool): Indicate if this language runtime is deprecated.. [optional]  # noqa: E501
            description (str): Description of the language runtime.. [optional]  # noqa: E501
            display_name (str): The display name of the language runtime. Display name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:), space ( ) or an underscore (_).. [optional]  # noqa: E501
            enabled (bool): Indicate if this language runtime is enabled. If not, the runtime is not usable at all.. [optional]  # noqa: E501
            insecure (bool): Indicate if this language runtime is insecure due to vulnerabilities.. [optional]  # noqa: E501
            language_name (str): The official name of the programming language. * `Python` - Python programming language.. [optional] if omitted the server will use the default value of "Python"  # noqa: E501
            language_version (str): The version of the programming language.. [optional]  # noqa: E501
            mod_user (str): The user identifier who last updated the language runtime.. [optional]  # noqa: E501
            name (str): The name of the language runtime. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.) or an underscore (_).. [optional]  # noqa: E501
            note (str): A note to bring user's attention to the status of this language runtime.. [optional]  # noqa: E501
            runtime_file_path (str): Path to the runtime file.. [optional]  # noqa: E501
            runtime_upload_moid (str): Moid of Upload which represents the uploaded runtime file.. [optional]  # noqa: E501
            catalog (WorkflowCatalogRelationship): [optional]  # noqa: E501
        """

        class_id = "functions.Runtime" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "functions.Runtime")
        object_type = "functions.Runtime" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "functions.Runtime")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
