"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.display_names import DisplayNames
    from intersight.model.hci_ahv_guest_tools import HciAhvGuestTools
    from intersight.model.hci_ahv_vm_all_of import HciAhvVmAllOf
    from intersight.model.hci_ahv_vm_disk_relationship import HciAhvVmDiskRelationship
    from intersight.model.hci_ahv_vm_gpu_relationship import HciAhvVmGpuRelationship
    from intersight.model.hci_ahv_vm_nic_relationship import HciAhvVmNicRelationship
    from intersight.model.hci_base_vm import HciBaseVm
    from intersight.model.hci_cluster_relationship import HciClusterRelationship
    from intersight.model.hci_node_relationship import HciNodeRelationship
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['DisplayNames'] = DisplayNames
    globals()['HciAhvGuestTools'] = HciAhvGuestTools
    globals()['HciAhvVmAllOf'] = HciAhvVmAllOf
    globals()['HciAhvVmDiskRelationship'] = HciAhvVmDiskRelationship
    globals()['HciAhvVmGpuRelationship'] = HciAhvVmGpuRelationship
    globals()['HciAhvVmNicRelationship'] = HciAhvVmNicRelationship
    globals()['HciBaseVm'] = HciBaseVm
    globals()['HciClusterRelationship'] = HciClusterRelationship
    globals()['HciNodeRelationship'] = HciNodeRelationship
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext


class HciAhvVm(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'HCI.AHVVM': "hci.AhvVm",
        },
        ('object_type',): {
            'HCI.AHVVM': "hci.AhvVm",
        },
        ('power_state',): {
            'UNDETERMINED': "UNDETERMINED",
            'OFF': "OFF",
            'ON': "ON",
            'PAUSED': "PAUSED",
            'SUSPENDED': "SUSPENDED",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'bios_uuid': (str,),  # noqa: E501
            'creation_time': (datetime,),  # noqa: E501
            'enabled_cpu_features': ([str], none_type,),  # noqa: E501
            'generation_uuid': (str,),  # noqa: E501
            'guest_tools': (HciAhvGuestTools,),  # noqa: E501
            'hardware_clock_timezone': (str,),  # noqa: E501
            'is_agent_vm': (bool,),  # noqa: E501
            'is_branding_enabled': (bool,),  # noqa: E501
            'is_cpu_hotplug_enabled': (bool,),  # noqa: E501
            'is_cpu_passthrough_enabled': (bool,),  # noqa: E501
            'is_cross_cluster_migration_in_progress': (bool,),  # noqa: E501
            'is_gpu_console_enabled': (bool,),  # noqa: E501
            'is_live_migrate_capable': (bool,),  # noqa: E501
            'is_memory_overcommit_enabled': (bool,),  # noqa: E501
            'is_scsi_controller_enabled': (bool,),  # noqa: E501
            'is_vcpu_hard_pinning_enabled': (bool,),  # noqa: E501
            'is_vga_console_enabled': (bool,),  # noqa: E501
            'is_vtpm_enabled': (bool,),  # noqa: E501
            'machine_type': (str,),  # noqa: E501
            'num_numa_nodes': (int,),  # noqa: E501
            'num_sockets': (int,),  # noqa: E501
            'num_threads_per_core': (int,),  # noqa: E501
            'protection_type': (str,),  # noqa: E501
            'source_uuid': (str,),  # noqa: E501
            'update_time': (datetime,),  # noqa: E501
            'vtpm_module_version': (str,),  # noqa: E501
            'disks': ([HciAhvVmDiskRelationship], none_type,),  # noqa: E501
            'gpus': ([HciAhvVmGpuRelationship], none_type,),  # noqa: E501
            'nics': ([HciAhvVmNicRelationship], none_type,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'cluster_ext_id': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'guest_os_name': (str,),  # noqa: E501
            'hypervisor_type': (str,),  # noqa: E501
            'memory_size_bytes': (int,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'node_ext_id': (str,),  # noqa: E501
            'num_cores_per_socket': (int,),  # noqa: E501
            'num_cpu_cores': (int,),  # noqa: E501
            'power_state': (str,),  # noqa: E501
            'vm_ext_id': (str,),  # noqa: E501
            'cluster': (HciClusterRelationship,),  # noqa: E501
            'node': (HciNodeRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        val = {
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'bios_uuid': 'BiosUuid',  # noqa: E501
        'creation_time': 'CreationTime',  # noqa: E501
        'enabled_cpu_features': 'EnabledCpuFeatures',  # noqa: E501
        'generation_uuid': 'GenerationUuid',  # noqa: E501
        'guest_tools': 'GuestTools',  # noqa: E501
        'hardware_clock_timezone': 'HardwareClockTimezone',  # noqa: E501
        'is_agent_vm': 'IsAgentVm',  # noqa: E501
        'is_branding_enabled': 'IsBrandingEnabled',  # noqa: E501
        'is_cpu_hotplug_enabled': 'IsCpuHotplugEnabled',  # noqa: E501
        'is_cpu_passthrough_enabled': 'IsCpuPassthroughEnabled',  # noqa: E501
        'is_cross_cluster_migration_in_progress': 'IsCrossClusterMigrationInProgress',  # noqa: E501
        'is_gpu_console_enabled': 'IsGpuConsoleEnabled',  # noqa: E501
        'is_live_migrate_capable': 'IsLiveMigrateCapable',  # noqa: E501
        'is_memory_overcommit_enabled': 'IsMemoryOvercommitEnabled',  # noqa: E501
        'is_scsi_controller_enabled': 'IsScsiControllerEnabled',  # noqa: E501
        'is_vcpu_hard_pinning_enabled': 'IsVcpuHardPinningEnabled',  # noqa: E501
        'is_vga_console_enabled': 'IsVgaConsoleEnabled',  # noqa: E501
        'is_vtpm_enabled': 'IsVtpmEnabled',  # noqa: E501
        'machine_type': 'MachineType',  # noqa: E501
        'num_numa_nodes': 'NumNumaNodes',  # noqa: E501
        'num_sockets': 'NumSockets',  # noqa: E501
        'num_threads_per_core': 'NumThreadsPerCore',  # noqa: E501
        'protection_type': 'ProtectionType',  # noqa: E501
        'source_uuid': 'SourceUuid',  # noqa: E501
        'update_time': 'UpdateTime',  # noqa: E501
        'vtpm_module_version': 'VtpmModuleVersion',  # noqa: E501
        'disks': 'Disks',  # noqa: E501
        'gpus': 'Gpus',  # noqa: E501
        'nics': 'Nics',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'cluster_ext_id': 'ClusterExtId',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'guest_os_name': 'GuestOsName',  # noqa: E501
        'hypervisor_type': 'HypervisorType',  # noqa: E501
        'memory_size_bytes': 'MemorySizeBytes',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'node_ext_id': 'NodeExtId',  # noqa: E501
        'num_cores_per_socket': 'NumCoresPerSocket',  # noqa: E501
        'num_cpu_cores': 'NumCpuCores',  # noqa: E501
        'power_state': 'PowerState',  # noqa: E501
        'vm_ext_id': 'VmExtId',  # noqa: E501
        'cluster': 'Cluster',  # noqa: E501
        'node': 'Node',  # noqa: E501
    }

    read_only_vars = {
        'bios_uuid',  # noqa: E501
        'creation_time',  # noqa: E501
        'generation_uuid',  # noqa: E501
        'hardware_clock_timezone',  # noqa: E501
        'is_agent_vm',  # noqa: E501
        'is_branding_enabled',  # noqa: E501
        'is_cpu_hotplug_enabled',  # noqa: E501
        'is_cpu_passthrough_enabled',  # noqa: E501
        'is_cross_cluster_migration_in_progress',  # noqa: E501
        'is_gpu_console_enabled',  # noqa: E501
        'is_live_migrate_capable',  # noqa: E501
        'is_memory_overcommit_enabled',  # noqa: E501
        'is_scsi_controller_enabled',  # noqa: E501
        'is_vcpu_hard_pinning_enabled',  # noqa: E501
        'is_vga_console_enabled',  # noqa: E501
        'is_vtpm_enabled',  # noqa: E501
        'machine_type',  # noqa: E501
        'num_numa_nodes',  # noqa: E501
        'num_sockets',  # noqa: E501
        'num_threads_per_core',  # noqa: E501
        'protection_type',  # noqa: E501
        'source_uuid',  # noqa: E501
        'update_time',  # noqa: E501
        'vtpm_module_version',  # noqa: E501
        'disks',  # noqa: E501
        'gpus',  # noqa: E501
        'nics',  # noqa: E501
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
        'cluster_ext_id',  # noqa: E501
        'description',  # noqa: E501
        'guest_os_name',  # noqa: E501
        'hypervisor_type',  # noqa: E501
        'memory_size_bytes',  # noqa: E501
        'name',  # noqa: E501
        'node_ext_id',  # noqa: E501
        'num_cores_per_socket',  # noqa: E501
        'num_cpu_cores',  # noqa: E501
        'power_state',  # noqa: E501
        'vm_ext_id',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """HciAhvVm - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "hci.AhvVm", must be one of ["hci.AhvVm", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "hci.AhvVm", must be one of ["hci.AhvVm", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            bios_uuid (str): The BIOS UUID of the VM, similar to physical server's serial number.. [optional]  # noqa: E501
            creation_time (datetime): The time the VM was created.. [optional]  # noqa: E501
            enabled_cpu_features ([str], none_type): [optional]  # noqa: E501
            generation_uuid (str): The generation UUID of the VM.. [optional]  # noqa: E501
            guest_tools (HciAhvGuestTools): [optional]  # noqa: E501
            hardware_clock_timezone (str): VM hardware clock timezone in IANA TZDB format (America/Los_Angeles).  Default: UTC.. [optional]  # noqa: E501
            is_agent_vm (bool): Indicates whether the VM is an agent VM or not. When their host enters maintenance mode, once the normal VMs are evacuated, the  agent VMs are powered off. When the host is restored, agent VMs  are powered on before the normal VMs are restored. In other words,  agent VMs cannot be HA-protected or live migrated.. [optional]  # noqa: E501
            is_branding_enabled (bool): Indicates whether to remove AHV branding from VM firmware tables or not.. [optional]  # noqa: E501
            is_cpu_hotplug_enabled (bool): The CPU hotplug status of the VM. It indicates whether the CPU  hotplug feature should be enabled for the VM or not. If enabled,  the VM can add or remove vCPUs while the VM is running.. [optional]  # noqa: E501
            is_cpu_passthrough_enabled (bool): The CPU passthrough status of the VM. It Indicates whether to passthrough the host CPU features to the guest or not.  Enabling this will make VM incapable of live migration.. [optional]  # noqa: E501
            is_cross_cluster_migration_in_progress (bool): Indicates whether the VM is in the process of cross cluster migration or not.. [optional]  # noqa: E501
            is_gpu_console_enabled (bool): The GPU console status of the VM. It indicates whether the GPU  console should be enabled for the VM or not. If enabled, the VM  will have access to the GPU console.. [optional]  # noqa: E501
            is_live_migrate_capable (bool): Indicates whether the VM is live migrate capable or not.  If the VM is not live migrate capable, it cannot be live migrated.. [optional]  # noqa: E501
            is_memory_overcommit_enabled (bool): The memory overcommit status of the VM. It indicates whether the memory overcommit feature should be enabled for the VM or not. If enabled, parts of the VM memory may reside outside of the  hypervisor physical memory. Once enabled, it should be expected  that the VM may suffer performance degradation.. [optional]  # noqa: E501
            is_scsi_controller_enabled (bool): The SCSI controller status of the VM. It indicates whether the  SCSI controller should be enabled for the VM or not. If enabled,  the VM will have access to the SCSI controller.. [optional]  # noqa: E501
            is_vcpu_hard_pinning_enabled (bool): The hard pinning status of the vCPU. It indicates whether the vCPUs  should be hard pinned to specific pCPUs or not.. [optional]  # noqa: E501
            is_vga_console_enabled (bool): Indicates whether to enable VGA console for the VM or not.. [optional]  # noqa: E501
            is_vtpm_enabled (bool): Indicates whether the VM has a virtual TPM enabled or not.. [optional]  # noqa: E501
            machine_type (str): The machine type of the VM. Possible values are PC, PSERIES, Q35.. [optional]  # noqa: E501
            num_numa_nodes (int): Number of NUMA nodes. 0 means NUMA is disabled.. [optional]  # noqa: E501
            num_sockets (int): The number of sockets of the VM.. [optional]  # noqa: E501
            num_threads_per_core (int): The number of threads per core of the VM.. [optional]  # noqa: E501
            protection_type (str): The type of protection applied on a VM.  Possible values are UNPROTECTED, PD_PROTECTED, and RULE_PROTECTED. PD_PROTECTED indicates a VM is protected using the Prism Element.  RULE_PROTECTED indicates a VM protection using the Prism Central.. [optional]  # noqa: E501
            source_uuid (str): The source UUID of the VM.. [optional]  # noqa: E501
            update_time (datetime): The time the VM was last updated.. [optional]  # noqa: E501
            vtpm_module_version (str): The version of the vTPM module.. [optional]  # noqa: E501
            disks ([HciAhvVmDiskRelationship], none_type): An array of relationships to hciAhvVmDisk resources.. [optional]  # noqa: E501
            gpus ([HciAhvVmGpuRelationship], none_type): An array of relationships to hciAhvVmGpu resources.. [optional]  # noqa: E501
            nics ([HciAhvVmNicRelationship], none_type): An array of relationships to hciAhvVmNic resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            cluster_ext_id (str): The unique identifier of the cluster which owns this VM.. [optional]  # noqa: E501
            description (str): The description of the VM.. [optional]  # noqa: E501
            guest_os_name (str): The guest OS name of the VM.. [optional]  # noqa: E501
            hypervisor_type (str): The hypervisor type of the given VM. It could be AHV, ESX etc.. [optional]  # noqa: E501
            memory_size_bytes (int): The memory size in bytes of the VM.. [optional]  # noqa: E501
            name (str): The name of the VM reported by the Prism Central.. [optional]  # noqa: E501
            node_ext_id (str): The unique identifier of the node.. [optional]  # noqa: E501
            num_cores_per_socket (int): The number of cores per socket of the VM.. [optional]  # noqa: E501
            num_cpu_cores (int): The number of CPU cores of the VM.. [optional]  # noqa: E501
            power_state (str): The power state of the VM. The possible values are ON, OFF, SUSPENDED (ESXi), PAUSED (AHV), UNDETERMINED. * `UNDETERMINED` - The VM power state is currently unknown. * `OFF` - The VM's power state is powered-off. * `ON` - The VM's power state is powered-on. * `PAUSED` - The VM's power state is paused, applicable only to AHV VM. * `SUSPENDED` - The VM's power state is suspended, applicable only to ESXi VM.. [optional] if omitted the server will use the default value of "UNDETERMINED"  # noqa: E501
            vm_ext_id (str): The unique identifier of the VM.. [optional]  # noqa: E501
            cluster (HciClusterRelationship): [optional]  # noqa: E501
            node (HciNodeRelationship): [optional]  # noqa: E501
        """

        class_id = "hci.AhvVm" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "hci.AhvVm")
        object_type = "hci.AhvVm" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "hci.AhvVm")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """HciAhvVm - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "hci.AhvVm", must be one of ["hci.AhvVm", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "hci.AhvVm", must be one of ["hci.AhvVm", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            bios_uuid (str): The BIOS UUID of the VM, similar to physical server's serial number.. [optional]  # noqa: E501
            creation_time (datetime): The time the VM was created.. [optional]  # noqa: E501
            enabled_cpu_features ([str], none_type): [optional]  # noqa: E501
            generation_uuid (str): The generation UUID of the VM.. [optional]  # noqa: E501
            guest_tools (HciAhvGuestTools): [optional]  # noqa: E501
            hardware_clock_timezone (str): VM hardware clock timezone in IANA TZDB format (America/Los_Angeles).  Default: UTC.. [optional]  # noqa: E501
            is_agent_vm (bool): Indicates whether the VM is an agent VM or not. When their host enters maintenance mode, once the normal VMs are evacuated, the  agent VMs are powered off. When the host is restored, agent VMs  are powered on before the normal VMs are restored. In other words,  agent VMs cannot be HA-protected or live migrated.. [optional]  # noqa: E501
            is_branding_enabled (bool): Indicates whether to remove AHV branding from VM firmware tables or not.. [optional]  # noqa: E501
            is_cpu_hotplug_enabled (bool): The CPU hotplug status of the VM. It indicates whether the CPU  hotplug feature should be enabled for the VM or not. If enabled,  the VM can add or remove vCPUs while the VM is running.. [optional]  # noqa: E501
            is_cpu_passthrough_enabled (bool): The CPU passthrough status of the VM. It Indicates whether to passthrough the host CPU features to the guest or not.  Enabling this will make VM incapable of live migration.. [optional]  # noqa: E501
            is_cross_cluster_migration_in_progress (bool): Indicates whether the VM is in the process of cross cluster migration or not.. [optional]  # noqa: E501
            is_gpu_console_enabled (bool): The GPU console status of the VM. It indicates whether the GPU  console should be enabled for the VM or not. If enabled, the VM  will have access to the GPU console.. [optional]  # noqa: E501
            is_live_migrate_capable (bool): Indicates whether the VM is live migrate capable or not.  If the VM is not live migrate capable, it cannot be live migrated.. [optional]  # noqa: E501
            is_memory_overcommit_enabled (bool): The memory overcommit status of the VM. It indicates whether the memory overcommit feature should be enabled for the VM or not. If enabled, parts of the VM memory may reside outside of the  hypervisor physical memory. Once enabled, it should be expected  that the VM may suffer performance degradation.. [optional]  # noqa: E501
            is_scsi_controller_enabled (bool): The SCSI controller status of the VM. It indicates whether the  SCSI controller should be enabled for the VM or not. If enabled,  the VM will have access to the SCSI controller.. [optional]  # noqa: E501
            is_vcpu_hard_pinning_enabled (bool): The hard pinning status of the vCPU. It indicates whether the vCPUs  should be hard pinned to specific pCPUs or not.. [optional]  # noqa: E501
            is_vga_console_enabled (bool): Indicates whether to enable VGA console for the VM or not.. [optional]  # noqa: E501
            is_vtpm_enabled (bool): Indicates whether the VM has a virtual TPM enabled or not.. [optional]  # noqa: E501
            machine_type (str): The machine type of the VM. Possible values are PC, PSERIES, Q35.. [optional]  # noqa: E501
            num_numa_nodes (int): Number of NUMA nodes. 0 means NUMA is disabled.. [optional]  # noqa: E501
            num_sockets (int): The number of sockets of the VM.. [optional]  # noqa: E501
            num_threads_per_core (int): The number of threads per core of the VM.. [optional]  # noqa: E501
            protection_type (str): The type of protection applied on a VM.  Possible values are UNPROTECTED, PD_PROTECTED, and RULE_PROTECTED. PD_PROTECTED indicates a VM is protected using the Prism Element.  RULE_PROTECTED indicates a VM protection using the Prism Central.. [optional]  # noqa: E501
            source_uuid (str): The source UUID of the VM.. [optional]  # noqa: E501
            update_time (datetime): The time the VM was last updated.. [optional]  # noqa: E501
            vtpm_module_version (str): The version of the vTPM module.. [optional]  # noqa: E501
            disks ([HciAhvVmDiskRelationship], none_type): An array of relationships to hciAhvVmDisk resources.. [optional]  # noqa: E501
            gpus ([HciAhvVmGpuRelationship], none_type): An array of relationships to hciAhvVmGpu resources.. [optional]  # noqa: E501
            nics ([HciAhvVmNicRelationship], none_type): An array of relationships to hciAhvVmNic resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            cluster_ext_id (str): The unique identifier of the cluster which owns this VM.. [optional]  # noqa: E501
            description (str): The description of the VM.. [optional]  # noqa: E501
            guest_os_name (str): The guest OS name of the VM.. [optional]  # noqa: E501
            hypervisor_type (str): The hypervisor type of the given VM. It could be AHV, ESX etc.. [optional]  # noqa: E501
            memory_size_bytes (int): The memory size in bytes of the VM.. [optional]  # noqa: E501
            name (str): The name of the VM reported by the Prism Central.. [optional]  # noqa: E501
            node_ext_id (str): The unique identifier of the node.. [optional]  # noqa: E501
            num_cores_per_socket (int): The number of cores per socket of the VM.. [optional]  # noqa: E501
            num_cpu_cores (int): The number of CPU cores of the VM.. [optional]  # noqa: E501
            power_state (str): The power state of the VM. The possible values are ON, OFF, SUSPENDED (ESXi), PAUSED (AHV), UNDETERMINED. * `UNDETERMINED` - The VM power state is currently unknown. * `OFF` - The VM's power state is powered-off. * `ON` - The VM's power state is powered-on. * `PAUSED` - The VM's power state is paused, applicable only to AHV VM. * `SUSPENDED` - The VM's power state is suspended, applicable only to ESXi VM.. [optional] if omitted the server will use the default value of "UNDETERMINED"  # noqa: E501
            vm_ext_id (str): The unique identifier of the VM.. [optional]  # noqa: E501
            cluster (HciClusterRelationship): [optional]  # noqa: E501
            node (HciNodeRelationship): [optional]  # noqa: E501
        """

        class_id = "hci.AhvVm" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "hci.AhvVm")
        object_type = "hci.AhvVm" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "hci.AhvVm")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              HciAhvVmAllOf,
              HciBaseVm,
          ],
          'oneOf': [
          ],
        }
