"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.iam_permission_relationship import IamPermissionRelationship
    from intersight.model.iam_switch_scope_permissions import IamSwitchScopePermissions
    from intersight.model.iam_user_relationship import IamUserRelationship
    from intersight.model.pkix_key_generation_spec import PkixKeyGenerationSpec
    globals()['IamPermissionRelationship'] = IamPermissionRelationship
    globals()['IamSwitchScopePermissions'] = IamSwitchScopePermissions
    globals()['IamUserRelationship'] = IamUserRelationship
    globals()['PkixKeyGenerationSpec'] = PkixKeyGenerationSpec


class IamApiKeyAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'IAM.APIKEY': "iam.ApiKey",
        },
        ('object_type',): {
            'IAM.APIKEY': "iam.ApiKey",
        },
        ('admin_status',): {
            'ENABLE': "enable",
            'DISABLE': "disable",
        },
        ('hash_algorithm',): {
            'SHA256': "SHA256",
            'SHA384': "SHA384",
            'SHA512': "SHA512",
            'SHA512_224': "SHA512_224",
            'SHA512_256': "SHA512_256",
        },
        ('oper_status',): {
            'ENABLED': "enabled",
            'DISABLED': "disabled",
            'EXPIRED': "expired",
        },
        ('signing_algorithm',): {
            'RSASSA-PKCS1-V1_5': "RSASSA-PKCS1-v1_5",
            'RSASSA-PSS': "RSASSA-PSS",
            'ED25519': "Ed25519",
            'ECDSA': "Ecdsa",
            'ECDSAP1363FORMAT': "EcdsaP1363Format",
        },
    }

    validations = {
        ('purpose',): {
            'max_length': 1024,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'admin_status': (str,),  # noqa: E501
            'expiry_date_time': (datetime,),  # noqa: E501
            'hash_algorithm': (str,),  # noqa: E501
            'is_never_expiring': (bool,),  # noqa: E501
            'key_spec': (PkixKeyGenerationSpec,),  # noqa: E501
            'last_used_ip': (str,),  # noqa: E501
            'last_used_time': (datetime,),  # noqa: E501
            'oper_status': (str,),  # noqa: E501
            'private_key': (str,),  # noqa: E501
            'purpose': (str,),  # noqa: E501
            'scope': (IamSwitchScopePermissions,),  # noqa: E501
            'signing_algorithm': (str,),  # noqa: E501
            'start_time': (datetime,),  # noqa: E501
            'permission': (IamPermissionRelationship,),  # noqa: E501
            'user': (IamUserRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'admin_status': 'AdminStatus',  # noqa: E501
        'expiry_date_time': 'ExpiryDateTime',  # noqa: E501
        'hash_algorithm': 'HashAlgorithm',  # noqa: E501
        'is_never_expiring': 'IsNeverExpiring',  # noqa: E501
        'key_spec': 'KeySpec',  # noqa: E501
        'last_used_ip': 'LastUsedIp',  # noqa: E501
        'last_used_time': 'LastUsedTime',  # noqa: E501
        'oper_status': 'OperStatus',  # noqa: E501
        'private_key': 'PrivateKey',  # noqa: E501
        'purpose': 'Purpose',  # noqa: E501
        'scope': 'Scope',  # noqa: E501
        'signing_algorithm': 'SigningAlgorithm',  # noqa: E501
        'start_time': 'StartTime',  # noqa: E501
        'permission': 'Permission',  # noqa: E501
        'user': 'User',  # noqa: E501
    }

    read_only_vars = {
        'last_used_ip',  # noqa: E501
        'last_used_time',  # noqa: E501
        'oper_status',  # noqa: E501
        'start_time',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """IamApiKeyAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "iam.ApiKey", must be one of ["iam.ApiKey", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "iam.ApiKey", must be one of ["iam.ApiKey", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            admin_status (str): Used to trigger the enable or disable action on the API key. These actions change the status of an API key. * `enable` - Used to enable a disabled API key/App Registration. If the API key/App Registration is already expired, this action has no effect. * `disable` - Used to disable an active API key/App Registration. If the API key/App Registration is already expired, this action has no effect.. [optional] if omitted the server will use the default value of "enable"  # noqa: E501
            expiry_date_time (datetime): The expiration date of the API key which is set at the time of creation of the key. Its value can only be assigned a date that falls within the range determined by the maximum expiration time configured at the account level. The expiry date can be edited to be earlier or later, provided it stays within the designated expiry period. This period is determined by adding the 'startTime' property of the API key to the maximum expiry time configured at the account level.. [optional]  # noqa: E501
            hash_algorithm (str): The cryptographic hash algorithm to calculate the message digest. * `SHA256` - The SHA-256 cryptographic hash, as defined by NIST in FIPS 180-4. * `SHA384` - The SHA-384 cryptographic hash, as defined by NIST in FIPS 180-4. * `SHA512` - The SHA-512 cryptographic hash, as defined by NIST in FIPS 180-4. * `SHA512_224` - The SHA-512/224 cryptographic hash, as defined by NIST in FIPS 180-4. * `SHA512_256` - The SHA-512/256 cryptographic hash, as defined by NIST in FIPS 180-4.. [optional] if omitted the server will use the default value of "SHA256"  # noqa: E501
            is_never_expiring (bool): Used to mark the API key as a never-expiring API key.. [optional] if omitted the server will use the default value of False  # noqa: E501
            key_spec (PkixKeyGenerationSpec): [optional]  # noqa: E501
            last_used_ip (str): The IP address from which the API key was last used.. [optional]  # noqa: E501
            last_used_time (datetime): The time at which the API key was last used. It is updated every 24 hours.. [optional]  # noqa: E501
            oper_status (str): The current status of the API key that dictates the validity of the key. * `enabled` - An API key/App Registration having enabled status can be used for API invocation. * `disabled` - An API key/App Registration having disabled status cannot be used for API invocation. * `expired` - An API key/App Registration having expired status cannot be used for API invocation as the expiration date has passed.. [optional] if omitted the server will use the default value of "enabled"  # noqa: E501
            private_key (str): Holds the private key for the API key.. [optional]  # noqa: E501
            purpose (str): The purpose of the API Key.. [optional]  # noqa: E501
            scope (IamSwitchScopePermissions): [optional]  # noqa: E501
            signing_algorithm (str): The signing algorithm used by the client to authenticate API requests to Intersight. The signing algorithm must be compatible with the key generation specification. * `RSASSA-PKCS1-v1_5` - RSASSA-PKCS1-v1_5 is a RSA signature scheme specified in [RFC 8017](https://tools.ietf.org/html/rfc8017).RSASSA-PKCS1-v1_5 is included only for compatibility with existing applications. * `RSASSA-PSS` - RSASSA-PSS is a RSA signature scheme specified in [RFC 8017](https://tools.ietf.org/html/rfc8017).It combines the RSASP1 and RSAVP1 primitives with the EMSA-PSS encoding method.In the interest of increased robustness, RSASSA-PSS is required in new applications. * `Ed25519` - The Ed25519 signature algorithm, as specified in [RFC 8032](https://tools.ietf.org/html/rfc8032).Ed25519 is a public-key signature system with several attractive features, includingfast single-signature verification, very fast signing, fast key generation and high security level. * `Ecdsa` - The Elliptic Curve Digital Signature Standard (ECDSA), as defined by NIST in FIPS 186-4 and ANSI X9.62.The signature is encoded as a ASN.1 DER SEQUENCE with two INTEGERs (r and s), as defined in RFC3279.When using ECDSA signatures, configure the client to use the same signature encoding as specified on the server side. * `EcdsaP1363Format` - The Elliptic Curve Digital Signature Standard (ECDSA), as defined by NIST in FIPS 186-4 and ANSI X9.62.The signature is the raw concatenation of r and s, as defined in the ISO/IEC 7816-8 IEEE P.1363 standard.In that format, r and s are represented as unsigned, big endian numbers.Extra padding bytes (of value 0x00) is applied so that both r and s encodings have the same size.When using ECDSA signatures, configure the client to use the same signature encoding as specified on the server side.. [optional] if omitted the server will use the default value of "RSASSA-PKCS1-v1_5"  # noqa: E501
            start_time (datetime): The timestamp at which an expiry date was first set on this API key. For expiring API keys, this field is same as the create time of the API key. For never-expiring API keys, this field is set initially to zero time value. If a never-expiry API key is later changed to have an expiration, the timestamp marking the start of this transition is recorded in this field.. [optional]  # noqa: E501
            permission (IamPermissionRelationship): [optional]  # noqa: E501
            user (IamUserRelationship): [optional]  # noqa: E501
        """

        class_id = "iam.ApiKey" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "iam.ApiKey")
        object_type = "iam.ApiKey" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "iam.ApiKey")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """IamApiKeyAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "iam.ApiKey", must be one of ["iam.ApiKey", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "iam.ApiKey", must be one of ["iam.ApiKey", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            admin_status (str): Used to trigger the enable or disable action on the API key. These actions change the status of an API key. * `enable` - Used to enable a disabled API key/App Registration. If the API key/App Registration is already expired, this action has no effect. * `disable` - Used to disable an active API key/App Registration. If the API key/App Registration is already expired, this action has no effect.. [optional] if omitted the server will use the default value of "enable"  # noqa: E501
            expiry_date_time (datetime): The expiration date of the API key which is set at the time of creation of the key. Its value can only be assigned a date that falls within the range determined by the maximum expiration time configured at the account level. The expiry date can be edited to be earlier or later, provided it stays within the designated expiry period. This period is determined by adding the 'startTime' property of the API key to the maximum expiry time configured at the account level.. [optional]  # noqa: E501
            hash_algorithm (str): The cryptographic hash algorithm to calculate the message digest. * `SHA256` - The SHA-256 cryptographic hash, as defined by NIST in FIPS 180-4. * `SHA384` - The SHA-384 cryptographic hash, as defined by NIST in FIPS 180-4. * `SHA512` - The SHA-512 cryptographic hash, as defined by NIST in FIPS 180-4. * `SHA512_224` - The SHA-512/224 cryptographic hash, as defined by NIST in FIPS 180-4. * `SHA512_256` - The SHA-512/256 cryptographic hash, as defined by NIST in FIPS 180-4.. [optional] if omitted the server will use the default value of "SHA256"  # noqa: E501
            is_never_expiring (bool): Used to mark the API key as a never-expiring API key.. [optional] if omitted the server will use the default value of False  # noqa: E501
            key_spec (PkixKeyGenerationSpec): [optional]  # noqa: E501
            last_used_ip (str): The IP address from which the API key was last used.. [optional]  # noqa: E501
            last_used_time (datetime): The time at which the API key was last used. It is updated every 24 hours.. [optional]  # noqa: E501
            oper_status (str): The current status of the API key that dictates the validity of the key. * `enabled` - An API key/App Registration having enabled status can be used for API invocation. * `disabled` - An API key/App Registration having disabled status cannot be used for API invocation. * `expired` - An API key/App Registration having expired status cannot be used for API invocation as the expiration date has passed.. [optional] if omitted the server will use the default value of "enabled"  # noqa: E501
            private_key (str): Holds the private key for the API key.. [optional]  # noqa: E501
            purpose (str): The purpose of the API Key.. [optional]  # noqa: E501
            scope (IamSwitchScopePermissions): [optional]  # noqa: E501
            signing_algorithm (str): The signing algorithm used by the client to authenticate API requests to Intersight. The signing algorithm must be compatible with the key generation specification. * `RSASSA-PKCS1-v1_5` - RSASSA-PKCS1-v1_5 is a RSA signature scheme specified in [RFC 8017](https://tools.ietf.org/html/rfc8017).RSASSA-PKCS1-v1_5 is included only for compatibility with existing applications. * `RSASSA-PSS` - RSASSA-PSS is a RSA signature scheme specified in [RFC 8017](https://tools.ietf.org/html/rfc8017).It combines the RSASP1 and RSAVP1 primitives with the EMSA-PSS encoding method.In the interest of increased robustness, RSASSA-PSS is required in new applications. * `Ed25519` - The Ed25519 signature algorithm, as specified in [RFC 8032](https://tools.ietf.org/html/rfc8032).Ed25519 is a public-key signature system with several attractive features, includingfast single-signature verification, very fast signing, fast key generation and high security level. * `Ecdsa` - The Elliptic Curve Digital Signature Standard (ECDSA), as defined by NIST in FIPS 186-4 and ANSI X9.62.The signature is encoded as a ASN.1 DER SEQUENCE with two INTEGERs (r and s), as defined in RFC3279.When using ECDSA signatures, configure the client to use the same signature encoding as specified on the server side. * `EcdsaP1363Format` - The Elliptic Curve Digital Signature Standard (ECDSA), as defined by NIST in FIPS 186-4 and ANSI X9.62.The signature is the raw concatenation of r and s, as defined in the ISO/IEC 7816-8 IEEE P.1363 standard.In that format, r and s are represented as unsigned, big endian numbers.Extra padding bytes (of value 0x00) is applied so that both r and s encodings have the same size.When using ECDSA signatures, configure the client to use the same signature encoding as specified on the server side.. [optional] if omitted the server will use the default value of "RSASSA-PKCS1-v1_5"  # noqa: E501
            start_time (datetime): The timestamp at which an expiry date was first set on this API key. For expiring API keys, this field is same as the create time of the API key. For never-expiring API keys, this field is set initially to zero time value. If a never-expiry API key is later changed to have an expiration, the timestamp marking the start of this transition is recorded in this field.. [optional]  # noqa: E501
            permission (IamPermissionRelationship): [optional]  # noqa: E501
            user (IamUserRelationship): [optional]  # noqa: E501
        """

        class_id = "iam.ApiKey" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "iam.ApiKey")
        object_type = "iam.ApiKey" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "iam.ApiKey")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
