"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError



class IamFeatureDefinitionAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'IAM.FEATUREDEFINITION': "iam.FeatureDefinition",
        },
        ('object_type',): {
            'IAM.FEATUREDEFINITION': "iam.FeatureDefinition",
        },
        ('feature',): {
            'IWO': "IWO",
            'HITACHI': "Hitachi",
            'KUBERNETESEXTENSION': "KubernetesExtension",
            'NETAPPIO': "NetAppIO",
            'IVSPUBLICCLOUD': "IvsPublicCloud",
            'TERRAFORMCLOUD': "TerraformCloud",
            'WASHINGTONEFT': "WashingtonEFT",
            'SOLUTIONS': "Solutions",
            'IKSBM': "IksBm",
            'NEXUSCLOUD': "NexusCloud",
            'NEXUSCLOUDTRIAL': "NexusCloudTrial",
            'NEXUSCLOUDUPGRADEASSIST': "NexusCloudUpgradeAssist",
            'NEXUSCLOUDSUSTAINABILITY': "NexusCloudSustainability",
            'PLATFORMUIREFRESH': "PlatformUIRefresh",
            'IKSGPU': "IksGpu",
            'IWOAPPSERVICEVERTICALSCALING': "IwoAppServiceVerticalScaling",
            'IWODATAEXPORTER': "IwoDataExporter",
            'IWOMIGRATE': "IwoMigrate",
            'NEXUSCLOUDTECHPREVIEWGOLD': "NexusCloudTechPreviewGold",
            'NEXUSCLOUDTECHPREVIEWSILVER': "NexusCloudTechPreviewSilver",
            'NEXUSCLOUDTECHPREVIEWBRONZE': "NexusCloudTechPreviewBronze",
            'DISCONNECTEDTARGETALARM': "DisconnectedTargetAlarm",
            'ASASERVICE': "AsAService",
            'EMEA': "EMEA",
            'CROSSPLATFORMNAVIGATION': "CrossPlatformNavigation",
            'WORKFLOWSPREVIEW': "WorkflowsPreview",
            'WORKFLOWSINTERSIGHTASSETS': "WorkflowsIntersightAssets",
            'MANUALKEKSUPPORT': "ManualKEKSupport",
            'FIRMWARECONSOLIDATIONEFT': "FirmwareConsolidationEFT",
            'FUNCTIONASASERVICE': "FunctionAsAService",
            'FI6664EFT': "FI6664EFT",
            'UNIFIEDEDGE': "UnifiedEdge",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'feature': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'feature': 'Feature',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """IamFeatureDefinitionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "iam.FeatureDefinition", must be one of ["iam.FeatureDefinition", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "iam.FeatureDefinition", must be one of ["iam.FeatureDefinition", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            feature (str): The beta feature that will be enabled for specific account. * `IWO` - Intersight Workflow Optimizer. * `Hitachi` - Support to claim Hitachi Storage arrays using the Intersight Orchestrator framework. * `KubernetesExtension` - Extension to the IKS and Adopted Clusters. * `NetAppIO` - Support to claim NetApp Storage arrays as IO targets. * `IvsPublicCloud` - Enables virtualization service for public clouds. * `TerraformCloud` - Enables an ability to create Terraform Cloud. * `WashingtonEFT` - Support for EFT customers to use Washington firmware images for upgrades. * `Solutions` - Support for managing solutions. * `IksBm` - Enables Intersight Kubernetes Service on Baremetal server. * `NexusCloud` - Enables Nexus Cloud services functionality. * `NexusCloudTrial` - Enables Nexus Cloud trial period. * `NexusCloudUpgradeAssist` - Enables Nexus Cloud upgrade assist. * `NexusCloudSustainability` - Enables Nexus Cloud sustainability. * `PlatformUIRefresh` - Enables platform refreshed UI with new service launcher. * `IksGpu` - Enables GPU support for Intersight Kubernetes Service. * `IwoAppServiceVerticalScaling` - Enables vertical Scaling of App Service Plans. * `IwoDataExporter` - Enables IWO Data Exporter component. * `IwoMigrate` - Enables IWO data Migration. * `NexusCloudTechPreviewGold` - Enable Nexus Cloud Preview of stable features, available for public consumption. * `NexusCloudTechPreviewSilver` - Enable Nexus Cloud Preview of beta features. This feature set is intended for consumption by internal audiences. * `NexusCloudTechPreviewBronze` - Enable Nexus Cloud Preview of features still in development. This feature set is intended for consumption by internal audiences. * `DisconnectedTargetAlarm` - Raise an alarm when a Target is disconnected from Intersight. Intersight is unable to manage disconnected Targets. * `AsAService` - Enable AsAService Preview of beta features. This feature set is intended for consumption by selective audiences. * `EMEA` - Enable all avaialble features on Intersight EMEA region. * `CrossPlatformNavigation` - Enable Cross-Platform Navigation on UI. * `WorkflowsPreview` - Enable Workflows preview for this account. * `WorkflowsIntersightAssets` - Enable workflow Intersight assets for this account. * `ManualKEKSupport` - Enable support for Manual key to enhance storage controller security for this account. * `FirmwareConsolidationEFT` - Enable usage of firmware images transitioned from CCO to Intersight. This feature set is intended for consumption by internal audiences. * `FunctionAsAService` - Enable the usage of the function as a service (faas) for Workflows. This feature set is intended for consumption by selective audiences. * `FI6664EFT` - Support for EFT customers to use FI-6664 in Port Policy. * `UnifiedEdge` - Enable Unified Edge related features for Avatar Platform.. [optional] if omitted the server will use the default value of "IWO"  # noqa: E501
        """

        class_id = "iam.FeatureDefinition" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "iam.FeatureDefinition")
        object_type = "iam.FeatureDefinition" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "iam.FeatureDefinition")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """IamFeatureDefinitionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "iam.FeatureDefinition", must be one of ["iam.FeatureDefinition", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "iam.FeatureDefinition", must be one of ["iam.FeatureDefinition", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            feature (str): The beta feature that will be enabled for specific account. * `IWO` - Intersight Workflow Optimizer. * `Hitachi` - Support to claim Hitachi Storage arrays using the Intersight Orchestrator framework. * `KubernetesExtension` - Extension to the IKS and Adopted Clusters. * `NetAppIO` - Support to claim NetApp Storage arrays as IO targets. * `IvsPublicCloud` - Enables virtualization service for public clouds. * `TerraformCloud` - Enables an ability to create Terraform Cloud. * `WashingtonEFT` - Support for EFT customers to use Washington firmware images for upgrades. * `Solutions` - Support for managing solutions. * `IksBm` - Enables Intersight Kubernetes Service on Baremetal server. * `NexusCloud` - Enables Nexus Cloud services functionality. * `NexusCloudTrial` - Enables Nexus Cloud trial period. * `NexusCloudUpgradeAssist` - Enables Nexus Cloud upgrade assist. * `NexusCloudSustainability` - Enables Nexus Cloud sustainability. * `PlatformUIRefresh` - Enables platform refreshed UI with new service launcher. * `IksGpu` - Enables GPU support for Intersight Kubernetes Service. * `IwoAppServiceVerticalScaling` - Enables vertical Scaling of App Service Plans. * `IwoDataExporter` - Enables IWO Data Exporter component. * `IwoMigrate` - Enables IWO data Migration. * `NexusCloudTechPreviewGold` - Enable Nexus Cloud Preview of stable features, available for public consumption. * `NexusCloudTechPreviewSilver` - Enable Nexus Cloud Preview of beta features. This feature set is intended for consumption by internal audiences. * `NexusCloudTechPreviewBronze` - Enable Nexus Cloud Preview of features still in development. This feature set is intended for consumption by internal audiences. * `DisconnectedTargetAlarm` - Raise an alarm when a Target is disconnected from Intersight. Intersight is unable to manage disconnected Targets. * `AsAService` - Enable AsAService Preview of beta features. This feature set is intended for consumption by selective audiences. * `EMEA` - Enable all avaialble features on Intersight EMEA region. * `CrossPlatformNavigation` - Enable Cross-Platform Navigation on UI. * `WorkflowsPreview` - Enable Workflows preview for this account. * `WorkflowsIntersightAssets` - Enable workflow Intersight assets for this account. * `ManualKEKSupport` - Enable support for Manual key to enhance storage controller security for this account. * `FirmwareConsolidationEFT` - Enable usage of firmware images transitioned from CCO to Intersight. This feature set is intended for consumption by internal audiences. * `FunctionAsAService` - Enable the usage of the function as a service (faas) for Workflows. This feature set is intended for consumption by selective audiences. * `FI6664EFT` - Support for EFT customers to use FI-6664 in Port Policy. * `UnifiedEdge` - Enable Unified Edge related features for Avatar Platform.. [optional] if omitted the server will use the default value of "IWO"  # noqa: E501
        """

        class_id = "iam.FeatureDefinition" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "iam.FeatureDefinition")
        object_type = "iam.FeatureDefinition" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "iam.FeatureDefinition")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
