"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.aaa_user_agent import AaaUserAgent
    from intersight.model.access_address_type import AccessAddressType
    from intersight.model.access_configuration_type import AccessConfigurationType
    from intersight.model.adapter_adapter_config import AdapterAdapterConfig
    from intersight.model.adapter_dce_interface_settings import AdapterDceInterfaceSettings
    from intersight.model.adapter_eth_settings import AdapterEthSettings
    from intersight.model.adapter_fc_settings import AdapterFcSettings
    from intersight.model.adapter_physical_nic_mode_settings import AdapterPhysicalNicModeSettings
    from intersight.model.adapter_port_channel_settings import AdapterPortChannelSettings
    from intersight.model.apic_fabric_leaf_node_details import ApicFabricLeafNodeDetails
    from intersight.model.appliance_api_status import ApplianceApiStatus
    from intersight.model.appliance_cert_renewal_phase import ApplianceCertRenewalPhase
    from intersight.model.appliance_cluster_install_phase import ApplianceClusterInstallPhase
    from intersight.model.appliance_key_value_pair import ApplianceKeyValuePair
    from intersight.model.appliance_metadata_manifest_version import ApplianceMetadataManifestVersion
    from intersight.model.appliance_network_status import ApplianceNetworkStatus
    from intersight.model.appliance_node_ip_info import ApplianceNodeIpInfo
    from intersight.model.appliance_status_check import ApplianceStatusCheck
    from intersight.model.asset_address_information import AssetAddressInformation
    from intersight.model.asset_alarm_summary import AssetAlarmSummary
    from intersight.model.asset_api_key_credential import AssetApiKeyCredential
    from intersight.model.asset_claim_signature import AssetClaimSignature
    from intersight.model.asset_client_certificate_credential import AssetClientCertificateCredential
    from intersight.model.asset_cloud_connection import AssetCloudConnection
    from intersight.model.asset_connection import AssetConnection
    from intersight.model.asset_connection_flap_status import AssetConnectionFlapStatus
    from intersight.model.asset_contract_information import AssetContractInformation
    from intersight.model.asset_credential import AssetCredential
    from intersight.model.asset_customer_information import AssetCustomerInformation
    from intersight.model.asset_deployment_alarm_info import AssetDeploymentAlarmInfo
    from intersight.model.asset_deployment_device_alarm_info import AssetDeploymentDeviceAlarmInfo
    from intersight.model.asset_deployment_device_information import AssetDeploymentDeviceInformation
    from intersight.model.asset_device_endpoint_local_credential import AssetDeviceEndpointLocalCredential
    from intersight.model.asset_device_information import AssetDeviceInformation
    from intersight.model.asset_device_statistics import AssetDeviceStatistics
    from intersight.model.asset_device_transaction import AssetDeviceTransaction
    from intersight.model.asset_generic_target_claim_options import AssetGenericTargetClaimOptions
    from intersight.model.asset_global_ultimate import AssetGlobalUltimate
    from intersight.model.asset_google_cloud_platform_service_account_key_credential import AssetGoogleCloudPlatformServiceAccountKeyCredential
    from intersight.model.asset_http_connection import AssetHttpConnection
    from intersight.model.asset_intersight_device_connector_connection import AssetIntersightDeviceConnectorConnection
    from intersight.model.asset_meraki_cloud_options import AssetMerakiCloudOptions
    from intersight.model.asset_metering_type import AssetMeteringType
    from intersight.model.asset_new_relic_credential import AssetNewRelicCredential
    from intersight.model.asset_no_authentication_credential import AssetNoAuthenticationCredential
    from intersight.model.asset_oauth_bearer_token_credential import AssetOauthBearerTokenCredential
    from intersight.model.asset_oauth_client_id_secret_credential import AssetOauthClientIdSecretCredential
    from intersight.model.asset_orchestration_civp_vmware_vcenter_options import AssetOrchestrationCivpVmwareVcenterOptions
    from intersight.model.asset_orchestration_hitachi_virtual_storage_platform_options import AssetOrchestrationHitachiVirtualStoragePlatformOptions
    from intersight.model.asset_orchestration_hsm_vmware_vcenter_options import AssetOrchestrationHsmVmwareVcenterOptions
    from intersight.model.asset_orchestration_service import AssetOrchestrationService
    from intersight.model.asset_parent_connection_signature import AssetParentConnectionSignature
    from intersight.model.asset_private_key_credential import AssetPrivateKeyCredential
    from intersight.model.asset_product_information import AssetProductInformation
    from intersight.model.asset_scoped_target_connection import AssetScopedTargetConnection
    from intersight.model.asset_service import AssetService
    from intersight.model.asset_service_now_credential import AssetServiceNowCredential
    from intersight.model.asset_service_options import AssetServiceOptions
    from intersight.model.asset_ssh_connection import AssetSshConnection
    from intersight.model.asset_sudi_info import AssetSudiInfo
    from intersight.model.asset_target_key import AssetTargetKey
    from intersight.model.asset_target_signature import AssetTargetSignature
    from intersight.model.asset_target_status_details import AssetTargetStatusDetails
    from intersight.model.asset_terraform_integration_service import AssetTerraformIntegrationService
    from intersight.model.asset_terraform_integration_terraform_agent_options import AssetTerraformIntegrationTerraformAgentOptions
    from intersight.model.asset_terraform_integration_terraform_cloud_options import AssetTerraformIntegrationTerraformCloudOptions
    from intersight.model.asset_username_password_credential import AssetUsernamePasswordCredential
    from intersight.model.asset_virtualization_amazon_web_service_options import AssetVirtualizationAmazonWebServiceOptions
    from intersight.model.asset_virtualization_cloud_options import AssetVirtualizationCloudOptions
    from intersight.model.asset_virtualization_service import AssetVirtualizationService
    from intersight.model.asset_vm_host import AssetVmHost
    from intersight.model.asset_workload_optimizer_amazon_web_services_billing_options import AssetWorkloadOptimizerAmazonWebServicesBillingOptions
    from intersight.model.asset_workload_optimizer_dynatrace_options import AssetWorkloadOptimizerDynatraceOptions
    from intersight.model.asset_workload_optimizer_google_cloud_platform_billing_options import AssetWorkloadOptimizerGoogleCloudPlatformBillingOptions
    from intersight.model.asset_workload_optimizer_hyperv_options import AssetWorkloadOptimizerHypervOptions
    from intersight.model.asset_workload_optimizer_microsoft_azure_application_insights_options import AssetWorkloadOptimizerMicrosoftAzureApplicationInsightsOptions
    from intersight.model.asset_workload_optimizer_microsoft_azure_billing_options import AssetWorkloadOptimizerMicrosoftAzureBillingOptions
    from intersight.model.asset_workload_optimizer_microsoft_azure_enterprise_agreement_options import AssetWorkloadOptimizerMicrosoftAzureEnterpriseAgreementOptions
    from intersight.model.asset_workload_optimizer_microsoft_azure_service_principal_options import AssetWorkloadOptimizerMicrosoftAzureServicePrincipalOptions
    from intersight.model.asset_workload_optimizer_microsoft_sql_server_options import AssetWorkloadOptimizerMicrosoftSqlServerOptions
    from intersight.model.asset_workload_optimizer_new_relic_options import AssetWorkloadOptimizerNewRelicOptions
    from intersight.model.asset_workload_optimizer_open_stack_options import AssetWorkloadOptimizerOpenStackOptions
    from intersight.model.asset_workload_optimizer_oracle_database_server_options import AssetWorkloadOptimizerOracleDatabaseServerOptions
    from intersight.model.asset_workload_optimizer_red_hat_open_stack_options import AssetWorkloadOptimizerRedHatOpenStackOptions
    from intersight.model.asset_workload_optimizer_service import AssetWorkloadOptimizerService
    from intersight.model.asset_workload_optimizer_vmware_vcenter_options import AssetWorkloadOptimizerVmwareVcenterOptions
    from intersight.model.blueprint_base_generated_object_source_from_selector import BlueprintBaseGeneratedObjectSourceFromSelector
    from intersight.model.blueprint_base_generated_object_source_metadata import BlueprintBaseGeneratedObjectSourceMetadata
    from intersight.model.blueprint_blueprint_definition_dependency import BlueprintBlueprintDefinitionDependency
    from intersight.model.blueprint_generated_object_metadata import BlueprintGeneratedObjectMetadata
    from intersight.model.blueprint_generated_object_new import BlueprintGeneratedObjectNew
    from intersight.model.blueprint_generated_object_operation_target import BlueprintGeneratedObjectOperationTarget
    from intersight.model.blueprint_generated_object_source_clone import BlueprintGeneratedObjectSourceClone
    from intersight.model.blueprint_generated_object_source_lookup import BlueprintGeneratedObjectSourceLookup
    from intersight.model.blueprint_generated_object_source_merge import BlueprintGeneratedObjectSourceMerge
    from intersight.model.blueprint_generated_object_source_reference import BlueprintGeneratedObjectSourceReference
    from intersight.model.blueprint_generated_object_source_selector import BlueprintGeneratedObjectSourceSelector
    from intersight.model.blueprint_input_operation_type import BlueprintInputOperationType
    from intersight.model.blueprint_pre_generate_operation import BlueprintPreGenerateOperation
    from intersight.model.blueprint_property_iteration import BlueprintPropertyIteration
    from intersight.model.blueprint_resource_constraints import BlueprintResourceConstraints
    from intersight.model.blueprint_service_item_definition import BlueprintServiceItemDefinition
    from intersight.model.boot_bootloader import BootBootloader
    from intersight.model.boot_device_base import BootDeviceBase
    from intersight.model.boot_flex_mmc import BootFlexMmc
    from intersight.model.boot_http import BootHttp
    from intersight.model.boot_iscsi import BootIscsi
    from intersight.model.boot_local_cdd import BootLocalCdd
    from intersight.model.boot_local_disk import BootLocalDisk
    from intersight.model.boot_nvme import BootNvme
    from intersight.model.boot_pch_storage import BootPchStorage
    from intersight.model.boot_pxe import BootPxe
    from intersight.model.boot_san import BootSan
    from intersight.model.boot_sd_card import BootSdCard
    from intersight.model.boot_static_ip_v4_settings import BootStaticIpV4Settings
    from intersight.model.boot_static_ip_v6_settings import BootStaticIpV6Settings
    from intersight.model.boot_uefi_shell import BootUefiShell
    from intersight.model.boot_usb import BootUsb
    from intersight.model.boot_virtual_media import BootVirtualMedia
    from intersight.model.bulk_api_result import BulkApiResult
    from intersight.model.bulk_http_header import BulkHttpHeader
    from intersight.model.bulk_multi_relation_entry_patch import BulkMultiRelationEntryPatch
    from intersight.model.bulk_patch_content import BulkPatchContent
    from intersight.model.bulk_rest_result import BulkRestResult
    from intersight.model.bulk_rest_sub_request import BulkRestSubRequest
    from intersight.model.bulk_sec_resource_roles import BulkSecResourceRoles
    from intersight.model.bulk_sub_request import BulkSubRequest
    from intersight.model.capability_certificate_property_constraints import CapabilityCertificatePropertyConstraints
    from intersight.model.capability_feature_config import CapabilityFeatureConfig
    from intersight.model.capability_hsu_iso_model_specific_constraint import CapabilityHsuIsoModelSpecificConstraint
    from intersight.model.capability_ldap_base_property_constraints import CapabilityLdapBasePropertyConstraints
    from intersight.model.capability_pc_id_range import CapabilityPcIdRange
    from intersight.model.capability_port_range import CapabilityPortRange
    from intersight.model.capability_server_component_constraint import CapabilityServerComponentConstraint
    from intersight.model.capability_switch_network_limits import CapabilitySwitchNetworkLimits
    from intersight.model.capability_switch_storage_limits import CapabilitySwitchStorageLimits
    from intersight.model.capability_switch_system_limits import CapabilitySwitchSystemLimits
    from intersight.model.capability_switching_mode_capability import CapabilitySwitchingModeCapability
    from intersight.model.capability_unsupported_feature_config import CapabilityUnsupportedFeatureConfig
    from intersight.model.capability_update_order_list_type import CapabilityUpdateOrderListType
    from intersight.model.certificatemanagement_certificate_base import CertificatemanagementCertificateBase
    from intersight.model.certificatemanagement_imc import CertificatemanagementImc
    from intersight.model.certificatemanagement_root_ca_certificate import CertificatemanagementRootCaCertificate
    from intersight.model.cloud_tfc_workspace_variables import CloudTfcWorkspaceVariables
    from intersight.model.cmrf_cm_rf import CmrfCmRf
    from intersight.model.comm_geo_location_details import CommGeoLocationDetails
    from intersight.model.comm_geo_point import CommGeoPoint
    from intersight.model.comm_ip_v4_address_block import CommIpV4AddressBlock
    from intersight.model.comm_ip_v4_interface import CommIpV4Interface
    from intersight.model.comm_ip_v6_interface import CommIpV6Interface
    from intersight.model.comm_physical_address import CommPhysicalAddress
    from intersight.model.comm_tag_usage import CommTagUsage
    from intersight.model.compute_alarm_summary import ComputeAlarmSummary
    from intersight.model.compute_host_utility_operation_confguration import ComputeHostUtilityOperationConfguration
    from intersight.model.compute_ip_address import ComputeIpAddress
    from intersight.model.compute_pending_workflow_trigger import ComputePendingWorkflowTrigger
    from intersight.model.compute_persistent_memory_module import ComputePersistentMemoryModule
    from intersight.model.compute_persistent_memory_operation import ComputePersistentMemoryOperation
    from intersight.model.compute_personality_setting import ComputePersonalitySetting
    from intersight.model.compute_scrub_op_configutation import ComputeScrubOpConfigutation
    from intersight.model.compute_server_config import ComputeServerConfig
    from intersight.model.compute_server_op_status import ComputeServerOpStatus
    from intersight.model.compute_storage_controller_operation import ComputeStorageControllerOperation
    from intersight.model.compute_storage_physical_drive import ComputeStoragePhysicalDrive
    from intersight.model.compute_storage_physical_drive_operation import ComputeStoragePhysicalDriveOperation
    from intersight.model.compute_storage_utility_image_operation import ComputeStorageUtilityImageOperation
    from intersight.model.compute_storage_virtual_drive import ComputeStorageVirtualDrive
    from intersight.model.compute_storage_virtual_drive_operation import ComputeStorageVirtualDriveOperation
    from intersight.model.cond_alarm_action import CondAlarmAction
    from intersight.model.cond_alarm_classification_eligibility import CondAlarmClassificationEligibility
    from intersight.model.cond_alarm_spec import CondAlarmSpec
    from intersight.model.cond_alarm_summary import CondAlarmSummary
    from intersight.model.connector_auth_message import ConnectorAuthMessage
    from intersight.model.connector_base_message import ConnectorBaseMessage
    from intersight.model.connector_close_stream_message import ConnectorCloseStreamMessage
    from intersight.model.connector_command_control_message import ConnectorCommandControlMessage
    from intersight.model.connector_command_terminal_stream import ConnectorCommandTerminalStream
    from intersight.model.connector_event_log import ConnectorEventLog
    from intersight.model.connector_expect_prompt import ConnectorExpectPrompt
    from intersight.model.connector_fetch_stream_message import ConnectorFetchStreamMessage
    from intersight.model.connector_file_checksum import ConnectorFileChecksum
    from intersight.model.connector_file_message import ConnectorFileMessage
    from intersight.model.connector_http_request import ConnectorHttpRequest
    from intersight.model.connector_platform_param_base import ConnectorPlatformParamBase
    from intersight.model.connector_ssh_config import ConnectorSshConfig
    from intersight.model.connector_ssh_message import ConnectorSshMessage
    from intersight.model.connector_start_stream import ConnectorStartStream
    from intersight.model.connector_start_stream_from_device import ConnectorStartStreamFromDevice
    from intersight.model.connector_stream_acknowledge import ConnectorStreamAcknowledge
    from intersight.model.connector_stream_input import ConnectorStreamInput
    from intersight.model.connector_stream_keepalive import ConnectorStreamKeepalive
    from intersight.model.connector_stream_message import ConnectorStreamMessage
    from intersight.model.connector_target_change_message import ConnectorTargetChangeMessage
    from intersight.model.connector_target_specification import ConnectorTargetSpecification
    from intersight.model.connector_url import ConnectorUrl
    from intersight.model.connector_winrm_request import ConnectorWinrmRequest
    from intersight.model.connector_xml_api_message import ConnectorXmlApiMessage
    from intersight.model.connectorpack_connector_pack_update import ConnectorpackConnectorPackUpdate
    from intersight.model.content_base_parameter import ContentBaseParameter
    from intersight.model.content_complex_type import ContentComplexType
    from intersight.model.content_parameter import ContentParameter
    from intersight.model.content_text_parameter import ContentTextParameter
    from intersight.model.convergedinfra_alarm_summary import ConvergedinfraAlarmSummary
    from intersight.model.convergedinfra_base_pod_summary import ConvergedinfraBasePodSummary
    from intersight.model.convergedinfra_compliance_summary import ConvergedinfraComplianceSummary
    from intersight.model.convergedinfra_pod_summary import ConvergedinfraPodSummary
    from intersight.model.crd_custom_resource_config_property import CrdCustomResourceConfigProperty
    from intersight.model.equipment_chassis_operation_status import EquipmentChassisOperationStatus
    from intersight.model.equipment_device_location import EquipmentDeviceLocation
    from intersight.model.equipment_io_card_identity import EquipmentIoCardIdentity
    from intersight.model.equipment_io_card_operation_status import EquipmentIoCardOperationStatus
    from intersight.model.equipment_reset_action import EquipmentResetAction
    from intersight.model.ether_macsec_oper_data import EtherMacsecOperData
    from intersight.model.fabric_cluster_assignment import FabricClusterAssignment
    from intersight.model.fabric_fc_zone_member import FabricFcZoneMember
    from intersight.model.fabric_lldp_settings import FabricLldpSettings
    from intersight.model.fabric_mac_aging_settings import FabricMacAgingSettings
    from intersight.model.fabric_mac_sec_ea_pol import FabricMacSecEaPol
    from intersight.model.fabric_port_identifier import FabricPortIdentifier
    from intersight.model.fabric_qos_class import FabricQosClass
    from intersight.model.fabric_sec_key import FabricSecKey
    from intersight.model.fabric_sec_key_chain import FabricSecKeyChain
    from intersight.model.fabric_udld_global_settings import FabricUdldGlobalSettings
    from intersight.model.fabric_udld_settings import FabricUdldSettings
    from intersight.model.fabric_vlan_settings import FabricVlanSettings
    from intersight.model.fcpool_block import FcpoolBlock
    from intersight.model.fcpool_reservation_reference import FcpoolReservationReference
    from intersight.model.feedback_feedback_data import FeedbackFeedbackData
    from intersight.model.firmware_base_impact import FirmwareBaseImpact
    from intersight.model.firmware_chassis_upgrade_impact import FirmwareChassisUpgradeImpact
    from intersight.model.firmware_cifs_server import FirmwareCifsServer
    from intersight.model.firmware_component_impact import FirmwareComponentImpact
    from intersight.model.firmware_component_meta import FirmwareComponentMeta
    from intersight.model.firmware_direct_download import FirmwareDirectDownload
    from intersight.model.firmware_exclude_component_pid_list_type import FirmwareExcludeComponentPidListType
    from intersight.model.firmware_fabric_upgrade_impact import FirmwareFabricUpgradeImpact
    from intersight.model.firmware_feature_version_map import FirmwareFeatureVersionMap
    from intersight.model.firmware_firmware_inventory import FirmwareFirmwareInventory
    from intersight.model.firmware_http_server import FirmwareHttpServer
    from intersight.model.firmware_model_bundle_version import FirmwareModelBundleVersion
    from intersight.model.firmware_network_share import FirmwareNetworkShare
    from intersight.model.firmware_nfs_server import FirmwareNfsServer
    from intersight.model.firmware_server_upgrade_impact import FirmwareServerUpgradeImpact
    from intersight.model.firmware_version_map import FirmwareVersionMap
    from intersight.model.forecast_model import ForecastModel
    from intersight.model.hci_ahv_guest_tools import HciAhvGuestTools
    from intersight.model.hci_alarm_parameter import HciAlarmParameter
    from intersight.model.hci_alarm_summary import HciAlarmSummary
    from intersight.model.hci_api_limit import HciApiLimit
    from intersight.model.hci_backplane_network_params import HciBackplaneNetworkParams
    from intersight.model.hci_capacity_violation import HciCapacityViolation
    from intersight.model.hci_consumption import HciConsumption
    from intersight.model.hci_entitlement_detail import HciEntitlementDetail
    from intersight.model.hci_esxi_guest_tools import HciEsxiGuestTools
    from intersight.model.hci_expired_license import HciExpiredLicense
    from intersight.model.hci_fault_tolerance_state import HciFaultToleranceState
    from intersight.model.hci_feature_violation import HciFeatureViolation
    from intersight.model.hci_ip_address import HciIpAddress
    from intersight.model.hci_ip_address_or_fqdn import HciIpAddressOrFqdn
    from intersight.model.hci_key_management_device_to_cert_status_info import HciKeyManagementDeviceToCertStatusInfo
    from intersight.model.hci_licensed_service import HciLicensedService
    from intersight.model.hci_management_server import HciManagementServer
    from intersight.model.hci_pulse_status import HciPulseStatus
    from intersight.model.hci_sbdf import HciSbdf
    from intersight.model.hci_service_violation import HciServiceViolation
    from intersight.model.hci_software_type import HciSoftwareType
    from intersight.model.hci_virtual_gpu_config import HciVirtualGpuConfig
    from intersight.model.hcl_constraint import HclConstraint
    from intersight.model.hcl_firmware import HclFirmware
    from intersight.model.hcl_hardware_compatibility_profile import HclHardwareCompatibilityProfile
    from intersight.model.hcl_product import HclProduct
    from intersight.model.hyperflex_abstract_app_setting import HyperflexAbstractAppSetting
    from intersight.model.hyperflex_alarm_summary import HyperflexAlarmSummary
    from intersight.model.hyperflex_app_setting_constraint import HyperflexAppSettingConstraint
    from intersight.model.hyperflex_backup_policy_settings import HyperflexBackupPolicySettings
    from intersight.model.hyperflex_capability import HyperflexCapability
    from intersight.model.hyperflex_datastore_info import HyperflexDatastoreInfo
    from intersight.model.hyperflex_entity_reference import HyperflexEntityReference
    from intersight.model.hyperflex_error_stack import HyperflexErrorStack
    from intersight.model.hyperflex_feature_limit_entry import HyperflexFeatureLimitEntry
    from intersight.model.hyperflex_file_path import HyperflexFilePath
    from intersight.model.hyperflex_health_check_node_level_info import HyperflexHealthCheckNodeLevelInfo
    from intersight.model.hyperflex_health_check_script_info import HyperflexHealthCheckScriptInfo
    from intersight.model.hyperflex_hx_host_mount_status_dt import HyperflexHxHostMountStatusDt
    from intersight.model.hyperflex_hx_license_authorization_details_dt import HyperflexHxLicenseAuthorizationDetailsDt
    from intersight.model.hyperflex_hx_link_dt import HyperflexHxLinkDt
    from intersight.model.hyperflex_hx_network_address_dt import HyperflexHxNetworkAddressDt
    from intersight.model.hyperflex_hx_platform_datastore_config_dt import HyperflexHxPlatformDatastoreConfigDt
    from intersight.model.hyperflex_hx_registration_details_dt import HyperflexHxRegistrationDetailsDt
    from intersight.model.hyperflex_hx_resiliency_info_dt import HyperflexHxResiliencyInfoDt
    from intersight.model.hyperflex_hx_site_dt import HyperflexHxSiteDt
    from intersight.model.hyperflex_hx_uu_id_dt import HyperflexHxUuIdDt
    from intersight.model.hyperflex_hx_zone_info_dt import HyperflexHxZoneInfoDt
    from intersight.model.hyperflex_hx_zone_resiliency_info_dt import HyperflexHxZoneResiliencyInfoDt
    from intersight.model.hyperflex_ip_addr_range import HyperflexIpAddrRange
    from intersight.model.hyperflex_logical_availability_zone import HyperflexLogicalAvailabilityZone
    from intersight.model.hyperflex_mac_addr_prefix_range import HyperflexMacAddrPrefixRange
    from intersight.model.hyperflex_map_cluster_id_to_protection_info import HyperflexMapClusterIdToProtectionInfo
    from intersight.model.hyperflex_map_cluster_id_to_st_snapshot_point import HyperflexMapClusterIdToStSnapshotPoint
    from intersight.model.hyperflex_map_uuid_to_tracked_disk import HyperflexMapUuidToTrackedDisk
    from intersight.model.hyperflex_named_vlan import HyperflexNamedVlan
    from intersight.model.hyperflex_named_vsan import HyperflexNamedVsan
    from intersight.model.hyperflex_network_configuration import HyperflexNetworkConfiguration
    from intersight.model.hyperflex_port_type_to_port_number_map import HyperflexPortTypeToPortNumberMap
    from intersight.model.hyperflex_protection_info import HyperflexProtectionInfo
    from intersight.model.hyperflex_re_sync_cluster_mo_ids import HyperflexReSyncClusterMoIds
    from intersight.model.hyperflex_replication_cluster_reference_to_schedule import HyperflexReplicationClusterReferenceToSchedule
    from intersight.model.hyperflex_replication_peer_info import HyperflexReplicationPeerInfo
    from intersight.model.hyperflex_replication_plat_datastore import HyperflexReplicationPlatDatastore
    from intersight.model.hyperflex_replication_plat_datastore_pair import HyperflexReplicationPlatDatastorePair
    from intersight.model.hyperflex_replication_schedule import HyperflexReplicationSchedule
    from intersight.model.hyperflex_replication_status import HyperflexReplicationStatus
    from intersight.model.hyperflex_rpo_status import HyperflexRpoStatus
    from intersight.model.hyperflex_server_firmware_version_info import HyperflexServerFirmwareVersionInfo
    from intersight.model.hyperflex_server_model_entry import HyperflexServerModelEntry
    from intersight.model.hyperflex_site_details import HyperflexSiteDetails
    from intersight.model.hyperflex_snapshot_files import HyperflexSnapshotFiles
    from intersight.model.hyperflex_snapshot_info_brief import HyperflexSnapshotInfoBrief
    from intersight.model.hyperflex_snapshot_point import HyperflexSnapshotPoint
    from intersight.model.hyperflex_snapshot_status import HyperflexSnapshotStatus
    from intersight.model.hyperflex_st_platform_cluster_healing_info import HyperflexStPlatformClusterHealingInfo
    from intersight.model.hyperflex_st_platform_cluster_resiliency_info import HyperflexStPlatformClusterResiliencyInfo
    from intersight.model.hyperflex_summary import HyperflexSummary
    from intersight.model.hyperflex_tracked_disk import HyperflexTrackedDisk
    from intersight.model.hyperflex_tracked_file import HyperflexTrackedFile
    from intersight.model.hyperflex_vcenter_configuration import HyperflexVcenterConfiguration
    from intersight.model.hyperflex_virtual_machine import HyperflexVirtualMachine
    from intersight.model.hyperflex_virtual_machine_runtime_info import HyperflexVirtualMachineRuntimeInfo
    from intersight.model.hyperflex_vm_protection_space_usage import HyperflexVmProtectionSpaceUsage
    from intersight.model.hyperflex_wwxn_prefix_range import HyperflexWwxnPrefixRange
    from intersight.model.i18n_message import I18nMessage
    from intersight.model.i18n_message_param import I18nMessageParam
    from intersight.model.iaas_license_keys_info import IaasLicenseKeysInfo
    from intersight.model.iaas_license_utilization_info import IaasLicenseUtilizationInfo
    from intersight.model.iaas_workflow_steps import IaasWorkflowSteps
    from intersight.model.iam_account_permissions import IamAccountPermissions
    from intersight.model.iam_account_tags import IamAccountTags
    from intersight.model.iam_app_credentials import IamAppCredentials
    from intersight.model.iam_basic_auth_credentials import IamBasicAuthCredentials
    from intersight.model.iam_client_meta import IamClientMeta
    from intersight.model.iam_end_point_password_properties import IamEndPointPasswordProperties
    from intersight.model.iam_failure_details import IamFailureDetails
    from intersight.model.iam_feature_definition import IamFeatureDefinition
    from intersight.model.iam_group_permission_to_roles import IamGroupPermissionToRoles
    from intersight.model.iam_ldap_base_properties import IamLdapBaseProperties
    from intersight.model.iam_ldap_dns_parameters import IamLdapDnsParameters
    from intersight.model.iam_permission_reference import IamPermissionReference
    from intersight.model.iam_permission_to_roles import IamPermissionToRoles
    from intersight.model.iam_resource_role import IamResourceRole
    from intersight.model.iam_rule import IamRule
    from intersight.model.iam_saml_sp_connection import IamSamlSpConnection
    from intersight.model.iam_security_context import IamSecurityContext
    from intersight.model.iam_sso_session_attributes import IamSsoSessionAttributes
    from intersight.model.iam_switch_account_permission import IamSwitchAccountPermission
    from intersight.model.iam_switch_scope_permissions import IamSwitchScopePermissions
    from intersight.model.iam_user_details import IamUserDetails
    from intersight.model.imcconnector_web_ui_message import ImcconnectorWebUiMessage
    from intersight.model.infra_base_gpu_configuration import InfraBaseGpuConfiguration
    from intersight.model.infra_base_pci_configuration import InfraBasePciConfiguration
    from intersight.model.infra_gpu_configuration import InfraGpuConfiguration
    from intersight.model.infra_hardware_info import InfraHardwareInfo
    from intersight.model.infra_meta_data import InfraMetaData
    from intersight.model.infra_mig_gpu_configuration import InfraMigGpuConfiguration
    from intersight.model.inventory_inventory_mo import InventoryInventoryMo
    from intersight.model.inventory_job_info import InventoryJobInfo
    from intersight.model.inventory_uem_info import InventoryUemInfo
    from intersight.model.ippool_ip_v4_block import IppoolIpV4Block
    from intersight.model.ippool_ip_v4_config import IppoolIpV4Config
    from intersight.model.ippool_ip_v6_block import IppoolIpV6Block
    from intersight.model.ippool_ip_v6_config import IppoolIpV6Config
    from intersight.model.ippool_reservation_reference import IppoolReservationReference
    from intersight.model.iqnpool_iqn_suffix_block import IqnpoolIqnSuffixBlock
    from intersight.model.iqnpool_reservation_reference import IqnpoolReservationReference
    from intersight.model.issue_condition import IssueCondition
    from intersight.model.issue_device_tag import IssueDeviceTag
    from intersight.model.issue_message import IssueMessage
    from intersight.model.issue_odata_condition import IssueOdataCondition
    from intersight.model.kubernetes_action_info import KubernetesActionInfo
    from intersight.model.kubernetes_addon import KubernetesAddon
    from intersight.model.kubernetes_addon_configuration import KubernetesAddonConfiguration
    from intersight.model.kubernetes_addon_version_reference import KubernetesAddonVersionReference
    from intersight.model.kubernetes_baremetal_network_info import KubernetesBaremetalNetworkInfo
    from intersight.model.kubernetes_base_virtual_machine_infra_config import KubernetesBaseVirtualMachineInfraConfig
    from intersight.model.kubernetes_calico_config import KubernetesCalicoConfig
    from intersight.model.kubernetes_cluster_certificate_configuration import KubernetesClusterCertificateConfiguration
    from intersight.model.kubernetes_cluster_management_config import KubernetesClusterManagementConfig
    from intersight.model.kubernetes_cni_config import KubernetesCniConfig
    from intersight.model.kubernetes_configuration import KubernetesConfiguration
    from intersight.model.kubernetes_daemon_set_status import KubernetesDaemonSetStatus
    from intersight.model.kubernetes_deployment_status import KubernetesDeploymentStatus
    from intersight.model.kubernetes_essential_addon import KubernetesEssentialAddon
    from intersight.model.kubernetes_esxi_virtual_machine_infra_config import KubernetesEsxiVirtualMachineInfraConfig
    from intersight.model.kubernetes_ethernet import KubernetesEthernet
    from intersight.model.kubernetes_ethernet_matcher import KubernetesEthernetMatcher
    from intersight.model.kubernetes_ingress_status import KubernetesIngressStatus
    from intersight.model.kubernetes_instance_type_details import KubernetesInstanceTypeDetails
    from intersight.model.kubernetes_ip_v4_config import KubernetesIpV4Config
    from intersight.model.kubernetes_key_value import KubernetesKeyValue
    from intersight.model.kubernetes_load_balancer import KubernetesLoadBalancer
    from intersight.model.kubernetes_network_interface import KubernetesNetworkInterface
    from intersight.model.kubernetes_network_interface_spec import KubernetesNetworkInterfaceSpec
    from intersight.model.kubernetes_node_address import KubernetesNodeAddress
    from intersight.model.kubernetes_node_group_label import KubernetesNodeGroupLabel
    from intersight.model.kubernetes_node_group_taint import KubernetesNodeGroupTaint
    from intersight.model.kubernetes_node_info import KubernetesNodeInfo
    from intersight.model.kubernetes_node_spec import KubernetesNodeSpec
    from intersight.model.kubernetes_node_status import KubernetesNodeStatus
    from intersight.model.kubernetes_object_meta import KubernetesObjectMeta
    from intersight.model.kubernetes_ovs_bond import KubernetesOvsBond
    from intersight.model.kubernetes_pod_status import KubernetesPodStatus
    from intersight.model.kubernetes_proxy_config import KubernetesProxyConfig
    from intersight.model.kubernetes_route import KubernetesRoute
    from intersight.model.kubernetes_service_status import KubernetesServiceStatus
    from intersight.model.kubernetes_stateful_set_status import KubernetesStatefulSetStatus
    from intersight.model.kubernetes_taint import KubernetesTaint
    from intersight.model.license_substitute_license import LicenseSubstituteLicense
    from intersight.model.macpool_block import MacpoolBlock
    from intersight.model.macpool_member_of import MacpoolMemberOf
    from intersight.model.macpool_reservation_reference import MacpoolReservationReference
    from intersight.model.marketplace_use_case_automation import MarketplaceUseCaseAutomation
    from intersight.model.marketplace_use_case_dependency import MarketplaceUseCaseDependency
    from intersight.model.marketplace_use_case_locale import MarketplaceUseCaseLocale
    from intersight.model.marketplace_use_case_version_locale import MarketplaceUseCaseVersionLocale
    from intersight.model.marketplace_use_case_version_resource import MarketplaceUseCaseVersionResource
    from intersight.model.memory_persistent_memory_goal import MemoryPersistentMemoryGoal
    from intersight.model.memory_persistent_memory_local_security import MemoryPersistentMemoryLocalSecurity
    from intersight.model.memory_persistent_memory_logical_namespace import MemoryPersistentMemoryLogicalNamespace
    from intersight.model.meta_access_privilege import MetaAccessPrivilege
    from intersight.model.meta_display_name_definition import MetaDisplayNameDefinition
    from intersight.model.meta_identity_definition import MetaIdentityDefinition
    from intersight.model.meta_prop_definition import MetaPropDefinition
    from intersight.model.meta_relationship_definition import MetaRelationshipDefinition
    from intersight.model.metrics_metric_criterion import MetricsMetricCriterion
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.monitoring_category_status import MonitoringCategoryStatus
    from intersight.model.motemplate_action_entry import MotemplateActionEntry
    from intersight.model.motemplate_action_param import MotemplateActionParam
    from intersight.model.motemplate_sync_error import MotemplateSyncError
    from intersight.model.network_hyper_flex_internet_protocol_address_range import NetworkHyperFlexInternetProtocolAddressRange
    from intersight.model.network_hyper_flex_network_address import NetworkHyperFlexNetworkAddress
    from intersight.model.niaapi_detail import NiaapiDetail
    from intersight.model.niaapi_new_release_detail import NiaapiNewReleaseDetail
    from intersight.model.niaapi_revision_info import NiaapiRevisionInfo
    from intersight.model.niaapi_software_regex import NiaapiSoftwareRegex
    from intersight.model.niaapi_version_regex_platform import NiaapiVersionRegexPlatform
    from intersight.model.niatelemetry_bootflash_details import NiatelemetryBootflashDetails
    from intersight.model.niatelemetry_cloud_regions_element import NiatelemetryCloudRegionsElement
    from intersight.model.niatelemetry_cloud_routers_element import NiatelemetryCloudRoutersElement
    from intersight.model.niatelemetry_deployment_status import NiatelemetryDeploymentStatus
    from intersight.model.niatelemetry_digital_optical_monitoring import NiatelemetryDigitalOpticalMonitoring
    from intersight.model.niatelemetry_diskinfo import NiatelemetryDiskinfo
    from intersight.model.niatelemetry_dom_info import NiatelemetryDomInfo
    from intersight.model.niatelemetry_dom_thres_info import NiatelemetryDomThresInfo
    from intersight.model.niatelemetry_eqpt_storage_firmware import NiatelemetryEqptStorageFirmware
    from intersight.model.niatelemetry_eqptcapacity_pol_usage5min import NiatelemetryEqptcapacityPolUsage5min
    from intersight.model.niatelemetry_eqptcapacity_prefix_entries15min import NiatelemetryEqptcapacityPrefixEntries15min
    from intersight.model.niatelemetry_eqptcapacity_prefix_entries5min import NiatelemetryEqptcapacityPrefixEntries5min
    from intersight.model.niatelemetry_fan_details import NiatelemetryFanDetails
    from intersight.model.niatelemetry_image_detail import NiatelemetryImageDetail
    from intersight.model.niatelemetry_interface import NiatelemetryInterface
    from intersight.model.niatelemetry_interface_element import NiatelemetryInterfaceElement
    from intersight.model.niatelemetry_job_detail import NiatelemetryJobDetail
    from intersight.model.niatelemetry_logical_link import NiatelemetryLogicalLink
    from intersight.model.niatelemetry_mds_neighbor_info import NiatelemetryMdsNeighborInfo
    from intersight.model.niatelemetry_network_info import NiatelemetryNetworkInfo
    from intersight.model.niatelemetry_node import NiatelemetryNode
    from intersight.model.niatelemetry_nve_packet_counters import NiatelemetryNvePacketCounters
    from intersight.model.niatelemetry_nve_vni import NiatelemetryNveVni
    from intersight.model.niatelemetry_nxos_bgp_evpn import NiatelemetryNxosBgpEvpn
    from intersight.model.niatelemetry_nxos_bgp_mvpn import NiatelemetryNxosBgpMvpn
    from intersight.model.niatelemetry_nxos_vtp import NiatelemetryNxosVtp
    from intersight.model.niatelemetry_proc_sys_cpu15min import NiatelemetryProcSysCpu15min
    from intersight.model.niatelemetry_proc_sys_cpu5min import NiatelemetryProcSysCpu5min
    from intersight.model.niatelemetry_proc_sys_mem15min import NiatelemetryProcSysMem15min
    from intersight.model.niatelemetry_proc_sys_mem5min import NiatelemetryProcSysMem5min
    from intersight.model.niatelemetry_sites import NiatelemetrySites
    from intersight.model.niatelemetry_smart_license import NiatelemetrySmartLicense
    from intersight.model.niatelemetry_switch_disk_utilization import NiatelemetrySwitchDiskUtilization
    from intersight.model.niatelemetry_vni_status import NiatelemetryVniStatus
    from intersight.model.niatelemetry_vpc_details import NiatelemetryVpcDetails
    from intersight.model.notification_abstract_condition import NotificationAbstractCondition
    from intersight.model.notification_abstract_mo_condition import NotificationAbstractMoCondition
    from intersight.model.notification_action import NotificationAction
    from intersight.model.notification_aggregation_settings import NotificationAggregationSettings
    from intersight.model.notification_alarm_mo_condition import NotificationAlarmMoCondition
    from intersight.model.notification_appliance_upgrade_mo_condition import NotificationApplianceUpgradeMoCondition
    from intersight.model.notification_distributable_mo_condition import NotificationDistributableMoCondition
    from intersight.model.notification_mo_condition import NotificationMoCondition
    from intersight.model.notification_send_email import NotificationSendEmail
    from intersight.model.notification_simple_filter import NotificationSimpleFilter
    from intersight.model.notification_simple_mo_condition import NotificationSimpleMoCondition
    from intersight.model.notification_software_release_meta_mo_condition import NotificationSoftwareReleaseMetaMoCondition
    from intersight.model.notification_trigger_webhook import NotificationTriggerWebhook
    from intersight.model.ntp_auth_ntp_server import NtpAuthNtpServer
    from intersight.model.onprem_cluster_info import OnpremClusterInfo
    from intersight.model.onprem_cluster_node import OnpremClusterNode
    from intersight.model.onprem_image_package import OnpremImagePackage
    from intersight.model.onprem_resource_info import OnpremResourceInfo
    from intersight.model.onprem_schedule import OnpremSchedule
    from intersight.model.onprem_upgrade_note import OnpremUpgradeNote
    from intersight.model.onprem_upgrade_phase import OnpremUpgradePhase
    from intersight.model.openapi_api_info import OpenapiApiInfo
    from intersight.model.openapi_failed_task import OpenapiFailedTask
    from intersight.model.openapi_key_value_pair import OpenapiKeyValuePair
    from intersight.model.oprs_kvpair import OprsKvpair
    from intersight.model.os_answers import OsAnswers
    from intersight.model.os_fibre_channel_response import OsFibreChannelResponse
    from intersight.model.os_fibre_channel_target import OsFibreChannelTarget
    from intersight.model.os_global_config import OsGlobalConfig
    from intersight.model.os_install_target import OsInstallTarget
    from intersight.model.os_install_target_response import OsInstallTargetResponse
    from intersight.model.os_ip_configuration import OsIpConfiguration
    from intersight.model.os_ipv4_configuration import OsIpv4Configuration
    from intersight.model.os_ipv6_configuration import OsIpv6Configuration
    from intersight.model.os_iscsi_lun_response import OsIscsiLunResponse
    from intersight.model.os_iscsi_target import OsIscsiTarget
    from intersight.model.os_operating_system_parameters import OsOperatingSystemParameters
    from intersight.model.os_physical_disk import OsPhysicalDisk
    from intersight.model.os_physical_disk_response import OsPhysicalDiskResponse
    from intersight.model.os_place_holder import OsPlaceHolder
    from intersight.model.os_remote_target_response import OsRemoteTargetResponse
    from intersight.model.os_san_target import OsSanTarget
    from intersight.model.os_server_config import OsServerConfig
    from intersight.model.os_validation_information import OsValidationInformation
    from intersight.model.os_virtual_drive import OsVirtualDrive
    from intersight.model.os_virtual_drive_response import OsVirtualDriveResponse
    from intersight.model.os_vmware_parameters import OsVmwareParameters
    from intersight.model.os_windows_parameters import OsWindowsParameters
    from intersight.model.partnerintegration_metrics_model import PartnerintegrationMetricsModel
    from intersight.model.pkix_distinguished_name import PkixDistinguishedName
    from intersight.model.pkix_ecdsa_key_spec import PkixEcdsaKeySpec
    from intersight.model.pkix_eddsa_key_spec import PkixEddsaKeySpec
    from intersight.model.pkix_key_generation_spec import PkixKeyGenerationSpec
    from intersight.model.pkix_rsa_algorithm import PkixRsaAlgorithm
    from intersight.model.pkix_subject_alternate_name import PkixSubjectAlternateName
    from intersight.model.policy_action_param import PolicyActionParam
    from intersight.model.policy_action_qualifier import PolicyActionQualifier
    from intersight.model.policy_config_change import PolicyConfigChange
    from intersight.model.policy_config_change_context import PolicyConfigChangeContext
    from intersight.model.policy_config_change_disruption_detail_type import PolicyConfigChangeDisruptionDetailType
    from intersight.model.policy_config_context import PolicyConfigContext
    from intersight.model.policy_config_result_context import PolicyConfigResultContext
    from intersight.model.policy_policy_error import PolicyPolicyError
    from intersight.model.policy_policy_status import PolicyPolicyStatus
    from intersight.model.policy_qualifier import PolicyQualifier
    from intersight.model.policy_scheduled_action import PolicyScheduledAction
    from intersight.model.pool_abstract_block_type import PoolAbstractBlockType
    from intersight.model.pool_reservation_reference import PoolReservationReference
    from intersight.model.recovery_backup_schedule import RecoveryBackupSchedule
    from intersight.model.recovery_config_params import RecoveryConfigParams
    from intersight.model.resource_adaptors_range_filter import ResourceAdaptorsRangeFilter
    from intersight.model.resource_advanced_filter import ResourceAdvancedFilter
    from intersight.model.resource_blade_qualifier import ResourceBladeQualifier
    from intersight.model.resource_chassis_and_slot_qualification import ResourceChassisAndSlotQualification
    from intersight.model.resource_chassis_id_range_filter import ResourceChassisIdRangeFilter
    from intersight.model.resource_chassis_servers_qualifier import ResourceChassisServersQualifier
    from intersight.model.resource_cpu_core_range_filter import ResourceCpuCoreRangeFilter
    from intersight.model.resource_cpu_speed_range_filter import ResourceCpuSpeedRangeFilter
    from intersight.model.resource_domain_qualifier import ResourceDomainQualifier
    from intersight.model.resource_gpu_controllers_range_filter import ResourceGpuControllersRangeFilter
    from intersight.model.resource_gpu_qualifier import ResourceGpuQualifier
    from intersight.model.resource_hardware_qualifier import ResourceHardwareQualifier
    from intersight.model.resource_memory_capacity_range_filter import ResourceMemoryCapacityRangeFilter
    from intersight.model.resource_memory_qualifier import ResourceMemoryQualifier
    from intersight.model.resource_memory_units_range_filter import ResourceMemoryUnitsRangeFilter
    from intersight.model.resource_network_adaptor_qualifier import ResourceNetworkAdaptorQualifier
    from intersight.model.resource_odata_rule_set_qualifier import ResourceOdataRuleSetQualifier
    from intersight.model.resource_per_type_combined_selector import ResourcePerTypeCombinedSelector
    from intersight.model.resource_processor_qualifier import ResourceProcessorQualifier
    from intersight.model.resource_rack_id_range_filter import ResourceRackIdRangeFilter
    from intersight.model.resource_rack_server_qualifier import ResourceRackServerQualifier
    from intersight.model.resource_range_filter import ResourceRangeFilter
    from intersight.model.resource_resource_qualifier import ResourceResourceQualifier
    from intersight.model.resource_rule_set_qualifier import ResourceRuleSetQualifier
    from intersight.model.resource_selector import ResourceSelector
    from intersight.model.resource_server_qualifier import ResourceServerQualifier
    from intersight.model.resource_slot_id_range_filter import ResourceSlotIdRangeFilter
    from intersight.model.resource_source_to_permission_resources import ResourceSourceToPermissionResources
    from intersight.model.resource_source_to_permission_resources_holder import ResourceSourceToPermissionResourcesHolder
    from intersight.model.resource_tag import ResourceTag
    from intersight.model.resource_tag_qualifier import ResourceTagQualifier
    from intersight.model.resourcepool_child_lease_condition import ResourcepoolChildLeaseCondition
    from intersight.model.resourcepool_lease_parameters import ResourcepoolLeaseParameters
    from intersight.model.resourcepool_qualification_type import ResourcepoolQualificationType
    from intersight.model.resourcepool_resource_evaluation_status import ResourcepoolResourceEvaluationStatus
    from intersight.model.resourcepool_resource_pool_parameters import ResourcepoolResourcePoolParameters
    from intersight.model.resourcepool_server_lease_parameters import ResourcepoolServerLeaseParameters
    from intersight.model.resourcepool_server_pool_parameters import ResourcepoolServerPoolParameters
    from intersight.model.scheduler_abstract_scheduling_params import SchedulerAbstractSchedulingParams
    from intersight.model.scheduler_abstract_task_request import SchedulerAbstractTaskRequest
    from intersight.model.scheduler_base_cadence_params import SchedulerBaseCadenceParams
    from intersight.model.scheduler_base_monthly_cadence_params import SchedulerBaseMonthlyCadenceParams
    from intersight.model.scheduler_base_schedule_params import SchedulerBaseScheduleParams
    from intersight.model.scheduler_block_date import SchedulerBlockDate
    from intersight.model.scheduler_daily_cadence_params import SchedulerDailyCadenceParams
    from intersight.model.scheduler_every_cadence_params import SchedulerEveryCadenceParams
    from intersight.model.scheduler_monthly_cadence_params import SchedulerMonthlyCadenceParams
    from intersight.model.scheduler_one_time_schedule_params import SchedulerOneTimeScheduleParams
    from intersight.model.scheduler_recurring_schedule_params import SchedulerRecurringScheduleParams
    from intersight.model.scheduler_rest_stim_task_request import SchedulerRestStimTaskRequest
    from intersight.model.scheduler_task_result_status import SchedulerTaskResultStatus
    from intersight.model.scheduler_task_schedule_policy_execution_status import SchedulerTaskSchedulePolicyExecutionStatus
    from intersight.model.scheduler_task_schedule_status import SchedulerTaskScheduleStatus
    from intersight.model.scheduler_weekly_cadence_params import SchedulerWeeklyCadenceParams
    from intersight.model.sdcard_diagnostics import SdcardDiagnostics
    from intersight.model.sdcard_drivers import SdcardDrivers
    from intersight.model.sdcard_host_upgrade_utility import SdcardHostUpgradeUtility
    from intersight.model.sdcard_operating_system import SdcardOperatingSystem
    from intersight.model.sdcard_partition import SdcardPartition
    from intersight.model.sdcard_server_configuration_utility import SdcardServerConfigurationUtility
    from intersight.model.sdcard_user_partition import SdcardUserPartition
    from intersight.model.sdcard_virtual_drive import SdcardVirtualDrive
    from intersight.model.server_pending_workflow_trigger import ServerPendingWorkflowTrigger
    from intersight.model.server_server_assign_type_slot import ServerServerAssignTypeSlot
    from intersight.model.serviceitem_base_message import ServiceitemBaseMessage
    from intersight.model.serviceitem_health_check_error_element import ServiceitemHealthCheckErrorElement
    from intersight.model.serviceitem_message import ServiceitemMessage
    from intersight.model.serviceitem_selection_criteria_input import ServiceitemSelectionCriteriaInput
    from intersight.model.servicerequest_message import ServicerequestMessage
    from intersight.model.snmp_trap import SnmpTrap
    from intersight.model.snmp_user import SnmpUser
    from intersight.model.softwarerepository_appliance_upload import SoftwarerepositoryApplianceUpload
    from intersight.model.softwarerepository_cifs_server import SoftwarerepositoryCifsServer
    from intersight.model.softwarerepository_constraint_models import SoftwarerepositoryConstraintModels
    from intersight.model.softwarerepository_file_server import SoftwarerepositoryFileServer
    from intersight.model.softwarerepository_http_server import SoftwarerepositoryHttpServer
    from intersight.model.softwarerepository_import_result import SoftwarerepositoryImportResult
    from intersight.model.softwarerepository_local_machine import SoftwarerepositoryLocalMachine
    from intersight.model.softwarerepository_nfs_server import SoftwarerepositoryNfsServer
    from intersight.model.softwarerepository_unsupported_model_constraint import SoftwarerepositoryUnsupportedModelConstraint
    from intersight.model.storage_automatic_drive_group import StorageAutomaticDriveGroup
    from intersight.model.storage_base_capacity import StorageBaseCapacity
    from intersight.model.storage_base_initiator import StorageBaseInitiator
    from intersight.model.storage_base_performance_metrics_average import StorageBasePerformanceMetricsAverage
    from intersight.model.storage_base_replication_blackout import StorageBaseReplicationBlackout
    from intersight.model.storage_external_lun import StorageExternalLun
    from intersight.model.storage_external_parity_group import StorageExternalParityGroup
    from intersight.model.storage_external_path import StorageExternalPath
    from intersight.model.storage_hitachi_array_utilization import StorageHitachiArrayUtilization
    from intersight.model.storage_hitachi_capacity import StorageHitachiCapacity
    from intersight.model.storage_hitachi_initiator import StorageHitachiInitiator
    from intersight.model.storage_host_nqn import StorageHostNqn
    from intersight.model.storage_hyper_flex_iscsi_initiator import StorageHyperFlexIscsiInitiator
    from intersight.model.storage_initiator import StorageInitiator
    from intersight.model.storage_internal_mo_physical_disk_config import StorageInternalMoPhysicalDiskConfig
    from intersight.model.storage_key_setting import StorageKeySetting
    from intersight.model.storage_kmip_auth_credentials import StorageKmipAuthCredentials
    from intersight.model.storage_kmip_server import StorageKmipServer
    from intersight.model.storage_local_key_setting import StorageLocalKeySetting
    from intersight.model.storage_m2_virtual_drive_config import StorageM2VirtualDriveConfig
    from intersight.model.storage_manual_drive_group import StorageManualDriveGroup
    from intersight.model.storage_namespace import StorageNamespace
    from intersight.model.storage_namespace_path import StorageNamespacePath
    from intersight.model.storage_net_app_auto_support import StorageNetAppAutoSupport
    from intersight.model.storage_net_app_cifs_acl import StorageNetAppCifsAcl
    from intersight.model.storage_net_app_ethernet_port_lag import StorageNetAppEthernetPortLag
    from intersight.model.storage_net_app_ethernet_port_vlan import StorageNetAppEthernetPortVlan
    from intersight.model.storage_net_app_export_policy_rule import StorageNetAppExportPolicyRule
    from intersight.model.storage_net_app_high_availability import StorageNetAppHighAvailability
    from intersight.model.storage_net_app_performance_metrics_average import StorageNetAppPerformanceMetricsAverage
    from intersight.model.storage_net_app_port import StorageNetAppPort
    from intersight.model.storage_net_app_snapshot_policy_schedule import StorageNetAppSnapshotPolicySchedule
    from intersight.model.storage_net_app_storage_cluster_efficiency import StorageNetAppStorageClusterEfficiency
    from intersight.model.storage_net_app_storage_utilization import StorageNetAppStorageUtilization
    from intersight.model.storage_nvme_dedicated_hot_spare_configuration import StorageNvmeDedicatedHotSpareConfiguration
    from intersight.model.storage_nvme_physical_disk_state import StorageNvmePhysicalDiskState
    from intersight.model.storage_nvme_raid_drive_group import StorageNvmeRaidDriveGroup
    from intersight.model.storage_nvme_virtual_drive_configuration import StorageNvmeVirtualDriveConfiguration
    from intersight.model.storage_pure_array_utilization import StoragePureArrayUtilization
    from intersight.model.storage_pure_disk_utilization import StoragePureDiskUtilization
    from intersight.model.storage_pure_host_utilization import StoragePureHostUtilization
    from intersight.model.storage_pure_replication_blackout import StoragePureReplicationBlackout
    from intersight.model.storage_pure_volume_utilization import StoragePureVolumeUtilization
    from intersight.model.storage_r0_drive import StorageR0Drive
    from intersight.model.storage_remote_key_setting import StorageRemoteKeySetting
    from intersight.model.storage_space import StorageSpace
    from intersight.model.storage_span_drives import StorageSpanDrives
    from intersight.model.storage_storage_container_host_mount_status import StorageStorageContainerHostMountStatus
    from intersight.model.storage_storage_container_utilization import StorageStorageContainerUtilization
    from intersight.model.storage_storage_utilization import StorageStorageUtilization
    from intersight.model.storage_virtual_drive_configuration import StorageVirtualDriveConfiguration
    from intersight.model.storage_virtual_drive_policy import StorageVirtualDrivePolicy
    from intersight.model.storage_volume_utilization import StorageVolumeUtilization
    from intersight.model.syslog_local_client_base import SyslogLocalClientBase
    from intersight.model.syslog_local_file_logging_client import SyslogLocalFileLoggingClient
    from intersight.model.syslog_remote_client_base import SyslogRemoteClientBase
    from intersight.model.syslog_remote_logging_client import SyslogRemoteLoggingClient
    from intersight.model.tam_action import TamAction
    from intersight.model.tam_api_data_source import TamApiDataSource
    from intersight.model.tam_base_advisory_details import TamBaseAdvisoryDetails
    from intersight.model.tam_base_data_source import TamBaseDataSource
    from intersight.model.tam_eol_advisory_details import TamEolAdvisoryDetails
    from intersight.model.tam_eol_severity import TamEolSeverity
    from intersight.model.tam_fn_severity import TamFnSeverity
    from intersight.model.tam_identifiers import TamIdentifiers
    from intersight.model.tam_milestone import TamMilestone
    from intersight.model.tam_psirt_severity import TamPsirtSeverity
    from intersight.model.tam_query_entry import TamQueryEntry
    from intersight.model.tam_s3_data_source import TamS3DataSource
    from intersight.model.tam_security_advisory_details import TamSecurityAdvisoryDetails
    from intersight.model.tam_severity import TamSeverity
    from intersight.model.tam_text_fsm_template_data_source import TamTextFsmTemplateDataSource
    from intersight.model.task_file_download_info import TaskFileDownloadInfo
    from intersight.model.techsupportmanagement_appliance_param import TechsupportmanagementApplianceParam
    from intersight.model.techsupportmanagement_nia_param import TechsupportmanagementNiaParam
    from intersight.model.techsupportmanagement_platform_param import TechsupportmanagementPlatformParam
    from intersight.model.techsupportmanagement_tech_support_file_info import TechsupportmanagementTechSupportFileInfo
    from intersight.model.template_transformation_stage import TemplateTransformationStage
    from intersight.model.ucsd_connector_pack import UcsdConnectorPack
    from intersight.model.ucsd_ucsd_restore_parameters import UcsdUcsdRestoreParameters
    from intersight.model.ucsdconnector_rest_client_message import UcsdconnectorRestClientMessage
    from intersight.model.uuidpool_reservation_reference import UuidpoolReservationReference
    from intersight.model.uuidpool_uuid_block import UuidpoolUuidBlock
    from intersight.model.virtualization_action_info import VirtualizationActionInfo
    from intersight.model.virtualization_base_custom_spec import VirtualizationBaseCustomSpec
    from intersight.model.virtualization_base_host_configuration import VirtualizationBaseHostConfiguration
    from intersight.model.virtualization_base_vm_configuration import VirtualizationBaseVmConfiguration
    from intersight.model.virtualization_cloud_init_config import VirtualizationCloudInitConfig
    from intersight.model.virtualization_compute_capacity import VirtualizationComputeCapacity
    from intersight.model.virtualization_cpu_info import VirtualizationCpuInfo
    from intersight.model.virtualization_esxi_clone_custom_spec import VirtualizationEsxiCloneCustomSpec
    from intersight.model.virtualization_esxi_host_configuration import VirtualizationEsxiHostConfiguration
    from intersight.model.virtualization_esxi_ova_custom_spec import VirtualizationEsxiOvaCustomSpec
    from intersight.model.virtualization_esxi_vm_compute_configuration import VirtualizationEsxiVmComputeConfiguration
    from intersight.model.virtualization_esxi_vm_configuration import VirtualizationEsxiVmConfiguration
    from intersight.model.virtualization_esxi_vm_network_configuration import VirtualizationEsxiVmNetworkConfiguration
    from intersight.model.virtualization_esxi_vm_storage_configuration import VirtualizationEsxiVmStorageConfiguration
    from intersight.model.virtualization_guest_info import VirtualizationGuestInfo
    from intersight.model.virtualization_memory_capacity import VirtualizationMemoryCapacity
    from intersight.model.virtualization_network_interface import VirtualizationNetworkInterface
    from intersight.model.virtualization_product_info import VirtualizationProductInfo
    from intersight.model.virtualization_storage_capacity import VirtualizationStorageCapacity
    from intersight.model.virtualization_virtual_machine_disk import VirtualizationVirtualMachineDisk
    from intersight.model.virtualization_vm_esxi_disk import VirtualizationVmEsxiDisk
    from intersight.model.virtualization_vmware_attached_resource_tag import VirtualizationVmwareAttachedResourceTag
    from intersight.model.virtualization_vmware_discovery_protocol import VirtualizationVmwareDiscoveryProtocol
    from intersight.model.virtualization_vmware_remote_display_info import VirtualizationVmwareRemoteDisplayInfo
    from intersight.model.virtualization_vmware_resource_allocation_system_traffic_types import VirtualizationVmwareResourceAllocationSystemTrafficTypes
    from intersight.model.virtualization_vmware_resource_consumption import VirtualizationVmwareResourceConsumption
    from intersight.model.virtualization_vmware_shares_info import VirtualizationVmwareSharesInfo
    from intersight.model.virtualization_vmware_teaming_and_failover import VirtualizationVmwareTeamingAndFailover
    from intersight.model.virtualization_vmware_vlan_range import VirtualizationVmwareVlanRange
    from intersight.model.virtualization_vmware_vm_cpu_share_info import VirtualizationVmwareVmCpuShareInfo
    from intersight.model.virtualization_vmware_vm_cpu_socket_info import VirtualizationVmwareVmCpuSocketInfo
    from intersight.model.virtualization_vmware_vm_disk_commit_info import VirtualizationVmwareVmDiskCommitInfo
    from intersight.model.virtualization_vmware_vm_memory_share_info import VirtualizationVmwareVmMemoryShareInfo
    from intersight.model.vmedia_mapping import VmediaMapping
    from intersight.model.vnic_arfs_settings import VnicArfsSettings
    from intersight.model.vnic_cdn import VnicCdn
    from intersight.model.vnic_completion_queue_settings import VnicCompletionQueueSettings
    from intersight.model.vnic_eth_if_old_info import VnicEthIfOldInfo
    from intersight.model.vnic_eth_interrupt_settings import VnicEthInterruptSettings
    from intersight.model.vnic_eth_rx_queue_settings import VnicEthRxQueueSettings
    from intersight.model.vnic_eth_tx_queue_settings import VnicEthTxQueueSettings
    from intersight.model.vnic_fc_error_recovery_settings import VnicFcErrorRecoverySettings
    from intersight.model.vnic_fc_if_old_info import VnicFcIfOldInfo
    from intersight.model.vnic_fc_interrupt_settings import VnicFcInterruptSettings
    from intersight.model.vnic_fc_queue_settings import VnicFcQueueSettings
    from intersight.model.vnic_flogi_settings import VnicFlogiSettings
    from intersight.model.vnic_iscsi_auth_profile import VnicIscsiAuthProfile
    from intersight.model.vnic_lun import VnicLun
    from intersight.model.vnic_nvgre_settings import VnicNvgreSettings
    from intersight.model.vnic_placement_settings import VnicPlacementSettings
    from intersight.model.vnic_plogi_settings import VnicPlogiSettings
    from intersight.model.vnic_ptp_settings import VnicPtpSettings
    from intersight.model.vnic_roce_settings import VnicRoceSettings
    from intersight.model.vnic_rss_hash_settings import VnicRssHashSettings
    from intersight.model.vnic_san_settings_old_info import VnicSanSettingsOldInfo
    from intersight.model.vnic_scsi_queue_settings import VnicScsiQueueSettings
    from intersight.model.vnic_sriov_settings import VnicSriovSettings
    from intersight.model.vnic_tcp_offload_settings import VnicTcpOffloadSettings
    from intersight.model.vnic_usnic_settings import VnicUsnicSettings
    from intersight.model.vnic_vif_status import VnicVifStatus
    from intersight.model.vnic_vlan_settings import VnicVlanSettings
    from intersight.model.vnic_vmq_settings import VnicVmqSettings
    from intersight.model.vnic_vsan_settings import VnicVsanSettings
    from intersight.model.vnic_vxlan_settings import VnicVxlanSettings
    from intersight.model.workflow_abstract_loop_task import WorkflowAbstractLoopTask
    from intersight.model.workflow_abstract_resource_selector import WorkflowAbstractResourceSelector
    from intersight.model.workflow_abstract_worker_task import WorkflowAbstractWorkerTask
    from intersight.model.workflow_ansible_play_session import WorkflowAnsiblePlaySession
    from intersight.model.workflow_api import WorkflowApi
    from intersight.model.workflow_array_data_type import WorkflowArrayDataType
    from intersight.model.workflow_array_item import WorkflowArrayItem
    from intersight.model.workflow_associated_roles import WorkflowAssociatedRoles
    from intersight.model.workflow_base_data_type import WorkflowBaseDataType
    from intersight.model.workflow_base_operation import WorkflowBaseOperation
    from intersight.model.workflow_base_service_item_action_property import WorkflowBaseServiceItemActionProperty
    from intersight.model.workflow_cancelable_type import WorkflowCancelableType
    from intersight.model.workflow_cli_command import WorkflowCliCommand
    from intersight.model.workflow_comments import WorkflowComments
    from intersight.model.workflow_constraints import WorkflowConstraints
    from intersight.model.workflow_control_task import WorkflowControlTask
    from intersight.model.workflow_custom_array_item import WorkflowCustomArrayItem
    from intersight.model.workflow_custom_data_property import WorkflowCustomDataProperty
    from intersight.model.workflow_custom_data_type import WorkflowCustomDataType
    from intersight.model.workflow_custom_data_type_properties import WorkflowCustomDataTypeProperties
    from intersight.model.workflow_data_source_selector import WorkflowDataSourceSelector
    from intersight.model.workflow_decision_case import WorkflowDecisionCase
    from intersight.model.workflow_decision_task import WorkflowDecisionTask
    from intersight.model.workflow_default_value import WorkflowDefaultValue
    from intersight.model.workflow_display_meta import WorkflowDisplayMeta
    from intersight.model.workflow_dynamic_template_parser_data_type import WorkflowDynamicTemplateParserDataType
    from intersight.model.workflow_end_task import WorkflowEndTask
    from intersight.model.workflow_enum_entry import WorkflowEnumEntry
    from intersight.model.workflow_environment_variable_reference import WorkflowEnvironmentVariableReference
    from intersight.model.workflow_expect_prompt import WorkflowExpectPrompt
    from intersight.model.workflow_failure_end_task import WorkflowFailureEndTask
    from intersight.model.workflow_file_download_op import WorkflowFileDownloadOp
    from intersight.model.workflow_file_operations import WorkflowFileOperations
    from intersight.model.workflow_file_template_op import WorkflowFileTemplateOp
    from intersight.model.workflow_file_transfer import WorkflowFileTransfer
    from intersight.model.workflow_fork_task import WorkflowForkTask
    from intersight.model.workflow_initiator_context import WorkflowInitiatorContext
    from intersight.model.workflow_internal_properties import WorkflowInternalProperties
    from intersight.model.workflow_join_task import WorkflowJoinTask
    from intersight.model.workflow_loop_task import WorkflowLoopTask
    from intersight.model.workflow_message import WorkflowMessage
    from intersight.model.workflow_migrate_service_item_action_property import WorkflowMigrateServiceItemActionProperty
    from intersight.model.workflow_migration_history import WorkflowMigrationHistory
    from intersight.model.workflow_mo_inventory_data_type import WorkflowMoInventoryDataType
    from intersight.model.workflow_mo_inventory_property import WorkflowMoInventoryProperty
    from intersight.model.workflow_mo_reference_array_item import WorkflowMoReferenceArrayItem
    from intersight.model.workflow_mo_reference_auto_array_item import WorkflowMoReferenceAutoArrayItem
    from intersight.model.workflow_mo_reference_auto_data_type import WorkflowMoReferenceAutoDataType
    from intersight.model.workflow_mo_reference_auto_property import WorkflowMoReferenceAutoProperty
    from intersight.model.workflow_mo_reference_data_type import WorkflowMoReferenceDataType
    from intersight.model.workflow_mo_reference_for_clone_data_type import WorkflowMoReferenceForCloneDataType
    from intersight.model.workflow_mo_reference_property import WorkflowMoReferenceProperty
    from intersight.model.workflow_operation_type_decommission import WorkflowOperationTypeDecommission
    from intersight.model.workflow_operation_type_deployment import WorkflowOperationTypeDeployment
    from intersight.model.workflow_operation_type_post_deployment import WorkflowOperationTypePostDeployment
    from intersight.model.workflow_parameter_set import WorkflowParameterSet
    from intersight.model.workflow_power_shell_api import WorkflowPowerShellApi
    from intersight.model.workflow_primitive_array_item import WorkflowPrimitiveArrayItem
    from intersight.model.workflow_primitive_data_property import WorkflowPrimitiveDataProperty
    from intersight.model.workflow_primitive_data_type import WorkflowPrimitiveDataType
    from intersight.model.workflow_properties import WorkflowProperties
    from intersight.model.workflow_resource_inline_selector import WorkflowResourceInlineSelector
    from intersight.model.workflow_resource_selector_criteria import WorkflowResourceSelectorCriteria
    from intersight.model.workflow_result_handler import WorkflowResultHandler
    from intersight.model.workflow_rollback_task import WorkflowRollbackTask
    from intersight.model.workflow_rollback_workflow_task import WorkflowRollbackWorkflowTask
    from intersight.model.workflow_selector_property import WorkflowSelectorProperty
    from intersight.model.workflow_sequence_params import WorkflowSequenceParams
    from intersight.model.workflow_serial_loop_task import WorkflowSerialLoopTask
    from intersight.model.workflow_service_item_action_properties import WorkflowServiceItemActionProperties
    from intersight.model.workflow_service_item_action_workflow_definition import WorkflowServiceItemActionWorkflowDefinition
    from intersight.model.workflow_service_item_input_definition_type import WorkflowServiceItemInputDefinitionType
    from intersight.model.workflow_service_item_type import WorkflowServiceItemType
    from intersight.model.workflow_ssh_cmd import WorkflowSshCmd
    from intersight.model.workflow_ssh_config import WorkflowSshConfig
    from intersight.model.workflow_ssh_session import WorkflowSshSession
    from intersight.model.workflow_start_task import WorkflowStartTask
    from intersight.model.workflow_sub_workflow_task import WorkflowSubWorkflowTask
    from intersight.model.workflow_success_end_task import WorkflowSuccessEndTask
    from intersight.model.workflow_target_context import WorkflowTargetContext
    from intersight.model.workflow_target_data_type import WorkflowTargetDataType
    from intersight.model.workflow_target_property import WorkflowTargetProperty
    from intersight.model.workflow_task_constraints import WorkflowTaskConstraints
    from intersight.model.workflow_task_info_update import WorkflowTaskInfoUpdate
    from intersight.model.workflow_task_loop_info import WorkflowTaskLoopInfo
    from intersight.model.workflow_task_retry_info import WorkflowTaskRetryInfo
    from intersight.model.workflow_ui_form_config import WorkflowUiFormConfig
    from intersight.model.workflow_ui_input_filter import WorkflowUiInputFilter
    from intersight.model.workflow_ui_view_config import WorkflowUiViewConfig
    from intersight.model.workflow_validation_error import WorkflowValidationError
    from intersight.model.workflow_validation_information import WorkflowValidationInformation
    from intersight.model.workflow_wait_task import WorkflowWaitTask
    from intersight.model.workflow_wait_task_prompt import WorkflowWaitTaskPrompt
    from intersight.model.workflow_web_api import WorkflowWebApi
    from intersight.model.workflow_worker_task import WorkflowWorkerTask
    from intersight.model.workflow_workflow_ctx import WorkflowWorkflowCtx
    from intersight.model.workflow_workflow_engine_properties import WorkflowWorkflowEngineProperties
    from intersight.model.workflow_workflow_info_auto_restart_properties import WorkflowWorkflowInfoAutoRestartProperties
    from intersight.model.workflow_workflow_info_properties import WorkflowWorkflowInfoProperties
    from intersight.model.workflow_workflow_properties import WorkflowWorkflowProperties
    from intersight.model.workflow_workflow_task import WorkflowWorkflowTask
    from intersight.model.workflow_xml_api import WorkflowXmlApi
    from intersight.model.workload_assigned_resource import WorkloadAssignedResource
    from intersight.model.workload_base_blueprint_reference import WorkloadBaseBlueprintReference
    from intersight.model.workload_batch_deployment import WorkloadBatchDeployment
    from intersight.model.workload_blueprint_input_reference import WorkloadBlueprintInputReference
    from intersight.model.workload_blueprint_reference import WorkloadBlueprintReference
    from intersight.model.workload_canary_deployment import WorkloadCanaryDeployment
    from intersight.model.workload_clone_status import WorkloadCloneStatus
    from intersight.model.workload_clone_status_entry import WorkloadCloneStatusEntry
    from intersight.model.workload_definition_mapper import WorkloadDefinitionMapper
    from intersight.model.workload_deployment_blueprint_input_type import WorkloadDeploymentBlueprintInputType
    from intersight.model.workload_deployment_change_detail import WorkloadDeploymentChangeDetail
    from intersight.model.workload_generated_object import WorkloadGeneratedObject
    from intersight.model.workload_resource_constraint import WorkloadResourceConstraint
    from intersight.model.workload_rollout_strategy import WorkloadRolloutStrategy
    from intersight.model.workload_state_aggregation import WorkloadStateAggregation
    from intersight.model.x509_certificate import X509Certificate
    globals()['AaaUserAgent'] = AaaUserAgent
    globals()['AccessAddressType'] = AccessAddressType
    globals()['AccessConfigurationType'] = AccessConfigurationType
    globals()['AdapterAdapterConfig'] = AdapterAdapterConfig
    globals()['AdapterDceInterfaceSettings'] = AdapterDceInterfaceSettings
    globals()['AdapterEthSettings'] = AdapterEthSettings
    globals()['AdapterFcSettings'] = AdapterFcSettings
    globals()['AdapterPhysicalNicModeSettings'] = AdapterPhysicalNicModeSettings
    globals()['AdapterPortChannelSettings'] = AdapterPortChannelSettings
    globals()['ApicFabricLeafNodeDetails'] = ApicFabricLeafNodeDetails
    globals()['ApplianceApiStatus'] = ApplianceApiStatus
    globals()['ApplianceCertRenewalPhase'] = ApplianceCertRenewalPhase
    globals()['ApplianceClusterInstallPhase'] = ApplianceClusterInstallPhase
    globals()['ApplianceKeyValuePair'] = ApplianceKeyValuePair
    globals()['ApplianceMetadataManifestVersion'] = ApplianceMetadataManifestVersion
    globals()['ApplianceNetworkStatus'] = ApplianceNetworkStatus
    globals()['ApplianceNodeIpInfo'] = ApplianceNodeIpInfo
    globals()['ApplianceStatusCheck'] = ApplianceStatusCheck
    globals()['AssetAddressInformation'] = AssetAddressInformation
    globals()['AssetAlarmSummary'] = AssetAlarmSummary
    globals()['AssetApiKeyCredential'] = AssetApiKeyCredential
    globals()['AssetClaimSignature'] = AssetClaimSignature
    globals()['AssetClientCertificateCredential'] = AssetClientCertificateCredential
    globals()['AssetCloudConnection'] = AssetCloudConnection
    globals()['AssetConnection'] = AssetConnection
    globals()['AssetConnectionFlapStatus'] = AssetConnectionFlapStatus
    globals()['AssetContractInformation'] = AssetContractInformation
    globals()['AssetCredential'] = AssetCredential
    globals()['AssetCustomerInformation'] = AssetCustomerInformation
    globals()['AssetDeploymentAlarmInfo'] = AssetDeploymentAlarmInfo
    globals()['AssetDeploymentDeviceAlarmInfo'] = AssetDeploymentDeviceAlarmInfo
    globals()['AssetDeploymentDeviceInformation'] = AssetDeploymentDeviceInformation
    globals()['AssetDeviceEndpointLocalCredential'] = AssetDeviceEndpointLocalCredential
    globals()['AssetDeviceInformation'] = AssetDeviceInformation
    globals()['AssetDeviceStatistics'] = AssetDeviceStatistics
    globals()['AssetDeviceTransaction'] = AssetDeviceTransaction
    globals()['AssetGenericTargetClaimOptions'] = AssetGenericTargetClaimOptions
    globals()['AssetGlobalUltimate'] = AssetGlobalUltimate
    globals()['AssetGoogleCloudPlatformServiceAccountKeyCredential'] = AssetGoogleCloudPlatformServiceAccountKeyCredential
    globals()['AssetHttpConnection'] = AssetHttpConnection
    globals()['AssetIntersightDeviceConnectorConnection'] = AssetIntersightDeviceConnectorConnection
    globals()['AssetMerakiCloudOptions'] = AssetMerakiCloudOptions
    globals()['AssetMeteringType'] = AssetMeteringType
    globals()['AssetNewRelicCredential'] = AssetNewRelicCredential
    globals()['AssetNoAuthenticationCredential'] = AssetNoAuthenticationCredential
    globals()['AssetOauthBearerTokenCredential'] = AssetOauthBearerTokenCredential
    globals()['AssetOauthClientIdSecretCredential'] = AssetOauthClientIdSecretCredential
    globals()['AssetOrchestrationCivpVmwareVcenterOptions'] = AssetOrchestrationCivpVmwareVcenterOptions
    globals()['AssetOrchestrationHitachiVirtualStoragePlatformOptions'] = AssetOrchestrationHitachiVirtualStoragePlatformOptions
    globals()['AssetOrchestrationHsmVmwareVcenterOptions'] = AssetOrchestrationHsmVmwareVcenterOptions
    globals()['AssetOrchestrationService'] = AssetOrchestrationService
    globals()['AssetParentConnectionSignature'] = AssetParentConnectionSignature
    globals()['AssetPrivateKeyCredential'] = AssetPrivateKeyCredential
    globals()['AssetProductInformation'] = AssetProductInformation
    globals()['AssetScopedTargetConnection'] = AssetScopedTargetConnection
    globals()['AssetService'] = AssetService
    globals()['AssetServiceNowCredential'] = AssetServiceNowCredential
    globals()['AssetServiceOptions'] = AssetServiceOptions
    globals()['AssetSshConnection'] = AssetSshConnection
    globals()['AssetSudiInfo'] = AssetSudiInfo
    globals()['AssetTargetKey'] = AssetTargetKey
    globals()['AssetTargetSignature'] = AssetTargetSignature
    globals()['AssetTargetStatusDetails'] = AssetTargetStatusDetails
    globals()['AssetTerraformIntegrationService'] = AssetTerraformIntegrationService
    globals()['AssetTerraformIntegrationTerraformAgentOptions'] = AssetTerraformIntegrationTerraformAgentOptions
    globals()['AssetTerraformIntegrationTerraformCloudOptions'] = AssetTerraformIntegrationTerraformCloudOptions
    globals()['AssetUsernamePasswordCredential'] = AssetUsernamePasswordCredential
    globals()['AssetVirtualizationAmazonWebServiceOptions'] = AssetVirtualizationAmazonWebServiceOptions
    globals()['AssetVirtualizationCloudOptions'] = AssetVirtualizationCloudOptions
    globals()['AssetVirtualizationService'] = AssetVirtualizationService
    globals()['AssetVmHost'] = AssetVmHost
    globals()['AssetWorkloadOptimizerAmazonWebServicesBillingOptions'] = AssetWorkloadOptimizerAmazonWebServicesBillingOptions
    globals()['AssetWorkloadOptimizerDynatraceOptions'] = AssetWorkloadOptimizerDynatraceOptions
    globals()['AssetWorkloadOptimizerGoogleCloudPlatformBillingOptions'] = AssetWorkloadOptimizerGoogleCloudPlatformBillingOptions
    globals()['AssetWorkloadOptimizerHypervOptions'] = AssetWorkloadOptimizerHypervOptions
    globals()['AssetWorkloadOptimizerMicrosoftAzureApplicationInsightsOptions'] = AssetWorkloadOptimizerMicrosoftAzureApplicationInsightsOptions
    globals()['AssetWorkloadOptimizerMicrosoftAzureBillingOptions'] = AssetWorkloadOptimizerMicrosoftAzureBillingOptions
    globals()['AssetWorkloadOptimizerMicrosoftAzureEnterpriseAgreementOptions'] = AssetWorkloadOptimizerMicrosoftAzureEnterpriseAgreementOptions
    globals()['AssetWorkloadOptimizerMicrosoftAzureServicePrincipalOptions'] = AssetWorkloadOptimizerMicrosoftAzureServicePrincipalOptions
    globals()['AssetWorkloadOptimizerMicrosoftSqlServerOptions'] = AssetWorkloadOptimizerMicrosoftSqlServerOptions
    globals()['AssetWorkloadOptimizerNewRelicOptions'] = AssetWorkloadOptimizerNewRelicOptions
    globals()['AssetWorkloadOptimizerOpenStackOptions'] = AssetWorkloadOptimizerOpenStackOptions
    globals()['AssetWorkloadOptimizerOracleDatabaseServerOptions'] = AssetWorkloadOptimizerOracleDatabaseServerOptions
    globals()['AssetWorkloadOptimizerRedHatOpenStackOptions'] = AssetWorkloadOptimizerRedHatOpenStackOptions
    globals()['AssetWorkloadOptimizerService'] = AssetWorkloadOptimizerService
    globals()['AssetWorkloadOptimizerVmwareVcenterOptions'] = AssetWorkloadOptimizerVmwareVcenterOptions
    globals()['BlueprintBaseGeneratedObjectSourceFromSelector'] = BlueprintBaseGeneratedObjectSourceFromSelector
    globals()['BlueprintBaseGeneratedObjectSourceMetadata'] = BlueprintBaseGeneratedObjectSourceMetadata
    globals()['BlueprintBlueprintDefinitionDependency'] = BlueprintBlueprintDefinitionDependency
    globals()['BlueprintGeneratedObjectMetadata'] = BlueprintGeneratedObjectMetadata
    globals()['BlueprintGeneratedObjectNew'] = BlueprintGeneratedObjectNew
    globals()['BlueprintGeneratedObjectOperationTarget'] = BlueprintGeneratedObjectOperationTarget
    globals()['BlueprintGeneratedObjectSourceClone'] = BlueprintGeneratedObjectSourceClone
    globals()['BlueprintGeneratedObjectSourceLookup'] = BlueprintGeneratedObjectSourceLookup
    globals()['BlueprintGeneratedObjectSourceMerge'] = BlueprintGeneratedObjectSourceMerge
    globals()['BlueprintGeneratedObjectSourceReference'] = BlueprintGeneratedObjectSourceReference
    globals()['BlueprintGeneratedObjectSourceSelector'] = BlueprintGeneratedObjectSourceSelector
    globals()['BlueprintInputOperationType'] = BlueprintInputOperationType
    globals()['BlueprintPreGenerateOperation'] = BlueprintPreGenerateOperation
    globals()['BlueprintPropertyIteration'] = BlueprintPropertyIteration
    globals()['BlueprintResourceConstraints'] = BlueprintResourceConstraints
    globals()['BlueprintServiceItemDefinition'] = BlueprintServiceItemDefinition
    globals()['BootBootloader'] = BootBootloader
    globals()['BootDeviceBase'] = BootDeviceBase
    globals()['BootFlexMmc'] = BootFlexMmc
    globals()['BootHttp'] = BootHttp
    globals()['BootIscsi'] = BootIscsi
    globals()['BootLocalCdd'] = BootLocalCdd
    globals()['BootLocalDisk'] = BootLocalDisk
    globals()['BootNvme'] = BootNvme
    globals()['BootPchStorage'] = BootPchStorage
    globals()['BootPxe'] = BootPxe
    globals()['BootSan'] = BootSan
    globals()['BootSdCard'] = BootSdCard
    globals()['BootStaticIpV4Settings'] = BootStaticIpV4Settings
    globals()['BootStaticIpV6Settings'] = BootStaticIpV6Settings
    globals()['BootUefiShell'] = BootUefiShell
    globals()['BootUsb'] = BootUsb
    globals()['BootVirtualMedia'] = BootVirtualMedia
    globals()['BulkApiResult'] = BulkApiResult
    globals()['BulkHttpHeader'] = BulkHttpHeader
    globals()['BulkMultiRelationEntryPatch'] = BulkMultiRelationEntryPatch
    globals()['BulkPatchContent'] = BulkPatchContent
    globals()['BulkRestResult'] = BulkRestResult
    globals()['BulkRestSubRequest'] = BulkRestSubRequest
    globals()['BulkSecResourceRoles'] = BulkSecResourceRoles
    globals()['BulkSubRequest'] = BulkSubRequest
    globals()['CapabilityCertificatePropertyConstraints'] = CapabilityCertificatePropertyConstraints
    globals()['CapabilityFeatureConfig'] = CapabilityFeatureConfig
    globals()['CapabilityHsuIsoModelSpecificConstraint'] = CapabilityHsuIsoModelSpecificConstraint
    globals()['CapabilityLdapBasePropertyConstraints'] = CapabilityLdapBasePropertyConstraints
    globals()['CapabilityPcIdRange'] = CapabilityPcIdRange
    globals()['CapabilityPortRange'] = CapabilityPortRange
    globals()['CapabilityServerComponentConstraint'] = CapabilityServerComponentConstraint
    globals()['CapabilitySwitchNetworkLimits'] = CapabilitySwitchNetworkLimits
    globals()['CapabilitySwitchStorageLimits'] = CapabilitySwitchStorageLimits
    globals()['CapabilitySwitchSystemLimits'] = CapabilitySwitchSystemLimits
    globals()['CapabilitySwitchingModeCapability'] = CapabilitySwitchingModeCapability
    globals()['CapabilityUnsupportedFeatureConfig'] = CapabilityUnsupportedFeatureConfig
    globals()['CapabilityUpdateOrderListType'] = CapabilityUpdateOrderListType
    globals()['CertificatemanagementCertificateBase'] = CertificatemanagementCertificateBase
    globals()['CertificatemanagementImc'] = CertificatemanagementImc
    globals()['CertificatemanagementRootCaCertificate'] = CertificatemanagementRootCaCertificate
    globals()['CloudTfcWorkspaceVariables'] = CloudTfcWorkspaceVariables
    globals()['CmrfCmRf'] = CmrfCmRf
    globals()['CommGeoLocationDetails'] = CommGeoLocationDetails
    globals()['CommGeoPoint'] = CommGeoPoint
    globals()['CommIpV4AddressBlock'] = CommIpV4AddressBlock
    globals()['CommIpV4Interface'] = CommIpV4Interface
    globals()['CommIpV6Interface'] = CommIpV6Interface
    globals()['CommPhysicalAddress'] = CommPhysicalAddress
    globals()['CommTagUsage'] = CommTagUsage
    globals()['ComputeAlarmSummary'] = ComputeAlarmSummary
    globals()['ComputeHostUtilityOperationConfguration'] = ComputeHostUtilityOperationConfguration
    globals()['ComputeIpAddress'] = ComputeIpAddress
    globals()['ComputePendingWorkflowTrigger'] = ComputePendingWorkflowTrigger
    globals()['ComputePersistentMemoryModule'] = ComputePersistentMemoryModule
    globals()['ComputePersistentMemoryOperation'] = ComputePersistentMemoryOperation
    globals()['ComputePersonalitySetting'] = ComputePersonalitySetting
    globals()['ComputeScrubOpConfigutation'] = ComputeScrubOpConfigutation
    globals()['ComputeServerConfig'] = ComputeServerConfig
    globals()['ComputeServerOpStatus'] = ComputeServerOpStatus
    globals()['ComputeStorageControllerOperation'] = ComputeStorageControllerOperation
    globals()['ComputeStoragePhysicalDrive'] = ComputeStoragePhysicalDrive
    globals()['ComputeStoragePhysicalDriveOperation'] = ComputeStoragePhysicalDriveOperation
    globals()['ComputeStorageUtilityImageOperation'] = ComputeStorageUtilityImageOperation
    globals()['ComputeStorageVirtualDrive'] = ComputeStorageVirtualDrive
    globals()['ComputeStorageVirtualDriveOperation'] = ComputeStorageVirtualDriveOperation
    globals()['CondAlarmAction'] = CondAlarmAction
    globals()['CondAlarmClassificationEligibility'] = CondAlarmClassificationEligibility
    globals()['CondAlarmSpec'] = CondAlarmSpec
    globals()['CondAlarmSummary'] = CondAlarmSummary
    globals()['ConnectorAuthMessage'] = ConnectorAuthMessage
    globals()['ConnectorBaseMessage'] = ConnectorBaseMessage
    globals()['ConnectorCloseStreamMessage'] = ConnectorCloseStreamMessage
    globals()['ConnectorCommandControlMessage'] = ConnectorCommandControlMessage
    globals()['ConnectorCommandTerminalStream'] = ConnectorCommandTerminalStream
    globals()['ConnectorEventLog'] = ConnectorEventLog
    globals()['ConnectorExpectPrompt'] = ConnectorExpectPrompt
    globals()['ConnectorFetchStreamMessage'] = ConnectorFetchStreamMessage
    globals()['ConnectorFileChecksum'] = ConnectorFileChecksum
    globals()['ConnectorFileMessage'] = ConnectorFileMessage
    globals()['ConnectorHttpRequest'] = ConnectorHttpRequest
    globals()['ConnectorPlatformParamBase'] = ConnectorPlatformParamBase
    globals()['ConnectorSshConfig'] = ConnectorSshConfig
    globals()['ConnectorSshMessage'] = ConnectorSshMessage
    globals()['ConnectorStartStream'] = ConnectorStartStream
    globals()['ConnectorStartStreamFromDevice'] = ConnectorStartStreamFromDevice
    globals()['ConnectorStreamAcknowledge'] = ConnectorStreamAcknowledge
    globals()['ConnectorStreamInput'] = ConnectorStreamInput
    globals()['ConnectorStreamKeepalive'] = ConnectorStreamKeepalive
    globals()['ConnectorStreamMessage'] = ConnectorStreamMessage
    globals()['ConnectorTargetChangeMessage'] = ConnectorTargetChangeMessage
    globals()['ConnectorTargetSpecification'] = ConnectorTargetSpecification
    globals()['ConnectorUrl'] = ConnectorUrl
    globals()['ConnectorWinrmRequest'] = ConnectorWinrmRequest
    globals()['ConnectorXmlApiMessage'] = ConnectorXmlApiMessage
    globals()['ConnectorpackConnectorPackUpdate'] = ConnectorpackConnectorPackUpdate
    globals()['ContentBaseParameter'] = ContentBaseParameter
    globals()['ContentComplexType'] = ContentComplexType
    globals()['ContentParameter'] = ContentParameter
    globals()['ContentTextParameter'] = ContentTextParameter
    globals()['ConvergedinfraAlarmSummary'] = ConvergedinfraAlarmSummary
    globals()['ConvergedinfraBasePodSummary'] = ConvergedinfraBasePodSummary
    globals()['ConvergedinfraComplianceSummary'] = ConvergedinfraComplianceSummary
    globals()['ConvergedinfraPodSummary'] = ConvergedinfraPodSummary
    globals()['CrdCustomResourceConfigProperty'] = CrdCustomResourceConfigProperty
    globals()['EquipmentChassisOperationStatus'] = EquipmentChassisOperationStatus
    globals()['EquipmentDeviceLocation'] = EquipmentDeviceLocation
    globals()['EquipmentIoCardIdentity'] = EquipmentIoCardIdentity
    globals()['EquipmentIoCardOperationStatus'] = EquipmentIoCardOperationStatus
    globals()['EquipmentResetAction'] = EquipmentResetAction
    globals()['EtherMacsecOperData'] = EtherMacsecOperData
    globals()['FabricClusterAssignment'] = FabricClusterAssignment
    globals()['FabricFcZoneMember'] = FabricFcZoneMember
    globals()['FabricLldpSettings'] = FabricLldpSettings
    globals()['FabricMacAgingSettings'] = FabricMacAgingSettings
    globals()['FabricMacSecEaPol'] = FabricMacSecEaPol
    globals()['FabricPortIdentifier'] = FabricPortIdentifier
    globals()['FabricQosClass'] = FabricQosClass
    globals()['FabricSecKey'] = FabricSecKey
    globals()['FabricSecKeyChain'] = FabricSecKeyChain
    globals()['FabricUdldGlobalSettings'] = FabricUdldGlobalSettings
    globals()['FabricUdldSettings'] = FabricUdldSettings
    globals()['FabricVlanSettings'] = FabricVlanSettings
    globals()['FcpoolBlock'] = FcpoolBlock
    globals()['FcpoolReservationReference'] = FcpoolReservationReference
    globals()['FeedbackFeedbackData'] = FeedbackFeedbackData
    globals()['FirmwareBaseImpact'] = FirmwareBaseImpact
    globals()['FirmwareChassisUpgradeImpact'] = FirmwareChassisUpgradeImpact
    globals()['FirmwareCifsServer'] = FirmwareCifsServer
    globals()['FirmwareComponentImpact'] = FirmwareComponentImpact
    globals()['FirmwareComponentMeta'] = FirmwareComponentMeta
    globals()['FirmwareDirectDownload'] = FirmwareDirectDownload
    globals()['FirmwareExcludeComponentPidListType'] = FirmwareExcludeComponentPidListType
    globals()['FirmwareFabricUpgradeImpact'] = FirmwareFabricUpgradeImpact
    globals()['FirmwareFeatureVersionMap'] = FirmwareFeatureVersionMap
    globals()['FirmwareFirmwareInventory'] = FirmwareFirmwareInventory
    globals()['FirmwareHttpServer'] = FirmwareHttpServer
    globals()['FirmwareModelBundleVersion'] = FirmwareModelBundleVersion
    globals()['FirmwareNetworkShare'] = FirmwareNetworkShare
    globals()['FirmwareNfsServer'] = FirmwareNfsServer
    globals()['FirmwareServerUpgradeImpact'] = FirmwareServerUpgradeImpact
    globals()['FirmwareVersionMap'] = FirmwareVersionMap
    globals()['ForecastModel'] = ForecastModel
    globals()['HciAhvGuestTools'] = HciAhvGuestTools
    globals()['HciAlarmParameter'] = HciAlarmParameter
    globals()['HciAlarmSummary'] = HciAlarmSummary
    globals()['HciApiLimit'] = HciApiLimit
    globals()['HciBackplaneNetworkParams'] = HciBackplaneNetworkParams
    globals()['HciCapacityViolation'] = HciCapacityViolation
    globals()['HciConsumption'] = HciConsumption
    globals()['HciEntitlementDetail'] = HciEntitlementDetail
    globals()['HciEsxiGuestTools'] = HciEsxiGuestTools
    globals()['HciExpiredLicense'] = HciExpiredLicense
    globals()['HciFaultToleranceState'] = HciFaultToleranceState
    globals()['HciFeatureViolation'] = HciFeatureViolation
    globals()['HciIpAddress'] = HciIpAddress
    globals()['HciIpAddressOrFqdn'] = HciIpAddressOrFqdn
    globals()['HciKeyManagementDeviceToCertStatusInfo'] = HciKeyManagementDeviceToCertStatusInfo
    globals()['HciLicensedService'] = HciLicensedService
    globals()['HciManagementServer'] = HciManagementServer
    globals()['HciPulseStatus'] = HciPulseStatus
    globals()['HciSbdf'] = HciSbdf
    globals()['HciServiceViolation'] = HciServiceViolation
    globals()['HciSoftwareType'] = HciSoftwareType
    globals()['HciVirtualGpuConfig'] = HciVirtualGpuConfig
    globals()['HclConstraint'] = HclConstraint
    globals()['HclFirmware'] = HclFirmware
    globals()['HclHardwareCompatibilityProfile'] = HclHardwareCompatibilityProfile
    globals()['HclProduct'] = HclProduct
    globals()['HyperflexAbstractAppSetting'] = HyperflexAbstractAppSetting
    globals()['HyperflexAlarmSummary'] = HyperflexAlarmSummary
    globals()['HyperflexAppSettingConstraint'] = HyperflexAppSettingConstraint
    globals()['HyperflexBackupPolicySettings'] = HyperflexBackupPolicySettings
    globals()['HyperflexCapability'] = HyperflexCapability
    globals()['HyperflexDatastoreInfo'] = HyperflexDatastoreInfo
    globals()['HyperflexEntityReference'] = HyperflexEntityReference
    globals()['HyperflexErrorStack'] = HyperflexErrorStack
    globals()['HyperflexFeatureLimitEntry'] = HyperflexFeatureLimitEntry
    globals()['HyperflexFilePath'] = HyperflexFilePath
    globals()['HyperflexHealthCheckNodeLevelInfo'] = HyperflexHealthCheckNodeLevelInfo
    globals()['HyperflexHealthCheckScriptInfo'] = HyperflexHealthCheckScriptInfo
    globals()['HyperflexHxHostMountStatusDt'] = HyperflexHxHostMountStatusDt
    globals()['HyperflexHxLicenseAuthorizationDetailsDt'] = HyperflexHxLicenseAuthorizationDetailsDt
    globals()['HyperflexHxLinkDt'] = HyperflexHxLinkDt
    globals()['HyperflexHxNetworkAddressDt'] = HyperflexHxNetworkAddressDt
    globals()['HyperflexHxPlatformDatastoreConfigDt'] = HyperflexHxPlatformDatastoreConfigDt
    globals()['HyperflexHxRegistrationDetailsDt'] = HyperflexHxRegistrationDetailsDt
    globals()['HyperflexHxResiliencyInfoDt'] = HyperflexHxResiliencyInfoDt
    globals()['HyperflexHxSiteDt'] = HyperflexHxSiteDt
    globals()['HyperflexHxUuIdDt'] = HyperflexHxUuIdDt
    globals()['HyperflexHxZoneInfoDt'] = HyperflexHxZoneInfoDt
    globals()['HyperflexHxZoneResiliencyInfoDt'] = HyperflexHxZoneResiliencyInfoDt
    globals()['HyperflexIpAddrRange'] = HyperflexIpAddrRange
    globals()['HyperflexLogicalAvailabilityZone'] = HyperflexLogicalAvailabilityZone
    globals()['HyperflexMacAddrPrefixRange'] = HyperflexMacAddrPrefixRange
    globals()['HyperflexMapClusterIdToProtectionInfo'] = HyperflexMapClusterIdToProtectionInfo
    globals()['HyperflexMapClusterIdToStSnapshotPoint'] = HyperflexMapClusterIdToStSnapshotPoint
    globals()['HyperflexMapUuidToTrackedDisk'] = HyperflexMapUuidToTrackedDisk
    globals()['HyperflexNamedVlan'] = HyperflexNamedVlan
    globals()['HyperflexNamedVsan'] = HyperflexNamedVsan
    globals()['HyperflexNetworkConfiguration'] = HyperflexNetworkConfiguration
    globals()['HyperflexPortTypeToPortNumberMap'] = HyperflexPortTypeToPortNumberMap
    globals()['HyperflexProtectionInfo'] = HyperflexProtectionInfo
    globals()['HyperflexReSyncClusterMoIds'] = HyperflexReSyncClusterMoIds
    globals()['HyperflexReplicationClusterReferenceToSchedule'] = HyperflexReplicationClusterReferenceToSchedule
    globals()['HyperflexReplicationPeerInfo'] = HyperflexReplicationPeerInfo
    globals()['HyperflexReplicationPlatDatastore'] = HyperflexReplicationPlatDatastore
    globals()['HyperflexReplicationPlatDatastorePair'] = HyperflexReplicationPlatDatastorePair
    globals()['HyperflexReplicationSchedule'] = HyperflexReplicationSchedule
    globals()['HyperflexReplicationStatus'] = HyperflexReplicationStatus
    globals()['HyperflexRpoStatus'] = HyperflexRpoStatus
    globals()['HyperflexServerFirmwareVersionInfo'] = HyperflexServerFirmwareVersionInfo
    globals()['HyperflexServerModelEntry'] = HyperflexServerModelEntry
    globals()['HyperflexSiteDetails'] = HyperflexSiteDetails
    globals()['HyperflexSnapshotFiles'] = HyperflexSnapshotFiles
    globals()['HyperflexSnapshotInfoBrief'] = HyperflexSnapshotInfoBrief
    globals()['HyperflexSnapshotPoint'] = HyperflexSnapshotPoint
    globals()['HyperflexSnapshotStatus'] = HyperflexSnapshotStatus
    globals()['HyperflexStPlatformClusterHealingInfo'] = HyperflexStPlatformClusterHealingInfo
    globals()['HyperflexStPlatformClusterResiliencyInfo'] = HyperflexStPlatformClusterResiliencyInfo
    globals()['HyperflexSummary'] = HyperflexSummary
    globals()['HyperflexTrackedDisk'] = HyperflexTrackedDisk
    globals()['HyperflexTrackedFile'] = HyperflexTrackedFile
    globals()['HyperflexVcenterConfiguration'] = HyperflexVcenterConfiguration
    globals()['HyperflexVirtualMachine'] = HyperflexVirtualMachine
    globals()['HyperflexVirtualMachineRuntimeInfo'] = HyperflexVirtualMachineRuntimeInfo
    globals()['HyperflexVmProtectionSpaceUsage'] = HyperflexVmProtectionSpaceUsage
    globals()['HyperflexWwxnPrefixRange'] = HyperflexWwxnPrefixRange
    globals()['I18nMessage'] = I18nMessage
    globals()['I18nMessageParam'] = I18nMessageParam
    globals()['IaasLicenseKeysInfo'] = IaasLicenseKeysInfo
    globals()['IaasLicenseUtilizationInfo'] = IaasLicenseUtilizationInfo
    globals()['IaasWorkflowSteps'] = IaasWorkflowSteps
    globals()['IamAccountPermissions'] = IamAccountPermissions
    globals()['IamAccountTags'] = IamAccountTags
    globals()['IamAppCredentials'] = IamAppCredentials
    globals()['IamBasicAuthCredentials'] = IamBasicAuthCredentials
    globals()['IamClientMeta'] = IamClientMeta
    globals()['IamEndPointPasswordProperties'] = IamEndPointPasswordProperties
    globals()['IamFailureDetails'] = IamFailureDetails
    globals()['IamFeatureDefinition'] = IamFeatureDefinition
    globals()['IamGroupPermissionToRoles'] = IamGroupPermissionToRoles
    globals()['IamLdapBaseProperties'] = IamLdapBaseProperties
    globals()['IamLdapDnsParameters'] = IamLdapDnsParameters
    globals()['IamPermissionReference'] = IamPermissionReference
    globals()['IamPermissionToRoles'] = IamPermissionToRoles
    globals()['IamResourceRole'] = IamResourceRole
    globals()['IamRule'] = IamRule
    globals()['IamSamlSpConnection'] = IamSamlSpConnection
    globals()['IamSecurityContext'] = IamSecurityContext
    globals()['IamSsoSessionAttributes'] = IamSsoSessionAttributes
    globals()['IamSwitchAccountPermission'] = IamSwitchAccountPermission
    globals()['IamSwitchScopePermissions'] = IamSwitchScopePermissions
    globals()['IamUserDetails'] = IamUserDetails
    globals()['ImcconnectorWebUiMessage'] = ImcconnectorWebUiMessage
    globals()['InfraBaseGpuConfiguration'] = InfraBaseGpuConfiguration
    globals()['InfraBasePciConfiguration'] = InfraBasePciConfiguration
    globals()['InfraGpuConfiguration'] = InfraGpuConfiguration
    globals()['InfraHardwareInfo'] = InfraHardwareInfo
    globals()['InfraMetaData'] = InfraMetaData
    globals()['InfraMigGpuConfiguration'] = InfraMigGpuConfiguration
    globals()['InventoryInventoryMo'] = InventoryInventoryMo
    globals()['InventoryJobInfo'] = InventoryJobInfo
    globals()['InventoryUemInfo'] = InventoryUemInfo
    globals()['IppoolIpV4Block'] = IppoolIpV4Block
    globals()['IppoolIpV4Config'] = IppoolIpV4Config
    globals()['IppoolIpV6Block'] = IppoolIpV6Block
    globals()['IppoolIpV6Config'] = IppoolIpV6Config
    globals()['IppoolReservationReference'] = IppoolReservationReference
    globals()['IqnpoolIqnSuffixBlock'] = IqnpoolIqnSuffixBlock
    globals()['IqnpoolReservationReference'] = IqnpoolReservationReference
    globals()['IssueCondition'] = IssueCondition
    globals()['IssueDeviceTag'] = IssueDeviceTag
    globals()['IssueMessage'] = IssueMessage
    globals()['IssueOdataCondition'] = IssueOdataCondition
    globals()['KubernetesActionInfo'] = KubernetesActionInfo
    globals()['KubernetesAddon'] = KubernetesAddon
    globals()['KubernetesAddonConfiguration'] = KubernetesAddonConfiguration
    globals()['KubernetesAddonVersionReference'] = KubernetesAddonVersionReference
    globals()['KubernetesBaremetalNetworkInfo'] = KubernetesBaremetalNetworkInfo
    globals()['KubernetesBaseVirtualMachineInfraConfig'] = KubernetesBaseVirtualMachineInfraConfig
    globals()['KubernetesCalicoConfig'] = KubernetesCalicoConfig
    globals()['KubernetesClusterCertificateConfiguration'] = KubernetesClusterCertificateConfiguration
    globals()['KubernetesClusterManagementConfig'] = KubernetesClusterManagementConfig
    globals()['KubernetesCniConfig'] = KubernetesCniConfig
    globals()['KubernetesConfiguration'] = KubernetesConfiguration
    globals()['KubernetesDaemonSetStatus'] = KubernetesDaemonSetStatus
    globals()['KubernetesDeploymentStatus'] = KubernetesDeploymentStatus
    globals()['KubernetesEssentialAddon'] = KubernetesEssentialAddon
    globals()['KubernetesEsxiVirtualMachineInfraConfig'] = KubernetesEsxiVirtualMachineInfraConfig
    globals()['KubernetesEthernet'] = KubernetesEthernet
    globals()['KubernetesEthernetMatcher'] = KubernetesEthernetMatcher
    globals()['KubernetesIngressStatus'] = KubernetesIngressStatus
    globals()['KubernetesInstanceTypeDetails'] = KubernetesInstanceTypeDetails
    globals()['KubernetesIpV4Config'] = KubernetesIpV4Config
    globals()['KubernetesKeyValue'] = KubernetesKeyValue
    globals()['KubernetesLoadBalancer'] = KubernetesLoadBalancer
    globals()['KubernetesNetworkInterface'] = KubernetesNetworkInterface
    globals()['KubernetesNetworkInterfaceSpec'] = KubernetesNetworkInterfaceSpec
    globals()['KubernetesNodeAddress'] = KubernetesNodeAddress
    globals()['KubernetesNodeGroupLabel'] = KubernetesNodeGroupLabel
    globals()['KubernetesNodeGroupTaint'] = KubernetesNodeGroupTaint
    globals()['KubernetesNodeInfo'] = KubernetesNodeInfo
    globals()['KubernetesNodeSpec'] = KubernetesNodeSpec
    globals()['KubernetesNodeStatus'] = KubernetesNodeStatus
    globals()['KubernetesObjectMeta'] = KubernetesObjectMeta
    globals()['KubernetesOvsBond'] = KubernetesOvsBond
    globals()['KubernetesPodStatus'] = KubernetesPodStatus
    globals()['KubernetesProxyConfig'] = KubernetesProxyConfig
    globals()['KubernetesRoute'] = KubernetesRoute
    globals()['KubernetesServiceStatus'] = KubernetesServiceStatus
    globals()['KubernetesStatefulSetStatus'] = KubernetesStatefulSetStatus
    globals()['KubernetesTaint'] = KubernetesTaint
    globals()['LicenseSubstituteLicense'] = LicenseSubstituteLicense
    globals()['MacpoolBlock'] = MacpoolBlock
    globals()['MacpoolMemberOf'] = MacpoolMemberOf
    globals()['MacpoolReservationReference'] = MacpoolReservationReference
    globals()['MarketplaceUseCaseAutomation'] = MarketplaceUseCaseAutomation
    globals()['MarketplaceUseCaseDependency'] = MarketplaceUseCaseDependency
    globals()['MarketplaceUseCaseLocale'] = MarketplaceUseCaseLocale
    globals()['MarketplaceUseCaseVersionLocale'] = MarketplaceUseCaseVersionLocale
    globals()['MarketplaceUseCaseVersionResource'] = MarketplaceUseCaseVersionResource
    globals()['MemoryPersistentMemoryGoal'] = MemoryPersistentMemoryGoal
    globals()['MemoryPersistentMemoryLocalSecurity'] = MemoryPersistentMemoryLocalSecurity
    globals()['MemoryPersistentMemoryLogicalNamespace'] = MemoryPersistentMemoryLogicalNamespace
    globals()['MetaAccessPrivilege'] = MetaAccessPrivilege
    globals()['MetaDisplayNameDefinition'] = MetaDisplayNameDefinition
    globals()['MetaIdentityDefinition'] = MetaIdentityDefinition
    globals()['MetaPropDefinition'] = MetaPropDefinition
    globals()['MetaRelationshipDefinition'] = MetaRelationshipDefinition
    globals()['MetricsMetricCriterion'] = MetricsMetricCriterion
    globals()['MoVersionContext'] = MoVersionContext
    globals()['MonitoringCategoryStatus'] = MonitoringCategoryStatus
    globals()['MotemplateActionEntry'] = MotemplateActionEntry
    globals()['MotemplateActionParam'] = MotemplateActionParam
    globals()['MotemplateSyncError'] = MotemplateSyncError
    globals()['NetworkHyperFlexInternetProtocolAddressRange'] = NetworkHyperFlexInternetProtocolAddressRange
    globals()['NetworkHyperFlexNetworkAddress'] = NetworkHyperFlexNetworkAddress
    globals()['NiaapiDetail'] = NiaapiDetail
    globals()['NiaapiNewReleaseDetail'] = NiaapiNewReleaseDetail
    globals()['NiaapiRevisionInfo'] = NiaapiRevisionInfo
    globals()['NiaapiSoftwareRegex'] = NiaapiSoftwareRegex
    globals()['NiaapiVersionRegexPlatform'] = NiaapiVersionRegexPlatform
    globals()['NiatelemetryBootflashDetails'] = NiatelemetryBootflashDetails
    globals()['NiatelemetryCloudRegionsElement'] = NiatelemetryCloudRegionsElement
    globals()['NiatelemetryCloudRoutersElement'] = NiatelemetryCloudRoutersElement
    globals()['NiatelemetryDeploymentStatus'] = NiatelemetryDeploymentStatus
    globals()['NiatelemetryDigitalOpticalMonitoring'] = NiatelemetryDigitalOpticalMonitoring
    globals()['NiatelemetryDiskinfo'] = NiatelemetryDiskinfo
    globals()['NiatelemetryDomInfo'] = NiatelemetryDomInfo
    globals()['NiatelemetryDomThresInfo'] = NiatelemetryDomThresInfo
    globals()['NiatelemetryEqptStorageFirmware'] = NiatelemetryEqptStorageFirmware
    globals()['NiatelemetryEqptcapacityPolUsage5min'] = NiatelemetryEqptcapacityPolUsage5min
    globals()['NiatelemetryEqptcapacityPrefixEntries15min'] = NiatelemetryEqptcapacityPrefixEntries15min
    globals()['NiatelemetryEqptcapacityPrefixEntries5min'] = NiatelemetryEqptcapacityPrefixEntries5min
    globals()['NiatelemetryFanDetails'] = NiatelemetryFanDetails
    globals()['NiatelemetryImageDetail'] = NiatelemetryImageDetail
    globals()['NiatelemetryInterface'] = NiatelemetryInterface
    globals()['NiatelemetryInterfaceElement'] = NiatelemetryInterfaceElement
    globals()['NiatelemetryJobDetail'] = NiatelemetryJobDetail
    globals()['NiatelemetryLogicalLink'] = NiatelemetryLogicalLink
    globals()['NiatelemetryMdsNeighborInfo'] = NiatelemetryMdsNeighborInfo
    globals()['NiatelemetryNetworkInfo'] = NiatelemetryNetworkInfo
    globals()['NiatelemetryNode'] = NiatelemetryNode
    globals()['NiatelemetryNvePacketCounters'] = NiatelemetryNvePacketCounters
    globals()['NiatelemetryNveVni'] = NiatelemetryNveVni
    globals()['NiatelemetryNxosBgpEvpn'] = NiatelemetryNxosBgpEvpn
    globals()['NiatelemetryNxosBgpMvpn'] = NiatelemetryNxosBgpMvpn
    globals()['NiatelemetryNxosVtp'] = NiatelemetryNxosVtp
    globals()['NiatelemetryProcSysCpu15min'] = NiatelemetryProcSysCpu15min
    globals()['NiatelemetryProcSysCpu5min'] = NiatelemetryProcSysCpu5min
    globals()['NiatelemetryProcSysMem15min'] = NiatelemetryProcSysMem15min
    globals()['NiatelemetryProcSysMem5min'] = NiatelemetryProcSysMem5min
    globals()['NiatelemetrySites'] = NiatelemetrySites
    globals()['NiatelemetrySmartLicense'] = NiatelemetrySmartLicense
    globals()['NiatelemetrySwitchDiskUtilization'] = NiatelemetrySwitchDiskUtilization
    globals()['NiatelemetryVniStatus'] = NiatelemetryVniStatus
    globals()['NiatelemetryVpcDetails'] = NiatelemetryVpcDetails
    globals()['NotificationAbstractCondition'] = NotificationAbstractCondition
    globals()['NotificationAbstractMoCondition'] = NotificationAbstractMoCondition
    globals()['NotificationAction'] = NotificationAction
    globals()['NotificationAggregationSettings'] = NotificationAggregationSettings
    globals()['NotificationAlarmMoCondition'] = NotificationAlarmMoCondition
    globals()['NotificationApplianceUpgradeMoCondition'] = NotificationApplianceUpgradeMoCondition
    globals()['NotificationDistributableMoCondition'] = NotificationDistributableMoCondition
    globals()['NotificationMoCondition'] = NotificationMoCondition
    globals()['NotificationSendEmail'] = NotificationSendEmail
    globals()['NotificationSimpleFilter'] = NotificationSimpleFilter
    globals()['NotificationSimpleMoCondition'] = NotificationSimpleMoCondition
    globals()['NotificationSoftwareReleaseMetaMoCondition'] = NotificationSoftwareReleaseMetaMoCondition
    globals()['NotificationTriggerWebhook'] = NotificationTriggerWebhook
    globals()['NtpAuthNtpServer'] = NtpAuthNtpServer
    globals()['OnpremClusterInfo'] = OnpremClusterInfo
    globals()['OnpremClusterNode'] = OnpremClusterNode
    globals()['OnpremImagePackage'] = OnpremImagePackage
    globals()['OnpremResourceInfo'] = OnpremResourceInfo
    globals()['OnpremSchedule'] = OnpremSchedule
    globals()['OnpremUpgradeNote'] = OnpremUpgradeNote
    globals()['OnpremUpgradePhase'] = OnpremUpgradePhase
    globals()['OpenapiApiInfo'] = OpenapiApiInfo
    globals()['OpenapiFailedTask'] = OpenapiFailedTask
    globals()['OpenapiKeyValuePair'] = OpenapiKeyValuePair
    globals()['OprsKvpair'] = OprsKvpair
    globals()['OsAnswers'] = OsAnswers
    globals()['OsFibreChannelResponse'] = OsFibreChannelResponse
    globals()['OsFibreChannelTarget'] = OsFibreChannelTarget
    globals()['OsGlobalConfig'] = OsGlobalConfig
    globals()['OsInstallTarget'] = OsInstallTarget
    globals()['OsInstallTargetResponse'] = OsInstallTargetResponse
    globals()['OsIpConfiguration'] = OsIpConfiguration
    globals()['OsIpv4Configuration'] = OsIpv4Configuration
    globals()['OsIpv6Configuration'] = OsIpv6Configuration
    globals()['OsIscsiLunResponse'] = OsIscsiLunResponse
    globals()['OsIscsiTarget'] = OsIscsiTarget
    globals()['OsOperatingSystemParameters'] = OsOperatingSystemParameters
    globals()['OsPhysicalDisk'] = OsPhysicalDisk
    globals()['OsPhysicalDiskResponse'] = OsPhysicalDiskResponse
    globals()['OsPlaceHolder'] = OsPlaceHolder
    globals()['OsRemoteTargetResponse'] = OsRemoteTargetResponse
    globals()['OsSanTarget'] = OsSanTarget
    globals()['OsServerConfig'] = OsServerConfig
    globals()['OsValidationInformation'] = OsValidationInformation
    globals()['OsVirtualDrive'] = OsVirtualDrive
    globals()['OsVirtualDriveResponse'] = OsVirtualDriveResponse
    globals()['OsVmwareParameters'] = OsVmwareParameters
    globals()['OsWindowsParameters'] = OsWindowsParameters
    globals()['PartnerintegrationMetricsModel'] = PartnerintegrationMetricsModel
    globals()['PkixDistinguishedName'] = PkixDistinguishedName
    globals()['PkixEcdsaKeySpec'] = PkixEcdsaKeySpec
    globals()['PkixEddsaKeySpec'] = PkixEddsaKeySpec
    globals()['PkixKeyGenerationSpec'] = PkixKeyGenerationSpec
    globals()['PkixRsaAlgorithm'] = PkixRsaAlgorithm
    globals()['PkixSubjectAlternateName'] = PkixSubjectAlternateName
    globals()['PolicyActionParam'] = PolicyActionParam
    globals()['PolicyActionQualifier'] = PolicyActionQualifier
    globals()['PolicyConfigChange'] = PolicyConfigChange
    globals()['PolicyConfigChangeContext'] = PolicyConfigChangeContext
    globals()['PolicyConfigChangeDisruptionDetailType'] = PolicyConfigChangeDisruptionDetailType
    globals()['PolicyConfigContext'] = PolicyConfigContext
    globals()['PolicyConfigResultContext'] = PolicyConfigResultContext
    globals()['PolicyPolicyError'] = PolicyPolicyError
    globals()['PolicyPolicyStatus'] = PolicyPolicyStatus
    globals()['PolicyQualifier'] = PolicyQualifier
    globals()['PolicyScheduledAction'] = PolicyScheduledAction
    globals()['PoolAbstractBlockType'] = PoolAbstractBlockType
    globals()['PoolReservationReference'] = PoolReservationReference
    globals()['RecoveryBackupSchedule'] = RecoveryBackupSchedule
    globals()['RecoveryConfigParams'] = RecoveryConfigParams
    globals()['ResourceAdaptorsRangeFilter'] = ResourceAdaptorsRangeFilter
    globals()['ResourceAdvancedFilter'] = ResourceAdvancedFilter
    globals()['ResourceBladeQualifier'] = ResourceBladeQualifier
    globals()['ResourceChassisAndSlotQualification'] = ResourceChassisAndSlotQualification
    globals()['ResourceChassisIdRangeFilter'] = ResourceChassisIdRangeFilter
    globals()['ResourceChassisServersQualifier'] = ResourceChassisServersQualifier
    globals()['ResourceCpuCoreRangeFilter'] = ResourceCpuCoreRangeFilter
    globals()['ResourceCpuSpeedRangeFilter'] = ResourceCpuSpeedRangeFilter
    globals()['ResourceDomainQualifier'] = ResourceDomainQualifier
    globals()['ResourceGpuControllersRangeFilter'] = ResourceGpuControllersRangeFilter
    globals()['ResourceGpuQualifier'] = ResourceGpuQualifier
    globals()['ResourceHardwareQualifier'] = ResourceHardwareQualifier
    globals()['ResourceMemoryCapacityRangeFilter'] = ResourceMemoryCapacityRangeFilter
    globals()['ResourceMemoryQualifier'] = ResourceMemoryQualifier
    globals()['ResourceMemoryUnitsRangeFilter'] = ResourceMemoryUnitsRangeFilter
    globals()['ResourceNetworkAdaptorQualifier'] = ResourceNetworkAdaptorQualifier
    globals()['ResourceOdataRuleSetQualifier'] = ResourceOdataRuleSetQualifier
    globals()['ResourcePerTypeCombinedSelector'] = ResourcePerTypeCombinedSelector
    globals()['ResourceProcessorQualifier'] = ResourceProcessorQualifier
    globals()['ResourceRackIdRangeFilter'] = ResourceRackIdRangeFilter
    globals()['ResourceRackServerQualifier'] = ResourceRackServerQualifier
    globals()['ResourceRangeFilter'] = ResourceRangeFilter
    globals()['ResourceResourceQualifier'] = ResourceResourceQualifier
    globals()['ResourceRuleSetQualifier'] = ResourceRuleSetQualifier
    globals()['ResourceSelector'] = ResourceSelector
    globals()['ResourceServerQualifier'] = ResourceServerQualifier
    globals()['ResourceSlotIdRangeFilter'] = ResourceSlotIdRangeFilter
    globals()['ResourceSourceToPermissionResources'] = ResourceSourceToPermissionResources
    globals()['ResourceSourceToPermissionResourcesHolder'] = ResourceSourceToPermissionResourcesHolder
    globals()['ResourceTag'] = ResourceTag
    globals()['ResourceTagQualifier'] = ResourceTagQualifier
    globals()['ResourcepoolChildLeaseCondition'] = ResourcepoolChildLeaseCondition
    globals()['ResourcepoolLeaseParameters'] = ResourcepoolLeaseParameters
    globals()['ResourcepoolQualificationType'] = ResourcepoolQualificationType
    globals()['ResourcepoolResourceEvaluationStatus'] = ResourcepoolResourceEvaluationStatus
    globals()['ResourcepoolResourcePoolParameters'] = ResourcepoolResourcePoolParameters
    globals()['ResourcepoolServerLeaseParameters'] = ResourcepoolServerLeaseParameters
    globals()['ResourcepoolServerPoolParameters'] = ResourcepoolServerPoolParameters
    globals()['SchedulerAbstractSchedulingParams'] = SchedulerAbstractSchedulingParams
    globals()['SchedulerAbstractTaskRequest'] = SchedulerAbstractTaskRequest
    globals()['SchedulerBaseCadenceParams'] = SchedulerBaseCadenceParams
    globals()['SchedulerBaseMonthlyCadenceParams'] = SchedulerBaseMonthlyCadenceParams
    globals()['SchedulerBaseScheduleParams'] = SchedulerBaseScheduleParams
    globals()['SchedulerBlockDate'] = SchedulerBlockDate
    globals()['SchedulerDailyCadenceParams'] = SchedulerDailyCadenceParams
    globals()['SchedulerEveryCadenceParams'] = SchedulerEveryCadenceParams
    globals()['SchedulerMonthlyCadenceParams'] = SchedulerMonthlyCadenceParams
    globals()['SchedulerOneTimeScheduleParams'] = SchedulerOneTimeScheduleParams
    globals()['SchedulerRecurringScheduleParams'] = SchedulerRecurringScheduleParams
    globals()['SchedulerRestStimTaskRequest'] = SchedulerRestStimTaskRequest
    globals()['SchedulerTaskResultStatus'] = SchedulerTaskResultStatus
    globals()['SchedulerTaskSchedulePolicyExecutionStatus'] = SchedulerTaskSchedulePolicyExecutionStatus
    globals()['SchedulerTaskScheduleStatus'] = SchedulerTaskScheduleStatus
    globals()['SchedulerWeeklyCadenceParams'] = SchedulerWeeklyCadenceParams
    globals()['SdcardDiagnostics'] = SdcardDiagnostics
    globals()['SdcardDrivers'] = SdcardDrivers
    globals()['SdcardHostUpgradeUtility'] = SdcardHostUpgradeUtility
    globals()['SdcardOperatingSystem'] = SdcardOperatingSystem
    globals()['SdcardPartition'] = SdcardPartition
    globals()['SdcardServerConfigurationUtility'] = SdcardServerConfigurationUtility
    globals()['SdcardUserPartition'] = SdcardUserPartition
    globals()['SdcardVirtualDrive'] = SdcardVirtualDrive
    globals()['ServerPendingWorkflowTrigger'] = ServerPendingWorkflowTrigger
    globals()['ServerServerAssignTypeSlot'] = ServerServerAssignTypeSlot
    globals()['ServiceitemBaseMessage'] = ServiceitemBaseMessage
    globals()['ServiceitemHealthCheckErrorElement'] = ServiceitemHealthCheckErrorElement
    globals()['ServiceitemMessage'] = ServiceitemMessage
    globals()['ServiceitemSelectionCriteriaInput'] = ServiceitemSelectionCriteriaInput
    globals()['ServicerequestMessage'] = ServicerequestMessage
    globals()['SnmpTrap'] = SnmpTrap
    globals()['SnmpUser'] = SnmpUser
    globals()['SoftwarerepositoryApplianceUpload'] = SoftwarerepositoryApplianceUpload
    globals()['SoftwarerepositoryCifsServer'] = SoftwarerepositoryCifsServer
    globals()['SoftwarerepositoryConstraintModels'] = SoftwarerepositoryConstraintModels
    globals()['SoftwarerepositoryFileServer'] = SoftwarerepositoryFileServer
    globals()['SoftwarerepositoryHttpServer'] = SoftwarerepositoryHttpServer
    globals()['SoftwarerepositoryImportResult'] = SoftwarerepositoryImportResult
    globals()['SoftwarerepositoryLocalMachine'] = SoftwarerepositoryLocalMachine
    globals()['SoftwarerepositoryNfsServer'] = SoftwarerepositoryNfsServer
    globals()['SoftwarerepositoryUnsupportedModelConstraint'] = SoftwarerepositoryUnsupportedModelConstraint
    globals()['StorageAutomaticDriveGroup'] = StorageAutomaticDriveGroup
    globals()['StorageBaseCapacity'] = StorageBaseCapacity
    globals()['StorageBaseInitiator'] = StorageBaseInitiator
    globals()['StorageBasePerformanceMetricsAverage'] = StorageBasePerformanceMetricsAverage
    globals()['StorageBaseReplicationBlackout'] = StorageBaseReplicationBlackout
    globals()['StorageExternalLun'] = StorageExternalLun
    globals()['StorageExternalParityGroup'] = StorageExternalParityGroup
    globals()['StorageExternalPath'] = StorageExternalPath
    globals()['StorageHitachiArrayUtilization'] = StorageHitachiArrayUtilization
    globals()['StorageHitachiCapacity'] = StorageHitachiCapacity
    globals()['StorageHitachiInitiator'] = StorageHitachiInitiator
    globals()['StorageHostNqn'] = StorageHostNqn
    globals()['StorageHyperFlexIscsiInitiator'] = StorageHyperFlexIscsiInitiator
    globals()['StorageInitiator'] = StorageInitiator
    globals()['StorageInternalMoPhysicalDiskConfig'] = StorageInternalMoPhysicalDiskConfig
    globals()['StorageKeySetting'] = StorageKeySetting
    globals()['StorageKmipAuthCredentials'] = StorageKmipAuthCredentials
    globals()['StorageKmipServer'] = StorageKmipServer
    globals()['StorageLocalKeySetting'] = StorageLocalKeySetting
    globals()['StorageM2VirtualDriveConfig'] = StorageM2VirtualDriveConfig
    globals()['StorageManualDriveGroup'] = StorageManualDriveGroup
    globals()['StorageNamespace'] = StorageNamespace
    globals()['StorageNamespacePath'] = StorageNamespacePath
    globals()['StorageNetAppAutoSupport'] = StorageNetAppAutoSupport
    globals()['StorageNetAppCifsAcl'] = StorageNetAppCifsAcl
    globals()['StorageNetAppEthernetPortLag'] = StorageNetAppEthernetPortLag
    globals()['StorageNetAppEthernetPortVlan'] = StorageNetAppEthernetPortVlan
    globals()['StorageNetAppExportPolicyRule'] = StorageNetAppExportPolicyRule
    globals()['StorageNetAppHighAvailability'] = StorageNetAppHighAvailability
    globals()['StorageNetAppPerformanceMetricsAverage'] = StorageNetAppPerformanceMetricsAverage
    globals()['StorageNetAppPort'] = StorageNetAppPort
    globals()['StorageNetAppSnapshotPolicySchedule'] = StorageNetAppSnapshotPolicySchedule
    globals()['StorageNetAppStorageClusterEfficiency'] = StorageNetAppStorageClusterEfficiency
    globals()['StorageNetAppStorageUtilization'] = StorageNetAppStorageUtilization
    globals()['StorageNvmeDedicatedHotSpareConfiguration'] = StorageNvmeDedicatedHotSpareConfiguration
    globals()['StorageNvmePhysicalDiskState'] = StorageNvmePhysicalDiskState
    globals()['StorageNvmeRaidDriveGroup'] = StorageNvmeRaidDriveGroup
    globals()['StorageNvmeVirtualDriveConfiguration'] = StorageNvmeVirtualDriveConfiguration
    globals()['StoragePureArrayUtilization'] = StoragePureArrayUtilization
    globals()['StoragePureDiskUtilization'] = StoragePureDiskUtilization
    globals()['StoragePureHostUtilization'] = StoragePureHostUtilization
    globals()['StoragePureReplicationBlackout'] = StoragePureReplicationBlackout
    globals()['StoragePureVolumeUtilization'] = StoragePureVolumeUtilization
    globals()['StorageR0Drive'] = StorageR0Drive
    globals()['StorageRemoteKeySetting'] = StorageRemoteKeySetting
    globals()['StorageSpace'] = StorageSpace
    globals()['StorageSpanDrives'] = StorageSpanDrives
    globals()['StorageStorageContainerHostMountStatus'] = StorageStorageContainerHostMountStatus
    globals()['StorageStorageContainerUtilization'] = StorageStorageContainerUtilization
    globals()['StorageStorageUtilization'] = StorageStorageUtilization
    globals()['StorageVirtualDriveConfiguration'] = StorageVirtualDriveConfiguration
    globals()['StorageVirtualDrivePolicy'] = StorageVirtualDrivePolicy
    globals()['StorageVolumeUtilization'] = StorageVolumeUtilization
    globals()['SyslogLocalClientBase'] = SyslogLocalClientBase
    globals()['SyslogLocalFileLoggingClient'] = SyslogLocalFileLoggingClient
    globals()['SyslogRemoteClientBase'] = SyslogRemoteClientBase
    globals()['SyslogRemoteLoggingClient'] = SyslogRemoteLoggingClient
    globals()['TamAction'] = TamAction
    globals()['TamApiDataSource'] = TamApiDataSource
    globals()['TamBaseAdvisoryDetails'] = TamBaseAdvisoryDetails
    globals()['TamBaseDataSource'] = TamBaseDataSource
    globals()['TamEolAdvisoryDetails'] = TamEolAdvisoryDetails
    globals()['TamEolSeverity'] = TamEolSeverity
    globals()['TamFnSeverity'] = TamFnSeverity
    globals()['TamIdentifiers'] = TamIdentifiers
    globals()['TamMilestone'] = TamMilestone
    globals()['TamPsirtSeverity'] = TamPsirtSeverity
    globals()['TamQueryEntry'] = TamQueryEntry
    globals()['TamS3DataSource'] = TamS3DataSource
    globals()['TamSecurityAdvisoryDetails'] = TamSecurityAdvisoryDetails
    globals()['TamSeverity'] = TamSeverity
    globals()['TamTextFsmTemplateDataSource'] = TamTextFsmTemplateDataSource
    globals()['TaskFileDownloadInfo'] = TaskFileDownloadInfo
    globals()['TechsupportmanagementApplianceParam'] = TechsupportmanagementApplianceParam
    globals()['TechsupportmanagementNiaParam'] = TechsupportmanagementNiaParam
    globals()['TechsupportmanagementPlatformParam'] = TechsupportmanagementPlatformParam
    globals()['TechsupportmanagementTechSupportFileInfo'] = TechsupportmanagementTechSupportFileInfo
    globals()['TemplateTransformationStage'] = TemplateTransformationStage
    globals()['UcsdConnectorPack'] = UcsdConnectorPack
    globals()['UcsdUcsdRestoreParameters'] = UcsdUcsdRestoreParameters
    globals()['UcsdconnectorRestClientMessage'] = UcsdconnectorRestClientMessage
    globals()['UuidpoolReservationReference'] = UuidpoolReservationReference
    globals()['UuidpoolUuidBlock'] = UuidpoolUuidBlock
    globals()['VirtualizationActionInfo'] = VirtualizationActionInfo
    globals()['VirtualizationBaseCustomSpec'] = VirtualizationBaseCustomSpec
    globals()['VirtualizationBaseHostConfiguration'] = VirtualizationBaseHostConfiguration
    globals()['VirtualizationBaseVmConfiguration'] = VirtualizationBaseVmConfiguration
    globals()['VirtualizationCloudInitConfig'] = VirtualizationCloudInitConfig
    globals()['VirtualizationComputeCapacity'] = VirtualizationComputeCapacity
    globals()['VirtualizationCpuInfo'] = VirtualizationCpuInfo
    globals()['VirtualizationEsxiCloneCustomSpec'] = VirtualizationEsxiCloneCustomSpec
    globals()['VirtualizationEsxiHostConfiguration'] = VirtualizationEsxiHostConfiguration
    globals()['VirtualizationEsxiOvaCustomSpec'] = VirtualizationEsxiOvaCustomSpec
    globals()['VirtualizationEsxiVmComputeConfiguration'] = VirtualizationEsxiVmComputeConfiguration
    globals()['VirtualizationEsxiVmConfiguration'] = VirtualizationEsxiVmConfiguration
    globals()['VirtualizationEsxiVmNetworkConfiguration'] = VirtualizationEsxiVmNetworkConfiguration
    globals()['VirtualizationEsxiVmStorageConfiguration'] = VirtualizationEsxiVmStorageConfiguration
    globals()['VirtualizationGuestInfo'] = VirtualizationGuestInfo
    globals()['VirtualizationMemoryCapacity'] = VirtualizationMemoryCapacity
    globals()['VirtualizationNetworkInterface'] = VirtualizationNetworkInterface
    globals()['VirtualizationProductInfo'] = VirtualizationProductInfo
    globals()['VirtualizationStorageCapacity'] = VirtualizationStorageCapacity
    globals()['VirtualizationVirtualMachineDisk'] = VirtualizationVirtualMachineDisk
    globals()['VirtualizationVmEsxiDisk'] = VirtualizationVmEsxiDisk
    globals()['VirtualizationVmwareAttachedResourceTag'] = VirtualizationVmwareAttachedResourceTag
    globals()['VirtualizationVmwareDiscoveryProtocol'] = VirtualizationVmwareDiscoveryProtocol
    globals()['VirtualizationVmwareRemoteDisplayInfo'] = VirtualizationVmwareRemoteDisplayInfo
    globals()['VirtualizationVmwareResourceAllocationSystemTrafficTypes'] = VirtualizationVmwareResourceAllocationSystemTrafficTypes
    globals()['VirtualizationVmwareResourceConsumption'] = VirtualizationVmwareResourceConsumption
    globals()['VirtualizationVmwareSharesInfo'] = VirtualizationVmwareSharesInfo
    globals()['VirtualizationVmwareTeamingAndFailover'] = VirtualizationVmwareTeamingAndFailover
    globals()['VirtualizationVmwareVlanRange'] = VirtualizationVmwareVlanRange
    globals()['VirtualizationVmwareVmCpuShareInfo'] = VirtualizationVmwareVmCpuShareInfo
    globals()['VirtualizationVmwareVmCpuSocketInfo'] = VirtualizationVmwareVmCpuSocketInfo
    globals()['VirtualizationVmwareVmDiskCommitInfo'] = VirtualizationVmwareVmDiskCommitInfo
    globals()['VirtualizationVmwareVmMemoryShareInfo'] = VirtualizationVmwareVmMemoryShareInfo
    globals()['VmediaMapping'] = VmediaMapping
    globals()['VnicArfsSettings'] = VnicArfsSettings
    globals()['VnicCdn'] = VnicCdn
    globals()['VnicCompletionQueueSettings'] = VnicCompletionQueueSettings
    globals()['VnicEthIfOldInfo'] = VnicEthIfOldInfo
    globals()['VnicEthInterruptSettings'] = VnicEthInterruptSettings
    globals()['VnicEthRxQueueSettings'] = VnicEthRxQueueSettings
    globals()['VnicEthTxQueueSettings'] = VnicEthTxQueueSettings
    globals()['VnicFcErrorRecoverySettings'] = VnicFcErrorRecoverySettings
    globals()['VnicFcIfOldInfo'] = VnicFcIfOldInfo
    globals()['VnicFcInterruptSettings'] = VnicFcInterruptSettings
    globals()['VnicFcQueueSettings'] = VnicFcQueueSettings
    globals()['VnicFlogiSettings'] = VnicFlogiSettings
    globals()['VnicIscsiAuthProfile'] = VnicIscsiAuthProfile
    globals()['VnicLun'] = VnicLun
    globals()['VnicNvgreSettings'] = VnicNvgreSettings
    globals()['VnicPlacementSettings'] = VnicPlacementSettings
    globals()['VnicPlogiSettings'] = VnicPlogiSettings
    globals()['VnicPtpSettings'] = VnicPtpSettings
    globals()['VnicRoceSettings'] = VnicRoceSettings
    globals()['VnicRssHashSettings'] = VnicRssHashSettings
    globals()['VnicSanSettingsOldInfo'] = VnicSanSettingsOldInfo
    globals()['VnicScsiQueueSettings'] = VnicScsiQueueSettings
    globals()['VnicSriovSettings'] = VnicSriovSettings
    globals()['VnicTcpOffloadSettings'] = VnicTcpOffloadSettings
    globals()['VnicUsnicSettings'] = VnicUsnicSettings
    globals()['VnicVifStatus'] = VnicVifStatus
    globals()['VnicVlanSettings'] = VnicVlanSettings
    globals()['VnicVmqSettings'] = VnicVmqSettings
    globals()['VnicVsanSettings'] = VnicVsanSettings
    globals()['VnicVxlanSettings'] = VnicVxlanSettings
    globals()['WorkflowAbstractLoopTask'] = WorkflowAbstractLoopTask
    globals()['WorkflowAbstractResourceSelector'] = WorkflowAbstractResourceSelector
    globals()['WorkflowAbstractWorkerTask'] = WorkflowAbstractWorkerTask
    globals()['WorkflowAnsiblePlaySession'] = WorkflowAnsiblePlaySession
    globals()['WorkflowApi'] = WorkflowApi
    globals()['WorkflowArrayDataType'] = WorkflowArrayDataType
    globals()['WorkflowArrayItem'] = WorkflowArrayItem
    globals()['WorkflowAssociatedRoles'] = WorkflowAssociatedRoles
    globals()['WorkflowBaseDataType'] = WorkflowBaseDataType
    globals()['WorkflowBaseOperation'] = WorkflowBaseOperation
    globals()['WorkflowBaseServiceItemActionProperty'] = WorkflowBaseServiceItemActionProperty
    globals()['WorkflowCancelableType'] = WorkflowCancelableType
    globals()['WorkflowCliCommand'] = WorkflowCliCommand
    globals()['WorkflowComments'] = WorkflowComments
    globals()['WorkflowConstraints'] = WorkflowConstraints
    globals()['WorkflowControlTask'] = WorkflowControlTask
    globals()['WorkflowCustomArrayItem'] = WorkflowCustomArrayItem
    globals()['WorkflowCustomDataProperty'] = WorkflowCustomDataProperty
    globals()['WorkflowCustomDataType'] = WorkflowCustomDataType
    globals()['WorkflowCustomDataTypeProperties'] = WorkflowCustomDataTypeProperties
    globals()['WorkflowDataSourceSelector'] = WorkflowDataSourceSelector
    globals()['WorkflowDecisionCase'] = WorkflowDecisionCase
    globals()['WorkflowDecisionTask'] = WorkflowDecisionTask
    globals()['WorkflowDefaultValue'] = WorkflowDefaultValue
    globals()['WorkflowDisplayMeta'] = WorkflowDisplayMeta
    globals()['WorkflowDynamicTemplateParserDataType'] = WorkflowDynamicTemplateParserDataType
    globals()['WorkflowEndTask'] = WorkflowEndTask
    globals()['WorkflowEnumEntry'] = WorkflowEnumEntry
    globals()['WorkflowEnvironmentVariableReference'] = WorkflowEnvironmentVariableReference
    globals()['WorkflowExpectPrompt'] = WorkflowExpectPrompt
    globals()['WorkflowFailureEndTask'] = WorkflowFailureEndTask
    globals()['WorkflowFileDownloadOp'] = WorkflowFileDownloadOp
    globals()['WorkflowFileOperations'] = WorkflowFileOperations
    globals()['WorkflowFileTemplateOp'] = WorkflowFileTemplateOp
    globals()['WorkflowFileTransfer'] = WorkflowFileTransfer
    globals()['WorkflowForkTask'] = WorkflowForkTask
    globals()['WorkflowInitiatorContext'] = WorkflowInitiatorContext
    globals()['WorkflowInternalProperties'] = WorkflowInternalProperties
    globals()['WorkflowJoinTask'] = WorkflowJoinTask
    globals()['WorkflowLoopTask'] = WorkflowLoopTask
    globals()['WorkflowMessage'] = WorkflowMessage
    globals()['WorkflowMigrateServiceItemActionProperty'] = WorkflowMigrateServiceItemActionProperty
    globals()['WorkflowMigrationHistory'] = WorkflowMigrationHistory
    globals()['WorkflowMoInventoryDataType'] = WorkflowMoInventoryDataType
    globals()['WorkflowMoInventoryProperty'] = WorkflowMoInventoryProperty
    globals()['WorkflowMoReferenceArrayItem'] = WorkflowMoReferenceArrayItem
    globals()['WorkflowMoReferenceAutoArrayItem'] = WorkflowMoReferenceAutoArrayItem
    globals()['WorkflowMoReferenceAutoDataType'] = WorkflowMoReferenceAutoDataType
    globals()['WorkflowMoReferenceAutoProperty'] = WorkflowMoReferenceAutoProperty
    globals()['WorkflowMoReferenceDataType'] = WorkflowMoReferenceDataType
    globals()['WorkflowMoReferenceForCloneDataType'] = WorkflowMoReferenceForCloneDataType
    globals()['WorkflowMoReferenceProperty'] = WorkflowMoReferenceProperty
    globals()['WorkflowOperationTypeDecommission'] = WorkflowOperationTypeDecommission
    globals()['WorkflowOperationTypeDeployment'] = WorkflowOperationTypeDeployment
    globals()['WorkflowOperationTypePostDeployment'] = WorkflowOperationTypePostDeployment
    globals()['WorkflowParameterSet'] = WorkflowParameterSet
    globals()['WorkflowPowerShellApi'] = WorkflowPowerShellApi
    globals()['WorkflowPrimitiveArrayItem'] = WorkflowPrimitiveArrayItem
    globals()['WorkflowPrimitiveDataProperty'] = WorkflowPrimitiveDataProperty
    globals()['WorkflowPrimitiveDataType'] = WorkflowPrimitiveDataType
    globals()['WorkflowProperties'] = WorkflowProperties
    globals()['WorkflowResourceInlineSelector'] = WorkflowResourceInlineSelector
    globals()['WorkflowResourceSelectorCriteria'] = WorkflowResourceSelectorCriteria
    globals()['WorkflowResultHandler'] = WorkflowResultHandler
    globals()['WorkflowRollbackTask'] = WorkflowRollbackTask
    globals()['WorkflowRollbackWorkflowTask'] = WorkflowRollbackWorkflowTask
    globals()['WorkflowSelectorProperty'] = WorkflowSelectorProperty
    globals()['WorkflowSequenceParams'] = WorkflowSequenceParams
    globals()['WorkflowSerialLoopTask'] = WorkflowSerialLoopTask
    globals()['WorkflowServiceItemActionProperties'] = WorkflowServiceItemActionProperties
    globals()['WorkflowServiceItemActionWorkflowDefinition'] = WorkflowServiceItemActionWorkflowDefinition
    globals()['WorkflowServiceItemInputDefinitionType'] = WorkflowServiceItemInputDefinitionType
    globals()['WorkflowServiceItemType'] = WorkflowServiceItemType
    globals()['WorkflowSshCmd'] = WorkflowSshCmd
    globals()['WorkflowSshConfig'] = WorkflowSshConfig
    globals()['WorkflowSshSession'] = WorkflowSshSession
    globals()['WorkflowStartTask'] = WorkflowStartTask
    globals()['WorkflowSubWorkflowTask'] = WorkflowSubWorkflowTask
    globals()['WorkflowSuccessEndTask'] = WorkflowSuccessEndTask
    globals()['WorkflowTargetContext'] = WorkflowTargetContext
    globals()['WorkflowTargetDataType'] = WorkflowTargetDataType
    globals()['WorkflowTargetProperty'] = WorkflowTargetProperty
    globals()['WorkflowTaskConstraints'] = WorkflowTaskConstraints
    globals()['WorkflowTaskInfoUpdate'] = WorkflowTaskInfoUpdate
    globals()['WorkflowTaskLoopInfo'] = WorkflowTaskLoopInfo
    globals()['WorkflowTaskRetryInfo'] = WorkflowTaskRetryInfo
    globals()['WorkflowUiFormConfig'] = WorkflowUiFormConfig
    globals()['WorkflowUiInputFilter'] = WorkflowUiInputFilter
    globals()['WorkflowUiViewConfig'] = WorkflowUiViewConfig
    globals()['WorkflowValidationError'] = WorkflowValidationError
    globals()['WorkflowValidationInformation'] = WorkflowValidationInformation
    globals()['WorkflowWaitTask'] = WorkflowWaitTask
    globals()['WorkflowWaitTaskPrompt'] = WorkflowWaitTaskPrompt
    globals()['WorkflowWebApi'] = WorkflowWebApi
    globals()['WorkflowWorkerTask'] = WorkflowWorkerTask
    globals()['WorkflowWorkflowCtx'] = WorkflowWorkflowCtx
    globals()['WorkflowWorkflowEngineProperties'] = WorkflowWorkflowEngineProperties
    globals()['WorkflowWorkflowInfoAutoRestartProperties'] = WorkflowWorkflowInfoAutoRestartProperties
    globals()['WorkflowWorkflowInfoProperties'] = WorkflowWorkflowInfoProperties
    globals()['WorkflowWorkflowProperties'] = WorkflowWorkflowProperties
    globals()['WorkflowWorkflowTask'] = WorkflowWorkflowTask
    globals()['WorkflowXmlApi'] = WorkflowXmlApi
    globals()['WorkloadAssignedResource'] = WorkloadAssignedResource
    globals()['WorkloadBaseBlueprintReference'] = WorkloadBaseBlueprintReference
    globals()['WorkloadBatchDeployment'] = WorkloadBatchDeployment
    globals()['WorkloadBlueprintInputReference'] = WorkloadBlueprintInputReference
    globals()['WorkloadBlueprintReference'] = WorkloadBlueprintReference
    globals()['WorkloadCanaryDeployment'] = WorkloadCanaryDeployment
    globals()['WorkloadCloneStatus'] = WorkloadCloneStatus
    globals()['WorkloadCloneStatusEntry'] = WorkloadCloneStatusEntry
    globals()['WorkloadDefinitionMapper'] = WorkloadDefinitionMapper
    globals()['WorkloadDeploymentBlueprintInputType'] = WorkloadDeploymentBlueprintInputType
    globals()['WorkloadDeploymentChangeDetail'] = WorkloadDeploymentChangeDetail
    globals()['WorkloadGeneratedObject'] = WorkloadGeneratedObject
    globals()['WorkloadResourceConstraint'] = WorkloadResourceConstraint
    globals()['WorkloadRolloutStrategy'] = WorkloadRolloutStrategy
    globals()['WorkloadStateAggregation'] = WorkloadStateAggregation
    globals()['X509Certificate'] = X509Certificate


class MoBaseComplexType(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'AAA.USERAGENT': "aaa.UserAgent",
            'ACCESS.ADDRESSTYPE': "access.AddressType",
            'ACCESS.CONFIGURATIONTYPE': "access.ConfigurationType",
            'ADAPTER.ADAPTERCONFIG': "adapter.AdapterConfig",
            'ADAPTER.DCEINTERFACESETTINGS': "adapter.DceInterfaceSettings",
            'ADAPTER.ETHSETTINGS': "adapter.EthSettings",
            'ADAPTER.FCSETTINGS': "adapter.FcSettings",
            'ADAPTER.PHYSICALNICMODESETTINGS': "adapter.PhysicalNicModeSettings",
            'ADAPTER.PORTCHANNELSETTINGS': "adapter.PortChannelSettings",
            'APIC.FABRICLEAFNODEDETAILS': "apic.FabricLeafNodeDetails",
            'APPLIANCE.APISTATUS': "appliance.ApiStatus",
            'APPLIANCE.CERTRENEWALPHASE': "appliance.CertRenewalPhase",
            'APPLIANCE.CLUSTERINSTALLPHASE': "appliance.ClusterInstallPhase",
            'APPLIANCE.KEYVALUEPAIR': "appliance.KeyValuePair",
            'APPLIANCE.METADATAMANIFESTVERSION': "appliance.MetadataManifestVersion",
            'APPLIANCE.NETWORKSTATUS': "appliance.NetworkStatus",
            'APPLIANCE.NODEIPINFO': "appliance.NodeIpInfo",
            'APPLIANCE.STATUSCHECK': "appliance.StatusCheck",
            'ASSET.ADDRESSINFORMATION': "asset.AddressInformation",
            'ASSET.ALARMSUMMARY': "asset.AlarmSummary",
            'ASSET.APIKEYCREDENTIAL': "asset.ApiKeyCredential",
            'ASSET.CLIENTCERTIFICATECREDENTIAL': "asset.ClientCertificateCredential",
            'ASSET.CLOUDCONNECTION': "asset.CloudConnection",
            'ASSET.CONNECTIONFLAPSTATUS': "asset.ConnectionFlapStatus",
            'ASSET.CONTRACTINFORMATION': "asset.ContractInformation",
            'ASSET.CUSTOMERINFORMATION': "asset.CustomerInformation",
            'ASSET.DEPLOYMENTALARMINFO': "asset.DeploymentAlarmInfo",
            'ASSET.DEPLOYMENTDEVICEALARMINFO': "asset.DeploymentDeviceAlarmInfo",
            'ASSET.DEPLOYMENTDEVICEINFORMATION': "asset.DeploymentDeviceInformation",
            'ASSET.DEVICEENDPOINTLOCALCREDENTIAL': "asset.DeviceEndpointLocalCredential",
            'ASSET.DEVICEINFORMATION': "asset.DeviceInformation",
            'ASSET.DEVICESTATISTICS': "asset.DeviceStatistics",
            'ASSET.DEVICETRANSACTION': "asset.DeviceTransaction",
            'ASSET.GENERICTARGETCLAIMOPTIONS': "asset.GenericTargetClaimOptions",
            'ASSET.GLOBALULTIMATE': "asset.GlobalUltimate",
            'ASSET.GOOGLECLOUDPLATFORMSERVICEACCOUNTKEYCREDENTIAL': "asset.GoogleCloudPlatformServiceAccountKeyCredential",
            'ASSET.HTTPCONNECTION': "asset.HttpConnection",
            'ASSET.INTERSIGHTDEVICECONNECTORCONNECTION': "asset.IntersightDeviceConnectorConnection",
            'ASSET.MERAKICLOUDOPTIONS': "asset.MerakiCloudOptions",
            'ASSET.METERINGTYPE': "asset.MeteringType",
            'ASSET.NEWRELICCREDENTIAL': "asset.NewRelicCredential",
            'ASSET.NOAUTHENTICATIONCREDENTIAL': "asset.NoAuthenticationCredential",
            'ASSET.OAUTHBEARERTOKENCREDENTIAL': "asset.OauthBearerTokenCredential",
            'ASSET.OAUTHCLIENTIDSECRETCREDENTIAL': "asset.OauthClientIdSecretCredential",
            'ASSET.ORCHESTRATIONCIVPVMWAREVCENTEROPTIONS': "asset.OrchestrationCivpVmwareVcenterOptions",
            'ASSET.ORCHESTRATIONHITACHIVIRTUALSTORAGEPLATFORMOPTIONS': "asset.OrchestrationHitachiVirtualStoragePlatformOptions",
            'ASSET.ORCHESTRATIONHSMVMWAREVCENTEROPTIONS': "asset.OrchestrationHsmVmwareVcenterOptions",
            'ASSET.ORCHESTRATIONSERVICE': "asset.OrchestrationService",
            'ASSET.PARENTCONNECTIONSIGNATURE': "asset.ParentConnectionSignature",
            'ASSET.PRIVATEKEYCREDENTIAL': "asset.PrivateKeyCredential",
            'ASSET.PRODUCTINFORMATION': "asset.ProductInformation",
            'ASSET.SCOPEDTARGETCONNECTION': "asset.ScopedTargetConnection",
            'ASSET.SERVICENOWCREDENTIAL': "asset.ServiceNowCredential",
            'ASSET.SSHCONNECTION': "asset.SshConnection",
            'ASSET.SUDIINFO': "asset.SudiInfo",
            'ASSET.TARGETKEY': "asset.TargetKey",
            'ASSET.TARGETSIGNATURE': "asset.TargetSignature",
            'ASSET.TARGETSTATUSDETAILS': "asset.TargetStatusDetails",
            'ASSET.TERRAFORMINTEGRATIONSERVICE': "asset.TerraformIntegrationService",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMAGENTOPTIONS': "asset.TerraformIntegrationTerraformAgentOptions",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMCLOUDOPTIONS': "asset.TerraformIntegrationTerraformCloudOptions",
            'ASSET.USERNAMEPASSWORDCREDENTIAL': "asset.UsernamePasswordCredential",
            'ASSET.VIRTUALIZATIONAMAZONWEBSERVICEOPTIONS': "asset.VirtualizationAmazonWebServiceOptions",
            'ASSET.VIRTUALIZATIONSERVICE': "asset.VirtualizationService",
            'ASSET.VMHOST': "asset.VmHost",
            'ASSET.WORKLOADOPTIMIZERAMAZONWEBSERVICESBILLINGOPTIONS': "asset.WorkloadOptimizerAmazonWebServicesBillingOptions",
            'ASSET.WORKLOADOPTIMIZERDYNATRACEOPTIONS': "asset.WorkloadOptimizerDynatraceOptions",
            'ASSET.WORKLOADOPTIMIZERGOOGLECLOUDPLATFORMBILLINGOPTIONS': "asset.WorkloadOptimizerGoogleCloudPlatformBillingOptions",
            'ASSET.WORKLOADOPTIMIZERHYPERVOPTIONS': "asset.WorkloadOptimizerHypervOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREAPPLICATIONINSIGHTSOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureApplicationInsightsOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREBILLINGOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureBillingOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREENTERPRISEAGREEMENTOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureEnterpriseAgreementOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZURESERVICEPRINCIPALOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureServicePrincipalOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTSQLSERVEROPTIONS': "asset.WorkloadOptimizerMicrosoftSqlServerOptions",
            'ASSET.WORKLOADOPTIMIZERNEWRELICOPTIONS': "asset.WorkloadOptimizerNewRelicOptions",
            'ASSET.WORKLOADOPTIMIZEROPENSTACKOPTIONS': "asset.WorkloadOptimizerOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERORACLEDATABASESERVEROPTIONS': "asset.WorkloadOptimizerOracleDatabaseServerOptions",
            'ASSET.WORKLOADOPTIMIZERREDHATOPENSTACKOPTIONS': "asset.WorkloadOptimizerRedHatOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERSERVICE': "asset.WorkloadOptimizerService",
            'ASSET.WORKLOADOPTIMIZERVMWAREVCENTEROPTIONS': "asset.WorkloadOptimizerVmwareVcenterOptions",
            'BLUEPRINT.BLUEPRINTDEFINITIONDEPENDENCY': "blueprint.BlueprintDefinitionDependency",
            'BLUEPRINT.GENERATEDOBJECTMETADATA': "blueprint.GeneratedObjectMetadata",
            'BLUEPRINT.GENERATEDOBJECTNEW': "blueprint.GeneratedObjectNew",
            'BLUEPRINT.GENERATEDOBJECTOPERATIONTARGET': "blueprint.GeneratedObjectOperationTarget",
            'BLUEPRINT.GENERATEDOBJECTSOURCECLONE': "blueprint.GeneratedObjectSourceClone",
            'BLUEPRINT.GENERATEDOBJECTSOURCELOOKUP': "blueprint.GeneratedObjectSourceLookup",
            'BLUEPRINT.GENERATEDOBJECTSOURCEMERGE': "blueprint.GeneratedObjectSourceMerge",
            'BLUEPRINT.GENERATEDOBJECTSOURCEREFERENCE': "blueprint.GeneratedObjectSourceReference",
            'BLUEPRINT.GENERATEDOBJECTSOURCESELECTOR': "blueprint.GeneratedObjectSourceSelector",
            'BLUEPRINT.INPUTOPERATIONTYPE': "blueprint.InputOperationType",
            'BLUEPRINT.PREGENERATEOPERATION': "blueprint.PreGenerateOperation",
            'BLUEPRINT.PROPERTYITERATION': "blueprint.PropertyIteration",
            'BLUEPRINT.RESOURCECONSTRAINTS': "blueprint.ResourceConstraints",
            'BLUEPRINT.SERVICEITEMDEFINITION': "blueprint.ServiceItemDefinition",
            'BOOT.BOOTLOADER': "boot.Bootloader",
            'BOOT.FLEXMMC': "boot.FlexMmc",
            'BOOT.HTTP': "boot.Http",
            'BOOT.ISCSI': "boot.Iscsi",
            'BOOT.LOCALCDD': "boot.LocalCdd",
            'BOOT.LOCALDISK': "boot.LocalDisk",
            'BOOT.NVME': "boot.Nvme",
            'BOOT.PCHSTORAGE': "boot.PchStorage",
            'BOOT.PXE': "boot.Pxe",
            'BOOT.SAN': "boot.San",
            'BOOT.SDCARD': "boot.SdCard",
            'BOOT.STATICIPV4SETTINGS': "boot.StaticIpV4Settings",
            'BOOT.STATICIPV6SETTINGS': "boot.StaticIpV6Settings",
            'BOOT.UEFISHELL': "boot.UefiShell",
            'BOOT.USB': "boot.Usb",
            'BOOT.VIRTUALMEDIA': "boot.VirtualMedia",
            'BULK.HTTPHEADER': "bulk.HttpHeader",
            'BULK.MULTIRELATIONENTRYPATCH': "bulk.MultiRelationEntryPatch",
            'BULK.PATCHCONTENT': "bulk.PatchContent",
            'BULK.RESTRESULT': "bulk.RestResult",
            'BULK.RESTSUBREQUEST': "bulk.RestSubRequest",
            'BULK.SECRESOURCEROLES': "bulk.SecResourceRoles",
            'CAPABILITY.CERTIFICATEPROPERTYCONSTRAINTS': "capability.CertificatePropertyConstraints",
            'CAPABILITY.FEATURECONFIG': "capability.FeatureConfig",
            'CAPABILITY.HSUISOMODELSPECIFICCONSTRAINT': "capability.HsuIsoModelSpecificConstraint",
            'CAPABILITY.LDAPBASEPROPERTYCONSTRAINTS': "capability.LdapBasePropertyConstraints",
            'CAPABILITY.PCIDRANGE': "capability.PcIdRange",
            'CAPABILITY.PORTRANGE': "capability.PortRange",
            'CAPABILITY.SERVERCOMPONENTCONSTRAINT': "capability.ServerComponentConstraint",
            'CAPABILITY.SWITCHNETWORKLIMITS': "capability.SwitchNetworkLimits",
            'CAPABILITY.SWITCHSTORAGELIMITS': "capability.SwitchStorageLimits",
            'CAPABILITY.SWITCHSYSTEMLIMITS': "capability.SwitchSystemLimits",
            'CAPABILITY.SWITCHINGMODECAPABILITY': "capability.SwitchingModeCapability",
            'CAPABILITY.UNSUPPORTEDFEATURECONFIG': "capability.UnsupportedFeatureConfig",
            'CAPABILITY.UPDATEORDERLISTTYPE': "capability.UpdateOrderListType",
            'CERTIFICATEMANAGEMENT.IMC': "certificatemanagement.Imc",
            'CERTIFICATEMANAGEMENT.ROOTCACERTIFICATE': "certificatemanagement.RootCaCertificate",
            'CLOUD.TFCWORKSPACEVARIABLES': "cloud.TfcWorkspaceVariables",
            'CMRF.CMRF': "cmrf.CmRf",
            'COMM.GEOLOCATIONDETAILS': "comm.GeoLocationDetails",
            'COMM.GEOPOINT': "comm.GeoPoint",
            'COMM.IPV4ADDRESSBLOCK': "comm.IpV4AddressBlock",
            'COMM.IPV4INTERFACE': "comm.IpV4Interface",
            'COMM.IPV6INTERFACE': "comm.IpV6Interface",
            'COMM.PHYSICALADDRESS': "comm.PhysicalAddress",
            'COMM.TAGUSAGE': "comm.TagUsage",
            'COMPUTE.ALARMSUMMARY': "compute.AlarmSummary",
            'COMPUTE.IPADDRESS': "compute.IpAddress",
            'COMPUTE.PENDINGWORKFLOWTRIGGER': "compute.PendingWorkflowTrigger",
            'COMPUTE.PERSISTENTMEMORYMODULE': "compute.PersistentMemoryModule",
            'COMPUTE.PERSISTENTMEMORYOPERATION': "compute.PersistentMemoryOperation",
            'COMPUTE.PERSONALITYSETTING': "compute.PersonalitySetting",
            'COMPUTE.SCRUBOPCONFIGUTATION': "compute.ScrubOpConfigutation",
            'COMPUTE.SERVERCONFIG': "compute.ServerConfig",
            'COMPUTE.SERVEROPSTATUS': "compute.ServerOpStatus",
            'COMPUTE.STORAGECONTROLLEROPERATION': "compute.StorageControllerOperation",
            'COMPUTE.STORAGEPHYSICALDRIVE': "compute.StoragePhysicalDrive",
            'COMPUTE.STORAGEPHYSICALDRIVEOPERATION': "compute.StoragePhysicalDriveOperation",
            'COMPUTE.STORAGEUTILITYIMAGEOPERATION': "compute.StorageUtilityImageOperation",
            'COMPUTE.STORAGEVIRTUALDRIVE': "compute.StorageVirtualDrive",
            'COMPUTE.STORAGEVIRTUALDRIVEOPERATION': "compute.StorageVirtualDriveOperation",
            'COND.ALARMACTION': "cond.AlarmAction",
            'COND.ALARMCLASSIFICATIONELIGIBILITY': "cond.AlarmClassificationEligibility",
            'COND.ALARMSPEC': "cond.AlarmSpec",
            'COND.ALARMSUMMARY': "cond.AlarmSummary",
            'CONNECTOR.CLOSESTREAMMESSAGE': "connector.CloseStreamMessage",
            'CONNECTOR.COMMANDCONTROLMESSAGE': "connector.CommandControlMessage",
            'CONNECTOR.COMMANDTERMINALSTREAM': "connector.CommandTerminalStream",
            'CONNECTOR.EVENTLOG': "connector.EventLog",
            'CONNECTOR.EXPECTPROMPT': "connector.ExpectPrompt",
            'CONNECTOR.FETCHSTREAMMESSAGE': "connector.FetchStreamMessage",
            'CONNECTOR.FILECHECKSUM': "connector.FileChecksum",
            'CONNECTOR.FILEMESSAGE': "connector.FileMessage",
            'CONNECTOR.HTTPREQUEST': "connector.HttpRequest",
            'CONNECTOR.SSHCONFIG': "connector.SshConfig",
            'CONNECTOR.SSHMESSAGE': "connector.SshMessage",
            'CONNECTOR.STARTSTREAM': "connector.StartStream",
            'CONNECTOR.STARTSTREAMFROMDEVICE': "connector.StartStreamFromDevice",
            'CONNECTOR.STREAMACKNOWLEDGE': "connector.StreamAcknowledge",
            'CONNECTOR.STREAMINPUT': "connector.StreamInput",
            'CONNECTOR.STREAMKEEPALIVE': "connector.StreamKeepalive",
            'CONNECTOR.TARGETCHANGEMESSAGE': "connector.TargetChangeMessage",
            'CONNECTOR.TARGETSPECIFICATION': "connector.TargetSpecification",
            'CONNECTOR.URL': "connector.Url",
            'CONNECTOR.WINRMREQUEST': "connector.WinrmRequest",
            'CONNECTOR.XMLAPIMESSAGE': "connector.XmlApiMessage",
            'CONNECTORPACK.CONNECTORPACKUPDATE': "connectorpack.ConnectorPackUpdate",
            'CONTENT.COMPLEXTYPE': "content.ComplexType",
            'CONTENT.PARAMETER': "content.Parameter",
            'CONTENT.TEXTPARAMETER': "content.TextParameter",
            'CONVERGEDINFRA.ALARMSUMMARY': "convergedinfra.AlarmSummary",
            'CONVERGEDINFRA.COMPLIANCESUMMARY': "convergedinfra.ComplianceSummary",
            'CONVERGEDINFRA.PODSUMMARY': "convergedinfra.PodSummary",
            'CRD.CUSTOMRESOURCECONFIGPROPERTY': "crd.CustomResourceConfigProperty",
            'EQUIPMENT.CHASSISOPERATIONSTATUS': "equipment.ChassisOperationStatus",
            'EQUIPMENT.DEVICELOCATION': "equipment.DeviceLocation",
            'EQUIPMENT.IOCARDIDENTITY': "equipment.IoCardIdentity",
            'EQUIPMENT.IOCARDOPERATIONSTATUS': "equipment.IoCardOperationStatus",
            'EQUIPMENT.RESETACTION': "equipment.ResetAction",
            'ETHER.MACSECOPERDATA': "ether.MacsecOperData",
            'FABRIC.CLUSTERASSIGNMENT': "fabric.ClusterAssignment",
            'FABRIC.FCZONEMEMBER': "fabric.FcZoneMember",
            'FABRIC.LLDPSETTINGS': "fabric.LldpSettings",
            'FABRIC.MACAGINGSETTINGS': "fabric.MacAgingSettings",
            'FABRIC.MACSECEAPOL': "fabric.MacSecEaPol",
            'FABRIC.PORTIDENTIFIER': "fabric.PortIdentifier",
            'FABRIC.QOSCLASS': "fabric.QosClass",
            'FABRIC.SECKEY': "fabric.SecKey",
            'FABRIC.SECKEYCHAIN': "fabric.SecKeyChain",
            'FABRIC.UDLDGLOBALSETTINGS': "fabric.UdldGlobalSettings",
            'FABRIC.UDLDSETTINGS': "fabric.UdldSettings",
            'FABRIC.VLANSETTINGS': "fabric.VlanSettings",
            'FCPOOL.BLOCK': "fcpool.Block",
            'FCPOOL.RESERVATIONREFERENCE': "fcpool.ReservationReference",
            'FEEDBACK.FEEDBACKDATA': "feedback.FeedbackData",
            'FIRMWARE.CHASSISUPGRADEIMPACT': "firmware.ChassisUpgradeImpact",
            'FIRMWARE.CIFSSERVER': "firmware.CifsServer",
            'FIRMWARE.COMPONENTIMPACT': "firmware.ComponentImpact",
            'FIRMWARE.COMPONENTMETA': "firmware.ComponentMeta",
            'FIRMWARE.DIRECTDOWNLOAD': "firmware.DirectDownload",
            'FIRMWARE.EXCLUDECOMPONENTPIDLISTTYPE': "firmware.ExcludeComponentPidListType",
            'FIRMWARE.FABRICUPGRADEIMPACT': "firmware.FabricUpgradeImpact",
            'FIRMWARE.FEATUREVERSIONMAP': "firmware.FeatureVersionMap",
            'FIRMWARE.FIRMWAREINVENTORY': "firmware.FirmwareInventory",
            'FIRMWARE.HTTPSERVER': "firmware.HttpServer",
            'FIRMWARE.MODELBUNDLEVERSION': "firmware.ModelBundleVersion",
            'FIRMWARE.NETWORKSHARE': "firmware.NetworkShare",
            'FIRMWARE.NFSSERVER': "firmware.NfsServer",
            'FIRMWARE.SERVERUPGRADEIMPACT': "firmware.ServerUpgradeImpact",
            'FIRMWARE.VERSIONMAP': "firmware.VersionMap",
            'FORECAST.MODEL': "forecast.Model",
            'HCI.AHVGUESTTOOLS': "hci.AhvGuestTools",
            'HCI.ALARMPARAMETER': "hci.AlarmParameter",
            'HCI.ALARMSUMMARY': "hci.AlarmSummary",
            'HCI.APILIMIT': "hci.ApiLimit",
            'HCI.BACKPLANENETWORKPARAMS': "hci.BackplaneNetworkParams",
            'HCI.CAPACITYVIOLATION': "hci.CapacityViolation",
            'HCI.CONSUMPTION': "hci.Consumption",
            'HCI.ENTITLEMENTDETAIL': "hci.EntitlementDetail",
            'HCI.ESXIGUESTTOOLS': "hci.EsxiGuestTools",
            'HCI.EXPIREDLICENSE': "hci.ExpiredLicense",
            'HCI.FAULTTOLERANCESTATE': "hci.FaultToleranceState",
            'HCI.FEATUREVIOLATION': "hci.FeatureViolation",
            'HCI.IPADDRESS': "hci.IpAddress",
            'HCI.IPADDRESSORFQDN': "hci.IpAddressOrFqdn",
            'HCI.KEYMANAGEMENTDEVICETOCERTSTATUSINFO': "hci.KeyManagementDeviceToCertStatusInfo",
            'HCI.LICENSEDSERVICE': "hci.LicensedService",
            'HCI.MANAGEMENTSERVER': "hci.ManagementServer",
            'HCI.PULSESTATUS': "hci.PulseStatus",
            'HCI.SBDF': "hci.Sbdf",
            'HCI.SERVICEVIOLATION': "hci.ServiceViolation",
            'HCI.SOFTWARETYPE': "hci.SoftwareType",
            'HCI.VIRTUALGPUCONFIG': "hci.VirtualGpuConfig",
            'HCL.CONSTRAINT': "hcl.Constraint",
            'HCL.FIRMWARE': "hcl.Firmware",
            'HCL.HARDWARECOMPATIBILITYPROFILE': "hcl.HardwareCompatibilityProfile",
            'HCL.PRODUCT': "hcl.Product",
            'HYPERFLEX.ALARMSUMMARY': "hyperflex.AlarmSummary",
            'HYPERFLEX.APPSETTINGCONSTRAINT': "hyperflex.AppSettingConstraint",
            'HYPERFLEX.BACKUPPOLICYSETTINGS': "hyperflex.BackupPolicySettings",
            'HYPERFLEX.CAPABILITY': "hyperflex.Capability",
            'HYPERFLEX.DATASTOREINFO': "hyperflex.DatastoreInfo",
            'HYPERFLEX.ENTITYREFERENCE': "hyperflex.EntityReference",
            'HYPERFLEX.ERRORSTACK': "hyperflex.ErrorStack",
            'HYPERFLEX.FEATURELIMITENTRY': "hyperflex.FeatureLimitEntry",
            'HYPERFLEX.FILEPATH': "hyperflex.FilePath",
            'HYPERFLEX.HEALTHCHECKNODELEVELINFO': "hyperflex.HealthCheckNodeLevelInfo",
            'HYPERFLEX.HEALTHCHECKSCRIPTINFO': "hyperflex.HealthCheckScriptInfo",
            'HYPERFLEX.HXHOSTMOUNTSTATUSDT': "hyperflex.HxHostMountStatusDt",
            'HYPERFLEX.HXLICENSEAUTHORIZATIONDETAILSDT': "hyperflex.HxLicenseAuthorizationDetailsDt",
            'HYPERFLEX.HXLINKDT': "hyperflex.HxLinkDt",
            'HYPERFLEX.HXNETWORKADDRESSDT': "hyperflex.HxNetworkAddressDt",
            'HYPERFLEX.HXPLATFORMDATASTORECONFIGDT': "hyperflex.HxPlatformDatastoreConfigDt",
            'HYPERFLEX.HXREGISTRATIONDETAILSDT': "hyperflex.HxRegistrationDetailsDt",
            'HYPERFLEX.HXRESILIENCYINFODT': "hyperflex.HxResiliencyInfoDt",
            'HYPERFLEX.HXSITEDT': "hyperflex.HxSiteDt",
            'HYPERFLEX.HXUUIDDT': "hyperflex.HxUuIdDt",
            'HYPERFLEX.HXZONEINFODT': "hyperflex.HxZoneInfoDt",
            'HYPERFLEX.HXZONERESILIENCYINFODT': "hyperflex.HxZoneResiliencyInfoDt",
            'HYPERFLEX.IPADDRRANGE': "hyperflex.IpAddrRange",
            'HYPERFLEX.LOGICALAVAILABILITYZONE': "hyperflex.LogicalAvailabilityZone",
            'HYPERFLEX.MACADDRPREFIXRANGE': "hyperflex.MacAddrPrefixRange",
            'HYPERFLEX.MAPCLUSTERIDTOPROTECTIONINFO': "hyperflex.MapClusterIdToProtectionInfo",
            'HYPERFLEX.MAPCLUSTERIDTOSTSNAPSHOTPOINT': "hyperflex.MapClusterIdToStSnapshotPoint",
            'HYPERFLEX.MAPUUIDTOTRACKEDDISK': "hyperflex.MapUuidToTrackedDisk",
            'HYPERFLEX.NAMEDVLAN': "hyperflex.NamedVlan",
            'HYPERFLEX.NAMEDVSAN': "hyperflex.NamedVsan",
            'HYPERFLEX.NETWORKCONFIGURATION': "hyperflex.NetworkConfiguration",
            'HYPERFLEX.PORTTYPETOPORTNUMBERMAP': "hyperflex.PortTypeToPortNumberMap",
            'HYPERFLEX.PROTECTIONINFO': "hyperflex.ProtectionInfo",
            'HYPERFLEX.RESYNCCLUSTERMOIDS': "hyperflex.ReSyncClusterMoIds",
            'HYPERFLEX.REPLICATIONCLUSTERREFERENCETOSCHEDULE': "hyperflex.ReplicationClusterReferenceToSchedule",
            'HYPERFLEX.REPLICATIONPEERINFO': "hyperflex.ReplicationPeerInfo",
            'HYPERFLEX.REPLICATIONPLATDATASTORE': "hyperflex.ReplicationPlatDatastore",
            'HYPERFLEX.REPLICATIONPLATDATASTOREPAIR': "hyperflex.ReplicationPlatDatastorePair",
            'HYPERFLEX.REPLICATIONSCHEDULE': "hyperflex.ReplicationSchedule",
            'HYPERFLEX.REPLICATIONSTATUS': "hyperflex.ReplicationStatus",
            'HYPERFLEX.RPOSTATUS': "hyperflex.RpoStatus",
            'HYPERFLEX.SERVERFIRMWAREVERSIONINFO': "hyperflex.ServerFirmwareVersionInfo",
            'HYPERFLEX.SERVERMODELENTRY': "hyperflex.ServerModelEntry",
            'HYPERFLEX.SITEDETAILS': "hyperflex.SiteDetails",
            'HYPERFLEX.SNAPSHOTFILES': "hyperflex.SnapshotFiles",
            'HYPERFLEX.SNAPSHOTINFOBRIEF': "hyperflex.SnapshotInfoBrief",
            'HYPERFLEX.SNAPSHOTPOINT': "hyperflex.SnapshotPoint",
            'HYPERFLEX.SNAPSHOTSTATUS': "hyperflex.SnapshotStatus",
            'HYPERFLEX.STPLATFORMCLUSTERHEALINGINFO': "hyperflex.StPlatformClusterHealingInfo",
            'HYPERFLEX.STPLATFORMCLUSTERRESILIENCYINFO': "hyperflex.StPlatformClusterResiliencyInfo",
            'HYPERFLEX.SUMMARY': "hyperflex.Summary",
            'HYPERFLEX.TRACKEDDISK': "hyperflex.TrackedDisk",
            'HYPERFLEX.TRACKEDFILE': "hyperflex.TrackedFile",
            'HYPERFLEX.VCENTERCONFIGURATION': "hyperflex.VcenterConfiguration",
            'HYPERFLEX.VIRTUALMACHINE': "hyperflex.VirtualMachine",
            'HYPERFLEX.VIRTUALMACHINERUNTIMEINFO': "hyperflex.VirtualMachineRuntimeInfo",
            'HYPERFLEX.VMPROTECTIONSPACEUSAGE': "hyperflex.VmProtectionSpaceUsage",
            'HYPERFLEX.WWXNPREFIXRANGE': "hyperflex.WwxnPrefixRange",
            'I18N.MESSAGE': "i18n.Message",
            'I18N.MESSAGEPARAM': "i18n.MessageParam",
            'IAAS.LICENSEKEYSINFO': "iaas.LicenseKeysInfo",
            'IAAS.LICENSEUTILIZATIONINFO': "iaas.LicenseUtilizationInfo",
            'IAAS.WORKFLOWSTEPS': "iaas.WorkflowSteps",
            'IAM.ACCOUNTPERMISSIONS': "iam.AccountPermissions",
            'IAM.ACCOUNTTAGS': "iam.AccountTags",
            'IAM.BASICAUTHCREDENTIALS': "iam.BasicAuthCredentials",
            'IAM.CLIENTMETA': "iam.ClientMeta",
            'IAM.ENDPOINTPASSWORDPROPERTIES': "iam.EndPointPasswordProperties",
            'IAM.FAILUREDETAILS': "iam.FailureDetails",
            'IAM.FEATUREDEFINITION': "iam.FeatureDefinition",
            'IAM.GROUPPERMISSIONTOROLES': "iam.GroupPermissionToRoles",
            'IAM.LDAPBASEPROPERTIES': "iam.LdapBaseProperties",
            'IAM.LDAPDNSPARAMETERS': "iam.LdapDnsParameters",
            'IAM.PERMISSIONREFERENCE': "iam.PermissionReference",
            'IAM.PERMISSIONTOROLES': "iam.PermissionToRoles",
            'IAM.RESOURCEROLE': "iam.ResourceRole",
            'IAM.RULE': "iam.Rule",
            'IAM.SAMLSPCONNECTION': "iam.SamlSpConnection",
            'IAM.SECURITYCONTEXT': "iam.SecurityContext",
            'IAM.SSOSESSIONATTRIBUTES': "iam.SsoSessionAttributes",
            'IAM.SWITCHACCOUNTPERMISSION': "iam.SwitchAccountPermission",
            'IAM.SWITCHSCOPEPERMISSIONS': "iam.SwitchScopePermissions",
            'IAM.USERDETAILS': "iam.UserDetails",
            'IMCCONNECTOR.WEBUIMESSAGE': "imcconnector.WebUiMessage",
            'INFRA.GPUCONFIGURATION': "infra.GpuConfiguration",
            'INFRA.HARDWAREINFO': "infra.HardwareInfo",
            'INFRA.METADATA': "infra.MetaData",
            'INFRA.MIGGPUCONFIGURATION': "infra.MigGpuConfiguration",
            'INVENTORY.INVENTORYMO': "inventory.InventoryMo",
            'INVENTORY.JOBINFO': "inventory.JobInfo",
            'INVENTORY.UEMINFO': "inventory.UemInfo",
            'IPPOOL.IPV4BLOCK': "ippool.IpV4Block",
            'IPPOOL.IPV4CONFIG': "ippool.IpV4Config",
            'IPPOOL.IPV6BLOCK': "ippool.IpV6Block",
            'IPPOOL.IPV6CONFIG': "ippool.IpV6Config",
            'IPPOOL.RESERVATIONREFERENCE': "ippool.ReservationReference",
            'IQNPOOL.IQNSUFFIXBLOCK': "iqnpool.IqnSuffixBlock",
            'IQNPOOL.RESERVATIONREFERENCE': "iqnpool.ReservationReference",
            'ISSUE.DEVICETAG': "issue.DeviceTag",
            'ISSUE.MESSAGE': "issue.Message",
            'ISSUE.ODATACONDITION': "issue.OdataCondition",
            'KUBERNETES.ACTIONINFO': "kubernetes.ActionInfo",
            'KUBERNETES.ADDON': "kubernetes.Addon",
            'KUBERNETES.ADDONCONFIGURATION': "kubernetes.AddonConfiguration",
            'KUBERNETES.ADDONVERSIONREFERENCE': "kubernetes.AddonVersionReference",
            'KUBERNETES.BAREMETALNETWORKINFO': "kubernetes.BaremetalNetworkInfo",
            'KUBERNETES.CALICOCONFIG': "kubernetes.CalicoConfig",
            'KUBERNETES.CLUSTERCERTIFICATECONFIGURATION': "kubernetes.ClusterCertificateConfiguration",
            'KUBERNETES.CLUSTERMANAGEMENTCONFIG': "kubernetes.ClusterManagementConfig",
            'KUBERNETES.CONFIGURATION': "kubernetes.Configuration",
            'KUBERNETES.DAEMONSETSTATUS': "kubernetes.DaemonSetStatus",
            'KUBERNETES.DEPLOYMENTSTATUS': "kubernetes.DeploymentStatus",
            'KUBERNETES.ESSENTIALADDON': "kubernetes.EssentialAddon",
            'KUBERNETES.ESXIVIRTUALMACHINEINFRACONFIG': "kubernetes.EsxiVirtualMachineInfraConfig",
            'KUBERNETES.ETHERNET': "kubernetes.Ethernet",
            'KUBERNETES.ETHERNETMATCHER': "kubernetes.EthernetMatcher",
            'KUBERNETES.INGRESSSTATUS': "kubernetes.IngressStatus",
            'KUBERNETES.INSTANCETYPEDETAILS': "kubernetes.InstanceTypeDetails",
            'KUBERNETES.IPV4CONFIG': "kubernetes.IpV4Config",
            'KUBERNETES.KEYVALUE': "kubernetes.KeyValue",
            'KUBERNETES.LOADBALANCER': "kubernetes.LoadBalancer",
            'KUBERNETES.NETWORKINTERFACESPEC': "kubernetes.NetworkInterfaceSpec",
            'KUBERNETES.NODEADDRESS': "kubernetes.NodeAddress",
            'KUBERNETES.NODEGROUPLABEL': "kubernetes.NodeGroupLabel",
            'KUBERNETES.NODEGROUPTAINT': "kubernetes.NodeGroupTaint",
            'KUBERNETES.NODEINFO': "kubernetes.NodeInfo",
            'KUBERNETES.NODESPEC': "kubernetes.NodeSpec",
            'KUBERNETES.NODESTATUS': "kubernetes.NodeStatus",
            'KUBERNETES.OBJECTMETA': "kubernetes.ObjectMeta",
            'KUBERNETES.OVSBOND': "kubernetes.OvsBond",
            'KUBERNETES.PODSTATUS': "kubernetes.PodStatus",
            'KUBERNETES.PROXYCONFIG': "kubernetes.ProxyConfig",
            'KUBERNETES.ROUTE': "kubernetes.Route",
            'KUBERNETES.SERVICESTATUS': "kubernetes.ServiceStatus",
            'KUBERNETES.STATEFULSETSTATUS': "kubernetes.StatefulSetStatus",
            'KUBERNETES.TAINT': "kubernetes.Taint",
            'LICENSE.SUBSTITUTELICENSE': "license.SubstituteLicense",
            'MACPOOL.BLOCK': "macpool.Block",
            'MACPOOL.MEMBEROF': "macpool.MemberOf",
            'MACPOOL.RESERVATIONREFERENCE': "macpool.ReservationReference",
            'MARKETPLACE.USECASEAUTOMATION': "marketplace.UseCaseAutomation",
            'MARKETPLACE.USECASEDEPENDENCY': "marketplace.UseCaseDependency",
            'MARKETPLACE.USECASELOCALE': "marketplace.UseCaseLocale",
            'MARKETPLACE.USECASEVERSIONLOCALE': "marketplace.UseCaseVersionLocale",
            'MARKETPLACE.USECASEVERSIONRESOURCE': "marketplace.UseCaseVersionResource",
            'MEMORY.PERSISTENTMEMORYGOAL': "memory.PersistentMemoryGoal",
            'MEMORY.PERSISTENTMEMORYLOCALSECURITY': "memory.PersistentMemoryLocalSecurity",
            'MEMORY.PERSISTENTMEMORYLOGICALNAMESPACE': "memory.PersistentMemoryLogicalNamespace",
            'META.ACCESSPRIVILEGE': "meta.AccessPrivilege",
            'META.DISPLAYNAMEDEFINITION': "meta.DisplayNameDefinition",
            'META.IDENTITYDEFINITION': "meta.IdentityDefinition",
            'META.PROPDEFINITION': "meta.PropDefinition",
            'META.RELATIONSHIPDEFINITION': "meta.RelationshipDefinition",
            'METRICS.METRICCRITERION': "metrics.MetricCriterion",
            'MO.MOREF': "mo.MoRef",
            'MO.TAG': "mo.Tag",
            'MO.VERSIONCONTEXT': "mo.VersionContext",
            'MONITORING.CATEGORYSTATUS': "monitoring.CategoryStatus",
            'MOTEMPLATE.ACTIONENTRY': "motemplate.ActionEntry",
            'MOTEMPLATE.ACTIONPARAM': "motemplate.ActionParam",
            'MOTEMPLATE.SYNCERROR': "motemplate.SyncError",
            'NETWORK.HYPERFLEXINTERNETPROTOCOLADDRESSRANGE': "network.HyperFlexInternetProtocolAddressRange",
            'NETWORK.HYPERFLEXNETWORKADDRESS': "network.HyperFlexNetworkAddress",
            'NIAAPI.DETAIL': "niaapi.Detail",
            'NIAAPI.NEWRELEASEDETAIL': "niaapi.NewReleaseDetail",
            'NIAAPI.REVISIONINFO': "niaapi.RevisionInfo",
            'NIAAPI.SOFTWAREREGEX': "niaapi.SoftwareRegex",
            'NIAAPI.VERSIONREGEXPLATFORM': "niaapi.VersionRegexPlatform",
            'NIATELEMETRY.BOOTFLASHDETAILS': "niatelemetry.BootflashDetails",
            'NIATELEMETRY.CLOUDREGIONSELEMENT': "niatelemetry.CloudRegionsElement",
            'NIATELEMETRY.CLOUDROUTERSELEMENT': "niatelemetry.CloudRoutersElement",
            'NIATELEMETRY.DEPLOYMENTSTATUS': "niatelemetry.DeploymentStatus",
            'NIATELEMETRY.DIGITALOPTICALMONITORING': "niatelemetry.DigitalOpticalMonitoring",
            'NIATELEMETRY.DISKINFO': "niatelemetry.Diskinfo",
            'NIATELEMETRY.DOMINFO': "niatelemetry.DomInfo",
            'NIATELEMETRY.DOMTHRESINFO': "niatelemetry.DomThresInfo",
            'NIATELEMETRY.EQPTSTORAGEFIRMWARE': "niatelemetry.EqptStorageFirmware",
            'NIATELEMETRY.EQPTCAPACITYPOLUSAGE5MIN': "niatelemetry.EqptcapacityPolUsage5min",
            'NIATELEMETRY.EQPTCAPACITYPREFIXENTRIES15MIN': "niatelemetry.EqptcapacityPrefixEntries15min",
            'NIATELEMETRY.EQPTCAPACITYPREFIXENTRIES5MIN': "niatelemetry.EqptcapacityPrefixEntries5min",
            'NIATELEMETRY.FANDETAILS': "niatelemetry.FanDetails",
            'NIATELEMETRY.IMAGEDETAIL': "niatelemetry.ImageDetail",
            'NIATELEMETRY.INTERFACE': "niatelemetry.Interface",
            'NIATELEMETRY.INTERFACEELEMENT': "niatelemetry.InterfaceElement",
            'NIATELEMETRY.JOBDETAIL': "niatelemetry.JobDetail",
            'NIATELEMETRY.LOGICALLINK': "niatelemetry.LogicalLink",
            'NIATELEMETRY.MDSNEIGHBORINFO': "niatelemetry.MdsNeighborInfo",
            'NIATELEMETRY.NETWORKINFO': "niatelemetry.NetworkInfo",
            'NIATELEMETRY.NODE': "niatelemetry.Node",
            'NIATELEMETRY.NVEPACKETCOUNTERS': "niatelemetry.NvePacketCounters",
            'NIATELEMETRY.NVEVNI': "niatelemetry.NveVni",
            'NIATELEMETRY.NXOSBGPEVPN': "niatelemetry.NxosBgpEvpn",
            'NIATELEMETRY.NXOSBGPMVPN': "niatelemetry.NxosBgpMvpn",
            'NIATELEMETRY.NXOSVTP': "niatelemetry.NxosVtp",
            'NIATELEMETRY.PROCSYSCPU15MIN': "niatelemetry.ProcSysCpu15min",
            'NIATELEMETRY.PROCSYSCPU5MIN': "niatelemetry.ProcSysCpu5min",
            'NIATELEMETRY.PROCSYSMEM15MIN': "niatelemetry.ProcSysMem15min",
            'NIATELEMETRY.PROCSYSMEM5MIN': "niatelemetry.ProcSysMem5min",
            'NIATELEMETRY.SITES': "niatelemetry.Sites",
            'NIATELEMETRY.SMARTLICENSE': "niatelemetry.SmartLicense",
            'NIATELEMETRY.SWITCHDISKUTILIZATION': "niatelemetry.SwitchDiskUtilization",
            'NIATELEMETRY.VNISTATUS': "niatelemetry.VniStatus",
            'NIATELEMETRY.VPCDETAILS': "niatelemetry.VpcDetails",
            'NOTIFICATION.AGGREGATIONSETTINGS': "notification.AggregationSettings",
            'NOTIFICATION.ALARMMOCONDITION': "notification.AlarmMoCondition",
            'NOTIFICATION.APPLIANCEUPGRADEMOCONDITION': "notification.ApplianceUpgradeMoCondition",
            'NOTIFICATION.DISTRIBUTABLEMOCONDITION': "notification.DistributableMoCondition",
            'NOTIFICATION.MOCONDITION': "notification.MoCondition",
            'NOTIFICATION.SENDEMAIL': "notification.SendEmail",
            'NOTIFICATION.SIMPLEFILTER': "notification.SimpleFilter",
            'NOTIFICATION.SIMPLEMOCONDITION': "notification.SimpleMoCondition",
            'NOTIFICATION.SOFTWARERELEASEMETAMOCONDITION': "notification.SoftwareReleaseMetaMoCondition",
            'NOTIFICATION.TRIGGERWEBHOOK': "notification.TriggerWebhook",
            'NTP.AUTHNTPSERVER': "ntp.AuthNtpServer",
            'ONPREM.CLUSTERINFO': "onprem.ClusterInfo",
            'ONPREM.CLUSTERNODE': "onprem.ClusterNode",
            'ONPREM.IMAGEPACKAGE': "onprem.ImagePackage",
            'ONPREM.RESOURCEINFO': "onprem.ResourceInfo",
            'ONPREM.SCHEDULE': "onprem.Schedule",
            'ONPREM.UPGRADENOTE': "onprem.UpgradeNote",
            'ONPREM.UPGRADEPHASE': "onprem.UpgradePhase",
            'OPENAPI.APIINFO': "openapi.ApiInfo",
            'OPENAPI.FAILEDTASK': "openapi.FailedTask",
            'OPENAPI.KEYVALUEPAIR': "openapi.KeyValuePair",
            'OPRS.KVPAIR': "oprs.Kvpair",
            'OS.ANSWERS': "os.Answers",
            'OS.FIBRECHANNELRESPONSE': "os.FibreChannelResponse",
            'OS.FIBRECHANNELTARGET': "os.FibreChannelTarget",
            'OS.GLOBALCONFIG': "os.GlobalConfig",
            'OS.IPV4CONFIGURATION': "os.Ipv4Configuration",
            'OS.IPV6CONFIGURATION': "os.Ipv6Configuration",
            'OS.ISCSILUNRESPONSE': "os.IscsiLunResponse",
            'OS.ISCSITARGET': "os.IscsiTarget",
            'OS.PHYSICALDISK': "os.PhysicalDisk",
            'OS.PHYSICALDISKRESPONSE': "os.PhysicalDiskResponse",
            'OS.PLACEHOLDER': "os.PlaceHolder",
            'OS.SERVERCONFIG': "os.ServerConfig",
            'OS.VALIDATIONINFORMATION': "os.ValidationInformation",
            'OS.VIRTUALDRIVE': "os.VirtualDrive",
            'OS.VIRTUALDRIVERESPONSE': "os.VirtualDriveResponse",
            'OS.VMWAREPARAMETERS': "os.VmwareParameters",
            'OS.WINDOWSPARAMETERS': "os.WindowsParameters",
            'PARTNERINTEGRATION.METRICSMODEL': "partnerintegration.MetricsModel",
            'PKIX.DISTINGUISHEDNAME': "pkix.DistinguishedName",
            'PKIX.ECDSAKEYSPEC': "pkix.EcdsaKeySpec",
            'PKIX.EDDSAKEYSPEC': "pkix.EddsaKeySpec",
            'PKIX.RSAALGORITHM': "pkix.RsaAlgorithm",
            'PKIX.SUBJECTALTERNATENAME': "pkix.SubjectAlternateName",
            'POLICY.ACTIONPARAM': "policy.ActionParam",
            'POLICY.ACTIONQUALIFIER': "policy.ActionQualifier",
            'POLICY.CONFIGCHANGE': "policy.ConfigChange",
            'POLICY.CONFIGCHANGECONTEXT': "policy.ConfigChangeContext",
            'POLICY.CONFIGCHANGEDISRUPTIONDETAILTYPE': "policy.ConfigChangeDisruptionDetailType",
            'POLICY.CONFIGCONTEXT': "policy.ConfigContext",
            'POLICY.CONFIGRESULTCONTEXT': "policy.ConfigResultContext",
            'POLICY.POLICYERROR': "policy.PolicyError",
            'POLICY.POLICYSTATUS': "policy.PolicyStatus",
            'POLICY.QUALIFIER': "policy.Qualifier",
            'POLICY.SCHEDULEDACTION': "policy.ScheduledAction",
            'RECOVERY.BACKUPSCHEDULE': "recovery.BackupSchedule",
            'RESOURCE.ADAPTORSRANGEFILTER': "resource.AdaptorsRangeFilter",
            'RESOURCE.BLADEQUALIFIER': "resource.BladeQualifier",
            'RESOURCE.CHASSISANDSLOTQUALIFICATION': "resource.ChassisAndSlotQualification",
            'RESOURCE.CHASSISIDRANGEFILTER': "resource.ChassisIdRangeFilter",
            'RESOURCE.CHASSISSERVERSQUALIFIER': "resource.ChassisServersQualifier",
            'RESOURCE.CPUCORERANGEFILTER': "resource.CpuCoreRangeFilter",
            'RESOURCE.CPUSPEEDRANGEFILTER': "resource.CpuSpeedRangeFilter",
            'RESOURCE.DOMAINQUALIFIER': "resource.DomainQualifier",
            'RESOURCE.GPUCONTROLLERSRANGEFILTER': "resource.GpuControllersRangeFilter",
            'RESOURCE.GPUQUALIFIER': "resource.GpuQualifier",
            'RESOURCE.MEMORYCAPACITYRANGEFILTER': "resource.MemoryCapacityRangeFilter",
            'RESOURCE.MEMORYQUALIFIER': "resource.MemoryQualifier",
            'RESOURCE.MEMORYUNITSRANGEFILTER': "resource.MemoryUnitsRangeFilter",
            'RESOURCE.NETWORKADAPTORQUALIFIER': "resource.NetworkAdaptorQualifier",
            'RESOURCE.ODATARULESETQUALIFIER': "resource.OdataRuleSetQualifier",
            'RESOURCE.PERTYPECOMBINEDSELECTOR': "resource.PerTypeCombinedSelector",
            'RESOURCE.PROCESSORQUALIFIER': "resource.ProcessorQualifier",
            'RESOURCE.RACKIDRANGEFILTER': "resource.RackIdRangeFilter",
            'RESOURCE.RACKSERVERQUALIFIER': "resource.RackServerQualifier",
            'RESOURCE.SELECTOR': "resource.Selector",
            'RESOURCE.SLOTIDRANGEFILTER': "resource.SlotIdRangeFilter",
            'RESOURCE.SOURCETOPERMISSIONRESOURCES': "resource.SourceToPermissionResources",
            'RESOURCE.SOURCETOPERMISSIONRESOURCESHOLDER': "resource.SourceToPermissionResourcesHolder",
            'RESOURCE.TAG': "resource.Tag",
            'RESOURCE.TAGQUALIFIER': "resource.TagQualifier",
            'RESOURCEPOOL.CHILDLEASECONDITION': "resourcepool.ChildLeaseCondition",
            'RESOURCEPOOL.QUALIFICATIONTYPE': "resourcepool.QualificationType",
            'RESOURCEPOOL.RESOURCEEVALUATIONSTATUS': "resourcepool.ResourceEvaluationStatus",
            'RESOURCEPOOL.SERVERLEASEPARAMETERS': "resourcepool.ServerLeaseParameters",
            'RESOURCEPOOL.SERVERPOOLPARAMETERS': "resourcepool.ServerPoolParameters",
            'SCHEDULER.BLOCKDATE': "scheduler.BlockDate",
            'SCHEDULER.DAILYCADENCEPARAMS': "scheduler.DailyCadenceParams",
            'SCHEDULER.EVERYCADENCEPARAMS': "scheduler.EveryCadenceParams",
            'SCHEDULER.MONTHLYCADENCEPARAMS': "scheduler.MonthlyCadenceParams",
            'SCHEDULER.ONETIMESCHEDULEPARAMS': "scheduler.OneTimeScheduleParams",
            'SCHEDULER.RECURRINGSCHEDULEPARAMS': "scheduler.RecurringScheduleParams",
            'SCHEDULER.RESTSTIMTASKREQUEST': "scheduler.RestStimTaskRequest",
            'SCHEDULER.TASKRESULTSTATUS': "scheduler.TaskResultStatus",
            'SCHEDULER.TASKSCHEDULEPOLICYEXECUTIONSTATUS': "scheduler.TaskSchedulePolicyExecutionStatus",
            'SCHEDULER.TASKSCHEDULESTATUS': "scheduler.TaskScheduleStatus",
            'SCHEDULER.WEEKLYCADENCEPARAMS': "scheduler.WeeklyCadenceParams",
            'SDCARD.DIAGNOSTICS': "sdcard.Diagnostics",
            'SDCARD.DRIVERS': "sdcard.Drivers",
            'SDCARD.HOSTUPGRADEUTILITY': "sdcard.HostUpgradeUtility",
            'SDCARD.OPERATINGSYSTEM': "sdcard.OperatingSystem",
            'SDCARD.PARTITION': "sdcard.Partition",
            'SDCARD.SERVERCONFIGURATIONUTILITY': "sdcard.ServerConfigurationUtility",
            'SDCARD.USERPARTITION': "sdcard.UserPartition",
            'SERVER.PENDINGWORKFLOWTRIGGER': "server.PendingWorkflowTrigger",
            'SERVER.SERVERASSIGNTYPESLOT': "server.ServerAssignTypeSlot",
            'SERVICEITEM.HEALTHCHECKERRORELEMENT': "serviceitem.HealthCheckErrorElement",
            'SERVICEITEM.MESSAGE': "serviceitem.Message",
            'SERVICEITEM.SELECTIONCRITERIAINPUT': "serviceitem.SelectionCriteriaInput",
            'SERVICEREQUEST.MESSAGE': "servicerequest.Message",
            'SNMP.TRAP': "snmp.Trap",
            'SNMP.USER': "snmp.User",
            'SOFTWAREREPOSITORY.APPLIANCEUPLOAD': "softwarerepository.ApplianceUpload",
            'SOFTWAREREPOSITORY.CIFSSERVER': "softwarerepository.CifsServer",
            'SOFTWAREREPOSITORY.CONSTRAINTMODELS': "softwarerepository.ConstraintModels",
            'SOFTWAREREPOSITORY.HTTPSERVER': "softwarerepository.HttpServer",
            'SOFTWAREREPOSITORY.IMPORTRESULT': "softwarerepository.ImportResult",
            'SOFTWAREREPOSITORY.LOCALMACHINE': "softwarerepository.LocalMachine",
            'SOFTWAREREPOSITORY.NFSSERVER': "softwarerepository.NfsServer",
            'SOFTWAREREPOSITORY.UNSUPPORTEDMODELCONSTRAINT': "softwarerepository.UnsupportedModelConstraint",
            'STORAGE.AUTOMATICDRIVEGROUP': "storage.AutomaticDriveGroup",
            'STORAGE.EXTERNALLUN': "storage.ExternalLun",
            'STORAGE.EXTERNALPARITYGROUP': "storage.ExternalParityGroup",
            'STORAGE.EXTERNALPATH': "storage.ExternalPath",
            'STORAGE.HITACHIARRAYUTILIZATION': "storage.HitachiArrayUtilization",
            'STORAGE.HITACHICAPACITY': "storage.HitachiCapacity",
            'STORAGE.HITACHIINITIATOR': "storage.HitachiInitiator",
            'STORAGE.HOSTNQN': "storage.HostNqn",
            'STORAGE.HYPERFLEXISCSIINITIATOR': "storage.HyperFlexIscsiInitiator",
            'STORAGE.INITIATOR': "storage.Initiator",
            'STORAGE.INTERNALMOPHYSICALDISKCONFIG': "storage.InternalMoPhysicalDiskConfig",
            'STORAGE.KEYSETTING': "storage.KeySetting",
            'STORAGE.KMIPAUTHCREDENTIALS': "storage.KmipAuthCredentials",
            'STORAGE.KMIPSERVER': "storage.KmipServer",
            'STORAGE.LOCALKEYSETTING': "storage.LocalKeySetting",
            'STORAGE.M2VIRTUALDRIVECONFIG': "storage.M2VirtualDriveConfig",
            'STORAGE.MANUALDRIVEGROUP': "storage.ManualDriveGroup",
            'STORAGE.NAMESPACE': "storage.Namespace",
            'STORAGE.NAMESPACEPATH': "storage.NamespacePath",
            'STORAGE.NETAPPAUTOSUPPORT': "storage.NetAppAutoSupport",
            'STORAGE.NETAPPCIFSACL': "storage.NetAppCifsAcl",
            'STORAGE.NETAPPETHERNETPORTLAG': "storage.NetAppEthernetPortLag",
            'STORAGE.NETAPPETHERNETPORTVLAN': "storage.NetAppEthernetPortVlan",
            'STORAGE.NETAPPEXPORTPOLICYRULE': "storage.NetAppExportPolicyRule",
            'STORAGE.NETAPPHIGHAVAILABILITY': "storage.NetAppHighAvailability",
            'STORAGE.NETAPPPERFORMANCEMETRICSAVERAGE': "storage.NetAppPerformanceMetricsAverage",
            'STORAGE.NETAPPPORT': "storage.NetAppPort",
            'STORAGE.NETAPPSNAPSHOTPOLICYSCHEDULE': "storage.NetAppSnapshotPolicySchedule",
            'STORAGE.NETAPPSTORAGECLUSTEREFFICIENCY': "storage.NetAppStorageClusterEfficiency",
            'STORAGE.NETAPPSTORAGEUTILIZATION': "storage.NetAppStorageUtilization",
            'STORAGE.NVMEDEDICATEDHOTSPARECONFIGURATION': "storage.NvmeDedicatedHotSpareConfiguration",
            'STORAGE.NVMEPHYSICALDISKSTATE': "storage.NvmePhysicalDiskState",
            'STORAGE.NVMERAIDDRIVEGROUP': "storage.NvmeRaidDriveGroup",
            'STORAGE.NVMEVIRTUALDRIVECONFIGURATION': "storage.NvmeVirtualDriveConfiguration",
            'STORAGE.PUREARRAYUTILIZATION': "storage.PureArrayUtilization",
            'STORAGE.PUREDISKUTILIZATION': "storage.PureDiskUtilization",
            'STORAGE.PUREHOSTUTILIZATION': "storage.PureHostUtilization",
            'STORAGE.PUREREPLICATIONBLACKOUT': "storage.PureReplicationBlackout",
            'STORAGE.PUREVOLUMEUTILIZATION': "storage.PureVolumeUtilization",
            'STORAGE.R0DRIVE': "storage.R0Drive",
            'STORAGE.REMOTEKEYSETTING': "storage.RemoteKeySetting",
            'STORAGE.SPACE': "storage.Space",
            'STORAGE.SPANDRIVES': "storage.SpanDrives",
            'STORAGE.STORAGECONTAINERHOSTMOUNTSTATUS': "storage.StorageContainerHostMountStatus",
            'STORAGE.STORAGECONTAINERUTILIZATION': "storage.StorageContainerUtilization",
            'STORAGE.VIRTUALDRIVECONFIGURATION': "storage.VirtualDriveConfiguration",
            'STORAGE.VIRTUALDRIVEPOLICY': "storage.VirtualDrivePolicy",
            'STORAGE.VOLUMEUTILIZATION': "storage.VolumeUtilization",
            'SYSLOG.LOCALFILELOGGINGCLIENT': "syslog.LocalFileLoggingClient",
            'SYSLOG.REMOTELOGGINGCLIENT': "syslog.RemoteLoggingClient",
            'TAM.ACTION': "tam.Action",
            'TAM.APIDATASOURCE': "tam.ApiDataSource",
            'TAM.EOLADVISORYDETAILS': "tam.EolAdvisoryDetails",
            'TAM.EOLSEVERITY': "tam.EolSeverity",
            'TAM.FNSEVERITY': "tam.FnSeverity",
            'TAM.IDENTIFIERS': "tam.Identifiers",
            'TAM.MILESTONE': "tam.Milestone",
            'TAM.PSIRTSEVERITY': "tam.PsirtSeverity",
            'TAM.QUERYENTRY': "tam.QueryEntry",
            'TAM.S3DATASOURCE': "tam.S3DataSource",
            'TAM.SECURITYADVISORYDETAILS': "tam.SecurityAdvisoryDetails",
            'TAM.TEXTFSMTEMPLATEDATASOURCE': "tam.TextFsmTemplateDataSource",
            'TASK.FILEDOWNLOADINFO': "task.FileDownloadInfo",
            'TECHSUPPORTMANAGEMENT.APPLIANCEPARAM': "techsupportmanagement.ApplianceParam",
            'TECHSUPPORTMANAGEMENT.NIAPARAM': "techsupportmanagement.NiaParam",
            'TECHSUPPORTMANAGEMENT.PLATFORMPARAM': "techsupportmanagement.PlatformParam",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTFILEINFO': "techsupportmanagement.TechSupportFileInfo",
            'TEMPLATE.TRANSFORMATIONSTAGE': "template.TransformationStage",
            'UCSD.CONNECTORPACK': "ucsd.ConnectorPack",
            'UCSD.UCSDRESTOREPARAMETERS': "ucsd.UcsdRestoreParameters",
            'UCSDCONNECTOR.RESTCLIENTMESSAGE': "ucsdconnector.RestClientMessage",
            'UUIDPOOL.RESERVATIONREFERENCE': "uuidpool.ReservationReference",
            'UUIDPOOL.UUIDBLOCK': "uuidpool.UuidBlock",
            'VIRTUALIZATION.ACTIONINFO': "virtualization.ActionInfo",
            'VIRTUALIZATION.CLOUDINITCONFIG': "virtualization.CloudInitConfig",
            'VIRTUALIZATION.COMPUTECAPACITY': "virtualization.ComputeCapacity",
            'VIRTUALIZATION.CPUINFO': "virtualization.CpuInfo",
            'VIRTUALIZATION.ESXICLONECUSTOMSPEC': "virtualization.EsxiCloneCustomSpec",
            'VIRTUALIZATION.ESXIHOSTCONFIGURATION': "virtualization.EsxiHostConfiguration",
            'VIRTUALIZATION.ESXIOVACUSTOMSPEC': "virtualization.EsxiOvaCustomSpec",
            'VIRTUALIZATION.ESXIVMCOMPUTECONFIGURATION': "virtualization.EsxiVmComputeConfiguration",
            'VIRTUALIZATION.ESXIVMCONFIGURATION': "virtualization.EsxiVmConfiguration",
            'VIRTUALIZATION.ESXIVMNETWORKCONFIGURATION': "virtualization.EsxiVmNetworkConfiguration",
            'VIRTUALIZATION.ESXIVMSTORAGECONFIGURATION': "virtualization.EsxiVmStorageConfiguration",
            'VIRTUALIZATION.GUESTINFO': "virtualization.GuestInfo",
            'VIRTUALIZATION.MEMORYCAPACITY': "virtualization.MemoryCapacity",
            'VIRTUALIZATION.NETWORKINTERFACE': "virtualization.NetworkInterface",
            'VIRTUALIZATION.PRODUCTINFO': "virtualization.ProductInfo",
            'VIRTUALIZATION.STORAGECAPACITY': "virtualization.StorageCapacity",
            'VIRTUALIZATION.VIRTUALMACHINEDISK': "virtualization.VirtualMachineDisk",
            'VIRTUALIZATION.VMESXIDISK': "virtualization.VmEsxiDisk",
            'VIRTUALIZATION.VMWAREATTACHEDRESOURCETAG': "virtualization.VmwareAttachedResourceTag",
            'VIRTUALIZATION.VMWAREDISCOVERYPROTOCOL': "virtualization.VmwareDiscoveryProtocol",
            'VIRTUALIZATION.VMWAREREMOTEDISPLAYINFO': "virtualization.VmwareRemoteDisplayInfo",
            'VIRTUALIZATION.VMWARERESOURCEALLOCATIONSYSTEMTRAFFICTYPES': "virtualization.VmwareResourceAllocationSystemTrafficTypes",
            'VIRTUALIZATION.VMWARERESOURCECONSUMPTION': "virtualization.VmwareResourceConsumption",
            'VIRTUALIZATION.VMWARESHARESINFO': "virtualization.VmwareSharesInfo",
            'VIRTUALIZATION.VMWARETEAMINGANDFAILOVER': "virtualization.VmwareTeamingAndFailover",
            'VIRTUALIZATION.VMWAREVLANRANGE': "virtualization.VmwareVlanRange",
            'VIRTUALIZATION.VMWAREVMCPUSHAREINFO': "virtualization.VmwareVmCpuShareInfo",
            'VIRTUALIZATION.VMWAREVMCPUSOCKETINFO': "virtualization.VmwareVmCpuSocketInfo",
            'VIRTUALIZATION.VMWAREVMDISKCOMMITINFO': "virtualization.VmwareVmDiskCommitInfo",
            'VIRTUALIZATION.VMWAREVMMEMORYSHAREINFO': "virtualization.VmwareVmMemoryShareInfo",
            'VMEDIA.MAPPING': "vmedia.Mapping",
            'VNIC.ARFSSETTINGS': "vnic.ArfsSettings",
            'VNIC.CDN': "vnic.Cdn",
            'VNIC.COMPLETIONQUEUESETTINGS': "vnic.CompletionQueueSettings",
            'VNIC.ETHIFOLDINFO': "vnic.EthIfOldInfo",
            'VNIC.ETHINTERRUPTSETTINGS': "vnic.EthInterruptSettings",
            'VNIC.ETHRXQUEUESETTINGS': "vnic.EthRxQueueSettings",
            'VNIC.ETHTXQUEUESETTINGS': "vnic.EthTxQueueSettings",
            'VNIC.FCERRORRECOVERYSETTINGS': "vnic.FcErrorRecoverySettings",
            'VNIC.FCIFOLDINFO': "vnic.FcIfOldInfo",
            'VNIC.FCINTERRUPTSETTINGS': "vnic.FcInterruptSettings",
            'VNIC.FCQUEUESETTINGS': "vnic.FcQueueSettings",
            'VNIC.FLOGISETTINGS': "vnic.FlogiSettings",
            'VNIC.ISCSIAUTHPROFILE': "vnic.IscsiAuthProfile",
            'VNIC.LUN': "vnic.Lun",
            'VNIC.NVGRESETTINGS': "vnic.NvgreSettings",
            'VNIC.PLACEMENTSETTINGS': "vnic.PlacementSettings",
            'VNIC.PLOGISETTINGS': "vnic.PlogiSettings",
            'VNIC.PTPSETTINGS': "vnic.PtpSettings",
            'VNIC.ROCESETTINGS': "vnic.RoceSettings",
            'VNIC.RSSHASHSETTINGS': "vnic.RssHashSettings",
            'VNIC.SANSETTINGSOLDINFO': "vnic.SanSettingsOldInfo",
            'VNIC.SCSIQUEUESETTINGS': "vnic.ScsiQueueSettings",
            'VNIC.SRIOVSETTINGS': "vnic.SriovSettings",
            'VNIC.TCPOFFLOADSETTINGS': "vnic.TcpOffloadSettings",
            'VNIC.USNICSETTINGS': "vnic.UsnicSettings",
            'VNIC.VIFSTATUS': "vnic.VifStatus",
            'VNIC.VLANSETTINGS': "vnic.VlanSettings",
            'VNIC.VMQSETTINGS': "vnic.VmqSettings",
            'VNIC.VSANSETTINGS': "vnic.VsanSettings",
            'VNIC.VXLANSETTINGS': "vnic.VxlanSettings",
            'WORKFLOW.ANSIBLEPLAYSESSION': "workflow.AnsiblePlaySession",
            'WORKFLOW.ARRAYDATATYPE': "workflow.ArrayDataType",
            'WORKFLOW.ASSOCIATEDROLES': "workflow.AssociatedRoles",
            'WORKFLOW.CANCELABLETYPE': "workflow.CancelableType",
            'WORKFLOW.CLICOMMAND': "workflow.CliCommand",
            'WORKFLOW.COMMENTS': "workflow.Comments",
            'WORKFLOW.CONSTRAINTS': "workflow.Constraints",
            'WORKFLOW.CUSTOMARRAYITEM': "workflow.CustomArrayItem",
            'WORKFLOW.CUSTOMDATAPROPERTY': "workflow.CustomDataProperty",
            'WORKFLOW.CUSTOMDATATYPE': "workflow.CustomDataType",
            'WORKFLOW.CUSTOMDATATYPEPROPERTIES': "workflow.CustomDataTypeProperties",
            'WORKFLOW.DATASOURCESELECTOR': "workflow.DataSourceSelector",
            'WORKFLOW.DECISIONCASE': "workflow.DecisionCase",
            'WORKFLOW.DECISIONTASK': "workflow.DecisionTask",
            'WORKFLOW.DEFAULTVALUE': "workflow.DefaultValue",
            'WORKFLOW.DISPLAYMETA': "workflow.DisplayMeta",
            'WORKFLOW.DYNAMICTEMPLATEPARSERDATATYPE': "workflow.DynamicTemplateParserDataType",
            'WORKFLOW.ENUMENTRY': "workflow.EnumEntry",
            'WORKFLOW.ENVIRONMENTVARIABLEREFERENCE': "workflow.EnvironmentVariableReference",
            'WORKFLOW.EXPECTPROMPT': "workflow.ExpectPrompt",
            'WORKFLOW.FAILUREENDTASK': "workflow.FailureEndTask",
            'WORKFLOW.FILEDOWNLOADOP': "workflow.FileDownloadOp",
            'WORKFLOW.FILEOPERATIONS': "workflow.FileOperations",
            'WORKFLOW.FILETEMPLATEOP': "workflow.FileTemplateOp",
            'WORKFLOW.FILETRANSFER': "workflow.FileTransfer",
            'WORKFLOW.FORKTASK': "workflow.ForkTask",
            'WORKFLOW.INITIATORCONTEXT': "workflow.InitiatorContext",
            'WORKFLOW.INTERNALPROPERTIES': "workflow.InternalProperties",
            'WORKFLOW.JOINTASK': "workflow.JoinTask",
            'WORKFLOW.LOOPTASK': "workflow.LoopTask",
            'WORKFLOW.MESSAGE': "workflow.Message",
            'WORKFLOW.MIGRATESERVICEITEMACTIONPROPERTY': "workflow.MigrateServiceItemActionProperty",
            'WORKFLOW.MIGRATIONHISTORY': "workflow.MigrationHistory",
            'WORKFLOW.MOINVENTORYDATATYPE': "workflow.MoInventoryDataType",
            'WORKFLOW.MOINVENTORYPROPERTY': "workflow.MoInventoryProperty",
            'WORKFLOW.MOREFERENCEARRAYITEM': "workflow.MoReferenceArrayItem",
            'WORKFLOW.MOREFERENCEAUTOARRAYITEM': "workflow.MoReferenceAutoArrayItem",
            'WORKFLOW.MOREFERENCEAUTODATATYPE': "workflow.MoReferenceAutoDataType",
            'WORKFLOW.MOREFERENCEAUTOPROPERTY': "workflow.MoReferenceAutoProperty",
            'WORKFLOW.MOREFERENCEDATATYPE': "workflow.MoReferenceDataType",
            'WORKFLOW.MOREFERENCEFORCLONEDATATYPE': "workflow.MoReferenceForCloneDataType",
            'WORKFLOW.MOREFERENCEPROPERTY': "workflow.MoReferenceProperty",
            'WORKFLOW.OPERATIONTYPEDECOMMISSION': "workflow.OperationTypeDecommission",
            'WORKFLOW.OPERATIONTYPEDEPLOYMENT': "workflow.OperationTypeDeployment",
            'WORKFLOW.OPERATIONTYPEPOSTDEPLOYMENT': "workflow.OperationTypePostDeployment",
            'WORKFLOW.PARAMETERSET': "workflow.ParameterSet",
            'WORKFLOW.POWERSHELLAPI': "workflow.PowerShellApi",
            'WORKFLOW.PRIMITIVEARRAYITEM': "workflow.PrimitiveArrayItem",
            'WORKFLOW.PRIMITIVEDATAPROPERTY': "workflow.PrimitiveDataProperty",
            'WORKFLOW.PRIMITIVEDATATYPE': "workflow.PrimitiveDataType",
            'WORKFLOW.PROPERTIES': "workflow.Properties",
            'WORKFLOW.RESOURCEINLINESELECTOR': "workflow.ResourceInlineSelector",
            'WORKFLOW.RESOURCESELECTORCRITERIA': "workflow.ResourceSelectorCriteria",
            'WORKFLOW.RESULTHANDLER': "workflow.ResultHandler",
            'WORKFLOW.ROLLBACKTASK': "workflow.RollbackTask",
            'WORKFLOW.ROLLBACKWORKFLOWTASK': "workflow.RollbackWorkflowTask",
            'WORKFLOW.SELECTORPROPERTY': "workflow.SelectorProperty",
            'WORKFLOW.SEQUENCEPARAMS': "workflow.SequenceParams",
            'WORKFLOW.SERIALLOOPTASK': "workflow.SerialLoopTask",
            'WORKFLOW.SERVICEITEMACTIONPROPERTIES': "workflow.ServiceItemActionProperties",
            'WORKFLOW.SERVICEITEMACTIONWORKFLOWDEFINITION': "workflow.ServiceItemActionWorkflowDefinition",
            'WORKFLOW.SERVICEITEMINPUTDEFINITIONTYPE': "workflow.ServiceItemInputDefinitionType",
            'WORKFLOW.SERVICEITEMTYPE': "workflow.ServiceItemType",
            'WORKFLOW.SSHCMD': "workflow.SshCmd",
            'WORKFLOW.SSHCONFIG': "workflow.SshConfig",
            'WORKFLOW.SSHSESSION': "workflow.SshSession",
            'WORKFLOW.STARTTASK': "workflow.StartTask",
            'WORKFLOW.SUBWORKFLOWTASK': "workflow.SubWorkflowTask",
            'WORKFLOW.SUCCESSENDTASK': "workflow.SuccessEndTask",
            'WORKFLOW.TARGETCONTEXT': "workflow.TargetContext",
            'WORKFLOW.TARGETDATATYPE': "workflow.TargetDataType",
            'WORKFLOW.TARGETPROPERTY': "workflow.TargetProperty",
            'WORKFLOW.TASKCONSTRAINTS': "workflow.TaskConstraints",
            'WORKFLOW.TASKINFOUPDATE': "workflow.TaskInfoUpdate",
            'WORKFLOW.TASKLOOPINFO': "workflow.TaskLoopInfo",
            'WORKFLOW.TASKRETRYINFO': "workflow.TaskRetryInfo",
            'WORKFLOW.UIFORMCONFIG': "workflow.UiFormConfig",
            'WORKFLOW.UIINPUTFILTER': "workflow.UiInputFilter",
            'WORKFLOW.UIVIEWCONFIG': "workflow.UiViewConfig",
            'WORKFLOW.VALIDATIONERROR': "workflow.ValidationError",
            'WORKFLOW.VALIDATIONINFORMATION': "workflow.ValidationInformation",
            'WORKFLOW.WAITTASK': "workflow.WaitTask",
            'WORKFLOW.WAITTASKPROMPT': "workflow.WaitTaskPrompt",
            'WORKFLOW.WEBAPI': "workflow.WebApi",
            'WORKFLOW.WORKERTASK': "workflow.WorkerTask",
            'WORKFLOW.WORKFLOWCTX': "workflow.WorkflowCtx",
            'WORKFLOW.WORKFLOWENGINEPROPERTIES': "workflow.WorkflowEngineProperties",
            'WORKFLOW.WORKFLOWINFOAUTORESTARTPROPERTIES': "workflow.WorkflowInfoAutoRestartProperties",
            'WORKFLOW.WORKFLOWINFOPROPERTIES': "workflow.WorkflowInfoProperties",
            'WORKFLOW.WORKFLOWPROPERTIES': "workflow.WorkflowProperties",
            'WORKFLOW.XMLAPI': "workflow.XmlApi",
            'WORKLOAD.ASSIGNEDRESOURCE': "workload.AssignedResource",
            'WORKLOAD.BATCHDEPLOYMENT': "workload.BatchDeployment",
            'WORKLOAD.BLUEPRINTINPUTREFERENCE': "workload.BlueprintInputReference",
            'WORKLOAD.BLUEPRINTREFERENCE': "workload.BlueprintReference",
            'WORKLOAD.CANARYDEPLOYMENT': "workload.CanaryDeployment",
            'WORKLOAD.CLONESTATUS': "workload.CloneStatus",
            'WORKLOAD.CLONESTATUSENTRY': "workload.CloneStatusEntry",
            'WORKLOAD.DEFINITIONMAPPER': "workload.DefinitionMapper",
            'WORKLOAD.DEPLOYMENTBLUEPRINTINPUTTYPE': "workload.DeploymentBlueprintInputType",
            'WORKLOAD.DEPLOYMENTCHANGEDETAIL': "workload.DeploymentChangeDetail",
            'WORKLOAD.GENERATEDOBJECT': "workload.GeneratedObject",
            'WORKLOAD.RESOURCECONSTRAINT': "workload.ResourceConstraint",
            'WORKLOAD.STATEAGGREGATION': "workload.StateAggregation",
            'X509.CERTIFICATE': "x509.Certificate",
        },
        ('object_type',): {
            'AAA.USERAGENT': "aaa.UserAgent",
            'ACCESS.ADDRESSTYPE': "access.AddressType",
            'ACCESS.CONFIGURATIONTYPE': "access.ConfigurationType",
            'ADAPTER.ADAPTERCONFIG': "adapter.AdapterConfig",
            'ADAPTER.DCEINTERFACESETTINGS': "adapter.DceInterfaceSettings",
            'ADAPTER.ETHSETTINGS': "adapter.EthSettings",
            'ADAPTER.FCSETTINGS': "adapter.FcSettings",
            'ADAPTER.PHYSICALNICMODESETTINGS': "adapter.PhysicalNicModeSettings",
            'ADAPTER.PORTCHANNELSETTINGS': "adapter.PortChannelSettings",
            'APIC.FABRICLEAFNODEDETAILS': "apic.FabricLeafNodeDetails",
            'APPLIANCE.APISTATUS': "appliance.ApiStatus",
            'APPLIANCE.CERTRENEWALPHASE': "appliance.CertRenewalPhase",
            'APPLIANCE.CLUSTERINSTALLPHASE': "appliance.ClusterInstallPhase",
            'APPLIANCE.KEYVALUEPAIR': "appliance.KeyValuePair",
            'APPLIANCE.METADATAMANIFESTVERSION': "appliance.MetadataManifestVersion",
            'APPLIANCE.NETWORKSTATUS': "appliance.NetworkStatus",
            'APPLIANCE.NODEIPINFO': "appliance.NodeIpInfo",
            'APPLIANCE.STATUSCHECK': "appliance.StatusCheck",
            'ASSET.ADDRESSINFORMATION': "asset.AddressInformation",
            'ASSET.ALARMSUMMARY': "asset.AlarmSummary",
            'ASSET.APIKEYCREDENTIAL': "asset.ApiKeyCredential",
            'ASSET.CLIENTCERTIFICATECREDENTIAL': "asset.ClientCertificateCredential",
            'ASSET.CLOUDCONNECTION': "asset.CloudConnection",
            'ASSET.CONNECTIONFLAPSTATUS': "asset.ConnectionFlapStatus",
            'ASSET.CONTRACTINFORMATION': "asset.ContractInformation",
            'ASSET.CUSTOMERINFORMATION': "asset.CustomerInformation",
            'ASSET.DEPLOYMENTALARMINFO': "asset.DeploymentAlarmInfo",
            'ASSET.DEPLOYMENTDEVICEALARMINFO': "asset.DeploymentDeviceAlarmInfo",
            'ASSET.DEPLOYMENTDEVICEINFORMATION': "asset.DeploymentDeviceInformation",
            'ASSET.DEVICEENDPOINTLOCALCREDENTIAL': "asset.DeviceEndpointLocalCredential",
            'ASSET.DEVICEINFORMATION': "asset.DeviceInformation",
            'ASSET.DEVICESTATISTICS': "asset.DeviceStatistics",
            'ASSET.DEVICETRANSACTION': "asset.DeviceTransaction",
            'ASSET.GENERICTARGETCLAIMOPTIONS': "asset.GenericTargetClaimOptions",
            'ASSET.GLOBALULTIMATE': "asset.GlobalUltimate",
            'ASSET.GOOGLECLOUDPLATFORMSERVICEACCOUNTKEYCREDENTIAL': "asset.GoogleCloudPlatformServiceAccountKeyCredential",
            'ASSET.HTTPCONNECTION': "asset.HttpConnection",
            'ASSET.INTERSIGHTDEVICECONNECTORCONNECTION': "asset.IntersightDeviceConnectorConnection",
            'ASSET.MERAKICLOUDOPTIONS': "asset.MerakiCloudOptions",
            'ASSET.METERINGTYPE': "asset.MeteringType",
            'ASSET.NEWRELICCREDENTIAL': "asset.NewRelicCredential",
            'ASSET.NOAUTHENTICATIONCREDENTIAL': "asset.NoAuthenticationCredential",
            'ASSET.OAUTHBEARERTOKENCREDENTIAL': "asset.OauthBearerTokenCredential",
            'ASSET.OAUTHCLIENTIDSECRETCREDENTIAL': "asset.OauthClientIdSecretCredential",
            'ASSET.ORCHESTRATIONCIVPVMWAREVCENTEROPTIONS': "asset.OrchestrationCivpVmwareVcenterOptions",
            'ASSET.ORCHESTRATIONHITACHIVIRTUALSTORAGEPLATFORMOPTIONS': "asset.OrchestrationHitachiVirtualStoragePlatformOptions",
            'ASSET.ORCHESTRATIONHSMVMWAREVCENTEROPTIONS': "asset.OrchestrationHsmVmwareVcenterOptions",
            'ASSET.ORCHESTRATIONSERVICE': "asset.OrchestrationService",
            'ASSET.PARENTCONNECTIONSIGNATURE': "asset.ParentConnectionSignature",
            'ASSET.PRIVATEKEYCREDENTIAL': "asset.PrivateKeyCredential",
            'ASSET.PRODUCTINFORMATION': "asset.ProductInformation",
            'ASSET.SCOPEDTARGETCONNECTION': "asset.ScopedTargetConnection",
            'ASSET.SERVICENOWCREDENTIAL': "asset.ServiceNowCredential",
            'ASSET.SSHCONNECTION': "asset.SshConnection",
            'ASSET.SUDIINFO': "asset.SudiInfo",
            'ASSET.TARGETKEY': "asset.TargetKey",
            'ASSET.TARGETSIGNATURE': "asset.TargetSignature",
            'ASSET.TARGETSTATUSDETAILS': "asset.TargetStatusDetails",
            'ASSET.TERRAFORMINTEGRATIONSERVICE': "asset.TerraformIntegrationService",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMAGENTOPTIONS': "asset.TerraformIntegrationTerraformAgentOptions",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMCLOUDOPTIONS': "asset.TerraformIntegrationTerraformCloudOptions",
            'ASSET.USERNAMEPASSWORDCREDENTIAL': "asset.UsernamePasswordCredential",
            'ASSET.VIRTUALIZATIONAMAZONWEBSERVICEOPTIONS': "asset.VirtualizationAmazonWebServiceOptions",
            'ASSET.VIRTUALIZATIONSERVICE': "asset.VirtualizationService",
            'ASSET.VMHOST': "asset.VmHost",
            'ASSET.WORKLOADOPTIMIZERAMAZONWEBSERVICESBILLINGOPTIONS': "asset.WorkloadOptimizerAmazonWebServicesBillingOptions",
            'ASSET.WORKLOADOPTIMIZERDYNATRACEOPTIONS': "asset.WorkloadOptimizerDynatraceOptions",
            'ASSET.WORKLOADOPTIMIZERGOOGLECLOUDPLATFORMBILLINGOPTIONS': "asset.WorkloadOptimizerGoogleCloudPlatformBillingOptions",
            'ASSET.WORKLOADOPTIMIZERHYPERVOPTIONS': "asset.WorkloadOptimizerHypervOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREAPPLICATIONINSIGHTSOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureApplicationInsightsOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREBILLINGOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureBillingOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREENTERPRISEAGREEMENTOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureEnterpriseAgreementOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZURESERVICEPRINCIPALOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureServicePrincipalOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTSQLSERVEROPTIONS': "asset.WorkloadOptimizerMicrosoftSqlServerOptions",
            'ASSET.WORKLOADOPTIMIZERNEWRELICOPTIONS': "asset.WorkloadOptimizerNewRelicOptions",
            'ASSET.WORKLOADOPTIMIZEROPENSTACKOPTIONS': "asset.WorkloadOptimizerOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERORACLEDATABASESERVEROPTIONS': "asset.WorkloadOptimizerOracleDatabaseServerOptions",
            'ASSET.WORKLOADOPTIMIZERREDHATOPENSTACKOPTIONS': "asset.WorkloadOptimizerRedHatOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERSERVICE': "asset.WorkloadOptimizerService",
            'ASSET.WORKLOADOPTIMIZERVMWAREVCENTEROPTIONS': "asset.WorkloadOptimizerVmwareVcenterOptions",
            'BLUEPRINT.BLUEPRINTDEFINITIONDEPENDENCY': "blueprint.BlueprintDefinitionDependency",
            'BLUEPRINT.GENERATEDOBJECTMETADATA': "blueprint.GeneratedObjectMetadata",
            'BLUEPRINT.GENERATEDOBJECTNEW': "blueprint.GeneratedObjectNew",
            'BLUEPRINT.GENERATEDOBJECTOPERATIONTARGET': "blueprint.GeneratedObjectOperationTarget",
            'BLUEPRINT.GENERATEDOBJECTSOURCECLONE': "blueprint.GeneratedObjectSourceClone",
            'BLUEPRINT.GENERATEDOBJECTSOURCELOOKUP': "blueprint.GeneratedObjectSourceLookup",
            'BLUEPRINT.GENERATEDOBJECTSOURCEMERGE': "blueprint.GeneratedObjectSourceMerge",
            'BLUEPRINT.GENERATEDOBJECTSOURCEREFERENCE': "blueprint.GeneratedObjectSourceReference",
            'BLUEPRINT.GENERATEDOBJECTSOURCESELECTOR': "blueprint.GeneratedObjectSourceSelector",
            'BLUEPRINT.INPUTOPERATIONTYPE': "blueprint.InputOperationType",
            'BLUEPRINT.PREGENERATEOPERATION': "blueprint.PreGenerateOperation",
            'BLUEPRINT.PROPERTYITERATION': "blueprint.PropertyIteration",
            'BLUEPRINT.RESOURCECONSTRAINTS': "blueprint.ResourceConstraints",
            'BLUEPRINT.SERVICEITEMDEFINITION': "blueprint.ServiceItemDefinition",
            'BOOT.BOOTLOADER': "boot.Bootloader",
            'BOOT.FLEXMMC': "boot.FlexMmc",
            'BOOT.HTTP': "boot.Http",
            'BOOT.ISCSI': "boot.Iscsi",
            'BOOT.LOCALCDD': "boot.LocalCdd",
            'BOOT.LOCALDISK': "boot.LocalDisk",
            'BOOT.NVME': "boot.Nvme",
            'BOOT.PCHSTORAGE': "boot.PchStorage",
            'BOOT.PXE': "boot.Pxe",
            'BOOT.SAN': "boot.San",
            'BOOT.SDCARD': "boot.SdCard",
            'BOOT.STATICIPV4SETTINGS': "boot.StaticIpV4Settings",
            'BOOT.STATICIPV6SETTINGS': "boot.StaticIpV6Settings",
            'BOOT.UEFISHELL': "boot.UefiShell",
            'BOOT.USB': "boot.Usb",
            'BOOT.VIRTUALMEDIA': "boot.VirtualMedia",
            'BULK.HTTPHEADER': "bulk.HttpHeader",
            'BULK.MULTIRELATIONENTRYPATCH': "bulk.MultiRelationEntryPatch",
            'BULK.PATCHCONTENT': "bulk.PatchContent",
            'BULK.RESTRESULT': "bulk.RestResult",
            'BULK.RESTSUBREQUEST': "bulk.RestSubRequest",
            'BULK.SECRESOURCEROLES': "bulk.SecResourceRoles",
            'CAPABILITY.CERTIFICATEPROPERTYCONSTRAINTS': "capability.CertificatePropertyConstraints",
            'CAPABILITY.FEATURECONFIG': "capability.FeatureConfig",
            'CAPABILITY.HSUISOMODELSPECIFICCONSTRAINT': "capability.HsuIsoModelSpecificConstraint",
            'CAPABILITY.LDAPBASEPROPERTYCONSTRAINTS': "capability.LdapBasePropertyConstraints",
            'CAPABILITY.PCIDRANGE': "capability.PcIdRange",
            'CAPABILITY.PORTRANGE': "capability.PortRange",
            'CAPABILITY.SERVERCOMPONENTCONSTRAINT': "capability.ServerComponentConstraint",
            'CAPABILITY.SWITCHNETWORKLIMITS': "capability.SwitchNetworkLimits",
            'CAPABILITY.SWITCHSTORAGELIMITS': "capability.SwitchStorageLimits",
            'CAPABILITY.SWITCHSYSTEMLIMITS': "capability.SwitchSystemLimits",
            'CAPABILITY.SWITCHINGMODECAPABILITY': "capability.SwitchingModeCapability",
            'CAPABILITY.UNSUPPORTEDFEATURECONFIG': "capability.UnsupportedFeatureConfig",
            'CAPABILITY.UPDATEORDERLISTTYPE': "capability.UpdateOrderListType",
            'CERTIFICATEMANAGEMENT.IMC': "certificatemanagement.Imc",
            'CERTIFICATEMANAGEMENT.ROOTCACERTIFICATE': "certificatemanagement.RootCaCertificate",
            'CLOUD.TFCWORKSPACEVARIABLES': "cloud.TfcWorkspaceVariables",
            'CMRF.CMRF': "cmrf.CmRf",
            'COMM.GEOLOCATIONDETAILS': "comm.GeoLocationDetails",
            'COMM.GEOPOINT': "comm.GeoPoint",
            'COMM.IPV4ADDRESSBLOCK': "comm.IpV4AddressBlock",
            'COMM.IPV4INTERFACE': "comm.IpV4Interface",
            'COMM.IPV6INTERFACE': "comm.IpV6Interface",
            'COMM.PHYSICALADDRESS': "comm.PhysicalAddress",
            'COMM.TAGUSAGE': "comm.TagUsage",
            'COMPUTE.ALARMSUMMARY': "compute.AlarmSummary",
            'COMPUTE.IPADDRESS': "compute.IpAddress",
            'COMPUTE.PENDINGWORKFLOWTRIGGER': "compute.PendingWorkflowTrigger",
            'COMPUTE.PERSISTENTMEMORYMODULE': "compute.PersistentMemoryModule",
            'COMPUTE.PERSISTENTMEMORYOPERATION': "compute.PersistentMemoryOperation",
            'COMPUTE.PERSONALITYSETTING': "compute.PersonalitySetting",
            'COMPUTE.SCRUBOPCONFIGUTATION': "compute.ScrubOpConfigutation",
            'COMPUTE.SERVERCONFIG': "compute.ServerConfig",
            'COMPUTE.SERVEROPSTATUS': "compute.ServerOpStatus",
            'COMPUTE.STORAGECONTROLLEROPERATION': "compute.StorageControllerOperation",
            'COMPUTE.STORAGEPHYSICALDRIVE': "compute.StoragePhysicalDrive",
            'COMPUTE.STORAGEPHYSICALDRIVEOPERATION': "compute.StoragePhysicalDriveOperation",
            'COMPUTE.STORAGEUTILITYIMAGEOPERATION': "compute.StorageUtilityImageOperation",
            'COMPUTE.STORAGEVIRTUALDRIVE': "compute.StorageVirtualDrive",
            'COMPUTE.STORAGEVIRTUALDRIVEOPERATION': "compute.StorageVirtualDriveOperation",
            'COND.ALARMACTION': "cond.AlarmAction",
            'COND.ALARMCLASSIFICATIONELIGIBILITY': "cond.AlarmClassificationEligibility",
            'COND.ALARMSPEC': "cond.AlarmSpec",
            'COND.ALARMSUMMARY': "cond.AlarmSummary",
            'CONNECTOR.CLOSESTREAMMESSAGE': "connector.CloseStreamMessage",
            'CONNECTOR.COMMANDCONTROLMESSAGE': "connector.CommandControlMessage",
            'CONNECTOR.COMMANDTERMINALSTREAM': "connector.CommandTerminalStream",
            'CONNECTOR.EVENTLOG': "connector.EventLog",
            'CONNECTOR.EXPECTPROMPT': "connector.ExpectPrompt",
            'CONNECTOR.FETCHSTREAMMESSAGE': "connector.FetchStreamMessage",
            'CONNECTOR.FILECHECKSUM': "connector.FileChecksum",
            'CONNECTOR.FILEMESSAGE': "connector.FileMessage",
            'CONNECTOR.HTTPREQUEST': "connector.HttpRequest",
            'CONNECTOR.SSHCONFIG': "connector.SshConfig",
            'CONNECTOR.SSHMESSAGE': "connector.SshMessage",
            'CONNECTOR.STARTSTREAM': "connector.StartStream",
            'CONNECTOR.STARTSTREAMFROMDEVICE': "connector.StartStreamFromDevice",
            'CONNECTOR.STREAMACKNOWLEDGE': "connector.StreamAcknowledge",
            'CONNECTOR.STREAMINPUT': "connector.StreamInput",
            'CONNECTOR.STREAMKEEPALIVE': "connector.StreamKeepalive",
            'CONNECTOR.TARGETCHANGEMESSAGE': "connector.TargetChangeMessage",
            'CONNECTOR.TARGETSPECIFICATION': "connector.TargetSpecification",
            'CONNECTOR.URL': "connector.Url",
            'CONNECTOR.WINRMREQUEST': "connector.WinrmRequest",
            'CONNECTOR.XMLAPIMESSAGE': "connector.XmlApiMessage",
            'CONNECTORPACK.CONNECTORPACKUPDATE': "connectorpack.ConnectorPackUpdate",
            'CONTENT.COMPLEXTYPE': "content.ComplexType",
            'CONTENT.PARAMETER': "content.Parameter",
            'CONTENT.TEXTPARAMETER': "content.TextParameter",
            'CONVERGEDINFRA.ALARMSUMMARY': "convergedinfra.AlarmSummary",
            'CONVERGEDINFRA.COMPLIANCESUMMARY': "convergedinfra.ComplianceSummary",
            'CONVERGEDINFRA.PODSUMMARY': "convergedinfra.PodSummary",
            'CRD.CUSTOMRESOURCECONFIGPROPERTY': "crd.CustomResourceConfigProperty",
            'EQUIPMENT.CHASSISOPERATIONSTATUS': "equipment.ChassisOperationStatus",
            'EQUIPMENT.DEVICELOCATION': "equipment.DeviceLocation",
            'EQUIPMENT.IOCARDIDENTITY': "equipment.IoCardIdentity",
            'EQUIPMENT.IOCARDOPERATIONSTATUS': "equipment.IoCardOperationStatus",
            'EQUIPMENT.RESETACTION': "equipment.ResetAction",
            'ETHER.MACSECOPERDATA': "ether.MacsecOperData",
            'FABRIC.CLUSTERASSIGNMENT': "fabric.ClusterAssignment",
            'FABRIC.FCZONEMEMBER': "fabric.FcZoneMember",
            'FABRIC.LLDPSETTINGS': "fabric.LldpSettings",
            'FABRIC.MACAGINGSETTINGS': "fabric.MacAgingSettings",
            'FABRIC.MACSECEAPOL': "fabric.MacSecEaPol",
            'FABRIC.PORTIDENTIFIER': "fabric.PortIdentifier",
            'FABRIC.QOSCLASS': "fabric.QosClass",
            'FABRIC.SECKEY': "fabric.SecKey",
            'FABRIC.SECKEYCHAIN': "fabric.SecKeyChain",
            'FABRIC.UDLDGLOBALSETTINGS': "fabric.UdldGlobalSettings",
            'FABRIC.UDLDSETTINGS': "fabric.UdldSettings",
            'FABRIC.VLANSETTINGS': "fabric.VlanSettings",
            'FCPOOL.BLOCK': "fcpool.Block",
            'FCPOOL.RESERVATIONREFERENCE': "fcpool.ReservationReference",
            'FEEDBACK.FEEDBACKDATA': "feedback.FeedbackData",
            'FIRMWARE.CHASSISUPGRADEIMPACT': "firmware.ChassisUpgradeImpact",
            'FIRMWARE.CIFSSERVER': "firmware.CifsServer",
            'FIRMWARE.COMPONENTIMPACT': "firmware.ComponentImpact",
            'FIRMWARE.COMPONENTMETA': "firmware.ComponentMeta",
            'FIRMWARE.DIRECTDOWNLOAD': "firmware.DirectDownload",
            'FIRMWARE.EXCLUDECOMPONENTPIDLISTTYPE': "firmware.ExcludeComponentPidListType",
            'FIRMWARE.FABRICUPGRADEIMPACT': "firmware.FabricUpgradeImpact",
            'FIRMWARE.FEATUREVERSIONMAP': "firmware.FeatureVersionMap",
            'FIRMWARE.FIRMWAREINVENTORY': "firmware.FirmwareInventory",
            'FIRMWARE.HTTPSERVER': "firmware.HttpServer",
            'FIRMWARE.MODELBUNDLEVERSION': "firmware.ModelBundleVersion",
            'FIRMWARE.NETWORKSHARE': "firmware.NetworkShare",
            'FIRMWARE.NFSSERVER': "firmware.NfsServer",
            'FIRMWARE.SERVERUPGRADEIMPACT': "firmware.ServerUpgradeImpact",
            'FIRMWARE.VERSIONMAP': "firmware.VersionMap",
            'FORECAST.MODEL': "forecast.Model",
            'HCI.AHVGUESTTOOLS': "hci.AhvGuestTools",
            'HCI.ALARMPARAMETER': "hci.AlarmParameter",
            'HCI.ALARMSUMMARY': "hci.AlarmSummary",
            'HCI.APILIMIT': "hci.ApiLimit",
            'HCI.BACKPLANENETWORKPARAMS': "hci.BackplaneNetworkParams",
            'HCI.CAPACITYVIOLATION': "hci.CapacityViolation",
            'HCI.CONSUMPTION': "hci.Consumption",
            'HCI.ENTITLEMENTDETAIL': "hci.EntitlementDetail",
            'HCI.ESXIGUESTTOOLS': "hci.EsxiGuestTools",
            'HCI.EXPIREDLICENSE': "hci.ExpiredLicense",
            'HCI.FAULTTOLERANCESTATE': "hci.FaultToleranceState",
            'HCI.FEATUREVIOLATION': "hci.FeatureViolation",
            'HCI.IPADDRESS': "hci.IpAddress",
            'HCI.IPADDRESSORFQDN': "hci.IpAddressOrFqdn",
            'HCI.KEYMANAGEMENTDEVICETOCERTSTATUSINFO': "hci.KeyManagementDeviceToCertStatusInfo",
            'HCI.LICENSEDSERVICE': "hci.LicensedService",
            'HCI.MANAGEMENTSERVER': "hci.ManagementServer",
            'HCI.PULSESTATUS': "hci.PulseStatus",
            'HCI.SBDF': "hci.Sbdf",
            'HCI.SERVICEVIOLATION': "hci.ServiceViolation",
            'HCI.SOFTWARETYPE': "hci.SoftwareType",
            'HCI.VIRTUALGPUCONFIG': "hci.VirtualGpuConfig",
            'HCL.CONSTRAINT': "hcl.Constraint",
            'HCL.FIRMWARE': "hcl.Firmware",
            'HCL.HARDWARECOMPATIBILITYPROFILE': "hcl.HardwareCompatibilityProfile",
            'HCL.PRODUCT': "hcl.Product",
            'HYPERFLEX.ALARMSUMMARY': "hyperflex.AlarmSummary",
            'HYPERFLEX.APPSETTINGCONSTRAINT': "hyperflex.AppSettingConstraint",
            'HYPERFLEX.BACKUPPOLICYSETTINGS': "hyperflex.BackupPolicySettings",
            'HYPERFLEX.CAPABILITY': "hyperflex.Capability",
            'HYPERFLEX.DATASTOREINFO': "hyperflex.DatastoreInfo",
            'HYPERFLEX.ENTITYREFERENCE': "hyperflex.EntityReference",
            'HYPERFLEX.ERRORSTACK': "hyperflex.ErrorStack",
            'HYPERFLEX.FEATURELIMITENTRY': "hyperflex.FeatureLimitEntry",
            'HYPERFLEX.FILEPATH': "hyperflex.FilePath",
            'HYPERFLEX.HEALTHCHECKNODELEVELINFO': "hyperflex.HealthCheckNodeLevelInfo",
            'HYPERFLEX.HEALTHCHECKSCRIPTINFO': "hyperflex.HealthCheckScriptInfo",
            'HYPERFLEX.HXHOSTMOUNTSTATUSDT': "hyperflex.HxHostMountStatusDt",
            'HYPERFLEX.HXLICENSEAUTHORIZATIONDETAILSDT': "hyperflex.HxLicenseAuthorizationDetailsDt",
            'HYPERFLEX.HXLINKDT': "hyperflex.HxLinkDt",
            'HYPERFLEX.HXNETWORKADDRESSDT': "hyperflex.HxNetworkAddressDt",
            'HYPERFLEX.HXPLATFORMDATASTORECONFIGDT': "hyperflex.HxPlatformDatastoreConfigDt",
            'HYPERFLEX.HXREGISTRATIONDETAILSDT': "hyperflex.HxRegistrationDetailsDt",
            'HYPERFLEX.HXRESILIENCYINFODT': "hyperflex.HxResiliencyInfoDt",
            'HYPERFLEX.HXSITEDT': "hyperflex.HxSiteDt",
            'HYPERFLEX.HXUUIDDT': "hyperflex.HxUuIdDt",
            'HYPERFLEX.HXZONEINFODT': "hyperflex.HxZoneInfoDt",
            'HYPERFLEX.HXZONERESILIENCYINFODT': "hyperflex.HxZoneResiliencyInfoDt",
            'HYPERFLEX.IPADDRRANGE': "hyperflex.IpAddrRange",
            'HYPERFLEX.LOGICALAVAILABILITYZONE': "hyperflex.LogicalAvailabilityZone",
            'HYPERFLEX.MACADDRPREFIXRANGE': "hyperflex.MacAddrPrefixRange",
            'HYPERFLEX.MAPCLUSTERIDTOPROTECTIONINFO': "hyperflex.MapClusterIdToProtectionInfo",
            'HYPERFLEX.MAPCLUSTERIDTOSTSNAPSHOTPOINT': "hyperflex.MapClusterIdToStSnapshotPoint",
            'HYPERFLEX.MAPUUIDTOTRACKEDDISK': "hyperflex.MapUuidToTrackedDisk",
            'HYPERFLEX.NAMEDVLAN': "hyperflex.NamedVlan",
            'HYPERFLEX.NAMEDVSAN': "hyperflex.NamedVsan",
            'HYPERFLEX.NETWORKCONFIGURATION': "hyperflex.NetworkConfiguration",
            'HYPERFLEX.PORTTYPETOPORTNUMBERMAP': "hyperflex.PortTypeToPortNumberMap",
            'HYPERFLEX.PROTECTIONINFO': "hyperflex.ProtectionInfo",
            'HYPERFLEX.RESYNCCLUSTERMOIDS': "hyperflex.ReSyncClusterMoIds",
            'HYPERFLEX.REPLICATIONCLUSTERREFERENCETOSCHEDULE': "hyperflex.ReplicationClusterReferenceToSchedule",
            'HYPERFLEX.REPLICATIONPEERINFO': "hyperflex.ReplicationPeerInfo",
            'HYPERFLEX.REPLICATIONPLATDATASTORE': "hyperflex.ReplicationPlatDatastore",
            'HYPERFLEX.REPLICATIONPLATDATASTOREPAIR': "hyperflex.ReplicationPlatDatastorePair",
            'HYPERFLEX.REPLICATIONSCHEDULE': "hyperflex.ReplicationSchedule",
            'HYPERFLEX.REPLICATIONSTATUS': "hyperflex.ReplicationStatus",
            'HYPERFLEX.RPOSTATUS': "hyperflex.RpoStatus",
            'HYPERFLEX.SERVERFIRMWAREVERSIONINFO': "hyperflex.ServerFirmwareVersionInfo",
            'HYPERFLEX.SERVERMODELENTRY': "hyperflex.ServerModelEntry",
            'HYPERFLEX.SITEDETAILS': "hyperflex.SiteDetails",
            'HYPERFLEX.SNAPSHOTFILES': "hyperflex.SnapshotFiles",
            'HYPERFLEX.SNAPSHOTINFOBRIEF': "hyperflex.SnapshotInfoBrief",
            'HYPERFLEX.SNAPSHOTPOINT': "hyperflex.SnapshotPoint",
            'HYPERFLEX.SNAPSHOTSTATUS': "hyperflex.SnapshotStatus",
            'HYPERFLEX.STPLATFORMCLUSTERHEALINGINFO': "hyperflex.StPlatformClusterHealingInfo",
            'HYPERFLEX.STPLATFORMCLUSTERRESILIENCYINFO': "hyperflex.StPlatformClusterResiliencyInfo",
            'HYPERFLEX.SUMMARY': "hyperflex.Summary",
            'HYPERFLEX.TRACKEDDISK': "hyperflex.TrackedDisk",
            'HYPERFLEX.TRACKEDFILE': "hyperflex.TrackedFile",
            'HYPERFLEX.VCENTERCONFIGURATION': "hyperflex.VcenterConfiguration",
            'HYPERFLEX.VIRTUALMACHINE': "hyperflex.VirtualMachine",
            'HYPERFLEX.VIRTUALMACHINERUNTIMEINFO': "hyperflex.VirtualMachineRuntimeInfo",
            'HYPERFLEX.VMPROTECTIONSPACEUSAGE': "hyperflex.VmProtectionSpaceUsage",
            'HYPERFLEX.WWXNPREFIXRANGE': "hyperflex.WwxnPrefixRange",
            'I18N.MESSAGE': "i18n.Message",
            'I18N.MESSAGEPARAM': "i18n.MessageParam",
            'IAAS.LICENSEKEYSINFO': "iaas.LicenseKeysInfo",
            'IAAS.LICENSEUTILIZATIONINFO': "iaas.LicenseUtilizationInfo",
            'IAAS.WORKFLOWSTEPS': "iaas.WorkflowSteps",
            'IAM.ACCOUNTPERMISSIONS': "iam.AccountPermissions",
            'IAM.ACCOUNTTAGS': "iam.AccountTags",
            'IAM.BASICAUTHCREDENTIALS': "iam.BasicAuthCredentials",
            'IAM.CLIENTMETA': "iam.ClientMeta",
            'IAM.ENDPOINTPASSWORDPROPERTIES': "iam.EndPointPasswordProperties",
            'IAM.FAILUREDETAILS': "iam.FailureDetails",
            'IAM.FEATUREDEFINITION': "iam.FeatureDefinition",
            'IAM.GROUPPERMISSIONTOROLES': "iam.GroupPermissionToRoles",
            'IAM.LDAPBASEPROPERTIES': "iam.LdapBaseProperties",
            'IAM.LDAPDNSPARAMETERS': "iam.LdapDnsParameters",
            'IAM.PERMISSIONREFERENCE': "iam.PermissionReference",
            'IAM.PERMISSIONTOROLES': "iam.PermissionToRoles",
            'IAM.RESOURCEROLE': "iam.ResourceRole",
            'IAM.RULE': "iam.Rule",
            'IAM.SAMLSPCONNECTION': "iam.SamlSpConnection",
            'IAM.SECURITYCONTEXT': "iam.SecurityContext",
            'IAM.SSOSESSIONATTRIBUTES': "iam.SsoSessionAttributes",
            'IAM.SWITCHACCOUNTPERMISSION': "iam.SwitchAccountPermission",
            'IAM.SWITCHSCOPEPERMISSIONS': "iam.SwitchScopePermissions",
            'IAM.USERDETAILS': "iam.UserDetails",
            'IMCCONNECTOR.WEBUIMESSAGE': "imcconnector.WebUiMessage",
            'INFRA.GPUCONFIGURATION': "infra.GpuConfiguration",
            'INFRA.HARDWAREINFO': "infra.HardwareInfo",
            'INFRA.METADATA': "infra.MetaData",
            'INFRA.MIGGPUCONFIGURATION': "infra.MigGpuConfiguration",
            'INVENTORY.INVENTORYMO': "inventory.InventoryMo",
            'INVENTORY.JOBINFO': "inventory.JobInfo",
            'INVENTORY.UEMINFO': "inventory.UemInfo",
            'IPPOOL.IPV4BLOCK': "ippool.IpV4Block",
            'IPPOOL.IPV4CONFIG': "ippool.IpV4Config",
            'IPPOOL.IPV6BLOCK': "ippool.IpV6Block",
            'IPPOOL.IPV6CONFIG': "ippool.IpV6Config",
            'IPPOOL.RESERVATIONREFERENCE': "ippool.ReservationReference",
            'IQNPOOL.IQNSUFFIXBLOCK': "iqnpool.IqnSuffixBlock",
            'IQNPOOL.RESERVATIONREFERENCE': "iqnpool.ReservationReference",
            'ISSUE.DEVICETAG': "issue.DeviceTag",
            'ISSUE.MESSAGE': "issue.Message",
            'ISSUE.ODATACONDITION': "issue.OdataCondition",
            'KUBERNETES.ACTIONINFO': "kubernetes.ActionInfo",
            'KUBERNETES.ADDON': "kubernetes.Addon",
            'KUBERNETES.ADDONCONFIGURATION': "kubernetes.AddonConfiguration",
            'KUBERNETES.ADDONVERSIONREFERENCE': "kubernetes.AddonVersionReference",
            'KUBERNETES.BAREMETALNETWORKINFO': "kubernetes.BaremetalNetworkInfo",
            'KUBERNETES.CALICOCONFIG': "kubernetes.CalicoConfig",
            'KUBERNETES.CLUSTERCERTIFICATECONFIGURATION': "kubernetes.ClusterCertificateConfiguration",
            'KUBERNETES.CLUSTERMANAGEMENTCONFIG': "kubernetes.ClusterManagementConfig",
            'KUBERNETES.CONFIGURATION': "kubernetes.Configuration",
            'KUBERNETES.DAEMONSETSTATUS': "kubernetes.DaemonSetStatus",
            'KUBERNETES.DEPLOYMENTSTATUS': "kubernetes.DeploymentStatus",
            'KUBERNETES.ESSENTIALADDON': "kubernetes.EssentialAddon",
            'KUBERNETES.ESXIVIRTUALMACHINEINFRACONFIG': "kubernetes.EsxiVirtualMachineInfraConfig",
            'KUBERNETES.ETHERNET': "kubernetes.Ethernet",
            'KUBERNETES.ETHERNETMATCHER': "kubernetes.EthernetMatcher",
            'KUBERNETES.INGRESSSTATUS': "kubernetes.IngressStatus",
            'KUBERNETES.INSTANCETYPEDETAILS': "kubernetes.InstanceTypeDetails",
            'KUBERNETES.IPV4CONFIG': "kubernetes.IpV4Config",
            'KUBERNETES.KEYVALUE': "kubernetes.KeyValue",
            'KUBERNETES.LOADBALANCER': "kubernetes.LoadBalancer",
            'KUBERNETES.NETWORKINTERFACESPEC': "kubernetes.NetworkInterfaceSpec",
            'KUBERNETES.NODEADDRESS': "kubernetes.NodeAddress",
            'KUBERNETES.NODEGROUPLABEL': "kubernetes.NodeGroupLabel",
            'KUBERNETES.NODEGROUPTAINT': "kubernetes.NodeGroupTaint",
            'KUBERNETES.NODEINFO': "kubernetes.NodeInfo",
            'KUBERNETES.NODESPEC': "kubernetes.NodeSpec",
            'KUBERNETES.NODESTATUS': "kubernetes.NodeStatus",
            'KUBERNETES.OBJECTMETA': "kubernetes.ObjectMeta",
            'KUBERNETES.OVSBOND': "kubernetes.OvsBond",
            'KUBERNETES.PODSTATUS': "kubernetes.PodStatus",
            'KUBERNETES.PROXYCONFIG': "kubernetes.ProxyConfig",
            'KUBERNETES.ROUTE': "kubernetes.Route",
            'KUBERNETES.SERVICESTATUS': "kubernetes.ServiceStatus",
            'KUBERNETES.STATEFULSETSTATUS': "kubernetes.StatefulSetStatus",
            'KUBERNETES.TAINT': "kubernetes.Taint",
            'LICENSE.SUBSTITUTELICENSE': "license.SubstituteLicense",
            'MACPOOL.BLOCK': "macpool.Block",
            'MACPOOL.MEMBEROF': "macpool.MemberOf",
            'MACPOOL.RESERVATIONREFERENCE': "macpool.ReservationReference",
            'MARKETPLACE.USECASEAUTOMATION': "marketplace.UseCaseAutomation",
            'MARKETPLACE.USECASEDEPENDENCY': "marketplace.UseCaseDependency",
            'MARKETPLACE.USECASELOCALE': "marketplace.UseCaseLocale",
            'MARKETPLACE.USECASEVERSIONLOCALE': "marketplace.UseCaseVersionLocale",
            'MARKETPLACE.USECASEVERSIONRESOURCE': "marketplace.UseCaseVersionResource",
            'MEMORY.PERSISTENTMEMORYGOAL': "memory.PersistentMemoryGoal",
            'MEMORY.PERSISTENTMEMORYLOCALSECURITY': "memory.PersistentMemoryLocalSecurity",
            'MEMORY.PERSISTENTMEMORYLOGICALNAMESPACE': "memory.PersistentMemoryLogicalNamespace",
            'META.ACCESSPRIVILEGE': "meta.AccessPrivilege",
            'META.DISPLAYNAMEDEFINITION': "meta.DisplayNameDefinition",
            'META.IDENTITYDEFINITION': "meta.IdentityDefinition",
            'META.PROPDEFINITION': "meta.PropDefinition",
            'META.RELATIONSHIPDEFINITION': "meta.RelationshipDefinition",
            'METRICS.METRICCRITERION': "metrics.MetricCriterion",
            'MO.MOREF': "mo.MoRef",
            'MO.TAG': "mo.Tag",
            'MO.VERSIONCONTEXT': "mo.VersionContext",
            'MONITORING.CATEGORYSTATUS': "monitoring.CategoryStatus",
            'MOTEMPLATE.ACTIONENTRY': "motemplate.ActionEntry",
            'MOTEMPLATE.ACTIONPARAM': "motemplate.ActionParam",
            'MOTEMPLATE.SYNCERROR': "motemplate.SyncError",
            'NETWORK.HYPERFLEXINTERNETPROTOCOLADDRESSRANGE': "network.HyperFlexInternetProtocolAddressRange",
            'NETWORK.HYPERFLEXNETWORKADDRESS': "network.HyperFlexNetworkAddress",
            'NIAAPI.DETAIL': "niaapi.Detail",
            'NIAAPI.NEWRELEASEDETAIL': "niaapi.NewReleaseDetail",
            'NIAAPI.REVISIONINFO': "niaapi.RevisionInfo",
            'NIAAPI.SOFTWAREREGEX': "niaapi.SoftwareRegex",
            'NIAAPI.VERSIONREGEXPLATFORM': "niaapi.VersionRegexPlatform",
            'NIATELEMETRY.BOOTFLASHDETAILS': "niatelemetry.BootflashDetails",
            'NIATELEMETRY.CLOUDREGIONSELEMENT': "niatelemetry.CloudRegionsElement",
            'NIATELEMETRY.CLOUDROUTERSELEMENT': "niatelemetry.CloudRoutersElement",
            'NIATELEMETRY.DEPLOYMENTSTATUS': "niatelemetry.DeploymentStatus",
            'NIATELEMETRY.DIGITALOPTICALMONITORING': "niatelemetry.DigitalOpticalMonitoring",
            'NIATELEMETRY.DISKINFO': "niatelemetry.Diskinfo",
            'NIATELEMETRY.DOMINFO': "niatelemetry.DomInfo",
            'NIATELEMETRY.DOMTHRESINFO': "niatelemetry.DomThresInfo",
            'NIATELEMETRY.EQPTSTORAGEFIRMWARE': "niatelemetry.EqptStorageFirmware",
            'NIATELEMETRY.EQPTCAPACITYPOLUSAGE5MIN': "niatelemetry.EqptcapacityPolUsage5min",
            'NIATELEMETRY.EQPTCAPACITYPREFIXENTRIES15MIN': "niatelemetry.EqptcapacityPrefixEntries15min",
            'NIATELEMETRY.EQPTCAPACITYPREFIXENTRIES5MIN': "niatelemetry.EqptcapacityPrefixEntries5min",
            'NIATELEMETRY.FANDETAILS': "niatelemetry.FanDetails",
            'NIATELEMETRY.IMAGEDETAIL': "niatelemetry.ImageDetail",
            'NIATELEMETRY.INTERFACE': "niatelemetry.Interface",
            'NIATELEMETRY.INTERFACEELEMENT': "niatelemetry.InterfaceElement",
            'NIATELEMETRY.JOBDETAIL': "niatelemetry.JobDetail",
            'NIATELEMETRY.LOGICALLINK': "niatelemetry.LogicalLink",
            'NIATELEMETRY.MDSNEIGHBORINFO': "niatelemetry.MdsNeighborInfo",
            'NIATELEMETRY.NETWORKINFO': "niatelemetry.NetworkInfo",
            'NIATELEMETRY.NODE': "niatelemetry.Node",
            'NIATELEMETRY.NVEPACKETCOUNTERS': "niatelemetry.NvePacketCounters",
            'NIATELEMETRY.NVEVNI': "niatelemetry.NveVni",
            'NIATELEMETRY.NXOSBGPEVPN': "niatelemetry.NxosBgpEvpn",
            'NIATELEMETRY.NXOSBGPMVPN': "niatelemetry.NxosBgpMvpn",
            'NIATELEMETRY.NXOSVTP': "niatelemetry.NxosVtp",
            'NIATELEMETRY.PROCSYSCPU15MIN': "niatelemetry.ProcSysCpu15min",
            'NIATELEMETRY.PROCSYSCPU5MIN': "niatelemetry.ProcSysCpu5min",
            'NIATELEMETRY.PROCSYSMEM15MIN': "niatelemetry.ProcSysMem15min",
            'NIATELEMETRY.PROCSYSMEM5MIN': "niatelemetry.ProcSysMem5min",
            'NIATELEMETRY.SITES': "niatelemetry.Sites",
            'NIATELEMETRY.SMARTLICENSE': "niatelemetry.SmartLicense",
            'NIATELEMETRY.SWITCHDISKUTILIZATION': "niatelemetry.SwitchDiskUtilization",
            'NIATELEMETRY.VNISTATUS': "niatelemetry.VniStatus",
            'NIATELEMETRY.VPCDETAILS': "niatelemetry.VpcDetails",
            'NOTIFICATION.AGGREGATIONSETTINGS': "notification.AggregationSettings",
            'NOTIFICATION.ALARMMOCONDITION': "notification.AlarmMoCondition",
            'NOTIFICATION.APPLIANCEUPGRADEMOCONDITION': "notification.ApplianceUpgradeMoCondition",
            'NOTIFICATION.DISTRIBUTABLEMOCONDITION': "notification.DistributableMoCondition",
            'NOTIFICATION.MOCONDITION': "notification.MoCondition",
            'NOTIFICATION.SENDEMAIL': "notification.SendEmail",
            'NOTIFICATION.SIMPLEFILTER': "notification.SimpleFilter",
            'NOTIFICATION.SIMPLEMOCONDITION': "notification.SimpleMoCondition",
            'NOTIFICATION.SOFTWARERELEASEMETAMOCONDITION': "notification.SoftwareReleaseMetaMoCondition",
            'NOTIFICATION.TRIGGERWEBHOOK': "notification.TriggerWebhook",
            'NTP.AUTHNTPSERVER': "ntp.AuthNtpServer",
            'ONPREM.CLUSTERINFO': "onprem.ClusterInfo",
            'ONPREM.CLUSTERNODE': "onprem.ClusterNode",
            'ONPREM.IMAGEPACKAGE': "onprem.ImagePackage",
            'ONPREM.RESOURCEINFO': "onprem.ResourceInfo",
            'ONPREM.SCHEDULE': "onprem.Schedule",
            'ONPREM.UPGRADENOTE': "onprem.UpgradeNote",
            'ONPREM.UPGRADEPHASE': "onprem.UpgradePhase",
            'OPENAPI.APIINFO': "openapi.ApiInfo",
            'OPENAPI.FAILEDTASK': "openapi.FailedTask",
            'OPENAPI.KEYVALUEPAIR': "openapi.KeyValuePair",
            'OPRS.KVPAIR': "oprs.Kvpair",
            'OS.ANSWERS': "os.Answers",
            'OS.FIBRECHANNELRESPONSE': "os.FibreChannelResponse",
            'OS.FIBRECHANNELTARGET': "os.FibreChannelTarget",
            'OS.GLOBALCONFIG': "os.GlobalConfig",
            'OS.IPV4CONFIGURATION': "os.Ipv4Configuration",
            'OS.IPV6CONFIGURATION': "os.Ipv6Configuration",
            'OS.ISCSILUNRESPONSE': "os.IscsiLunResponse",
            'OS.ISCSITARGET': "os.IscsiTarget",
            'OS.PHYSICALDISK': "os.PhysicalDisk",
            'OS.PHYSICALDISKRESPONSE': "os.PhysicalDiskResponse",
            'OS.PLACEHOLDER': "os.PlaceHolder",
            'OS.SERVERCONFIG': "os.ServerConfig",
            'OS.VALIDATIONINFORMATION': "os.ValidationInformation",
            'OS.VIRTUALDRIVE': "os.VirtualDrive",
            'OS.VIRTUALDRIVERESPONSE': "os.VirtualDriveResponse",
            'OS.VMWAREPARAMETERS': "os.VmwareParameters",
            'OS.WINDOWSPARAMETERS': "os.WindowsParameters",
            'PARTNERINTEGRATION.METRICSMODEL': "partnerintegration.MetricsModel",
            'PKIX.DISTINGUISHEDNAME': "pkix.DistinguishedName",
            'PKIX.ECDSAKEYSPEC': "pkix.EcdsaKeySpec",
            'PKIX.EDDSAKEYSPEC': "pkix.EddsaKeySpec",
            'PKIX.RSAALGORITHM': "pkix.RsaAlgorithm",
            'PKIX.SUBJECTALTERNATENAME': "pkix.SubjectAlternateName",
            'POLICY.ACTIONPARAM': "policy.ActionParam",
            'POLICY.ACTIONQUALIFIER': "policy.ActionQualifier",
            'POLICY.CONFIGCHANGE': "policy.ConfigChange",
            'POLICY.CONFIGCHANGECONTEXT': "policy.ConfigChangeContext",
            'POLICY.CONFIGCHANGEDISRUPTIONDETAILTYPE': "policy.ConfigChangeDisruptionDetailType",
            'POLICY.CONFIGCONTEXT': "policy.ConfigContext",
            'POLICY.CONFIGRESULTCONTEXT': "policy.ConfigResultContext",
            'POLICY.POLICYERROR': "policy.PolicyError",
            'POLICY.POLICYSTATUS': "policy.PolicyStatus",
            'POLICY.QUALIFIER': "policy.Qualifier",
            'POLICY.SCHEDULEDACTION': "policy.ScheduledAction",
            'RECOVERY.BACKUPSCHEDULE': "recovery.BackupSchedule",
            'RESOURCE.ADAPTORSRANGEFILTER': "resource.AdaptorsRangeFilter",
            'RESOURCE.BLADEQUALIFIER': "resource.BladeQualifier",
            'RESOURCE.CHASSISANDSLOTQUALIFICATION': "resource.ChassisAndSlotQualification",
            'RESOURCE.CHASSISIDRANGEFILTER': "resource.ChassisIdRangeFilter",
            'RESOURCE.CHASSISSERVERSQUALIFIER': "resource.ChassisServersQualifier",
            'RESOURCE.CPUCORERANGEFILTER': "resource.CpuCoreRangeFilter",
            'RESOURCE.CPUSPEEDRANGEFILTER': "resource.CpuSpeedRangeFilter",
            'RESOURCE.DOMAINQUALIFIER': "resource.DomainQualifier",
            'RESOURCE.GPUCONTROLLERSRANGEFILTER': "resource.GpuControllersRangeFilter",
            'RESOURCE.GPUQUALIFIER': "resource.GpuQualifier",
            'RESOURCE.MEMORYCAPACITYRANGEFILTER': "resource.MemoryCapacityRangeFilter",
            'RESOURCE.MEMORYQUALIFIER': "resource.MemoryQualifier",
            'RESOURCE.MEMORYUNITSRANGEFILTER': "resource.MemoryUnitsRangeFilter",
            'RESOURCE.NETWORKADAPTORQUALIFIER': "resource.NetworkAdaptorQualifier",
            'RESOURCE.ODATARULESETQUALIFIER': "resource.OdataRuleSetQualifier",
            'RESOURCE.PERTYPECOMBINEDSELECTOR': "resource.PerTypeCombinedSelector",
            'RESOURCE.PROCESSORQUALIFIER': "resource.ProcessorQualifier",
            'RESOURCE.RACKIDRANGEFILTER': "resource.RackIdRangeFilter",
            'RESOURCE.RACKSERVERQUALIFIER': "resource.RackServerQualifier",
            'RESOURCE.SELECTOR': "resource.Selector",
            'RESOURCE.SLOTIDRANGEFILTER': "resource.SlotIdRangeFilter",
            'RESOURCE.SOURCETOPERMISSIONRESOURCES': "resource.SourceToPermissionResources",
            'RESOURCE.SOURCETOPERMISSIONRESOURCESHOLDER': "resource.SourceToPermissionResourcesHolder",
            'RESOURCE.TAG': "resource.Tag",
            'RESOURCE.TAGQUALIFIER': "resource.TagQualifier",
            'RESOURCEPOOL.CHILDLEASECONDITION': "resourcepool.ChildLeaseCondition",
            'RESOURCEPOOL.QUALIFICATIONTYPE': "resourcepool.QualificationType",
            'RESOURCEPOOL.RESOURCEEVALUATIONSTATUS': "resourcepool.ResourceEvaluationStatus",
            'RESOURCEPOOL.SERVERLEASEPARAMETERS': "resourcepool.ServerLeaseParameters",
            'RESOURCEPOOL.SERVERPOOLPARAMETERS': "resourcepool.ServerPoolParameters",
            'SCHEDULER.BLOCKDATE': "scheduler.BlockDate",
            'SCHEDULER.DAILYCADENCEPARAMS': "scheduler.DailyCadenceParams",
            'SCHEDULER.EVERYCADENCEPARAMS': "scheduler.EveryCadenceParams",
            'SCHEDULER.MONTHLYCADENCEPARAMS': "scheduler.MonthlyCadenceParams",
            'SCHEDULER.ONETIMESCHEDULEPARAMS': "scheduler.OneTimeScheduleParams",
            'SCHEDULER.RECURRINGSCHEDULEPARAMS': "scheduler.RecurringScheduleParams",
            'SCHEDULER.RESTSTIMTASKREQUEST': "scheduler.RestStimTaskRequest",
            'SCHEDULER.TASKRESULTSTATUS': "scheduler.TaskResultStatus",
            'SCHEDULER.TASKSCHEDULEPOLICYEXECUTIONSTATUS': "scheduler.TaskSchedulePolicyExecutionStatus",
            'SCHEDULER.TASKSCHEDULESTATUS': "scheduler.TaskScheduleStatus",
            'SCHEDULER.WEEKLYCADENCEPARAMS': "scheduler.WeeklyCadenceParams",
            'SDCARD.DIAGNOSTICS': "sdcard.Diagnostics",
            'SDCARD.DRIVERS': "sdcard.Drivers",
            'SDCARD.HOSTUPGRADEUTILITY': "sdcard.HostUpgradeUtility",
            'SDCARD.OPERATINGSYSTEM': "sdcard.OperatingSystem",
            'SDCARD.PARTITION': "sdcard.Partition",
            'SDCARD.SERVERCONFIGURATIONUTILITY': "sdcard.ServerConfigurationUtility",
            'SDCARD.USERPARTITION': "sdcard.UserPartition",
            'SERVER.PENDINGWORKFLOWTRIGGER': "server.PendingWorkflowTrigger",
            'SERVER.SERVERASSIGNTYPESLOT': "server.ServerAssignTypeSlot",
            'SERVICEITEM.HEALTHCHECKERRORELEMENT': "serviceitem.HealthCheckErrorElement",
            'SERVICEITEM.MESSAGE': "serviceitem.Message",
            'SERVICEITEM.SELECTIONCRITERIAINPUT': "serviceitem.SelectionCriteriaInput",
            'SERVICEREQUEST.MESSAGE': "servicerequest.Message",
            'SNMP.TRAP': "snmp.Trap",
            'SNMP.USER': "snmp.User",
            'SOFTWAREREPOSITORY.APPLIANCEUPLOAD': "softwarerepository.ApplianceUpload",
            'SOFTWAREREPOSITORY.CIFSSERVER': "softwarerepository.CifsServer",
            'SOFTWAREREPOSITORY.CONSTRAINTMODELS': "softwarerepository.ConstraintModels",
            'SOFTWAREREPOSITORY.HTTPSERVER': "softwarerepository.HttpServer",
            'SOFTWAREREPOSITORY.IMPORTRESULT': "softwarerepository.ImportResult",
            'SOFTWAREREPOSITORY.LOCALMACHINE': "softwarerepository.LocalMachine",
            'SOFTWAREREPOSITORY.NFSSERVER': "softwarerepository.NfsServer",
            'SOFTWAREREPOSITORY.UNSUPPORTEDMODELCONSTRAINT': "softwarerepository.UnsupportedModelConstraint",
            'STORAGE.AUTOMATICDRIVEGROUP': "storage.AutomaticDriveGroup",
            'STORAGE.EXTERNALLUN': "storage.ExternalLun",
            'STORAGE.EXTERNALPARITYGROUP': "storage.ExternalParityGroup",
            'STORAGE.EXTERNALPATH': "storage.ExternalPath",
            'STORAGE.HITACHIARRAYUTILIZATION': "storage.HitachiArrayUtilization",
            'STORAGE.HITACHICAPACITY': "storage.HitachiCapacity",
            'STORAGE.HITACHIINITIATOR': "storage.HitachiInitiator",
            'STORAGE.HOSTNQN': "storage.HostNqn",
            'STORAGE.HYPERFLEXISCSIINITIATOR': "storage.HyperFlexIscsiInitiator",
            'STORAGE.INITIATOR': "storage.Initiator",
            'STORAGE.INTERNALMOPHYSICALDISKCONFIG': "storage.InternalMoPhysicalDiskConfig",
            'STORAGE.KEYSETTING': "storage.KeySetting",
            'STORAGE.KMIPAUTHCREDENTIALS': "storage.KmipAuthCredentials",
            'STORAGE.KMIPSERVER': "storage.KmipServer",
            'STORAGE.LOCALKEYSETTING': "storage.LocalKeySetting",
            'STORAGE.M2VIRTUALDRIVECONFIG': "storage.M2VirtualDriveConfig",
            'STORAGE.MANUALDRIVEGROUP': "storage.ManualDriveGroup",
            'STORAGE.NAMESPACE': "storage.Namespace",
            'STORAGE.NAMESPACEPATH': "storage.NamespacePath",
            'STORAGE.NETAPPAUTOSUPPORT': "storage.NetAppAutoSupport",
            'STORAGE.NETAPPCIFSACL': "storage.NetAppCifsAcl",
            'STORAGE.NETAPPETHERNETPORTLAG': "storage.NetAppEthernetPortLag",
            'STORAGE.NETAPPETHERNETPORTVLAN': "storage.NetAppEthernetPortVlan",
            'STORAGE.NETAPPEXPORTPOLICYRULE': "storage.NetAppExportPolicyRule",
            'STORAGE.NETAPPHIGHAVAILABILITY': "storage.NetAppHighAvailability",
            'STORAGE.NETAPPPERFORMANCEMETRICSAVERAGE': "storage.NetAppPerformanceMetricsAverage",
            'STORAGE.NETAPPPORT': "storage.NetAppPort",
            'STORAGE.NETAPPSNAPSHOTPOLICYSCHEDULE': "storage.NetAppSnapshotPolicySchedule",
            'STORAGE.NETAPPSTORAGECLUSTEREFFICIENCY': "storage.NetAppStorageClusterEfficiency",
            'STORAGE.NETAPPSTORAGEUTILIZATION': "storage.NetAppStorageUtilization",
            'STORAGE.NVMEDEDICATEDHOTSPARECONFIGURATION': "storage.NvmeDedicatedHotSpareConfiguration",
            'STORAGE.NVMEPHYSICALDISKSTATE': "storage.NvmePhysicalDiskState",
            'STORAGE.NVMERAIDDRIVEGROUP': "storage.NvmeRaidDriveGroup",
            'STORAGE.NVMEVIRTUALDRIVECONFIGURATION': "storage.NvmeVirtualDriveConfiguration",
            'STORAGE.PUREARRAYUTILIZATION': "storage.PureArrayUtilization",
            'STORAGE.PUREDISKUTILIZATION': "storage.PureDiskUtilization",
            'STORAGE.PUREHOSTUTILIZATION': "storage.PureHostUtilization",
            'STORAGE.PUREREPLICATIONBLACKOUT': "storage.PureReplicationBlackout",
            'STORAGE.PUREVOLUMEUTILIZATION': "storage.PureVolumeUtilization",
            'STORAGE.R0DRIVE': "storage.R0Drive",
            'STORAGE.REMOTEKEYSETTING': "storage.RemoteKeySetting",
            'STORAGE.SPACE': "storage.Space",
            'STORAGE.SPANDRIVES': "storage.SpanDrives",
            'STORAGE.STORAGECONTAINERHOSTMOUNTSTATUS': "storage.StorageContainerHostMountStatus",
            'STORAGE.STORAGECONTAINERUTILIZATION': "storage.StorageContainerUtilization",
            'STORAGE.VIRTUALDRIVECONFIGURATION': "storage.VirtualDriveConfiguration",
            'STORAGE.VIRTUALDRIVEPOLICY': "storage.VirtualDrivePolicy",
            'STORAGE.VOLUMEUTILIZATION': "storage.VolumeUtilization",
            'SYSLOG.LOCALFILELOGGINGCLIENT': "syslog.LocalFileLoggingClient",
            'SYSLOG.REMOTELOGGINGCLIENT': "syslog.RemoteLoggingClient",
            'TAM.ACTION': "tam.Action",
            'TAM.APIDATASOURCE': "tam.ApiDataSource",
            'TAM.EOLADVISORYDETAILS': "tam.EolAdvisoryDetails",
            'TAM.EOLSEVERITY': "tam.EolSeverity",
            'TAM.FNSEVERITY': "tam.FnSeverity",
            'TAM.IDENTIFIERS': "tam.Identifiers",
            'TAM.MILESTONE': "tam.Milestone",
            'TAM.PSIRTSEVERITY': "tam.PsirtSeverity",
            'TAM.QUERYENTRY': "tam.QueryEntry",
            'TAM.S3DATASOURCE': "tam.S3DataSource",
            'TAM.SECURITYADVISORYDETAILS': "tam.SecurityAdvisoryDetails",
            'TAM.TEXTFSMTEMPLATEDATASOURCE': "tam.TextFsmTemplateDataSource",
            'TASK.FILEDOWNLOADINFO': "task.FileDownloadInfo",
            'TECHSUPPORTMANAGEMENT.APPLIANCEPARAM': "techsupportmanagement.ApplianceParam",
            'TECHSUPPORTMANAGEMENT.NIAPARAM': "techsupportmanagement.NiaParam",
            'TECHSUPPORTMANAGEMENT.PLATFORMPARAM': "techsupportmanagement.PlatformParam",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTFILEINFO': "techsupportmanagement.TechSupportFileInfo",
            'TEMPLATE.TRANSFORMATIONSTAGE': "template.TransformationStage",
            'UCSD.CONNECTORPACK': "ucsd.ConnectorPack",
            'UCSD.UCSDRESTOREPARAMETERS': "ucsd.UcsdRestoreParameters",
            'UCSDCONNECTOR.RESTCLIENTMESSAGE': "ucsdconnector.RestClientMessage",
            'UUIDPOOL.RESERVATIONREFERENCE': "uuidpool.ReservationReference",
            'UUIDPOOL.UUIDBLOCK': "uuidpool.UuidBlock",
            'VIRTUALIZATION.ACTIONINFO': "virtualization.ActionInfo",
            'VIRTUALIZATION.CLOUDINITCONFIG': "virtualization.CloudInitConfig",
            'VIRTUALIZATION.COMPUTECAPACITY': "virtualization.ComputeCapacity",
            'VIRTUALIZATION.CPUINFO': "virtualization.CpuInfo",
            'VIRTUALIZATION.ESXICLONECUSTOMSPEC': "virtualization.EsxiCloneCustomSpec",
            'VIRTUALIZATION.ESXIHOSTCONFIGURATION': "virtualization.EsxiHostConfiguration",
            'VIRTUALIZATION.ESXIOVACUSTOMSPEC': "virtualization.EsxiOvaCustomSpec",
            'VIRTUALIZATION.ESXIVMCOMPUTECONFIGURATION': "virtualization.EsxiVmComputeConfiguration",
            'VIRTUALIZATION.ESXIVMCONFIGURATION': "virtualization.EsxiVmConfiguration",
            'VIRTUALIZATION.ESXIVMNETWORKCONFIGURATION': "virtualization.EsxiVmNetworkConfiguration",
            'VIRTUALIZATION.ESXIVMSTORAGECONFIGURATION': "virtualization.EsxiVmStorageConfiguration",
            'VIRTUALIZATION.GUESTINFO': "virtualization.GuestInfo",
            'VIRTUALIZATION.MEMORYCAPACITY': "virtualization.MemoryCapacity",
            'VIRTUALIZATION.NETWORKINTERFACE': "virtualization.NetworkInterface",
            'VIRTUALIZATION.PRODUCTINFO': "virtualization.ProductInfo",
            'VIRTUALIZATION.STORAGECAPACITY': "virtualization.StorageCapacity",
            'VIRTUALIZATION.VIRTUALMACHINEDISK': "virtualization.VirtualMachineDisk",
            'VIRTUALIZATION.VMESXIDISK': "virtualization.VmEsxiDisk",
            'VIRTUALIZATION.VMWAREATTACHEDRESOURCETAG': "virtualization.VmwareAttachedResourceTag",
            'VIRTUALIZATION.VMWAREDISCOVERYPROTOCOL': "virtualization.VmwareDiscoveryProtocol",
            'VIRTUALIZATION.VMWAREREMOTEDISPLAYINFO': "virtualization.VmwareRemoteDisplayInfo",
            'VIRTUALIZATION.VMWARERESOURCEALLOCATIONSYSTEMTRAFFICTYPES': "virtualization.VmwareResourceAllocationSystemTrafficTypes",
            'VIRTUALIZATION.VMWARERESOURCECONSUMPTION': "virtualization.VmwareResourceConsumption",
            'VIRTUALIZATION.VMWARESHARESINFO': "virtualization.VmwareSharesInfo",
            'VIRTUALIZATION.VMWARETEAMINGANDFAILOVER': "virtualization.VmwareTeamingAndFailover",
            'VIRTUALIZATION.VMWAREVLANRANGE': "virtualization.VmwareVlanRange",
            'VIRTUALIZATION.VMWAREVMCPUSHAREINFO': "virtualization.VmwareVmCpuShareInfo",
            'VIRTUALIZATION.VMWAREVMCPUSOCKETINFO': "virtualization.VmwareVmCpuSocketInfo",
            'VIRTUALIZATION.VMWAREVMDISKCOMMITINFO': "virtualization.VmwareVmDiskCommitInfo",
            'VIRTUALIZATION.VMWAREVMMEMORYSHAREINFO': "virtualization.VmwareVmMemoryShareInfo",
            'VMEDIA.MAPPING': "vmedia.Mapping",
            'VNIC.ARFSSETTINGS': "vnic.ArfsSettings",
            'VNIC.CDN': "vnic.Cdn",
            'VNIC.COMPLETIONQUEUESETTINGS': "vnic.CompletionQueueSettings",
            'VNIC.ETHIFOLDINFO': "vnic.EthIfOldInfo",
            'VNIC.ETHINTERRUPTSETTINGS': "vnic.EthInterruptSettings",
            'VNIC.ETHRXQUEUESETTINGS': "vnic.EthRxQueueSettings",
            'VNIC.ETHTXQUEUESETTINGS': "vnic.EthTxQueueSettings",
            'VNIC.FCERRORRECOVERYSETTINGS': "vnic.FcErrorRecoverySettings",
            'VNIC.FCIFOLDINFO': "vnic.FcIfOldInfo",
            'VNIC.FCINTERRUPTSETTINGS': "vnic.FcInterruptSettings",
            'VNIC.FCQUEUESETTINGS': "vnic.FcQueueSettings",
            'VNIC.FLOGISETTINGS': "vnic.FlogiSettings",
            'VNIC.ISCSIAUTHPROFILE': "vnic.IscsiAuthProfile",
            'VNIC.LUN': "vnic.Lun",
            'VNIC.NVGRESETTINGS': "vnic.NvgreSettings",
            'VNIC.PLACEMENTSETTINGS': "vnic.PlacementSettings",
            'VNIC.PLOGISETTINGS': "vnic.PlogiSettings",
            'VNIC.PTPSETTINGS': "vnic.PtpSettings",
            'VNIC.ROCESETTINGS': "vnic.RoceSettings",
            'VNIC.RSSHASHSETTINGS': "vnic.RssHashSettings",
            'VNIC.SANSETTINGSOLDINFO': "vnic.SanSettingsOldInfo",
            'VNIC.SCSIQUEUESETTINGS': "vnic.ScsiQueueSettings",
            'VNIC.SRIOVSETTINGS': "vnic.SriovSettings",
            'VNIC.TCPOFFLOADSETTINGS': "vnic.TcpOffloadSettings",
            'VNIC.USNICSETTINGS': "vnic.UsnicSettings",
            'VNIC.VIFSTATUS': "vnic.VifStatus",
            'VNIC.VLANSETTINGS': "vnic.VlanSettings",
            'VNIC.VMQSETTINGS': "vnic.VmqSettings",
            'VNIC.VSANSETTINGS': "vnic.VsanSettings",
            'VNIC.VXLANSETTINGS': "vnic.VxlanSettings",
            'WORKFLOW.ANSIBLEPLAYSESSION': "workflow.AnsiblePlaySession",
            'WORKFLOW.ARRAYDATATYPE': "workflow.ArrayDataType",
            'WORKFLOW.ASSOCIATEDROLES': "workflow.AssociatedRoles",
            'WORKFLOW.CANCELABLETYPE': "workflow.CancelableType",
            'WORKFLOW.CLICOMMAND': "workflow.CliCommand",
            'WORKFLOW.COMMENTS': "workflow.Comments",
            'WORKFLOW.CONSTRAINTS': "workflow.Constraints",
            'WORKFLOW.CUSTOMARRAYITEM': "workflow.CustomArrayItem",
            'WORKFLOW.CUSTOMDATAPROPERTY': "workflow.CustomDataProperty",
            'WORKFLOW.CUSTOMDATATYPE': "workflow.CustomDataType",
            'WORKFLOW.CUSTOMDATATYPEPROPERTIES': "workflow.CustomDataTypeProperties",
            'WORKFLOW.DATASOURCESELECTOR': "workflow.DataSourceSelector",
            'WORKFLOW.DECISIONCASE': "workflow.DecisionCase",
            'WORKFLOW.DECISIONTASK': "workflow.DecisionTask",
            'WORKFLOW.DEFAULTVALUE': "workflow.DefaultValue",
            'WORKFLOW.DISPLAYMETA': "workflow.DisplayMeta",
            'WORKFLOW.DYNAMICTEMPLATEPARSERDATATYPE': "workflow.DynamicTemplateParserDataType",
            'WORKFLOW.ENUMENTRY': "workflow.EnumEntry",
            'WORKFLOW.ENVIRONMENTVARIABLEREFERENCE': "workflow.EnvironmentVariableReference",
            'WORKFLOW.EXPECTPROMPT': "workflow.ExpectPrompt",
            'WORKFLOW.FAILUREENDTASK': "workflow.FailureEndTask",
            'WORKFLOW.FILEDOWNLOADOP': "workflow.FileDownloadOp",
            'WORKFLOW.FILEOPERATIONS': "workflow.FileOperations",
            'WORKFLOW.FILETEMPLATEOP': "workflow.FileTemplateOp",
            'WORKFLOW.FILETRANSFER': "workflow.FileTransfer",
            'WORKFLOW.FORKTASK': "workflow.ForkTask",
            'WORKFLOW.INITIATORCONTEXT': "workflow.InitiatorContext",
            'WORKFLOW.INTERNALPROPERTIES': "workflow.InternalProperties",
            'WORKFLOW.JOINTASK': "workflow.JoinTask",
            'WORKFLOW.LOOPTASK': "workflow.LoopTask",
            'WORKFLOW.MESSAGE': "workflow.Message",
            'WORKFLOW.MIGRATESERVICEITEMACTIONPROPERTY': "workflow.MigrateServiceItemActionProperty",
            'WORKFLOW.MIGRATIONHISTORY': "workflow.MigrationHistory",
            'WORKFLOW.MOINVENTORYDATATYPE': "workflow.MoInventoryDataType",
            'WORKFLOW.MOINVENTORYPROPERTY': "workflow.MoInventoryProperty",
            'WORKFLOW.MOREFERENCEARRAYITEM': "workflow.MoReferenceArrayItem",
            'WORKFLOW.MOREFERENCEAUTOARRAYITEM': "workflow.MoReferenceAutoArrayItem",
            'WORKFLOW.MOREFERENCEAUTODATATYPE': "workflow.MoReferenceAutoDataType",
            'WORKFLOW.MOREFERENCEAUTOPROPERTY': "workflow.MoReferenceAutoProperty",
            'WORKFLOW.MOREFERENCEDATATYPE': "workflow.MoReferenceDataType",
            'WORKFLOW.MOREFERENCEFORCLONEDATATYPE': "workflow.MoReferenceForCloneDataType",
            'WORKFLOW.MOREFERENCEPROPERTY': "workflow.MoReferenceProperty",
            'WORKFLOW.OPERATIONTYPEDECOMMISSION': "workflow.OperationTypeDecommission",
            'WORKFLOW.OPERATIONTYPEDEPLOYMENT': "workflow.OperationTypeDeployment",
            'WORKFLOW.OPERATIONTYPEPOSTDEPLOYMENT': "workflow.OperationTypePostDeployment",
            'WORKFLOW.PARAMETERSET': "workflow.ParameterSet",
            'WORKFLOW.POWERSHELLAPI': "workflow.PowerShellApi",
            'WORKFLOW.PRIMITIVEARRAYITEM': "workflow.PrimitiveArrayItem",
            'WORKFLOW.PRIMITIVEDATAPROPERTY': "workflow.PrimitiveDataProperty",
            'WORKFLOW.PRIMITIVEDATATYPE': "workflow.PrimitiveDataType",
            'WORKFLOW.PROPERTIES': "workflow.Properties",
            'WORKFLOW.RESOURCEINLINESELECTOR': "workflow.ResourceInlineSelector",
            'WORKFLOW.RESOURCESELECTORCRITERIA': "workflow.ResourceSelectorCriteria",
            'WORKFLOW.RESULTHANDLER': "workflow.ResultHandler",
            'WORKFLOW.ROLLBACKTASK': "workflow.RollbackTask",
            'WORKFLOW.ROLLBACKWORKFLOWTASK': "workflow.RollbackWorkflowTask",
            'WORKFLOW.SELECTORPROPERTY': "workflow.SelectorProperty",
            'WORKFLOW.SEQUENCEPARAMS': "workflow.SequenceParams",
            'WORKFLOW.SERIALLOOPTASK': "workflow.SerialLoopTask",
            'WORKFLOW.SERVICEITEMACTIONPROPERTIES': "workflow.ServiceItemActionProperties",
            'WORKFLOW.SERVICEITEMACTIONWORKFLOWDEFINITION': "workflow.ServiceItemActionWorkflowDefinition",
            'WORKFLOW.SERVICEITEMINPUTDEFINITIONTYPE': "workflow.ServiceItemInputDefinitionType",
            'WORKFLOW.SERVICEITEMTYPE': "workflow.ServiceItemType",
            'WORKFLOW.SSHCMD': "workflow.SshCmd",
            'WORKFLOW.SSHCONFIG': "workflow.SshConfig",
            'WORKFLOW.SSHSESSION': "workflow.SshSession",
            'WORKFLOW.STARTTASK': "workflow.StartTask",
            'WORKFLOW.SUBWORKFLOWTASK': "workflow.SubWorkflowTask",
            'WORKFLOW.SUCCESSENDTASK': "workflow.SuccessEndTask",
            'WORKFLOW.TARGETCONTEXT': "workflow.TargetContext",
            'WORKFLOW.TARGETDATATYPE': "workflow.TargetDataType",
            'WORKFLOW.TARGETPROPERTY': "workflow.TargetProperty",
            'WORKFLOW.TASKCONSTRAINTS': "workflow.TaskConstraints",
            'WORKFLOW.TASKINFOUPDATE': "workflow.TaskInfoUpdate",
            'WORKFLOW.TASKLOOPINFO': "workflow.TaskLoopInfo",
            'WORKFLOW.TASKRETRYINFO': "workflow.TaskRetryInfo",
            'WORKFLOW.UIFORMCONFIG': "workflow.UiFormConfig",
            'WORKFLOW.UIINPUTFILTER': "workflow.UiInputFilter",
            'WORKFLOW.UIVIEWCONFIG': "workflow.UiViewConfig",
            'WORKFLOW.VALIDATIONERROR': "workflow.ValidationError",
            'WORKFLOW.VALIDATIONINFORMATION': "workflow.ValidationInformation",
            'WORKFLOW.WAITTASK': "workflow.WaitTask",
            'WORKFLOW.WAITTASKPROMPT': "workflow.WaitTaskPrompt",
            'WORKFLOW.WEBAPI': "workflow.WebApi",
            'WORKFLOW.WORKERTASK': "workflow.WorkerTask",
            'WORKFLOW.WORKFLOWCTX': "workflow.WorkflowCtx",
            'WORKFLOW.WORKFLOWENGINEPROPERTIES': "workflow.WorkflowEngineProperties",
            'WORKFLOW.WORKFLOWINFOAUTORESTARTPROPERTIES': "workflow.WorkflowInfoAutoRestartProperties",
            'WORKFLOW.WORKFLOWINFOPROPERTIES': "workflow.WorkflowInfoProperties",
            'WORKFLOW.WORKFLOWPROPERTIES': "workflow.WorkflowProperties",
            'WORKFLOW.XMLAPI': "workflow.XmlApi",
            'WORKLOAD.ASSIGNEDRESOURCE': "workload.AssignedResource",
            'WORKLOAD.BATCHDEPLOYMENT': "workload.BatchDeployment",
            'WORKLOAD.BLUEPRINTINPUTREFERENCE': "workload.BlueprintInputReference",
            'WORKLOAD.BLUEPRINTREFERENCE': "workload.BlueprintReference",
            'WORKLOAD.CANARYDEPLOYMENT': "workload.CanaryDeployment",
            'WORKLOAD.CLONESTATUS': "workload.CloneStatus",
            'WORKLOAD.CLONESTATUSENTRY': "workload.CloneStatusEntry",
            'WORKLOAD.DEFINITIONMAPPER': "workload.DefinitionMapper",
            'WORKLOAD.DEPLOYMENTBLUEPRINTINPUTTYPE': "workload.DeploymentBlueprintInputType",
            'WORKLOAD.DEPLOYMENTCHANGEDETAIL': "workload.DeploymentChangeDetail",
            'WORKLOAD.GENERATEDOBJECT': "workload.GeneratedObject",
            'WORKLOAD.RESOURCECONSTRAINT': "workload.ResourceConstraint",
            'WORKLOAD.STATEAGGREGATION': "workload.StateAggregation",
            'X509.CERTIFICATE': "x509.Certificate",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'aaa.UserAgent': AaaUserAgent,
            'access.AddressType': AccessAddressType,
            'access.ConfigurationType': AccessConfigurationType,
            'adapter.AdapterConfig': AdapterAdapterConfig,
            'adapter.DceInterfaceSettings': AdapterDceInterfaceSettings,
            'adapter.EthSettings': AdapterEthSettings,
            'adapter.FcSettings': AdapterFcSettings,
            'adapter.PhysicalNicModeSettings': AdapterPhysicalNicModeSettings,
            'adapter.PortChannelSettings': AdapterPortChannelSettings,
            'apic.FabricLeafNodeDetails': ApicFabricLeafNodeDetails,
            'appliance.ApiStatus': ApplianceApiStatus,
            'appliance.CertRenewalPhase': ApplianceCertRenewalPhase,
            'appliance.ClusterInstallPhase': ApplianceClusterInstallPhase,
            'appliance.KeyValuePair': ApplianceKeyValuePair,
            'appliance.MetadataManifestVersion': ApplianceMetadataManifestVersion,
            'appliance.NetworkStatus': ApplianceNetworkStatus,
            'appliance.NodeIpInfo': ApplianceNodeIpInfo,
            'appliance.StatusCheck': ApplianceStatusCheck,
            'asset.AddressInformation': AssetAddressInformation,
            'asset.AlarmSummary': AssetAlarmSummary,
            'asset.ApiKeyCredential': AssetApiKeyCredential,
            'asset.ClaimSignature': AssetClaimSignature,
            'asset.ClientCertificateCredential': AssetClientCertificateCredential,
            'asset.CloudConnection': AssetCloudConnection,
            'asset.Connection': AssetConnection,
            'asset.ConnectionFlapStatus': AssetConnectionFlapStatus,
            'asset.ContractInformation': AssetContractInformation,
            'asset.Credential': AssetCredential,
            'asset.CustomerInformation': AssetCustomerInformation,
            'asset.DeploymentAlarmInfo': AssetDeploymentAlarmInfo,
            'asset.DeploymentDeviceAlarmInfo': AssetDeploymentDeviceAlarmInfo,
            'asset.DeploymentDeviceInformation': AssetDeploymentDeviceInformation,
            'asset.DeviceEndpointLocalCredential': AssetDeviceEndpointLocalCredential,
            'asset.DeviceInformation': AssetDeviceInformation,
            'asset.DeviceStatistics': AssetDeviceStatistics,
            'asset.DeviceTransaction': AssetDeviceTransaction,
            'asset.GenericTargetClaimOptions': AssetGenericTargetClaimOptions,
            'asset.GlobalUltimate': AssetGlobalUltimate,
            'asset.GoogleCloudPlatformServiceAccountKeyCredential': AssetGoogleCloudPlatformServiceAccountKeyCredential,
            'asset.HttpConnection': AssetHttpConnection,
            'asset.IntersightDeviceConnectorConnection': AssetIntersightDeviceConnectorConnection,
            'asset.MerakiCloudOptions': AssetMerakiCloudOptions,
            'asset.MeteringType': AssetMeteringType,
            'asset.NewRelicCredential': AssetNewRelicCredential,
            'asset.NoAuthenticationCredential': AssetNoAuthenticationCredential,
            'asset.OauthBearerTokenCredential': AssetOauthBearerTokenCredential,
            'asset.OauthClientIdSecretCredential': AssetOauthClientIdSecretCredential,
            'asset.OrchestrationCivpVmwareVcenterOptions': AssetOrchestrationCivpVmwareVcenterOptions,
            'asset.OrchestrationHitachiVirtualStoragePlatformOptions': AssetOrchestrationHitachiVirtualStoragePlatformOptions,
            'asset.OrchestrationHsmVmwareVcenterOptions': AssetOrchestrationHsmVmwareVcenterOptions,
            'asset.OrchestrationService': AssetOrchestrationService,
            'asset.ParentConnectionSignature': AssetParentConnectionSignature,
            'asset.PrivateKeyCredential': AssetPrivateKeyCredential,
            'asset.ProductInformation': AssetProductInformation,
            'asset.ScopedTargetConnection': AssetScopedTargetConnection,
            'asset.Service': AssetService,
            'asset.ServiceNowCredential': AssetServiceNowCredential,
            'asset.ServiceOptions': AssetServiceOptions,
            'asset.SshConnection': AssetSshConnection,
            'asset.SudiInfo': AssetSudiInfo,
            'asset.TargetKey': AssetTargetKey,
            'asset.TargetSignature': AssetTargetSignature,
            'asset.TargetStatusDetails': AssetTargetStatusDetails,
            'asset.TerraformIntegrationService': AssetTerraformIntegrationService,
            'asset.TerraformIntegrationTerraformAgentOptions': AssetTerraformIntegrationTerraformAgentOptions,
            'asset.TerraformIntegrationTerraformCloudOptions': AssetTerraformIntegrationTerraformCloudOptions,
            'asset.UsernamePasswordCredential': AssetUsernamePasswordCredential,
            'asset.VirtualizationAmazonWebServiceOptions': AssetVirtualizationAmazonWebServiceOptions,
            'asset.VirtualizationCloudOptions': AssetVirtualizationCloudOptions,
            'asset.VirtualizationService': AssetVirtualizationService,
            'asset.VmHost': AssetVmHost,
            'asset.WorkloadOptimizerAmazonWebServicesBillingOptions': AssetWorkloadOptimizerAmazonWebServicesBillingOptions,
            'asset.WorkloadOptimizerDynatraceOptions': AssetWorkloadOptimizerDynatraceOptions,
            'asset.WorkloadOptimizerGoogleCloudPlatformBillingOptions': AssetWorkloadOptimizerGoogleCloudPlatformBillingOptions,
            'asset.WorkloadOptimizerHypervOptions': AssetWorkloadOptimizerHypervOptions,
            'asset.WorkloadOptimizerMicrosoftAzureApplicationInsightsOptions': AssetWorkloadOptimizerMicrosoftAzureApplicationInsightsOptions,
            'asset.WorkloadOptimizerMicrosoftAzureBillingOptions': AssetWorkloadOptimizerMicrosoftAzureBillingOptions,
            'asset.WorkloadOptimizerMicrosoftAzureEnterpriseAgreementOptions': AssetWorkloadOptimizerMicrosoftAzureEnterpriseAgreementOptions,
            'asset.WorkloadOptimizerMicrosoftAzureServicePrincipalOptions': AssetWorkloadOptimizerMicrosoftAzureServicePrincipalOptions,
            'asset.WorkloadOptimizerMicrosoftSqlServerOptions': AssetWorkloadOptimizerMicrosoftSqlServerOptions,
            'asset.WorkloadOptimizerNewRelicOptions': AssetWorkloadOptimizerNewRelicOptions,
            'asset.WorkloadOptimizerOpenStackOptions': AssetWorkloadOptimizerOpenStackOptions,
            'asset.WorkloadOptimizerOracleDatabaseServerOptions': AssetWorkloadOptimizerOracleDatabaseServerOptions,
            'asset.WorkloadOptimizerRedHatOpenStackOptions': AssetWorkloadOptimizerRedHatOpenStackOptions,
            'asset.WorkloadOptimizerService': AssetWorkloadOptimizerService,
            'asset.WorkloadOptimizerVmwareVcenterOptions': AssetWorkloadOptimizerVmwareVcenterOptions,
            'blueprint.BaseGeneratedObjectSourceFromSelector': BlueprintBaseGeneratedObjectSourceFromSelector,
            'blueprint.BaseGeneratedObjectSourceMetadata': BlueprintBaseGeneratedObjectSourceMetadata,
            'blueprint.BlueprintDefinitionDependency': BlueprintBlueprintDefinitionDependency,
            'blueprint.GeneratedObjectMetadata': BlueprintGeneratedObjectMetadata,
            'blueprint.GeneratedObjectNew': BlueprintGeneratedObjectNew,
            'blueprint.GeneratedObjectOperationTarget': BlueprintGeneratedObjectOperationTarget,
            'blueprint.GeneratedObjectSourceClone': BlueprintGeneratedObjectSourceClone,
            'blueprint.GeneratedObjectSourceLookup': BlueprintGeneratedObjectSourceLookup,
            'blueprint.GeneratedObjectSourceMerge': BlueprintGeneratedObjectSourceMerge,
            'blueprint.GeneratedObjectSourceReference': BlueprintGeneratedObjectSourceReference,
            'blueprint.GeneratedObjectSourceSelector': BlueprintGeneratedObjectSourceSelector,
            'blueprint.InputOperationType': BlueprintInputOperationType,
            'blueprint.PreGenerateOperation': BlueprintPreGenerateOperation,
            'blueprint.PropertyIteration': BlueprintPropertyIteration,
            'blueprint.ResourceConstraints': BlueprintResourceConstraints,
            'blueprint.ServiceItemDefinition': BlueprintServiceItemDefinition,
            'boot.Bootloader': BootBootloader,
            'boot.DeviceBase': BootDeviceBase,
            'boot.FlexMmc': BootFlexMmc,
            'boot.Http': BootHttp,
            'boot.Iscsi': BootIscsi,
            'boot.LocalCdd': BootLocalCdd,
            'boot.LocalDisk': BootLocalDisk,
            'boot.Nvme': BootNvme,
            'boot.PchStorage': BootPchStorage,
            'boot.Pxe': BootPxe,
            'boot.San': BootSan,
            'boot.SdCard': BootSdCard,
            'boot.StaticIpV4Settings': BootStaticIpV4Settings,
            'boot.StaticIpV6Settings': BootStaticIpV6Settings,
            'boot.UefiShell': BootUefiShell,
            'boot.Usb': BootUsb,
            'boot.VirtualMedia': BootVirtualMedia,
            'bulk.ApiResult': BulkApiResult,
            'bulk.HttpHeader': BulkHttpHeader,
            'bulk.MultiRelationEntryPatch': BulkMultiRelationEntryPatch,
            'bulk.PatchContent': BulkPatchContent,
            'bulk.RestResult': BulkRestResult,
            'bulk.RestSubRequest': BulkRestSubRequest,
            'bulk.SecResourceRoles': BulkSecResourceRoles,
            'bulk.SubRequest': BulkSubRequest,
            'capability.CertificatePropertyConstraints': CapabilityCertificatePropertyConstraints,
            'capability.FeatureConfig': CapabilityFeatureConfig,
            'capability.HsuIsoModelSpecificConstraint': CapabilityHsuIsoModelSpecificConstraint,
            'capability.LdapBasePropertyConstraints': CapabilityLdapBasePropertyConstraints,
            'capability.PcIdRange': CapabilityPcIdRange,
            'capability.PortRange': CapabilityPortRange,
            'capability.ServerComponentConstraint': CapabilityServerComponentConstraint,
            'capability.SwitchNetworkLimits': CapabilitySwitchNetworkLimits,
            'capability.SwitchStorageLimits': CapabilitySwitchStorageLimits,
            'capability.SwitchSystemLimits': CapabilitySwitchSystemLimits,
            'capability.SwitchingModeCapability': CapabilitySwitchingModeCapability,
            'capability.UnsupportedFeatureConfig': CapabilityUnsupportedFeatureConfig,
            'capability.UpdateOrderListType': CapabilityUpdateOrderListType,
            'certificatemanagement.CertificateBase': CertificatemanagementCertificateBase,
            'certificatemanagement.Imc': CertificatemanagementImc,
            'certificatemanagement.RootCaCertificate': CertificatemanagementRootCaCertificate,
            'cloud.TfcWorkspaceVariables': CloudTfcWorkspaceVariables,
            'cmrf.CmRf': CmrfCmRf,
            'comm.GeoLocationDetails': CommGeoLocationDetails,
            'comm.GeoPoint': CommGeoPoint,
            'comm.IpV4AddressBlock': CommIpV4AddressBlock,
            'comm.IpV4Interface': CommIpV4Interface,
            'comm.IpV6Interface': CommIpV6Interface,
            'comm.PhysicalAddress': CommPhysicalAddress,
            'comm.TagUsage': CommTagUsage,
            'compute.AlarmSummary': ComputeAlarmSummary,
            'compute.HostUtilityOperationConfguration': ComputeHostUtilityOperationConfguration,
            'compute.IpAddress': ComputeIpAddress,
            'compute.PendingWorkflowTrigger': ComputePendingWorkflowTrigger,
            'compute.PersistentMemoryModule': ComputePersistentMemoryModule,
            'compute.PersistentMemoryOperation': ComputePersistentMemoryOperation,
            'compute.PersonalitySetting': ComputePersonalitySetting,
            'compute.ScrubOpConfigutation': ComputeScrubOpConfigutation,
            'compute.ServerConfig': ComputeServerConfig,
            'compute.ServerOpStatus': ComputeServerOpStatus,
            'compute.StorageControllerOperation': ComputeStorageControllerOperation,
            'compute.StoragePhysicalDrive': ComputeStoragePhysicalDrive,
            'compute.StoragePhysicalDriveOperation': ComputeStoragePhysicalDriveOperation,
            'compute.StorageUtilityImageOperation': ComputeStorageUtilityImageOperation,
            'compute.StorageVirtualDrive': ComputeStorageVirtualDrive,
            'compute.StorageVirtualDriveOperation': ComputeStorageVirtualDriveOperation,
            'cond.AlarmAction': CondAlarmAction,
            'cond.AlarmClassificationEligibility': CondAlarmClassificationEligibility,
            'cond.AlarmSpec': CondAlarmSpec,
            'cond.AlarmSummary': CondAlarmSummary,
            'connector.AuthMessage': ConnectorAuthMessage,
            'connector.BaseMessage': ConnectorBaseMessage,
            'connector.CloseStreamMessage': ConnectorCloseStreamMessage,
            'connector.CommandControlMessage': ConnectorCommandControlMessage,
            'connector.CommandTerminalStream': ConnectorCommandTerminalStream,
            'connector.EventLog': ConnectorEventLog,
            'connector.ExpectPrompt': ConnectorExpectPrompt,
            'connector.FetchStreamMessage': ConnectorFetchStreamMessage,
            'connector.FileChecksum': ConnectorFileChecksum,
            'connector.FileMessage': ConnectorFileMessage,
            'connector.HttpRequest': ConnectorHttpRequest,
            'connector.PlatformParamBase': ConnectorPlatformParamBase,
            'connector.SshConfig': ConnectorSshConfig,
            'connector.SshMessage': ConnectorSshMessage,
            'connector.StartStream': ConnectorStartStream,
            'connector.StartStreamFromDevice': ConnectorStartStreamFromDevice,
            'connector.StreamAcknowledge': ConnectorStreamAcknowledge,
            'connector.StreamInput': ConnectorStreamInput,
            'connector.StreamKeepalive': ConnectorStreamKeepalive,
            'connector.StreamMessage': ConnectorStreamMessage,
            'connector.TargetChangeMessage': ConnectorTargetChangeMessage,
            'connector.TargetSpecification': ConnectorTargetSpecification,
            'connector.Url': ConnectorUrl,
            'connector.WinrmRequest': ConnectorWinrmRequest,
            'connector.XmlApiMessage': ConnectorXmlApiMessage,
            'connectorpack.ConnectorPackUpdate': ConnectorpackConnectorPackUpdate,
            'content.BaseParameter': ContentBaseParameter,
            'content.ComplexType': ContentComplexType,
            'content.Parameter': ContentParameter,
            'content.TextParameter': ContentTextParameter,
            'convergedinfra.AlarmSummary': ConvergedinfraAlarmSummary,
            'convergedinfra.BasePodSummary': ConvergedinfraBasePodSummary,
            'convergedinfra.ComplianceSummary': ConvergedinfraComplianceSummary,
            'convergedinfra.PodSummary': ConvergedinfraPodSummary,
            'crd.CustomResourceConfigProperty': CrdCustomResourceConfigProperty,
            'equipment.ChassisOperationStatus': EquipmentChassisOperationStatus,
            'equipment.DeviceLocation': EquipmentDeviceLocation,
            'equipment.IoCardIdentity': EquipmentIoCardIdentity,
            'equipment.IoCardOperationStatus': EquipmentIoCardOperationStatus,
            'equipment.ResetAction': EquipmentResetAction,
            'ether.MacsecOperData': EtherMacsecOperData,
            'fabric.ClusterAssignment': FabricClusterAssignment,
            'fabric.FcZoneMember': FabricFcZoneMember,
            'fabric.LldpSettings': FabricLldpSettings,
            'fabric.MacAgingSettings': FabricMacAgingSettings,
            'fabric.MacSecEaPol': FabricMacSecEaPol,
            'fabric.PortIdentifier': FabricPortIdentifier,
            'fabric.QosClass': FabricQosClass,
            'fabric.SecKey': FabricSecKey,
            'fabric.SecKeyChain': FabricSecKeyChain,
            'fabric.UdldGlobalSettings': FabricUdldGlobalSettings,
            'fabric.UdldSettings': FabricUdldSettings,
            'fabric.VlanSettings': FabricVlanSettings,
            'fcpool.Block': FcpoolBlock,
            'fcpool.ReservationReference': FcpoolReservationReference,
            'feedback.FeedbackData': FeedbackFeedbackData,
            'firmware.BaseImpact': FirmwareBaseImpact,
            'firmware.ChassisUpgradeImpact': FirmwareChassisUpgradeImpact,
            'firmware.CifsServer': FirmwareCifsServer,
            'firmware.ComponentImpact': FirmwareComponentImpact,
            'firmware.ComponentMeta': FirmwareComponentMeta,
            'firmware.DirectDownload': FirmwareDirectDownload,
            'firmware.ExcludeComponentPidListType': FirmwareExcludeComponentPidListType,
            'firmware.FabricUpgradeImpact': FirmwareFabricUpgradeImpact,
            'firmware.FeatureVersionMap': FirmwareFeatureVersionMap,
            'firmware.FirmwareInventory': FirmwareFirmwareInventory,
            'firmware.HttpServer': FirmwareHttpServer,
            'firmware.ModelBundleVersion': FirmwareModelBundleVersion,
            'firmware.NetworkShare': FirmwareNetworkShare,
            'firmware.NfsServer': FirmwareNfsServer,
            'firmware.ServerUpgradeImpact': FirmwareServerUpgradeImpact,
            'firmware.VersionMap': FirmwareVersionMap,
            'forecast.Model': ForecastModel,
            'hci.AhvGuestTools': HciAhvGuestTools,
            'hci.AlarmParameter': HciAlarmParameter,
            'hci.AlarmSummary': HciAlarmSummary,
            'hci.ApiLimit': HciApiLimit,
            'hci.BackplaneNetworkParams': HciBackplaneNetworkParams,
            'hci.CapacityViolation': HciCapacityViolation,
            'hci.Consumption': HciConsumption,
            'hci.EntitlementDetail': HciEntitlementDetail,
            'hci.EsxiGuestTools': HciEsxiGuestTools,
            'hci.ExpiredLicense': HciExpiredLicense,
            'hci.FaultToleranceState': HciFaultToleranceState,
            'hci.FeatureViolation': HciFeatureViolation,
            'hci.IpAddress': HciIpAddress,
            'hci.IpAddressOrFqdn': HciIpAddressOrFqdn,
            'hci.KeyManagementDeviceToCertStatusInfo': HciKeyManagementDeviceToCertStatusInfo,
            'hci.LicensedService': HciLicensedService,
            'hci.ManagementServer': HciManagementServer,
            'hci.PulseStatus': HciPulseStatus,
            'hci.Sbdf': HciSbdf,
            'hci.ServiceViolation': HciServiceViolation,
            'hci.SoftwareType': HciSoftwareType,
            'hci.VirtualGpuConfig': HciVirtualGpuConfig,
            'hcl.Constraint': HclConstraint,
            'hcl.Firmware': HclFirmware,
            'hcl.HardwareCompatibilityProfile': HclHardwareCompatibilityProfile,
            'hcl.Product': HclProduct,
            'hyperflex.AbstractAppSetting': HyperflexAbstractAppSetting,
            'hyperflex.AlarmSummary': HyperflexAlarmSummary,
            'hyperflex.AppSettingConstraint': HyperflexAppSettingConstraint,
            'hyperflex.BackupPolicySettings': HyperflexBackupPolicySettings,
            'hyperflex.Capability': HyperflexCapability,
            'hyperflex.DatastoreInfo': HyperflexDatastoreInfo,
            'hyperflex.EntityReference': HyperflexEntityReference,
            'hyperflex.ErrorStack': HyperflexErrorStack,
            'hyperflex.FeatureLimitEntry': HyperflexFeatureLimitEntry,
            'hyperflex.FilePath': HyperflexFilePath,
            'hyperflex.HealthCheckNodeLevelInfo': HyperflexHealthCheckNodeLevelInfo,
            'hyperflex.HealthCheckScriptInfo': HyperflexHealthCheckScriptInfo,
            'hyperflex.HxHostMountStatusDt': HyperflexHxHostMountStatusDt,
            'hyperflex.HxLicenseAuthorizationDetailsDt': HyperflexHxLicenseAuthorizationDetailsDt,
            'hyperflex.HxLinkDt': HyperflexHxLinkDt,
            'hyperflex.HxNetworkAddressDt': HyperflexHxNetworkAddressDt,
            'hyperflex.HxPlatformDatastoreConfigDt': HyperflexHxPlatformDatastoreConfigDt,
            'hyperflex.HxRegistrationDetailsDt': HyperflexHxRegistrationDetailsDt,
            'hyperflex.HxResiliencyInfoDt': HyperflexHxResiliencyInfoDt,
            'hyperflex.HxSiteDt': HyperflexHxSiteDt,
            'hyperflex.HxUuIdDt': HyperflexHxUuIdDt,
            'hyperflex.HxZoneInfoDt': HyperflexHxZoneInfoDt,
            'hyperflex.HxZoneResiliencyInfoDt': HyperflexHxZoneResiliencyInfoDt,
            'hyperflex.IpAddrRange': HyperflexIpAddrRange,
            'hyperflex.LogicalAvailabilityZone': HyperflexLogicalAvailabilityZone,
            'hyperflex.MacAddrPrefixRange': HyperflexMacAddrPrefixRange,
            'hyperflex.MapClusterIdToProtectionInfo': HyperflexMapClusterIdToProtectionInfo,
            'hyperflex.MapClusterIdToStSnapshotPoint': HyperflexMapClusterIdToStSnapshotPoint,
            'hyperflex.MapUuidToTrackedDisk': HyperflexMapUuidToTrackedDisk,
            'hyperflex.NamedVlan': HyperflexNamedVlan,
            'hyperflex.NamedVsan': HyperflexNamedVsan,
            'hyperflex.NetworkConfiguration': HyperflexNetworkConfiguration,
            'hyperflex.PortTypeToPortNumberMap': HyperflexPortTypeToPortNumberMap,
            'hyperflex.ProtectionInfo': HyperflexProtectionInfo,
            'hyperflex.ReSyncClusterMoIds': HyperflexReSyncClusterMoIds,
            'hyperflex.ReplicationClusterReferenceToSchedule': HyperflexReplicationClusterReferenceToSchedule,
            'hyperflex.ReplicationPeerInfo': HyperflexReplicationPeerInfo,
            'hyperflex.ReplicationPlatDatastore': HyperflexReplicationPlatDatastore,
            'hyperflex.ReplicationPlatDatastorePair': HyperflexReplicationPlatDatastorePair,
            'hyperflex.ReplicationSchedule': HyperflexReplicationSchedule,
            'hyperflex.ReplicationStatus': HyperflexReplicationStatus,
            'hyperflex.RpoStatus': HyperflexRpoStatus,
            'hyperflex.ServerFirmwareVersionInfo': HyperflexServerFirmwareVersionInfo,
            'hyperflex.ServerModelEntry': HyperflexServerModelEntry,
            'hyperflex.SiteDetails': HyperflexSiteDetails,
            'hyperflex.SnapshotFiles': HyperflexSnapshotFiles,
            'hyperflex.SnapshotInfoBrief': HyperflexSnapshotInfoBrief,
            'hyperflex.SnapshotPoint': HyperflexSnapshotPoint,
            'hyperflex.SnapshotStatus': HyperflexSnapshotStatus,
            'hyperflex.StPlatformClusterHealingInfo': HyperflexStPlatformClusterHealingInfo,
            'hyperflex.StPlatformClusterResiliencyInfo': HyperflexStPlatformClusterResiliencyInfo,
            'hyperflex.Summary': HyperflexSummary,
            'hyperflex.TrackedDisk': HyperflexTrackedDisk,
            'hyperflex.TrackedFile': HyperflexTrackedFile,
            'hyperflex.VcenterConfiguration': HyperflexVcenterConfiguration,
            'hyperflex.VirtualMachine': HyperflexVirtualMachine,
            'hyperflex.VirtualMachineRuntimeInfo': HyperflexVirtualMachineRuntimeInfo,
            'hyperflex.VmProtectionSpaceUsage': HyperflexVmProtectionSpaceUsage,
            'hyperflex.WwxnPrefixRange': HyperflexWwxnPrefixRange,
            'i18n.Message': I18nMessage,
            'i18n.MessageParam': I18nMessageParam,
            'iaas.LicenseKeysInfo': IaasLicenseKeysInfo,
            'iaas.LicenseUtilizationInfo': IaasLicenseUtilizationInfo,
            'iaas.WorkflowSteps': IaasWorkflowSteps,
            'iam.AccountPermissions': IamAccountPermissions,
            'iam.AccountTags': IamAccountTags,
            'iam.AppCredentials': IamAppCredentials,
            'iam.BasicAuthCredentials': IamBasicAuthCredentials,
            'iam.ClientMeta': IamClientMeta,
            'iam.EndPointPasswordProperties': IamEndPointPasswordProperties,
            'iam.FailureDetails': IamFailureDetails,
            'iam.FeatureDefinition': IamFeatureDefinition,
            'iam.GroupPermissionToRoles': IamGroupPermissionToRoles,
            'iam.LdapBaseProperties': IamLdapBaseProperties,
            'iam.LdapDnsParameters': IamLdapDnsParameters,
            'iam.PermissionReference': IamPermissionReference,
            'iam.PermissionToRoles': IamPermissionToRoles,
            'iam.ResourceRole': IamResourceRole,
            'iam.Rule': IamRule,
            'iam.SamlSpConnection': IamSamlSpConnection,
            'iam.SecurityContext': IamSecurityContext,
            'iam.SsoSessionAttributes': IamSsoSessionAttributes,
            'iam.SwitchAccountPermission': IamSwitchAccountPermission,
            'iam.SwitchScopePermissions': IamSwitchScopePermissions,
            'iam.UserDetails': IamUserDetails,
            'imcconnector.WebUiMessage': ImcconnectorWebUiMessage,
            'infra.BaseGpuConfiguration': InfraBaseGpuConfiguration,
            'infra.BasePciConfiguration': InfraBasePciConfiguration,
            'infra.GpuConfiguration': InfraGpuConfiguration,
            'infra.HardwareInfo': InfraHardwareInfo,
            'infra.MetaData': InfraMetaData,
            'infra.MigGpuConfiguration': InfraMigGpuConfiguration,
            'inventory.InventoryMo': InventoryInventoryMo,
            'inventory.JobInfo': InventoryJobInfo,
            'inventory.UemInfo': InventoryUemInfo,
            'ippool.IpV4Block': IppoolIpV4Block,
            'ippool.IpV4Config': IppoolIpV4Config,
            'ippool.IpV6Block': IppoolIpV6Block,
            'ippool.IpV6Config': IppoolIpV6Config,
            'ippool.ReservationReference': IppoolReservationReference,
            'iqnpool.IqnSuffixBlock': IqnpoolIqnSuffixBlock,
            'iqnpool.ReservationReference': IqnpoolReservationReference,
            'issue.Condition': IssueCondition,
            'issue.DeviceTag': IssueDeviceTag,
            'issue.Message': IssueMessage,
            'issue.OdataCondition': IssueOdataCondition,
            'kubernetes.ActionInfo': KubernetesActionInfo,
            'kubernetes.Addon': KubernetesAddon,
            'kubernetes.AddonConfiguration': KubernetesAddonConfiguration,
            'kubernetes.AddonVersionReference': KubernetesAddonVersionReference,
            'kubernetes.BaremetalNetworkInfo': KubernetesBaremetalNetworkInfo,
            'kubernetes.BaseVirtualMachineInfraConfig': KubernetesBaseVirtualMachineInfraConfig,
            'kubernetes.CalicoConfig': KubernetesCalicoConfig,
            'kubernetes.ClusterCertificateConfiguration': KubernetesClusterCertificateConfiguration,
            'kubernetes.ClusterManagementConfig': KubernetesClusterManagementConfig,
            'kubernetes.CniConfig': KubernetesCniConfig,
            'kubernetes.Configuration': KubernetesConfiguration,
            'kubernetes.DaemonSetStatus': KubernetesDaemonSetStatus,
            'kubernetes.DeploymentStatus': KubernetesDeploymentStatus,
            'kubernetes.EssentialAddon': KubernetesEssentialAddon,
            'kubernetes.EsxiVirtualMachineInfraConfig': KubernetesEsxiVirtualMachineInfraConfig,
            'kubernetes.Ethernet': KubernetesEthernet,
            'kubernetes.EthernetMatcher': KubernetesEthernetMatcher,
            'kubernetes.IngressStatus': KubernetesIngressStatus,
            'kubernetes.InstanceTypeDetails': KubernetesInstanceTypeDetails,
            'kubernetes.IpV4Config': KubernetesIpV4Config,
            'kubernetes.KeyValue': KubernetesKeyValue,
            'kubernetes.LoadBalancer': KubernetesLoadBalancer,
            'kubernetes.NetworkInterface': KubernetesNetworkInterface,
            'kubernetes.NetworkInterfaceSpec': KubernetesNetworkInterfaceSpec,
            'kubernetes.NodeAddress': KubernetesNodeAddress,
            'kubernetes.NodeGroupLabel': KubernetesNodeGroupLabel,
            'kubernetes.NodeGroupTaint': KubernetesNodeGroupTaint,
            'kubernetes.NodeInfo': KubernetesNodeInfo,
            'kubernetes.NodeSpec': KubernetesNodeSpec,
            'kubernetes.NodeStatus': KubernetesNodeStatus,
            'kubernetes.ObjectMeta': KubernetesObjectMeta,
            'kubernetes.OvsBond': KubernetesOvsBond,
            'kubernetes.PodStatus': KubernetesPodStatus,
            'kubernetes.ProxyConfig': KubernetesProxyConfig,
            'kubernetes.Route': KubernetesRoute,
            'kubernetes.ServiceStatus': KubernetesServiceStatus,
            'kubernetes.StatefulSetStatus': KubernetesStatefulSetStatus,
            'kubernetes.Taint': KubernetesTaint,
            'license.SubstituteLicense': LicenseSubstituteLicense,
            'macpool.Block': MacpoolBlock,
            'macpool.MemberOf': MacpoolMemberOf,
            'macpool.ReservationReference': MacpoolReservationReference,
            'marketplace.UseCaseAutomation': MarketplaceUseCaseAutomation,
            'marketplace.UseCaseDependency': MarketplaceUseCaseDependency,
            'marketplace.UseCaseLocale': MarketplaceUseCaseLocale,
            'marketplace.UseCaseVersionLocale': MarketplaceUseCaseVersionLocale,
            'marketplace.UseCaseVersionResource': MarketplaceUseCaseVersionResource,
            'memory.PersistentMemoryGoal': MemoryPersistentMemoryGoal,
            'memory.PersistentMemoryLocalSecurity': MemoryPersistentMemoryLocalSecurity,
            'memory.PersistentMemoryLogicalNamespace': MemoryPersistentMemoryLogicalNamespace,
            'meta.AccessPrivilege': MetaAccessPrivilege,
            'meta.DisplayNameDefinition': MetaDisplayNameDefinition,
            'meta.IdentityDefinition': MetaIdentityDefinition,
            'meta.PropDefinition': MetaPropDefinition,
            'meta.RelationshipDefinition': MetaRelationshipDefinition,
            'metrics.MetricCriterion': MetricsMetricCriterion,
            'mo.VersionContext': MoVersionContext,
            'monitoring.CategoryStatus': MonitoringCategoryStatus,
            'motemplate.ActionEntry': MotemplateActionEntry,
            'motemplate.ActionParam': MotemplateActionParam,
            'motemplate.SyncError': MotemplateSyncError,
            'network.HyperFlexInternetProtocolAddressRange': NetworkHyperFlexInternetProtocolAddressRange,
            'network.HyperFlexNetworkAddress': NetworkHyperFlexNetworkAddress,
            'niaapi.Detail': NiaapiDetail,
            'niaapi.NewReleaseDetail': NiaapiNewReleaseDetail,
            'niaapi.RevisionInfo': NiaapiRevisionInfo,
            'niaapi.SoftwareRegex': NiaapiSoftwareRegex,
            'niaapi.VersionRegexPlatform': NiaapiVersionRegexPlatform,
            'niatelemetry.BootflashDetails': NiatelemetryBootflashDetails,
            'niatelemetry.CloudRegionsElement': NiatelemetryCloudRegionsElement,
            'niatelemetry.CloudRoutersElement': NiatelemetryCloudRoutersElement,
            'niatelemetry.DeploymentStatus': NiatelemetryDeploymentStatus,
            'niatelemetry.DigitalOpticalMonitoring': NiatelemetryDigitalOpticalMonitoring,
            'niatelemetry.Diskinfo': NiatelemetryDiskinfo,
            'niatelemetry.DomInfo': NiatelemetryDomInfo,
            'niatelemetry.DomThresInfo': NiatelemetryDomThresInfo,
            'niatelemetry.EqptStorageFirmware': NiatelemetryEqptStorageFirmware,
            'niatelemetry.EqptcapacityPolUsage5min': NiatelemetryEqptcapacityPolUsage5min,
            'niatelemetry.EqptcapacityPrefixEntries15min': NiatelemetryEqptcapacityPrefixEntries15min,
            'niatelemetry.EqptcapacityPrefixEntries5min': NiatelemetryEqptcapacityPrefixEntries5min,
            'niatelemetry.FanDetails': NiatelemetryFanDetails,
            'niatelemetry.ImageDetail': NiatelemetryImageDetail,
            'niatelemetry.Interface': NiatelemetryInterface,
            'niatelemetry.InterfaceElement': NiatelemetryInterfaceElement,
            'niatelemetry.JobDetail': NiatelemetryJobDetail,
            'niatelemetry.LogicalLink': NiatelemetryLogicalLink,
            'niatelemetry.MdsNeighborInfo': NiatelemetryMdsNeighborInfo,
            'niatelemetry.NetworkInfo': NiatelemetryNetworkInfo,
            'niatelemetry.Node': NiatelemetryNode,
            'niatelemetry.NvePacketCounters': NiatelemetryNvePacketCounters,
            'niatelemetry.NveVni': NiatelemetryNveVni,
            'niatelemetry.NxosBgpEvpn': NiatelemetryNxosBgpEvpn,
            'niatelemetry.NxosBgpMvpn': NiatelemetryNxosBgpMvpn,
            'niatelemetry.NxosVtp': NiatelemetryNxosVtp,
            'niatelemetry.ProcSysCpu15min': NiatelemetryProcSysCpu15min,
            'niatelemetry.ProcSysCpu5min': NiatelemetryProcSysCpu5min,
            'niatelemetry.ProcSysMem15min': NiatelemetryProcSysMem15min,
            'niatelemetry.ProcSysMem5min': NiatelemetryProcSysMem5min,
            'niatelemetry.Sites': NiatelemetrySites,
            'niatelemetry.SmartLicense': NiatelemetrySmartLicense,
            'niatelemetry.SwitchDiskUtilization': NiatelemetrySwitchDiskUtilization,
            'niatelemetry.VniStatus': NiatelemetryVniStatus,
            'niatelemetry.VpcDetails': NiatelemetryVpcDetails,
            'notification.AbstractCondition': NotificationAbstractCondition,
            'notification.AbstractMoCondition': NotificationAbstractMoCondition,
            'notification.Action': NotificationAction,
            'notification.AggregationSettings': NotificationAggregationSettings,
            'notification.AlarmMoCondition': NotificationAlarmMoCondition,
            'notification.ApplianceUpgradeMoCondition': NotificationApplianceUpgradeMoCondition,
            'notification.DistributableMoCondition': NotificationDistributableMoCondition,
            'notification.MoCondition': NotificationMoCondition,
            'notification.SendEmail': NotificationSendEmail,
            'notification.SimpleFilter': NotificationSimpleFilter,
            'notification.SimpleMoCondition': NotificationSimpleMoCondition,
            'notification.SoftwareReleaseMetaMoCondition': NotificationSoftwareReleaseMetaMoCondition,
            'notification.TriggerWebhook': NotificationTriggerWebhook,
            'ntp.AuthNtpServer': NtpAuthNtpServer,
            'onprem.ClusterInfo': OnpremClusterInfo,
            'onprem.ClusterNode': OnpremClusterNode,
            'onprem.ImagePackage': OnpremImagePackage,
            'onprem.ResourceInfo': OnpremResourceInfo,
            'onprem.Schedule': OnpremSchedule,
            'onprem.UpgradeNote': OnpremUpgradeNote,
            'onprem.UpgradePhase': OnpremUpgradePhase,
            'openapi.ApiInfo': OpenapiApiInfo,
            'openapi.FailedTask': OpenapiFailedTask,
            'openapi.KeyValuePair': OpenapiKeyValuePair,
            'oprs.Kvpair': OprsKvpair,
            'os.Answers': OsAnswers,
            'os.FibreChannelResponse': OsFibreChannelResponse,
            'os.FibreChannelTarget': OsFibreChannelTarget,
            'os.GlobalConfig': OsGlobalConfig,
            'os.InstallTarget': OsInstallTarget,
            'os.InstallTargetResponse': OsInstallTargetResponse,
            'os.IpConfiguration': OsIpConfiguration,
            'os.Ipv4Configuration': OsIpv4Configuration,
            'os.Ipv6Configuration': OsIpv6Configuration,
            'os.IscsiLunResponse': OsIscsiLunResponse,
            'os.IscsiTarget': OsIscsiTarget,
            'os.OperatingSystemParameters': OsOperatingSystemParameters,
            'os.PhysicalDisk': OsPhysicalDisk,
            'os.PhysicalDiskResponse': OsPhysicalDiskResponse,
            'os.PlaceHolder': OsPlaceHolder,
            'os.RemoteTargetResponse': OsRemoteTargetResponse,
            'os.SanTarget': OsSanTarget,
            'os.ServerConfig': OsServerConfig,
            'os.ValidationInformation': OsValidationInformation,
            'os.VirtualDrive': OsVirtualDrive,
            'os.VirtualDriveResponse': OsVirtualDriveResponse,
            'os.VmwareParameters': OsVmwareParameters,
            'os.WindowsParameters': OsWindowsParameters,
            'partnerintegration.MetricsModel': PartnerintegrationMetricsModel,
            'pkix.DistinguishedName': PkixDistinguishedName,
            'pkix.EcdsaKeySpec': PkixEcdsaKeySpec,
            'pkix.EddsaKeySpec': PkixEddsaKeySpec,
            'pkix.KeyGenerationSpec': PkixKeyGenerationSpec,
            'pkix.RsaAlgorithm': PkixRsaAlgorithm,
            'pkix.SubjectAlternateName': PkixSubjectAlternateName,
            'policy.ActionParam': PolicyActionParam,
            'policy.ActionQualifier': PolicyActionQualifier,
            'policy.ConfigChange': PolicyConfigChange,
            'policy.ConfigChangeContext': PolicyConfigChangeContext,
            'policy.ConfigChangeDisruptionDetailType': PolicyConfigChangeDisruptionDetailType,
            'policy.ConfigContext': PolicyConfigContext,
            'policy.ConfigResultContext': PolicyConfigResultContext,
            'policy.PolicyError': PolicyPolicyError,
            'policy.PolicyStatus': PolicyPolicyStatus,
            'policy.Qualifier': PolicyQualifier,
            'policy.ScheduledAction': PolicyScheduledAction,
            'pool.AbstractBlockType': PoolAbstractBlockType,
            'pool.ReservationReference': PoolReservationReference,
            'recovery.BackupSchedule': RecoveryBackupSchedule,
            'recovery.ConfigParams': RecoveryConfigParams,
            'resource.AdaptorsRangeFilter': ResourceAdaptorsRangeFilter,
            'resource.AdvancedFilter': ResourceAdvancedFilter,
            'resource.BladeQualifier': ResourceBladeQualifier,
            'resource.ChassisAndSlotQualification': ResourceChassisAndSlotQualification,
            'resource.ChassisIdRangeFilter': ResourceChassisIdRangeFilter,
            'resource.ChassisServersQualifier': ResourceChassisServersQualifier,
            'resource.CpuCoreRangeFilter': ResourceCpuCoreRangeFilter,
            'resource.CpuSpeedRangeFilter': ResourceCpuSpeedRangeFilter,
            'resource.DomainQualifier': ResourceDomainQualifier,
            'resource.GpuControllersRangeFilter': ResourceGpuControllersRangeFilter,
            'resource.GpuQualifier': ResourceGpuQualifier,
            'resource.HardwareQualifier': ResourceHardwareQualifier,
            'resource.MemoryCapacityRangeFilter': ResourceMemoryCapacityRangeFilter,
            'resource.MemoryQualifier': ResourceMemoryQualifier,
            'resource.MemoryUnitsRangeFilter': ResourceMemoryUnitsRangeFilter,
            'resource.NetworkAdaptorQualifier': ResourceNetworkAdaptorQualifier,
            'resource.OdataRuleSetQualifier': ResourceOdataRuleSetQualifier,
            'resource.PerTypeCombinedSelector': ResourcePerTypeCombinedSelector,
            'resource.ProcessorQualifier': ResourceProcessorQualifier,
            'resource.RackIdRangeFilter': ResourceRackIdRangeFilter,
            'resource.RackServerQualifier': ResourceRackServerQualifier,
            'resource.RangeFilter': ResourceRangeFilter,
            'resource.ResourceQualifier': ResourceResourceQualifier,
            'resource.RuleSetQualifier': ResourceRuleSetQualifier,
            'resource.Selector': ResourceSelector,
            'resource.ServerQualifier': ResourceServerQualifier,
            'resource.SlotIdRangeFilter': ResourceSlotIdRangeFilter,
            'resource.SourceToPermissionResources': ResourceSourceToPermissionResources,
            'resource.SourceToPermissionResourcesHolder': ResourceSourceToPermissionResourcesHolder,
            'resource.Tag': ResourceTag,
            'resource.TagQualifier': ResourceTagQualifier,
            'resourcepool.ChildLeaseCondition': ResourcepoolChildLeaseCondition,
            'resourcepool.LeaseParameters': ResourcepoolLeaseParameters,
            'resourcepool.QualificationType': ResourcepoolQualificationType,
            'resourcepool.ResourceEvaluationStatus': ResourcepoolResourceEvaluationStatus,
            'resourcepool.ResourcePoolParameters': ResourcepoolResourcePoolParameters,
            'resourcepool.ServerLeaseParameters': ResourcepoolServerLeaseParameters,
            'resourcepool.ServerPoolParameters': ResourcepoolServerPoolParameters,
            'scheduler.AbstractSchedulingParams': SchedulerAbstractSchedulingParams,
            'scheduler.AbstractTaskRequest': SchedulerAbstractTaskRequest,
            'scheduler.BaseCadenceParams': SchedulerBaseCadenceParams,
            'scheduler.BaseMonthlyCadenceParams': SchedulerBaseMonthlyCadenceParams,
            'scheduler.BaseScheduleParams': SchedulerBaseScheduleParams,
            'scheduler.BlockDate': SchedulerBlockDate,
            'scheduler.DailyCadenceParams': SchedulerDailyCadenceParams,
            'scheduler.EveryCadenceParams': SchedulerEveryCadenceParams,
            'scheduler.MonthlyCadenceParams': SchedulerMonthlyCadenceParams,
            'scheduler.OneTimeScheduleParams': SchedulerOneTimeScheduleParams,
            'scheduler.RecurringScheduleParams': SchedulerRecurringScheduleParams,
            'scheduler.RestStimTaskRequest': SchedulerRestStimTaskRequest,
            'scheduler.TaskResultStatus': SchedulerTaskResultStatus,
            'scheduler.TaskSchedulePolicyExecutionStatus': SchedulerTaskSchedulePolicyExecutionStatus,
            'scheduler.TaskScheduleStatus': SchedulerTaskScheduleStatus,
            'scheduler.WeeklyCadenceParams': SchedulerWeeklyCadenceParams,
            'sdcard.Diagnostics': SdcardDiagnostics,
            'sdcard.Drivers': SdcardDrivers,
            'sdcard.HostUpgradeUtility': SdcardHostUpgradeUtility,
            'sdcard.OperatingSystem': SdcardOperatingSystem,
            'sdcard.Partition': SdcardPartition,
            'sdcard.ServerConfigurationUtility': SdcardServerConfigurationUtility,
            'sdcard.UserPartition': SdcardUserPartition,
            'sdcard.VirtualDrive': SdcardVirtualDrive,
            'server.PendingWorkflowTrigger': ServerPendingWorkflowTrigger,
            'server.ServerAssignTypeSlot': ServerServerAssignTypeSlot,
            'serviceitem.BaseMessage': ServiceitemBaseMessage,
            'serviceitem.HealthCheckErrorElement': ServiceitemHealthCheckErrorElement,
            'serviceitem.Message': ServiceitemMessage,
            'serviceitem.SelectionCriteriaInput': ServiceitemSelectionCriteriaInput,
            'servicerequest.Message': ServicerequestMessage,
            'snmp.Trap': SnmpTrap,
            'snmp.User': SnmpUser,
            'softwarerepository.ApplianceUpload': SoftwarerepositoryApplianceUpload,
            'softwarerepository.CifsServer': SoftwarerepositoryCifsServer,
            'softwarerepository.ConstraintModels': SoftwarerepositoryConstraintModels,
            'softwarerepository.FileServer': SoftwarerepositoryFileServer,
            'softwarerepository.HttpServer': SoftwarerepositoryHttpServer,
            'softwarerepository.ImportResult': SoftwarerepositoryImportResult,
            'softwarerepository.LocalMachine': SoftwarerepositoryLocalMachine,
            'softwarerepository.NfsServer': SoftwarerepositoryNfsServer,
            'softwarerepository.UnsupportedModelConstraint': SoftwarerepositoryUnsupportedModelConstraint,
            'storage.AutomaticDriveGroup': StorageAutomaticDriveGroup,
            'storage.BaseCapacity': StorageBaseCapacity,
            'storage.BaseInitiator': StorageBaseInitiator,
            'storage.BasePerformanceMetricsAverage': StorageBasePerformanceMetricsAverage,
            'storage.BaseReplicationBlackout': StorageBaseReplicationBlackout,
            'storage.ExternalLun': StorageExternalLun,
            'storage.ExternalParityGroup': StorageExternalParityGroup,
            'storage.ExternalPath': StorageExternalPath,
            'storage.HitachiArrayUtilization': StorageHitachiArrayUtilization,
            'storage.HitachiCapacity': StorageHitachiCapacity,
            'storage.HitachiInitiator': StorageHitachiInitiator,
            'storage.HostNqn': StorageHostNqn,
            'storage.HyperFlexIscsiInitiator': StorageHyperFlexIscsiInitiator,
            'storage.Initiator': StorageInitiator,
            'storage.InternalMoPhysicalDiskConfig': StorageInternalMoPhysicalDiskConfig,
            'storage.KeySetting': StorageKeySetting,
            'storage.KmipAuthCredentials': StorageKmipAuthCredentials,
            'storage.KmipServer': StorageKmipServer,
            'storage.LocalKeySetting': StorageLocalKeySetting,
            'storage.M2VirtualDriveConfig': StorageM2VirtualDriveConfig,
            'storage.ManualDriveGroup': StorageManualDriveGroup,
            'storage.Namespace': StorageNamespace,
            'storage.NamespacePath': StorageNamespacePath,
            'storage.NetAppAutoSupport': StorageNetAppAutoSupport,
            'storage.NetAppCifsAcl': StorageNetAppCifsAcl,
            'storage.NetAppEthernetPortLag': StorageNetAppEthernetPortLag,
            'storage.NetAppEthernetPortVlan': StorageNetAppEthernetPortVlan,
            'storage.NetAppExportPolicyRule': StorageNetAppExportPolicyRule,
            'storage.NetAppHighAvailability': StorageNetAppHighAvailability,
            'storage.NetAppPerformanceMetricsAverage': StorageNetAppPerformanceMetricsAverage,
            'storage.NetAppPort': StorageNetAppPort,
            'storage.NetAppSnapshotPolicySchedule': StorageNetAppSnapshotPolicySchedule,
            'storage.NetAppStorageClusterEfficiency': StorageNetAppStorageClusterEfficiency,
            'storage.NetAppStorageUtilization': StorageNetAppStorageUtilization,
            'storage.NvmeDedicatedHotSpareConfiguration': StorageNvmeDedicatedHotSpareConfiguration,
            'storage.NvmePhysicalDiskState': StorageNvmePhysicalDiskState,
            'storage.NvmeRaidDriveGroup': StorageNvmeRaidDriveGroup,
            'storage.NvmeVirtualDriveConfiguration': StorageNvmeVirtualDriveConfiguration,
            'storage.PureArrayUtilization': StoragePureArrayUtilization,
            'storage.PureDiskUtilization': StoragePureDiskUtilization,
            'storage.PureHostUtilization': StoragePureHostUtilization,
            'storage.PureReplicationBlackout': StoragePureReplicationBlackout,
            'storage.PureVolumeUtilization': StoragePureVolumeUtilization,
            'storage.R0Drive': StorageR0Drive,
            'storage.RemoteKeySetting': StorageRemoteKeySetting,
            'storage.Space': StorageSpace,
            'storage.SpanDrives': StorageSpanDrives,
            'storage.StorageContainerHostMountStatus': StorageStorageContainerHostMountStatus,
            'storage.StorageContainerUtilization': StorageStorageContainerUtilization,
            'storage.StorageUtilization': StorageStorageUtilization,
            'storage.VirtualDriveConfiguration': StorageVirtualDriveConfiguration,
            'storage.VirtualDrivePolicy': StorageVirtualDrivePolicy,
            'storage.VolumeUtilization': StorageVolumeUtilization,
            'syslog.LocalClientBase': SyslogLocalClientBase,
            'syslog.LocalFileLoggingClient': SyslogLocalFileLoggingClient,
            'syslog.RemoteClientBase': SyslogRemoteClientBase,
            'syslog.RemoteLoggingClient': SyslogRemoteLoggingClient,
            'tam.Action': TamAction,
            'tam.ApiDataSource': TamApiDataSource,
            'tam.BaseAdvisoryDetails': TamBaseAdvisoryDetails,
            'tam.BaseDataSource': TamBaseDataSource,
            'tam.EolAdvisoryDetails': TamEolAdvisoryDetails,
            'tam.EolSeverity': TamEolSeverity,
            'tam.FnSeverity': TamFnSeverity,
            'tam.Identifiers': TamIdentifiers,
            'tam.Milestone': TamMilestone,
            'tam.PsirtSeverity': TamPsirtSeverity,
            'tam.QueryEntry': TamQueryEntry,
            'tam.S3DataSource': TamS3DataSource,
            'tam.SecurityAdvisoryDetails': TamSecurityAdvisoryDetails,
            'tam.Severity': TamSeverity,
            'tam.TextFsmTemplateDataSource': TamTextFsmTemplateDataSource,
            'task.FileDownloadInfo': TaskFileDownloadInfo,
            'techsupportmanagement.ApplianceParam': TechsupportmanagementApplianceParam,
            'techsupportmanagement.NiaParam': TechsupportmanagementNiaParam,
            'techsupportmanagement.PlatformParam': TechsupportmanagementPlatformParam,
            'techsupportmanagement.TechSupportFileInfo': TechsupportmanagementTechSupportFileInfo,
            'template.TransformationStage': TemplateTransformationStage,
            'ucsd.ConnectorPack': UcsdConnectorPack,
            'ucsd.UcsdRestoreParameters': UcsdUcsdRestoreParameters,
            'ucsdconnector.RestClientMessage': UcsdconnectorRestClientMessage,
            'uuidpool.ReservationReference': UuidpoolReservationReference,
            'uuidpool.UuidBlock': UuidpoolUuidBlock,
            'virtualization.ActionInfo': VirtualizationActionInfo,
            'virtualization.BaseCustomSpec': VirtualizationBaseCustomSpec,
            'virtualization.BaseHostConfiguration': VirtualizationBaseHostConfiguration,
            'virtualization.BaseVmConfiguration': VirtualizationBaseVmConfiguration,
            'virtualization.CloudInitConfig': VirtualizationCloudInitConfig,
            'virtualization.ComputeCapacity': VirtualizationComputeCapacity,
            'virtualization.CpuInfo': VirtualizationCpuInfo,
            'virtualization.EsxiCloneCustomSpec': VirtualizationEsxiCloneCustomSpec,
            'virtualization.EsxiHostConfiguration': VirtualizationEsxiHostConfiguration,
            'virtualization.EsxiOvaCustomSpec': VirtualizationEsxiOvaCustomSpec,
            'virtualization.EsxiVmComputeConfiguration': VirtualizationEsxiVmComputeConfiguration,
            'virtualization.EsxiVmConfiguration': VirtualizationEsxiVmConfiguration,
            'virtualization.EsxiVmNetworkConfiguration': VirtualizationEsxiVmNetworkConfiguration,
            'virtualization.EsxiVmStorageConfiguration': VirtualizationEsxiVmStorageConfiguration,
            'virtualization.GuestInfo': VirtualizationGuestInfo,
            'virtualization.MemoryCapacity': VirtualizationMemoryCapacity,
            'virtualization.NetworkInterface': VirtualizationNetworkInterface,
            'virtualization.ProductInfo': VirtualizationProductInfo,
            'virtualization.StorageCapacity': VirtualizationStorageCapacity,
            'virtualization.VirtualMachineDisk': VirtualizationVirtualMachineDisk,
            'virtualization.VmEsxiDisk': VirtualizationVmEsxiDisk,
            'virtualization.VmwareAttachedResourceTag': VirtualizationVmwareAttachedResourceTag,
            'virtualization.VmwareDiscoveryProtocol': VirtualizationVmwareDiscoveryProtocol,
            'virtualization.VmwareRemoteDisplayInfo': VirtualizationVmwareRemoteDisplayInfo,
            'virtualization.VmwareResourceAllocationSystemTrafficTypes': VirtualizationVmwareResourceAllocationSystemTrafficTypes,
            'virtualization.VmwareResourceConsumption': VirtualizationVmwareResourceConsumption,
            'virtualization.VmwareSharesInfo': VirtualizationVmwareSharesInfo,
            'virtualization.VmwareTeamingAndFailover': VirtualizationVmwareTeamingAndFailover,
            'virtualization.VmwareVlanRange': VirtualizationVmwareVlanRange,
            'virtualization.VmwareVmCpuShareInfo': VirtualizationVmwareVmCpuShareInfo,
            'virtualization.VmwareVmCpuSocketInfo': VirtualizationVmwareVmCpuSocketInfo,
            'virtualization.VmwareVmDiskCommitInfo': VirtualizationVmwareVmDiskCommitInfo,
            'virtualization.VmwareVmMemoryShareInfo': VirtualizationVmwareVmMemoryShareInfo,
            'vmedia.Mapping': VmediaMapping,
            'vnic.ArfsSettings': VnicArfsSettings,
            'vnic.Cdn': VnicCdn,
            'vnic.CompletionQueueSettings': VnicCompletionQueueSettings,
            'vnic.EthIfOldInfo': VnicEthIfOldInfo,
            'vnic.EthInterruptSettings': VnicEthInterruptSettings,
            'vnic.EthRxQueueSettings': VnicEthRxQueueSettings,
            'vnic.EthTxQueueSettings': VnicEthTxQueueSettings,
            'vnic.FcErrorRecoverySettings': VnicFcErrorRecoverySettings,
            'vnic.FcIfOldInfo': VnicFcIfOldInfo,
            'vnic.FcInterruptSettings': VnicFcInterruptSettings,
            'vnic.FcQueueSettings': VnicFcQueueSettings,
            'vnic.FlogiSettings': VnicFlogiSettings,
            'vnic.IscsiAuthProfile': VnicIscsiAuthProfile,
            'vnic.Lun': VnicLun,
            'vnic.NvgreSettings': VnicNvgreSettings,
            'vnic.PlacementSettings': VnicPlacementSettings,
            'vnic.PlogiSettings': VnicPlogiSettings,
            'vnic.PtpSettings': VnicPtpSettings,
            'vnic.RoceSettings': VnicRoceSettings,
            'vnic.RssHashSettings': VnicRssHashSettings,
            'vnic.SanSettingsOldInfo': VnicSanSettingsOldInfo,
            'vnic.ScsiQueueSettings': VnicScsiQueueSettings,
            'vnic.SriovSettings': VnicSriovSettings,
            'vnic.TcpOffloadSettings': VnicTcpOffloadSettings,
            'vnic.UsnicSettings': VnicUsnicSettings,
            'vnic.VifStatus': VnicVifStatus,
            'vnic.VlanSettings': VnicVlanSettings,
            'vnic.VmqSettings': VnicVmqSettings,
            'vnic.VsanSettings': VnicVsanSettings,
            'vnic.VxlanSettings': VnicVxlanSettings,
            'workflow.AbstractLoopTask': WorkflowAbstractLoopTask,
            'workflow.AbstractResourceSelector': WorkflowAbstractResourceSelector,
            'workflow.AbstractWorkerTask': WorkflowAbstractWorkerTask,
            'workflow.AnsiblePlaySession': WorkflowAnsiblePlaySession,
            'workflow.Api': WorkflowApi,
            'workflow.ArrayDataType': WorkflowArrayDataType,
            'workflow.ArrayItem': WorkflowArrayItem,
            'workflow.AssociatedRoles': WorkflowAssociatedRoles,
            'workflow.BaseDataType': WorkflowBaseDataType,
            'workflow.BaseOperation': WorkflowBaseOperation,
            'workflow.BaseServiceItemActionProperty': WorkflowBaseServiceItemActionProperty,
            'workflow.CancelableType': WorkflowCancelableType,
            'workflow.CliCommand': WorkflowCliCommand,
            'workflow.Comments': WorkflowComments,
            'workflow.Constraints': WorkflowConstraints,
            'workflow.ControlTask': WorkflowControlTask,
            'workflow.CustomArrayItem': WorkflowCustomArrayItem,
            'workflow.CustomDataProperty': WorkflowCustomDataProperty,
            'workflow.CustomDataType': WorkflowCustomDataType,
            'workflow.CustomDataTypeProperties': WorkflowCustomDataTypeProperties,
            'workflow.DataSourceSelector': WorkflowDataSourceSelector,
            'workflow.DecisionCase': WorkflowDecisionCase,
            'workflow.DecisionTask': WorkflowDecisionTask,
            'workflow.DefaultValue': WorkflowDefaultValue,
            'workflow.DisplayMeta': WorkflowDisplayMeta,
            'workflow.DynamicTemplateParserDataType': WorkflowDynamicTemplateParserDataType,
            'workflow.EndTask': WorkflowEndTask,
            'workflow.EnumEntry': WorkflowEnumEntry,
            'workflow.EnvironmentVariableReference': WorkflowEnvironmentVariableReference,
            'workflow.ExpectPrompt': WorkflowExpectPrompt,
            'workflow.FailureEndTask': WorkflowFailureEndTask,
            'workflow.FileDownloadOp': WorkflowFileDownloadOp,
            'workflow.FileOperations': WorkflowFileOperations,
            'workflow.FileTemplateOp': WorkflowFileTemplateOp,
            'workflow.FileTransfer': WorkflowFileTransfer,
            'workflow.ForkTask': WorkflowForkTask,
            'workflow.InitiatorContext': WorkflowInitiatorContext,
            'workflow.InternalProperties': WorkflowInternalProperties,
            'workflow.JoinTask': WorkflowJoinTask,
            'workflow.LoopTask': WorkflowLoopTask,
            'workflow.Message': WorkflowMessage,
            'workflow.MigrateServiceItemActionProperty': WorkflowMigrateServiceItemActionProperty,
            'workflow.MigrationHistory': WorkflowMigrationHistory,
            'workflow.MoInventoryDataType': WorkflowMoInventoryDataType,
            'workflow.MoInventoryProperty': WorkflowMoInventoryProperty,
            'workflow.MoReferenceArrayItem': WorkflowMoReferenceArrayItem,
            'workflow.MoReferenceAutoArrayItem': WorkflowMoReferenceAutoArrayItem,
            'workflow.MoReferenceAutoDataType': WorkflowMoReferenceAutoDataType,
            'workflow.MoReferenceAutoProperty': WorkflowMoReferenceAutoProperty,
            'workflow.MoReferenceDataType': WorkflowMoReferenceDataType,
            'workflow.MoReferenceForCloneDataType': WorkflowMoReferenceForCloneDataType,
            'workflow.MoReferenceProperty': WorkflowMoReferenceProperty,
            'workflow.OperationTypeDecommission': WorkflowOperationTypeDecommission,
            'workflow.OperationTypeDeployment': WorkflowOperationTypeDeployment,
            'workflow.OperationTypePostDeployment': WorkflowOperationTypePostDeployment,
            'workflow.ParameterSet': WorkflowParameterSet,
            'workflow.PowerShellApi': WorkflowPowerShellApi,
            'workflow.PrimitiveArrayItem': WorkflowPrimitiveArrayItem,
            'workflow.PrimitiveDataProperty': WorkflowPrimitiveDataProperty,
            'workflow.PrimitiveDataType': WorkflowPrimitiveDataType,
            'workflow.Properties': WorkflowProperties,
            'workflow.ResourceInlineSelector': WorkflowResourceInlineSelector,
            'workflow.ResourceSelectorCriteria': WorkflowResourceSelectorCriteria,
            'workflow.ResultHandler': WorkflowResultHandler,
            'workflow.RollbackTask': WorkflowRollbackTask,
            'workflow.RollbackWorkflowTask': WorkflowRollbackWorkflowTask,
            'workflow.SelectorProperty': WorkflowSelectorProperty,
            'workflow.SequenceParams': WorkflowSequenceParams,
            'workflow.SerialLoopTask': WorkflowSerialLoopTask,
            'workflow.ServiceItemActionProperties': WorkflowServiceItemActionProperties,
            'workflow.ServiceItemActionWorkflowDefinition': WorkflowServiceItemActionWorkflowDefinition,
            'workflow.ServiceItemInputDefinitionType': WorkflowServiceItemInputDefinitionType,
            'workflow.ServiceItemType': WorkflowServiceItemType,
            'workflow.SshCmd': WorkflowSshCmd,
            'workflow.SshConfig': WorkflowSshConfig,
            'workflow.SshSession': WorkflowSshSession,
            'workflow.StartTask': WorkflowStartTask,
            'workflow.SubWorkflowTask': WorkflowSubWorkflowTask,
            'workflow.SuccessEndTask': WorkflowSuccessEndTask,
            'workflow.TargetContext': WorkflowTargetContext,
            'workflow.TargetDataType': WorkflowTargetDataType,
            'workflow.TargetProperty': WorkflowTargetProperty,
            'workflow.TaskConstraints': WorkflowTaskConstraints,
            'workflow.TaskInfoUpdate': WorkflowTaskInfoUpdate,
            'workflow.TaskLoopInfo': WorkflowTaskLoopInfo,
            'workflow.TaskRetryInfo': WorkflowTaskRetryInfo,
            'workflow.UiFormConfig': WorkflowUiFormConfig,
            'workflow.UiInputFilter': WorkflowUiInputFilter,
            'workflow.UiViewConfig': WorkflowUiViewConfig,
            'workflow.ValidationError': WorkflowValidationError,
            'workflow.ValidationInformation': WorkflowValidationInformation,
            'workflow.WaitTask': WorkflowWaitTask,
            'workflow.WaitTaskPrompt': WorkflowWaitTaskPrompt,
            'workflow.WebApi': WorkflowWebApi,
            'workflow.WorkerTask': WorkflowWorkerTask,
            'workflow.WorkflowCtx': WorkflowWorkflowCtx,
            'workflow.WorkflowEngineProperties': WorkflowWorkflowEngineProperties,
            'workflow.WorkflowInfoAutoRestartProperties': WorkflowWorkflowInfoAutoRestartProperties,
            'workflow.WorkflowInfoProperties': WorkflowWorkflowInfoProperties,
            'workflow.WorkflowProperties': WorkflowWorkflowProperties,
            'workflow.WorkflowTask': WorkflowWorkflowTask,
            'workflow.XmlApi': WorkflowXmlApi,
            'workload.AssignedResource': WorkloadAssignedResource,
            'workload.BaseBlueprintReference': WorkloadBaseBlueprintReference,
            'workload.BatchDeployment': WorkloadBatchDeployment,
            'workload.BlueprintInputReference': WorkloadBlueprintInputReference,
            'workload.BlueprintReference': WorkloadBlueprintReference,
            'workload.CanaryDeployment': WorkloadCanaryDeployment,
            'workload.CloneStatus': WorkloadCloneStatus,
            'workload.CloneStatusEntry': WorkloadCloneStatusEntry,
            'workload.DefinitionMapper': WorkloadDefinitionMapper,
            'workload.DeploymentBlueprintInputType': WorkloadDeploymentBlueprintInputType,
            'workload.DeploymentChangeDetail': WorkloadDeploymentChangeDetail,
            'workload.GeneratedObject': WorkloadGeneratedObject,
            'workload.ResourceConstraint': WorkloadResourceConstraint,
            'workload.RolloutStrategy': WorkloadRolloutStrategy,
            'workload.StateAggregation': WorkloadStateAggregation,
            'x509.Certificate': X509Certificate,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, class_id, object_type, *args, **kwargs):  # noqa: E501
        """MoBaseComplexType - a model defined in OpenAPI

        Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """MoBaseComplexType - a model defined in OpenAPI

        Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
