"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.comm_geo_location_details import CommGeoLocationDetails
    from intersight.model.compute_alarm_summary import ComputeAlarmSummary
    from intersight.model.console_console_config_relationship import ConsoleConsoleConfigRelationship
    from intersight.model.display_names import DisplayNames
    from intersight.model.equipment_base import EquipmentBase
    from intersight.model.equipment_chassis_controller_relationship import EquipmentChassisControllerRelationship
    from intersight.model.equipment_chassis_relationship import EquipmentChassisRelationship
    from intersight.model.equipment_fan_module_relationship import EquipmentFanModuleRelationship
    from intersight.model.equipment_fru_relationship import EquipmentFruRelationship
    from intersight.model.equipment_locator_led_relationship import EquipmentLocatorLedRelationship
    from intersight.model.equipment_psu_relationship import EquipmentPsuRelationship
    from intersight.model.equipment_sensor_relationship import EquipmentSensorRelationship
    from intersight.model.equipment_switch_card_relationship import EquipmentSwitchCardRelationship
    from intersight.model.ether_port_channel_relationship import EtherPortChannelRelationship
    from intersight.model.fc_port_channel_relationship import FcPortChannelRelationship
    from intersight.model.firmware_running_firmware_relationship import FirmwareRunningFirmwareRelationship
    from intersight.model.inventory_device_info_relationship import InventoryDeviceInfoRelationship
    from intersight.model.management_controller_relationship import ManagementControllerRelationship
    from intersight.model.management_entity_relationship import ManagementEntityRelationship
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.network_discovered_neighbor_relationship import NetworkDiscoveredNeighborRelationship
    from intersight.model.network_dns_relationship import NetworkDnsRelationship
    from intersight.model.network_element_all_of import NetworkElementAllOf
    from intersight.model.network_fc_zone_info_relationship import NetworkFcZoneInfoRelationship
    from intersight.model.network_feature_control_relationship import NetworkFeatureControlRelationship
    from intersight.model.network_interface_list_relationship import NetworkInterfaceListRelationship
    from intersight.model.network_license_file_relationship import NetworkLicenseFileRelationship
    from intersight.model.network_supervisor_card_relationship import NetworkSupervisorCardRelationship
    from intersight.model.network_vethernet_relationship import NetworkVethernetRelationship
    from intersight.model.network_vfc_relationship import NetworkVfcRelationship
    from intersight.model.network_vlan_port_info_relationship import NetworkVlanPortInfoRelationship
    from intersight.model.network_vpc_domain_relationship import NetworkVpcDomainRelationship
    from intersight.model.network_vpc_member_relationship import NetworkVpcMemberRelationship
    from intersight.model.network_vpc_peer_relationship import NetworkVpcPeerRelationship
    from intersight.model.network_vrf_relationship import NetworkVrfRelationship
    from intersight.model.ntp_ntp_server_relationship import NtpNtpServerRelationship
    from intersight.model.port_mac_binding_relationship import PortMacBindingRelationship
    from intersight.model.processor_unit_relationship import ProcessorUnitRelationship
    from intersight.model.storage_item_relationship import StorageItemRelationship
    from intersight.model.top_system_relationship import TopSystemRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['CommGeoLocationDetails'] = CommGeoLocationDetails
    globals()['ComputeAlarmSummary'] = ComputeAlarmSummary
    globals()['ConsoleConsoleConfigRelationship'] = ConsoleConsoleConfigRelationship
    globals()['DisplayNames'] = DisplayNames
    globals()['EquipmentBase'] = EquipmentBase
    globals()['EquipmentChassisControllerRelationship'] = EquipmentChassisControllerRelationship
    globals()['EquipmentChassisRelationship'] = EquipmentChassisRelationship
    globals()['EquipmentFanModuleRelationship'] = EquipmentFanModuleRelationship
    globals()['EquipmentFruRelationship'] = EquipmentFruRelationship
    globals()['EquipmentLocatorLedRelationship'] = EquipmentLocatorLedRelationship
    globals()['EquipmentPsuRelationship'] = EquipmentPsuRelationship
    globals()['EquipmentSensorRelationship'] = EquipmentSensorRelationship
    globals()['EquipmentSwitchCardRelationship'] = EquipmentSwitchCardRelationship
    globals()['EtherPortChannelRelationship'] = EtherPortChannelRelationship
    globals()['FcPortChannelRelationship'] = FcPortChannelRelationship
    globals()['FirmwareRunningFirmwareRelationship'] = FirmwareRunningFirmwareRelationship
    globals()['InventoryDeviceInfoRelationship'] = InventoryDeviceInfoRelationship
    globals()['ManagementControllerRelationship'] = ManagementControllerRelationship
    globals()['ManagementEntityRelationship'] = ManagementEntityRelationship
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['NetworkDiscoveredNeighborRelationship'] = NetworkDiscoveredNeighborRelationship
    globals()['NetworkDnsRelationship'] = NetworkDnsRelationship
    globals()['NetworkElementAllOf'] = NetworkElementAllOf
    globals()['NetworkFcZoneInfoRelationship'] = NetworkFcZoneInfoRelationship
    globals()['NetworkFeatureControlRelationship'] = NetworkFeatureControlRelationship
    globals()['NetworkInterfaceListRelationship'] = NetworkInterfaceListRelationship
    globals()['NetworkLicenseFileRelationship'] = NetworkLicenseFileRelationship
    globals()['NetworkSupervisorCardRelationship'] = NetworkSupervisorCardRelationship
    globals()['NetworkVethernetRelationship'] = NetworkVethernetRelationship
    globals()['NetworkVfcRelationship'] = NetworkVfcRelationship
    globals()['NetworkVlanPortInfoRelationship'] = NetworkVlanPortInfoRelationship
    globals()['NetworkVpcDomainRelationship'] = NetworkVpcDomainRelationship
    globals()['NetworkVpcMemberRelationship'] = NetworkVpcMemberRelationship
    globals()['NetworkVpcPeerRelationship'] = NetworkVpcPeerRelationship
    globals()['NetworkVrfRelationship'] = NetworkVrfRelationship
    globals()['NtpNtpServerRelationship'] = NtpNtpServerRelationship
    globals()['PortMacBindingRelationship'] = PortMacBindingRelationship
    globals()['ProcessorUnitRelationship'] = ProcessorUnitRelationship
    globals()['StorageItemRelationship'] = StorageItemRelationship
    globals()['TopSystemRelationship'] = TopSystemRelationship


class NetworkElement(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'NETWORK.ELEMENT': "network.Element",
        },
        ('object_type',): {
            'NETWORK.ELEMENT': "network.Element",
        },
        ('admin_evac_state',): {
            'EMPTY': "",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
            'APPLYING': "applying",
            'ON': "on",
            'OFF': "off",
            'N/A': "N/A",
        },
        ('ethernet_switching_mode',): {
            'END-HOST': "end-host",
            'SWITCH': "switch",
        },
        ('fc_switching_mode',): {
            'END-HOST': "end-host",
            'SWITCH': "switch",
        },
        ('inter_cluster_link_state',): {
            'UNKNOWN': "Unknown",
            'UP': "Up",
            'DOWN': "Down",
            'DEGRADED': "Degraded",
        },
        ('management_mode',): {
            'INTERSIGHTSTANDALONE': "IntersightStandalone",
            'UCSM': "UCSM",
            'INTERSIGHT': "Intersight",
        },
        ('oper_evac_state',): {
            'EMPTY': "",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
            'APPLYING': "applying",
            'ON': "on",
            'OFF': "off",
            'N/A': "N/A",
        },
        ('switch_type',): {
            'FABRICINTERCONNECT': "FabricInterconnect",
            'NEXUSDEVICE': "NexusDevice",
            'MDSDEVICE': "MDSDevice",
            'EDGECHASSISMANAGEMENTCONTROLLER': "EdgeChassisManagementController",
        },
        ('thermal',): {
            'UNKNOWN': "unknown",
            'OK': "ok",
            'UPPER-NON-RECOVERABLE': "upper-non-recoverable",
            'UPPER-CRITICAL': "upper-critical",
            'UPPER-NON-CRITICAL': "upper-non-critical",
            'LOWER-NON-CRITICAL': "lower-non-critical",
            'LOWER-CRITICAL': "lower-critical",
            'LOWER-NON-RECOVERABLE': "lower-non-recoverable",
        },
    }

    validations = {
        ('default_domain',): {
            'max_length': 255,
            'min_length': 0,
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9]+([-.]{1}[a-zA-Z0-9]+)*$',  # noqa: E501
            },
        },
        ('user_label',): {
            'max_length': 64,
            'min_length': 0,
            'regex': {
                'pattern': r'^[ !#$%&\(\)\*\+,\-\.\/:;\?@\[\]_\{\|\}~a-zA-Z0-9]*$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'admin_evac_state': (str,),  # noqa: E501
            'admin_inband_interface_state': (str,),  # noqa: E501
            'alarm_summary': (ComputeAlarmSummary,),  # noqa: E501
            'available_memory': (str,),  # noqa: E501
            'chassis': (str,),  # noqa: E501
            'conf_mod_ts': (str,),  # noqa: E501
            'conf_mod_ts_backup': (str,),  # noqa: E501
            'connection_status': (str,),  # noqa: E501
            'default_domain': (str,),  # noqa: E501
            'ethernet_mode': (str,),  # noqa: E501
            'ethernet_switching_mode': (str,),  # noqa: E501
            'fault_summary': (int,),  # noqa: E501
            'fc_mode': (str,),  # noqa: E501
            'fc_switching_mode': (str,),  # noqa: E501
            'fpga_upgrade_needed': (bool,),  # noqa: E501
            'inband_ip_address': (str,),  # noqa: E501
            'inband_ip_gateway': (str,),  # noqa: E501
            'inband_ip_mask': (str,),  # noqa: E501
            'inband_vlan': (int,),  # noqa: E501
            'inter_cluster_link_state': (str,),  # noqa: E501
            'jumbo_frame_enabled': (bool,),  # noqa: E501
            'location_details': (CommGeoLocationDetails,),  # noqa: E501
            'management_mode': (str,),  # noqa: E501
            'oper_evac_state': (str,),  # noqa: E501
            'operability': (str,),  # noqa: E501
            'out_of_band_ip_address': (str,),  # noqa: E501
            'out_of_band_ip_gateway': (str,),  # noqa: E501
            'out_of_band_ip_mask': (str,),  # noqa: E501
            'out_of_band_ipv4_address': (str,),  # noqa: E501
            'out_of_band_ipv4_gateway': (str,),  # noqa: E501
            'out_of_band_ipv4_mask': (str,),  # noqa: E501
            'out_of_band_ipv6_address': (str,),  # noqa: E501
            'out_of_band_ipv6_gateway': (str,),  # noqa: E501
            'out_of_band_ipv6_prefix': (str,),  # noqa: E501
            'out_of_band_mac': (str,),  # noqa: E501
            'part_number': (str,),  # noqa: E501
            'peer_firmware_out_of_sync': (bool,),  # noqa: E501
            'reserved_vlan_start_id': (int,),  # noqa: E501
            'slot_id': (int,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'switch_id': (str,),  # noqa: E501
            'switch_profile_name': (str,),  # noqa: E501
            'switch_type': (str,),  # noqa: E501
            'system_up_time': (str,),  # noqa: E501
            'thermal': (str,),  # noqa: E501
            'total_memory': (int,),  # noqa: E501
            'user_label': (str,),  # noqa: E501
            'version': (str,),  # noqa: E501
            'cards': ([EquipmentSwitchCardRelationship], none_type,),  # noqa: E501
            'cdp_neighbor': ([NetworkDiscoveredNeighborRelationship], none_type,),  # noqa: E501
            'chassis_controller': (EquipmentChassisControllerRelationship,),  # noqa: E501
            'console': ([ConsoleConsoleConfigRelationship], none_type,),  # noqa: E501
            'dns': ([NetworkDnsRelationship], none_type,),  # noqa: E501
            'equipment_chassis': (EquipmentChassisRelationship,),  # noqa: E501
            'ether_port_channels': ([EtherPortChannelRelationship], none_type,),  # noqa: E501
            'fanmodules': ([EquipmentFanModuleRelationship], none_type,),  # noqa: E501
            'fc_port_channels': ([FcPortChannelRelationship], none_type,),  # noqa: E501
            'feature_control': ([NetworkFeatureControlRelationship], none_type,),  # noqa: E501
            'interface_list': ([NetworkInterfaceListRelationship], none_type,),  # noqa: E501
            'inventory_device_info': (InventoryDeviceInfoRelationship,),  # noqa: E501
            'license_file': ([NetworkLicenseFileRelationship], none_type,),  # noqa: E501
            'lldp_neighbor': ([NetworkDiscoveredNeighborRelationship], none_type,),  # noqa: E501
            'locator_led': (EquipmentLocatorLedRelationship,),  # noqa: E501
            'management_controller': (ManagementControllerRelationship,),  # noqa: E501
            'management_entity': (ManagementEntityRelationship,),  # noqa: E501
            'network_fc_zone_info': (NetworkFcZoneInfoRelationship,),  # noqa: E501
            'network_vlan_port_info': (NetworkVlanPortInfoRelationship,),  # noqa: E501
            'ntp_server': ([NtpNtpServerRelationship], none_type,),  # noqa: E501
            'port_mac_bindings': ([PortMacBindingRelationship], none_type,),  # noqa: E501
            'processor_unit': ([ProcessorUnitRelationship], none_type,),  # noqa: E501
            'psus': ([EquipmentPsuRelationship], none_type,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'sensors': ([EquipmentSensorRelationship], none_type,),  # noqa: E501
            'storage_items': ([StorageItemRelationship], none_type,),  # noqa: E501
            'supervisor_card': ([NetworkSupervisorCardRelationship], none_type,),  # noqa: E501
            'top_system': (TopSystemRelationship,),  # noqa: E501
            'ucsm_running_firmware': (FirmwareRunningFirmwareRelationship,),  # noqa: E501
            'veths': ([NetworkVethernetRelationship], none_type,),  # noqa: E501
            'vfcs': ([NetworkVfcRelationship], none_type,),  # noqa: E501
            'vpc_domain': (NetworkVpcDomainRelationship,),  # noqa: E501
            'vpc_member': ([NetworkVpcMemberRelationship], none_type,),  # noqa: E501
            'vpc_peer': ([NetworkVpcPeerRelationship], none_type,),  # noqa: E501
            'vrf': ([NetworkVrfRelationship], none_type,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'device_mo_id': (str,),  # noqa: E501
            'dn': (str,),  # noqa: E501
            'rn': (str,),  # noqa: E501
            'is_upgraded': (bool,),  # noqa: E501
            'model': (str,),  # noqa: E501
            'presence': (str,),  # noqa: E501
            'revision': (str,),  # noqa: E501
            'serial': (str,),  # noqa: E501
            'vendor': (str,),  # noqa: E501
            'previous_fru': (EquipmentFruRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        val = {
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'admin_evac_state': 'AdminEvacState',  # noqa: E501
        'admin_inband_interface_state': 'AdminInbandInterfaceState',  # noqa: E501
        'alarm_summary': 'AlarmSummary',  # noqa: E501
        'available_memory': 'AvailableMemory',  # noqa: E501
        'chassis': 'Chassis',  # noqa: E501
        'conf_mod_ts': 'ConfModTs',  # noqa: E501
        'conf_mod_ts_backup': 'ConfModTsBackup',  # noqa: E501
        'connection_status': 'ConnectionStatus',  # noqa: E501
        'default_domain': 'DefaultDomain',  # noqa: E501
        'ethernet_mode': 'EthernetMode',  # noqa: E501
        'ethernet_switching_mode': 'EthernetSwitchingMode',  # noqa: E501
        'fault_summary': 'FaultSummary',  # noqa: E501
        'fc_mode': 'FcMode',  # noqa: E501
        'fc_switching_mode': 'FcSwitchingMode',  # noqa: E501
        'fpga_upgrade_needed': 'FpgaUpgradeNeeded',  # noqa: E501
        'inband_ip_address': 'InbandIpAddress',  # noqa: E501
        'inband_ip_gateway': 'InbandIpGateway',  # noqa: E501
        'inband_ip_mask': 'InbandIpMask',  # noqa: E501
        'inband_vlan': 'InbandVlan',  # noqa: E501
        'inter_cluster_link_state': 'InterClusterLinkState',  # noqa: E501
        'jumbo_frame_enabled': 'JumboFrameEnabled',  # noqa: E501
        'location_details': 'LocationDetails',  # noqa: E501
        'management_mode': 'ManagementMode',  # noqa: E501
        'oper_evac_state': 'OperEvacState',  # noqa: E501
        'operability': 'Operability',  # noqa: E501
        'out_of_band_ip_address': 'OutOfBandIpAddress',  # noqa: E501
        'out_of_band_ip_gateway': 'OutOfBandIpGateway',  # noqa: E501
        'out_of_band_ip_mask': 'OutOfBandIpMask',  # noqa: E501
        'out_of_band_ipv4_address': 'OutOfBandIpv4Address',  # noqa: E501
        'out_of_band_ipv4_gateway': 'OutOfBandIpv4Gateway',  # noqa: E501
        'out_of_band_ipv4_mask': 'OutOfBandIpv4Mask',  # noqa: E501
        'out_of_band_ipv6_address': 'OutOfBandIpv6Address',  # noqa: E501
        'out_of_band_ipv6_gateway': 'OutOfBandIpv6Gateway',  # noqa: E501
        'out_of_band_ipv6_prefix': 'OutOfBandIpv6Prefix',  # noqa: E501
        'out_of_band_mac': 'OutOfBandMac',  # noqa: E501
        'part_number': 'PartNumber',  # noqa: E501
        'peer_firmware_out_of_sync': 'PeerFirmwareOutOfSync',  # noqa: E501
        'reserved_vlan_start_id': 'ReservedVlanStartId',  # noqa: E501
        'slot_id': 'SlotId',  # noqa: E501
        'status': 'Status',  # noqa: E501
        'switch_id': 'SwitchId',  # noqa: E501
        'switch_profile_name': 'SwitchProfileName',  # noqa: E501
        'switch_type': 'SwitchType',  # noqa: E501
        'system_up_time': 'SystemUpTime',  # noqa: E501
        'thermal': 'Thermal',  # noqa: E501
        'total_memory': 'TotalMemory',  # noqa: E501
        'user_label': 'UserLabel',  # noqa: E501
        'version': 'Version',  # noqa: E501
        'cards': 'Cards',  # noqa: E501
        'cdp_neighbor': 'CdpNeighbor',  # noqa: E501
        'chassis_controller': 'ChassisController',  # noqa: E501
        'console': 'Console',  # noqa: E501
        'dns': 'Dns',  # noqa: E501
        'equipment_chassis': 'EquipmentChassis',  # noqa: E501
        'ether_port_channels': 'EtherPortChannels',  # noqa: E501
        'fanmodules': 'Fanmodules',  # noqa: E501
        'fc_port_channels': 'FcPortChannels',  # noqa: E501
        'feature_control': 'FeatureControl',  # noqa: E501
        'interface_list': 'InterfaceList',  # noqa: E501
        'inventory_device_info': 'InventoryDeviceInfo',  # noqa: E501
        'license_file': 'LicenseFile',  # noqa: E501
        'lldp_neighbor': 'LldpNeighbor',  # noqa: E501
        'locator_led': 'LocatorLed',  # noqa: E501
        'management_controller': 'ManagementController',  # noqa: E501
        'management_entity': 'ManagementEntity',  # noqa: E501
        'network_fc_zone_info': 'NetworkFcZoneInfo',  # noqa: E501
        'network_vlan_port_info': 'NetworkVlanPortInfo',  # noqa: E501
        'ntp_server': 'NtpServer',  # noqa: E501
        'port_mac_bindings': 'PortMacBindings',  # noqa: E501
        'processor_unit': 'ProcessorUnit',  # noqa: E501
        'psus': 'Psus',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'sensors': 'Sensors',  # noqa: E501
        'storage_items': 'StorageItems',  # noqa: E501
        'supervisor_card': 'SupervisorCard',  # noqa: E501
        'top_system': 'TopSystem',  # noqa: E501
        'ucsm_running_firmware': 'UcsmRunningFirmware',  # noqa: E501
        'veths': 'Veths',  # noqa: E501
        'vfcs': 'Vfcs',  # noqa: E501
        'vpc_domain': 'VpcDomain',  # noqa: E501
        'vpc_member': 'VpcMember',  # noqa: E501
        'vpc_peer': 'VpcPeer',  # noqa: E501
        'vrf': 'Vrf',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'device_mo_id': 'DeviceMoId',  # noqa: E501
        'dn': 'Dn',  # noqa: E501
        'rn': 'Rn',  # noqa: E501
        'is_upgraded': 'IsUpgraded',  # noqa: E501
        'model': 'Model',  # noqa: E501
        'presence': 'Presence',  # noqa: E501
        'revision': 'Revision',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'vendor': 'Vendor',  # noqa: E501
        'previous_fru': 'PreviousFru',  # noqa: E501
    }

    read_only_vars = {
        'admin_evac_state',  # noqa: E501
        'admin_inband_interface_state',  # noqa: E501
        'available_memory',  # noqa: E501
        'ethernet_mode',  # noqa: E501
        'ethernet_switching_mode',  # noqa: E501
        'fc_mode',  # noqa: E501
        'fc_switching_mode',  # noqa: E501
        'fpga_upgrade_needed',  # noqa: E501
        'inband_ip_address',  # noqa: E501
        'inband_ip_gateway',  # noqa: E501
        'inband_ip_mask',  # noqa: E501
        'inband_vlan',  # noqa: E501
        'inter_cluster_link_state',  # noqa: E501
        'jumbo_frame_enabled',  # noqa: E501
        'oper_evac_state',  # noqa: E501
        'operability',  # noqa: E501
        'out_of_band_ip_address',  # noqa: E501
        'out_of_band_ip_gateway',  # noqa: E501
        'out_of_band_ip_mask',  # noqa: E501
        'out_of_band_ipv4_address',  # noqa: E501
        'out_of_band_ipv4_gateway',  # noqa: E501
        'out_of_band_ipv4_mask',  # noqa: E501
        'out_of_band_mac',  # noqa: E501
        'peer_firmware_out_of_sync',  # noqa: E501
        'reserved_vlan_start_id',  # noqa: E501
        'slot_id',  # noqa: E501
        'switch_id',  # noqa: E501
        'switch_profile_name',  # noqa: E501
        'switch_type',  # noqa: E501
        'total_memory',  # noqa: E501
        'cards',  # noqa: E501
        'cdp_neighbor',  # noqa: E501
        'console',  # noqa: E501
        'dns',  # noqa: E501
        'ether_port_channels',  # noqa: E501
        'fanmodules',  # noqa: E501
        'fc_port_channels',  # noqa: E501
        'feature_control',  # noqa: E501
        'interface_list',  # noqa: E501
        'license_file',  # noqa: E501
        'lldp_neighbor',  # noqa: E501
        'ntp_server',  # noqa: E501
        'port_mac_bindings',  # noqa: E501
        'psus',  # noqa: E501
        'sensors',  # noqa: E501
        'storage_items',  # noqa: E501
        'veths',  # noqa: E501
        'vfcs',  # noqa: E501
        'vpc_member',  # noqa: E501
        'vpc_peer',  # noqa: E501
        'vrf',  # noqa: E501
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
        'device_mo_id',  # noqa: E501
        'dn',  # noqa: E501
        'rn',  # noqa: E501
        'is_upgraded',  # noqa: E501
        'model',  # noqa: E501
        'presence',  # noqa: E501
        'revision',  # noqa: E501
        'serial',  # noqa: E501
        'vendor',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """NetworkElement - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "network.Element", must be one of ["network.Element", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "network.Element", must be one of ["network.Element", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            admin_evac_state (str): Administratively configured state of Fabric Evacuation feature, for this switch. * `` - Evacuation state of the switch is unknown. * `enabled` - Evacuation state of the switch is enabled. * `disabled` - Evacuation state of the switch is disabled. * `applying` - Evacuation state of the switch when evacuation is in progress. * `on` - Evacuation state of the switch is enabled. * `off` - Evacuation state of the switch is disabled. * `N/A` - Evacuation state of the switch is not applicable.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            admin_inband_interface_state (str): The administrative state of the network Element inband management interface.. [optional]  # noqa: E501
            alarm_summary (ComputeAlarmSummary): [optional]  # noqa: E501
            available_memory (str): Available memory (un-used) on this switch platform.. [optional]  # noqa: E501
            chassis (str): Chassis IP of the switch.. [optional]  # noqa: E501
            conf_mod_ts (str): Configuration modified timestamp of the switch.. [optional]  # noqa: E501
            conf_mod_ts_backup (str): Configuration modified backup timestamp of the switch.. [optional]  # noqa: E501
            connection_status (str): Connection status of the switch.. [optional]  # noqa: E501
            default_domain (str): The default domain name configured on the switch.. [optional]  # noqa: E501
            ethernet_mode (str): The user configured Ethernet operational mode for this switch (End-Host or Switching).. [optional]  # noqa: E501
            ethernet_switching_mode (str): The user configured Ethernet operational mode for this switch (End-Host or Switching). * `end-host` - In end-host mode, the fabric interconnects appear to the upstream devices as end hosts with multiple links.In this mode, the switch does not run Spanning Tree Protocol and avoids loops by following a set of rules for traffic forwarding.In case of ethernet switching mode - Ethernet end-host mode is also known as Ethernet host virtualizer. * `switch` - In switch mode, the switch runs Spanning Tree Protocol to avoid loops, and broadcast and multicast packets are handled in the traditional way.This is the traditional switch mode.. [optional] if omitted the server will use the default value of "end-host"  # noqa: E501
            fault_summary (int): The fault summary of the network Element out-of-band management interface.. [optional]  # noqa: E501
            fc_mode (str): The user configured FC operational mode for this switch (End-Host or Switching).. [optional]  # noqa: E501
            fc_switching_mode (str): The user configured FC operational mode for this switch (End-Host or Switching). * `end-host` - In end-host mode, the fabric interconnects appear to the upstream devices as end hosts with multiple links.In this mode, the switch does not run Spanning Tree Protocol and avoids loops by following a set of rules for traffic forwarding.In case of ethernet switching mode - Ethernet end-host mode is also known as Ethernet host virtualizer. * `switch` - In switch mode, the switch runs Spanning Tree Protocol to avoid loops, and broadcast and multicast packets are handled in the traditional way.This is the traditional switch mode.. [optional] if omitted the server will use the default value of "end-host"  # noqa: E501
            fpga_upgrade_needed (bool): The flag to check vulnerability with secure boot technology.. [optional]  # noqa: E501
            inband_ip_address (str): The IP address of the network Element inband management interface.. [optional]  # noqa: E501
            inband_ip_gateway (str): The default gateway of the network Element inband management interface.. [optional]  # noqa: E501
            inband_ip_mask (str): The network mask of the network Element inband management interface.. [optional]  # noqa: E501
            inband_vlan (int): The VLAN ID of the network Element inband management interface.. [optional]  # noqa: E501
            inter_cluster_link_state (str): The intercluster link state of the switch. * `Unknown` - The operational state of the link is not known. * `Up` - The operational state of the link is up. * `Down` - The operational state of the link is down. * `Degraded` - The link is operational but degraded. This state is applicable to port channels when any one of the member links is down.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            jumbo_frame_enabled (bool): Jumbo Frame configuration for the switch.. [optional] if omitted the server will use the default value of True  # noqa: E501
            location_details (CommGeoLocationDetails): [optional]  # noqa: E501
            management_mode (str): The management mode of the fabric interconnect. * `IntersightStandalone` - Intersight Standalone mode of operation. * `UCSM` - Unified Computing System Manager mode of operation. * `Intersight` - Intersight managed mode of operation.. [optional] if omitted the server will use the default value of "IntersightStandalone"  # noqa: E501
            oper_evac_state (str): Operational state of the Fabric Evacuation feature, for this switch. * `` - Evacuation state of the switch is unknown. * `enabled` - Evacuation state of the switch is enabled. * `disabled` - Evacuation state of the switch is disabled. * `applying` - Evacuation state of the switch when evacuation is in progress. * `on` - Evacuation state of the switch is enabled. * `off` - Evacuation state of the switch is disabled. * `N/A` - Evacuation state of the switch is not applicable.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            operability (str): The switch's current overall operational/health state.. [optional]  # noqa: E501
            out_of_band_ip_address (str): The IP address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ip_gateway (str): The default gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ip_mask (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_address (str): The IPv4 address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_gateway (str): The default IPv4 gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_mask (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_address (str): The IPv6 address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_gateway (str): The default IPv6 gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_prefix (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_mac (str): The MAC address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            part_number (str): Part number of the switch.. [optional]  # noqa: E501
            peer_firmware_out_of_sync (bool): The flag to indicate the firmware of peer Fabric Interconnect is out of sync.. [optional]  # noqa: E501
            reserved_vlan_start_id (int): The reserved VLAN start ID of the Network Element. A block of 128 VLANs are reserved for internal use and cannot be used for carrying network traffic.. [optional]  # noqa: E501
            slot_id (int): The Slot Id of the network Element when embedded inside a chassis.. [optional]  # noqa: E501
            status (str): The status of the switch.. [optional]  # noqa: E501
            switch_id (str): The Switch Id of the network Element.. [optional]  # noqa: E501
            switch_profile_name (str): The name of switch profile associated with the switch.. [optional]  # noqa: E501
            switch_type (str): The Switch type that the network element is a part of. * `FabricInterconnect` - The default Switch type of UCSM and IMM mode devices. * `NexusDevice` - Switch type of Nexus devices. * `MDSDevice` - Switch type of Nexus MDS devices. * `EdgeChassisManagementController` - Switch type of Edge Chassis Management Controller.. [optional] if omitted the server will use the default value of "FabricInterconnect"  # noqa: E501
            system_up_time (str): System up time of the switch.. [optional]  # noqa: E501
            thermal (str): The Thermal status of the fabric interconnect. * `unknown` - The default state of the sensor (in case no data is received). * `ok` - State of the sensor indicating the sensor's temperature range is okay. * `upper-non-recoverable` - State of the sensor indicating that the temperature is extremely high above normal range. * `upper-critical` - State of the sensor indicating that the temperature is above normal range. * `upper-non-critical` - State of the sensor indicating that the temperature is a little above the normal range. * `lower-non-critical` - State of the sensor indicating that the temperature is a little below the normal range. * `lower-critical` - State of the sensor indicating that the temperature is below normal range. * `lower-non-recoverable` - State of the sensor indicating that the temperature is extremely below normal range.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            total_memory (int): Total available memory on this switch platform.. [optional]  # noqa: E501
            user_label (str): The user defined label assigned to the switch.. [optional]  # noqa: E501
            version (str): Firmware version of the switch.. [optional]  # noqa: E501
            cards ([EquipmentSwitchCardRelationship], none_type): An array of relationships to equipmentSwitchCard resources.. [optional]  # noqa: E501
            cdp_neighbor ([NetworkDiscoveredNeighborRelationship], none_type): An array of relationships to networkDiscoveredNeighbor resources.. [optional]  # noqa: E501
            chassis_controller (EquipmentChassisControllerRelationship): [optional]  # noqa: E501
            console ([ConsoleConsoleConfigRelationship], none_type): An array of relationships to consoleConsoleConfig resources.. [optional]  # noqa: E501
            dns ([NetworkDnsRelationship], none_type): An array of relationships to networkDns resources.. [optional]  # noqa: E501
            equipment_chassis (EquipmentChassisRelationship): [optional]  # noqa: E501
            ether_port_channels ([EtherPortChannelRelationship], none_type): An array of relationships to etherPortChannel resources.. [optional]  # noqa: E501
            fanmodules ([EquipmentFanModuleRelationship], none_type): An array of relationships to equipmentFanModule resources.. [optional]  # noqa: E501
            fc_port_channels ([FcPortChannelRelationship], none_type): An array of relationships to fcPortChannel resources.. [optional]  # noqa: E501
            feature_control ([NetworkFeatureControlRelationship], none_type): An array of relationships to networkFeatureControl resources.. [optional]  # noqa: E501
            interface_list ([NetworkInterfaceListRelationship], none_type): An array of relationships to networkInterfaceList resources.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            license_file ([NetworkLicenseFileRelationship], none_type): An array of relationships to networkLicenseFile resources.. [optional]  # noqa: E501
            lldp_neighbor ([NetworkDiscoveredNeighborRelationship], none_type): An array of relationships to networkDiscoveredNeighbor resources.. [optional]  # noqa: E501
            locator_led (EquipmentLocatorLedRelationship): [optional]  # noqa: E501
            management_controller (ManagementControllerRelationship): [optional]  # noqa: E501
            management_entity (ManagementEntityRelationship): [optional]  # noqa: E501
            network_fc_zone_info (NetworkFcZoneInfoRelationship): [optional]  # noqa: E501
            network_vlan_port_info (NetworkVlanPortInfoRelationship): [optional]  # noqa: E501
            ntp_server ([NtpNtpServerRelationship], none_type): An array of relationships to ntpNtpServer resources.. [optional]  # noqa: E501
            port_mac_bindings ([PortMacBindingRelationship], none_type): An array of relationships to portMacBinding resources.. [optional]  # noqa: E501
            processor_unit ([ProcessorUnitRelationship], none_type): An array of relationships to processorUnit resources.. [optional]  # noqa: E501
            psus ([EquipmentPsuRelationship], none_type): An array of relationships to equipmentPsu resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            sensors ([EquipmentSensorRelationship], none_type): An array of relationships to equipmentSensor resources.. [optional]  # noqa: E501
            storage_items ([StorageItemRelationship], none_type): An array of relationships to storageItem resources.. [optional]  # noqa: E501
            supervisor_card ([NetworkSupervisorCardRelationship], none_type): An array of relationships to networkSupervisorCard resources.. [optional]  # noqa: E501
            top_system (TopSystemRelationship): [optional]  # noqa: E501
            ucsm_running_firmware (FirmwareRunningFirmwareRelationship): [optional]  # noqa: E501
            veths ([NetworkVethernetRelationship], none_type): An array of relationships to networkVethernet resources.. [optional]  # noqa: E501
            vfcs ([NetworkVfcRelationship], none_type): An array of relationships to networkVfc resources.. [optional]  # noqa: E501
            vpc_domain (NetworkVpcDomainRelationship): [optional]  # noqa: E501
            vpc_member ([NetworkVpcMemberRelationship], none_type): An array of relationships to networkVpcMember resources.. [optional]  # noqa: E501
            vpc_peer ([NetworkVpcPeerRelationship], none_type): An array of relationships to networkVpcPeer resources.. [optional]  # noqa: E501
            vrf ([NetworkVrfRelationship], none_type): An array of relationships to networkVrf resources.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            is_upgraded (bool): This field indicates the compute status of the catalog values for the associated component or hardware.. [optional] if omitted the server will use the default value of False  # noqa: E501
            model (str): This field displays the model number of the associated component or hardware.. [optional]  # noqa: E501
            presence (str): This field indicates the presence (equipped) or absence (absent) of the associated component or hardware.. [optional]  # noqa: E501
            revision (str): This field displays the revised version of the associated component or hardware (if any).. [optional]  # noqa: E501
            serial (str): This field displays the serial number of the associated component or hardware.. [optional]  # noqa: E501
            vendor (str): This field displays the vendor information of the associated component or hardware.. [optional]  # noqa: E501
            previous_fru (EquipmentFruRelationship): [optional]  # noqa: E501
        """

        class_id = "network.Element" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "network.Element")
        object_type = "network.Element" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "network.Element")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """NetworkElement - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "network.Element", must be one of ["network.Element", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "network.Element", must be one of ["network.Element", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            admin_evac_state (str): Administratively configured state of Fabric Evacuation feature, for this switch. * `` - Evacuation state of the switch is unknown. * `enabled` - Evacuation state of the switch is enabled. * `disabled` - Evacuation state of the switch is disabled. * `applying` - Evacuation state of the switch when evacuation is in progress. * `on` - Evacuation state of the switch is enabled. * `off` - Evacuation state of the switch is disabled. * `N/A` - Evacuation state of the switch is not applicable.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            admin_inband_interface_state (str): The administrative state of the network Element inband management interface.. [optional]  # noqa: E501
            alarm_summary (ComputeAlarmSummary): [optional]  # noqa: E501
            available_memory (str): Available memory (un-used) on this switch platform.. [optional]  # noqa: E501
            chassis (str): Chassis IP of the switch.. [optional]  # noqa: E501
            conf_mod_ts (str): Configuration modified timestamp of the switch.. [optional]  # noqa: E501
            conf_mod_ts_backup (str): Configuration modified backup timestamp of the switch.. [optional]  # noqa: E501
            connection_status (str): Connection status of the switch.. [optional]  # noqa: E501
            default_domain (str): The default domain name configured on the switch.. [optional]  # noqa: E501
            ethernet_mode (str): The user configured Ethernet operational mode for this switch (End-Host or Switching).. [optional]  # noqa: E501
            ethernet_switching_mode (str): The user configured Ethernet operational mode for this switch (End-Host or Switching). * `end-host` - In end-host mode, the fabric interconnects appear to the upstream devices as end hosts with multiple links.In this mode, the switch does not run Spanning Tree Protocol and avoids loops by following a set of rules for traffic forwarding.In case of ethernet switching mode - Ethernet end-host mode is also known as Ethernet host virtualizer. * `switch` - In switch mode, the switch runs Spanning Tree Protocol to avoid loops, and broadcast and multicast packets are handled in the traditional way.This is the traditional switch mode.. [optional] if omitted the server will use the default value of "end-host"  # noqa: E501
            fault_summary (int): The fault summary of the network Element out-of-band management interface.. [optional]  # noqa: E501
            fc_mode (str): The user configured FC operational mode for this switch (End-Host or Switching).. [optional]  # noqa: E501
            fc_switching_mode (str): The user configured FC operational mode for this switch (End-Host or Switching). * `end-host` - In end-host mode, the fabric interconnects appear to the upstream devices as end hosts with multiple links.In this mode, the switch does not run Spanning Tree Protocol and avoids loops by following a set of rules for traffic forwarding.In case of ethernet switching mode - Ethernet end-host mode is also known as Ethernet host virtualizer. * `switch` - In switch mode, the switch runs Spanning Tree Protocol to avoid loops, and broadcast and multicast packets are handled in the traditional way.This is the traditional switch mode.. [optional] if omitted the server will use the default value of "end-host"  # noqa: E501
            fpga_upgrade_needed (bool): The flag to check vulnerability with secure boot technology.. [optional]  # noqa: E501
            inband_ip_address (str): The IP address of the network Element inband management interface.. [optional]  # noqa: E501
            inband_ip_gateway (str): The default gateway of the network Element inband management interface.. [optional]  # noqa: E501
            inband_ip_mask (str): The network mask of the network Element inband management interface.. [optional]  # noqa: E501
            inband_vlan (int): The VLAN ID of the network Element inband management interface.. [optional]  # noqa: E501
            inter_cluster_link_state (str): The intercluster link state of the switch. * `Unknown` - The operational state of the link is not known. * `Up` - The operational state of the link is up. * `Down` - The operational state of the link is down. * `Degraded` - The link is operational but degraded. This state is applicable to port channels when any one of the member links is down.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            jumbo_frame_enabled (bool): Jumbo Frame configuration for the switch.. [optional] if omitted the server will use the default value of True  # noqa: E501
            location_details (CommGeoLocationDetails): [optional]  # noqa: E501
            management_mode (str): The management mode of the fabric interconnect. * `IntersightStandalone` - Intersight Standalone mode of operation. * `UCSM` - Unified Computing System Manager mode of operation. * `Intersight` - Intersight managed mode of operation.. [optional] if omitted the server will use the default value of "IntersightStandalone"  # noqa: E501
            oper_evac_state (str): Operational state of the Fabric Evacuation feature, for this switch. * `` - Evacuation state of the switch is unknown. * `enabled` - Evacuation state of the switch is enabled. * `disabled` - Evacuation state of the switch is disabled. * `applying` - Evacuation state of the switch when evacuation is in progress. * `on` - Evacuation state of the switch is enabled. * `off` - Evacuation state of the switch is disabled. * `N/A` - Evacuation state of the switch is not applicable.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            operability (str): The switch's current overall operational/health state.. [optional]  # noqa: E501
            out_of_band_ip_address (str): The IP address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ip_gateway (str): The default gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ip_mask (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_address (str): The IPv4 address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_gateway (str): The default IPv4 gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv4_mask (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_address (str): The IPv6 address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_gateway (str): The default IPv6 gateway of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_ipv6_prefix (str): The network mask of the network Element out-of-band management interface.. [optional]  # noqa: E501
            out_of_band_mac (str): The MAC address of the network Element out-of-band management interface.. [optional]  # noqa: E501
            part_number (str): Part number of the switch.. [optional]  # noqa: E501
            peer_firmware_out_of_sync (bool): The flag to indicate the firmware of peer Fabric Interconnect is out of sync.. [optional]  # noqa: E501
            reserved_vlan_start_id (int): The reserved VLAN start ID of the Network Element. A block of 128 VLANs are reserved for internal use and cannot be used for carrying network traffic.. [optional]  # noqa: E501
            slot_id (int): The Slot Id of the network Element when embedded inside a chassis.. [optional]  # noqa: E501
            status (str): The status of the switch.. [optional]  # noqa: E501
            switch_id (str): The Switch Id of the network Element.. [optional]  # noqa: E501
            switch_profile_name (str): The name of switch profile associated with the switch.. [optional]  # noqa: E501
            switch_type (str): The Switch type that the network element is a part of. * `FabricInterconnect` - The default Switch type of UCSM and IMM mode devices. * `NexusDevice` - Switch type of Nexus devices. * `MDSDevice` - Switch type of Nexus MDS devices. * `EdgeChassisManagementController` - Switch type of Edge Chassis Management Controller.. [optional] if omitted the server will use the default value of "FabricInterconnect"  # noqa: E501
            system_up_time (str): System up time of the switch.. [optional]  # noqa: E501
            thermal (str): The Thermal status of the fabric interconnect. * `unknown` - The default state of the sensor (in case no data is received). * `ok` - State of the sensor indicating the sensor's temperature range is okay. * `upper-non-recoverable` - State of the sensor indicating that the temperature is extremely high above normal range. * `upper-critical` - State of the sensor indicating that the temperature is above normal range. * `upper-non-critical` - State of the sensor indicating that the temperature is a little above the normal range. * `lower-non-critical` - State of the sensor indicating that the temperature is a little below the normal range. * `lower-critical` - State of the sensor indicating that the temperature is below normal range. * `lower-non-recoverable` - State of the sensor indicating that the temperature is extremely below normal range.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            total_memory (int): Total available memory on this switch platform.. [optional]  # noqa: E501
            user_label (str): The user defined label assigned to the switch.. [optional]  # noqa: E501
            version (str): Firmware version of the switch.. [optional]  # noqa: E501
            cards ([EquipmentSwitchCardRelationship], none_type): An array of relationships to equipmentSwitchCard resources.. [optional]  # noqa: E501
            cdp_neighbor ([NetworkDiscoveredNeighborRelationship], none_type): An array of relationships to networkDiscoveredNeighbor resources.. [optional]  # noqa: E501
            chassis_controller (EquipmentChassisControllerRelationship): [optional]  # noqa: E501
            console ([ConsoleConsoleConfigRelationship], none_type): An array of relationships to consoleConsoleConfig resources.. [optional]  # noqa: E501
            dns ([NetworkDnsRelationship], none_type): An array of relationships to networkDns resources.. [optional]  # noqa: E501
            equipment_chassis (EquipmentChassisRelationship): [optional]  # noqa: E501
            ether_port_channels ([EtherPortChannelRelationship], none_type): An array of relationships to etherPortChannel resources.. [optional]  # noqa: E501
            fanmodules ([EquipmentFanModuleRelationship], none_type): An array of relationships to equipmentFanModule resources.. [optional]  # noqa: E501
            fc_port_channels ([FcPortChannelRelationship], none_type): An array of relationships to fcPortChannel resources.. [optional]  # noqa: E501
            feature_control ([NetworkFeatureControlRelationship], none_type): An array of relationships to networkFeatureControl resources.. [optional]  # noqa: E501
            interface_list ([NetworkInterfaceListRelationship], none_type): An array of relationships to networkInterfaceList resources.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            license_file ([NetworkLicenseFileRelationship], none_type): An array of relationships to networkLicenseFile resources.. [optional]  # noqa: E501
            lldp_neighbor ([NetworkDiscoveredNeighborRelationship], none_type): An array of relationships to networkDiscoveredNeighbor resources.. [optional]  # noqa: E501
            locator_led (EquipmentLocatorLedRelationship): [optional]  # noqa: E501
            management_controller (ManagementControllerRelationship): [optional]  # noqa: E501
            management_entity (ManagementEntityRelationship): [optional]  # noqa: E501
            network_fc_zone_info (NetworkFcZoneInfoRelationship): [optional]  # noqa: E501
            network_vlan_port_info (NetworkVlanPortInfoRelationship): [optional]  # noqa: E501
            ntp_server ([NtpNtpServerRelationship], none_type): An array of relationships to ntpNtpServer resources.. [optional]  # noqa: E501
            port_mac_bindings ([PortMacBindingRelationship], none_type): An array of relationships to portMacBinding resources.. [optional]  # noqa: E501
            processor_unit ([ProcessorUnitRelationship], none_type): An array of relationships to processorUnit resources.. [optional]  # noqa: E501
            psus ([EquipmentPsuRelationship], none_type): An array of relationships to equipmentPsu resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            sensors ([EquipmentSensorRelationship], none_type): An array of relationships to equipmentSensor resources.. [optional]  # noqa: E501
            storage_items ([StorageItemRelationship], none_type): An array of relationships to storageItem resources.. [optional]  # noqa: E501
            supervisor_card ([NetworkSupervisorCardRelationship], none_type): An array of relationships to networkSupervisorCard resources.. [optional]  # noqa: E501
            top_system (TopSystemRelationship): [optional]  # noqa: E501
            ucsm_running_firmware (FirmwareRunningFirmwareRelationship): [optional]  # noqa: E501
            veths ([NetworkVethernetRelationship], none_type): An array of relationships to networkVethernet resources.. [optional]  # noqa: E501
            vfcs ([NetworkVfcRelationship], none_type): An array of relationships to networkVfc resources.. [optional]  # noqa: E501
            vpc_domain (NetworkVpcDomainRelationship): [optional]  # noqa: E501
            vpc_member ([NetworkVpcMemberRelationship], none_type): An array of relationships to networkVpcMember resources.. [optional]  # noqa: E501
            vpc_peer ([NetworkVpcPeerRelationship], none_type): An array of relationships to networkVpcPeer resources.. [optional]  # noqa: E501
            vrf ([NetworkVrfRelationship], none_type): An array of relationships to networkVrf resources.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            is_upgraded (bool): This field indicates the compute status of the catalog values for the associated component or hardware.. [optional] if omitted the server will use the default value of False  # noqa: E501
            model (str): This field displays the model number of the associated component or hardware.. [optional]  # noqa: E501
            presence (str): This field indicates the presence (equipped) or absence (absent) of the associated component or hardware.. [optional]  # noqa: E501
            revision (str): This field displays the revised version of the associated component or hardware (if any).. [optional]  # noqa: E501
            serial (str): This field displays the serial number of the associated component or hardware.. [optional]  # noqa: E501
            vendor (str): This field displays the vendor information of the associated component or hardware.. [optional]  # noqa: E501
            previous_fru (EquipmentFruRelationship): [optional]  # noqa: E501
        """

        class_id = "network.Element" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "network.Element")
        object_type = "network.Element" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "network.Element")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              EquipmentBase,
              NetworkElementAllOf,
          ],
          'oneOf': [
          ],
        }
