"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.mo_base_complex_type import MoBaseComplexType
    from intersight.model.notification_abstract_mo_condition import NotificationAbstractMoCondition
    from intersight.model.notification_alarm_mo_condition import NotificationAlarmMoCondition
    from intersight.model.notification_appliance_upgrade_mo_condition import NotificationApplianceUpgradeMoCondition
    from intersight.model.notification_distributable_mo_condition import NotificationDistributableMoCondition
    from intersight.model.notification_mo_condition import NotificationMoCondition
    from intersight.model.notification_simple_mo_condition import NotificationSimpleMoCondition
    from intersight.model.notification_software_release_meta_mo_condition import NotificationSoftwareReleaseMetaMoCondition
    globals()['MoBaseComplexType'] = MoBaseComplexType
    globals()['NotificationAbstractMoCondition'] = NotificationAbstractMoCondition
    globals()['NotificationAlarmMoCondition'] = NotificationAlarmMoCondition
    globals()['NotificationApplianceUpgradeMoCondition'] = NotificationApplianceUpgradeMoCondition
    globals()['NotificationDistributableMoCondition'] = NotificationDistributableMoCondition
    globals()['NotificationMoCondition'] = NotificationMoCondition
    globals()['NotificationSimpleMoCondition'] = NotificationSimpleMoCondition
    globals()['NotificationSoftwareReleaseMetaMoCondition'] = NotificationSoftwareReleaseMetaMoCondition


class NotificationAbstractCondition(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'AAA.USERAGENT': "aaa.UserAgent",
            'ACCESS.ADDRESSTYPE': "access.AddressType",
            'ACCESS.CONFIGURATIONTYPE': "access.ConfigurationType",
            'ADAPTER.ADAPTERCONFIG': "adapter.AdapterConfig",
            'ADAPTER.DCEINTERFACESETTINGS': "adapter.DceInterfaceSettings",
            'ADAPTER.ETHSETTINGS': "adapter.EthSettings",
            'ADAPTER.FCSETTINGS': "adapter.FcSettings",
            'ADAPTER.PHYSICALNICMODESETTINGS': "adapter.PhysicalNicModeSettings",
            'ADAPTER.PORTCHANNELSETTINGS': "adapter.PortChannelSettings",
            'APIC.FABRICLEAFNODEDETAILS': "apic.FabricLeafNodeDetails",
            'APPLIANCE.APISTATUS': "appliance.ApiStatus",
            'APPLIANCE.CERTRENEWALPHASE': "appliance.CertRenewalPhase",
            'APPLIANCE.CLUSTERINSTALLPHASE': "appliance.ClusterInstallPhase",
            'APPLIANCE.KEYVALUEPAIR': "appliance.KeyValuePair",
            'APPLIANCE.METADATAMANIFESTVERSION': "appliance.MetadataManifestVersion",
            'APPLIANCE.NETWORKSTATUS': "appliance.NetworkStatus",
            'APPLIANCE.NODEIPINFO': "appliance.NodeIpInfo",
            'APPLIANCE.STATUSCHECK': "appliance.StatusCheck",
            'ASSET.ADDRESSINFORMATION': "asset.AddressInformation",
            'ASSET.ALARMSUMMARY': "asset.AlarmSummary",
            'ASSET.APIKEYCREDENTIAL': "asset.ApiKeyCredential",
            'ASSET.CLIENTCERTIFICATECREDENTIAL': "asset.ClientCertificateCredential",
            'ASSET.CLOUDCONNECTION': "asset.CloudConnection",
            'ASSET.CONNECTIONFLAPSTATUS': "asset.ConnectionFlapStatus",
            'ASSET.CONTRACTINFORMATION': "asset.ContractInformation",
            'ASSET.CUSTOMERINFORMATION': "asset.CustomerInformation",
            'ASSET.DEPLOYMENTALARMINFO': "asset.DeploymentAlarmInfo",
            'ASSET.DEPLOYMENTDEVICEALARMINFO': "asset.DeploymentDeviceAlarmInfo",
            'ASSET.DEPLOYMENTDEVICEINFORMATION': "asset.DeploymentDeviceInformation",
            'ASSET.DEVICEENDPOINTLOCALCREDENTIAL': "asset.DeviceEndpointLocalCredential",
            'ASSET.DEVICEINFORMATION': "asset.DeviceInformation",
            'ASSET.DEVICESTATISTICS': "asset.DeviceStatistics",
            'ASSET.DEVICETRANSACTION': "asset.DeviceTransaction",
            'ASSET.GENERICTARGETCLAIMOPTIONS': "asset.GenericTargetClaimOptions",
            'ASSET.GLOBALULTIMATE': "asset.GlobalUltimate",
            'ASSET.GOOGLECLOUDPLATFORMSERVICEACCOUNTKEYCREDENTIAL': "asset.GoogleCloudPlatformServiceAccountKeyCredential",
            'ASSET.HTTPCONNECTION': "asset.HttpConnection",
            'ASSET.INTERSIGHTDEVICECONNECTORCONNECTION': "asset.IntersightDeviceConnectorConnection",
            'ASSET.MERAKICLOUDOPTIONS': "asset.MerakiCloudOptions",
            'ASSET.METERINGTYPE': "asset.MeteringType",
            'ASSET.NEWRELICCREDENTIAL': "asset.NewRelicCredential",
            'ASSET.NOAUTHENTICATIONCREDENTIAL': "asset.NoAuthenticationCredential",
            'ASSET.OAUTHBEARERTOKENCREDENTIAL': "asset.OauthBearerTokenCredential",
            'ASSET.OAUTHCLIENTIDSECRETCREDENTIAL': "asset.OauthClientIdSecretCredential",
            'ASSET.ORCHESTRATIONCIVPVMWAREVCENTEROPTIONS': "asset.OrchestrationCivpVmwareVcenterOptions",
            'ASSET.ORCHESTRATIONHITACHIVIRTUALSTORAGEPLATFORMOPTIONS': "asset.OrchestrationHitachiVirtualStoragePlatformOptions",
            'ASSET.ORCHESTRATIONHSMVMWAREVCENTEROPTIONS': "asset.OrchestrationHsmVmwareVcenterOptions",
            'ASSET.ORCHESTRATIONSERVICE': "asset.OrchestrationService",
            'ASSET.PARENTCONNECTIONSIGNATURE': "asset.ParentConnectionSignature",
            'ASSET.PRIVATEKEYCREDENTIAL': "asset.PrivateKeyCredential",
            'ASSET.PRODUCTINFORMATION': "asset.ProductInformation",
            'ASSET.SCOPEDTARGETCONNECTION': "asset.ScopedTargetConnection",
            'ASSET.SERVICENOWCREDENTIAL': "asset.ServiceNowCredential",
            'ASSET.SSHCONNECTION': "asset.SshConnection",
            'ASSET.SUDIINFO': "asset.SudiInfo",
            'ASSET.TARGETKEY': "asset.TargetKey",
            'ASSET.TARGETSIGNATURE': "asset.TargetSignature",
            'ASSET.TARGETSTATUSDETAILS': "asset.TargetStatusDetails",
            'ASSET.TERRAFORMINTEGRATIONSERVICE': "asset.TerraformIntegrationService",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMAGENTOPTIONS': "asset.TerraformIntegrationTerraformAgentOptions",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMCLOUDOPTIONS': "asset.TerraformIntegrationTerraformCloudOptions",
            'ASSET.USERNAMEPASSWORDCREDENTIAL': "asset.UsernamePasswordCredential",
            'ASSET.VIRTUALIZATIONAMAZONWEBSERVICEOPTIONS': "asset.VirtualizationAmazonWebServiceOptions",
            'ASSET.VIRTUALIZATIONSERVICE': "asset.VirtualizationService",
            'ASSET.VMHOST': "asset.VmHost",
            'ASSET.WORKLOADOPTIMIZERAMAZONWEBSERVICESBILLINGOPTIONS': "asset.WorkloadOptimizerAmazonWebServicesBillingOptions",
            'ASSET.WORKLOADOPTIMIZERDYNATRACEOPTIONS': "asset.WorkloadOptimizerDynatraceOptions",
            'ASSET.WORKLOADOPTIMIZERGOOGLECLOUDPLATFORMBILLINGOPTIONS': "asset.WorkloadOptimizerGoogleCloudPlatformBillingOptions",
            'ASSET.WORKLOADOPTIMIZERHYPERVOPTIONS': "asset.WorkloadOptimizerHypervOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREAPPLICATIONINSIGHTSOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureApplicationInsightsOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREBILLINGOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureBillingOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREENTERPRISEAGREEMENTOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureEnterpriseAgreementOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZURESERVICEPRINCIPALOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureServicePrincipalOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTSQLSERVEROPTIONS': "asset.WorkloadOptimizerMicrosoftSqlServerOptions",
            'ASSET.WORKLOADOPTIMIZERNEWRELICOPTIONS': "asset.WorkloadOptimizerNewRelicOptions",
            'ASSET.WORKLOADOPTIMIZEROPENSTACKOPTIONS': "asset.WorkloadOptimizerOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERORACLEDATABASESERVEROPTIONS': "asset.WorkloadOptimizerOracleDatabaseServerOptions",
            'ASSET.WORKLOADOPTIMIZERREDHATOPENSTACKOPTIONS': "asset.WorkloadOptimizerRedHatOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERSERVICE': "asset.WorkloadOptimizerService",
            'ASSET.WORKLOADOPTIMIZERVMWAREVCENTEROPTIONS': "asset.WorkloadOptimizerVmwareVcenterOptions",
            'BLUEPRINT.BLUEPRINTDEFINITIONDEPENDENCY': "blueprint.BlueprintDefinitionDependency",
            'BLUEPRINT.GENERATEDOBJECTMETADATA': "blueprint.GeneratedObjectMetadata",
            'BLUEPRINT.GENERATEDOBJECTNEW': "blueprint.GeneratedObjectNew",
            'BLUEPRINT.GENERATEDOBJECTOPERATIONTARGET': "blueprint.GeneratedObjectOperationTarget",
            'BLUEPRINT.GENERATEDOBJECTSOURCECLONE': "blueprint.GeneratedObjectSourceClone",
            'BLUEPRINT.GENERATEDOBJECTSOURCELOOKUP': "blueprint.GeneratedObjectSourceLookup",
            'BLUEPRINT.GENERATEDOBJECTSOURCEMERGE': "blueprint.GeneratedObjectSourceMerge",
            'BLUEPRINT.GENERATEDOBJECTSOURCEREFERENCE': "blueprint.GeneratedObjectSourceReference",
            'BLUEPRINT.GENERATEDOBJECTSOURCESELECTOR': "blueprint.GeneratedObjectSourceSelector",
            'BLUEPRINT.INPUTOPERATIONTYPE': "blueprint.InputOperationType",
            'BLUEPRINT.PREGENERATEOPERATION': "blueprint.PreGenerateOperation",
            'BLUEPRINT.PROPERTYITERATION': "blueprint.PropertyIteration",
            'BLUEPRINT.RESOURCECONSTRAINTS': "blueprint.ResourceConstraints",
            'BLUEPRINT.SERVICEITEMDEFINITION': "blueprint.ServiceItemDefinition",
            'BOOT.BOOTLOADER': "boot.Bootloader",
            'BOOT.FLEXMMC': "boot.FlexMmc",
            'BOOT.HTTP': "boot.Http",
            'BOOT.ISCSI': "boot.Iscsi",
            'BOOT.LOCALCDD': "boot.LocalCdd",
            'BOOT.LOCALDISK': "boot.LocalDisk",
            'BOOT.NVME': "boot.Nvme",
            'BOOT.PCHSTORAGE': "boot.PchStorage",
            'BOOT.PXE': "boot.Pxe",
            'BOOT.SAN': "boot.San",
            'BOOT.SDCARD': "boot.SdCard",
            'BOOT.STATICIPV4SETTINGS': "boot.StaticIpV4Settings",
            'BOOT.STATICIPV6SETTINGS': "boot.StaticIpV6Settings",
            'BOOT.UEFISHELL': "boot.UefiShell",
            'BOOT.USB': "boot.Usb",
            'BOOT.VIRTUALMEDIA': "boot.VirtualMedia",
            'BULK.HTTPHEADER': "bulk.HttpHeader",
            'BULK.MULTIRELATIONENTRYPATCH': "bulk.MultiRelationEntryPatch",
            'BULK.PATCHCONTENT': "bulk.PatchContent",
            'BULK.RESTRESULT': "bulk.RestResult",
            'BULK.RESTSUBREQUEST': "bulk.RestSubRequest",
            'BULK.SECRESOURCEROLES': "bulk.SecResourceRoles",
            'CAPABILITY.CERTIFICATEPROPERTYCONSTRAINTS': "capability.CertificatePropertyConstraints",
            'CAPABILITY.FEATURECONFIG': "capability.FeatureConfig",
            'CAPABILITY.HSUISOMODELSPECIFICCONSTRAINT': "capability.HsuIsoModelSpecificConstraint",
            'CAPABILITY.LDAPBASEPROPERTYCONSTRAINTS': "capability.LdapBasePropertyConstraints",
            'CAPABILITY.PCIDRANGE': "capability.PcIdRange",
            'CAPABILITY.PORTRANGE': "capability.PortRange",
            'CAPABILITY.SERVERCOMPONENTCONSTRAINT': "capability.ServerComponentConstraint",
            'CAPABILITY.SWITCHNETWORKLIMITS': "capability.SwitchNetworkLimits",
            'CAPABILITY.SWITCHSTORAGELIMITS': "capability.SwitchStorageLimits",
            'CAPABILITY.SWITCHSYSTEMLIMITS': "capability.SwitchSystemLimits",
            'CAPABILITY.SWITCHINGMODECAPABILITY': "capability.SwitchingModeCapability",
            'CAPABILITY.UNSUPPORTEDFEATURECONFIG': "capability.UnsupportedFeatureConfig",
            'CAPABILITY.UPDATEORDERLISTTYPE': "capability.UpdateOrderListType",
            'CERTIFICATEMANAGEMENT.IMC': "certificatemanagement.Imc",
            'CERTIFICATEMANAGEMENT.ROOTCACERTIFICATE': "certificatemanagement.RootCaCertificate",
            'CLOUD.TFCWORKSPACEVARIABLES': "cloud.TfcWorkspaceVariables",
            'CMRF.CMRF': "cmrf.CmRf",
            'COMM.GEOLOCATIONDETAILS': "comm.GeoLocationDetails",
            'COMM.GEOPOINT': "comm.GeoPoint",
            'COMM.IPV4ADDRESSBLOCK': "comm.IpV4AddressBlock",
            'COMM.IPV4INTERFACE': "comm.IpV4Interface",
            'COMM.IPV6INTERFACE': "comm.IpV6Interface",
            'COMM.PHYSICALADDRESS': "comm.PhysicalAddress",
            'COMM.TAGUSAGE': "comm.TagUsage",
            'COMPUTE.ALARMSUMMARY': "compute.AlarmSummary",
            'COMPUTE.IPADDRESS': "compute.IpAddress",
            'COMPUTE.PENDINGWORKFLOWTRIGGER': "compute.PendingWorkflowTrigger",
            'COMPUTE.PERSISTENTMEMORYMODULE': "compute.PersistentMemoryModule",
            'COMPUTE.PERSISTENTMEMORYOPERATION': "compute.PersistentMemoryOperation",
            'COMPUTE.PERSONALITYSETTING': "compute.PersonalitySetting",
            'COMPUTE.SCRUBOPCONFIGUTATION': "compute.ScrubOpConfigutation",
            'COMPUTE.SERVERCONFIG': "compute.ServerConfig",
            'COMPUTE.SERVEROPSTATUS': "compute.ServerOpStatus",
            'COMPUTE.STORAGECONTROLLEROPERATION': "compute.StorageControllerOperation",
            'COMPUTE.STORAGEPHYSICALDRIVE': "compute.StoragePhysicalDrive",
            'COMPUTE.STORAGEPHYSICALDRIVEOPERATION': "compute.StoragePhysicalDriveOperation",
            'COMPUTE.STORAGEUTILITYIMAGEOPERATION': "compute.StorageUtilityImageOperation",
            'COMPUTE.STORAGEVIRTUALDRIVE': "compute.StorageVirtualDrive",
            'COMPUTE.STORAGEVIRTUALDRIVEOPERATION': "compute.StorageVirtualDriveOperation",
            'COND.ALARMACTION': "cond.AlarmAction",
            'COND.ALARMCLASSIFICATIONELIGIBILITY': "cond.AlarmClassificationEligibility",
            'COND.ALARMSPEC': "cond.AlarmSpec",
            'COND.ALARMSUMMARY': "cond.AlarmSummary",
            'CONNECTOR.CLOSESTREAMMESSAGE': "connector.CloseStreamMessage",
            'CONNECTOR.COMMANDCONTROLMESSAGE': "connector.CommandControlMessage",
            'CONNECTOR.COMMANDTERMINALSTREAM': "connector.CommandTerminalStream",
            'CONNECTOR.EVENTLOG': "connector.EventLog",
            'CONNECTOR.EXPECTPROMPT': "connector.ExpectPrompt",
            'CONNECTOR.FETCHSTREAMMESSAGE': "connector.FetchStreamMessage",
            'CONNECTOR.FILECHECKSUM': "connector.FileChecksum",
            'CONNECTOR.FILEMESSAGE': "connector.FileMessage",
            'CONNECTOR.HTTPREQUEST': "connector.HttpRequest",
            'CONNECTOR.SSHCONFIG': "connector.SshConfig",
            'CONNECTOR.SSHMESSAGE': "connector.SshMessage",
            'CONNECTOR.STARTSTREAM': "connector.StartStream",
            'CONNECTOR.STARTSTREAMFROMDEVICE': "connector.StartStreamFromDevice",
            'CONNECTOR.STREAMACKNOWLEDGE': "connector.StreamAcknowledge",
            'CONNECTOR.STREAMINPUT': "connector.StreamInput",
            'CONNECTOR.STREAMKEEPALIVE': "connector.StreamKeepalive",
            'CONNECTOR.TARGETCHANGEMESSAGE': "connector.TargetChangeMessage",
            'CONNECTOR.TARGETSPECIFICATION': "connector.TargetSpecification",
            'CONNECTOR.URL': "connector.Url",
            'CONNECTOR.WINRMREQUEST': "connector.WinrmRequest",
            'CONNECTOR.XMLAPIMESSAGE': "connector.XmlApiMessage",
            'CONNECTORPACK.CONNECTORPACKUPDATE': "connectorpack.ConnectorPackUpdate",
            'CONTENT.COMPLEXTYPE': "content.ComplexType",
            'CONTENT.PARAMETER': "content.Parameter",
            'CONTENT.TEXTPARAMETER': "content.TextParameter",
            'CONVERGEDINFRA.ALARMSUMMARY': "convergedinfra.AlarmSummary",
            'CONVERGEDINFRA.COMPLIANCESUMMARY': "convergedinfra.ComplianceSummary",
            'CONVERGEDINFRA.PODSUMMARY': "convergedinfra.PodSummary",
            'CRD.CUSTOMRESOURCECONFIGPROPERTY': "crd.CustomResourceConfigProperty",
            'EQUIPMENT.CHASSISOPERATIONSTATUS': "equipment.ChassisOperationStatus",
            'EQUIPMENT.DEVICELOCATION': "equipment.DeviceLocation",
            'EQUIPMENT.IOCARDIDENTITY': "equipment.IoCardIdentity",
            'EQUIPMENT.IOCARDOPERATIONSTATUS': "equipment.IoCardOperationStatus",
            'EQUIPMENT.RESETACTION': "equipment.ResetAction",
            'ETHER.MACSECOPERDATA': "ether.MacsecOperData",
            'FABRIC.CLUSTERASSIGNMENT': "fabric.ClusterAssignment",
            'FABRIC.FCZONEMEMBER': "fabric.FcZoneMember",
            'FABRIC.LLDPSETTINGS': "fabric.LldpSettings",
            'FABRIC.MACAGINGSETTINGS': "fabric.MacAgingSettings",
            'FABRIC.MACSECEAPOL': "fabric.MacSecEaPol",
            'FABRIC.PORTIDENTIFIER': "fabric.PortIdentifier",
            'FABRIC.QOSCLASS': "fabric.QosClass",
            'FABRIC.SECKEY': "fabric.SecKey",
            'FABRIC.SECKEYCHAIN': "fabric.SecKeyChain",
            'FABRIC.UDLDGLOBALSETTINGS': "fabric.UdldGlobalSettings",
            'FABRIC.UDLDSETTINGS': "fabric.UdldSettings",
            'FABRIC.VLANSETTINGS': "fabric.VlanSettings",
            'FCPOOL.BLOCK': "fcpool.Block",
            'FCPOOL.RESERVATIONREFERENCE': "fcpool.ReservationReference",
            'FEEDBACK.FEEDBACKDATA': "feedback.FeedbackData",
            'FIRMWARE.CHASSISUPGRADEIMPACT': "firmware.ChassisUpgradeImpact",
            'FIRMWARE.CIFSSERVER': "firmware.CifsServer",
            'FIRMWARE.COMPONENTIMPACT': "firmware.ComponentImpact",
            'FIRMWARE.COMPONENTMETA': "firmware.ComponentMeta",
            'FIRMWARE.DIRECTDOWNLOAD': "firmware.DirectDownload",
            'FIRMWARE.EXCLUDECOMPONENTPIDLISTTYPE': "firmware.ExcludeComponentPidListType",
            'FIRMWARE.FABRICUPGRADEIMPACT': "firmware.FabricUpgradeImpact",
            'FIRMWARE.FEATUREVERSIONMAP': "firmware.FeatureVersionMap",
            'FIRMWARE.FIRMWAREINVENTORY': "firmware.FirmwareInventory",
            'FIRMWARE.HTTPSERVER': "firmware.HttpServer",
            'FIRMWARE.MODELBUNDLEVERSION': "firmware.ModelBundleVersion",
            'FIRMWARE.NETWORKSHARE': "firmware.NetworkShare",
            'FIRMWARE.NFSSERVER': "firmware.NfsServer",
            'FIRMWARE.SERVERUPGRADEIMPACT': "firmware.ServerUpgradeImpact",
            'FIRMWARE.VERSIONMAP': "firmware.VersionMap",
            'FORECAST.MODEL': "forecast.Model",
            'HCI.AHVGUESTTOOLS': "hci.AhvGuestTools",
            'HCI.ALARMPARAMETER': "hci.AlarmParameter",
            'HCI.ALARMSUMMARY': "hci.AlarmSummary",
            'HCI.APILIMIT': "hci.ApiLimit",
            'HCI.BACKPLANENETWORKPARAMS': "hci.BackplaneNetworkParams",
            'HCI.CAPACITYVIOLATION': "hci.CapacityViolation",
            'HCI.CONSUMPTION': "hci.Consumption",
            'HCI.ENTITLEMENTDETAIL': "hci.EntitlementDetail",
            'HCI.ESXIGUESTTOOLS': "hci.EsxiGuestTools",
            'HCI.EXPIREDLICENSE': "hci.ExpiredLicense",
            'HCI.FAULTTOLERANCESTATE': "hci.FaultToleranceState",
            'HCI.FEATUREVIOLATION': "hci.FeatureViolation",
            'HCI.IPADDRESS': "hci.IpAddress",
            'HCI.IPADDRESSORFQDN': "hci.IpAddressOrFqdn",
            'HCI.KEYMANAGEMENTDEVICETOCERTSTATUSINFO': "hci.KeyManagementDeviceToCertStatusInfo",
            'HCI.LICENSEDSERVICE': "hci.LicensedService",
            'HCI.MANAGEMENTSERVER': "hci.ManagementServer",
            'HCI.PULSESTATUS': "hci.PulseStatus",
            'HCI.SBDF': "hci.Sbdf",
            'HCI.SERVICEVIOLATION': "hci.ServiceViolation",
            'HCI.SOFTWARETYPE': "hci.SoftwareType",
            'HCI.VIRTUALGPUCONFIG': "hci.VirtualGpuConfig",
            'HCL.CONSTRAINT': "hcl.Constraint",
            'HCL.FIRMWARE': "hcl.Firmware",
            'HCL.HARDWARECOMPATIBILITYPROFILE': "hcl.HardwareCompatibilityProfile",
            'HCL.PRODUCT': "hcl.Product",
            'HYPERFLEX.ALARMSUMMARY': "hyperflex.AlarmSummary",
            'HYPERFLEX.APPSETTINGCONSTRAINT': "hyperflex.AppSettingConstraint",
            'HYPERFLEX.BACKUPPOLICYSETTINGS': "hyperflex.BackupPolicySettings",
            'HYPERFLEX.CAPABILITY': "hyperflex.Capability",
            'HYPERFLEX.DATASTOREINFO': "hyperflex.DatastoreInfo",
            'HYPERFLEX.ENTITYREFERENCE': "hyperflex.EntityReference",
            'HYPERFLEX.ERRORSTACK': "hyperflex.ErrorStack",
            'HYPERFLEX.FEATURELIMITENTRY': "hyperflex.FeatureLimitEntry",
            'HYPERFLEX.FILEPATH': "hyperflex.FilePath",
            'HYPERFLEX.HEALTHCHECKNODELEVELINFO': "hyperflex.HealthCheckNodeLevelInfo",
            'HYPERFLEX.HEALTHCHECKSCRIPTINFO': "hyperflex.HealthCheckScriptInfo",
            'HYPERFLEX.HXHOSTMOUNTSTATUSDT': "hyperflex.HxHostMountStatusDt",
            'HYPERFLEX.HXLICENSEAUTHORIZATIONDETAILSDT': "hyperflex.HxLicenseAuthorizationDetailsDt",
            'HYPERFLEX.HXLINKDT': "hyperflex.HxLinkDt",
            'HYPERFLEX.HXNETWORKADDRESSDT': "hyperflex.HxNetworkAddressDt",
            'HYPERFLEX.HXPLATFORMDATASTORECONFIGDT': "hyperflex.HxPlatformDatastoreConfigDt",
            'HYPERFLEX.HXREGISTRATIONDETAILSDT': "hyperflex.HxRegistrationDetailsDt",
            'HYPERFLEX.HXRESILIENCYINFODT': "hyperflex.HxResiliencyInfoDt",
            'HYPERFLEX.HXSITEDT': "hyperflex.HxSiteDt",
            'HYPERFLEX.HXUUIDDT': "hyperflex.HxUuIdDt",
            'HYPERFLEX.HXZONEINFODT': "hyperflex.HxZoneInfoDt",
            'HYPERFLEX.HXZONERESILIENCYINFODT': "hyperflex.HxZoneResiliencyInfoDt",
            'HYPERFLEX.IPADDRRANGE': "hyperflex.IpAddrRange",
            'HYPERFLEX.LOGICALAVAILABILITYZONE': "hyperflex.LogicalAvailabilityZone",
            'HYPERFLEX.MACADDRPREFIXRANGE': "hyperflex.MacAddrPrefixRange",
            'HYPERFLEX.MAPCLUSTERIDTOPROTECTIONINFO': "hyperflex.MapClusterIdToProtectionInfo",
            'HYPERFLEX.MAPCLUSTERIDTOSTSNAPSHOTPOINT': "hyperflex.MapClusterIdToStSnapshotPoint",
            'HYPERFLEX.MAPUUIDTOTRACKEDDISK': "hyperflex.MapUuidToTrackedDisk",
            'HYPERFLEX.NAMEDVLAN': "hyperflex.NamedVlan",
            'HYPERFLEX.NAMEDVSAN': "hyperflex.NamedVsan",
            'HYPERFLEX.NETWORKCONFIGURATION': "hyperflex.NetworkConfiguration",
            'HYPERFLEX.PORTTYPETOPORTNUMBERMAP': "hyperflex.PortTypeToPortNumberMap",
            'HYPERFLEX.PROTECTIONINFO': "hyperflex.ProtectionInfo",
            'HYPERFLEX.RESYNCCLUSTERMOIDS': "hyperflex.ReSyncClusterMoIds",
            'HYPERFLEX.REPLICATIONCLUSTERREFERENCETOSCHEDULE': "hyperflex.ReplicationClusterReferenceToSchedule",
            'HYPERFLEX.REPLICATIONPEERINFO': "hyperflex.ReplicationPeerInfo",
            'HYPERFLEX.REPLICATIONPLATDATASTORE': "hyperflex.ReplicationPlatDatastore",
            'HYPERFLEX.REPLICATIONPLATDATASTOREPAIR': "hyperflex.ReplicationPlatDatastorePair",
            'HYPERFLEX.REPLICATIONSCHEDULE': "hyperflex.ReplicationSchedule",
            'HYPERFLEX.REPLICATIONSTATUS': "hyperflex.ReplicationStatus",
            'HYPERFLEX.RPOSTATUS': "hyperflex.RpoStatus",
            'HYPERFLEX.SERVERFIRMWAREVERSIONINFO': "hyperflex.ServerFirmwareVersionInfo",
            'HYPERFLEX.SERVERMODELENTRY': "hyperflex.ServerModelEntry",
            'HYPERFLEX.SITEDETAILS': "hyperflex.SiteDetails",
            'HYPERFLEX.SNAPSHOTFILES': "hyperflex.SnapshotFiles",
            'HYPERFLEX.SNAPSHOTINFOBRIEF': "hyperflex.SnapshotInfoBrief",
            'HYPERFLEX.SNAPSHOTPOINT': "hyperflex.SnapshotPoint",
            'HYPERFLEX.SNAPSHOTSTATUS': "hyperflex.SnapshotStatus",
            'HYPERFLEX.STPLATFORMCLUSTERHEALINGINFO': "hyperflex.StPlatformClusterHealingInfo",
            'HYPERFLEX.STPLATFORMCLUSTERRESILIENCYINFO': "hyperflex.StPlatformClusterResiliencyInfo",
            'HYPERFLEX.SUMMARY': "hyperflex.Summary",
            'HYPERFLEX.TRACKEDDISK': "hyperflex.TrackedDisk",
            'HYPERFLEX.TRACKEDFILE': "hyperflex.TrackedFile",
            'HYPERFLEX.VCENTERCONFIGURATION': "hyperflex.VcenterConfiguration",
            'HYPERFLEX.VIRTUALMACHINE': "hyperflex.VirtualMachine",
            'HYPERFLEX.VIRTUALMACHINERUNTIMEINFO': "hyperflex.VirtualMachineRuntimeInfo",
            'HYPERFLEX.VMPROTECTIONSPACEUSAGE': "hyperflex.VmProtectionSpaceUsage",
            'HYPERFLEX.WWXNPREFIXRANGE': "hyperflex.WwxnPrefixRange",
            'I18N.MESSAGE': "i18n.Message",
            'I18N.MESSAGEPARAM': "i18n.MessageParam",
            'IAAS.LICENSEKEYSINFO': "iaas.LicenseKeysInfo",
            'IAAS.LICENSEUTILIZATIONINFO': "iaas.LicenseUtilizationInfo",
            'IAAS.WORKFLOWSTEPS': "iaas.WorkflowSteps",
            'IAM.ACCOUNTPERMISSIONS': "iam.AccountPermissions",
            'IAM.ACCOUNTTAGS': "iam.AccountTags",
            'IAM.BASICAUTHCREDENTIALS': "iam.BasicAuthCredentials",
            'IAM.CLIENTMETA': "iam.ClientMeta",
            'IAM.ENDPOINTPASSWORDPROPERTIES': "iam.EndPointPasswordProperties",
            'IAM.FAILUREDETAILS': "iam.FailureDetails",
            'IAM.FEATUREDEFINITION': "iam.FeatureDefinition",
            'IAM.GROUPPERMISSIONTOROLES': "iam.GroupPermissionToRoles",
            'IAM.LDAPBASEPROPERTIES': "iam.LdapBaseProperties",
            'IAM.LDAPDNSPARAMETERS': "iam.LdapDnsParameters",
            'IAM.PERMISSIONREFERENCE': "iam.PermissionReference",
            'IAM.PERMISSIONTOROLES': "iam.PermissionToRoles",
            'IAM.RESOURCEROLE': "iam.ResourceRole",
            'IAM.RULE': "iam.Rule",
            'IAM.SAMLSPCONNECTION': "iam.SamlSpConnection",
            'IAM.SECURITYCONTEXT': "iam.SecurityContext",
            'IAM.SSOSESSIONATTRIBUTES': "iam.SsoSessionAttributes",
            'IAM.SWITCHACCOUNTPERMISSION': "iam.SwitchAccountPermission",
            'IAM.SWITCHSCOPEPERMISSIONS': "iam.SwitchScopePermissions",
            'IAM.USERDETAILS': "iam.UserDetails",
            'IMCCONNECTOR.WEBUIMESSAGE': "imcconnector.WebUiMessage",
            'INFRA.GPUCONFIGURATION': "infra.GpuConfiguration",
            'INFRA.HARDWAREINFO': "infra.HardwareInfo",
            'INFRA.METADATA': "infra.MetaData",
            'INFRA.MIGGPUCONFIGURATION': "infra.MigGpuConfiguration",
            'INVENTORY.INVENTORYMO': "inventory.InventoryMo",
            'INVENTORY.JOBINFO': "inventory.JobInfo",
            'INVENTORY.UEMINFO': "inventory.UemInfo",
            'IPPOOL.IPV4BLOCK': "ippool.IpV4Block",
            'IPPOOL.IPV4CONFIG': "ippool.IpV4Config",
            'IPPOOL.IPV6BLOCK': "ippool.IpV6Block",
            'IPPOOL.IPV6CONFIG': "ippool.IpV6Config",
            'IPPOOL.RESERVATIONREFERENCE': "ippool.ReservationReference",
            'IQNPOOL.IQNSUFFIXBLOCK': "iqnpool.IqnSuffixBlock",
            'IQNPOOL.RESERVATIONREFERENCE': "iqnpool.ReservationReference",
            'ISSUE.DEVICETAG': "issue.DeviceTag",
            'ISSUE.MESSAGE': "issue.Message",
            'ISSUE.ODATACONDITION': "issue.OdataCondition",
            'KUBERNETES.ACTIONINFO': "kubernetes.ActionInfo",
            'KUBERNETES.ADDON': "kubernetes.Addon",
            'KUBERNETES.ADDONCONFIGURATION': "kubernetes.AddonConfiguration",
            'KUBERNETES.ADDONVERSIONREFERENCE': "kubernetes.AddonVersionReference",
            'KUBERNETES.BAREMETALNETWORKINFO': "kubernetes.BaremetalNetworkInfo",
            'KUBERNETES.CALICOCONFIG': "kubernetes.CalicoConfig",
            'KUBERNETES.CLUSTERCERTIFICATECONFIGURATION': "kubernetes.ClusterCertificateConfiguration",
            'KUBERNETES.CLUSTERMANAGEMENTCONFIG': "kubernetes.ClusterManagementConfig",
            'KUBERNETES.CONFIGURATION': "kubernetes.Configuration",
            'KUBERNETES.DAEMONSETSTATUS': "kubernetes.DaemonSetStatus",
            'KUBERNETES.DEPLOYMENTSTATUS': "kubernetes.DeploymentStatus",
            'KUBERNETES.ESSENTIALADDON': "kubernetes.EssentialAddon",
            'KUBERNETES.ESXIVIRTUALMACHINEINFRACONFIG': "kubernetes.EsxiVirtualMachineInfraConfig",
            'KUBERNETES.ETHERNET': "kubernetes.Ethernet",
            'KUBERNETES.ETHERNETMATCHER': "kubernetes.EthernetMatcher",
            'KUBERNETES.INGRESSSTATUS': "kubernetes.IngressStatus",
            'KUBERNETES.INSTANCETYPEDETAILS': "kubernetes.InstanceTypeDetails",
            'KUBERNETES.IPV4CONFIG': "kubernetes.IpV4Config",
            'KUBERNETES.KEYVALUE': "kubernetes.KeyValue",
            'KUBERNETES.LOADBALANCER': "kubernetes.LoadBalancer",
            'KUBERNETES.NETWORKINTERFACESPEC': "kubernetes.NetworkInterfaceSpec",
            'KUBERNETES.NODEADDRESS': "kubernetes.NodeAddress",
            'KUBERNETES.NODEGROUPLABEL': "kubernetes.NodeGroupLabel",
            'KUBERNETES.NODEGROUPTAINT': "kubernetes.NodeGroupTaint",
            'KUBERNETES.NODEINFO': "kubernetes.NodeInfo",
            'KUBERNETES.NODESPEC': "kubernetes.NodeSpec",
            'KUBERNETES.NODESTATUS': "kubernetes.NodeStatus",
            'KUBERNETES.OBJECTMETA': "kubernetes.ObjectMeta",
            'KUBERNETES.OVSBOND': "kubernetes.OvsBond",
            'KUBERNETES.PODSTATUS': "kubernetes.PodStatus",
            'KUBERNETES.PROXYCONFIG': "kubernetes.ProxyConfig",
            'KUBERNETES.ROUTE': "kubernetes.Route",
            'KUBERNETES.SERVICESTATUS': "kubernetes.ServiceStatus",
            'KUBERNETES.STATEFULSETSTATUS': "kubernetes.StatefulSetStatus",
            'KUBERNETES.TAINT': "kubernetes.Taint",
            'LICENSE.SUBSTITUTELICENSE': "license.SubstituteLicense",
            'MACPOOL.BLOCK': "macpool.Block",
            'MACPOOL.MEMBEROF': "macpool.MemberOf",
            'MACPOOL.RESERVATIONREFERENCE': "macpool.ReservationReference",
            'MARKETPLACE.USECASEAUTOMATION': "marketplace.UseCaseAutomation",
            'MARKETPLACE.USECASEDEPENDENCY': "marketplace.UseCaseDependency",
            'MARKETPLACE.USECASELOCALE': "marketplace.UseCaseLocale",
            'MARKETPLACE.USECASEVERSIONLOCALE': "marketplace.UseCaseVersionLocale",
            'MARKETPLACE.USECASEVERSIONRESOURCE': "marketplace.UseCaseVersionResource",
            'MEMORY.PERSISTENTMEMORYGOAL': "memory.PersistentMemoryGoal",
            'MEMORY.PERSISTENTMEMORYLOCALSECURITY': "memory.PersistentMemoryLocalSecurity",
            'MEMORY.PERSISTENTMEMORYLOGICALNAMESPACE': "memory.PersistentMemoryLogicalNamespace",
            'META.ACCESSPRIVILEGE': "meta.AccessPrivilege",
            'META.DISPLAYNAMEDEFINITION': "meta.DisplayNameDefinition",
            'META.IDENTITYDEFINITION': "meta.IdentityDefinition",
            'META.PROPDEFINITION': "meta.PropDefinition",
            'META.RELATIONSHIPDEFINITION': "meta.RelationshipDefinition",
            'METRICS.METRICCRITERION': "metrics.MetricCriterion",
            'MO.MOREF': "mo.MoRef",
            'MO.TAG': "mo.Tag",
            'MO.VERSIONCONTEXT': "mo.VersionContext",
            'MONITORING.CATEGORYSTATUS': "monitoring.CategoryStatus",
            'MOTEMPLATE.ACTIONENTRY': "motemplate.ActionEntry",
            'MOTEMPLATE.ACTIONPARAM': "motemplate.ActionParam",
            'MOTEMPLATE.SYNCERROR': "motemplate.SyncError",
            'NETWORK.HYPERFLEXINTERNETPROTOCOLADDRESSRANGE': "network.HyperFlexInternetProtocolAddressRange",
            'NETWORK.HYPERFLEXNETWORKADDRESS': "network.HyperFlexNetworkAddress",
            'NIAAPI.DETAIL': "niaapi.Detail",
            'NIAAPI.NEWRELEASEDETAIL': "niaapi.NewReleaseDetail",
            'NIAAPI.REVISIONINFO': "niaapi.RevisionInfo",
            'NIAAPI.SOFTWAREREGEX': "niaapi.SoftwareRegex",
            'NIAAPI.VERSIONREGEXPLATFORM': "niaapi.VersionRegexPlatform",
            'NIATELEMETRY.BOOTFLASHDETAILS': "niatelemetry.BootflashDetails",
            'NIATELEMETRY.CLOUDREGIONSELEMENT': "niatelemetry.CloudRegionsElement",
            'NIATELEMETRY.CLOUDROUTERSELEMENT': "niatelemetry.CloudRoutersElement",
            'NIATELEMETRY.DEPLOYMENTSTATUS': "niatelemetry.DeploymentStatus",
            'NIATELEMETRY.DIGITALOPTICALMONITORING': "niatelemetry.DigitalOpticalMonitoring",
            'NIATELEMETRY.DISKINFO': "niatelemetry.Diskinfo",
            'NIATELEMETRY.DOMINFO': "niatelemetry.DomInfo",
            'NIATELEMETRY.DOMTHRESINFO': "niatelemetry.DomThresInfo",
            'NIATELEMETRY.EQPTSTORAGEFIRMWARE': "niatelemetry.EqptStorageFirmware",
            'NIATELEMETRY.EQPTCAPACITYPOLUSAGE5MIN': "niatelemetry.EqptcapacityPolUsage5min",
            'NIATELEMETRY.EQPTCAPACITYPREFIXENTRIES15MIN': "niatelemetry.EqptcapacityPrefixEntries15min",
            'NIATELEMETRY.EQPTCAPACITYPREFIXENTRIES5MIN': "niatelemetry.EqptcapacityPrefixEntries5min",
            'NIATELEMETRY.FANDETAILS': "niatelemetry.FanDetails",
            'NIATELEMETRY.IMAGEDETAIL': "niatelemetry.ImageDetail",
            'NIATELEMETRY.INTERFACE': "niatelemetry.Interface",
            'NIATELEMETRY.INTERFACEELEMENT': "niatelemetry.InterfaceElement",
            'NIATELEMETRY.JOBDETAIL': "niatelemetry.JobDetail",
            'NIATELEMETRY.LOGICALLINK': "niatelemetry.LogicalLink",
            'NIATELEMETRY.MDSNEIGHBORINFO': "niatelemetry.MdsNeighborInfo",
            'NIATELEMETRY.NETWORKINFO': "niatelemetry.NetworkInfo",
            'NIATELEMETRY.NODE': "niatelemetry.Node",
            'NIATELEMETRY.NVEPACKETCOUNTERS': "niatelemetry.NvePacketCounters",
            'NIATELEMETRY.NVEVNI': "niatelemetry.NveVni",
            'NIATELEMETRY.NXOSBGPEVPN': "niatelemetry.NxosBgpEvpn",
            'NIATELEMETRY.NXOSBGPMVPN': "niatelemetry.NxosBgpMvpn",
            'NIATELEMETRY.NXOSVTP': "niatelemetry.NxosVtp",
            'NIATELEMETRY.PROCSYSCPU15MIN': "niatelemetry.ProcSysCpu15min",
            'NIATELEMETRY.PROCSYSCPU5MIN': "niatelemetry.ProcSysCpu5min",
            'NIATELEMETRY.PROCSYSMEM15MIN': "niatelemetry.ProcSysMem15min",
            'NIATELEMETRY.PROCSYSMEM5MIN': "niatelemetry.ProcSysMem5min",
            'NIATELEMETRY.SITES': "niatelemetry.Sites",
            'NIATELEMETRY.SMARTLICENSE': "niatelemetry.SmartLicense",
            'NIATELEMETRY.SWITCHDISKUTILIZATION': "niatelemetry.SwitchDiskUtilization",
            'NIATELEMETRY.VNISTATUS': "niatelemetry.VniStatus",
            'NIATELEMETRY.VPCDETAILS': "niatelemetry.VpcDetails",
            'NOTIFICATION.AGGREGATIONSETTINGS': "notification.AggregationSettings",
            'NOTIFICATION.ALARMMOCONDITION': "notification.AlarmMoCondition",
            'NOTIFICATION.APPLIANCEUPGRADEMOCONDITION': "notification.ApplianceUpgradeMoCondition",
            'NOTIFICATION.DISTRIBUTABLEMOCONDITION': "notification.DistributableMoCondition",
            'NOTIFICATION.MOCONDITION': "notification.MoCondition",
            'NOTIFICATION.SENDEMAIL': "notification.SendEmail",
            'NOTIFICATION.SIMPLEFILTER': "notification.SimpleFilter",
            'NOTIFICATION.SIMPLEMOCONDITION': "notification.SimpleMoCondition",
            'NOTIFICATION.SOFTWARERELEASEMETAMOCONDITION': "notification.SoftwareReleaseMetaMoCondition",
            'NOTIFICATION.TRIGGERWEBHOOK': "notification.TriggerWebhook",
            'NTP.AUTHNTPSERVER': "ntp.AuthNtpServer",
            'ONPREM.CLUSTERINFO': "onprem.ClusterInfo",
            'ONPREM.CLUSTERNODE': "onprem.ClusterNode",
            'ONPREM.IMAGEPACKAGE': "onprem.ImagePackage",
            'ONPREM.RESOURCEINFO': "onprem.ResourceInfo",
            'ONPREM.SCHEDULE': "onprem.Schedule",
            'ONPREM.UPGRADENOTE': "onprem.UpgradeNote",
            'ONPREM.UPGRADEPHASE': "onprem.UpgradePhase",
            'OPENAPI.APIINFO': "openapi.ApiInfo",
            'OPENAPI.FAILEDTASK': "openapi.FailedTask",
            'OPENAPI.KEYVALUEPAIR': "openapi.KeyValuePair",
            'OPRS.KVPAIR': "oprs.Kvpair",
            'OS.ANSWERS': "os.Answers",
            'OS.FIBRECHANNELRESPONSE': "os.FibreChannelResponse",
            'OS.FIBRECHANNELTARGET': "os.FibreChannelTarget",
            'OS.GLOBALCONFIG': "os.GlobalConfig",
            'OS.IPV4CONFIGURATION': "os.Ipv4Configuration",
            'OS.IPV6CONFIGURATION': "os.Ipv6Configuration",
            'OS.ISCSILUNRESPONSE': "os.IscsiLunResponse",
            'OS.ISCSITARGET': "os.IscsiTarget",
            'OS.PHYSICALDISK': "os.PhysicalDisk",
            'OS.PHYSICALDISKRESPONSE': "os.PhysicalDiskResponse",
            'OS.PLACEHOLDER': "os.PlaceHolder",
            'OS.SERVERCONFIG': "os.ServerConfig",
            'OS.VALIDATIONINFORMATION': "os.ValidationInformation",
            'OS.VIRTUALDRIVE': "os.VirtualDrive",
            'OS.VIRTUALDRIVERESPONSE': "os.VirtualDriveResponse",
            'OS.VMWAREPARAMETERS': "os.VmwareParameters",
            'OS.WINDOWSPARAMETERS': "os.WindowsParameters",
            'PARTNERINTEGRATION.METRICSMODEL': "partnerintegration.MetricsModel",
            'PKIX.DISTINGUISHEDNAME': "pkix.DistinguishedName",
            'PKIX.ECDSAKEYSPEC': "pkix.EcdsaKeySpec",
            'PKIX.EDDSAKEYSPEC': "pkix.EddsaKeySpec",
            'PKIX.RSAALGORITHM': "pkix.RsaAlgorithm",
            'PKIX.SUBJECTALTERNATENAME': "pkix.SubjectAlternateName",
            'POLICY.ACTIONPARAM': "policy.ActionParam",
            'POLICY.ACTIONQUALIFIER': "policy.ActionQualifier",
            'POLICY.CONFIGCHANGE': "policy.ConfigChange",
            'POLICY.CONFIGCHANGECONTEXT': "policy.ConfigChangeContext",
            'POLICY.CONFIGCHANGEDISRUPTIONDETAILTYPE': "policy.ConfigChangeDisruptionDetailType",
            'POLICY.CONFIGCONTEXT': "policy.ConfigContext",
            'POLICY.CONFIGRESULTCONTEXT': "policy.ConfigResultContext",
            'POLICY.POLICYERROR': "policy.PolicyError",
            'POLICY.POLICYSTATUS': "policy.PolicyStatus",
            'POLICY.QUALIFIER': "policy.Qualifier",
            'POLICY.SCHEDULEDACTION': "policy.ScheduledAction",
            'RECOVERY.BACKUPSCHEDULE': "recovery.BackupSchedule",
            'RESOURCE.ADAPTORSRANGEFILTER': "resource.AdaptorsRangeFilter",
            'RESOURCE.BLADEQUALIFIER': "resource.BladeQualifier",
            'RESOURCE.CHASSISANDSLOTQUALIFICATION': "resource.ChassisAndSlotQualification",
            'RESOURCE.CHASSISIDRANGEFILTER': "resource.ChassisIdRangeFilter",
            'RESOURCE.CHASSISSERVERSQUALIFIER': "resource.ChassisServersQualifier",
            'RESOURCE.CPUCORERANGEFILTER': "resource.CpuCoreRangeFilter",
            'RESOURCE.CPUSPEEDRANGEFILTER': "resource.CpuSpeedRangeFilter",
            'RESOURCE.DOMAINQUALIFIER': "resource.DomainQualifier",
            'RESOURCE.GPUCONTROLLERSRANGEFILTER': "resource.GpuControllersRangeFilter",
            'RESOURCE.GPUQUALIFIER': "resource.GpuQualifier",
            'RESOURCE.MEMORYCAPACITYRANGEFILTER': "resource.MemoryCapacityRangeFilter",
            'RESOURCE.MEMORYQUALIFIER': "resource.MemoryQualifier",
            'RESOURCE.MEMORYUNITSRANGEFILTER': "resource.MemoryUnitsRangeFilter",
            'RESOURCE.NETWORKADAPTORQUALIFIER': "resource.NetworkAdaptorQualifier",
            'RESOURCE.ODATARULESETQUALIFIER': "resource.OdataRuleSetQualifier",
            'RESOURCE.PERTYPECOMBINEDSELECTOR': "resource.PerTypeCombinedSelector",
            'RESOURCE.PROCESSORQUALIFIER': "resource.ProcessorQualifier",
            'RESOURCE.RACKIDRANGEFILTER': "resource.RackIdRangeFilter",
            'RESOURCE.RACKSERVERQUALIFIER': "resource.RackServerQualifier",
            'RESOURCE.SELECTOR': "resource.Selector",
            'RESOURCE.SLOTIDRANGEFILTER': "resource.SlotIdRangeFilter",
            'RESOURCE.SOURCETOPERMISSIONRESOURCES': "resource.SourceToPermissionResources",
            'RESOURCE.SOURCETOPERMISSIONRESOURCESHOLDER': "resource.SourceToPermissionResourcesHolder",
            'RESOURCE.TAG': "resource.Tag",
            'RESOURCE.TAGQUALIFIER': "resource.TagQualifier",
            'RESOURCEPOOL.CHILDLEASECONDITION': "resourcepool.ChildLeaseCondition",
            'RESOURCEPOOL.QUALIFICATIONTYPE': "resourcepool.QualificationType",
            'RESOURCEPOOL.RESOURCEEVALUATIONSTATUS': "resourcepool.ResourceEvaluationStatus",
            'RESOURCEPOOL.SERVERLEASEPARAMETERS': "resourcepool.ServerLeaseParameters",
            'RESOURCEPOOL.SERVERPOOLPARAMETERS': "resourcepool.ServerPoolParameters",
            'SCHEDULER.BLOCKDATE': "scheduler.BlockDate",
            'SCHEDULER.DAILYCADENCEPARAMS': "scheduler.DailyCadenceParams",
            'SCHEDULER.EVERYCADENCEPARAMS': "scheduler.EveryCadenceParams",
            'SCHEDULER.MONTHLYCADENCEPARAMS': "scheduler.MonthlyCadenceParams",
            'SCHEDULER.ONETIMESCHEDULEPARAMS': "scheduler.OneTimeScheduleParams",
            'SCHEDULER.RECURRINGSCHEDULEPARAMS': "scheduler.RecurringScheduleParams",
            'SCHEDULER.RESTSTIMTASKREQUEST': "scheduler.RestStimTaskRequest",
            'SCHEDULER.TASKRESULTSTATUS': "scheduler.TaskResultStatus",
            'SCHEDULER.TASKSCHEDULEPOLICYEXECUTIONSTATUS': "scheduler.TaskSchedulePolicyExecutionStatus",
            'SCHEDULER.TASKSCHEDULESTATUS': "scheduler.TaskScheduleStatus",
            'SCHEDULER.WEEKLYCADENCEPARAMS': "scheduler.WeeklyCadenceParams",
            'SDCARD.DIAGNOSTICS': "sdcard.Diagnostics",
            'SDCARD.DRIVERS': "sdcard.Drivers",
            'SDCARD.HOSTUPGRADEUTILITY': "sdcard.HostUpgradeUtility",
            'SDCARD.OPERATINGSYSTEM': "sdcard.OperatingSystem",
            'SDCARD.PARTITION': "sdcard.Partition",
            'SDCARD.SERVERCONFIGURATIONUTILITY': "sdcard.ServerConfigurationUtility",
            'SDCARD.USERPARTITION': "sdcard.UserPartition",
            'SERVER.PENDINGWORKFLOWTRIGGER': "server.PendingWorkflowTrigger",
            'SERVER.SERVERASSIGNTYPESLOT': "server.ServerAssignTypeSlot",
            'SERVICEITEM.HEALTHCHECKERRORELEMENT': "serviceitem.HealthCheckErrorElement",
            'SERVICEITEM.MESSAGE': "serviceitem.Message",
            'SERVICEITEM.SELECTIONCRITERIAINPUT': "serviceitem.SelectionCriteriaInput",
            'SERVICEREQUEST.MESSAGE': "servicerequest.Message",
            'SNMP.TRAP': "snmp.Trap",
            'SNMP.USER': "snmp.User",
            'SOFTWAREREPOSITORY.APPLIANCEUPLOAD': "softwarerepository.ApplianceUpload",
            'SOFTWAREREPOSITORY.CIFSSERVER': "softwarerepository.CifsServer",
            'SOFTWAREREPOSITORY.CONSTRAINTMODELS': "softwarerepository.ConstraintModels",
            'SOFTWAREREPOSITORY.HTTPSERVER': "softwarerepository.HttpServer",
            'SOFTWAREREPOSITORY.IMPORTRESULT': "softwarerepository.ImportResult",
            'SOFTWAREREPOSITORY.LOCALMACHINE': "softwarerepository.LocalMachine",
            'SOFTWAREREPOSITORY.NFSSERVER': "softwarerepository.NfsServer",
            'SOFTWAREREPOSITORY.UNSUPPORTEDMODELCONSTRAINT': "softwarerepository.UnsupportedModelConstraint",
            'STORAGE.AUTOMATICDRIVEGROUP': "storage.AutomaticDriveGroup",
            'STORAGE.EXTERNALLUN': "storage.ExternalLun",
            'STORAGE.EXTERNALPARITYGROUP': "storage.ExternalParityGroup",
            'STORAGE.EXTERNALPATH': "storage.ExternalPath",
            'STORAGE.HITACHIARRAYUTILIZATION': "storage.HitachiArrayUtilization",
            'STORAGE.HITACHICAPACITY': "storage.HitachiCapacity",
            'STORAGE.HITACHIINITIATOR': "storage.HitachiInitiator",
            'STORAGE.HOSTNQN': "storage.HostNqn",
            'STORAGE.HYPERFLEXISCSIINITIATOR': "storage.HyperFlexIscsiInitiator",
            'STORAGE.INITIATOR': "storage.Initiator",
            'STORAGE.INTERNALMOPHYSICALDISKCONFIG': "storage.InternalMoPhysicalDiskConfig",
            'STORAGE.KEYSETTING': "storage.KeySetting",
            'STORAGE.KMIPAUTHCREDENTIALS': "storage.KmipAuthCredentials",
            'STORAGE.KMIPSERVER': "storage.KmipServer",
            'STORAGE.LOCALKEYSETTING': "storage.LocalKeySetting",
            'STORAGE.M2VIRTUALDRIVECONFIG': "storage.M2VirtualDriveConfig",
            'STORAGE.MANUALDRIVEGROUP': "storage.ManualDriveGroup",
            'STORAGE.NAMESPACE': "storage.Namespace",
            'STORAGE.NAMESPACEPATH': "storage.NamespacePath",
            'STORAGE.NETAPPAUTOSUPPORT': "storage.NetAppAutoSupport",
            'STORAGE.NETAPPCIFSACL': "storage.NetAppCifsAcl",
            'STORAGE.NETAPPETHERNETPORTLAG': "storage.NetAppEthernetPortLag",
            'STORAGE.NETAPPETHERNETPORTVLAN': "storage.NetAppEthernetPortVlan",
            'STORAGE.NETAPPEXPORTPOLICYRULE': "storage.NetAppExportPolicyRule",
            'STORAGE.NETAPPHIGHAVAILABILITY': "storage.NetAppHighAvailability",
            'STORAGE.NETAPPPERFORMANCEMETRICSAVERAGE': "storage.NetAppPerformanceMetricsAverage",
            'STORAGE.NETAPPPORT': "storage.NetAppPort",
            'STORAGE.NETAPPSNAPSHOTPOLICYSCHEDULE': "storage.NetAppSnapshotPolicySchedule",
            'STORAGE.NETAPPSTORAGECLUSTEREFFICIENCY': "storage.NetAppStorageClusterEfficiency",
            'STORAGE.NETAPPSTORAGEUTILIZATION': "storage.NetAppStorageUtilization",
            'STORAGE.NVMEDEDICATEDHOTSPARECONFIGURATION': "storage.NvmeDedicatedHotSpareConfiguration",
            'STORAGE.NVMEPHYSICALDISKSTATE': "storage.NvmePhysicalDiskState",
            'STORAGE.NVMERAIDDRIVEGROUP': "storage.NvmeRaidDriveGroup",
            'STORAGE.NVMEVIRTUALDRIVECONFIGURATION': "storage.NvmeVirtualDriveConfiguration",
            'STORAGE.PUREARRAYUTILIZATION': "storage.PureArrayUtilization",
            'STORAGE.PUREDISKUTILIZATION': "storage.PureDiskUtilization",
            'STORAGE.PUREHOSTUTILIZATION': "storage.PureHostUtilization",
            'STORAGE.PUREREPLICATIONBLACKOUT': "storage.PureReplicationBlackout",
            'STORAGE.PUREVOLUMEUTILIZATION': "storage.PureVolumeUtilization",
            'STORAGE.R0DRIVE': "storage.R0Drive",
            'STORAGE.REMOTEKEYSETTING': "storage.RemoteKeySetting",
            'STORAGE.SPACE': "storage.Space",
            'STORAGE.SPANDRIVES': "storage.SpanDrives",
            'STORAGE.STORAGECONTAINERHOSTMOUNTSTATUS': "storage.StorageContainerHostMountStatus",
            'STORAGE.STORAGECONTAINERUTILIZATION': "storage.StorageContainerUtilization",
            'STORAGE.VIRTUALDRIVECONFIGURATION': "storage.VirtualDriveConfiguration",
            'STORAGE.VIRTUALDRIVEPOLICY': "storage.VirtualDrivePolicy",
            'STORAGE.VOLUMEUTILIZATION': "storage.VolumeUtilization",
            'SYSLOG.LOCALFILELOGGINGCLIENT': "syslog.LocalFileLoggingClient",
            'SYSLOG.REMOTELOGGINGCLIENT': "syslog.RemoteLoggingClient",
            'TAM.ACTION': "tam.Action",
            'TAM.APIDATASOURCE': "tam.ApiDataSource",
            'TAM.EOLADVISORYDETAILS': "tam.EolAdvisoryDetails",
            'TAM.EOLSEVERITY': "tam.EolSeverity",
            'TAM.FNSEVERITY': "tam.FnSeverity",
            'TAM.IDENTIFIERS': "tam.Identifiers",
            'TAM.MILESTONE': "tam.Milestone",
            'TAM.PSIRTSEVERITY': "tam.PsirtSeverity",
            'TAM.QUERYENTRY': "tam.QueryEntry",
            'TAM.S3DATASOURCE': "tam.S3DataSource",
            'TAM.SECURITYADVISORYDETAILS': "tam.SecurityAdvisoryDetails",
            'TAM.TEXTFSMTEMPLATEDATASOURCE': "tam.TextFsmTemplateDataSource",
            'TASK.FILEDOWNLOADINFO': "task.FileDownloadInfo",
            'TECHSUPPORTMANAGEMENT.APPLIANCEPARAM': "techsupportmanagement.ApplianceParam",
            'TECHSUPPORTMANAGEMENT.NIAPARAM': "techsupportmanagement.NiaParam",
            'TECHSUPPORTMANAGEMENT.PLATFORMPARAM': "techsupportmanagement.PlatformParam",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTFILEINFO': "techsupportmanagement.TechSupportFileInfo",
            'TEMPLATE.TRANSFORMATIONSTAGE': "template.TransformationStage",
            'UCSD.CONNECTORPACK': "ucsd.ConnectorPack",
            'UCSD.UCSDRESTOREPARAMETERS': "ucsd.UcsdRestoreParameters",
            'UCSDCONNECTOR.RESTCLIENTMESSAGE': "ucsdconnector.RestClientMessage",
            'UUIDPOOL.RESERVATIONREFERENCE': "uuidpool.ReservationReference",
            'UUIDPOOL.UUIDBLOCK': "uuidpool.UuidBlock",
            'VIRTUALIZATION.ACTIONINFO': "virtualization.ActionInfo",
            'VIRTUALIZATION.CLOUDINITCONFIG': "virtualization.CloudInitConfig",
            'VIRTUALIZATION.COMPUTECAPACITY': "virtualization.ComputeCapacity",
            'VIRTUALIZATION.CPUINFO': "virtualization.CpuInfo",
            'VIRTUALIZATION.ESXICLONECUSTOMSPEC': "virtualization.EsxiCloneCustomSpec",
            'VIRTUALIZATION.ESXIHOSTCONFIGURATION': "virtualization.EsxiHostConfiguration",
            'VIRTUALIZATION.ESXIOVACUSTOMSPEC': "virtualization.EsxiOvaCustomSpec",
            'VIRTUALIZATION.ESXIVMCOMPUTECONFIGURATION': "virtualization.EsxiVmComputeConfiguration",
            'VIRTUALIZATION.ESXIVMCONFIGURATION': "virtualization.EsxiVmConfiguration",
            'VIRTUALIZATION.ESXIVMNETWORKCONFIGURATION': "virtualization.EsxiVmNetworkConfiguration",
            'VIRTUALIZATION.ESXIVMSTORAGECONFIGURATION': "virtualization.EsxiVmStorageConfiguration",
            'VIRTUALIZATION.GUESTINFO': "virtualization.GuestInfo",
            'VIRTUALIZATION.MEMORYCAPACITY': "virtualization.MemoryCapacity",
            'VIRTUALIZATION.NETWORKINTERFACE': "virtualization.NetworkInterface",
            'VIRTUALIZATION.PRODUCTINFO': "virtualization.ProductInfo",
            'VIRTUALIZATION.STORAGECAPACITY': "virtualization.StorageCapacity",
            'VIRTUALIZATION.VIRTUALMACHINEDISK': "virtualization.VirtualMachineDisk",
            'VIRTUALIZATION.VMESXIDISK': "virtualization.VmEsxiDisk",
            'VIRTUALIZATION.VMWAREATTACHEDRESOURCETAG': "virtualization.VmwareAttachedResourceTag",
            'VIRTUALIZATION.VMWAREDISCOVERYPROTOCOL': "virtualization.VmwareDiscoveryProtocol",
            'VIRTUALIZATION.VMWAREREMOTEDISPLAYINFO': "virtualization.VmwareRemoteDisplayInfo",
            'VIRTUALIZATION.VMWARERESOURCEALLOCATIONSYSTEMTRAFFICTYPES': "virtualization.VmwareResourceAllocationSystemTrafficTypes",
            'VIRTUALIZATION.VMWARERESOURCECONSUMPTION': "virtualization.VmwareResourceConsumption",
            'VIRTUALIZATION.VMWARESHARESINFO': "virtualization.VmwareSharesInfo",
            'VIRTUALIZATION.VMWARETEAMINGANDFAILOVER': "virtualization.VmwareTeamingAndFailover",
            'VIRTUALIZATION.VMWAREVLANRANGE': "virtualization.VmwareVlanRange",
            'VIRTUALIZATION.VMWAREVMCPUSHAREINFO': "virtualization.VmwareVmCpuShareInfo",
            'VIRTUALIZATION.VMWAREVMCPUSOCKETINFO': "virtualization.VmwareVmCpuSocketInfo",
            'VIRTUALIZATION.VMWAREVMDISKCOMMITINFO': "virtualization.VmwareVmDiskCommitInfo",
            'VIRTUALIZATION.VMWAREVMMEMORYSHAREINFO': "virtualization.VmwareVmMemoryShareInfo",
            'VMEDIA.MAPPING': "vmedia.Mapping",
            'VNIC.ARFSSETTINGS': "vnic.ArfsSettings",
            'VNIC.CDN': "vnic.Cdn",
            'VNIC.COMPLETIONQUEUESETTINGS': "vnic.CompletionQueueSettings",
            'VNIC.ETHIFOLDINFO': "vnic.EthIfOldInfo",
            'VNIC.ETHINTERRUPTSETTINGS': "vnic.EthInterruptSettings",
            'VNIC.ETHRXQUEUESETTINGS': "vnic.EthRxQueueSettings",
            'VNIC.ETHTXQUEUESETTINGS': "vnic.EthTxQueueSettings",
            'VNIC.FCERRORRECOVERYSETTINGS': "vnic.FcErrorRecoverySettings",
            'VNIC.FCIFOLDINFO': "vnic.FcIfOldInfo",
            'VNIC.FCINTERRUPTSETTINGS': "vnic.FcInterruptSettings",
            'VNIC.FCQUEUESETTINGS': "vnic.FcQueueSettings",
            'VNIC.FLOGISETTINGS': "vnic.FlogiSettings",
            'VNIC.ISCSIAUTHPROFILE': "vnic.IscsiAuthProfile",
            'VNIC.LUN': "vnic.Lun",
            'VNIC.NVGRESETTINGS': "vnic.NvgreSettings",
            'VNIC.PLACEMENTSETTINGS': "vnic.PlacementSettings",
            'VNIC.PLOGISETTINGS': "vnic.PlogiSettings",
            'VNIC.PTPSETTINGS': "vnic.PtpSettings",
            'VNIC.ROCESETTINGS': "vnic.RoceSettings",
            'VNIC.RSSHASHSETTINGS': "vnic.RssHashSettings",
            'VNIC.SANSETTINGSOLDINFO': "vnic.SanSettingsOldInfo",
            'VNIC.SCSIQUEUESETTINGS': "vnic.ScsiQueueSettings",
            'VNIC.SRIOVSETTINGS': "vnic.SriovSettings",
            'VNIC.TCPOFFLOADSETTINGS': "vnic.TcpOffloadSettings",
            'VNIC.USNICSETTINGS': "vnic.UsnicSettings",
            'VNIC.VIFSTATUS': "vnic.VifStatus",
            'VNIC.VLANSETTINGS': "vnic.VlanSettings",
            'VNIC.VMQSETTINGS': "vnic.VmqSettings",
            'VNIC.VSANSETTINGS': "vnic.VsanSettings",
            'VNIC.VXLANSETTINGS': "vnic.VxlanSettings",
            'WORKFLOW.ANSIBLEPLAYSESSION': "workflow.AnsiblePlaySession",
            'WORKFLOW.ARRAYDATATYPE': "workflow.ArrayDataType",
            'WORKFLOW.ASSOCIATEDROLES': "workflow.AssociatedRoles",
            'WORKFLOW.CANCELABLETYPE': "workflow.CancelableType",
            'WORKFLOW.CLICOMMAND': "workflow.CliCommand",
            'WORKFLOW.COMMENTS': "workflow.Comments",
            'WORKFLOW.CONSTRAINTS': "workflow.Constraints",
            'WORKFLOW.CUSTOMARRAYITEM': "workflow.CustomArrayItem",
            'WORKFLOW.CUSTOMDATAPROPERTY': "workflow.CustomDataProperty",
            'WORKFLOW.CUSTOMDATATYPE': "workflow.CustomDataType",
            'WORKFLOW.CUSTOMDATATYPEPROPERTIES': "workflow.CustomDataTypeProperties",
            'WORKFLOW.DATASOURCESELECTOR': "workflow.DataSourceSelector",
            'WORKFLOW.DECISIONCASE': "workflow.DecisionCase",
            'WORKFLOW.DECISIONTASK': "workflow.DecisionTask",
            'WORKFLOW.DEFAULTVALUE': "workflow.DefaultValue",
            'WORKFLOW.DISPLAYMETA': "workflow.DisplayMeta",
            'WORKFLOW.DYNAMICTEMPLATEPARSERDATATYPE': "workflow.DynamicTemplateParserDataType",
            'WORKFLOW.ENUMENTRY': "workflow.EnumEntry",
            'WORKFLOW.ENVIRONMENTVARIABLEREFERENCE': "workflow.EnvironmentVariableReference",
            'WORKFLOW.EXPECTPROMPT': "workflow.ExpectPrompt",
            'WORKFLOW.FAILUREENDTASK': "workflow.FailureEndTask",
            'WORKFLOW.FILEDOWNLOADOP': "workflow.FileDownloadOp",
            'WORKFLOW.FILEOPERATIONS': "workflow.FileOperations",
            'WORKFLOW.FILETEMPLATEOP': "workflow.FileTemplateOp",
            'WORKFLOW.FILETRANSFER': "workflow.FileTransfer",
            'WORKFLOW.FORKTASK': "workflow.ForkTask",
            'WORKFLOW.INITIATORCONTEXT': "workflow.InitiatorContext",
            'WORKFLOW.INTERNALPROPERTIES': "workflow.InternalProperties",
            'WORKFLOW.JOINTASK': "workflow.JoinTask",
            'WORKFLOW.LOOPTASK': "workflow.LoopTask",
            'WORKFLOW.MESSAGE': "workflow.Message",
            'WORKFLOW.MIGRATESERVICEITEMACTIONPROPERTY': "workflow.MigrateServiceItemActionProperty",
            'WORKFLOW.MIGRATIONHISTORY': "workflow.MigrationHistory",
            'WORKFLOW.MOINVENTORYDATATYPE': "workflow.MoInventoryDataType",
            'WORKFLOW.MOINVENTORYPROPERTY': "workflow.MoInventoryProperty",
            'WORKFLOW.MOREFERENCEARRAYITEM': "workflow.MoReferenceArrayItem",
            'WORKFLOW.MOREFERENCEAUTOARRAYITEM': "workflow.MoReferenceAutoArrayItem",
            'WORKFLOW.MOREFERENCEAUTODATATYPE': "workflow.MoReferenceAutoDataType",
            'WORKFLOW.MOREFERENCEAUTOPROPERTY': "workflow.MoReferenceAutoProperty",
            'WORKFLOW.MOREFERENCEDATATYPE': "workflow.MoReferenceDataType",
            'WORKFLOW.MOREFERENCEFORCLONEDATATYPE': "workflow.MoReferenceForCloneDataType",
            'WORKFLOW.MOREFERENCEPROPERTY': "workflow.MoReferenceProperty",
            'WORKFLOW.OPERATIONTYPEDECOMMISSION': "workflow.OperationTypeDecommission",
            'WORKFLOW.OPERATIONTYPEDEPLOYMENT': "workflow.OperationTypeDeployment",
            'WORKFLOW.OPERATIONTYPEPOSTDEPLOYMENT': "workflow.OperationTypePostDeployment",
            'WORKFLOW.PARAMETERSET': "workflow.ParameterSet",
            'WORKFLOW.POWERSHELLAPI': "workflow.PowerShellApi",
            'WORKFLOW.PRIMITIVEARRAYITEM': "workflow.PrimitiveArrayItem",
            'WORKFLOW.PRIMITIVEDATAPROPERTY': "workflow.PrimitiveDataProperty",
            'WORKFLOW.PRIMITIVEDATATYPE': "workflow.PrimitiveDataType",
            'WORKFLOW.PROPERTIES': "workflow.Properties",
            'WORKFLOW.RESOURCEINLINESELECTOR': "workflow.ResourceInlineSelector",
            'WORKFLOW.RESOURCESELECTORCRITERIA': "workflow.ResourceSelectorCriteria",
            'WORKFLOW.RESULTHANDLER': "workflow.ResultHandler",
            'WORKFLOW.ROLLBACKTASK': "workflow.RollbackTask",
            'WORKFLOW.ROLLBACKWORKFLOWTASK': "workflow.RollbackWorkflowTask",
            'WORKFLOW.SELECTORPROPERTY': "workflow.SelectorProperty",
            'WORKFLOW.SEQUENCEPARAMS': "workflow.SequenceParams",
            'WORKFLOW.SERIALLOOPTASK': "workflow.SerialLoopTask",
            'WORKFLOW.SERVICEITEMACTIONPROPERTIES': "workflow.ServiceItemActionProperties",
            'WORKFLOW.SERVICEITEMACTIONWORKFLOWDEFINITION': "workflow.ServiceItemActionWorkflowDefinition",
            'WORKFLOW.SERVICEITEMINPUTDEFINITIONTYPE': "workflow.ServiceItemInputDefinitionType",
            'WORKFLOW.SERVICEITEMTYPE': "workflow.ServiceItemType",
            'WORKFLOW.SSHCMD': "workflow.SshCmd",
            'WORKFLOW.SSHCONFIG': "workflow.SshConfig",
            'WORKFLOW.SSHSESSION': "workflow.SshSession",
            'WORKFLOW.STARTTASK': "workflow.StartTask",
            'WORKFLOW.SUBWORKFLOWTASK': "workflow.SubWorkflowTask",
            'WORKFLOW.SUCCESSENDTASK': "workflow.SuccessEndTask",
            'WORKFLOW.TARGETCONTEXT': "workflow.TargetContext",
            'WORKFLOW.TARGETDATATYPE': "workflow.TargetDataType",
            'WORKFLOW.TARGETPROPERTY': "workflow.TargetProperty",
            'WORKFLOW.TASKCONSTRAINTS': "workflow.TaskConstraints",
            'WORKFLOW.TASKINFOUPDATE': "workflow.TaskInfoUpdate",
            'WORKFLOW.TASKLOOPINFO': "workflow.TaskLoopInfo",
            'WORKFLOW.TASKRETRYINFO': "workflow.TaskRetryInfo",
            'WORKFLOW.UIFORMCONFIG': "workflow.UiFormConfig",
            'WORKFLOW.UIINPUTFILTER': "workflow.UiInputFilter",
            'WORKFLOW.UIVIEWCONFIG': "workflow.UiViewConfig",
            'WORKFLOW.VALIDATIONERROR': "workflow.ValidationError",
            'WORKFLOW.VALIDATIONINFORMATION': "workflow.ValidationInformation",
            'WORKFLOW.WAITTASK': "workflow.WaitTask",
            'WORKFLOW.WAITTASKPROMPT': "workflow.WaitTaskPrompt",
            'WORKFLOW.WEBAPI': "workflow.WebApi",
            'WORKFLOW.WORKERTASK': "workflow.WorkerTask",
            'WORKFLOW.WORKFLOWCTX': "workflow.WorkflowCtx",
            'WORKFLOW.WORKFLOWENGINEPROPERTIES': "workflow.WorkflowEngineProperties",
            'WORKFLOW.WORKFLOWINFOAUTORESTARTPROPERTIES': "workflow.WorkflowInfoAutoRestartProperties",
            'WORKFLOW.WORKFLOWINFOPROPERTIES': "workflow.WorkflowInfoProperties",
            'WORKFLOW.WORKFLOWPROPERTIES': "workflow.WorkflowProperties",
            'WORKFLOW.XMLAPI': "workflow.XmlApi",
            'WORKLOAD.ASSIGNEDRESOURCE': "workload.AssignedResource",
            'WORKLOAD.BATCHDEPLOYMENT': "workload.BatchDeployment",
            'WORKLOAD.BLUEPRINTINPUTREFERENCE': "workload.BlueprintInputReference",
            'WORKLOAD.BLUEPRINTREFERENCE': "workload.BlueprintReference",
            'WORKLOAD.CANARYDEPLOYMENT': "workload.CanaryDeployment",
            'WORKLOAD.CLONESTATUS': "workload.CloneStatus",
            'WORKLOAD.CLONESTATUSENTRY': "workload.CloneStatusEntry",
            'WORKLOAD.DEFINITIONMAPPER': "workload.DefinitionMapper",
            'WORKLOAD.DEPLOYMENTBLUEPRINTINPUTTYPE': "workload.DeploymentBlueprintInputType",
            'WORKLOAD.DEPLOYMENTCHANGEDETAIL': "workload.DeploymentChangeDetail",
            'WORKLOAD.GENERATEDOBJECT': "workload.GeneratedObject",
            'WORKLOAD.RESOURCECONSTRAINT': "workload.ResourceConstraint",
            'WORKLOAD.STATEAGGREGATION': "workload.StateAggregation",
            'X509.CERTIFICATE': "x509.Certificate",
        },
        ('object_type',): {
            'AAA.USERAGENT': "aaa.UserAgent",
            'ACCESS.ADDRESSTYPE': "access.AddressType",
            'ACCESS.CONFIGURATIONTYPE': "access.ConfigurationType",
            'ADAPTER.ADAPTERCONFIG': "adapter.AdapterConfig",
            'ADAPTER.DCEINTERFACESETTINGS': "adapter.DceInterfaceSettings",
            'ADAPTER.ETHSETTINGS': "adapter.EthSettings",
            'ADAPTER.FCSETTINGS': "adapter.FcSettings",
            'ADAPTER.PHYSICALNICMODESETTINGS': "adapter.PhysicalNicModeSettings",
            'ADAPTER.PORTCHANNELSETTINGS': "adapter.PortChannelSettings",
            'APIC.FABRICLEAFNODEDETAILS': "apic.FabricLeafNodeDetails",
            'APPLIANCE.APISTATUS': "appliance.ApiStatus",
            'APPLIANCE.CERTRENEWALPHASE': "appliance.CertRenewalPhase",
            'APPLIANCE.CLUSTERINSTALLPHASE': "appliance.ClusterInstallPhase",
            'APPLIANCE.KEYVALUEPAIR': "appliance.KeyValuePair",
            'APPLIANCE.METADATAMANIFESTVERSION': "appliance.MetadataManifestVersion",
            'APPLIANCE.NETWORKSTATUS': "appliance.NetworkStatus",
            'APPLIANCE.NODEIPINFO': "appliance.NodeIpInfo",
            'APPLIANCE.STATUSCHECK': "appliance.StatusCheck",
            'ASSET.ADDRESSINFORMATION': "asset.AddressInformation",
            'ASSET.ALARMSUMMARY': "asset.AlarmSummary",
            'ASSET.APIKEYCREDENTIAL': "asset.ApiKeyCredential",
            'ASSET.CLIENTCERTIFICATECREDENTIAL': "asset.ClientCertificateCredential",
            'ASSET.CLOUDCONNECTION': "asset.CloudConnection",
            'ASSET.CONNECTIONFLAPSTATUS': "asset.ConnectionFlapStatus",
            'ASSET.CONTRACTINFORMATION': "asset.ContractInformation",
            'ASSET.CUSTOMERINFORMATION': "asset.CustomerInformation",
            'ASSET.DEPLOYMENTALARMINFO': "asset.DeploymentAlarmInfo",
            'ASSET.DEPLOYMENTDEVICEALARMINFO': "asset.DeploymentDeviceAlarmInfo",
            'ASSET.DEPLOYMENTDEVICEINFORMATION': "asset.DeploymentDeviceInformation",
            'ASSET.DEVICEENDPOINTLOCALCREDENTIAL': "asset.DeviceEndpointLocalCredential",
            'ASSET.DEVICEINFORMATION': "asset.DeviceInformation",
            'ASSET.DEVICESTATISTICS': "asset.DeviceStatistics",
            'ASSET.DEVICETRANSACTION': "asset.DeviceTransaction",
            'ASSET.GENERICTARGETCLAIMOPTIONS': "asset.GenericTargetClaimOptions",
            'ASSET.GLOBALULTIMATE': "asset.GlobalUltimate",
            'ASSET.GOOGLECLOUDPLATFORMSERVICEACCOUNTKEYCREDENTIAL': "asset.GoogleCloudPlatformServiceAccountKeyCredential",
            'ASSET.HTTPCONNECTION': "asset.HttpConnection",
            'ASSET.INTERSIGHTDEVICECONNECTORCONNECTION': "asset.IntersightDeviceConnectorConnection",
            'ASSET.MERAKICLOUDOPTIONS': "asset.MerakiCloudOptions",
            'ASSET.METERINGTYPE': "asset.MeteringType",
            'ASSET.NEWRELICCREDENTIAL': "asset.NewRelicCredential",
            'ASSET.NOAUTHENTICATIONCREDENTIAL': "asset.NoAuthenticationCredential",
            'ASSET.OAUTHBEARERTOKENCREDENTIAL': "asset.OauthBearerTokenCredential",
            'ASSET.OAUTHCLIENTIDSECRETCREDENTIAL': "asset.OauthClientIdSecretCredential",
            'ASSET.ORCHESTRATIONCIVPVMWAREVCENTEROPTIONS': "asset.OrchestrationCivpVmwareVcenterOptions",
            'ASSET.ORCHESTRATIONHITACHIVIRTUALSTORAGEPLATFORMOPTIONS': "asset.OrchestrationHitachiVirtualStoragePlatformOptions",
            'ASSET.ORCHESTRATIONHSMVMWAREVCENTEROPTIONS': "asset.OrchestrationHsmVmwareVcenterOptions",
            'ASSET.ORCHESTRATIONSERVICE': "asset.OrchestrationService",
            'ASSET.PARENTCONNECTIONSIGNATURE': "asset.ParentConnectionSignature",
            'ASSET.PRIVATEKEYCREDENTIAL': "asset.PrivateKeyCredential",
            'ASSET.PRODUCTINFORMATION': "asset.ProductInformation",
            'ASSET.SCOPEDTARGETCONNECTION': "asset.ScopedTargetConnection",
            'ASSET.SERVICENOWCREDENTIAL': "asset.ServiceNowCredential",
            'ASSET.SSHCONNECTION': "asset.SshConnection",
            'ASSET.SUDIINFO': "asset.SudiInfo",
            'ASSET.TARGETKEY': "asset.TargetKey",
            'ASSET.TARGETSIGNATURE': "asset.TargetSignature",
            'ASSET.TARGETSTATUSDETAILS': "asset.TargetStatusDetails",
            'ASSET.TERRAFORMINTEGRATIONSERVICE': "asset.TerraformIntegrationService",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMAGENTOPTIONS': "asset.TerraformIntegrationTerraformAgentOptions",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMCLOUDOPTIONS': "asset.TerraformIntegrationTerraformCloudOptions",
            'ASSET.USERNAMEPASSWORDCREDENTIAL': "asset.UsernamePasswordCredential",
            'ASSET.VIRTUALIZATIONAMAZONWEBSERVICEOPTIONS': "asset.VirtualizationAmazonWebServiceOptions",
            'ASSET.VIRTUALIZATIONSERVICE': "asset.VirtualizationService",
            'ASSET.VMHOST': "asset.VmHost",
            'ASSET.WORKLOADOPTIMIZERAMAZONWEBSERVICESBILLINGOPTIONS': "asset.WorkloadOptimizerAmazonWebServicesBillingOptions",
            'ASSET.WORKLOADOPTIMIZERDYNATRACEOPTIONS': "asset.WorkloadOptimizerDynatraceOptions",
            'ASSET.WORKLOADOPTIMIZERGOOGLECLOUDPLATFORMBILLINGOPTIONS': "asset.WorkloadOptimizerGoogleCloudPlatformBillingOptions",
            'ASSET.WORKLOADOPTIMIZERHYPERVOPTIONS': "asset.WorkloadOptimizerHypervOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREAPPLICATIONINSIGHTSOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureApplicationInsightsOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREBILLINGOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureBillingOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREENTERPRISEAGREEMENTOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureEnterpriseAgreementOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZURESERVICEPRINCIPALOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureServicePrincipalOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTSQLSERVEROPTIONS': "asset.WorkloadOptimizerMicrosoftSqlServerOptions",
            'ASSET.WORKLOADOPTIMIZERNEWRELICOPTIONS': "asset.WorkloadOptimizerNewRelicOptions",
            'ASSET.WORKLOADOPTIMIZEROPENSTACKOPTIONS': "asset.WorkloadOptimizerOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERORACLEDATABASESERVEROPTIONS': "asset.WorkloadOptimizerOracleDatabaseServerOptions",
            'ASSET.WORKLOADOPTIMIZERREDHATOPENSTACKOPTIONS': "asset.WorkloadOptimizerRedHatOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERSERVICE': "asset.WorkloadOptimizerService",
            'ASSET.WORKLOADOPTIMIZERVMWAREVCENTEROPTIONS': "asset.WorkloadOptimizerVmwareVcenterOptions",
            'BLUEPRINT.BLUEPRINTDEFINITIONDEPENDENCY': "blueprint.BlueprintDefinitionDependency",
            'BLUEPRINT.GENERATEDOBJECTMETADATA': "blueprint.GeneratedObjectMetadata",
            'BLUEPRINT.GENERATEDOBJECTNEW': "blueprint.GeneratedObjectNew",
            'BLUEPRINT.GENERATEDOBJECTOPERATIONTARGET': "blueprint.GeneratedObjectOperationTarget",
            'BLUEPRINT.GENERATEDOBJECTSOURCECLONE': "blueprint.GeneratedObjectSourceClone",
            'BLUEPRINT.GENERATEDOBJECTSOURCELOOKUP': "blueprint.GeneratedObjectSourceLookup",
            'BLUEPRINT.GENERATEDOBJECTSOURCEMERGE': "blueprint.GeneratedObjectSourceMerge",
            'BLUEPRINT.GENERATEDOBJECTSOURCEREFERENCE': "blueprint.GeneratedObjectSourceReference",
            'BLUEPRINT.GENERATEDOBJECTSOURCESELECTOR': "blueprint.GeneratedObjectSourceSelector",
            'BLUEPRINT.INPUTOPERATIONTYPE': "blueprint.InputOperationType",
            'BLUEPRINT.PREGENERATEOPERATION': "blueprint.PreGenerateOperation",
            'BLUEPRINT.PROPERTYITERATION': "blueprint.PropertyIteration",
            'BLUEPRINT.RESOURCECONSTRAINTS': "blueprint.ResourceConstraints",
            'BLUEPRINT.SERVICEITEMDEFINITION': "blueprint.ServiceItemDefinition",
            'BOOT.BOOTLOADER': "boot.Bootloader",
            'BOOT.FLEXMMC': "boot.FlexMmc",
            'BOOT.HTTP': "boot.Http",
            'BOOT.ISCSI': "boot.Iscsi",
            'BOOT.LOCALCDD': "boot.LocalCdd",
            'BOOT.LOCALDISK': "boot.LocalDisk",
            'BOOT.NVME': "boot.Nvme",
            'BOOT.PCHSTORAGE': "boot.PchStorage",
            'BOOT.PXE': "boot.Pxe",
            'BOOT.SAN': "boot.San",
            'BOOT.SDCARD': "boot.SdCard",
            'BOOT.STATICIPV4SETTINGS': "boot.StaticIpV4Settings",
            'BOOT.STATICIPV6SETTINGS': "boot.StaticIpV6Settings",
            'BOOT.UEFISHELL': "boot.UefiShell",
            'BOOT.USB': "boot.Usb",
            'BOOT.VIRTUALMEDIA': "boot.VirtualMedia",
            'BULK.HTTPHEADER': "bulk.HttpHeader",
            'BULK.MULTIRELATIONENTRYPATCH': "bulk.MultiRelationEntryPatch",
            'BULK.PATCHCONTENT': "bulk.PatchContent",
            'BULK.RESTRESULT': "bulk.RestResult",
            'BULK.RESTSUBREQUEST': "bulk.RestSubRequest",
            'BULK.SECRESOURCEROLES': "bulk.SecResourceRoles",
            'CAPABILITY.CERTIFICATEPROPERTYCONSTRAINTS': "capability.CertificatePropertyConstraints",
            'CAPABILITY.FEATURECONFIG': "capability.FeatureConfig",
            'CAPABILITY.HSUISOMODELSPECIFICCONSTRAINT': "capability.HsuIsoModelSpecificConstraint",
            'CAPABILITY.LDAPBASEPROPERTYCONSTRAINTS': "capability.LdapBasePropertyConstraints",
            'CAPABILITY.PCIDRANGE': "capability.PcIdRange",
            'CAPABILITY.PORTRANGE': "capability.PortRange",
            'CAPABILITY.SERVERCOMPONENTCONSTRAINT': "capability.ServerComponentConstraint",
            'CAPABILITY.SWITCHNETWORKLIMITS': "capability.SwitchNetworkLimits",
            'CAPABILITY.SWITCHSTORAGELIMITS': "capability.SwitchStorageLimits",
            'CAPABILITY.SWITCHSYSTEMLIMITS': "capability.SwitchSystemLimits",
            'CAPABILITY.SWITCHINGMODECAPABILITY': "capability.SwitchingModeCapability",
            'CAPABILITY.UNSUPPORTEDFEATURECONFIG': "capability.UnsupportedFeatureConfig",
            'CAPABILITY.UPDATEORDERLISTTYPE': "capability.UpdateOrderListType",
            'CERTIFICATEMANAGEMENT.IMC': "certificatemanagement.Imc",
            'CERTIFICATEMANAGEMENT.ROOTCACERTIFICATE': "certificatemanagement.RootCaCertificate",
            'CLOUD.TFCWORKSPACEVARIABLES': "cloud.TfcWorkspaceVariables",
            'CMRF.CMRF': "cmrf.CmRf",
            'COMM.GEOLOCATIONDETAILS': "comm.GeoLocationDetails",
            'COMM.GEOPOINT': "comm.GeoPoint",
            'COMM.IPV4ADDRESSBLOCK': "comm.IpV4AddressBlock",
            'COMM.IPV4INTERFACE': "comm.IpV4Interface",
            'COMM.IPV6INTERFACE': "comm.IpV6Interface",
            'COMM.PHYSICALADDRESS': "comm.PhysicalAddress",
            'COMM.TAGUSAGE': "comm.TagUsage",
            'COMPUTE.ALARMSUMMARY': "compute.AlarmSummary",
            'COMPUTE.IPADDRESS': "compute.IpAddress",
            'COMPUTE.PENDINGWORKFLOWTRIGGER': "compute.PendingWorkflowTrigger",
            'COMPUTE.PERSISTENTMEMORYMODULE': "compute.PersistentMemoryModule",
            'COMPUTE.PERSISTENTMEMORYOPERATION': "compute.PersistentMemoryOperation",
            'COMPUTE.PERSONALITYSETTING': "compute.PersonalitySetting",
            'COMPUTE.SCRUBOPCONFIGUTATION': "compute.ScrubOpConfigutation",
            'COMPUTE.SERVERCONFIG': "compute.ServerConfig",
            'COMPUTE.SERVEROPSTATUS': "compute.ServerOpStatus",
            'COMPUTE.STORAGECONTROLLEROPERATION': "compute.StorageControllerOperation",
            'COMPUTE.STORAGEPHYSICALDRIVE': "compute.StoragePhysicalDrive",
            'COMPUTE.STORAGEPHYSICALDRIVEOPERATION': "compute.StoragePhysicalDriveOperation",
            'COMPUTE.STORAGEUTILITYIMAGEOPERATION': "compute.StorageUtilityImageOperation",
            'COMPUTE.STORAGEVIRTUALDRIVE': "compute.StorageVirtualDrive",
            'COMPUTE.STORAGEVIRTUALDRIVEOPERATION': "compute.StorageVirtualDriveOperation",
            'COND.ALARMACTION': "cond.AlarmAction",
            'COND.ALARMCLASSIFICATIONELIGIBILITY': "cond.AlarmClassificationEligibility",
            'COND.ALARMSPEC': "cond.AlarmSpec",
            'COND.ALARMSUMMARY': "cond.AlarmSummary",
            'CONNECTOR.CLOSESTREAMMESSAGE': "connector.CloseStreamMessage",
            'CONNECTOR.COMMANDCONTROLMESSAGE': "connector.CommandControlMessage",
            'CONNECTOR.COMMANDTERMINALSTREAM': "connector.CommandTerminalStream",
            'CONNECTOR.EVENTLOG': "connector.EventLog",
            'CONNECTOR.EXPECTPROMPT': "connector.ExpectPrompt",
            'CONNECTOR.FETCHSTREAMMESSAGE': "connector.FetchStreamMessage",
            'CONNECTOR.FILECHECKSUM': "connector.FileChecksum",
            'CONNECTOR.FILEMESSAGE': "connector.FileMessage",
            'CONNECTOR.HTTPREQUEST': "connector.HttpRequest",
            'CONNECTOR.SSHCONFIG': "connector.SshConfig",
            'CONNECTOR.SSHMESSAGE': "connector.SshMessage",
            'CONNECTOR.STARTSTREAM': "connector.StartStream",
            'CONNECTOR.STARTSTREAMFROMDEVICE': "connector.StartStreamFromDevice",
            'CONNECTOR.STREAMACKNOWLEDGE': "connector.StreamAcknowledge",
            'CONNECTOR.STREAMINPUT': "connector.StreamInput",
            'CONNECTOR.STREAMKEEPALIVE': "connector.StreamKeepalive",
            'CONNECTOR.TARGETCHANGEMESSAGE': "connector.TargetChangeMessage",
            'CONNECTOR.TARGETSPECIFICATION': "connector.TargetSpecification",
            'CONNECTOR.URL': "connector.Url",
            'CONNECTOR.WINRMREQUEST': "connector.WinrmRequest",
            'CONNECTOR.XMLAPIMESSAGE': "connector.XmlApiMessage",
            'CONNECTORPACK.CONNECTORPACKUPDATE': "connectorpack.ConnectorPackUpdate",
            'CONTENT.COMPLEXTYPE': "content.ComplexType",
            'CONTENT.PARAMETER': "content.Parameter",
            'CONTENT.TEXTPARAMETER': "content.TextParameter",
            'CONVERGEDINFRA.ALARMSUMMARY': "convergedinfra.AlarmSummary",
            'CONVERGEDINFRA.COMPLIANCESUMMARY': "convergedinfra.ComplianceSummary",
            'CONVERGEDINFRA.PODSUMMARY': "convergedinfra.PodSummary",
            'CRD.CUSTOMRESOURCECONFIGPROPERTY': "crd.CustomResourceConfigProperty",
            'EQUIPMENT.CHASSISOPERATIONSTATUS': "equipment.ChassisOperationStatus",
            'EQUIPMENT.DEVICELOCATION': "equipment.DeviceLocation",
            'EQUIPMENT.IOCARDIDENTITY': "equipment.IoCardIdentity",
            'EQUIPMENT.IOCARDOPERATIONSTATUS': "equipment.IoCardOperationStatus",
            'EQUIPMENT.RESETACTION': "equipment.ResetAction",
            'ETHER.MACSECOPERDATA': "ether.MacsecOperData",
            'FABRIC.CLUSTERASSIGNMENT': "fabric.ClusterAssignment",
            'FABRIC.FCZONEMEMBER': "fabric.FcZoneMember",
            'FABRIC.LLDPSETTINGS': "fabric.LldpSettings",
            'FABRIC.MACAGINGSETTINGS': "fabric.MacAgingSettings",
            'FABRIC.MACSECEAPOL': "fabric.MacSecEaPol",
            'FABRIC.PORTIDENTIFIER': "fabric.PortIdentifier",
            'FABRIC.QOSCLASS': "fabric.QosClass",
            'FABRIC.SECKEY': "fabric.SecKey",
            'FABRIC.SECKEYCHAIN': "fabric.SecKeyChain",
            'FABRIC.UDLDGLOBALSETTINGS': "fabric.UdldGlobalSettings",
            'FABRIC.UDLDSETTINGS': "fabric.UdldSettings",
            'FABRIC.VLANSETTINGS': "fabric.VlanSettings",
            'FCPOOL.BLOCK': "fcpool.Block",
            'FCPOOL.RESERVATIONREFERENCE': "fcpool.ReservationReference",
            'FEEDBACK.FEEDBACKDATA': "feedback.FeedbackData",
            'FIRMWARE.CHASSISUPGRADEIMPACT': "firmware.ChassisUpgradeImpact",
            'FIRMWARE.CIFSSERVER': "firmware.CifsServer",
            'FIRMWARE.COMPONENTIMPACT': "firmware.ComponentImpact",
            'FIRMWARE.COMPONENTMETA': "firmware.ComponentMeta",
            'FIRMWARE.DIRECTDOWNLOAD': "firmware.DirectDownload",
            'FIRMWARE.EXCLUDECOMPONENTPIDLISTTYPE': "firmware.ExcludeComponentPidListType",
            'FIRMWARE.FABRICUPGRADEIMPACT': "firmware.FabricUpgradeImpact",
            'FIRMWARE.FEATUREVERSIONMAP': "firmware.FeatureVersionMap",
            'FIRMWARE.FIRMWAREINVENTORY': "firmware.FirmwareInventory",
            'FIRMWARE.HTTPSERVER': "firmware.HttpServer",
            'FIRMWARE.MODELBUNDLEVERSION': "firmware.ModelBundleVersion",
            'FIRMWARE.NETWORKSHARE': "firmware.NetworkShare",
            'FIRMWARE.NFSSERVER': "firmware.NfsServer",
            'FIRMWARE.SERVERUPGRADEIMPACT': "firmware.ServerUpgradeImpact",
            'FIRMWARE.VERSIONMAP': "firmware.VersionMap",
            'FORECAST.MODEL': "forecast.Model",
            'HCI.AHVGUESTTOOLS': "hci.AhvGuestTools",
            'HCI.ALARMPARAMETER': "hci.AlarmParameter",
            'HCI.ALARMSUMMARY': "hci.AlarmSummary",
            'HCI.APILIMIT': "hci.ApiLimit",
            'HCI.BACKPLANENETWORKPARAMS': "hci.BackplaneNetworkParams",
            'HCI.CAPACITYVIOLATION': "hci.CapacityViolation",
            'HCI.CONSUMPTION': "hci.Consumption",
            'HCI.ENTITLEMENTDETAIL': "hci.EntitlementDetail",
            'HCI.ESXIGUESTTOOLS': "hci.EsxiGuestTools",
            'HCI.EXPIREDLICENSE': "hci.ExpiredLicense",
            'HCI.FAULTTOLERANCESTATE': "hci.FaultToleranceState",
            'HCI.FEATUREVIOLATION': "hci.FeatureViolation",
            'HCI.IPADDRESS': "hci.IpAddress",
            'HCI.IPADDRESSORFQDN': "hci.IpAddressOrFqdn",
            'HCI.KEYMANAGEMENTDEVICETOCERTSTATUSINFO': "hci.KeyManagementDeviceToCertStatusInfo",
            'HCI.LICENSEDSERVICE': "hci.LicensedService",
            'HCI.MANAGEMENTSERVER': "hci.ManagementServer",
            'HCI.PULSESTATUS': "hci.PulseStatus",
            'HCI.SBDF': "hci.Sbdf",
            'HCI.SERVICEVIOLATION': "hci.ServiceViolation",
            'HCI.SOFTWARETYPE': "hci.SoftwareType",
            'HCI.VIRTUALGPUCONFIG': "hci.VirtualGpuConfig",
            'HCL.CONSTRAINT': "hcl.Constraint",
            'HCL.FIRMWARE': "hcl.Firmware",
            'HCL.HARDWARECOMPATIBILITYPROFILE': "hcl.HardwareCompatibilityProfile",
            'HCL.PRODUCT': "hcl.Product",
            'HYPERFLEX.ALARMSUMMARY': "hyperflex.AlarmSummary",
            'HYPERFLEX.APPSETTINGCONSTRAINT': "hyperflex.AppSettingConstraint",
            'HYPERFLEX.BACKUPPOLICYSETTINGS': "hyperflex.BackupPolicySettings",
            'HYPERFLEX.CAPABILITY': "hyperflex.Capability",
            'HYPERFLEX.DATASTOREINFO': "hyperflex.DatastoreInfo",
            'HYPERFLEX.ENTITYREFERENCE': "hyperflex.EntityReference",
            'HYPERFLEX.ERRORSTACK': "hyperflex.ErrorStack",
            'HYPERFLEX.FEATURELIMITENTRY': "hyperflex.FeatureLimitEntry",
            'HYPERFLEX.FILEPATH': "hyperflex.FilePath",
            'HYPERFLEX.HEALTHCHECKNODELEVELINFO': "hyperflex.HealthCheckNodeLevelInfo",
            'HYPERFLEX.HEALTHCHECKSCRIPTINFO': "hyperflex.HealthCheckScriptInfo",
            'HYPERFLEX.HXHOSTMOUNTSTATUSDT': "hyperflex.HxHostMountStatusDt",
            'HYPERFLEX.HXLICENSEAUTHORIZATIONDETAILSDT': "hyperflex.HxLicenseAuthorizationDetailsDt",
            'HYPERFLEX.HXLINKDT': "hyperflex.HxLinkDt",
            'HYPERFLEX.HXNETWORKADDRESSDT': "hyperflex.HxNetworkAddressDt",
            'HYPERFLEX.HXPLATFORMDATASTORECONFIGDT': "hyperflex.HxPlatformDatastoreConfigDt",
            'HYPERFLEX.HXREGISTRATIONDETAILSDT': "hyperflex.HxRegistrationDetailsDt",
            'HYPERFLEX.HXRESILIENCYINFODT': "hyperflex.HxResiliencyInfoDt",
            'HYPERFLEX.HXSITEDT': "hyperflex.HxSiteDt",
            'HYPERFLEX.HXUUIDDT': "hyperflex.HxUuIdDt",
            'HYPERFLEX.HXZONEINFODT': "hyperflex.HxZoneInfoDt",
            'HYPERFLEX.HXZONERESILIENCYINFODT': "hyperflex.HxZoneResiliencyInfoDt",
            'HYPERFLEX.IPADDRRANGE': "hyperflex.IpAddrRange",
            'HYPERFLEX.LOGICALAVAILABILITYZONE': "hyperflex.LogicalAvailabilityZone",
            'HYPERFLEX.MACADDRPREFIXRANGE': "hyperflex.MacAddrPrefixRange",
            'HYPERFLEX.MAPCLUSTERIDTOPROTECTIONINFO': "hyperflex.MapClusterIdToProtectionInfo",
            'HYPERFLEX.MAPCLUSTERIDTOSTSNAPSHOTPOINT': "hyperflex.MapClusterIdToStSnapshotPoint",
            'HYPERFLEX.MAPUUIDTOTRACKEDDISK': "hyperflex.MapUuidToTrackedDisk",
            'HYPERFLEX.NAMEDVLAN': "hyperflex.NamedVlan",
            'HYPERFLEX.NAMEDVSAN': "hyperflex.NamedVsan",
            'HYPERFLEX.NETWORKCONFIGURATION': "hyperflex.NetworkConfiguration",
            'HYPERFLEX.PORTTYPETOPORTNUMBERMAP': "hyperflex.PortTypeToPortNumberMap",
            'HYPERFLEX.PROTECTIONINFO': "hyperflex.ProtectionInfo",
            'HYPERFLEX.RESYNCCLUSTERMOIDS': "hyperflex.ReSyncClusterMoIds",
            'HYPERFLEX.REPLICATIONCLUSTERREFERENCETOSCHEDULE': "hyperflex.ReplicationClusterReferenceToSchedule",
            'HYPERFLEX.REPLICATIONPEERINFO': "hyperflex.ReplicationPeerInfo",
            'HYPERFLEX.REPLICATIONPLATDATASTORE': "hyperflex.ReplicationPlatDatastore",
            'HYPERFLEX.REPLICATIONPLATDATASTOREPAIR': "hyperflex.ReplicationPlatDatastorePair",
            'HYPERFLEX.REPLICATIONSCHEDULE': "hyperflex.ReplicationSchedule",
            'HYPERFLEX.REPLICATIONSTATUS': "hyperflex.ReplicationStatus",
            'HYPERFLEX.RPOSTATUS': "hyperflex.RpoStatus",
            'HYPERFLEX.SERVERFIRMWAREVERSIONINFO': "hyperflex.ServerFirmwareVersionInfo",
            'HYPERFLEX.SERVERMODELENTRY': "hyperflex.ServerModelEntry",
            'HYPERFLEX.SITEDETAILS': "hyperflex.SiteDetails",
            'HYPERFLEX.SNAPSHOTFILES': "hyperflex.SnapshotFiles",
            'HYPERFLEX.SNAPSHOTINFOBRIEF': "hyperflex.SnapshotInfoBrief",
            'HYPERFLEX.SNAPSHOTPOINT': "hyperflex.SnapshotPoint",
            'HYPERFLEX.SNAPSHOTSTATUS': "hyperflex.SnapshotStatus",
            'HYPERFLEX.STPLATFORMCLUSTERHEALINGINFO': "hyperflex.StPlatformClusterHealingInfo",
            'HYPERFLEX.STPLATFORMCLUSTERRESILIENCYINFO': "hyperflex.StPlatformClusterResiliencyInfo",
            'HYPERFLEX.SUMMARY': "hyperflex.Summary",
            'HYPERFLEX.TRACKEDDISK': "hyperflex.TrackedDisk",
            'HYPERFLEX.TRACKEDFILE': "hyperflex.TrackedFile",
            'HYPERFLEX.VCENTERCONFIGURATION': "hyperflex.VcenterConfiguration",
            'HYPERFLEX.VIRTUALMACHINE': "hyperflex.VirtualMachine",
            'HYPERFLEX.VIRTUALMACHINERUNTIMEINFO': "hyperflex.VirtualMachineRuntimeInfo",
            'HYPERFLEX.VMPROTECTIONSPACEUSAGE': "hyperflex.VmProtectionSpaceUsage",
            'HYPERFLEX.WWXNPREFIXRANGE': "hyperflex.WwxnPrefixRange",
            'I18N.MESSAGE': "i18n.Message",
            'I18N.MESSAGEPARAM': "i18n.MessageParam",
            'IAAS.LICENSEKEYSINFO': "iaas.LicenseKeysInfo",
            'IAAS.LICENSEUTILIZATIONINFO': "iaas.LicenseUtilizationInfo",
            'IAAS.WORKFLOWSTEPS': "iaas.WorkflowSteps",
            'IAM.ACCOUNTPERMISSIONS': "iam.AccountPermissions",
            'IAM.ACCOUNTTAGS': "iam.AccountTags",
            'IAM.BASICAUTHCREDENTIALS': "iam.BasicAuthCredentials",
            'IAM.CLIENTMETA': "iam.ClientMeta",
            'IAM.ENDPOINTPASSWORDPROPERTIES': "iam.EndPointPasswordProperties",
            'IAM.FAILUREDETAILS': "iam.FailureDetails",
            'IAM.FEATUREDEFINITION': "iam.FeatureDefinition",
            'IAM.GROUPPERMISSIONTOROLES': "iam.GroupPermissionToRoles",
            'IAM.LDAPBASEPROPERTIES': "iam.LdapBaseProperties",
            'IAM.LDAPDNSPARAMETERS': "iam.LdapDnsParameters",
            'IAM.PERMISSIONREFERENCE': "iam.PermissionReference",
            'IAM.PERMISSIONTOROLES': "iam.PermissionToRoles",
            'IAM.RESOURCEROLE': "iam.ResourceRole",
            'IAM.RULE': "iam.Rule",
            'IAM.SAMLSPCONNECTION': "iam.SamlSpConnection",
            'IAM.SECURITYCONTEXT': "iam.SecurityContext",
            'IAM.SSOSESSIONATTRIBUTES': "iam.SsoSessionAttributes",
            'IAM.SWITCHACCOUNTPERMISSION': "iam.SwitchAccountPermission",
            'IAM.SWITCHSCOPEPERMISSIONS': "iam.SwitchScopePermissions",
            'IAM.USERDETAILS': "iam.UserDetails",
            'IMCCONNECTOR.WEBUIMESSAGE': "imcconnector.WebUiMessage",
            'INFRA.GPUCONFIGURATION': "infra.GpuConfiguration",
            'INFRA.HARDWAREINFO': "infra.HardwareInfo",
            'INFRA.METADATA': "infra.MetaData",
            'INFRA.MIGGPUCONFIGURATION': "infra.MigGpuConfiguration",
            'INVENTORY.INVENTORYMO': "inventory.InventoryMo",
            'INVENTORY.JOBINFO': "inventory.JobInfo",
            'INVENTORY.UEMINFO': "inventory.UemInfo",
            'IPPOOL.IPV4BLOCK': "ippool.IpV4Block",
            'IPPOOL.IPV4CONFIG': "ippool.IpV4Config",
            'IPPOOL.IPV6BLOCK': "ippool.IpV6Block",
            'IPPOOL.IPV6CONFIG': "ippool.IpV6Config",
            'IPPOOL.RESERVATIONREFERENCE': "ippool.ReservationReference",
            'IQNPOOL.IQNSUFFIXBLOCK': "iqnpool.IqnSuffixBlock",
            'IQNPOOL.RESERVATIONREFERENCE': "iqnpool.ReservationReference",
            'ISSUE.DEVICETAG': "issue.DeviceTag",
            'ISSUE.MESSAGE': "issue.Message",
            'ISSUE.ODATACONDITION': "issue.OdataCondition",
            'KUBERNETES.ACTIONINFO': "kubernetes.ActionInfo",
            'KUBERNETES.ADDON': "kubernetes.Addon",
            'KUBERNETES.ADDONCONFIGURATION': "kubernetes.AddonConfiguration",
            'KUBERNETES.ADDONVERSIONREFERENCE': "kubernetes.AddonVersionReference",
            'KUBERNETES.BAREMETALNETWORKINFO': "kubernetes.BaremetalNetworkInfo",
            'KUBERNETES.CALICOCONFIG': "kubernetes.CalicoConfig",
            'KUBERNETES.CLUSTERCERTIFICATECONFIGURATION': "kubernetes.ClusterCertificateConfiguration",
            'KUBERNETES.CLUSTERMANAGEMENTCONFIG': "kubernetes.ClusterManagementConfig",
            'KUBERNETES.CONFIGURATION': "kubernetes.Configuration",
            'KUBERNETES.DAEMONSETSTATUS': "kubernetes.DaemonSetStatus",
            'KUBERNETES.DEPLOYMENTSTATUS': "kubernetes.DeploymentStatus",
            'KUBERNETES.ESSENTIALADDON': "kubernetes.EssentialAddon",
            'KUBERNETES.ESXIVIRTUALMACHINEINFRACONFIG': "kubernetes.EsxiVirtualMachineInfraConfig",
            'KUBERNETES.ETHERNET': "kubernetes.Ethernet",
            'KUBERNETES.ETHERNETMATCHER': "kubernetes.EthernetMatcher",
            'KUBERNETES.INGRESSSTATUS': "kubernetes.IngressStatus",
            'KUBERNETES.INSTANCETYPEDETAILS': "kubernetes.InstanceTypeDetails",
            'KUBERNETES.IPV4CONFIG': "kubernetes.IpV4Config",
            'KUBERNETES.KEYVALUE': "kubernetes.KeyValue",
            'KUBERNETES.LOADBALANCER': "kubernetes.LoadBalancer",
            'KUBERNETES.NETWORKINTERFACESPEC': "kubernetes.NetworkInterfaceSpec",
            'KUBERNETES.NODEADDRESS': "kubernetes.NodeAddress",
            'KUBERNETES.NODEGROUPLABEL': "kubernetes.NodeGroupLabel",
            'KUBERNETES.NODEGROUPTAINT': "kubernetes.NodeGroupTaint",
            'KUBERNETES.NODEINFO': "kubernetes.NodeInfo",
            'KUBERNETES.NODESPEC': "kubernetes.NodeSpec",
            'KUBERNETES.NODESTATUS': "kubernetes.NodeStatus",
            'KUBERNETES.OBJECTMETA': "kubernetes.ObjectMeta",
            'KUBERNETES.OVSBOND': "kubernetes.OvsBond",
            'KUBERNETES.PODSTATUS': "kubernetes.PodStatus",
            'KUBERNETES.PROXYCONFIG': "kubernetes.ProxyConfig",
            'KUBERNETES.ROUTE': "kubernetes.Route",
            'KUBERNETES.SERVICESTATUS': "kubernetes.ServiceStatus",
            'KUBERNETES.STATEFULSETSTATUS': "kubernetes.StatefulSetStatus",
            'KUBERNETES.TAINT': "kubernetes.Taint",
            'LICENSE.SUBSTITUTELICENSE': "license.SubstituteLicense",
            'MACPOOL.BLOCK': "macpool.Block",
            'MACPOOL.MEMBEROF': "macpool.MemberOf",
            'MACPOOL.RESERVATIONREFERENCE': "macpool.ReservationReference",
            'MARKETPLACE.USECASEAUTOMATION': "marketplace.UseCaseAutomation",
            'MARKETPLACE.USECASEDEPENDENCY': "marketplace.UseCaseDependency",
            'MARKETPLACE.USECASELOCALE': "marketplace.UseCaseLocale",
            'MARKETPLACE.USECASEVERSIONLOCALE': "marketplace.UseCaseVersionLocale",
            'MARKETPLACE.USECASEVERSIONRESOURCE': "marketplace.UseCaseVersionResource",
            'MEMORY.PERSISTENTMEMORYGOAL': "memory.PersistentMemoryGoal",
            'MEMORY.PERSISTENTMEMORYLOCALSECURITY': "memory.PersistentMemoryLocalSecurity",
            'MEMORY.PERSISTENTMEMORYLOGICALNAMESPACE': "memory.PersistentMemoryLogicalNamespace",
            'META.ACCESSPRIVILEGE': "meta.AccessPrivilege",
            'META.DISPLAYNAMEDEFINITION': "meta.DisplayNameDefinition",
            'META.IDENTITYDEFINITION': "meta.IdentityDefinition",
            'META.PROPDEFINITION': "meta.PropDefinition",
            'META.RELATIONSHIPDEFINITION': "meta.RelationshipDefinition",
            'METRICS.METRICCRITERION': "metrics.MetricCriterion",
            'MO.MOREF': "mo.MoRef",
            'MO.TAG': "mo.Tag",
            'MO.VERSIONCONTEXT': "mo.VersionContext",
            'MONITORING.CATEGORYSTATUS': "monitoring.CategoryStatus",
            'MOTEMPLATE.ACTIONENTRY': "motemplate.ActionEntry",
            'MOTEMPLATE.ACTIONPARAM': "motemplate.ActionParam",
            'MOTEMPLATE.SYNCERROR': "motemplate.SyncError",
            'NETWORK.HYPERFLEXINTERNETPROTOCOLADDRESSRANGE': "network.HyperFlexInternetProtocolAddressRange",
            'NETWORK.HYPERFLEXNETWORKADDRESS': "network.HyperFlexNetworkAddress",
            'NIAAPI.DETAIL': "niaapi.Detail",
            'NIAAPI.NEWRELEASEDETAIL': "niaapi.NewReleaseDetail",
            'NIAAPI.REVISIONINFO': "niaapi.RevisionInfo",
            'NIAAPI.SOFTWAREREGEX': "niaapi.SoftwareRegex",
            'NIAAPI.VERSIONREGEXPLATFORM': "niaapi.VersionRegexPlatform",
            'NIATELEMETRY.BOOTFLASHDETAILS': "niatelemetry.BootflashDetails",
            'NIATELEMETRY.CLOUDREGIONSELEMENT': "niatelemetry.CloudRegionsElement",
            'NIATELEMETRY.CLOUDROUTERSELEMENT': "niatelemetry.CloudRoutersElement",
            'NIATELEMETRY.DEPLOYMENTSTATUS': "niatelemetry.DeploymentStatus",
            'NIATELEMETRY.DIGITALOPTICALMONITORING': "niatelemetry.DigitalOpticalMonitoring",
            'NIATELEMETRY.DISKINFO': "niatelemetry.Diskinfo",
            'NIATELEMETRY.DOMINFO': "niatelemetry.DomInfo",
            'NIATELEMETRY.DOMTHRESINFO': "niatelemetry.DomThresInfo",
            'NIATELEMETRY.EQPTSTORAGEFIRMWARE': "niatelemetry.EqptStorageFirmware",
            'NIATELEMETRY.EQPTCAPACITYPOLUSAGE5MIN': "niatelemetry.EqptcapacityPolUsage5min",
            'NIATELEMETRY.EQPTCAPACITYPREFIXENTRIES15MIN': "niatelemetry.EqptcapacityPrefixEntries15min",
            'NIATELEMETRY.EQPTCAPACITYPREFIXENTRIES5MIN': "niatelemetry.EqptcapacityPrefixEntries5min",
            'NIATELEMETRY.FANDETAILS': "niatelemetry.FanDetails",
            'NIATELEMETRY.IMAGEDETAIL': "niatelemetry.ImageDetail",
            'NIATELEMETRY.INTERFACE': "niatelemetry.Interface",
            'NIATELEMETRY.INTERFACEELEMENT': "niatelemetry.InterfaceElement",
            'NIATELEMETRY.JOBDETAIL': "niatelemetry.JobDetail",
            'NIATELEMETRY.LOGICALLINK': "niatelemetry.LogicalLink",
            'NIATELEMETRY.MDSNEIGHBORINFO': "niatelemetry.MdsNeighborInfo",
            'NIATELEMETRY.NETWORKINFO': "niatelemetry.NetworkInfo",
            'NIATELEMETRY.NODE': "niatelemetry.Node",
            'NIATELEMETRY.NVEPACKETCOUNTERS': "niatelemetry.NvePacketCounters",
            'NIATELEMETRY.NVEVNI': "niatelemetry.NveVni",
            'NIATELEMETRY.NXOSBGPEVPN': "niatelemetry.NxosBgpEvpn",
            'NIATELEMETRY.NXOSBGPMVPN': "niatelemetry.NxosBgpMvpn",
            'NIATELEMETRY.NXOSVTP': "niatelemetry.NxosVtp",
            'NIATELEMETRY.PROCSYSCPU15MIN': "niatelemetry.ProcSysCpu15min",
            'NIATELEMETRY.PROCSYSCPU5MIN': "niatelemetry.ProcSysCpu5min",
            'NIATELEMETRY.PROCSYSMEM15MIN': "niatelemetry.ProcSysMem15min",
            'NIATELEMETRY.PROCSYSMEM5MIN': "niatelemetry.ProcSysMem5min",
            'NIATELEMETRY.SITES': "niatelemetry.Sites",
            'NIATELEMETRY.SMARTLICENSE': "niatelemetry.SmartLicense",
            'NIATELEMETRY.SWITCHDISKUTILIZATION': "niatelemetry.SwitchDiskUtilization",
            'NIATELEMETRY.VNISTATUS': "niatelemetry.VniStatus",
            'NIATELEMETRY.VPCDETAILS': "niatelemetry.VpcDetails",
            'NOTIFICATION.AGGREGATIONSETTINGS': "notification.AggregationSettings",
            'NOTIFICATION.ALARMMOCONDITION': "notification.AlarmMoCondition",
            'NOTIFICATION.APPLIANCEUPGRADEMOCONDITION': "notification.ApplianceUpgradeMoCondition",
            'NOTIFICATION.DISTRIBUTABLEMOCONDITION': "notification.DistributableMoCondition",
            'NOTIFICATION.MOCONDITION': "notification.MoCondition",
            'NOTIFICATION.SENDEMAIL': "notification.SendEmail",
            'NOTIFICATION.SIMPLEFILTER': "notification.SimpleFilter",
            'NOTIFICATION.SIMPLEMOCONDITION': "notification.SimpleMoCondition",
            'NOTIFICATION.SOFTWARERELEASEMETAMOCONDITION': "notification.SoftwareReleaseMetaMoCondition",
            'NOTIFICATION.TRIGGERWEBHOOK': "notification.TriggerWebhook",
            'NTP.AUTHNTPSERVER': "ntp.AuthNtpServer",
            'ONPREM.CLUSTERINFO': "onprem.ClusterInfo",
            'ONPREM.CLUSTERNODE': "onprem.ClusterNode",
            'ONPREM.IMAGEPACKAGE': "onprem.ImagePackage",
            'ONPREM.RESOURCEINFO': "onprem.ResourceInfo",
            'ONPREM.SCHEDULE': "onprem.Schedule",
            'ONPREM.UPGRADENOTE': "onprem.UpgradeNote",
            'ONPREM.UPGRADEPHASE': "onprem.UpgradePhase",
            'OPENAPI.APIINFO': "openapi.ApiInfo",
            'OPENAPI.FAILEDTASK': "openapi.FailedTask",
            'OPENAPI.KEYVALUEPAIR': "openapi.KeyValuePair",
            'OPRS.KVPAIR': "oprs.Kvpair",
            'OS.ANSWERS': "os.Answers",
            'OS.FIBRECHANNELRESPONSE': "os.FibreChannelResponse",
            'OS.FIBRECHANNELTARGET': "os.FibreChannelTarget",
            'OS.GLOBALCONFIG': "os.GlobalConfig",
            'OS.IPV4CONFIGURATION': "os.Ipv4Configuration",
            'OS.IPV6CONFIGURATION': "os.Ipv6Configuration",
            'OS.ISCSILUNRESPONSE': "os.IscsiLunResponse",
            'OS.ISCSITARGET': "os.IscsiTarget",
            'OS.PHYSICALDISK': "os.PhysicalDisk",
            'OS.PHYSICALDISKRESPONSE': "os.PhysicalDiskResponse",
            'OS.PLACEHOLDER': "os.PlaceHolder",
            'OS.SERVERCONFIG': "os.ServerConfig",
            'OS.VALIDATIONINFORMATION': "os.ValidationInformation",
            'OS.VIRTUALDRIVE': "os.VirtualDrive",
            'OS.VIRTUALDRIVERESPONSE': "os.VirtualDriveResponse",
            'OS.VMWAREPARAMETERS': "os.VmwareParameters",
            'OS.WINDOWSPARAMETERS': "os.WindowsParameters",
            'PARTNERINTEGRATION.METRICSMODEL': "partnerintegration.MetricsModel",
            'PKIX.DISTINGUISHEDNAME': "pkix.DistinguishedName",
            'PKIX.ECDSAKEYSPEC': "pkix.EcdsaKeySpec",
            'PKIX.EDDSAKEYSPEC': "pkix.EddsaKeySpec",
            'PKIX.RSAALGORITHM': "pkix.RsaAlgorithm",
            'PKIX.SUBJECTALTERNATENAME': "pkix.SubjectAlternateName",
            'POLICY.ACTIONPARAM': "policy.ActionParam",
            'POLICY.ACTIONQUALIFIER': "policy.ActionQualifier",
            'POLICY.CONFIGCHANGE': "policy.ConfigChange",
            'POLICY.CONFIGCHANGECONTEXT': "policy.ConfigChangeContext",
            'POLICY.CONFIGCHANGEDISRUPTIONDETAILTYPE': "policy.ConfigChangeDisruptionDetailType",
            'POLICY.CONFIGCONTEXT': "policy.ConfigContext",
            'POLICY.CONFIGRESULTCONTEXT': "policy.ConfigResultContext",
            'POLICY.POLICYERROR': "policy.PolicyError",
            'POLICY.POLICYSTATUS': "policy.PolicyStatus",
            'POLICY.QUALIFIER': "policy.Qualifier",
            'POLICY.SCHEDULEDACTION': "policy.ScheduledAction",
            'RECOVERY.BACKUPSCHEDULE': "recovery.BackupSchedule",
            'RESOURCE.ADAPTORSRANGEFILTER': "resource.AdaptorsRangeFilter",
            'RESOURCE.BLADEQUALIFIER': "resource.BladeQualifier",
            'RESOURCE.CHASSISANDSLOTQUALIFICATION': "resource.ChassisAndSlotQualification",
            'RESOURCE.CHASSISIDRANGEFILTER': "resource.ChassisIdRangeFilter",
            'RESOURCE.CHASSISSERVERSQUALIFIER': "resource.ChassisServersQualifier",
            'RESOURCE.CPUCORERANGEFILTER': "resource.CpuCoreRangeFilter",
            'RESOURCE.CPUSPEEDRANGEFILTER': "resource.CpuSpeedRangeFilter",
            'RESOURCE.DOMAINQUALIFIER': "resource.DomainQualifier",
            'RESOURCE.GPUCONTROLLERSRANGEFILTER': "resource.GpuControllersRangeFilter",
            'RESOURCE.GPUQUALIFIER': "resource.GpuQualifier",
            'RESOURCE.MEMORYCAPACITYRANGEFILTER': "resource.MemoryCapacityRangeFilter",
            'RESOURCE.MEMORYQUALIFIER': "resource.MemoryQualifier",
            'RESOURCE.MEMORYUNITSRANGEFILTER': "resource.MemoryUnitsRangeFilter",
            'RESOURCE.NETWORKADAPTORQUALIFIER': "resource.NetworkAdaptorQualifier",
            'RESOURCE.ODATARULESETQUALIFIER': "resource.OdataRuleSetQualifier",
            'RESOURCE.PERTYPECOMBINEDSELECTOR': "resource.PerTypeCombinedSelector",
            'RESOURCE.PROCESSORQUALIFIER': "resource.ProcessorQualifier",
            'RESOURCE.RACKIDRANGEFILTER': "resource.RackIdRangeFilter",
            'RESOURCE.RACKSERVERQUALIFIER': "resource.RackServerQualifier",
            'RESOURCE.SELECTOR': "resource.Selector",
            'RESOURCE.SLOTIDRANGEFILTER': "resource.SlotIdRangeFilter",
            'RESOURCE.SOURCETOPERMISSIONRESOURCES': "resource.SourceToPermissionResources",
            'RESOURCE.SOURCETOPERMISSIONRESOURCESHOLDER': "resource.SourceToPermissionResourcesHolder",
            'RESOURCE.TAG': "resource.Tag",
            'RESOURCE.TAGQUALIFIER': "resource.TagQualifier",
            'RESOURCEPOOL.CHILDLEASECONDITION': "resourcepool.ChildLeaseCondition",
            'RESOURCEPOOL.QUALIFICATIONTYPE': "resourcepool.QualificationType",
            'RESOURCEPOOL.RESOURCEEVALUATIONSTATUS': "resourcepool.ResourceEvaluationStatus",
            'RESOURCEPOOL.SERVERLEASEPARAMETERS': "resourcepool.ServerLeaseParameters",
            'RESOURCEPOOL.SERVERPOOLPARAMETERS': "resourcepool.ServerPoolParameters",
            'SCHEDULER.BLOCKDATE': "scheduler.BlockDate",
            'SCHEDULER.DAILYCADENCEPARAMS': "scheduler.DailyCadenceParams",
            'SCHEDULER.EVERYCADENCEPARAMS': "scheduler.EveryCadenceParams",
            'SCHEDULER.MONTHLYCADENCEPARAMS': "scheduler.MonthlyCadenceParams",
            'SCHEDULER.ONETIMESCHEDULEPARAMS': "scheduler.OneTimeScheduleParams",
            'SCHEDULER.RECURRINGSCHEDULEPARAMS': "scheduler.RecurringScheduleParams",
            'SCHEDULER.RESTSTIMTASKREQUEST': "scheduler.RestStimTaskRequest",
            'SCHEDULER.TASKRESULTSTATUS': "scheduler.TaskResultStatus",
            'SCHEDULER.TASKSCHEDULEPOLICYEXECUTIONSTATUS': "scheduler.TaskSchedulePolicyExecutionStatus",
            'SCHEDULER.TASKSCHEDULESTATUS': "scheduler.TaskScheduleStatus",
            'SCHEDULER.WEEKLYCADENCEPARAMS': "scheduler.WeeklyCadenceParams",
            'SDCARD.DIAGNOSTICS': "sdcard.Diagnostics",
            'SDCARD.DRIVERS': "sdcard.Drivers",
            'SDCARD.HOSTUPGRADEUTILITY': "sdcard.HostUpgradeUtility",
            'SDCARD.OPERATINGSYSTEM': "sdcard.OperatingSystem",
            'SDCARD.PARTITION': "sdcard.Partition",
            'SDCARD.SERVERCONFIGURATIONUTILITY': "sdcard.ServerConfigurationUtility",
            'SDCARD.USERPARTITION': "sdcard.UserPartition",
            'SERVER.PENDINGWORKFLOWTRIGGER': "server.PendingWorkflowTrigger",
            'SERVER.SERVERASSIGNTYPESLOT': "server.ServerAssignTypeSlot",
            'SERVICEITEM.HEALTHCHECKERRORELEMENT': "serviceitem.HealthCheckErrorElement",
            'SERVICEITEM.MESSAGE': "serviceitem.Message",
            'SERVICEITEM.SELECTIONCRITERIAINPUT': "serviceitem.SelectionCriteriaInput",
            'SERVICEREQUEST.MESSAGE': "servicerequest.Message",
            'SNMP.TRAP': "snmp.Trap",
            'SNMP.USER': "snmp.User",
            'SOFTWAREREPOSITORY.APPLIANCEUPLOAD': "softwarerepository.ApplianceUpload",
            'SOFTWAREREPOSITORY.CIFSSERVER': "softwarerepository.CifsServer",
            'SOFTWAREREPOSITORY.CONSTRAINTMODELS': "softwarerepository.ConstraintModels",
            'SOFTWAREREPOSITORY.HTTPSERVER': "softwarerepository.HttpServer",
            'SOFTWAREREPOSITORY.IMPORTRESULT': "softwarerepository.ImportResult",
            'SOFTWAREREPOSITORY.LOCALMACHINE': "softwarerepository.LocalMachine",
            'SOFTWAREREPOSITORY.NFSSERVER': "softwarerepository.NfsServer",
            'SOFTWAREREPOSITORY.UNSUPPORTEDMODELCONSTRAINT': "softwarerepository.UnsupportedModelConstraint",
            'STORAGE.AUTOMATICDRIVEGROUP': "storage.AutomaticDriveGroup",
            'STORAGE.EXTERNALLUN': "storage.ExternalLun",
            'STORAGE.EXTERNALPARITYGROUP': "storage.ExternalParityGroup",
            'STORAGE.EXTERNALPATH': "storage.ExternalPath",
            'STORAGE.HITACHIARRAYUTILIZATION': "storage.HitachiArrayUtilization",
            'STORAGE.HITACHICAPACITY': "storage.HitachiCapacity",
            'STORAGE.HITACHIINITIATOR': "storage.HitachiInitiator",
            'STORAGE.HOSTNQN': "storage.HostNqn",
            'STORAGE.HYPERFLEXISCSIINITIATOR': "storage.HyperFlexIscsiInitiator",
            'STORAGE.INITIATOR': "storage.Initiator",
            'STORAGE.INTERNALMOPHYSICALDISKCONFIG': "storage.InternalMoPhysicalDiskConfig",
            'STORAGE.KEYSETTING': "storage.KeySetting",
            'STORAGE.KMIPAUTHCREDENTIALS': "storage.KmipAuthCredentials",
            'STORAGE.KMIPSERVER': "storage.KmipServer",
            'STORAGE.LOCALKEYSETTING': "storage.LocalKeySetting",
            'STORAGE.M2VIRTUALDRIVECONFIG': "storage.M2VirtualDriveConfig",
            'STORAGE.MANUALDRIVEGROUP': "storage.ManualDriveGroup",
            'STORAGE.NAMESPACE': "storage.Namespace",
            'STORAGE.NAMESPACEPATH': "storage.NamespacePath",
            'STORAGE.NETAPPAUTOSUPPORT': "storage.NetAppAutoSupport",
            'STORAGE.NETAPPCIFSACL': "storage.NetAppCifsAcl",
            'STORAGE.NETAPPETHERNETPORTLAG': "storage.NetAppEthernetPortLag",
            'STORAGE.NETAPPETHERNETPORTVLAN': "storage.NetAppEthernetPortVlan",
            'STORAGE.NETAPPEXPORTPOLICYRULE': "storage.NetAppExportPolicyRule",
            'STORAGE.NETAPPHIGHAVAILABILITY': "storage.NetAppHighAvailability",
            'STORAGE.NETAPPPERFORMANCEMETRICSAVERAGE': "storage.NetAppPerformanceMetricsAverage",
            'STORAGE.NETAPPPORT': "storage.NetAppPort",
            'STORAGE.NETAPPSNAPSHOTPOLICYSCHEDULE': "storage.NetAppSnapshotPolicySchedule",
            'STORAGE.NETAPPSTORAGECLUSTEREFFICIENCY': "storage.NetAppStorageClusterEfficiency",
            'STORAGE.NETAPPSTORAGEUTILIZATION': "storage.NetAppStorageUtilization",
            'STORAGE.NVMEDEDICATEDHOTSPARECONFIGURATION': "storage.NvmeDedicatedHotSpareConfiguration",
            'STORAGE.NVMEPHYSICALDISKSTATE': "storage.NvmePhysicalDiskState",
            'STORAGE.NVMERAIDDRIVEGROUP': "storage.NvmeRaidDriveGroup",
            'STORAGE.NVMEVIRTUALDRIVECONFIGURATION': "storage.NvmeVirtualDriveConfiguration",
            'STORAGE.PUREARRAYUTILIZATION': "storage.PureArrayUtilization",
            'STORAGE.PUREDISKUTILIZATION': "storage.PureDiskUtilization",
            'STORAGE.PUREHOSTUTILIZATION': "storage.PureHostUtilization",
            'STORAGE.PUREREPLICATIONBLACKOUT': "storage.PureReplicationBlackout",
            'STORAGE.PUREVOLUMEUTILIZATION': "storage.PureVolumeUtilization",
            'STORAGE.R0DRIVE': "storage.R0Drive",
            'STORAGE.REMOTEKEYSETTING': "storage.RemoteKeySetting",
            'STORAGE.SPACE': "storage.Space",
            'STORAGE.SPANDRIVES': "storage.SpanDrives",
            'STORAGE.STORAGECONTAINERHOSTMOUNTSTATUS': "storage.StorageContainerHostMountStatus",
            'STORAGE.STORAGECONTAINERUTILIZATION': "storage.StorageContainerUtilization",
            'STORAGE.VIRTUALDRIVECONFIGURATION': "storage.VirtualDriveConfiguration",
            'STORAGE.VIRTUALDRIVEPOLICY': "storage.VirtualDrivePolicy",
            'STORAGE.VOLUMEUTILIZATION': "storage.VolumeUtilization",
            'SYSLOG.LOCALFILELOGGINGCLIENT': "syslog.LocalFileLoggingClient",
            'SYSLOG.REMOTELOGGINGCLIENT': "syslog.RemoteLoggingClient",
            'TAM.ACTION': "tam.Action",
            'TAM.APIDATASOURCE': "tam.ApiDataSource",
            'TAM.EOLADVISORYDETAILS': "tam.EolAdvisoryDetails",
            'TAM.EOLSEVERITY': "tam.EolSeverity",
            'TAM.FNSEVERITY': "tam.FnSeverity",
            'TAM.IDENTIFIERS': "tam.Identifiers",
            'TAM.MILESTONE': "tam.Milestone",
            'TAM.PSIRTSEVERITY': "tam.PsirtSeverity",
            'TAM.QUERYENTRY': "tam.QueryEntry",
            'TAM.S3DATASOURCE': "tam.S3DataSource",
            'TAM.SECURITYADVISORYDETAILS': "tam.SecurityAdvisoryDetails",
            'TAM.TEXTFSMTEMPLATEDATASOURCE': "tam.TextFsmTemplateDataSource",
            'TASK.FILEDOWNLOADINFO': "task.FileDownloadInfo",
            'TECHSUPPORTMANAGEMENT.APPLIANCEPARAM': "techsupportmanagement.ApplianceParam",
            'TECHSUPPORTMANAGEMENT.NIAPARAM': "techsupportmanagement.NiaParam",
            'TECHSUPPORTMANAGEMENT.PLATFORMPARAM': "techsupportmanagement.PlatformParam",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTFILEINFO': "techsupportmanagement.TechSupportFileInfo",
            'TEMPLATE.TRANSFORMATIONSTAGE': "template.TransformationStage",
            'UCSD.CONNECTORPACK': "ucsd.ConnectorPack",
            'UCSD.UCSDRESTOREPARAMETERS': "ucsd.UcsdRestoreParameters",
            'UCSDCONNECTOR.RESTCLIENTMESSAGE': "ucsdconnector.RestClientMessage",
            'UUIDPOOL.RESERVATIONREFERENCE': "uuidpool.ReservationReference",
            'UUIDPOOL.UUIDBLOCK': "uuidpool.UuidBlock",
            'VIRTUALIZATION.ACTIONINFO': "virtualization.ActionInfo",
            'VIRTUALIZATION.CLOUDINITCONFIG': "virtualization.CloudInitConfig",
            'VIRTUALIZATION.COMPUTECAPACITY': "virtualization.ComputeCapacity",
            'VIRTUALIZATION.CPUINFO': "virtualization.CpuInfo",
            'VIRTUALIZATION.ESXICLONECUSTOMSPEC': "virtualization.EsxiCloneCustomSpec",
            'VIRTUALIZATION.ESXIHOSTCONFIGURATION': "virtualization.EsxiHostConfiguration",
            'VIRTUALIZATION.ESXIOVACUSTOMSPEC': "virtualization.EsxiOvaCustomSpec",
            'VIRTUALIZATION.ESXIVMCOMPUTECONFIGURATION': "virtualization.EsxiVmComputeConfiguration",
            'VIRTUALIZATION.ESXIVMCONFIGURATION': "virtualization.EsxiVmConfiguration",
            'VIRTUALIZATION.ESXIVMNETWORKCONFIGURATION': "virtualization.EsxiVmNetworkConfiguration",
            'VIRTUALIZATION.ESXIVMSTORAGECONFIGURATION': "virtualization.EsxiVmStorageConfiguration",
            'VIRTUALIZATION.GUESTINFO': "virtualization.GuestInfo",
            'VIRTUALIZATION.MEMORYCAPACITY': "virtualization.MemoryCapacity",
            'VIRTUALIZATION.NETWORKINTERFACE': "virtualization.NetworkInterface",
            'VIRTUALIZATION.PRODUCTINFO': "virtualization.ProductInfo",
            'VIRTUALIZATION.STORAGECAPACITY': "virtualization.StorageCapacity",
            'VIRTUALIZATION.VIRTUALMACHINEDISK': "virtualization.VirtualMachineDisk",
            'VIRTUALIZATION.VMESXIDISK': "virtualization.VmEsxiDisk",
            'VIRTUALIZATION.VMWAREATTACHEDRESOURCETAG': "virtualization.VmwareAttachedResourceTag",
            'VIRTUALIZATION.VMWAREDISCOVERYPROTOCOL': "virtualization.VmwareDiscoveryProtocol",
            'VIRTUALIZATION.VMWAREREMOTEDISPLAYINFO': "virtualization.VmwareRemoteDisplayInfo",
            'VIRTUALIZATION.VMWARERESOURCEALLOCATIONSYSTEMTRAFFICTYPES': "virtualization.VmwareResourceAllocationSystemTrafficTypes",
            'VIRTUALIZATION.VMWARERESOURCECONSUMPTION': "virtualization.VmwareResourceConsumption",
            'VIRTUALIZATION.VMWARESHARESINFO': "virtualization.VmwareSharesInfo",
            'VIRTUALIZATION.VMWARETEAMINGANDFAILOVER': "virtualization.VmwareTeamingAndFailover",
            'VIRTUALIZATION.VMWAREVLANRANGE': "virtualization.VmwareVlanRange",
            'VIRTUALIZATION.VMWAREVMCPUSHAREINFO': "virtualization.VmwareVmCpuShareInfo",
            'VIRTUALIZATION.VMWAREVMCPUSOCKETINFO': "virtualization.VmwareVmCpuSocketInfo",
            'VIRTUALIZATION.VMWAREVMDISKCOMMITINFO': "virtualization.VmwareVmDiskCommitInfo",
            'VIRTUALIZATION.VMWAREVMMEMORYSHAREINFO': "virtualization.VmwareVmMemoryShareInfo",
            'VMEDIA.MAPPING': "vmedia.Mapping",
            'VNIC.ARFSSETTINGS': "vnic.ArfsSettings",
            'VNIC.CDN': "vnic.Cdn",
            'VNIC.COMPLETIONQUEUESETTINGS': "vnic.CompletionQueueSettings",
            'VNIC.ETHIFOLDINFO': "vnic.EthIfOldInfo",
            'VNIC.ETHINTERRUPTSETTINGS': "vnic.EthInterruptSettings",
            'VNIC.ETHRXQUEUESETTINGS': "vnic.EthRxQueueSettings",
            'VNIC.ETHTXQUEUESETTINGS': "vnic.EthTxQueueSettings",
            'VNIC.FCERRORRECOVERYSETTINGS': "vnic.FcErrorRecoverySettings",
            'VNIC.FCIFOLDINFO': "vnic.FcIfOldInfo",
            'VNIC.FCINTERRUPTSETTINGS': "vnic.FcInterruptSettings",
            'VNIC.FCQUEUESETTINGS': "vnic.FcQueueSettings",
            'VNIC.FLOGISETTINGS': "vnic.FlogiSettings",
            'VNIC.ISCSIAUTHPROFILE': "vnic.IscsiAuthProfile",
            'VNIC.LUN': "vnic.Lun",
            'VNIC.NVGRESETTINGS': "vnic.NvgreSettings",
            'VNIC.PLACEMENTSETTINGS': "vnic.PlacementSettings",
            'VNIC.PLOGISETTINGS': "vnic.PlogiSettings",
            'VNIC.PTPSETTINGS': "vnic.PtpSettings",
            'VNIC.ROCESETTINGS': "vnic.RoceSettings",
            'VNIC.RSSHASHSETTINGS': "vnic.RssHashSettings",
            'VNIC.SANSETTINGSOLDINFO': "vnic.SanSettingsOldInfo",
            'VNIC.SCSIQUEUESETTINGS': "vnic.ScsiQueueSettings",
            'VNIC.SRIOVSETTINGS': "vnic.SriovSettings",
            'VNIC.TCPOFFLOADSETTINGS': "vnic.TcpOffloadSettings",
            'VNIC.USNICSETTINGS': "vnic.UsnicSettings",
            'VNIC.VIFSTATUS': "vnic.VifStatus",
            'VNIC.VLANSETTINGS': "vnic.VlanSettings",
            'VNIC.VMQSETTINGS': "vnic.VmqSettings",
            'VNIC.VSANSETTINGS': "vnic.VsanSettings",
            'VNIC.VXLANSETTINGS': "vnic.VxlanSettings",
            'WORKFLOW.ANSIBLEPLAYSESSION': "workflow.AnsiblePlaySession",
            'WORKFLOW.ARRAYDATATYPE': "workflow.ArrayDataType",
            'WORKFLOW.ASSOCIATEDROLES': "workflow.AssociatedRoles",
            'WORKFLOW.CANCELABLETYPE': "workflow.CancelableType",
            'WORKFLOW.CLICOMMAND': "workflow.CliCommand",
            'WORKFLOW.COMMENTS': "workflow.Comments",
            'WORKFLOW.CONSTRAINTS': "workflow.Constraints",
            'WORKFLOW.CUSTOMARRAYITEM': "workflow.CustomArrayItem",
            'WORKFLOW.CUSTOMDATAPROPERTY': "workflow.CustomDataProperty",
            'WORKFLOW.CUSTOMDATATYPE': "workflow.CustomDataType",
            'WORKFLOW.CUSTOMDATATYPEPROPERTIES': "workflow.CustomDataTypeProperties",
            'WORKFLOW.DATASOURCESELECTOR': "workflow.DataSourceSelector",
            'WORKFLOW.DECISIONCASE': "workflow.DecisionCase",
            'WORKFLOW.DECISIONTASK': "workflow.DecisionTask",
            'WORKFLOW.DEFAULTVALUE': "workflow.DefaultValue",
            'WORKFLOW.DISPLAYMETA': "workflow.DisplayMeta",
            'WORKFLOW.DYNAMICTEMPLATEPARSERDATATYPE': "workflow.DynamicTemplateParserDataType",
            'WORKFLOW.ENUMENTRY': "workflow.EnumEntry",
            'WORKFLOW.ENVIRONMENTVARIABLEREFERENCE': "workflow.EnvironmentVariableReference",
            'WORKFLOW.EXPECTPROMPT': "workflow.ExpectPrompt",
            'WORKFLOW.FAILUREENDTASK': "workflow.FailureEndTask",
            'WORKFLOW.FILEDOWNLOADOP': "workflow.FileDownloadOp",
            'WORKFLOW.FILEOPERATIONS': "workflow.FileOperations",
            'WORKFLOW.FILETEMPLATEOP': "workflow.FileTemplateOp",
            'WORKFLOW.FILETRANSFER': "workflow.FileTransfer",
            'WORKFLOW.FORKTASK': "workflow.ForkTask",
            'WORKFLOW.INITIATORCONTEXT': "workflow.InitiatorContext",
            'WORKFLOW.INTERNALPROPERTIES': "workflow.InternalProperties",
            'WORKFLOW.JOINTASK': "workflow.JoinTask",
            'WORKFLOW.LOOPTASK': "workflow.LoopTask",
            'WORKFLOW.MESSAGE': "workflow.Message",
            'WORKFLOW.MIGRATESERVICEITEMACTIONPROPERTY': "workflow.MigrateServiceItemActionProperty",
            'WORKFLOW.MIGRATIONHISTORY': "workflow.MigrationHistory",
            'WORKFLOW.MOINVENTORYDATATYPE': "workflow.MoInventoryDataType",
            'WORKFLOW.MOINVENTORYPROPERTY': "workflow.MoInventoryProperty",
            'WORKFLOW.MOREFERENCEARRAYITEM': "workflow.MoReferenceArrayItem",
            'WORKFLOW.MOREFERENCEAUTOARRAYITEM': "workflow.MoReferenceAutoArrayItem",
            'WORKFLOW.MOREFERENCEAUTODATATYPE': "workflow.MoReferenceAutoDataType",
            'WORKFLOW.MOREFERENCEAUTOPROPERTY': "workflow.MoReferenceAutoProperty",
            'WORKFLOW.MOREFERENCEDATATYPE': "workflow.MoReferenceDataType",
            'WORKFLOW.MOREFERENCEFORCLONEDATATYPE': "workflow.MoReferenceForCloneDataType",
            'WORKFLOW.MOREFERENCEPROPERTY': "workflow.MoReferenceProperty",
            'WORKFLOW.OPERATIONTYPEDECOMMISSION': "workflow.OperationTypeDecommission",
            'WORKFLOW.OPERATIONTYPEDEPLOYMENT': "workflow.OperationTypeDeployment",
            'WORKFLOW.OPERATIONTYPEPOSTDEPLOYMENT': "workflow.OperationTypePostDeployment",
            'WORKFLOW.PARAMETERSET': "workflow.ParameterSet",
            'WORKFLOW.POWERSHELLAPI': "workflow.PowerShellApi",
            'WORKFLOW.PRIMITIVEARRAYITEM': "workflow.PrimitiveArrayItem",
            'WORKFLOW.PRIMITIVEDATAPROPERTY': "workflow.PrimitiveDataProperty",
            'WORKFLOW.PRIMITIVEDATATYPE': "workflow.PrimitiveDataType",
            'WORKFLOW.PROPERTIES': "workflow.Properties",
            'WORKFLOW.RESOURCEINLINESELECTOR': "workflow.ResourceInlineSelector",
            'WORKFLOW.RESOURCESELECTORCRITERIA': "workflow.ResourceSelectorCriteria",
            'WORKFLOW.RESULTHANDLER': "workflow.ResultHandler",
            'WORKFLOW.ROLLBACKTASK': "workflow.RollbackTask",
            'WORKFLOW.ROLLBACKWORKFLOWTASK': "workflow.RollbackWorkflowTask",
            'WORKFLOW.SELECTORPROPERTY': "workflow.SelectorProperty",
            'WORKFLOW.SEQUENCEPARAMS': "workflow.SequenceParams",
            'WORKFLOW.SERIALLOOPTASK': "workflow.SerialLoopTask",
            'WORKFLOW.SERVICEITEMACTIONPROPERTIES': "workflow.ServiceItemActionProperties",
            'WORKFLOW.SERVICEITEMACTIONWORKFLOWDEFINITION': "workflow.ServiceItemActionWorkflowDefinition",
            'WORKFLOW.SERVICEITEMINPUTDEFINITIONTYPE': "workflow.ServiceItemInputDefinitionType",
            'WORKFLOW.SERVICEITEMTYPE': "workflow.ServiceItemType",
            'WORKFLOW.SSHCMD': "workflow.SshCmd",
            'WORKFLOW.SSHCONFIG': "workflow.SshConfig",
            'WORKFLOW.SSHSESSION': "workflow.SshSession",
            'WORKFLOW.STARTTASK': "workflow.StartTask",
            'WORKFLOW.SUBWORKFLOWTASK': "workflow.SubWorkflowTask",
            'WORKFLOW.SUCCESSENDTASK': "workflow.SuccessEndTask",
            'WORKFLOW.TARGETCONTEXT': "workflow.TargetContext",
            'WORKFLOW.TARGETDATATYPE': "workflow.TargetDataType",
            'WORKFLOW.TARGETPROPERTY': "workflow.TargetProperty",
            'WORKFLOW.TASKCONSTRAINTS': "workflow.TaskConstraints",
            'WORKFLOW.TASKINFOUPDATE': "workflow.TaskInfoUpdate",
            'WORKFLOW.TASKLOOPINFO': "workflow.TaskLoopInfo",
            'WORKFLOW.TASKRETRYINFO': "workflow.TaskRetryInfo",
            'WORKFLOW.UIFORMCONFIG': "workflow.UiFormConfig",
            'WORKFLOW.UIINPUTFILTER': "workflow.UiInputFilter",
            'WORKFLOW.UIVIEWCONFIG': "workflow.UiViewConfig",
            'WORKFLOW.VALIDATIONERROR': "workflow.ValidationError",
            'WORKFLOW.VALIDATIONINFORMATION': "workflow.ValidationInformation",
            'WORKFLOW.WAITTASK': "workflow.WaitTask",
            'WORKFLOW.WAITTASKPROMPT': "workflow.WaitTaskPrompt",
            'WORKFLOW.WEBAPI': "workflow.WebApi",
            'WORKFLOW.WORKERTASK': "workflow.WorkerTask",
            'WORKFLOW.WORKFLOWCTX': "workflow.WorkflowCtx",
            'WORKFLOW.WORKFLOWENGINEPROPERTIES': "workflow.WorkflowEngineProperties",
            'WORKFLOW.WORKFLOWINFOAUTORESTARTPROPERTIES': "workflow.WorkflowInfoAutoRestartProperties",
            'WORKFLOW.WORKFLOWINFOPROPERTIES': "workflow.WorkflowInfoProperties",
            'WORKFLOW.WORKFLOWPROPERTIES': "workflow.WorkflowProperties",
            'WORKFLOW.XMLAPI': "workflow.XmlApi",
            'WORKLOAD.ASSIGNEDRESOURCE': "workload.AssignedResource",
            'WORKLOAD.BATCHDEPLOYMENT': "workload.BatchDeployment",
            'WORKLOAD.BLUEPRINTINPUTREFERENCE': "workload.BlueprintInputReference",
            'WORKLOAD.BLUEPRINTREFERENCE': "workload.BlueprintReference",
            'WORKLOAD.CANARYDEPLOYMENT': "workload.CanaryDeployment",
            'WORKLOAD.CLONESTATUS': "workload.CloneStatus",
            'WORKLOAD.CLONESTATUSENTRY': "workload.CloneStatusEntry",
            'WORKLOAD.DEFINITIONMAPPER': "workload.DefinitionMapper",
            'WORKLOAD.DEPLOYMENTBLUEPRINTINPUTTYPE': "workload.DeploymentBlueprintInputType",
            'WORKLOAD.DEPLOYMENTCHANGEDETAIL': "workload.DeploymentChangeDetail",
            'WORKLOAD.GENERATEDOBJECT': "workload.GeneratedObject",
            'WORKLOAD.RESOURCECONSTRAINT': "workload.ResourceConstraint",
            'WORKLOAD.STATEAGGREGATION': "workload.StateAggregation",
            'X509.CERTIFICATE': "x509.Certificate",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = True

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'notification.AbstractMoCondition': NotificationAbstractMoCondition,
            'notification.AlarmMoCondition': NotificationAlarmMoCondition,
            'notification.ApplianceUpgradeMoCondition': NotificationApplianceUpgradeMoCondition,
            'notification.DistributableMoCondition': NotificationDistributableMoCondition,
            'notification.MoCondition': NotificationMoCondition,
            'notification.SimpleMoCondition': NotificationSimpleMoCondition,
            'notification.SoftwareReleaseMetaMoCondition': NotificationSoftwareReleaseMetaMoCondition,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, class_id, object_type, *args, **kwargs):  # noqa: E501
        """NotificationAbstractCondition - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """NotificationAbstractCondition - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              MoBaseComplexType,
          ],
          'oneOf': [
          ],
        }
