"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.access_policy_inventory import AccessPolicyInventory
    from intersight.model.certificatemanagement_policy_inventory import CertificatemanagementPolicyInventory
    from intersight.model.display_names import DisplayNames
    from intersight.model.fabric_eth_network_control_policy_inventory import FabricEthNetworkControlPolicyInventory
    from intersight.model.fabric_eth_network_group_policy_inventory import FabricEthNetworkGroupPolicyInventory
    from intersight.model.firmware_firmware_summary import FirmwareFirmwareSummary
    from intersight.model.iam_end_point_user_policy_inventory import IamEndPointUserPolicyInventory
    from intersight.model.ipmioverlan_policy_inventory import IpmioverlanPolicyInventory
    from intersight.model.kvm_policy_inventory import KvmPolicyInventory
    from intersight.model.memory_policy_inventory import MemoryPolicyInventory
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.networkconfig_policy_inventory import NetworkconfigPolicyInventory
    from intersight.model.policy_abstract_inventory import PolicyAbstractInventory
    from intersight.model.policy_abstract_policy_inventory_all_of import PolicyAbstractPolicyInventoryAllOf
    from intersight.model.power_policy_inventory import PowerPolicyInventory
    from intersight.model.sdcard_policy_inventory import SdcardPolicyInventory
    from intersight.model.snmp_policy_inventory import SnmpPolicyInventory
    from intersight.model.sol_policy_inventory import SolPolicyInventory
    from intersight.model.ssh_policy_inventory import SshPolicyInventory
    from intersight.model.syslog_policy_inventory import SyslogPolicyInventory
    from intersight.model.thermal_policy_inventory import ThermalPolicyInventory
    from intersight.model.vmedia_policy_inventory import VmediaPolicyInventory
    from intersight.model.vnic_eth_adapter_policy_inventory import VnicEthAdapterPolicyInventory
    from intersight.model.vnic_eth_network_policy_inventory import VnicEthNetworkPolicyInventory
    from intersight.model.vnic_eth_qos_policy_inventory import VnicEthQosPolicyInventory
    from intersight.model.vnic_fc_adapter_policy_inventory import VnicFcAdapterPolicyInventory
    from intersight.model.vnic_fc_network_policy_inventory import VnicFcNetworkPolicyInventory
    from intersight.model.vnic_fc_qos_policy_inventory import VnicFcQosPolicyInventory
    from intersight.model.vnic_iscsi_adapter_policy_inventory import VnicIscsiAdapterPolicyInventory
    from intersight.model.vnic_iscsi_boot_policy_inventory import VnicIscsiBootPolicyInventory
    from intersight.model.vnic_iscsi_static_target_policy_inventory import VnicIscsiStaticTargetPolicyInventory
    from intersight.model.vnic_lan_connectivity_policy_inventory import VnicLanConnectivityPolicyInventory
    from intersight.model.vnic_san_connectivity_policy_inventory import VnicSanConnectivityPolicyInventory
    globals()['AccessPolicyInventory'] = AccessPolicyInventory
    globals()['CertificatemanagementPolicyInventory'] = CertificatemanagementPolicyInventory
    globals()['DisplayNames'] = DisplayNames
    globals()['FabricEthNetworkControlPolicyInventory'] = FabricEthNetworkControlPolicyInventory
    globals()['FabricEthNetworkGroupPolicyInventory'] = FabricEthNetworkGroupPolicyInventory
    globals()['FirmwareFirmwareSummary'] = FirmwareFirmwareSummary
    globals()['IamEndPointUserPolicyInventory'] = IamEndPointUserPolicyInventory
    globals()['IpmioverlanPolicyInventory'] = IpmioverlanPolicyInventory
    globals()['KvmPolicyInventory'] = KvmPolicyInventory
    globals()['MemoryPolicyInventory'] = MemoryPolicyInventory
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['NetworkconfigPolicyInventory'] = NetworkconfigPolicyInventory
    globals()['PolicyAbstractInventory'] = PolicyAbstractInventory
    globals()['PolicyAbstractPolicyInventoryAllOf'] = PolicyAbstractPolicyInventoryAllOf
    globals()['PowerPolicyInventory'] = PowerPolicyInventory
    globals()['SdcardPolicyInventory'] = SdcardPolicyInventory
    globals()['SnmpPolicyInventory'] = SnmpPolicyInventory
    globals()['SolPolicyInventory'] = SolPolicyInventory
    globals()['SshPolicyInventory'] = SshPolicyInventory
    globals()['SyslogPolicyInventory'] = SyslogPolicyInventory
    globals()['ThermalPolicyInventory'] = ThermalPolicyInventory
    globals()['VmediaPolicyInventory'] = VmediaPolicyInventory
    globals()['VnicEthAdapterPolicyInventory'] = VnicEthAdapterPolicyInventory
    globals()['VnicEthNetworkPolicyInventory'] = VnicEthNetworkPolicyInventory
    globals()['VnicEthQosPolicyInventory'] = VnicEthQosPolicyInventory
    globals()['VnicFcAdapterPolicyInventory'] = VnicFcAdapterPolicyInventory
    globals()['VnicFcNetworkPolicyInventory'] = VnicFcNetworkPolicyInventory
    globals()['VnicFcQosPolicyInventory'] = VnicFcQosPolicyInventory
    globals()['VnicIscsiAdapterPolicyInventory'] = VnicIscsiAdapterPolicyInventory
    globals()['VnicIscsiBootPolicyInventory'] = VnicIscsiBootPolicyInventory
    globals()['VnicIscsiStaticTargetPolicyInventory'] = VnicIscsiStaticTargetPolicyInventory
    globals()['VnicLanConnectivityPolicyInventory'] = VnicLanConnectivityPolicyInventory
    globals()['VnicSanConnectivityPolicyInventory'] = VnicSanConnectivityPolicyInventory


class PolicyAbstractPolicyInventory(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'ACCESS.POLICYINVENTORY': "access.PolicyInventory",
            'CERTIFICATEMANAGEMENT.POLICYINVENTORY': "certificatemanagement.PolicyInventory",
            'FABRIC.ETHNETWORKCONTROLPOLICYINVENTORY': "fabric.EthNetworkControlPolicyInventory",
            'FABRIC.ETHNETWORKGROUPPOLICYINVENTORY': "fabric.EthNetworkGroupPolicyInventory",
            'FIRMWARE.FIRMWARESUMMARY': "firmware.FirmwareSummary",
            'IAM.ENDPOINTUSERPOLICYINVENTORY': "iam.EndPointUserPolicyInventory",
            'IPMIOVERLAN.POLICYINVENTORY': "ipmioverlan.PolicyInventory",
            'KVM.POLICYINVENTORY': "kvm.PolicyInventory",
            'MEMORY.POLICYINVENTORY': "memory.PolicyInventory",
            'NETWORKCONFIG.POLICYINVENTORY': "networkconfig.PolicyInventory",
            'POWER.POLICYINVENTORY': "power.PolicyInventory",
            'SDCARD.POLICYINVENTORY': "sdcard.PolicyInventory",
            'SNMP.POLICYINVENTORY': "snmp.PolicyInventory",
            'SOL.POLICYINVENTORY': "sol.PolicyInventory",
            'SSH.POLICYINVENTORY': "ssh.PolicyInventory",
            'SYSLOG.POLICYINVENTORY': "syslog.PolicyInventory",
            'THERMAL.POLICYINVENTORY': "thermal.PolicyInventory",
            'VMEDIA.POLICYINVENTORY': "vmedia.PolicyInventory",
            'VNIC.ETHADAPTERPOLICYINVENTORY': "vnic.EthAdapterPolicyInventory",
            'VNIC.ETHNETWORKPOLICYINVENTORY': "vnic.EthNetworkPolicyInventory",
            'VNIC.ETHQOSPOLICYINVENTORY': "vnic.EthQosPolicyInventory",
            'VNIC.FCADAPTERPOLICYINVENTORY': "vnic.FcAdapterPolicyInventory",
            'VNIC.FCNETWORKPOLICYINVENTORY': "vnic.FcNetworkPolicyInventory",
            'VNIC.FCQOSPOLICYINVENTORY': "vnic.FcQosPolicyInventory",
            'VNIC.ISCSIADAPTERPOLICYINVENTORY': "vnic.IscsiAdapterPolicyInventory",
            'VNIC.ISCSIBOOTPOLICYINVENTORY': "vnic.IscsiBootPolicyInventory",
            'VNIC.ISCSISTATICTARGETPOLICYINVENTORY': "vnic.IscsiStaticTargetPolicyInventory",
            'VNIC.LANCONNECTIVITYPOLICYINVENTORY': "vnic.LanConnectivityPolicyInventory",
            'VNIC.SANCONNECTIVITYPOLICYINVENTORY': "vnic.SanConnectivityPolicyInventory",
        },
        ('object_type',): {
            'ACCESS.POLICYINVENTORY': "access.PolicyInventory",
            'CERTIFICATEMANAGEMENT.POLICYINVENTORY': "certificatemanagement.PolicyInventory",
            'FABRIC.ETHNETWORKCONTROLPOLICYINVENTORY': "fabric.EthNetworkControlPolicyInventory",
            'FABRIC.ETHNETWORKGROUPPOLICYINVENTORY': "fabric.EthNetworkGroupPolicyInventory",
            'FIRMWARE.FIRMWARESUMMARY': "firmware.FirmwareSummary",
            'IAM.ENDPOINTUSERPOLICYINVENTORY': "iam.EndPointUserPolicyInventory",
            'IPMIOVERLAN.POLICYINVENTORY': "ipmioverlan.PolicyInventory",
            'KVM.POLICYINVENTORY': "kvm.PolicyInventory",
            'MEMORY.POLICYINVENTORY': "memory.PolicyInventory",
            'NETWORKCONFIG.POLICYINVENTORY': "networkconfig.PolicyInventory",
            'POWER.POLICYINVENTORY': "power.PolicyInventory",
            'SDCARD.POLICYINVENTORY': "sdcard.PolicyInventory",
            'SNMP.POLICYINVENTORY': "snmp.PolicyInventory",
            'SOL.POLICYINVENTORY': "sol.PolicyInventory",
            'SSH.POLICYINVENTORY': "ssh.PolicyInventory",
            'SYSLOG.POLICYINVENTORY': "syslog.PolicyInventory",
            'THERMAL.POLICYINVENTORY': "thermal.PolicyInventory",
            'VMEDIA.POLICYINVENTORY': "vmedia.PolicyInventory",
            'VNIC.ETHADAPTERPOLICYINVENTORY': "vnic.EthAdapterPolicyInventory",
            'VNIC.ETHNETWORKPOLICYINVENTORY': "vnic.EthNetworkPolicyInventory",
            'VNIC.ETHQOSPOLICYINVENTORY': "vnic.EthQosPolicyInventory",
            'VNIC.FCADAPTERPOLICYINVENTORY': "vnic.FcAdapterPolicyInventory",
            'VNIC.FCNETWORKPOLICYINVENTORY': "vnic.FcNetworkPolicyInventory",
            'VNIC.FCQOSPOLICYINVENTORY': "vnic.FcQosPolicyInventory",
            'VNIC.ISCSIADAPTERPOLICYINVENTORY': "vnic.IscsiAdapterPolicyInventory",
            'VNIC.ISCSIBOOTPOLICYINVENTORY': "vnic.IscsiBootPolicyInventory",
            'VNIC.ISCSISTATICTARGETPOLICYINVENTORY': "vnic.IscsiStaticTargetPolicyInventory",
            'VNIC.LANCONNECTIVITYPOLICYINVENTORY': "vnic.LanConnectivityPolicyInventory",
            'VNIC.SANCONNECTIVITYPOLICYINVENTORY': "vnic.SanConnectivityPolicyInventory",
        },
    }

    validations = {
        ('description',): {
            'max_length': 1024,
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9]+[\sa-zA-Z0-9_\'.:-]*$',  # noqa: E501
            },
        },
        ('name',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9_.:-]{1,512}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'device_mo_id': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'access.PolicyInventory': AccessPolicyInventory,
            'certificatemanagement.PolicyInventory': CertificatemanagementPolicyInventory,
            'fabric.EthNetworkControlPolicyInventory': FabricEthNetworkControlPolicyInventory,
            'fabric.EthNetworkGroupPolicyInventory': FabricEthNetworkGroupPolicyInventory,
            'firmware.FirmwareSummary': FirmwareFirmwareSummary,
            'iam.EndPointUserPolicyInventory': IamEndPointUserPolicyInventory,
            'ipmioverlan.PolicyInventory': IpmioverlanPolicyInventory,
            'kvm.PolicyInventory': KvmPolicyInventory,
            'memory.PolicyInventory': MemoryPolicyInventory,
            'networkconfig.PolicyInventory': NetworkconfigPolicyInventory,
            'power.PolicyInventory': PowerPolicyInventory,
            'sdcard.PolicyInventory': SdcardPolicyInventory,
            'snmp.PolicyInventory': SnmpPolicyInventory,
            'sol.PolicyInventory': SolPolicyInventory,
            'ssh.PolicyInventory': SshPolicyInventory,
            'syslog.PolicyInventory': SyslogPolicyInventory,
            'thermal.PolicyInventory': ThermalPolicyInventory,
            'vmedia.PolicyInventory': VmediaPolicyInventory,
            'vnic.EthAdapterPolicyInventory': VnicEthAdapterPolicyInventory,
            'vnic.EthNetworkPolicyInventory': VnicEthNetworkPolicyInventory,
            'vnic.EthQosPolicyInventory': VnicEthQosPolicyInventory,
            'vnic.FcAdapterPolicyInventory': VnicFcAdapterPolicyInventory,
            'vnic.FcNetworkPolicyInventory': VnicFcNetworkPolicyInventory,
            'vnic.FcQosPolicyInventory': VnicFcQosPolicyInventory,
            'vnic.IscsiAdapterPolicyInventory': VnicIscsiAdapterPolicyInventory,
            'vnic.IscsiBootPolicyInventory': VnicIscsiBootPolicyInventory,
            'vnic.IscsiStaticTargetPolicyInventory': VnicIscsiStaticTargetPolicyInventory,
            'vnic.LanConnectivityPolicyInventory': VnicLanConnectivityPolicyInventory,
            'vnic.SanConnectivityPolicyInventory': VnicSanConnectivityPolicyInventory,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'device_mo_id': 'DeviceMoId',  # noqa: E501
    }

    read_only_vars = {
        'description',  # noqa: E501
        'name',  # noqa: E501
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
        'device_mo_id',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, class_id, object_type, *args, **kwargs):  # noqa: E501
        """PolicyAbstractPolicyInventory - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str): Description of the policy.. [optional]  # noqa: E501
            name (str): Name of the inventoried policy object.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): Device ID of the entity from where inventory is reported.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """PolicyAbstractPolicyInventory - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str): Description of the policy.. [optional]  # noqa: E501
            name (str): Name of the inventoried policy object.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): Device ID of the entity from where inventory is reported.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              PolicyAbstractInventory,
              PolicyAbstractPolicyInventoryAllOf,
          ],
          'oneOf': [
          ],
        }
