"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.scheduler_abstract_scheduling_params import SchedulerAbstractSchedulingParams
    from intersight.model.scheduler_base_schedule_params_all_of import SchedulerBaseScheduleParamsAllOf
    from intersight.model.scheduler_one_time_schedule_params import SchedulerOneTimeScheduleParams
    from intersight.model.scheduler_recurring_schedule_params import SchedulerRecurringScheduleParams
    globals()['SchedulerAbstractSchedulingParams'] = SchedulerAbstractSchedulingParams
    globals()['SchedulerBaseScheduleParamsAllOf'] = SchedulerBaseScheduleParamsAllOf
    globals()['SchedulerOneTimeScheduleParams'] = SchedulerOneTimeScheduleParams
    globals()['SchedulerRecurringScheduleParams'] = SchedulerRecurringScheduleParams


class SchedulerBaseScheduleParams(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'ONETIMESCHEDULEPARAMS': "scheduler.OneTimeScheduleParams",
            'RECURRINGSCHEDULEPARAMS': "scheduler.RecurringScheduleParams",
        },
        ('object_type',): {
            'ONETIMESCHEDULEPARAMS': "scheduler.OneTimeScheduleParams",
            'RECURRINGSCHEDULEPARAMS': "scheduler.RecurringScheduleParams",
        },
        ('time_zone',): {
            'PACIFIC/NIUE': "Pacific/Niue",
            'AFRICA/ABIDJAN': "Africa/Abidjan",
            'AFRICA/ACCRA': "Africa/Accra",
            'AFRICA/ADDIS_ABABA': "Africa/Addis_Ababa",
            'AFRICA/ALGIERS': "Africa/Algiers",
            'AFRICA/ASMARA': "Africa/Asmara",
            'AFRICA/BAMAKO': "Africa/Bamako",
            'AFRICA/BANGUI': "Africa/Bangui",
            'AFRICA/BANJUL': "Africa/Banjul",
            'AFRICA/BISSAU': "Africa/Bissau",
            'AFRICA/BLANTYRE': "Africa/Blantyre",
            'AFRICA/BRAZZAVILLE': "Africa/Brazzaville",
            'AFRICA/BUJUMBURA': "Africa/Bujumbura",
            'AFRICA/CAIRO': "Africa/Cairo",
            'AFRICA/CASABLANCA': "Africa/Casablanca",
            'AFRICA/CEUTA': "Africa/Ceuta",
            'AFRICA/CONAKRY': "Africa/Conakry",
            'AFRICA/DAKAR': "Africa/Dakar",
            'AFRICA/DAR_ES_SALAAM': "Africa/Dar_es_Salaam",
            'AFRICA/DJIBOUTI': "Africa/Djibouti",
            'AFRICA/DOUALA': "Africa/Douala",
            'AFRICA/EL_AAIUN': "Africa/El_Aaiun",
            'AFRICA/FREETOWN': "Africa/Freetown",
            'AFRICA/GABORONE': "Africa/Gaborone",
            'AFRICA/HARARE': "Africa/Harare",
            'AFRICA/JOHANNESBURG': "Africa/Johannesburg",
            'AFRICA/JUBA': "Africa/Juba",
            'AFRICA/KAMPALA': "Africa/Kampala",
            'AFRICA/KHARTOUM': "Africa/Khartoum",
            'AFRICA/KIGALI': "Africa/Kigali",
            'AFRICA/KINSHASA': "Africa/Kinshasa",
            'AFRICA/LAGOS': "Africa/Lagos",
            'AFRICA/LIBREVILLE': "Africa/Libreville",
            'AFRICA/LOME': "Africa/Lome",
            'AFRICA/LUANDA': "Africa/Luanda",
            'AFRICA/LUBUMBASHI': "Africa/Lubumbashi",
            'AFRICA/LUSAKA': "Africa/Lusaka",
            'AFRICA/MALABO': "Africa/Malabo",
            'AFRICA/MAPUTO': "Africa/Maputo",
            'AFRICA/MASERU': "Africa/Maseru",
            'AFRICA/MBABANE': "Africa/Mbabane",
            'AFRICA/MOGADISHU': "Africa/Mogadishu",
            'AFRICA/MONROVIA': "Africa/Monrovia",
            'AFRICA/NAIROBI': "Africa/Nairobi",
            'AFRICA/NDJAMENA': "Africa/Ndjamena",
            'AFRICA/NIAMEY': "Africa/Niamey",
            'AFRICA/NOUAKCHOTT': "Africa/Nouakchott",
            'AFRICA/OUAGADOUGOU': "Africa/Ouagadougou",
            'AFRICA/PORTO-NOVO': "Africa/Porto-Novo",
            'AFRICA/SAO_TOME': "Africa/Sao_Tome",
            'AFRICA/TRIPOLI': "Africa/Tripoli",
            'AFRICA/TUNIS': "Africa/Tunis",
            'AFRICA/WINDHOEK': "Africa/Windhoek",
            'AMERICA/ADAK': "America/Adak",
            'AMERICA/ANCHORAGE': "America/Anchorage",
            'AMERICA/ANGUILLA': "America/Anguilla",
            'AMERICA/ANTIGUA': "America/Antigua",
            'AMERICA/ARAGUAINA': "America/Araguaina",
            'AMERICA/ARGENTINA/BUENOS_AIRES': "America/Argentina/Buenos_Aires",
            'AMERICA/ARGENTINA/CATAMARCA': "America/Argentina/Catamarca",
            'AMERICA/ARGENTINA/CORDOBA': "America/Argentina/Cordoba",
            'AMERICA/ARGENTINA/JUJUY': "America/Argentina/Jujuy",
            'AMERICA/ARGENTINA/LA_RIOJA': "America/Argentina/La_Rioja",
            'AMERICA/ARGENTINA/MENDOZA': "America/Argentina/Mendoza",
            'AMERICA/ARGENTINA/RIO_GALLEGOS': "America/Argentina/Rio_Gallegos",
            'AMERICA/ARGENTINA/SALTA': "America/Argentina/Salta",
            'AMERICA/ARGENTINA/SAN_JUAN': "America/Argentina/San_Juan",
            'AMERICA/ARGENTINA/SAN_LUIS': "America/Argentina/San_Luis",
            'AMERICA/ARGENTINA/TUCUMAN': "America/Argentina/Tucuman",
            'AMERICA/ARGENTINA/USHUAIA': "America/Argentina/Ushuaia",
            'AMERICA/ARUBA': "America/Aruba",
            'AMERICA/ASUNCION': "America/Asuncion",
            'AMERICA/ATIKOKAN': "America/Atikokan",
            'AMERICA/BAHIA': "America/Bahia",
            'AMERICA/BAHIA_BANDERAS': "America/Bahia_Banderas",
            'AMERICA/BARBADOS': "America/Barbados",
            'AMERICA/BELEM': "America/Belem",
            'AMERICA/BELIZE': "America/Belize",
            'AMERICA/BLANC-SABLON': "America/Blanc-Sablon",
            'AMERICA/BOA_VISTA': "America/Boa_Vista",
            'AMERICA/BOGOTA': "America/Bogota",
            'AMERICA/BOISE': "America/Boise",
            'AMERICA/CAMBRIDGE_BAY': "America/Cambridge_Bay",
            'AMERICA/CAMPO_GRANDE': "America/Campo_Grande",
            'AMERICA/CANCUN': "America/Cancun",
            'AMERICA/CARACAS': "America/Caracas",
            'AMERICA/CAYENNE': "America/Cayenne",
            'AMERICA/CAYMAN': "America/Cayman",
            'AMERICA/CHICAGO': "America/Chicago",
            'AMERICA/CHIHUAHUA': "America/Chihuahua",
            'AMERICA/COSTA_RICA': "America/Costa_Rica",
            'AMERICA/CRESTON': "America/Creston",
            'AMERICA/CUIABA': "America/Cuiaba",
            'AMERICA/CURACAO': "America/Curacao",
            'AMERICA/DANMARKSHAVN': "America/Danmarkshavn",
            'AMERICA/DAWSON': "America/Dawson",
            'AMERICA/DAWSON_CREEK': "America/Dawson_Creek",
            'AMERICA/DENVER': "America/Denver",
            'AMERICA/DETROIT': "America/Detroit",
            'AMERICA/DOMINICA': "America/Dominica",
            'AMERICA/EDMONTON': "America/Edmonton",
            'AMERICA/EIRUNEPE': "America/Eirunepe",
            'AMERICA/EL_SALVADOR': "America/El_Salvador",
            'AMERICA/FORTALEZA': "America/Fortaleza",
            'AMERICA/GLACE_BAY': "America/Glace_Bay",
            'AMERICA/GODTHAB': "America/Godthab",
            'AMERICA/GOOSE_BAY': "America/Goose_Bay",
            'AMERICA/GRAND_TURK': "America/Grand_Turk",
            'AMERICA/GRENADA': "America/Grenada",
            'AMERICA/GUADELOUPE': "America/Guadeloupe",
            'AMERICA/GUATEMALA': "America/Guatemala",
            'AMERICA/GUAYAQUIL': "America/Guayaquil",
            'AMERICA/GUYANA': "America/Guyana",
            'AMERICA/HALIFAX': "America/Halifax",
            'AMERICA/HAVANA': "America/Havana",
            'AMERICA/HERMOSILLO': "America/Hermosillo",
            'AMERICA/INDIANA/INDIANAPOLIS': "America/Indiana/Indianapolis",
            'AMERICA/INDIANA/KNOX': "America/Indiana/Knox",
            'AMERICA/INDIANA/MARENGO': "America/Indiana/Marengo",
            'AMERICA/INDIANA/PETERSBURG': "America/Indiana/Petersburg",
            'AMERICA/INDIANA/TELL_CITY': "America/Indiana/Tell_City",
            'AMERICA/INDIANA/VEVAY': "America/Indiana/Vevay",
            'AMERICA/INDIANA/VINCENNES': "America/Indiana/Vincennes",
            'AMERICA/INDIANA/WINAMAC': "America/Indiana/Winamac",
            'AMERICA/INUVIK': "America/Inuvik",
            'AMERICA/IQALUIT': "America/Iqaluit",
            'AMERICA/JAMAICA': "America/Jamaica",
            'AMERICA/JUNEAU': "America/Juneau",
            'AMERICA/KENTUCKY/LOUISVILLE': "America/Kentucky/Louisville",
            'AMERICA/KENTUCKY/MONTICELLO': "America/Kentucky/Monticello",
            'AMERICA/KRALENDIJK': "America/Kralendijk",
            'AMERICA/LA_PAZ': "America/La_Paz",
            'AMERICA/LIMA': "America/Lima",
            'AMERICA/LOS_ANGELES': "America/Los_Angeles",
            'AMERICA/LOWER_PRINCES': "America/Lower_Princes",
            'AMERICA/MACEIO': "America/Maceio",
            'AMERICA/MANAGUA': "America/Managua",
            'AMERICA/MANAUS': "America/Manaus",
            'AMERICA/MARIGOT': "America/Marigot",
            'AMERICA/MARTINIQUE': "America/Martinique",
            'AMERICA/MATAMOROS': "America/Matamoros",
            'AMERICA/MAZATLAN': "America/Mazatlan",
            'AMERICA/MENOMINEE': "America/Menominee",
            'AMERICA/MERIDA': "America/Merida",
            'AMERICA/METLAKATLA': "America/Metlakatla",
            'AMERICA/MEXICO_CITY': "America/Mexico_City",
            'AMERICA/MIQUELON': "America/Miquelon",
            'AMERICA/MONCTON': "America/Moncton",
            'AMERICA/MONTERREY': "America/Monterrey",
            'AMERICA/MONTEVIDEO': "America/Montevideo",
            'AMERICA/MONTREAL': "America/Montreal",
            'AMERICA/MONTSERRAT': "America/Montserrat",
            'AMERICA/NASSAU': "America/Nassau",
            'AMERICA/NEW_YORK': "America/New_York",
            'AMERICA/NIPIGON': "America/Nipigon",
            'AMERICA/NOME': "America/Nome",
            'AMERICA/NORONHA': "America/Noronha",
            'AMERICA/NORTH_DAKOTA/BEULAH': "America/North_Dakota/Beulah",
            'AMERICA/NORTH_DAKOTA/CENTER': "America/North_Dakota/Center",
            'AMERICA/NORTH_DAKOTA/NEW_SALEM': "America/North_Dakota/New_Salem",
            'AMERICA/OJINAGA': "America/Ojinaga",
            'AMERICA/PANAMA': "America/Panama",
            'AMERICA/PANGNIRTUNG': "America/Pangnirtung",
            'AMERICA/PARAMARIBO': "America/Paramaribo",
            'AMERICA/PHOENIX': "America/Phoenix",
            'AMERICA/PORT-AU-PRINCE': "America/Port-au-Prince",
            'AMERICA/PORT_OF_SPAIN': "America/Port_of_Spain",
            'AMERICA/PORTO_VELHO': "America/Porto_Velho",
            'AMERICA/PUERTO_RICO': "America/Puerto_Rico",
            'AMERICA/RAINY_RIVER': "America/Rainy_River",
            'AMERICA/RANKIN_INLET': "America/Rankin_Inlet",
            'AMERICA/RECIFE': "America/Recife",
            'AMERICA/REGINA': "America/Regina",
            'AMERICA/RESOLUTE': "America/Resolute",
            'AMERICA/RIO_BRANCO': "America/Rio_Branco",
            'AMERICA/SANTA_ISABEL': "America/Santa_Isabel",
            'AMERICA/SANTAREM': "America/Santarem",
            'AMERICA/SANTIAGO': "America/Santiago",
            'AMERICA/SANTO_DOMINGO': "America/Santo_Domingo",
            'AMERICA/SAO_PAULO': "America/Sao_Paulo",
            'AMERICA/SCORESBYSUND': "America/Scoresbysund",
            'AMERICA/SHIPROCK': "America/Shiprock",
            'AMERICA/SITKA': "America/Sitka",
            'AMERICA/ST_BARTHELEMY': "America/St_Barthelemy",
            'AMERICA/ST_JOHNS': "America/St_Johns",
            'AMERICA/ST_KITTS': "America/St_Kitts",
            'AMERICA/ST_LUCIA': "America/St_Lucia",
            'AMERICA/ST_THOMAS': "America/St_Thomas",
            'AMERICA/ST_VINCENT': "America/St_Vincent",
            'AMERICA/SWIFT_CURRENT': "America/Swift_Current",
            'AMERICA/TEGUCIGALPA': "America/Tegucigalpa",
            'AMERICA/THULE': "America/Thule",
            'AMERICA/THUNDER_BAY': "America/Thunder_Bay",
            'AMERICA/TIJUANA': "America/Tijuana",
            'AMERICA/TORONTO': "America/Toronto",
            'AMERICA/TORTOLA': "America/Tortola",
            'AMERICA/VANCOUVER': "America/Vancouver",
            'AMERICA/WHITEHORSE': "America/Whitehorse",
            'AMERICA/WINNIPEG': "America/Winnipeg",
            'AMERICA/YAKUTAT': "America/Yakutat",
            'AMERICA/YELLOWKNIFE': "America/Yellowknife",
            'ANTARCTICA/CASEY': "Antarctica/Casey",
            'ANTARCTICA/DAVIS': "Antarctica/Davis",
            'ANTARCTICA/DUMONTDURVILLE': "Antarctica/DumontDUrville",
            'ANTARCTICA/MACQUARIE': "Antarctica/Macquarie",
            'ANTARCTICA/MAWSON': "Antarctica/Mawson",
            'ANTARCTICA/MCMURDO': "Antarctica/McMurdo",
            'ANTARCTICA/PALMER': "Antarctica/Palmer",
            'ANTARCTICA/ROTHERA': "Antarctica/Rothera",
            'ANTARCTICA/SOUTH_POLE': "Antarctica/South_Pole",
            'ANTARCTICA/SYOWA': "Antarctica/Syowa",
            'ANTARCTICA/TROLL': "Antarctica/Troll",
            'ANTARCTICA/VOSTOK': "Antarctica/Vostok",
            'ARCTIC/LONGYEARBYEN': "Arctic/Longyearbyen",
            'ASIA/ADEN': "Asia/Aden",
            'ASIA/ALMATY': "Asia/Almaty",
            'ASIA/AMMAN': "Asia/Amman",
            'ASIA/ANADYR': "Asia/Anadyr",
            'ASIA/AQTAU': "Asia/Aqtau",
            'ASIA/AQTOBE': "Asia/Aqtobe",
            'ASIA/ASHGABAT': "Asia/Ashgabat",
            'ASIA/BAGHDAD': "Asia/Baghdad",
            'ASIA/BAHRAIN': "Asia/Bahrain",
            'ASIA/BAKU': "Asia/Baku",
            'ASIA/BANGKOK': "Asia/Bangkok",
            'ASIA/BEIRUT': "Asia/Beirut",
            'ASIA/BISHKEK': "Asia/Bishkek",
            'ASIA/BRUNEI': "Asia/Brunei",
            'ASIA/CALCUTTA': "Asia/Calcutta",
            'ASIA/CHOIBALSAN': "Asia/Choibalsan",
            'ASIA/CHONGQING': "Asia/Chongqing",
            'ASIA/COLOMBO': "Asia/Colombo",
            'ASIA/DAMASCUS': "Asia/Damascus",
            'ASIA/DHAKA': "Asia/Dhaka",
            'ASIA/DILI': "Asia/Dili",
            'ASIA/DUBAI': "Asia/Dubai",
            'ASIA/DUSHANBE': "Asia/Dushanbe",
            'ASIA/GAZA': "Asia/Gaza",
            'ASIA/HARBIN': "Asia/Harbin",
            'ASIA/HEBRON': "Asia/Hebron",
            'ASIA/HO_CHI_MINH': "Asia/Ho_Chi_Minh",
            'ASIA/HONG_KONG': "Asia/Hong_Kong",
            'ASIA/HOVD': "Asia/Hovd",
            'ASIA/IRKUTSK': "Asia/Irkutsk",
            'ASIA/JAKARTA': "Asia/Jakarta",
            'ASIA/JAYAPURA': "Asia/Jayapura",
            'ASIA/JERUSALEM': "Asia/Jerusalem",
            'ASIA/KABUL': "Asia/Kabul",
            'ASIA/KAMCHATKA': "Asia/Kamchatka",
            'ASIA/KARACHI': "Asia/Karachi",
            'ASIA/KASHGAR': "Asia/Kashgar",
            'ASIA/KATHMANDU': "Asia/Kathmandu",
            'ASIA/KATMANDU': "Asia/Katmandu",
            'ASIA/KHANDYGA': "Asia/Khandyga",
            'ASIA/KOLKATA': "Asia/Kolkata",
            'ASIA/KRASNOYARSK': "Asia/Krasnoyarsk",
            'ASIA/KUALA_LUMPUR': "Asia/Kuala_Lumpur",
            'ASIA/KUCHING': "Asia/Kuching",
            'ASIA/KUWAIT': "Asia/Kuwait",
            'ASIA/MACAU': "Asia/Macau",
            'ASIA/MAGADAN': "Asia/Magadan",
            'ASIA/MAKASSAR': "Asia/Makassar",
            'ASIA/MANILA': "Asia/Manila",
            'ASIA/MUSCAT': "Asia/Muscat",
            'ASIA/NICOSIA': "Asia/Nicosia",
            'ASIA/NOVOKUZNETSK': "Asia/Novokuznetsk",
            'ASIA/NOVOSIBIRSK': "Asia/Novosibirsk",
            'ASIA/OMSK': "Asia/Omsk",
            'ASIA/ORAL': "Asia/Oral",
            'ASIA/PHNOM_PENH': "Asia/Phnom_Penh",
            'ASIA/PONTIANAK': "Asia/Pontianak",
            'ASIA/PYONGYANG': "Asia/Pyongyang",
            'ASIA/QATAR': "Asia/Qatar",
            'ASIA/QYZYLORDA': "Asia/Qyzylorda",
            'ASIA/RANGOON': "Asia/Rangoon",
            'ASIA/RIYADH': "Asia/Riyadh",
            'ASIA/SAIGON': "Asia/Saigon",
            'ASIA/SAKHALIN': "Asia/Sakhalin",
            'ASIA/SAMARKAND': "Asia/Samarkand",
            'ASIA/SEOUL': "Asia/Seoul",
            'ASIA/SHANGHAI': "Asia/Shanghai",
            'ASIA/SINGAPORE': "Asia/Singapore",
            'ASIA/TAIPEI': "Asia/Taipei",
            'ASIA/TASHKENT': "Asia/Tashkent",
            'ASIA/TBILISI': "Asia/Tbilisi",
            'ASIA/TEHRAN': "Asia/Tehran",
            'ASIA/THIMPHU': "Asia/Thimphu",
            'ASIA/TOKYO': "Asia/Tokyo",
            'ASIA/ULAANBAATAR': "Asia/Ulaanbaatar",
            'ASIA/URUMQI': "Asia/Urumqi",
            'ASIA/UST-NERA': "Asia/Ust-Nera",
            'ASIA/VIENTIANE': "Asia/Vientiane",
            'ASIA/VLADIVOSTOK': "Asia/Vladivostok",
            'ASIA/YAKUTSK': "Asia/Yakutsk",
            'ASIA/YEKATERINBURG': "Asia/Yekaterinburg",
            'ASIA/YEREVAN': "Asia/Yerevan",
            'ATLANTIC/AZORES': "Atlantic/Azores",
            'ATLANTIC/BERMUDA': "Atlantic/Bermuda",
            'ATLANTIC/CANARY': "Atlantic/Canary",
            'ATLANTIC/CAPE_VERDE': "Atlantic/Cape_Verde",
            'ATLANTIC/FAROE': "Atlantic/Faroe",
            'ATLANTIC/MADEIRA': "Atlantic/Madeira",
            'ATLANTIC/REYKJAVIK': "Atlantic/Reykjavik",
            'ATLANTIC/SOUTH_GEORGIA': "Atlantic/South_Georgia",
            'ATLANTIC/ST_HELENA': "Atlantic/St_Helena",
            'ATLANTIC/STANLEY': "Atlantic/Stanley",
            'AUSTRALIA/ADELAIDE': "Australia/Adelaide",
            'AUSTRALIA/BRISBANE': "Australia/Brisbane",
            'AUSTRALIA/BROKEN_HILL': "Australia/Broken_Hill",
            'AUSTRALIA/CURRIE': "Australia/Currie",
            'AUSTRALIA/DARWIN': "Australia/Darwin",
            'AUSTRALIA/EUCLA': "Australia/Eucla",
            'AUSTRALIA/HOBART': "Australia/Hobart",
            'AUSTRALIA/LINDEMAN': "Australia/Lindeman",
            'AUSTRALIA/LORD_HOWE': "Australia/Lord_Howe",
            'AUSTRALIA/MELBOURNE': "Australia/Melbourne",
            'AUSTRALIA/PERTH': "Australia/Perth",
            'AUSTRALIA/SYDNEY': "Australia/Sydney",
            'ETC/GMT': "Etc/GMT",
            'EUROPE/AMSTERDAM': "Europe/Amsterdam",
            'EUROPE/ANDORRA': "Europe/Andorra",
            'EUROPE/ATHENS': "Europe/Athens",
            'EUROPE/BELGRADE': "Europe/Belgrade",
            'EUROPE/BERLIN': "Europe/Berlin",
            'EUROPE/BRATISLAVA': "Europe/Bratislava",
            'EUROPE/BRUSSELS': "Europe/Brussels",
            'EUROPE/BUCHAREST': "Europe/Bucharest",
            'EUROPE/BUDAPEST': "Europe/Budapest",
            'EUROPE/BUSINGEN': "Europe/Busingen",
            'EUROPE/CHISINAU': "Europe/Chisinau",
            'EUROPE/COPENHAGEN': "Europe/Copenhagen",
            'EUROPE/DUBLIN': "Europe/Dublin",
            'EUROPE/GIBRALTAR': "Europe/Gibraltar",
            'EUROPE/GUERNSEY': "Europe/Guernsey",
            'EUROPE/HELSINKI': "Europe/Helsinki",
            'EUROPE/ISLE_OF_MAN': "Europe/Isle_of_Man",
            'EUROPE/ISTANBUL': "Europe/Istanbul",
            'EUROPE/JERSEY': "Europe/Jersey",
            'EUROPE/KALININGRAD': "Europe/Kaliningrad",
            'EUROPE/KIEV': "Europe/Kiev",
            'EUROPE/LISBON': "Europe/Lisbon",
            'EUROPE/LJUBLJANA': "Europe/Ljubljana",
            'EUROPE/LONDON': "Europe/London",
            'EUROPE/LUXEMBOURG': "Europe/Luxembourg",
            'EUROPE/MADRID': "Europe/Madrid",
            'EUROPE/MALTA': "Europe/Malta",
            'EUROPE/MARIEHAMN': "Europe/Mariehamn",
            'EUROPE/MINSK': "Europe/Minsk",
            'EUROPE/MONACO': "Europe/Monaco",
            'EUROPE/MOSCOW': "Europe/Moscow",
            'EUROPE/OSLO': "Europe/Oslo",
            'EUROPE/PARIS': "Europe/Paris",
            'EUROPE/PODGORICA': "Europe/Podgorica",
            'EUROPE/PRAGUE': "Europe/Prague",
            'EUROPE/RIGA': "Europe/Riga",
            'EUROPE/ROME': "Europe/Rome",
            'EUROPE/SAMARA': "Europe/Samara",
            'EUROPE/SAN_MARINO': "Europe/San_Marino",
            'EUROPE/SARAJEVO': "Europe/Sarajevo",
            'EUROPE/SIMFEROPOL': "Europe/Simferopol",
            'EUROPE/SKOPJE': "Europe/Skopje",
            'EUROPE/SOFIA': "Europe/Sofia",
            'EUROPE/STOCKHOLM': "Europe/Stockholm",
            'EUROPE/TALLINN': "Europe/Tallinn",
            'EUROPE/TIRANE': "Europe/Tirane",
            'EUROPE/UZHGOROD': "Europe/Uzhgorod",
            'EUROPE/VADUZ': "Europe/Vaduz",
            'EUROPE/VATICAN': "Europe/Vatican",
            'EUROPE/VIENNA': "Europe/Vienna",
            'EUROPE/VILNIUS': "Europe/Vilnius",
            'EUROPE/VOLGOGRAD': "Europe/Volgograd",
            'EUROPE/WARSAW': "Europe/Warsaw",
            'EUROPE/ZAGREB': "Europe/Zagreb",
            'EUROPE/ZAPOROZHYE': "Europe/Zaporozhye",
            'EUROPE/ZURICH': "Europe/Zurich",
            'INDIAN/ANTANANARIVO': "Indian/Antananarivo",
            'INDIAN/CHAGOS': "Indian/Chagos",
            'INDIAN/CHRISTMAS': "Indian/Christmas",
            'INDIAN/COCOS': "Indian/Cocos",
            'INDIAN/COMORO': "Indian/Comoro",
            'INDIAN/KERGUELEN': "Indian/Kerguelen",
            'INDIAN/MAHE': "Indian/Mahe",
            'INDIAN/MALDIVES': "Indian/Maldives",
            'INDIAN/MAURITIUS': "Indian/Mauritius",
            'INDIAN/MAYOTTE': "Indian/Mayotte",
            'INDIAN/REUNION': "Indian/Reunion",
            'PACIFIC/APIA': "Pacific/Apia",
            'PACIFIC/AUCKLAND': "Pacific/Auckland",
            'PACIFIC/CHATHAM': "Pacific/Chatham",
            'PACIFIC/CHUUK': "Pacific/Chuuk",
            'PACIFIC/EASTER': "Pacific/Easter",
            'PACIFIC/EFATE': "Pacific/Efate",
            'PACIFIC/ENDERBURY': "Pacific/Enderbury",
            'PACIFIC/FAKAOFO': "Pacific/Fakaofo",
            'PACIFIC/FIJI': "Pacific/Fiji",
            'PACIFIC/FUNAFUTI': "Pacific/Funafuti",
            'PACIFIC/GALAPAGOS': "Pacific/Galapagos",
            'PACIFIC/GAMBIER': "Pacific/Gambier",
            'PACIFIC/GUADALCANAL': "Pacific/Guadalcanal",
            'PACIFIC/GUAM': "Pacific/Guam",
            'PACIFIC/HONOLULU': "Pacific/Honolulu",
            'PACIFIC/JOHNSTON': "Pacific/Johnston",
            'PACIFIC/KIRITIMATI': "Pacific/Kiritimati",
            'PACIFIC/KOSRAE': "Pacific/Kosrae",
            'PACIFIC/KWAJALEIN': "Pacific/Kwajalein",
            'PACIFIC/MAJURO': "Pacific/Majuro",
            'PACIFIC/MARQUESAS': "Pacific/Marquesas",
            'PACIFIC/MIDWAY': "Pacific/Midway",
            'PACIFIC/NAURU': "Pacific/Nauru",
            'PACIFIC/NORFOLK': "Pacific/Norfolk",
            'PACIFIC/NOUMEA': "Pacific/Noumea",
            'PACIFIC/PAGO_PAGO': "Pacific/Pago_Pago",
            'PACIFIC/PALAU': "Pacific/Palau",
            'PACIFIC/PITCAIRN': "Pacific/Pitcairn",
            'PACIFIC/POHNPEI': "Pacific/Pohnpei",
            'PACIFIC/PORT_MORESBY': "Pacific/Port_Moresby",
            'PACIFIC/RAROTONGA': "Pacific/Rarotonga",
            'PACIFIC/SAIPAN': "Pacific/Saipan",
            'PACIFIC/TAHITI': "Pacific/Tahiti",
            'PACIFIC/TARAWA': "Pacific/Tarawa",
            'PACIFIC/TONGATAPU': "Pacific/Tongatapu",
            'PACIFIC/WAKE': "Pacific/Wake",
            'PACIFIC/WALLIS': "Pacific/Wallis",
            'UTC': "UTC",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'duration': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'start_time': (datetime,),  # noqa: E501
            'time_zone': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'scheduler.OneTimeScheduleParams': SchedulerOneTimeScheduleParams,
            'scheduler.RecurringScheduleParams': SchedulerRecurringScheduleParams,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'duration': 'Duration',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'start_time': 'StartTime',  # noqa: E501
        'time_zone': 'TimeZone',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, class_id, object_type, *args, **kwargs):  # noqa: E501
        """SchedulerBaseScheduleParams - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            duration (str): The duration of the schedule. Its syntax is specified at https://www.w3.org/TR/xmlschema11-2/#nt-durationRep For example, P20DT10H5M2.3S is for 20 days, 10 hours, 5 minutes and 2.3 seconds. It is a mandatory input property for Policy based schedules.. [optional]  # noqa: E501
            name (str): The name of the schedule. It is a mandatory input property for Policy based schedules.. [optional]  # noqa: E501
            start_time (datetime): The schedule start time. A future time is required.. [optional]  # noqa: E501
            time_zone (str): The timezone for the startTime specified. It is a mandatory input property when start time is provided. * `Pacific/Niue` -  * `Africa/Abidjan` -  * `Africa/Accra` -  * `Africa/Addis_Ababa` -  * `Africa/Algiers` -  * `Africa/Asmara` -  * `Africa/Bamako` -  * `Africa/Bangui` -  * `Africa/Banjul` -  * `Africa/Bissau` -  * `Africa/Blantyre` -  * `Africa/Brazzaville` -  * `Africa/Bujumbura` -  * `Africa/Cairo` -  * `Africa/Casablanca` -  * `Africa/Ceuta` -  * `Africa/Conakry` -  * `Africa/Dakar` -  * `Africa/Dar_es_Salaam` -  * `Africa/Djibouti` -  * `Africa/Douala` -  * `Africa/El_Aaiun` -  * `Africa/Freetown` -  * `Africa/Gaborone` -  * `Africa/Harare` -  * `Africa/Johannesburg` -  * `Africa/Juba` -  * `Africa/Kampala` -  * `Africa/Khartoum` -  * `Africa/Kigali` -  * `Africa/Kinshasa` -  * `Africa/Lagos` -  * `Africa/Libreville` -  * `Africa/Lome` -  * `Africa/Luanda` -  * `Africa/Lubumbashi` -  * `Africa/Lusaka` -  * `Africa/Malabo` -  * `Africa/Maputo` -  * `Africa/Maseru` -  * `Africa/Mbabane` -  * `Africa/Mogadishu` -  * `Africa/Monrovia` -  * `Africa/Nairobi` -  * `Africa/Ndjamena` -  * `Africa/Niamey` -  * `Africa/Nouakchott` -  * `Africa/Ouagadougou` -  * `Africa/Porto-Novo` -  * `Africa/Sao_Tome` -  * `Africa/Tripoli` -  * `Africa/Tunis` -  * `Africa/Windhoek` -  * `America/Adak` -  * `America/Anchorage` -  * `America/Anguilla` -  * `America/Antigua` -  * `America/Araguaina` -  * `America/Argentina/Buenos_Aires` -  * `America/Argentina/Catamarca` -  * `America/Argentina/Cordoba` -  * `America/Argentina/Jujuy` -  * `America/Argentina/La_Rioja` -  * `America/Argentina/Mendoza` -  * `America/Argentina/Rio_Gallegos` -  * `America/Argentina/Salta` -  * `America/Argentina/San_Juan` -  * `America/Argentina/San_Luis` -  * `America/Argentina/Tucuman` -  * `America/Argentina/Ushuaia` -  * `America/Aruba` -  * `America/Asuncion` -  * `America/Atikokan` -  * `America/Bahia` -  * `America/Bahia_Banderas` -  * `America/Barbados` -  * `America/Belem` -  * `America/Belize` -  * `America/Blanc-Sablon` -  * `America/Boa_Vista` -  * `America/Bogota` -  * `America/Boise` -  * `America/Cambridge_Bay` -  * `America/Campo_Grande` -  * `America/Cancun` -  * `America/Caracas` -  * `America/Cayenne` -  * `America/Cayman` -  * `America/Chicago` -  * `America/Chihuahua` -  * `America/Costa_Rica` -  * `America/Creston` -  * `America/Cuiaba` -  * `America/Curacao` -  * `America/Danmarkshavn` -  * `America/Dawson` -  * `America/Dawson_Creek` -  * `America/Denver` -  * `America/Detroit` -  * `America/Dominica` -  * `America/Edmonton` -  * `America/Eirunepe` -  * `America/El_Salvador` -  * `America/Fortaleza` -  * `America/Glace_Bay` -  * `America/Godthab` -  * `America/Goose_Bay` -  * `America/Grand_Turk` -  * `America/Grenada` -  * `America/Guadeloupe` -  * `America/Guatemala` -  * `America/Guayaquil` -  * `America/Guyana` -  * `America/Halifax` -  * `America/Havana` -  * `America/Hermosillo` -  * `America/Indiana/Indianapolis` -  * `America/Indiana/Knox` -  * `America/Indiana/Marengo` -  * `America/Indiana/Petersburg` -  * `America/Indiana/Tell_City` -  * `America/Indiana/Vevay` -  * `America/Indiana/Vincennes` -  * `America/Indiana/Winamac` -  * `America/Inuvik` -  * `America/Iqaluit` -  * `America/Jamaica` -  * `America/Juneau` -  * `America/Kentucky/Louisville` -  * `America/Kentucky/Monticello` -  * `America/Kralendijk` -  * `America/La_Paz` -  * `America/Lima` -  * `America/Los_Angeles` -  * `America/Lower_Princes` -  * `America/Maceio` -  * `America/Managua` -  * `America/Manaus` -  * `America/Marigot` -  * `America/Martinique` -  * `America/Matamoros` -  * `America/Mazatlan` -  * `America/Menominee` -  * `America/Merida` -  * `America/Metlakatla` -  * `America/Mexico_City` -  * `America/Miquelon` -  * `America/Moncton` -  * `America/Monterrey` -  * `America/Montevideo` -  * `America/Montreal` -  * `America/Montserrat` -  * `America/Nassau` -  * `America/New_York` -  * `America/Nipigon` -  * `America/Nome` -  * `America/Noronha` -  * `America/North_Dakota/Beulah` -  * `America/North_Dakota/Center` -  * `America/North_Dakota/New_Salem` -  * `America/Ojinaga` -  * `America/Panama` -  * `America/Pangnirtung` -  * `America/Paramaribo` -  * `America/Phoenix` -  * `America/Port-au-Prince` -  * `America/Port_of_Spain` -  * `America/Porto_Velho` -  * `America/Puerto_Rico` -  * `America/Rainy_River` -  * `America/Rankin_Inlet` -  * `America/Recife` -  * `America/Regina` -  * `America/Resolute` -  * `America/Rio_Branco` -  * `America/Santa_Isabel` -  * `America/Santarem` -  * `America/Santiago` -  * `America/Santo_Domingo` -  * `America/Sao_Paulo` -  * `America/Scoresbysund` -  * `America/Shiprock` -  * `America/Sitka` -  * `America/St_Barthelemy` -  * `America/St_Johns` -  * `America/St_Kitts` -  * `America/St_Lucia` -  * `America/St_Thomas` -  * `America/St_Vincent` -  * `America/Swift_Current` -  * `America/Tegucigalpa` -  * `America/Thule` -  * `America/Thunder_Bay` -  * `America/Tijuana` -  * `America/Toronto` -  * `America/Tortola` -  * `America/Vancouver` -  * `America/Whitehorse` -  * `America/Winnipeg` -  * `America/Yakutat` -  * `America/Yellowknife` -  * `Antarctica/Casey` -  * `Antarctica/Davis` -  * `Antarctica/DumontDUrville` -  * `Antarctica/Macquarie` -  * `Antarctica/Mawson` -  * `Antarctica/McMurdo` -  * `Antarctica/Palmer` -  * `Antarctica/Rothera` -  * `Antarctica/South_Pole` -  * `Antarctica/Syowa` -  * `Antarctica/Troll` -  * `Antarctica/Vostok` -  * `Arctic/Longyearbyen` -  * `Asia/Aden` -  * `Asia/Almaty` -  * `Asia/Amman` -  * `Asia/Anadyr` -  * `Asia/Aqtau` -  * `Asia/Aqtobe` -  * `Asia/Ashgabat` -  * `Asia/Baghdad` -  * `Asia/Bahrain` -  * `Asia/Baku` -  * `Asia/Bangkok` -  * `Asia/Beirut` -  * `Asia/Bishkek` -  * `Asia/Brunei` -  * `Asia/Calcutta` -  * `Asia/Choibalsan` -  * `Asia/Chongqing` -  * `Asia/Colombo` -  * `Asia/Damascus` -  * `Asia/Dhaka` -  * `Asia/Dili` -  * `Asia/Dubai` -  * `Asia/Dushanbe` -  * `Asia/Gaza` -  * `Asia/Harbin` -  * `Asia/Hebron` -  * `Asia/Ho_Chi_Minh` -  * `Asia/Hong_Kong` -  * `Asia/Hovd` -  * `Asia/Irkutsk` -  * `Asia/Jakarta` -  * `Asia/Jayapura` -  * `Asia/Jerusalem` -  * `Asia/Kabul` -  * `Asia/Kamchatka` -  * `Asia/Karachi` -  * `Asia/Kashgar` -  * `Asia/Kathmandu` -  * `Asia/Katmandu` -  * `Asia/Khandyga` -  * `Asia/Kolkata` -  * `Asia/Krasnoyarsk` -  * `Asia/Kuala_Lumpur` -  * `Asia/Kuching` -  * `Asia/Kuwait` -  * `Asia/Macau` -  * `Asia/Magadan` -  * `Asia/Makassar` -  * `Asia/Manila` -  * `Asia/Muscat` -  * `Asia/Nicosia` -  * `Asia/Novokuznetsk` -  * `Asia/Novosibirsk` -  * `Asia/Omsk` -  * `Asia/Oral` -  * `Asia/Phnom_Penh` -  * `Asia/Pontianak` -  * `Asia/Pyongyang` -  * `Asia/Qatar` -  * `Asia/Qyzylorda` -  * `Asia/Rangoon` -  * `Asia/Riyadh` -  * `Asia/Saigon` -  * `Asia/Sakhalin` -  * `Asia/Samarkand` -  * `Asia/Seoul` -  * `Asia/Shanghai` -  * `Asia/Singapore` -  * `Asia/Taipei` -  * `Asia/Tashkent` -  * `Asia/Tbilisi` -  * `Asia/Tehran` -  * `Asia/Thimphu` -  * `Asia/Tokyo` -  * `Asia/Ulaanbaatar` -  * `Asia/Urumqi` -  * `Asia/Ust-Nera` -  * `Asia/Vientiane` -  * `Asia/Vladivostok` -  * `Asia/Yakutsk` -  * `Asia/Yekaterinburg` -  * `Asia/Yerevan` -  * `Atlantic/Azores` -  * `Atlantic/Bermuda` -  * `Atlantic/Canary` -  * `Atlantic/Cape_Verde` -  * `Atlantic/Faroe` -  * `Atlantic/Madeira` -  * `Atlantic/Reykjavik` -  * `Atlantic/South_Georgia` -  * `Atlantic/St_Helena` -  * `Atlantic/Stanley` -  * `Australia/Adelaide` -  * `Australia/Brisbane` -  * `Australia/Broken_Hill` -  * `Australia/Currie` -  * `Australia/Darwin` -  * `Australia/Eucla` -  * `Australia/Hobart` -  * `Australia/Lindeman` -  * `Australia/Lord_Howe` -  * `Australia/Melbourne` -  * `Australia/Perth` -  * `Australia/Sydney` -  * `Etc/GMT` -  * `Europe/Amsterdam` -  * `Europe/Andorra` -  * `Europe/Athens` -  * `Europe/Belgrade` -  * `Europe/Berlin` -  * `Europe/Bratislava` -  * `Europe/Brussels` -  * `Europe/Bucharest` -  * `Europe/Budapest` -  * `Europe/Busingen` -  * `Europe/Chisinau` -  * `Europe/Copenhagen` -  * `Europe/Dublin` -  * `Europe/Gibraltar` -  * `Europe/Guernsey` -  * `Europe/Helsinki` -  * `Europe/Isle_of_Man` -  * `Europe/Istanbul` -  * `Europe/Jersey` -  * `Europe/Kaliningrad` -  * `Europe/Kiev` -  * `Europe/Lisbon` -  * `Europe/Ljubljana` -  * `Europe/London` -  * `Europe/Luxembourg` -  * `Europe/Madrid` -  * `Europe/Malta` -  * `Europe/Mariehamn` -  * `Europe/Minsk` -  * `Europe/Monaco` -  * `Europe/Moscow` -  * `Europe/Oslo` -  * `Europe/Paris` -  * `Europe/Podgorica` -  * `Europe/Prague` -  * `Europe/Riga` -  * `Europe/Rome` -  * `Europe/Samara` -  * `Europe/San_Marino` -  * `Europe/Sarajevo` -  * `Europe/Simferopol` -  * `Europe/Skopje` -  * `Europe/Sofia` -  * `Europe/Stockholm` -  * `Europe/Tallinn` -  * `Europe/Tirane` -  * `Europe/Uzhgorod` -  * `Europe/Vaduz` -  * `Europe/Vatican` -  * `Europe/Vienna` -  * `Europe/Vilnius` -  * `Europe/Volgograd` -  * `Europe/Warsaw` -  * `Europe/Zagreb` -  * `Europe/Zaporozhye` -  * `Europe/Zurich` -  * `Indian/Antananarivo` -  * `Indian/Chagos` -  * `Indian/Christmas` -  * `Indian/Cocos` -  * `Indian/Comoro` -  * `Indian/Kerguelen` -  * `Indian/Mahe` -  * `Indian/Maldives` -  * `Indian/Mauritius` -  * `Indian/Mayotte` -  * `Indian/Reunion` -  * `Pacific/Apia` -  * `Pacific/Auckland` -  * `Pacific/Chatham` -  * `Pacific/Chuuk` -  * `Pacific/Easter` -  * `Pacific/Efate` -  * `Pacific/Enderbury` -  * `Pacific/Fakaofo` -  * `Pacific/Fiji` -  * `Pacific/Funafuti` -  * `Pacific/Galapagos` -  * `Pacific/Gambier` -  * `Pacific/Guadalcanal` -  * `Pacific/Guam` -  * `Pacific/Honolulu` -  * `Pacific/Johnston` -  * `Pacific/Kiritimati` -  * `Pacific/Kosrae` -  * `Pacific/Kwajalein` -  * `Pacific/Majuro` -  * `Pacific/Marquesas` -  * `Pacific/Midway` -  * `Pacific/Nauru` -  * `Pacific/Norfolk` -  * `Pacific/Noumea` -  * `Pacific/Pago_Pago` -  * `Pacific/Palau` -  * `Pacific/Pitcairn` -  * `Pacific/Pohnpei` -  * `Pacific/Port_Moresby` -  * `Pacific/Rarotonga` -  * `Pacific/Saipan` -  * `Pacific/Tahiti` -  * `Pacific/Tarawa` -  * `Pacific/Tongatapu` -  * `Pacific/Wake` -  * `Pacific/Wallis` -  * `UTC` -. [optional] if omitted the server will use the default value of "Pacific/Niue"  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """SchedulerBaseScheduleParams - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            duration (str): The duration of the schedule. Its syntax is specified at https://www.w3.org/TR/xmlschema11-2/#nt-durationRep For example, P20DT10H5M2.3S is for 20 days, 10 hours, 5 minutes and 2.3 seconds. It is a mandatory input property for Policy based schedules.. [optional]  # noqa: E501
            name (str): The name of the schedule. It is a mandatory input property for Policy based schedules.. [optional]  # noqa: E501
            start_time (datetime): The schedule start time. A future time is required.. [optional]  # noqa: E501
            time_zone (str): The timezone for the startTime specified. It is a mandatory input property when start time is provided. * `Pacific/Niue` -  * `Africa/Abidjan` -  * `Africa/Accra` -  * `Africa/Addis_Ababa` -  * `Africa/Algiers` -  * `Africa/Asmara` -  * `Africa/Bamako` -  * `Africa/Bangui` -  * `Africa/Banjul` -  * `Africa/Bissau` -  * `Africa/Blantyre` -  * `Africa/Brazzaville` -  * `Africa/Bujumbura` -  * `Africa/Cairo` -  * `Africa/Casablanca` -  * `Africa/Ceuta` -  * `Africa/Conakry` -  * `Africa/Dakar` -  * `Africa/Dar_es_Salaam` -  * `Africa/Djibouti` -  * `Africa/Douala` -  * `Africa/El_Aaiun` -  * `Africa/Freetown` -  * `Africa/Gaborone` -  * `Africa/Harare` -  * `Africa/Johannesburg` -  * `Africa/Juba` -  * `Africa/Kampala` -  * `Africa/Khartoum` -  * `Africa/Kigali` -  * `Africa/Kinshasa` -  * `Africa/Lagos` -  * `Africa/Libreville` -  * `Africa/Lome` -  * `Africa/Luanda` -  * `Africa/Lubumbashi` -  * `Africa/Lusaka` -  * `Africa/Malabo` -  * `Africa/Maputo` -  * `Africa/Maseru` -  * `Africa/Mbabane` -  * `Africa/Mogadishu` -  * `Africa/Monrovia` -  * `Africa/Nairobi` -  * `Africa/Ndjamena` -  * `Africa/Niamey` -  * `Africa/Nouakchott` -  * `Africa/Ouagadougou` -  * `Africa/Porto-Novo` -  * `Africa/Sao_Tome` -  * `Africa/Tripoli` -  * `Africa/Tunis` -  * `Africa/Windhoek` -  * `America/Adak` -  * `America/Anchorage` -  * `America/Anguilla` -  * `America/Antigua` -  * `America/Araguaina` -  * `America/Argentina/Buenos_Aires` -  * `America/Argentina/Catamarca` -  * `America/Argentina/Cordoba` -  * `America/Argentina/Jujuy` -  * `America/Argentina/La_Rioja` -  * `America/Argentina/Mendoza` -  * `America/Argentina/Rio_Gallegos` -  * `America/Argentina/Salta` -  * `America/Argentina/San_Juan` -  * `America/Argentina/San_Luis` -  * `America/Argentina/Tucuman` -  * `America/Argentina/Ushuaia` -  * `America/Aruba` -  * `America/Asuncion` -  * `America/Atikokan` -  * `America/Bahia` -  * `America/Bahia_Banderas` -  * `America/Barbados` -  * `America/Belem` -  * `America/Belize` -  * `America/Blanc-Sablon` -  * `America/Boa_Vista` -  * `America/Bogota` -  * `America/Boise` -  * `America/Cambridge_Bay` -  * `America/Campo_Grande` -  * `America/Cancun` -  * `America/Caracas` -  * `America/Cayenne` -  * `America/Cayman` -  * `America/Chicago` -  * `America/Chihuahua` -  * `America/Costa_Rica` -  * `America/Creston` -  * `America/Cuiaba` -  * `America/Curacao` -  * `America/Danmarkshavn` -  * `America/Dawson` -  * `America/Dawson_Creek` -  * `America/Denver` -  * `America/Detroit` -  * `America/Dominica` -  * `America/Edmonton` -  * `America/Eirunepe` -  * `America/El_Salvador` -  * `America/Fortaleza` -  * `America/Glace_Bay` -  * `America/Godthab` -  * `America/Goose_Bay` -  * `America/Grand_Turk` -  * `America/Grenada` -  * `America/Guadeloupe` -  * `America/Guatemala` -  * `America/Guayaquil` -  * `America/Guyana` -  * `America/Halifax` -  * `America/Havana` -  * `America/Hermosillo` -  * `America/Indiana/Indianapolis` -  * `America/Indiana/Knox` -  * `America/Indiana/Marengo` -  * `America/Indiana/Petersburg` -  * `America/Indiana/Tell_City` -  * `America/Indiana/Vevay` -  * `America/Indiana/Vincennes` -  * `America/Indiana/Winamac` -  * `America/Inuvik` -  * `America/Iqaluit` -  * `America/Jamaica` -  * `America/Juneau` -  * `America/Kentucky/Louisville` -  * `America/Kentucky/Monticello` -  * `America/Kralendijk` -  * `America/La_Paz` -  * `America/Lima` -  * `America/Los_Angeles` -  * `America/Lower_Princes` -  * `America/Maceio` -  * `America/Managua` -  * `America/Manaus` -  * `America/Marigot` -  * `America/Martinique` -  * `America/Matamoros` -  * `America/Mazatlan` -  * `America/Menominee` -  * `America/Merida` -  * `America/Metlakatla` -  * `America/Mexico_City` -  * `America/Miquelon` -  * `America/Moncton` -  * `America/Monterrey` -  * `America/Montevideo` -  * `America/Montreal` -  * `America/Montserrat` -  * `America/Nassau` -  * `America/New_York` -  * `America/Nipigon` -  * `America/Nome` -  * `America/Noronha` -  * `America/North_Dakota/Beulah` -  * `America/North_Dakota/Center` -  * `America/North_Dakota/New_Salem` -  * `America/Ojinaga` -  * `America/Panama` -  * `America/Pangnirtung` -  * `America/Paramaribo` -  * `America/Phoenix` -  * `America/Port-au-Prince` -  * `America/Port_of_Spain` -  * `America/Porto_Velho` -  * `America/Puerto_Rico` -  * `America/Rainy_River` -  * `America/Rankin_Inlet` -  * `America/Recife` -  * `America/Regina` -  * `America/Resolute` -  * `America/Rio_Branco` -  * `America/Santa_Isabel` -  * `America/Santarem` -  * `America/Santiago` -  * `America/Santo_Domingo` -  * `America/Sao_Paulo` -  * `America/Scoresbysund` -  * `America/Shiprock` -  * `America/Sitka` -  * `America/St_Barthelemy` -  * `America/St_Johns` -  * `America/St_Kitts` -  * `America/St_Lucia` -  * `America/St_Thomas` -  * `America/St_Vincent` -  * `America/Swift_Current` -  * `America/Tegucigalpa` -  * `America/Thule` -  * `America/Thunder_Bay` -  * `America/Tijuana` -  * `America/Toronto` -  * `America/Tortola` -  * `America/Vancouver` -  * `America/Whitehorse` -  * `America/Winnipeg` -  * `America/Yakutat` -  * `America/Yellowknife` -  * `Antarctica/Casey` -  * `Antarctica/Davis` -  * `Antarctica/DumontDUrville` -  * `Antarctica/Macquarie` -  * `Antarctica/Mawson` -  * `Antarctica/McMurdo` -  * `Antarctica/Palmer` -  * `Antarctica/Rothera` -  * `Antarctica/South_Pole` -  * `Antarctica/Syowa` -  * `Antarctica/Troll` -  * `Antarctica/Vostok` -  * `Arctic/Longyearbyen` -  * `Asia/Aden` -  * `Asia/Almaty` -  * `Asia/Amman` -  * `Asia/Anadyr` -  * `Asia/Aqtau` -  * `Asia/Aqtobe` -  * `Asia/Ashgabat` -  * `Asia/Baghdad` -  * `Asia/Bahrain` -  * `Asia/Baku` -  * `Asia/Bangkok` -  * `Asia/Beirut` -  * `Asia/Bishkek` -  * `Asia/Brunei` -  * `Asia/Calcutta` -  * `Asia/Choibalsan` -  * `Asia/Chongqing` -  * `Asia/Colombo` -  * `Asia/Damascus` -  * `Asia/Dhaka` -  * `Asia/Dili` -  * `Asia/Dubai` -  * `Asia/Dushanbe` -  * `Asia/Gaza` -  * `Asia/Harbin` -  * `Asia/Hebron` -  * `Asia/Ho_Chi_Minh` -  * `Asia/Hong_Kong` -  * `Asia/Hovd` -  * `Asia/Irkutsk` -  * `Asia/Jakarta` -  * `Asia/Jayapura` -  * `Asia/Jerusalem` -  * `Asia/Kabul` -  * `Asia/Kamchatka` -  * `Asia/Karachi` -  * `Asia/Kashgar` -  * `Asia/Kathmandu` -  * `Asia/Katmandu` -  * `Asia/Khandyga` -  * `Asia/Kolkata` -  * `Asia/Krasnoyarsk` -  * `Asia/Kuala_Lumpur` -  * `Asia/Kuching` -  * `Asia/Kuwait` -  * `Asia/Macau` -  * `Asia/Magadan` -  * `Asia/Makassar` -  * `Asia/Manila` -  * `Asia/Muscat` -  * `Asia/Nicosia` -  * `Asia/Novokuznetsk` -  * `Asia/Novosibirsk` -  * `Asia/Omsk` -  * `Asia/Oral` -  * `Asia/Phnom_Penh` -  * `Asia/Pontianak` -  * `Asia/Pyongyang` -  * `Asia/Qatar` -  * `Asia/Qyzylorda` -  * `Asia/Rangoon` -  * `Asia/Riyadh` -  * `Asia/Saigon` -  * `Asia/Sakhalin` -  * `Asia/Samarkand` -  * `Asia/Seoul` -  * `Asia/Shanghai` -  * `Asia/Singapore` -  * `Asia/Taipei` -  * `Asia/Tashkent` -  * `Asia/Tbilisi` -  * `Asia/Tehran` -  * `Asia/Thimphu` -  * `Asia/Tokyo` -  * `Asia/Ulaanbaatar` -  * `Asia/Urumqi` -  * `Asia/Ust-Nera` -  * `Asia/Vientiane` -  * `Asia/Vladivostok` -  * `Asia/Yakutsk` -  * `Asia/Yekaterinburg` -  * `Asia/Yerevan` -  * `Atlantic/Azores` -  * `Atlantic/Bermuda` -  * `Atlantic/Canary` -  * `Atlantic/Cape_Verde` -  * `Atlantic/Faroe` -  * `Atlantic/Madeira` -  * `Atlantic/Reykjavik` -  * `Atlantic/South_Georgia` -  * `Atlantic/St_Helena` -  * `Atlantic/Stanley` -  * `Australia/Adelaide` -  * `Australia/Brisbane` -  * `Australia/Broken_Hill` -  * `Australia/Currie` -  * `Australia/Darwin` -  * `Australia/Eucla` -  * `Australia/Hobart` -  * `Australia/Lindeman` -  * `Australia/Lord_Howe` -  * `Australia/Melbourne` -  * `Australia/Perth` -  * `Australia/Sydney` -  * `Etc/GMT` -  * `Europe/Amsterdam` -  * `Europe/Andorra` -  * `Europe/Athens` -  * `Europe/Belgrade` -  * `Europe/Berlin` -  * `Europe/Bratislava` -  * `Europe/Brussels` -  * `Europe/Bucharest` -  * `Europe/Budapest` -  * `Europe/Busingen` -  * `Europe/Chisinau` -  * `Europe/Copenhagen` -  * `Europe/Dublin` -  * `Europe/Gibraltar` -  * `Europe/Guernsey` -  * `Europe/Helsinki` -  * `Europe/Isle_of_Man` -  * `Europe/Istanbul` -  * `Europe/Jersey` -  * `Europe/Kaliningrad` -  * `Europe/Kiev` -  * `Europe/Lisbon` -  * `Europe/Ljubljana` -  * `Europe/London` -  * `Europe/Luxembourg` -  * `Europe/Madrid` -  * `Europe/Malta` -  * `Europe/Mariehamn` -  * `Europe/Minsk` -  * `Europe/Monaco` -  * `Europe/Moscow` -  * `Europe/Oslo` -  * `Europe/Paris` -  * `Europe/Podgorica` -  * `Europe/Prague` -  * `Europe/Riga` -  * `Europe/Rome` -  * `Europe/Samara` -  * `Europe/San_Marino` -  * `Europe/Sarajevo` -  * `Europe/Simferopol` -  * `Europe/Skopje` -  * `Europe/Sofia` -  * `Europe/Stockholm` -  * `Europe/Tallinn` -  * `Europe/Tirane` -  * `Europe/Uzhgorod` -  * `Europe/Vaduz` -  * `Europe/Vatican` -  * `Europe/Vienna` -  * `Europe/Vilnius` -  * `Europe/Volgograd` -  * `Europe/Warsaw` -  * `Europe/Zagreb` -  * `Europe/Zaporozhye` -  * `Europe/Zurich` -  * `Indian/Antananarivo` -  * `Indian/Chagos` -  * `Indian/Christmas` -  * `Indian/Cocos` -  * `Indian/Comoro` -  * `Indian/Kerguelen` -  * `Indian/Mahe` -  * `Indian/Maldives` -  * `Indian/Mauritius` -  * `Indian/Mayotte` -  * `Indian/Reunion` -  * `Pacific/Apia` -  * `Pacific/Auckland` -  * `Pacific/Chatham` -  * `Pacific/Chuuk` -  * `Pacific/Easter` -  * `Pacific/Efate` -  * `Pacific/Enderbury` -  * `Pacific/Fakaofo` -  * `Pacific/Fiji` -  * `Pacific/Funafuti` -  * `Pacific/Galapagos` -  * `Pacific/Gambier` -  * `Pacific/Guadalcanal` -  * `Pacific/Guam` -  * `Pacific/Honolulu` -  * `Pacific/Johnston` -  * `Pacific/Kiritimati` -  * `Pacific/Kosrae` -  * `Pacific/Kwajalein` -  * `Pacific/Majuro` -  * `Pacific/Marquesas` -  * `Pacific/Midway` -  * `Pacific/Nauru` -  * `Pacific/Norfolk` -  * `Pacific/Noumea` -  * `Pacific/Pago_Pago` -  * `Pacific/Palau` -  * `Pacific/Pitcairn` -  * `Pacific/Pohnpei` -  * `Pacific/Port_Moresby` -  * `Pacific/Rarotonga` -  * `Pacific/Saipan` -  * `Pacific/Tahiti` -  * `Pacific/Tarawa` -  * `Pacific/Tongatapu` -  * `Pacific/Wake` -  * `Pacific/Wallis` -  * `UTC` -. [optional] if omitted the server will use the default value of "Pacific/Niue"  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              SchedulerAbstractSchedulingParams,
              SchedulerBaseScheduleParamsAllOf,
          ],
          'oneOf': [
          ],
        }
