"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.mo_base_complex_type import MoBaseComplexType
    from intersight.model.snmp_user_all_of import SnmpUserAllOf
    globals()['MoBaseComplexType'] = MoBaseComplexType
    globals()['SnmpUserAllOf'] = SnmpUserAllOf


class SnmpUser(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'SNMP.USER': "snmp.User",
        },
        ('object_type',): {
            'SNMP.USER': "snmp.User",
        },
        ('auth_type',): {
            'NA': "NA",
            'MD5': "MD5",
            'SHA': "SHA",
            'SHA-224': "SHA-224",
            'SHA-256': "SHA-256",
            'SHA-384': "SHA-384",
            'SHA-512': "SHA-512",
        },
        ('privacy_type',): {
            'NA': "NA",
            'DES': "DES",
            'AES': "AES",
        },
        ('security_level',): {
            'AUTHPRIV': "AuthPriv",
            'NOAUTHNOPRIV': "NoAuthNoPriv",
            'AUTHNOPRIV': "AuthNoPriv",
        },
    }

    validations = {
        ('name',): {
            'max_length': 31,
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = True

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'auth_password': (str,),  # noqa: E501
            'auth_type': (str,),  # noqa: E501
            'is_auth_password_set': (bool,),  # noqa: E501
            'is_privacy_password_set': (bool,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'privacy_password': (str,),  # noqa: E501
            'privacy_type': (str,),  # noqa: E501
            'security_level': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        val = {
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'auth_password': 'AuthPassword',  # noqa: E501
        'auth_type': 'AuthType',  # noqa: E501
        'is_auth_password_set': 'IsAuthPasswordSet',  # noqa: E501
        'is_privacy_password_set': 'IsPrivacyPasswordSet',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'privacy_password': 'PrivacyPassword',  # noqa: E501
        'privacy_type': 'PrivacyType',  # noqa: E501
        'security_level': 'SecurityLevel',  # noqa: E501
    }

    read_only_vars = {
        'is_auth_password_set',  # noqa: E501
        'is_privacy_password_set',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """SnmpUser - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "snmp.User", must be one of ["snmp.User", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "snmp.User", must be one of ["snmp.User", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            auth_password (str): Authorization password for the user.. [optional]  # noqa: E501
            auth_type (str): Authorization protocol for authenticating the user. * `NA` - Authentication protocol is not applicable. * `MD5` - MD5 protocol is used to authenticate SNMP user. * `SHA` - SHA protocol is used to authenticate SNMP user. * `SHA-224` - SHA-224 protocol is used to authenticate SNMP user. * `SHA-256` - SHA-256 protocol is used to authenticate SNMP user. * `SHA-384` - SHA-384 protocol is used to authenticate SNMP user. * `SHA-512` - SHA-512 protocol is used to authenticate SNMP user.. [optional] if omitted the server will use the default value of "NA"  # noqa: E501
            is_auth_password_set (bool): Indicates whether the value of the 'authPassword' property has been set.. [optional] if omitted the server will use the default value of False  # noqa: E501
            is_privacy_password_set (bool): Indicates whether the value of the 'privacyPassword' property has been set.. [optional] if omitted the server will use the default value of False  # noqa: E501
            name (str): SNMP username. Must have a minimum of 1 and and a maximum of 31 characters.. [optional]  # noqa: E501
            privacy_password (str): Privacy password for the user.. [optional]  # noqa: E501
            privacy_type (str): Privacy protocol for the user. * `NA` - Privacy protocol is not applicable. * `DES` - DES privacy protocol is used for SNMP user. * `AES` - AES privacy protocol is used for SNMP user.. [optional] if omitted the server will use the default value of "NA"  # noqa: E501
            security_level (str): Security mechanism used for communication between agent and manager. * `AuthPriv` - The user requires both an authorization password and a privacy password. * `NoAuthNoPriv` - The user does not require an authorization or privacy password. * `AuthNoPriv` - The user requires an authorization password but not a privacy password.. [optional] if omitted the server will use the default value of "AuthPriv"  # noqa: E501
        """

        class_id = "snmp.User" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "snmp.User")
        object_type = "snmp.User" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "snmp.User")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """SnmpUser - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "snmp.User", must be one of ["snmp.User", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "snmp.User", must be one of ["snmp.User", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            auth_password (str): Authorization password for the user.. [optional]  # noqa: E501
            auth_type (str): Authorization protocol for authenticating the user. * `NA` - Authentication protocol is not applicable. * `MD5` - MD5 protocol is used to authenticate SNMP user. * `SHA` - SHA protocol is used to authenticate SNMP user. * `SHA-224` - SHA-224 protocol is used to authenticate SNMP user. * `SHA-256` - SHA-256 protocol is used to authenticate SNMP user. * `SHA-384` - SHA-384 protocol is used to authenticate SNMP user. * `SHA-512` - SHA-512 protocol is used to authenticate SNMP user.. [optional] if omitted the server will use the default value of "NA"  # noqa: E501
            is_auth_password_set (bool): Indicates whether the value of the 'authPassword' property has been set.. [optional] if omitted the server will use the default value of False  # noqa: E501
            is_privacy_password_set (bool): Indicates whether the value of the 'privacyPassword' property has been set.. [optional] if omitted the server will use the default value of False  # noqa: E501
            name (str): SNMP username. Must have a minimum of 1 and and a maximum of 31 characters.. [optional]  # noqa: E501
            privacy_password (str): Privacy password for the user.. [optional]  # noqa: E501
            privacy_type (str): Privacy protocol for the user. * `NA` - Privacy protocol is not applicable. * `DES` - DES privacy protocol is used for SNMP user. * `AES` - AES privacy protocol is used for SNMP user.. [optional] if omitted the server will use the default value of "NA"  # noqa: E501
            security_level (str): Security mechanism used for communication between agent and manager. * `AuthPriv` - The user requires both an authorization password and a privacy password. * `NoAuthNoPriv` - The user does not require an authorization or privacy password. * `AuthNoPriv` - The user requires an authorization password but not a privacy password.. [optional] if omitted the server will use the default value of "AuthPriv"  # noqa: E501
        """

        class_id = "snmp.User" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "snmp.User")
        object_type = "snmp.User" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "snmp.User")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              MoBaseComplexType,
              SnmpUserAllOf,
          ],
          'oneOf': [
          ],
        }
