"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.display_names import DisplayNames
    from intersight.model.equipment_fru_relationship import EquipmentFruRelationship
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_mo_ref import MoMoRef
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.storage_base_capacity import StorageBaseCapacity
    from intersight.model.storage_net_app_aggregate_relationship import StorageNetAppAggregateRelationship
    from intersight.model.storage_net_app_base_disk import StorageNetAppBaseDisk
    from intersight.model.storage_net_app_cluster_relationship import StorageNetAppClusterRelationship
    from intersight.model.storage_net_app_disk_event_relationship import StorageNetAppDiskEventRelationship
    from intersight.model.storage_net_app_node_relationship import StorageNetAppNodeRelationship
    globals()['DisplayNames'] = DisplayNames
    globals()['EquipmentFruRelationship'] = EquipmentFruRelationship
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoMoRef'] = MoMoRef
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['StorageBaseCapacity'] = StorageBaseCapacity
    globals()['StorageNetAppAggregateRelationship'] = StorageNetAppAggregateRelationship
    globals()['StorageNetAppBaseDisk'] = StorageNetAppBaseDisk
    globals()['StorageNetAppClusterRelationship'] = StorageNetAppClusterRelationship
    globals()['StorageNetAppDiskEventRelationship'] = StorageNetAppDiskEventRelationship
    globals()['StorageNetAppNodeRelationship'] = StorageNetAppNodeRelationship


class StorageNetAppBaseDiskRelationship(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'MO.MOREF': "mo.MoRef",
        },
        ('protocol',): {
            'UNKNOWN': "Unknown",
            'SAS': "SAS",
            'NVME': "NVMe",
            'SATA': "SATA",
        },
        ('status',): {
            'UNKNOWN': "Unknown",
            'OK': "Ok",
            'DEGRADED': "Degraded",
            'CRITICAL': "Critical",
            'OFFLINE': "Offline",
            'IDENTIFYING': "Identifying",
            'NOTAVAILABLE': "NotAvailable",
            'UPDATING': "Updating",
            'UNRECOGNIZED': "Unrecognized",
        },
        ('type',): {
            'UNKNOWN': "Unknown",
            'SSD': "SSD",
            'HDD': "HDD",
            'NVRAM': "NVRAM",
            'SATA': "SATA",
            'BSAS': "BSAS",
            'FC': "FC",
            'FSAS': "FSAS",
            'LUN': "LUN",
            'MSATA': "MSATA",
            'SAS': "SAS",
            'VMDISK': "VMDISK",
        },
        ('container_type',): {
            'UNKNOWN': "Unknown",
            'AGGREGATE': "Aggregate",
            'BROKEN': "Broken",
            'LABEL_MAINTENANCE': "Label Maintenance",
            'FOREIGN': "Foreign",
            'MAINTENANCE': "Maintenance",
            'MEDIATOR': "Mediator",
            'SHARED': "Shared",
            'REMOTE': "Remote",
            'SPARE': "Spare",
            'UNASSIGNED': "Unassigned",
            'UNSUPPORTED': "Unsupported",
        },
        ('disk_type',): {
            'UNKNOWN': "Unknown",
            'SSDNVM': "SSDNVM",
            'ATA': "ATA",
            'FCAL': "FCAL",
            'BSAS': "BSAS",
            'FSAS': "FSAS",
            'LUN': "LUN",
            'SAS': "SAS",
            'MSATA': "MSATA",
            'SSD': "SSD",
            'VMDISK': "VMDISK",
        },
        ('state',): {
            'PRESENT': "Present",
            'COPY': "Copy",
            'BROKEN': "Broken",
            'MAINTENANCE': "Maintenance",
            'PARTNER': "Partner",
            'PENDING': "Pending",
            'RECONSTRUCTING': "Reconstructing",
            'REMOVED': "Removed",
            'SPARE': "Spare",
            'UNFAIL': "Unfail",
            'ZEROING': "Zeroing",
        },
        ('object_type',): {
            'AAA.AUDITRECORD': "aaa.AuditRecord",
            'AAA.RETENTIONCONFIG': "aaa.RetentionConfig",
            'AAA.RETENTIONPOLICY': "aaa.RetentionPolicy",
            'ACCESS.IPADDRESS': "access.IpAddress",
            'ACCESS.POLICY': "access.Policy",
            'ACCESS.POLICYINVENTORY': "access.PolicyInventory",
            'ADAPTER.CONFIGPOLICY': "adapter.ConfigPolicy",
            'ADAPTER.EXTETHINTERFACE': "adapter.ExtEthInterface",
            'ADAPTER.HOSTETHINTERFACE': "adapter.HostEthInterface",
            'ADAPTER.HOSTFCINTERFACE': "adapter.HostFcInterface",
            'ADAPTER.HOSTISCSIINTERFACE': "adapter.HostIscsiInterface",
            'ADAPTER.UNIT': "adapter.Unit",
            'ADAPTER.UNITEXPANDER': "adapter.UnitExpander",
            'APIC.ACIPOD': "apic.AciPod",
            'APIC.APPLICATION': "apic.Application",
            'APIC.APPLICATIONENDPOINTGROUP': "apic.ApplicationEndpointGroup",
            'APIC.BRIDGEDOMAIN': "apic.BridgeDomain",
            'APIC.EXTERNALROUTEDLAYERTHREEDOMAIN': "apic.ExternalRoutedLayerThreeDomain",
            'APIC.FABRICLEAFNODE': "apic.FabricLeafNode",
            'APIC.FABRICLEAFNODEINTERFACE': "apic.FabricLeafNodeInterface",
            'APIC.OUT': "apic.Out",
            'APIC.SUBNET': "apic.Subnet",
            'APIC.TENANT': "apic.Tenant",
            'APIC.VPCGROUP': "apic.VpcGroup",
            'APIC.VRFS': "apic.Vrfs",
            'APPLIANCE.APPOPSTATUS': "appliance.AppOpStatus",
            'APPLIANCE.APPSTATUS': "appliance.AppStatus",
            'APPLIANCE.AUTORMAPOLICY': "appliance.AutoRmaPolicy",
            'APPLIANCE.BACKUP': "appliance.Backup",
            'APPLIANCE.BACKUPMONITOR': "appliance.BackupMonitor",
            'APPLIANCE.BACKUPPOLICY': "appliance.BackupPolicy",
            'APPLIANCE.BACKUPROTATEDATA': "appliance.BackupRotateData",
            'APPLIANCE.CERTIFICATESETTING': "appliance.CertificateSetting",
            'APPLIANCE.CLUSTERINFO': "appliance.ClusterInfo",
            'APPLIANCE.CLUSTERINSTALL': "appliance.ClusterInstall",
            'APPLIANCE.CLUSTERREPLACENODE': "appliance.ClusterReplaceNode",
            'APPLIANCE.CLUSTERWORKERNODE': "appliance.ClusterWorkerNode",
            'APPLIANCE.CLUSTERWORKERNODEREPLACE': "appliance.ClusterWorkerNodeReplace",
            'APPLIANCE.CLUSTERWORKERNODEREUSE': "appliance.ClusterWorkerNodeReuse",
            'APPLIANCE.DATAEXPORTPOLICY': "appliance.DataExportPolicy",
            'APPLIANCE.DEVICECERTIFICATE': "appliance.DeviceCertificate",
            'APPLIANCE.DEVICECLAIM': "appliance.DeviceClaim",
            'APPLIANCE.DEVICECLUSTERINSTALL': "appliance.DeviceClusterInstall",
            'APPLIANCE.DEVICESTATE': "appliance.DeviceState",
            'APPLIANCE.DEVICEUPGRADEPOLICY': "appliance.DeviceUpgradePolicy",
            'APPLIANCE.DIAGSETTING': "appliance.DiagSetting",
            'APPLIANCE.EXTERNALSYSLOGSETTING': "appliance.ExternalSyslogSetting",
            'APPLIANCE.FILEGATEWAY': "appliance.FileGateway",
            'APPLIANCE.FILESYSTEMOPSTATUS': "appliance.FileSystemOpStatus",
            'APPLIANCE.FILESYSTEMSTATUS': "appliance.FileSystemStatus",
            'APPLIANCE.GROUPOPSTATUS': "appliance.GroupOpStatus",
            'APPLIANCE.GROUPSTATUS': "appliance.GroupStatus",
            'APPLIANCE.IMAGEBUNDLE': "appliance.ImageBundle",
            'APPLIANCE.METAMANIFEST': "appliance.MetaManifest",
            'APPLIANCE.METRICSCONFIG': "appliance.MetricsConfig",
            'APPLIANCE.NETWORKLINKSTATUS': "appliance.NetworkLinkStatus",
            'APPLIANCE.NODEINFO': "appliance.NodeInfo",
            'APPLIANCE.NODEOPSTATUS': "appliance.NodeOpStatus",
            'APPLIANCE.NODESTATUS': "appliance.NodeStatus",
            'APPLIANCE.RELEASENOTE': "appliance.ReleaseNote",
            'APPLIANCE.REMOTEFILEIMPORT': "appliance.RemoteFileImport",
            'APPLIANCE.RESTORE': "appliance.Restore",
            'APPLIANCE.SETUPINFO': "appliance.SetupInfo",
            'APPLIANCE.SYSTEMINFO': "appliance.SystemInfo",
            'APPLIANCE.SYSTEMOPSTATUS': "appliance.SystemOpStatus",
            'APPLIANCE.SYSTEMSTATUS': "appliance.SystemStatus",
            'APPLIANCE.UPGRADE': "appliance.Upgrade",
            'APPLIANCE.UPGRADEPOLICY': "appliance.UpgradePolicy",
            'APPLIANCE.UPGRADETRACKER': "appliance.UpgradeTracker",
            'ASSET.CLUSTERMEMBER': "asset.ClusterMember",
            'ASSET.DEPLOYMENT': "asset.Deployment",
            'ASSET.DEPLOYMENTDEVICE': "asset.DeploymentDevice",
            'ASSET.DEVICECLAIM': "asset.DeviceClaim",
            'ASSET.DEVICECONFIGURATION': "asset.DeviceConfiguration",
            'ASSET.DEVICECONNECTORMANAGER': "asset.DeviceConnectorManager",
            'ASSET.DEVICECONTRACTINFORMATION': "asset.DeviceContractInformation",
            'ASSET.DEVICECONTRACTNOTIFICATION': "asset.DeviceContractNotification",
            'ASSET.DEVICEREGISTRATION': "asset.DeviceRegistration",
            'ASSET.GEOLOCATION': "asset.GeoLocation",
            'ASSET.SUBSCRIPTION': "asset.Subscription",
            'ASSET.SUBSCRIPTIONACCOUNT': "asset.SubscriptionAccount",
            'ASSET.SUBSCRIPTIONDEVICECONTRACTINFORMATION': "asset.SubscriptionDeviceContractInformation",
            'ASSET.TARGET': "asset.Target",
            'BIOS.BOOTDEVICE': "bios.BootDevice",
            'BIOS.BOOTMODE': "bios.BootMode",
            'BIOS.POLICY': "bios.Policy",
            'BIOS.SYSTEMBOOTORDER': "bios.SystemBootOrder",
            'BIOS.TOKENSETTINGS': "bios.TokenSettings",
            'BIOS.UNIT': "bios.Unit",
            'BIOS.VFSELECTMEMORYRASCONFIGURATION': "bios.VfSelectMemoryRasConfiguration",
            'BOOT.CDDDEVICE': "boot.CddDevice",
            'BOOT.DEVICEBOOTMODE': "boot.DeviceBootMode",
            'BOOT.DEVICEBOOTSECURITY': "boot.DeviceBootSecurity",
            'BOOT.HDDDEVICE': "boot.HddDevice",
            'BOOT.ISCSIDEVICE': "boot.IscsiDevice",
            'BOOT.NVMEDEVICE': "boot.NvmeDevice",
            'BOOT.PCHSTORAGEDEVICE': "boot.PchStorageDevice",
            'BOOT.PRECISIONPOLICY': "boot.PrecisionPolicy",
            'BOOT.PXEDEVICE': "boot.PxeDevice",
            'BOOT.SANDEVICE': "boot.SanDevice",
            'BOOT.SDDEVICE': "boot.SdDevice",
            'BOOT.UEFISHELLDEVICE': "boot.UefiShellDevice",
            'BOOT.USBDEVICE': "boot.UsbDevice",
            'BOOT.VMEDIADEVICE': "boot.VmediaDevice",
            'BULK.EXPORT': "bulk.Export",
            'BULK.EXPORTEDITEM': "bulk.ExportedItem",
            'BULK.MOCLONER': "bulk.MoCloner",
            'BULK.MODEEPCLONER': "bulk.MoDeepCloner",
            'BULK.MOMERGER': "bulk.MoMerger",
            'BULK.REQUEST': "bulk.Request",
            'BULK.RESULT': "bulk.Result",
            'BULK.SUBREQUESTOBJ': "bulk.SubRequestObj",
            'CAPABILITY.ACTIONSMETADATA': "capability.ActionsMetaData",
            'CAPABILITY.ADAPTERDEPRECATEDDEF': "capability.AdapterDeprecatedDef",
            'CAPABILITY.ADAPTERFIRMWAREREQUIREMENT': "capability.AdapterFirmwareRequirement",
            'CAPABILITY.ADAPTERUNITDESCRIPTOR': "capability.AdapterUnitDescriptor",
            'CAPABILITY.ADAPTERUPDATECONSTRAINTMETA': "capability.AdapterUpdateConstraintMeta",
            'CAPABILITY.ADAPTERUPGRADESUPPORTMETA': "capability.AdapterUpgradeSupportMeta",
            'CAPABILITY.CATALOG': "capability.Catalog",
            'CAPABILITY.CHASSISDESCRIPTOR': "capability.ChassisDescriptor",
            'CAPABILITY.CHASSISMANUFACTURINGDEF': "capability.ChassisManufacturingDef",
            'CAPABILITY.CHASSISUPGRADESUPPORTMETA': "capability.ChassisUpgradeSupportMeta",
            'CAPABILITY.CIMCFIRMWAREDESCRIPTOR': "capability.CimcFirmwareDescriptor",
            'CAPABILITY.CPUENDPOINTDESCRIPTOR': "capability.CpuEndpointDescriptor",
            'CAPABILITY.DIMMSENDPOINTDESCRIPTOR': "capability.DimmsEndpointDescriptor",
            'CAPABILITY.DOMAINPOLICYREQUIREMENT': "capability.DomainPolicyRequirement",
            'CAPABILITY.DRIVESENDPOINTDESCRIPTOR': "capability.DrivesEndpointDescriptor",
            'CAPABILITY.EQUIPMENTPHYSICALDEF': "capability.EquipmentPhysicalDef",
            'CAPABILITY.EQUIPMENTSLOTARRAY': "capability.EquipmentSlotArray",
            'CAPABILITY.FANMODULEDESCRIPTOR': "capability.FanModuleDescriptor",
            'CAPABILITY.FANMODULEMANUFACTURINGDEF': "capability.FanModuleManufacturingDef",
            'CAPABILITY.FEXCAPABILITYDEF': "capability.FexCapabilityDef",
            'CAPABILITY.FEXDESCRIPTOR': "capability.FexDescriptor",
            'CAPABILITY.FEXMANUFACTURINGDEF': "capability.FexManufacturingDef",
            'CAPABILITY.FEXSUPPORTMETA': "capability.FexSupportMeta",
            'CAPABILITY.GPUENDPOINTDESCRIPTOR': "capability.GpuEndpointDescriptor",
            'CAPABILITY.HSUISOFILESUPPORTMETA': "capability.HsuIsoFileSupportMeta",
            'CAPABILITY.IOCARDCAPABILITYDEF': "capability.IoCardCapabilityDef",
            'CAPABILITY.IOCARDDESCRIPTOR': "capability.IoCardDescriptor",
            'CAPABILITY.IOCARDMANUFACTURINGDEF': "capability.IoCardManufacturingDef",
            'CAPABILITY.IOMUPGRADESUPPORTMETA': "capability.IomUpgradeSupportMeta",
            'CAPABILITY.PORTGROUPAGGREGATIONDEF': "capability.PortGroupAggregationDef",
            'CAPABILITY.PROCESSORUNITUPDATECONSTRAINTMETA': "capability.ProcessorUnitUpdateConstraintMeta",
            'CAPABILITY.PSUDESCRIPTOR': "capability.PsuDescriptor",
            'CAPABILITY.PSUMANUFACTURINGDEF': "capability.PsuManufacturingDef",
            'CAPABILITY.SERVERACTIONSMETA': "capability.ServerActionsMeta",
            'CAPABILITY.SERVERDESCRIPTOR': "capability.ServerDescriptor",
            'CAPABILITY.SERVERMODELSCAPABILITYDEF': "capability.ServerModelsCapabilityDef",
            'CAPABILITY.SERVERSCHEMADESCRIPTOR': "capability.ServerSchemaDescriptor",
            'CAPABILITY.SERVERUPGRADESUPPORTMETA': "capability.ServerUpgradeSupportMeta",
            'CAPABILITY.SIOCMODULECAPABILITYDEF': "capability.SiocModuleCapabilityDef",
            'CAPABILITY.SIOCMODULEDESCRIPTOR': "capability.SiocModuleDescriptor",
            'CAPABILITY.SIOCMODULEMANUFACTURINGDEF': "capability.SiocModuleManufacturingDef",
            'CAPABILITY.STANDARDREDFISHSUPPORTMETA': "capability.StandardRedfishSupportMeta",
            'CAPABILITY.STORAGECONTROLLERUPDATECONSTRAINTMETA': "capability.StorageControllerUpdateConstraintMeta",
            'CAPABILITY.STORAGECONTROLLERSMETADATA': "capability.StorageControllersMetaData",
            'CAPABILITY.SWITCHCAPABILITY': "capability.SwitchCapability",
            'CAPABILITY.SWITCHDESCRIPTOR': "capability.SwitchDescriptor",
            'CAPABILITY.SWITCHEQUIPMENTINFO': "capability.SwitchEquipmentInfo",
            'CAPABILITY.SWITCHMANUFACTURINGDEF': "capability.SwitchManufacturingDef",
            'CAPABILITY.TEMPLATECATALOG': "capability.TemplateCatalog",
            'CAPABILITY.UPDATEORDERMETA': "capability.UpdateOrderMeta",
            'CAPABILITY.VICDESCRIPTOR': "capability.VicDescriptor",
            'CATALYSTSDWAN.CONFIGGROUP': "catalystsdwan.ConfigGroup",
            'CATALYSTSDWAN.POLICYGROUP': "catalystsdwan.PolicyGroup",
            'CATALYSTSDWAN.VEDGEDEVICE': "catalystsdwan.VedgeDevice",
            'CERTIFICATEMANAGEMENT.POLICY': "certificatemanagement.Policy",
            'CERTIFICATEMANAGEMENT.POLICYINVENTORY': "certificatemanagement.PolicyInventory",
            'CHANGELOG.ITEM': "changelog.Item",
            'CHASSIS.CONFIGCHANGEDETAIL': "chassis.ConfigChangeDetail",
            'CHASSIS.CONFIGIMPORT': "chassis.ConfigImport",
            'CHASSIS.CONFIGRESULT': "chassis.ConfigResult",
            'CHASSIS.CONFIGRESULTENTRY': "chassis.ConfigResultEntry",
            'CHASSIS.IOMPROFILE': "chassis.IomProfile",
            'CHASSIS.PROFILE': "chassis.Profile",
            'CHASSIS.PROFILETEMPLATE': "chassis.ProfileTemplate",
            'CLOUD.COLLECTINVENTORY': "cloud.CollectInventory",
            'CLOUD.TFCAGENTPOOL': "cloud.TfcAgentpool",
            'CLOUD.TFCORGANIZATION': "cloud.TfcOrganization",
            'CLOUD.TFCWORKSPACE': "cloud.TfcWorkspace",
            'COMM.HTTPPROXYPOLICY': "comm.HttpProxyPolicy",
            'COMM.TAGDEFINITION': "comm.TagDefinition",
            'COMPUTE.BLADE': "compute.Blade",
            'COMPUTE.BLADEIDENTITY': "compute.BladeIdentity",
            'COMPUTE.BOARD': "compute.Board",
            'COMPUTE.DOWNLOADSTATUS': "compute.DownloadStatus",
            'COMPUTE.HOSTUTILITYOPERATION': "compute.HostUtilityOperation",
            'COMPUTE.MAPPING': "compute.Mapping",
            'COMPUTE.PERSONALITY': "compute.Personality",
            'COMPUTE.PHYSICALSUMMARY': "compute.PhysicalSummary",
            'COMPUTE.RACKUNIT': "compute.RackUnit",
            'COMPUTE.RACKUNITIDENTITY': "compute.RackUnitIdentity",
            'COMPUTE.SCRUBPOLICY': "compute.ScrubPolicy",
            'COMPUTE.SERVERIDPOOL': "compute.ServerIdPool",
            'COMPUTE.SERVERPOWERPARAMETERS': "compute.ServerPowerParameters",
            'COMPUTE.SERVERPOWERPOLICY': "compute.ServerPowerPolicy",
            'COMPUTE.SERVERSETTING': "compute.ServerSetting",
            'COMPUTE.VMEDIA': "compute.Vmedia",
            'COND.ALARM': "cond.Alarm",
            'COND.ALARMAGGREGATION': "cond.AlarmAggregation",
            'COND.ALARMCLASSIFICATION': "cond.AlarmClassification",
            'COND.ALARMDEFINITION': "cond.AlarmDefinition",
            'COND.ALARMSUPPRESSION': "cond.AlarmSuppression",
            'COND.HCLSTATUS': "cond.HclStatus",
            'COND.HCLSTATUSDETAIL': "cond.HclStatusDetail",
            'COND.HCLSTATUSJOB': "cond.HclStatusJob",
            'CONNECTORPACK.CONNECTORPACKUPGRADE': "connectorpack.ConnectorPackUpgrade",
            'CONNECTORPACK.UPGRADEIMPACT': "connectorpack.UpgradeImpact",
            'CONSOLE.CONSOLECONFIG': "console.ConsoleConfig",
            'CONVERGEDINFRA.ADAPTERCOMPLIANCEDETAILS': "convergedinfra.AdapterComplianceDetails",
            'CONVERGEDINFRA.POD': "convergedinfra.Pod",
            'CONVERGEDINFRA.PODCOMPLIANCEINFO': "convergedinfra.PodComplianceInfo",
            'CONVERGEDINFRA.SERVERCOMPLIANCEDETAILS': "convergedinfra.ServerComplianceDetails",
            'CONVERGEDINFRA.STORAGECOMPLIANCEDETAILS': "convergedinfra.StorageComplianceDetails",
            'CONVERGEDINFRA.SWITCHCOMPLIANCEDETAILS': "convergedinfra.SwitchComplianceDetails",
            'COREMANAGEMENT.COREFILE': "coremanagement.CoreFile",
            'COREMANAGEMENT.DOWNLOAD': "coremanagement.Download",
            'CRD.CUSTOMRESOURCE': "crd.CustomResource",
            'DEVICECONNECTOR.POLICY': "deviceconnector.Policy",
            'DNAC.DEVICE': "dnac.Device",
            'DNAC.DEVICEINTERFACE': "dnac.DeviceInterface",
            'DNAC.EXTERNALBORDERNODE': "dnac.ExternalBorderNode",
            'DNAC.EXTERNALBORDERNODEINTERFACE': "dnac.ExternalBorderNodeInterface",
            'DNAC.FABRICSITE': "dnac.FabricSite",
            'DNAC.SITE': "dnac.Site",
            'DNAC.SITEIPPOOL': "dnac.SiteIpPool",
            'DNAC.TEMPLATE': "dnac.Template",
            'DNAC.TRANSIT': "dnac.Transit",
            'DNAC.VIRTUALNETWORKFABRICSITE': "dnac.VirtualNetworkFabricSite",
            'ENERGY.DAILYMETRICS': "energy.DailyMetrics",
            'ENERGY.METRICS': "energy.Metrics",
            'EQUIPMENT.CHASSIS': "equipment.Chassis",
            'EQUIPMENT.CHASSISCONTROLLER': "equipment.ChassisController",
            'EQUIPMENT.CHASSISIDPOOL': "equipment.ChassisIdPool",
            'EQUIPMENT.CHASSISIDENTITY': "equipment.ChassisIdentity",
            'EQUIPMENT.CHASSISOPERATION': "equipment.ChassisOperation",
            'EQUIPMENT.DEVICESUMMARY': "equipment.DeviceSummary",
            'EQUIPMENT.ENCLOSUREELEMENT': "equipment.EnclosureElement",
            'EQUIPMENT.ENDPOINTLOG': "equipment.EndPointLog",
            'EQUIPMENT.EXPANDERMODULE': "equipment.ExpanderModule",
            'EQUIPMENT.EXPANDERMODULEIDENTITY': "equipment.ExpanderModuleIdentity",
            'EQUIPMENT.FAN': "equipment.Fan",
            'EQUIPMENT.FANCONTROL': "equipment.FanControl",
            'EQUIPMENT.FANMODULE': "equipment.FanModule",
            'EQUIPMENT.FEX': "equipment.Fex",
            'EQUIPMENT.FEXIDENTITY': "equipment.FexIdentity",
            'EQUIPMENT.FEXOPERATION': "equipment.FexOperation",
            'EQUIPMENT.FRU': "equipment.Fru",
            'EQUIPMENT.HYBRIDDRIVESLOT': "equipment.HybridDriveSlot",
            'EQUIPMENT.IOCARD': "equipment.IoCard",
            'EQUIPMENT.IOCARDOPERATION': "equipment.IoCardOperation",
            'EQUIPMENT.IOEXPANDER': "equipment.IoExpander",
            'EQUIPMENT.LOCATORLED': "equipment.LocatorLed",
            'EQUIPMENT.LOGDOWNLOAD': "equipment.LogDownload",
            'EQUIPMENT.PSU': "equipment.Psu",
            'EQUIPMENT.PSUCONTROL': "equipment.PsuControl",
            'EQUIPMENT.RACKENCLOSURE': "equipment.RackEnclosure",
            'EQUIPMENT.RACKENCLOSURESLOT': "equipment.RackEnclosureSlot",
            'EQUIPMENT.RISER': "equipment.Riser",
            'EQUIPMENT.SENSOR': "equipment.Sensor",
            'EQUIPMENT.SHAREDIOMODULE': "equipment.SharedIoModule",
            'EQUIPMENT.SWITCHCARD': "equipment.SwitchCard",
            'EQUIPMENT.SWITCHOPERATION': "equipment.SwitchOperation",
            'EQUIPMENT.SYSTEMIOCONTROLLER': "equipment.SystemIoController",
            'EQUIPMENT.TPM': "equipment.Tpm",
            'EQUIPMENT.TRANSCEIVER': "equipment.Transceiver",
            'ETHER.HOSTPORT': "ether.HostPort",
            'ETHER.NETWORKPORT': "ether.NetworkPort",
            'ETHER.PHYSICALPORT': "ether.PhysicalPort",
            'ETHER.PORTCHANNEL': "ether.PortChannel",
            'EXTERNALSITE.AUTHORIZATION': "externalsite.Authorization",
            'FABRIC.APPLIANCEPCROLE': "fabric.AppliancePcRole",
            'FABRIC.APPLIANCEROLE': "fabric.ApplianceRole",
            'FABRIC.CONFIGCHANGEDETAIL': "fabric.ConfigChangeDetail",
            'FABRIC.CONFIGRESULT': "fabric.ConfigResult",
            'FABRIC.CONFIGRESULTENTRY': "fabric.ConfigResultEntry",
            'FABRIC.ELEMENTIDENTITY': "fabric.ElementIdentity",
            'FABRIC.ESTIMATEIMPACT': "fabric.EstimateImpact",
            'FABRIC.ETHNETWORKCONTROLPOLICY': "fabric.EthNetworkControlPolicy",
            'FABRIC.ETHNETWORKCONTROLPOLICYINVENTORY': "fabric.EthNetworkControlPolicyInventory",
            'FABRIC.ETHNETWORKGROUPPOLICY': "fabric.EthNetworkGroupPolicy",
            'FABRIC.ETHNETWORKGROUPPOLICYINVENTORY': "fabric.EthNetworkGroupPolicyInventory",
            'FABRIC.ETHNETWORKPOLICY': "fabric.EthNetworkPolicy",
            'FABRIC.FCNETWORKPOLICY': "fabric.FcNetworkPolicy",
            'FABRIC.FCSTORAGEROLE': "fabric.FcStorageRole",
            'FABRIC.FCUPLINKPCROLE': "fabric.FcUplinkPcRole",
            'FABRIC.FCUPLINKROLE': "fabric.FcUplinkRole",
            'FABRIC.FCZONEPOLICY': "fabric.FcZonePolicy",
            'FABRIC.FCOEUPLINKPCROLE': "fabric.FcoeUplinkPcRole",
            'FABRIC.FCOEUPLINKROLE': "fabric.FcoeUplinkRole",
            'FABRIC.FLOWCONTROLPOLICY': "fabric.FlowControlPolicy",
            'FABRIC.LANPINGROUP': "fabric.LanPinGroup",
            'FABRIC.LINKAGGREGATIONPOLICY': "fabric.LinkAggregationPolicy",
            'FABRIC.LINKCONTROLPOLICY': "fabric.LinkControlPolicy",
            'FABRIC.MACSECPOLICY': "fabric.MacSecPolicy",
            'FABRIC.MULTICASTPOLICY': "fabric.MulticastPolicy",
            'FABRIC.PCMEMBER': "fabric.PcMember",
            'FABRIC.PCOPERATION': "fabric.PcOperation",
            'FABRIC.PORTMODE': "fabric.PortMode",
            'FABRIC.PORTOPERATION': "fabric.PortOperation",
            'FABRIC.PORTPOLICY': "fabric.PortPolicy",
            'FABRIC.SANPINGROUP': "fabric.SanPinGroup",
            'FABRIC.SERVERROLE': "fabric.ServerRole",
            'FABRIC.SPANDESTETHPORT': "fabric.SpanDestEthPort",
            'FABRIC.SPANSESSION': "fabric.SpanSession",
            'FABRIC.SPANSOURCEETHPORT': "fabric.SpanSourceEthPort",
            'FABRIC.SPANSOURCEETHPORTCHANNEL': "fabric.SpanSourceEthPortChannel",
            'FABRIC.SPANSOURCEVLAN': "fabric.SpanSourceVlan",
            'FABRIC.SPANSOURCEVNICETHIF': "fabric.SpanSourceVnicEthIf",
            'FABRIC.SWITCHCLUSTERPROFILE': "fabric.SwitchClusterProfile",
            'FABRIC.SWITCHCLUSTERPROFILETEMPLATE': "fabric.SwitchClusterProfileTemplate",
            'FABRIC.SWITCHCONTROLPOLICY': "fabric.SwitchControlPolicy",
            'FABRIC.SWITCHPROFILE': "fabric.SwitchProfile",
            'FABRIC.SWITCHPROFILETEMPLATE': "fabric.SwitchProfileTemplate",
            'FABRIC.SYSTEMQOSPOLICY': "fabric.SystemQosPolicy",
            'FABRIC.UPLINKPCROLE': "fabric.UplinkPcRole",
            'FABRIC.UPLINKROLE': "fabric.UplinkRole",
            'FABRIC.VLAN': "fabric.Vlan",
            'FABRIC.VLANINVENTORY': "fabric.VlanInventory",
            'FABRIC.VLANSET': "fabric.VlanSet",
            'FABRIC.VSAN': "fabric.Vsan",
            'FABRIC.VSANINVENTORY': "fabric.VsanInventory",
            'FAULT.INSTANCE': "fault.Instance",
            'FC.NEIGHBOR': "fc.Neighbor",
            'FC.PHYSICALPORT': "fc.PhysicalPort",
            'FC.PORTCHANNEL': "fc.PortChannel",
            'FCPOOL.FCBLOCK': "fcpool.FcBlock",
            'FCPOOL.LEASE': "fcpool.Lease",
            'FCPOOL.POOL': "fcpool.Pool",
            'FCPOOL.POOLMEMBER': "fcpool.PoolMember",
            'FCPOOL.RESERVATION': "fcpool.Reservation",
            'FCPOOL.UNIVERSE': "fcpool.Universe",
            'FEEDBACK.FEEDBACKPOST': "feedback.FeedbackPost",
            'FIRMWARE.BIOSDESCRIPTOR': "firmware.BiosDescriptor",
            'FIRMWARE.BOARDCONTROLLERDESCRIPTOR': "firmware.BoardControllerDescriptor",
            'FIRMWARE.CHASSISUPGRADE': "firmware.ChassisUpgrade",
            'FIRMWARE.CIMCDESCRIPTOR': "firmware.CimcDescriptor",
            'FIRMWARE.DIMMDESCRIPTOR': "firmware.DimmDescriptor",
            'FIRMWARE.DISTRIBUTABLE': "firmware.Distributable",
            'FIRMWARE.DISTRIBUTABLEMETA': "firmware.DistributableMeta",
            'FIRMWARE.DRIVEDESCRIPTOR': "firmware.DriveDescriptor",
            'FIRMWARE.DRIVERDISTRIBUTABLE': "firmware.DriverDistributable",
            'FIRMWARE.EULA': "firmware.Eula",
            'FIRMWARE.FIRMWARESUMMARY': "firmware.FirmwareSummary",
            'FIRMWARE.GPUDESCRIPTOR': "firmware.GpuDescriptor",
            'FIRMWARE.HBADESCRIPTOR': "firmware.HbaDescriptor",
            'FIRMWARE.IOMDESCRIPTOR': "firmware.IomDescriptor",
            'FIRMWARE.MSWITCHDESCRIPTOR': "firmware.MswitchDescriptor",
            'FIRMWARE.NXOSDESCRIPTOR': "firmware.NxosDescriptor",
            'FIRMWARE.PCIEDESCRIPTOR': "firmware.PcieDescriptor",
            'FIRMWARE.POLICY': "firmware.Policy",
            'FIRMWARE.PSUDESCRIPTOR': "firmware.PsuDescriptor",
            'FIRMWARE.RUNNINGFIRMWARE': "firmware.RunningFirmware",
            'FIRMWARE.SASEXPANDERDESCRIPTOR': "firmware.SasExpanderDescriptor",
            'FIRMWARE.SERVERCONFIGURATIONUTILITYDISTRIBUTABLE': "firmware.ServerConfigurationUtilityDistributable",
            'FIRMWARE.STORAGECONTROLLERDESCRIPTOR': "firmware.StorageControllerDescriptor",
            'FIRMWARE.SWITCHUPGRADE': "firmware.SwitchUpgrade",
            'FIRMWARE.UNSUPPORTEDVERSIONUPGRADE': "firmware.UnsupportedVersionUpgrade",
            'FIRMWARE.UPGRADE': "firmware.Upgrade",
            'FIRMWARE.UPGRADEIMPACT': "firmware.UpgradeImpact",
            'FIRMWARE.UPGRADEIMPACTSTATUS': "firmware.UpgradeImpactStatus",
            'FIRMWARE.UPGRADESTATUS': "firmware.UpgradeStatus",
            'FIRMWARE.UPGRADEVALIDITY': "firmware.UpgradeValidity",
            'FMC.DEVICE': "fmc.Device",
            'FMC.DEVICEHAPAIR': "fmc.DeviceHaPair",
            'FMC.DOMAIN': "fmc.Domain",
            'FMC.PHYSICALINTERFACE': "fmc.PhysicalInterface",
            'FORECAST.CATALOG': "forecast.Catalog",
            'FORECAST.DEFINITION': "forecast.Definition",
            'FORECAST.INSTANCE': "forecast.Instance",
            'GRAPHICS.CARD': "graphics.Card",
            'GRAPHICS.CONTROLLER': "graphics.Controller",
            'HCI.AHVVM': "hci.AhvVm",
            'HCI.AHVVMDISK': "hci.AhvVmDisk",
            'HCI.AHVVMGPU': "hci.AhvVmGpu",
            'HCI.AHVVMNIC': "hci.AhvVmNic",
            'HCI.ALARM': "hci.Alarm",
            'HCI.CLUSTER': "hci.Cluster",
            'HCI.COMPLIANCE': "hci.Compliance",
            'HCI.DISK': "hci.Disk",
            'HCI.DOMAINMANAGER': "hci.DomainManager",
            'HCI.ENTITLEMENT': "hci.Entitlement",
            'HCI.ESXIVM': "hci.EsxiVm",
            'HCI.ESXIVMDISK': "hci.EsxiVmDisk",
            'HCI.ESXIVMNIC': "hci.EsxiVmNic",
            'HCI.GPU': "hci.Gpu",
            'HCI.LICENSE': "hci.License",
            'HCI.NODE': "hci.Node",
            'HCI.PHYSICALGPU': "hci.PhysicalGpu",
            'HCI.VIOLATION': "hci.Violation",
            'HCI.VIRTUALGPU': "hci.VirtualGpu",
            'HCL.COMPATIBILITYSTATUS': "hcl.CompatibilityStatus",
            'HCL.DRIVERIMAGE': "hcl.DriverImage",
            'HCL.EXEMPTEDCATALOG': "hcl.ExemptedCatalog",
            'HCL.HWCATALOGINFO': "hcl.HwCatalogInfo",
            'HCL.HYPERFLEXSOFTWARECOMPATIBILITYINFO': "hcl.HyperflexSoftwareCompatibilityInfo",
            'HCL.OPERATINGSYSTEM': "hcl.OperatingSystem",
            'HCL.OPERATINGSYSTEMVENDOR': "hcl.OperatingSystemVendor",
            'HCL.SERVERCATALOG': "hcl.ServerCatalog",
            'HCL.SERVERHWCATALOGINFO': "hcl.ServerHwCatalogInfo",
            'HCL.SUPPORTEDDRIVERNAME': "hcl.SupportedDriverName",
            'HYPERFLEX.ALARM': "hyperflex.Alarm",
            'HYPERFLEX.APPCATALOG': "hyperflex.AppCatalog",
            'HYPERFLEX.AUTOSUPPORTPOLICY': "hyperflex.AutoSupportPolicy",
            'HYPERFLEX.BACKUPCLUSTER': "hyperflex.BackupCluster",
            'HYPERFLEX.CAPABILITYINFO': "hyperflex.CapabilityInfo",
            'HYPERFLEX.CLUSTER': "hyperflex.Cluster",
            'HYPERFLEX.CLUSTERBACKUPPOLICY': "hyperflex.ClusterBackupPolicy",
            'HYPERFLEX.CLUSTERBACKUPPOLICYDEPLOYMENT': "hyperflex.ClusterBackupPolicyDeployment",
            'HYPERFLEX.CLUSTERBACKUPPOLICYINVENTORY': "hyperflex.ClusterBackupPolicyInventory",
            'HYPERFLEX.CLUSTERHEALTHCHECKEXECUTIONSNAPSHOT': "hyperflex.ClusterHealthCheckExecutionSnapshot",
            'HYPERFLEX.CLUSTERNETWORKPOLICY': "hyperflex.ClusterNetworkPolicy",
            'HYPERFLEX.CLUSTERPROFILE': "hyperflex.ClusterProfile",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICY': "hyperflex.ClusterReplicationNetworkPolicy",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICYDEPLOYMENT': "hyperflex.ClusterReplicationNetworkPolicyDeployment",
            'HYPERFLEX.CLUSTERSTORAGEPOLICY': "hyperflex.ClusterStoragePolicy",
            'HYPERFLEX.CONFIGRESULT': "hyperflex.ConfigResult",
            'HYPERFLEX.CONFIGRESULTENTRY': "hyperflex.ConfigResultEntry",
            'HYPERFLEX.DATAPROTECTIONPEER': "hyperflex.DataProtectionPeer",
            'HYPERFLEX.DATASTORESTATISTIC': "hyperflex.DatastoreStatistic",
            'HYPERFLEX.DEVICEPACKAGEDOWNLOADSTATE': "hyperflex.DevicePackageDownloadState",
            'HYPERFLEX.DRIVE': "hyperflex.Drive",
            'HYPERFLEX.ENCRYPTION': "hyperflex.Encryption",
            'HYPERFLEX.EXTFCSTORAGEPOLICY': "hyperflex.ExtFcStoragePolicy",
            'HYPERFLEX.EXTISCSISTORAGEPOLICY': "hyperflex.ExtIscsiStoragePolicy",
            'HYPERFLEX.FEATURELIMITEXTERNAL': "hyperflex.FeatureLimitExternal",
            'HYPERFLEX.FEATURELIMITINTERNAL': "hyperflex.FeatureLimitInternal",
            'HYPERFLEX.HEALTH': "hyperflex.Health",
            'HYPERFLEX.HEALTHCHECKDEFINITION': "hyperflex.HealthCheckDefinition",
            'HYPERFLEX.HEALTHCHECKEXECUTION': "hyperflex.HealthCheckExecution",
            'HYPERFLEX.HEALTHCHECKEXECUTIONSNAPSHOT': "hyperflex.HealthCheckExecutionSnapshot",
            'HYPERFLEX.HEALTHCHECKPACKAGECHECKSUM': "hyperflex.HealthCheckPackageChecksum",
            'HYPERFLEX.HEALTHCHECKSCHEDULEPOLICY': "hyperflex.HealthCheckSchedulePolicy",
            'HYPERFLEX.HWCATALOG': "hyperflex.HwCatalog",
            'HYPERFLEX.HXDPVERSION': "hyperflex.HxdpVersion",
            'HYPERFLEX.HYPERVISORHOST': "hyperflex.HypervisorHost",
            'HYPERFLEX.HYPERVISORVIRTUALMACHINE': "hyperflex.HypervisorVirtualMachine",
            'HYPERFLEX.INITIATORGROUP': "hyperflex.InitiatorGroup",
            'HYPERFLEX.ISCSINETWORK': "hyperflex.IscsiNetwork",
            'HYPERFLEX.KEYENCRYPTIONKEY': "hyperflex.KeyEncryptionKey",
            'HYPERFLEX.LICENSE': "hyperflex.License",
            'HYPERFLEX.LOCALCREDENTIALPOLICY': "hyperflex.LocalCredentialPolicy",
            'HYPERFLEX.LUN': "hyperflex.Lun",
            'HYPERFLEX.NODE': "hyperflex.Node",
            'HYPERFLEX.NODECONFIGPOLICY': "hyperflex.NodeConfigPolicy",
            'HYPERFLEX.NODEPROFILE': "hyperflex.NodeProfile",
            'HYPERFLEX.PROTECTEDCLUSTER': "hyperflex.ProtectedCluster",
            'HYPERFLEX.PROXYSETTINGPOLICY': "hyperflex.ProxySettingPolicy",
            'HYPERFLEX.REDUCERESYNC': "hyperflex.ReduceReSync",
            'HYPERFLEX.SERVERFIRMWAREVERSION': "hyperflex.ServerFirmwareVersion",
            'HYPERFLEX.SERVERFIRMWAREVERSIONENTRY': "hyperflex.ServerFirmwareVersionEntry",
            'HYPERFLEX.SERVERMODEL': "hyperflex.ServerModel",
            'HYPERFLEX.SERVICEAUTHTOKEN': "hyperflex.ServiceAuthToken",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONCOMPONENT': "hyperflex.SoftwareDistributionComponent",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONENTRY': "hyperflex.SoftwareDistributionEntry",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONVERSION': "hyperflex.SoftwareDistributionVersion",
            'HYPERFLEX.SOFTWAREVERSIONPOLICY': "hyperflex.SoftwareVersionPolicy",
            'HYPERFLEX.STARTREDUCERESYNC': "hyperflex.StartReduceReSync",
            'HYPERFLEX.STORAGECONTAINER': "hyperflex.StorageContainer",
            'HYPERFLEX.SYSCONFIGPOLICY': "hyperflex.SysConfigPolicy",
            'HYPERFLEX.TARGET': "hyperflex.Target",
            'HYPERFLEX.UCSMCONFIGPOLICY': "hyperflex.UcsmConfigPolicy",
            'HYPERFLEX.VCENTERCONFIGPOLICY': "hyperflex.VcenterConfigPolicy",
            'HYPERFLEX.VMBACKUPINFO': "hyperflex.VmBackupInfo",
            'HYPERFLEX.VMIMPORTOPERATION': "hyperflex.VmImportOperation",
            'HYPERFLEX.VMRESTOREOPERATION': "hyperflex.VmRestoreOperation",
            'HYPERFLEX.VMSNAPSHOTINFO': "hyperflex.VmSnapshotInfo",
            'HYPERFLEX.VOLUME': "hyperflex.Volume",
            'HYPERFLEX.WITNESSCONFIGURATION': "hyperflex.WitnessConfiguration",
            'IAAS.CONNECTORPACK': "iaas.ConnectorPack",
            'IAAS.CUSTOMTASKINFO': "iaas.CustomTaskInfo",
            'IAAS.DEVICESTATUS': "iaas.DeviceStatus",
            'IAAS.DIAGNOSTICMESSAGES': "iaas.DiagnosticMessages",
            'IAAS.LICENSEINFO': "iaas.LicenseInfo",
            'IAAS.MOSTRUNTASKS': "iaas.MostRunTasks",
            'IAAS.SERVICEREQUEST': "iaas.ServiceRequest",
            'IAAS.SYSTEMTASKINFO': "iaas.SystemTaskInfo",
            'IAAS.UCSDINFO': "iaas.UcsdInfo",
            'IAAS.UCSDMANAGEDINFRA': "iaas.UcsdManagedInfra",
            'IAAS.UCSDMESSAGES': "iaas.UcsdMessages",
            'IAM.ACCOUNT': "iam.Account",
            'IAM.ACCOUNTEXPERIENCE': "iam.AccountExperience",
            'IAM.APIKEY': "iam.ApiKey",
            'IAM.APPREGISTRATION': "iam.AppRegistration",
            'IAM.BANNERMESSAGE': "iam.BannerMessage",
            'IAM.CERTIFICATE': "iam.Certificate",
            'IAM.CERTIFICATEREQUEST': "iam.CertificateRequest",
            'IAM.DEFAULTAUTHENTICATION': "iam.DefaultAuthentication",
            'IAM.DOMAINGROUP': "iam.DomainGroup",
            'IAM.DOMAINNAMEINFO': "iam.DomainNameInfo",
            'IAM.ENDPOINTPRIVILEGE': "iam.EndPointPrivilege",
            'IAM.ENDPOINTROLE': "iam.EndPointRole",
            'IAM.ENDPOINTUSER': "iam.EndPointUser",
            'IAM.ENDPOINTUSERINVENTORY': "iam.EndPointUserInventory",
            'IAM.ENDPOINTUSERPOLICY': "iam.EndPointUserPolicy",
            'IAM.ENDPOINTUSERPOLICYINVENTORY': "iam.EndPointUserPolicyInventory",
            'IAM.ENDPOINTUSERROLE': "iam.EndPointUserRole",
            'IAM.ENDPOINTUSERROLEINVENTORY': "iam.EndPointUserRoleInventory",
            'IAM.GUESTACCESSSETTINGS': "iam.GuestAccessSettings",
            'IAM.IDP': "iam.Idp",
            'IAM.IDPREFERENCE': "iam.IdpReference",
            'IAM.IPACCESSMANAGEMENT': "iam.IpAccessManagement",
            'IAM.IPADDRESS': "iam.IpAddress",
            'IAM.LDAPCONFIGPARAMS': "iam.LdapConfigParams",
            'IAM.LDAPGROUP': "iam.LdapGroup",
            'IAM.LDAPMETA': "iam.LdapMeta",
            'IAM.LDAPPOLICY': "iam.LdapPolicy",
            'IAM.LDAPPROVIDER': "iam.LdapProvider",
            'IAM.LOCALUSERPASSWORD': "iam.LocalUserPassword",
            'IAM.LOCALUSERPASSWORDPOLICY': "iam.LocalUserPasswordPolicy",
            'IAM.OAUTHTOKEN': "iam.OAuthToken",
            'IAM.PERMISSION': "iam.Permission",
            'IAM.PRIVATEKEYSPEC': "iam.PrivateKeySpec",
            'IAM.PRIVILEGE': "iam.Privilege",
            'IAM.PRIVILEGESET': "iam.PrivilegeSet",
            'IAM.QUALIFIER': "iam.Qualifier",
            'IAM.RESOURCELIMITS': "iam.ResourceLimits",
            'IAM.RESOURCEPERMISSION': "iam.ResourcePermission",
            'IAM.RESOURCEROLES': "iam.ResourceRoles",
            'IAM.ROLE': "iam.Role",
            'IAM.SECURITYHOLDER': "iam.SecurityHolder",
            'IAM.SERVICEPROVIDER': "iam.ServiceProvider",
            'IAM.SESSION': "iam.Session",
            'IAM.SESSIONLIMITS': "iam.SessionLimits",
            'IAM.SHARINGRULE': "iam.SharingRule",
            'IAM.SYSTEM': "iam.System",
            'IAM.TESTIDPCONFIGURATION': "iam.TestIdpConfiguration",
            'IAM.TRUSTPOINT': "iam.TrustPoint",
            'IAM.USER': "iam.User",
            'IAM.USERGROUP': "iam.UserGroup",
            'IAM.USERPREFERENCE': "iam.UserPreference",
            'IAM.USERQUALIFIER': "iam.UserQualifier",
            'IAM.USERSETTING': "iam.UserSetting",
            'INVENTORY.DEVICEINFO': "inventory.DeviceInfo",
            'INVENTORY.DNMOBINDING': "inventory.DnMoBinding",
            'INVENTORY.GENERICINVENTORY': "inventory.GenericInventory",
            'INVENTORY.GENERICINVENTORYHOLDER': "inventory.GenericInventoryHolder",
            'INVENTORY.REQUEST': "inventory.Request",
            'IPMIOVERLAN.POLICY': "ipmioverlan.Policy",
            'IPMIOVERLAN.POLICYINVENTORY': "ipmioverlan.PolicyInventory",
            'IPPOOL.BLOCKLEASE': "ippool.BlockLease",
            'IPPOOL.IPLEASE': "ippool.IpLease",
            'IPPOOL.POOL': "ippool.Pool",
            'IPPOOL.POOLMEMBER': "ippool.PoolMember",
            'IPPOOL.RESERVATION': "ippool.Reservation",
            'IPPOOL.SHADOWBLOCK': "ippool.ShadowBlock",
            'IPPOOL.SHADOWPOOL': "ippool.ShadowPool",
            'IPPOOL.UNIVERSE': "ippool.Universe",
            'IQNPOOL.BLOCK': "iqnpool.Block",
            'IQNPOOL.LEASE': "iqnpool.Lease",
            'IQNPOOL.POOL': "iqnpool.Pool",
            'IQNPOOL.POOLMEMBER': "iqnpool.PoolMember",
            'IQNPOOL.RESERVATION': "iqnpool.Reservation",
            'IQNPOOL.UNIVERSE': "iqnpool.Universe",
            'IWOTENANT.MAINTENANCENOTIFICATION': "iwotenant.MaintenanceNotification",
            'IWOTENANT.MIGRATE': "iwotenant.Migrate",
            'IWOTENANT.TENANTCUSTOMIZATION': "iwotenant.TenantCustomization",
            'IWOTENANT.TENANTSTATUS': "iwotenant.TenantStatus",
            'KUBERNETES.ACICNIAPIC': "kubernetes.AciCniApic",
            'KUBERNETES.ACICNIPROFILE': "kubernetes.AciCniProfile",
            'KUBERNETES.ACICNITENANTCLUSTERALLOCATION': "kubernetes.AciCniTenantClusterAllocation",
            'KUBERNETES.ADDONDEFINITION': "kubernetes.AddonDefinition",
            'KUBERNETES.ADDONPOLICY': "kubernetes.AddonPolicy",
            'KUBERNETES.ADDONREPOSITORY': "kubernetes.AddonRepository",
            'KUBERNETES.BAREMETALNODEPROFILE': "kubernetes.BaremetalNodeProfile",
            'KUBERNETES.CATALOG': "kubernetes.Catalog",
            'KUBERNETES.CLUSTER': "kubernetes.Cluster",
            'KUBERNETES.CLUSTERADDONPROFILE': "kubernetes.ClusterAddonProfile",
            'KUBERNETES.CLUSTERPROFILE': "kubernetes.ClusterProfile",
            'KUBERNETES.CONFIGRESULT': "kubernetes.ConfigResult",
            'KUBERNETES.CONFIGRESULTENTRY': "kubernetes.ConfigResultEntry",
            'KUBERNETES.CONTAINERRUNTIMEPOLICY': "kubernetes.ContainerRuntimePolicy",
            'KUBERNETES.DAEMONSET': "kubernetes.DaemonSet",
            'KUBERNETES.DEPLOYMENT': "kubernetes.Deployment",
            'KUBERNETES.HTTPPROXYPOLICY': "kubernetes.HttpProxyPolicy",
            'KUBERNETES.INGRESS': "kubernetes.Ingress",
            'KUBERNETES.NETWORKPOLICY': "kubernetes.NetworkPolicy",
            'KUBERNETES.NODE': "kubernetes.Node",
            'KUBERNETES.NODEGROUPPROFILE': "kubernetes.NodeGroupProfile",
            'KUBERNETES.NVIDIAGPUPRODUCT': "kubernetes.NvidiaGpuProduct",
            'KUBERNETES.POD': "kubernetes.Pod",
            'KUBERNETES.SERVICE': "kubernetes.Service",
            'KUBERNETES.STATEFULSET': "kubernetes.StatefulSet",
            'KUBERNETES.SYSCONFIGPOLICY': "kubernetes.SysConfigPolicy",
            'KUBERNETES.TRUSTEDREGISTRIESPOLICY': "kubernetes.TrustedRegistriesPolicy",
            'KUBERNETES.VERSION': "kubernetes.Version",
            'KUBERNETES.VERSIONPOLICY': "kubernetes.VersionPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRACONFIGPOLICY': "kubernetes.VirtualMachineInfraConfigPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRASTRUCTUREPROVIDER': "kubernetes.VirtualMachineInfrastructureProvider",
            'KUBERNETES.VIRTUALMACHINEINSTANCETYPE': "kubernetes.VirtualMachineInstanceType",
            'KUBERNETES.VIRTUALMACHINENODEPROFILE': "kubernetes.VirtualMachineNodeProfile",
            'KVM.POLICY': "kvm.Policy",
            'KVM.POLICYINVENTORY': "kvm.PolicyInventory",
            'KVM.SESSION': "kvm.Session",
            'KVM.TUNNEL': "kvm.Tunnel",
            'KVM.TUNNELEDKVMPOLICY': "kvm.TunneledKvmPolicy",
            'LICENSE.ACCOUNTLICENSEDATA': "license.AccountLicenseData",
            'LICENSE.CUSTOMEROP': "license.CustomerOp",
            'LICENSE.ERPCUSTOMEROP': "license.ErpCustomerOp",
            'LICENSE.ERPLICENSECOUNT': "license.ErpLicenseCount",
            'LICENSE.IKSCUSTOMEROP': "license.IksCustomerOp",
            'LICENSE.IKSLICENSECOUNT': "license.IksLicenseCount",
            'LICENSE.INCCUSTOMEROP': "license.IncCustomerOp",
            'LICENSE.INCLICENSECOUNT': "license.IncLicenseCount",
            'LICENSE.IWOCUSTOMEROP': "license.IwoCustomerOp",
            'LICENSE.IWOLICENSECOUNT': "license.IwoLicenseCount",
            'LICENSE.LICENSEINFO': "license.LicenseInfo",
            'LICENSE.LICENSEINFOVIEW': "license.LicenseInfoView",
            'LICENSE.LICENSEREGISTRATIONSTATUS': "license.LicenseRegistrationStatus",
            'LICENSE.LICENSERESERVATIONOP': "license.LicenseReservationOp",
            'LICENSE.SMARTLICENSETOKEN': "license.SmartlicenseToken",
            'LS.SERVICEPROFILE': "ls.ServiceProfile",
            'MACPOOL.IDBLOCK': "macpool.IdBlock",
            'MACPOOL.LEASE': "macpool.Lease",
            'MACPOOL.POOL': "macpool.Pool",
            'MACPOOL.POOLMEMBER': "macpool.PoolMember",
            'MACPOOL.RESERVATION': "macpool.Reservation",
            'MACPOOL.UNIVERSE': "macpool.Universe",
            'MANAGEMENT.CONTROLLER': "management.Controller",
            'MANAGEMENT.ENTITY': "management.Entity",
            'MANAGEMENT.INTERFACE': "management.Interface",
            'MARKETPLACE.USECASE': "marketplace.UseCase",
            'MARKETPLACE.USECASEVERSION': "marketplace.UseCaseVersion",
            'MEMORY.ARRAY': "memory.Array",
            'MEMORY.PERSISTENTMEMORYCONFIGRESULT': "memory.PersistentMemoryConfigResult",
            'MEMORY.PERSISTENTMEMORYCONFIGURATION': "memory.PersistentMemoryConfiguration",
            'MEMORY.PERSISTENTMEMORYNAMESPACE': "memory.PersistentMemoryNamespace",
            'MEMORY.PERSISTENTMEMORYNAMESPACECONFIGRESULT': "memory.PersistentMemoryNamespaceConfigResult",
            'MEMORY.PERSISTENTMEMORYPOLICY': "memory.PersistentMemoryPolicy",
            'MEMORY.PERSISTENTMEMORYREGION': "memory.PersistentMemoryRegion",
            'MEMORY.PERSISTENTMEMORYUNIT': "memory.PersistentMemoryUnit",
            'MEMORY.POLICY': "memory.Policy",
            'MEMORY.POLICYINVENTORY': "memory.PolicyInventory",
            'MEMORY.UNIT': "memory.Unit",
            'MERAKI.DEVICE': "meraki.Device",
            'MERAKI.NETWORK': "meraki.Network",
            'MERAKI.ORGANIZATION': "meraki.Organization",
            'MERAKI.PORTPROFILE': "meraki.PortProfile",
            'MERAKI.TAG': "meraki.Tag",
            'META.DEFINITION': "meta.Definition",
            'METRICS.CONFIGURATION': "metrics.Configuration",
            'METRICS.METRICSEXPLORATION': "metrics.MetricsExploration",
            'METRICS.RESOURCECONFIGURATION': "metrics.ResourceConfiguration",
            'MONITORING.HEALTHSTATUS': "monitoring.HealthStatus",
            'NETWORK.DISCOVEREDNEIGHBOR': "network.DiscoveredNeighbor",
            'NETWORK.DNS': "network.Dns",
            'NETWORK.ELEMENT': "network.Element",
            'NETWORK.ELEMENTSUMMARY': "network.ElementSummary",
            'NETWORK.FCZONEINFO': "network.FcZoneInfo",
            'NETWORK.FEATURECONTROL': "network.FeatureControl",
            'NETWORK.INTERFACELIST': "network.InterfaceList",
            'NETWORK.LICENSEFILE': "network.LicenseFile",
            'NETWORK.SUPERVISORCARD': "network.SupervisorCard",
            'NETWORK.TELEMETRYCHECK': "network.TelemetryCheck",
            'NETWORK.VETHERNET': "network.Vethernet",
            'NETWORK.VFC': "network.Vfc",
            'NETWORK.VLANPORTINFO': "network.VlanPortInfo",
            'NETWORK.VPCDOMAIN': "network.VpcDomain",
            'NETWORK.VPCMEMBER': "network.VpcMember",
            'NETWORK.VPCPEER': "network.VpcPeer",
            'NETWORK.VRF': "network.Vrf",
            'NETWORKCONFIG.POLICY': "networkconfig.Policy",
            'NETWORKCONFIG.POLICYINVENTORY': "networkconfig.PolicyInventory",
            'NIAAPI.APICCCOPOST': "niaapi.ApicCcoPost",
            'NIAAPI.APICFIELDNOTICE': "niaapi.ApicFieldNotice",
            'NIAAPI.APICHWEOL': "niaapi.ApicHweol",
            'NIAAPI.APICLATESTMAINTAINEDRELEASE': "niaapi.ApicLatestMaintainedRelease",
            'NIAAPI.APICRELEASERECOMMEND': "niaapi.ApicReleaseRecommend",
            'NIAAPI.APICSWEOL': "niaapi.ApicSweol",
            'NIAAPI.DCNMCCOPOST': "niaapi.DcnmCcoPost",
            'NIAAPI.DCNMFIELDNOTICE': "niaapi.DcnmFieldNotice",
            'NIAAPI.DCNMHWEOL': "niaapi.DcnmHweol",
            'NIAAPI.DCNMLATESTMAINTAINEDRELEASE': "niaapi.DcnmLatestMaintainedRelease",
            'NIAAPI.DCNMRELEASERECOMMEND': "niaapi.DcnmReleaseRecommend",
            'NIAAPI.DCNMSWEOL': "niaapi.DcnmSweol",
            'NIAAPI.FILEDOWNLOADER': "niaapi.FileDownloader",
            'NIAAPI.NIAMETADATA': "niaapi.NiaMetadata",
            'NIAAPI.NIBFILEDOWNLOADER': "niaapi.NibFileDownloader",
            'NIAAPI.NIBMETADATA': "niaapi.NibMetadata",
            'NIAAPI.PUVSCRIPTDOWNLOADER': "niaapi.PuvScriptDownloader",
            'NIAAPI.SNVALIDATORMETADATA': "niaapi.SnValidatorMetadata",
            'NIAAPI.UPGRADEASSISTFILE': "niaapi.UpgradeAssistFile",
            'NIAAPI.VERSIONREGEX': "niaapi.VersionRegex",
            'NIATELEMETRY.AAALDAPPROVIDERDETAILS': "niatelemetry.AaaLdapProviderDetails",
            'NIATELEMETRY.AAARADIUSPROVIDERDETAILS': "niatelemetry.AaaRadiusProviderDetails",
            'NIATELEMETRY.AAATACACSPROVIDERDETAILS': "niatelemetry.AaaTacacsProviderDetails",
            'NIATELEMETRY.APICAPPPLUGINDETAILS': "niatelemetry.ApicAppPluginDetails",
            'NIATELEMETRY.APICCOREFILEDETAILS': "niatelemetry.ApicCoreFileDetails",
            'NIATELEMETRY.APICDBGEXPRSEXPORTDEST': "niatelemetry.ApicDbgexpRsExportDest",
            'NIATELEMETRY.APICDBGEXPRSTSSCHEDULER': "niatelemetry.ApicDbgexpRsTsScheduler",
            'NIATELEMETRY.APICFANDETAILS': "niatelemetry.ApicFanDetails",
            'NIATELEMETRY.APICFEXDETAILS': "niatelemetry.ApicFexDetails",
            'NIATELEMETRY.APICFLASHDETAILS': "niatelemetry.ApicFlashDetails",
            'NIATELEMETRY.APICNTPAUTH': "niatelemetry.ApicNtpAuth",
            'NIATELEMETRY.APICPERFORMANCEDATA': "niatelemetry.ApicPerformanceData",
            'NIATELEMETRY.APICPODDATA': "niatelemetry.ApicPodData",
            'NIATELEMETRY.APICPSUDETAILS': "niatelemetry.ApicPsuDetails",
            'NIATELEMETRY.APICREALMDETAILS': "niatelemetry.ApicRealmDetails",
            'NIATELEMETRY.APICSNMPCLIENTGRPDETAILS': "niatelemetry.ApicSnmpClientGrpDetails",
            'NIATELEMETRY.APICSNMPCOMMUNITYACCESSDETAILS': "niatelemetry.ApicSnmpCommunityAccessDetails",
            'NIATELEMETRY.APICSNMPCOMMUNITYDETAILS': "niatelemetry.ApicSnmpCommunityDetails",
            'NIATELEMETRY.APICSNMPTRAPDETAILS': "niatelemetry.ApicSnmpTrapDetails",
            'NIATELEMETRY.APICSNMPTRAPFWDSERVERDETAILS': "niatelemetry.ApicSnmpTrapFwdServerDetails",
            'NIATELEMETRY.APICSNMPVERSIONTHREEDETAILS': "niatelemetry.ApicSnmpVersionThreeDetails",
            'NIATELEMETRY.APICSYSLOGGRP': "niatelemetry.ApicSysLogGrp",
            'NIATELEMETRY.APICSYSLOGSRC': "niatelemetry.ApicSysLogSrc",
            'NIATELEMETRY.APICTRANSCEIVERDETAILS': "niatelemetry.ApicTransceiverDetails",
            'NIATELEMETRY.APICUIPAGECOUNTS': "niatelemetry.ApicUiPageCounts",
            'NIATELEMETRY.APICVISION': "niatelemetry.ApicVision",
            'NIATELEMETRY.APPDETAILS': "niatelemetry.AppDetails",
            'NIATELEMETRY.CLOUDDETAILS': "niatelemetry.CloudDetails",
            'NIATELEMETRY.COMMONPOLICIES': "niatelemetry.CommonPolicies",
            'NIATELEMETRY.DCNMFANDETAILS': "niatelemetry.DcnmFanDetails",
            'NIATELEMETRY.DCNMFEXDETAILS': "niatelemetry.DcnmFexDetails",
            'NIATELEMETRY.DCNMMODULEDETAILS': "niatelemetry.DcnmModuleDetails",
            'NIATELEMETRY.DCNMPSUDETAILS': "niatelemetry.DcnmPsuDetails",
            'NIATELEMETRY.DCNMTRANSCEIVERDETAILS': "niatelemetry.DcnmTransceiverDetails",
            'NIATELEMETRY.DOMINFOOBJECT': "niatelemetry.DomInfoObject",
            'NIATELEMETRY.DOMTHRESINFOOBJECT': "niatelemetry.DomThresInfoObject",
            'NIATELEMETRY.EPG': "niatelemetry.Epg",
            'NIATELEMETRY.FABRICMODULEDETAILS': "niatelemetry.FabricModuleDetails",
            'NIATELEMETRY.FABRICNODECONTROLDETAILS': "niatelemetry.FabricNodeControlDetails",
            'NIATELEMETRY.FABRICPODPROFILE': "niatelemetry.FabricPodProfile",
            'NIATELEMETRY.FABRICPODSS': "niatelemetry.FabricPodSs",
            'NIATELEMETRY.FAULT': "niatelemetry.Fault",
            'NIATELEMETRY.HCLOUDDETAILS': "niatelemetry.HcloudDetails",
            'NIATELEMETRY.HEALTHINSIGHTSDATA': "niatelemetry.HealthInsightsData",
            'NIATELEMETRY.HTTPSACLCONTRACTDETAILS': "niatelemetry.HttpsAclContractDetails",
            'NIATELEMETRY.HTTPSACLCONTRACTFILTERMAP': "niatelemetry.HttpsAclContractFilterMap",
            'NIATELEMETRY.HTTPSACLEPGCONTRACTMAP': "niatelemetry.HttpsAclEpgContractMap",
            'NIATELEMETRY.HTTPSACLEPGDETAILS': "niatelemetry.HttpsAclEpgDetails",
            'NIATELEMETRY.HTTPSACLFILTERDETAILS': "niatelemetry.HttpsAclFilterDetails",
            'NIATELEMETRY.INSIGHTGROUPDETAILS': "niatelemetry.InsightGroupDetails",
            'NIATELEMETRY.LC': "niatelemetry.Lc",
            'NIATELEMETRY.LEAFPOLGRPDETAILS': "niatelemetry.LeafPolGrpDetails",
            'NIATELEMETRY.MDSNEIGHBORS': "niatelemetry.MdsNeighbors",
            'NIATELEMETRY.MSOCONTRACTDETAILS': "niatelemetry.MsoContractDetails",
            'NIATELEMETRY.MSOEPGDETAILS': "niatelemetry.MsoEpgDetails",
            'NIATELEMETRY.MSOSCHEMADETAILS': "niatelemetry.MsoSchemaDetails",
            'NIATELEMETRY.MSOSITEDETAILS': "niatelemetry.MsoSiteDetails",
            'NIATELEMETRY.MSOTENANTDETAILS': "niatelemetry.MsoTenantDetails",
            'NIATELEMETRY.NEXUSCLOUDACCOUNT': "niatelemetry.NexusCloudAccount",
            'NIATELEMETRY.NEXUSCLOUDSITE': "niatelemetry.NexusCloudSite",
            'NIATELEMETRY.NEXUSDASHBOARDCONTROLLERDETAILS': "niatelemetry.NexusDashboardControllerDetails",
            'NIATELEMETRY.NEXUSDASHBOARDDETAILS': "niatelemetry.NexusDashboardDetails",
            'NIATELEMETRY.NEXUSDASHBOARDMEMORYDETAILS': "niatelemetry.NexusDashboardMemoryDetails",
            'NIATELEMETRY.NEXUSDASHBOARDS': "niatelemetry.NexusDashboards",
            'NIATELEMETRY.NIAFEATUREUSAGE': "niatelemetry.NiaFeatureUsage",
            'NIATELEMETRY.NIAINVENTORY': "niatelemetry.NiaInventory",
            'NIATELEMETRY.NIAINVENTORYDCNM': "niatelemetry.NiaInventoryDcnm",
            'NIATELEMETRY.NIAINVENTORYFABRIC': "niatelemetry.NiaInventoryFabric",
            'NIATELEMETRY.NIALICENSESTATE': "niatelemetry.NiaLicenseState",
            'NIATELEMETRY.NICC': "niatelemetry.Nicc",
            'NIATELEMETRY.PASSWORDSTRENGTHCHECK': "niatelemetry.PasswordStrengthCheck",
            'NIATELEMETRY.PODCOMMPOLICIES': "niatelemetry.PodCommPolicies",
            'NIATELEMETRY.PODSNMPPOLICIES': "niatelemetry.PodSnmpPolicies",
            'NIATELEMETRY.PODTIMESERVERPOLICIES': "niatelemetry.PodTimeServerPolicies",
            'NIATELEMETRY.SITEINVENTORY': "niatelemetry.SiteInventory",
            'NIATELEMETRY.SNMPSRC': "niatelemetry.SnmpSrc",
            'NIATELEMETRY.SPINEPOLGRPDETAILS': "niatelemetry.SpinePolGrpDetails",
            'NIATELEMETRY.SSHVERSIONTWO': "niatelemetry.SshVersionTwo",
            'NIATELEMETRY.SUPERVISORMODULEDETAILS': "niatelemetry.SupervisorModuleDetails",
            'NIATELEMETRY.SYSLOGREMOTEDEST': "niatelemetry.SyslogRemoteDest",
            'NIATELEMETRY.SYSLOGSYSMSG': "niatelemetry.SyslogSysMsg",
            'NIATELEMETRY.SYSLOGSYSMSGFACFILTER': "niatelemetry.SyslogSysMsgFacFilter",
            'NIATELEMETRY.SYSTEMCONTROLLERDETAILS': "niatelemetry.SystemControllerDetails",
            'NIATELEMETRY.TENANT': "niatelemetry.Tenant",
            'NOTIFICATION.ACCOUNTSUBSCRIPTION': "notification.AccountSubscription",
            'NTP.NTPSERVER': "ntp.NtpServer",
            'NTP.POLICY': "ntp.Policy",
            'OAUTH.ACCESSTOKEN': "oauth.AccessToken",
            'OAUTH.AUTHORIZATION': "oauth.Authorization",
            'OPENAPI.APIMETHODMETA': "openapi.ApiMethodMeta",
            'OPENAPI.OPENAPISPECIFICATION': "openapi.OpenApiSpecification",
            'OPENAPI.PROCESSFILE': "openapi.ProcessFile",
            'OPENAPI.TASKGENERATIONREQUEST': "openapi.TaskGenerationRequest",
            'OPENAPI.TASKGENERATIONRESULT': "openapi.TaskGenerationResult",
            'OPRS.DEPLOYMENT': "oprs.Deployment",
            'OPRS.SYNCTARGETLISTMESSAGE': "oprs.SyncTargetListMessage",
            'ORGANIZATION.ORGANIZATION': "organization.Organization",
            'OS.BULKINSTALLINFO': "os.BulkInstallInfo",
            'OS.CATALOG': "os.Catalog",
            'OS.CONFIGURATIONFILE': "os.ConfigurationFile",
            'OS.DISTRIBUTION': "os.Distribution",
            'OS.INSTALL': "os.Install",
            'OS.OSSUPPORT': "os.OsSupport",
            'OS.SUPPORTEDVERSION': "os.SupportedVersion",
            'OS.TEMPLATEFILE': "os.TemplateFile",
            'OS.VALIDINSTALLTARGET': "os.ValidInstallTarget",
            'OS.VALIDREMOTETARGET': "os.ValidRemoteTarget",
            'PARTNERINTEGRATION.DCLOGS': "partnerintegration.DcLogs",
            'PARTNERINTEGRATION.DEVICECONNECTOR': "partnerintegration.DeviceConnector",
            'PARTNERINTEGRATION.DOCISSUES': "partnerintegration.DocIssues",
            'PARTNERINTEGRATION.ETL': "partnerintegration.Etl",
            'PARTNERINTEGRATION.FILE': "partnerintegration.File",
            'PARTNERINTEGRATION.INVENTORY': "partnerintegration.Inventory",
            'PARTNERINTEGRATION.LOGS': "partnerintegration.Logs",
            'PARTNERINTEGRATION.METRICS': "partnerintegration.Metrics",
            'PARTNERINTEGRATION.MODEL': "partnerintegration.Model",
            'PCI.COPROCESSORCARD': "pci.CoprocessorCard",
            'PCI.DEVICE': "pci.Device",
            'PCI.LINK': "pci.Link",
            'PCI.NODE': "pci.Node",
            'PCI.SLOT': "pci.Slot",
            'PCI.SWITCH': "pci.Switch",
            'PORT.GROUP': "port.Group",
            'PORT.MACBINDING': "port.MacBinding",
            'PORT.SUBGROUP': "port.SubGroup",
            'POWER.CONTROLSTATE': "power.ControlState",
            'POWER.POLICY': "power.Policy",
            'POWER.POLICYINVENTORY': "power.PolicyInventory",
            'PROCESSOR.UNIT': "processor.Unit",
            'RACK.UNITPERSONALITY': "rack.UnitPersonality",
            'RECOMMENDATION.CAPACITYRUNWAY': "recommendation.CapacityRunway",
            'RECOMMENDATION.CLUSTEREXPANSION': "recommendation.ClusterExpansion",
            'RECOMMENDATION.HARDWAREEXPANSIONREQUEST': "recommendation.HardwareExpansionRequest",
            'RECOMMENDATION.HARDWAREEXPANSIONREQUESTITEM': "recommendation.HardwareExpansionRequestItem",
            'RECOMMENDATION.PHYSICALITEM': "recommendation.PhysicalItem",
            'RECOMMENDATION.PURCHASEORDERESTIMATE': "recommendation.PurchaseOrderEstimate",
            'RECOMMENDATION.PURCHASEORDERLIST': "recommendation.PurchaseOrderList",
            'RECOMMENDATION.SOFTWAREITEM': "recommendation.SoftwareItem",
            'RECOVERY.BACKUPCONFIGPOLICY': "recovery.BackupConfigPolicy",
            'RECOVERY.BACKUPPROFILE': "recovery.BackupProfile",
            'RECOVERY.CONFIGRESULT': "recovery.ConfigResult",
            'RECOVERY.CONFIGRESULTENTRY': "recovery.ConfigResultEntry",
            'RECOVERY.ONDEMANDBACKUP': "recovery.OnDemandBackup",
            'RECOVERY.RESTORE': "recovery.Restore",
            'RECOVERY.SCHEDULECONFIGPOLICY': "recovery.ScheduleConfigPolicy",
            'RESOURCE.GROUP': "resource.Group",
            'RESOURCE.GROUPMEMBER': "resource.GroupMember",
            'RESOURCE.LICENSERESOURCECOUNT': "resource.LicenseResourceCount",
            'RESOURCE.MEMBERSHIP': "resource.Membership",
            'RESOURCE.MEMBERSHIPHOLDER': "resource.MembershipHolder",
            'RESOURCE.RESERVATION': "resource.Reservation",
            'RESOURCE.SELECTIONCRITERIA': "resource.SelectionCriteria",
            'RESOURCE.SHAREDRESOURCESINFOHOLDER': "resource.SharedResourcesInfoHolder",
            'RESOURCEPOOL.CHASSISQUALIFICATIONPOLICY': "resourcepool.ChassisQualificationPolicy",
            'RESOURCEPOOL.LEASE': "resourcepool.Lease",
            'RESOURCEPOOL.LEASERESOURCE': "resourcepool.LeaseResource",
            'RESOURCEPOOL.MEMBERSHIPRESERVATION': "resourcepool.MembershipReservation",
            'RESOURCEPOOL.POOL': "resourcepool.Pool",
            'RESOURCEPOOL.POOLMEMBER': "resourcepool.PoolMember",
            'RESOURCEPOOL.QUALIFICATIONPOLICY': "resourcepool.QualificationPolicy",
            'RESOURCEPOOL.UNIVERSE': "resourcepool.Universe",
            'RPROXY.REVERSEPROXY': "rproxy.ReverseProxy",
            'SCHEDULER.SCHEDULEPOLICY': "scheduler.SchedulePolicy",
            'SCHEDULER.TASKRESULT': "scheduler.TaskResult",
            'SCHEDULER.TASKSCHEDULE': "scheduler.TaskSchedule",
            'SDAACI.CONNECTION': "sdaaci.Connection",
            'SDAACI.CONNECTIONDETAIL': "sdaaci.ConnectionDetail",
            'SDCARD.POLICY': "sdcard.Policy",
            'SDCARD.POLICYINVENTORY': "sdcard.PolicyInventory",
            'SEARCH.SEARCHITEM': "search.SearchItem",
            'SEARCH.TAGITEM': "search.TagItem",
            'SECURITY.UNIT': "security.Unit",
            'SERVER.CONFIGCHANGEDETAIL': "server.ConfigChangeDetail",
            'SERVER.CONFIGIMPORT': "server.ConfigImport",
            'SERVER.CONFIGRESULT': "server.ConfigResult",
            'SERVER.CONFIGRESULTENTRY': "server.ConfigResultEntry",
            'SERVER.DISRUPTION': "server.Disruption",
            'SERVER.PROFILE': "server.Profile",
            'SERVER.PROFILETEMPLATE': "server.ProfileTemplate",
            'SERVICENOW.CHANGEREQUEST': "servicenow.ChangeRequest",
            'SERVICENOW.CHANGEREQUESTDOC': "servicenow.ChangeRequestDoc",
            'SERVICENOW.INCIDENT': "servicenow.Incident",
            'SERVICENOW.INCIDENTDOC': "servicenow.IncidentDoc",
            'SMTP.POLICY': "smtp.Policy",
            'SMTP.POLICYTEST': "smtp.PolicyTest",
            'SNMP.POLICY': "snmp.Policy",
            'SNMP.POLICYINVENTORY': "snmp.PolicyInventory",
            'SOFTWARE.APPLIANCEDISTRIBUTABLE': "software.ApplianceDistributable",
            'SOFTWARE.DOWNLOADHISTORY': "software.DownloadHistory",
            'SOFTWARE.HCIBUNDLEDISTRIBUTABLE': "software.HciBundleDistributable",
            'SOFTWARE.HCIDISTRIBUTABLE': "software.HciDistributable",
            'SOFTWARE.HCLMETA': "software.HclMeta",
            'SOFTWARE.HYPERFLEXBUNDLEDISTRIBUTABLE': "software.HyperflexBundleDistributable",
            'SOFTWARE.HYPERFLEXDISTRIBUTABLE': "software.HyperflexDistributable",
            'SOFTWARE.IKSBUNDLEDISTRIBUTABLE': "software.IksBundleDistributable",
            'SOFTWARE.RELEASEMETA': "software.ReleaseMeta",
            'SOFTWARE.SOLUTIONDISTRIBUTABLE': "software.SolutionDistributable",
            'SOFTWARE.UCSDBUNDLEDISTRIBUTABLE': "software.UcsdBundleDistributable",
            'SOFTWARE.UCSDDISTRIBUTABLE': "software.UcsdDistributable",
            'SOFTWAREREPOSITORY.AUTHORIZATION': "softwarerepository.Authorization",
            'SOFTWAREREPOSITORY.CACHEDIMAGE': "softwarerepository.CachedImage",
            'SOFTWAREREPOSITORY.CATALOG': "softwarerepository.Catalog",
            'SOFTWAREREPOSITORY.CATEGORYMAPPER': "softwarerepository.CategoryMapper",
            'SOFTWAREREPOSITORY.CATEGORYMAPPERMODEL': "softwarerepository.CategoryMapperModel",
            'SOFTWAREREPOSITORY.CATEGORYSUPPORTCONSTRAINT': "softwarerepository.CategorySupportConstraint",
            'SOFTWAREREPOSITORY.CATEGORYUNSUPPORTEDMODELS': "softwarerepository.CategoryUnsupportedModels",
            'SOFTWAREREPOSITORY.DOWNLOADSPEC': "softwarerepository.DownloadSpec",
            'SOFTWAREREPOSITORY.OPERATINGSYSTEMFILE': "softwarerepository.OperatingSystemFile",
            'SOFTWAREREPOSITORY.RELEASE': "softwarerepository.Release",
            'SOL.POLICY': "sol.Policy",
            'SOL.POLICYINVENTORY': "sol.PolicyInventory",
            'SSH.POLICY': "ssh.Policy",
            'SSH.POLICYINVENTORY': "ssh.PolicyInventory",
            'STORAGE.BATTERYBACKUPUNIT': "storage.BatteryBackupUnit",
            'STORAGE.CONTROLLER': "storage.Controller",
            'STORAGE.CONTROLLERDRIVE': "storage.ControllerDrive",
            'STORAGE.DISKGROUP': "storage.DiskGroup",
            'STORAGE.DISKSLOT': "storage.DiskSlot",
            'STORAGE.DRIVEGROUP': "storage.DriveGroup",
            'STORAGE.DRIVESECURITYPOLICY': "storage.DriveSecurityPolicy",
            'STORAGE.ENCLOSURE': "storage.Enclosure",
            'STORAGE.ENCLOSUREDISK': "storage.EnclosureDisk",
            'STORAGE.ENCLOSUREDISKSLOTEP': "storage.EnclosureDiskSlotEp",
            'STORAGE.FILEITEM': "storage.FileItem",
            'STORAGE.FLEXFLASHCONTROLLER': "storage.FlexFlashController",
            'STORAGE.FLEXFLASHCONTROLLERPROPS': "storage.FlexFlashControllerProps",
            'STORAGE.FLEXFLASHPHYSICALDRIVE': "storage.FlexFlashPhysicalDrive",
            'STORAGE.FLEXFLASHVIRTUALDRIVE': "storage.FlexFlashVirtualDrive",
            'STORAGE.FLEXUTILCONTROLLER': "storage.FlexUtilController",
            'STORAGE.FLEXUTILPHYSICALDRIVE': "storage.FlexUtilPhysicalDrive",
            'STORAGE.FLEXUTILVIRTUALDRIVE': "storage.FlexUtilVirtualDrive",
            'STORAGE.HITACHIARRAY': "storage.HitachiArray",
            'STORAGE.HITACHICONTROLLER': "storage.HitachiController",
            'STORAGE.HITACHIDISK': "storage.HitachiDisk",
            'STORAGE.HITACHIEXTERNALPARITYGROUP': "storage.HitachiExternalParityGroup",
            'STORAGE.HITACHIEXTERNALPATHGROUP': "storage.HitachiExternalPathGroup",
            'STORAGE.HITACHIEXTERNALSTORAGELUN': "storage.HitachiExternalStorageLun",
            'STORAGE.HITACHIEXTERNALSTORAGEPORT': "storage.HitachiExternalStoragePort",
            'STORAGE.HITACHIHOST': "storage.HitachiHost",
            'STORAGE.HITACHIHOSTLUN': "storage.HitachiHostLun",
            'STORAGE.HITACHINVMSUBSYSTEM': "storage.HitachiNvmSubsystem",
            'STORAGE.HITACHIPARITYGROUP': "storage.HitachiParityGroup",
            'STORAGE.HITACHIPOOL': "storage.HitachiPool",
            'STORAGE.HITACHIPORT': "storage.HitachiPort",
            'STORAGE.HITACHIREMOTECOPYPAIRGAD': "storage.HitachiRemoteCopyPairGad",
            'STORAGE.HITACHIREMOTECOPYPAIRTC': "storage.HitachiRemoteCopyPairTc",
            'STORAGE.HITACHIREMOTECOPYPAIRUR': "storage.HitachiRemoteCopyPairUr",
            'STORAGE.HITACHIREMOTEREPLICATION': "storage.HitachiRemoteReplication",
            'STORAGE.HITACHISNAPSHOT': "storage.HitachiSnapshot",
            'STORAGE.HITACHIVOLUME': "storage.HitachiVolume",
            'STORAGE.HITACHIVOLUMEMIGRATIONPAIR': "storage.HitachiVolumeMigrationPair",
            'STORAGE.HYPERFLEXSTORAGECONTAINER': "storage.HyperFlexStorageContainer",
            'STORAGE.HYPERFLEXVOLUME': "storage.HyperFlexVolume",
            'STORAGE.ITEM': "storage.Item",
            'STORAGE.KNOXSECUREDRIVECONFIGURATION': "storage.KnoxSecureDriveConfiguration",
            'STORAGE.NETAPPAGGREGATE': "storage.NetAppAggregate",
            'STORAGE.NETAPPAGGREGATEEVENT': "storage.NetAppAggregateEvent",
            'STORAGE.NETAPPBASEDISK': "storage.NetAppBaseDisk",
            'STORAGE.NETAPPCIFSSERVICE': "storage.NetAppCifsService",
            'STORAGE.NETAPPCIFSSHARE': "storage.NetAppCifsShare",
            'STORAGE.NETAPPCLOUDTARGET': "storage.NetAppCloudTarget",
            'STORAGE.NETAPPCLUSTER': "storage.NetAppCluster",
            'STORAGE.NETAPPCLUSTEREVENT': "storage.NetAppClusterEvent",
            'STORAGE.NETAPPCLUSTERSNAPMIRRORPOLICY': "storage.NetAppClusterSnapMirrorPolicy",
            'STORAGE.NETAPPCLUSTERSNAPSHOTPOLICY': "storage.NetAppClusterSnapshotPolicy",
            'STORAGE.NETAPPDATAIPINTERFACE': "storage.NetAppDataIpInterface",
            'STORAGE.NETAPPDATAIPINTERFACEEVENT': "storage.NetAppDataIpInterfaceEvent",
            'STORAGE.NETAPPDISKEVENT': "storage.NetAppDiskEvent",
            'STORAGE.NETAPPETHERNETPORT': "storage.NetAppEthernetPort",
            'STORAGE.NETAPPETHERNETPORTEVENT': "storage.NetAppEthernetPortEvent",
            'STORAGE.NETAPPEXPORTPOLICY': "storage.NetAppExportPolicy",
            'STORAGE.NETAPPFCINTERFACE': "storage.NetAppFcInterface",
            'STORAGE.NETAPPFCINTERFACEEVENT': "storage.NetAppFcInterfaceEvent",
            'STORAGE.NETAPPFCPORT': "storage.NetAppFcPort",
            'STORAGE.NETAPPFCPORTEVENT': "storage.NetAppFcPortEvent",
            'STORAGE.NETAPPINITIATORGROUP': "storage.NetAppInitiatorGroup",
            'STORAGE.NETAPPIPINTERFACE': "storage.NetAppIpInterface",
            'STORAGE.NETAPPIPINTERFACEEVENT': "storage.NetAppIpInterfaceEvent",
            'STORAGE.NETAPPISCSISERVICE': "storage.NetAppIscsiService",
            'STORAGE.NETAPPLICENSE': "storage.NetAppLicense",
            'STORAGE.NETAPPLUN': "storage.NetAppLun",
            'STORAGE.NETAPPLUNEVENT': "storage.NetAppLunEvent",
            'STORAGE.NETAPPLUNMAP': "storage.NetAppLunMap",
            'STORAGE.NETAPPNAMESPACE': "storage.NetAppNamespace",
            'STORAGE.NETAPPNFSCLIENT': "storage.NetAppNfsClient",
            'STORAGE.NETAPPNFSSERVICE': "storage.NetAppNfsService",
            'STORAGE.NETAPPNODE': "storage.NetAppNode",
            'STORAGE.NETAPPNODECDPNEIGHBOR': "storage.NetAppNodeCdpNeighbor",
            'STORAGE.NETAPPNODEEVENT': "storage.NetAppNodeEvent",
            'STORAGE.NETAPPNONDATAIPINTERFACE': "storage.NetAppNonDataIpInterface",
            'STORAGE.NETAPPNONDATAIPINTERFACEEVENT': "storage.NetAppNonDataIpInterfaceEvent",
            'STORAGE.NETAPPNTPSERVER': "storage.NetAppNtpServer",
            'STORAGE.NETAPPQTREE': "storage.NetAppQtree",
            'STORAGE.NETAPPSCHEDULE': "storage.NetAppSchedule",
            'STORAGE.NETAPPSENSOR': "storage.NetAppSensor",
            'STORAGE.NETAPPSNAPMIRRORRELATIONSHIP': "storage.NetAppSnapMirrorRelationship",
            'STORAGE.NETAPPSTORAGEVM': "storage.NetAppStorageVm",
            'STORAGE.NETAPPSVMEVENT': "storage.NetAppSvmEvent",
            'STORAGE.NETAPPSVMSNAPMIRRORPOLICY': "storage.NetAppSvmSnapMirrorPolicy",
            'STORAGE.NETAPPSVMSNAPSHOTPOLICY': "storage.NetAppSvmSnapshotPolicy",
            'STORAGE.NETAPPVOLUME': "storage.NetAppVolume",
            'STORAGE.NETAPPVOLUMEEVENT': "storage.NetAppVolumeEvent",
            'STORAGE.NETAPPVOLUMESNAPSHOT': "storage.NetAppVolumeSnapshot",
            'STORAGE.NVMERAIDCONFIGURATION': "storage.NvmeRaidConfiguration",
            'STORAGE.PHYSICALDISK': "storage.PhysicalDisk",
            'STORAGE.PHYSICALDISKEXTENSION': "storage.PhysicalDiskExtension",
            'STORAGE.PHYSICALDISKUSAGE': "storage.PhysicalDiskUsage",
            'STORAGE.PUREARRAY': "storage.PureArray",
            'STORAGE.PUREARRAYALERTS': "storage.PureArrayAlerts",
            'STORAGE.PURECONTROLLER': "storage.PureController",
            'STORAGE.PUREDIRECTORY': "storage.PureDirectory",
            'STORAGE.PUREDIRECTORYEXPORT': "storage.PureDirectoryExport",
            'STORAGE.PUREDIRECTORYPOLICY': "storage.PureDirectoryPolicy",
            'STORAGE.PUREDIRECTORYQUOTA': "storage.PureDirectoryQuota",
            'STORAGE.PUREDIRECTORYSNAPSHOT': "storage.PureDirectorySnapshot",
            'STORAGE.PUREDISK': "storage.PureDisk",
            'STORAGE.PUREFILESYSTEMS': "storage.PureFileSystems",
            'STORAGE.PUREHOST': "storage.PureHost",
            'STORAGE.PUREHOSTGROUP': "storage.PureHostGroup",
            'STORAGE.PUREHOSTLUN': "storage.PureHostLun",
            'STORAGE.PURENFSPOLICYRULE': "storage.PureNfsPolicyRule",
            'STORAGE.PUREPORT': "storage.PurePort",
            'STORAGE.PUREPROTECTIONGROUP': "storage.PureProtectionGroup",
            'STORAGE.PUREPROTECTIONGROUPSNAPSHOT': "storage.PureProtectionGroupSnapshot",
            'STORAGE.PUREQUOTAPOLICYRULE': "storage.PureQuotaPolicyRule",
            'STORAGE.PUREREPLICATIONSCHEDULE': "storage.PureReplicationSchedule",
            'STORAGE.PURESMBPOLICYRULE': "storage.PureSmbPolicyRule",
            'STORAGE.PURESNAPSHOTSCHEDULE': "storage.PureSnapshotSchedule",
            'STORAGE.PURETARGETARRAY': "storage.PureTargetArray",
            'STORAGE.PUREVOLUME': "storage.PureVolume",
            'STORAGE.PUREVOLUMESNAPSHOT': "storage.PureVolumeSnapshot",
            'STORAGE.SASEXPANDER': "storage.SasExpander",
            'STORAGE.SASPORT': "storage.SasPort",
            'STORAGE.SPAN': "storage.Span",
            'STORAGE.STORAGEPOLICY': "storage.StoragePolicy",
            'STORAGE.VDMEMBEREP': "storage.VdMemberEp",
            'STORAGE.VIRTUALDRIVE': "storage.VirtualDrive",
            'STORAGE.VIRTUALDRIVECONTAINER': "storage.VirtualDriveContainer",
            'STORAGE.VIRTUALDRIVEEXTENSION': "storage.VirtualDriveExtension",
            'STORAGE.VIRTUALDRIVEIDENTITY': "storage.VirtualDriveIdentity",
            'SYSLOG.POLICY': "syslog.Policy",
            'SYSLOG.POLICYINVENTORY': "syslog.PolicyInventory",
            'TAM.ADVISORYCOUNT': "tam.AdvisoryCount",
            'TAM.ADVISORYDEFINITION': "tam.AdvisoryDefinition",
            'TAM.ADVISORYINFO': "tam.AdvisoryInfo",
            'TAM.ADVISORYINSTANCE': "tam.AdvisoryInstance",
            'TAM.SECURITYADVISORY': "tam.SecurityAdvisory",
            'TASK.CATALYSTSDWANSCOPEDINVENTORY': "task.CatalystSdwanScopedInventory",
            'TASK.FABRICMOSSCOPEDINVENTORY': "task.FabricMosScopedInventory",
            'TASK.HCISCOPEDINVENTORY': "task.HciScopedInventory",
            'TASK.HITACHISCOPEDINVENTORY': "task.HitachiScopedInventory",
            'TASK.HYPERFLEXMANAGEMENTSCOPEDINVENTORY': "task.HyperFlexManagementScopedInventory",
            'TASK.HYPERFLEXSCOPEDINVENTORY': "task.HyperflexScopedInventory",
            'TASK.MDSSCOPEDINVENTORY': "task.MdsScopedInventory",
            'TASK.MDSSYSTEMSCOPEDINVENTORY': "task.MdsSystemScopedInventory",
            'TASK.MERAKISCOPEDINVENTORY': "task.MerakiScopedInventory",
            'TASK.NETAPPSCOPEDINVENTORY': "task.NetAppScopedInventory",
            'TASK.NEXUSSCOPEDINVENTORY': "task.NexusScopedInventory",
            'TASK.NEXUSSYSTEMSCOPEDINVENTORY': "task.NexusSystemScopedInventory",
            'TASK.NEXUSVLANSCOPEDINVENTORY': "task.NexusVlanScopedInventory",
            'TASK.PURESCOPEDINVENTORY': "task.PureScopedInventory",
            'TASK.SERVERSCOPEDINVENTORY': "task.ServerScopedInventory",
            'TASK.WORKFLOWACTION': "task.WorkflowAction",
            'TECHSUPPORTMANAGEMENT.COLLECTIONCONTROLPOLICY': "techsupportmanagement.CollectionControlPolicy",
            'TECHSUPPORTMANAGEMENT.DOWNLOAD': "techsupportmanagement.Download",
            'TECHSUPPORTMANAGEMENT.ENDPOINT': "techsupportmanagement.EndPoint",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTBUNDLE': "techsupportmanagement.TechSupportBundle",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTSTATUS': "techsupportmanagement.TechSupportStatus",
            'TERMINAL.AUDITLOG': "terminal.AuditLog",
            'THERMAL.POLICY': "thermal.Policy",
            'THERMAL.POLICYINVENTORY': "thermal.PolicyInventory",
            'TOP.SYSTEM': "top.System",
            'UCSD.BACKUPINFO': "ucsd.BackupInfo",
            'UUIDPOOL.BLOCK': "uuidpool.Block",
            'UUIDPOOL.POOL': "uuidpool.Pool",
            'UUIDPOOL.POOLMEMBER': "uuidpool.PoolMember",
            'UUIDPOOL.RESERVATION': "uuidpool.Reservation",
            'UUIDPOOL.UNIVERSE': "uuidpool.Universe",
            'UUIDPOOL.UUIDLEASE': "uuidpool.UuidLease",
            'VIEW.HEALTHSTATUS': "view.HealthStatus",
            'VIEW.SERVER': "view.Server",
            'VIRTUALIZATION.ESXICONSOLE': "virtualization.EsxiConsole",
            'VIRTUALIZATION.HOST': "virtualization.Host",
            'VIRTUALIZATION.VIRTUALMACHINE': "virtualization.VirtualMachine",
            'VIRTUALIZATION.VMWARECLUSTER': "virtualization.VmwareCluster",
            'VIRTUALIZATION.VMWAREDATACENTER': "virtualization.VmwareDatacenter",
            'VIRTUALIZATION.VMWAREDATASTORE': "virtualization.VmwareDatastore",
            'VIRTUALIZATION.VMWAREDATASTORECLUSTER': "virtualization.VmwareDatastoreCluster",
            'VIRTUALIZATION.VMWAREDISTRIBUTEDNETWORK': "virtualization.VmwareDistributedNetwork",
            'VIRTUALIZATION.VMWAREDISTRIBUTEDSWITCH': "virtualization.VmwareDistributedSwitch",
            'VIRTUALIZATION.VMWAREFOLDER': "virtualization.VmwareFolder",
            'VIRTUALIZATION.VMWAREHOST': "virtualization.VmwareHost",
            'VIRTUALIZATION.VMWAREHOSTGPU': "virtualization.VmwareHostGpu",
            'VIRTUALIZATION.VMWAREKERNELNETWORK': "virtualization.VmwareKernelNetwork",
            'VIRTUALIZATION.VMWARENETWORK': "virtualization.VmwareNetwork",
            'VIRTUALIZATION.VMWAREPHYSICALNETWORKINTERFACE': "virtualization.VmwarePhysicalNetworkInterface",
            'VIRTUALIZATION.VMWAREPROACTIVEHA': "virtualization.VmwareProactiveHa",
            'VIRTUALIZATION.VMWAREUPLINKPORT': "virtualization.VmwareUplinkPort",
            'VIRTUALIZATION.VMWAREVCENTER': "virtualization.VmwareVcenter",
            'VIRTUALIZATION.VMWAREVIRTUALDISK': "virtualization.VmwareVirtualDisk",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINE': "virtualization.VmwareVirtualMachine",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINEGPU': "virtualization.VmwareVirtualMachineGpu",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINESNAPSHOT': "virtualization.VmwareVirtualMachineSnapshot",
            'VIRTUALIZATION.VMWAREVIRTUALNETWORKINTERFACE': "virtualization.VmwareVirtualNetworkInterface",
            'VIRTUALIZATION.VMWAREVIRTUALSWITCH': "virtualization.VmwareVirtualSwitch",
            'VMEDIA.POLICY': "vmedia.Policy",
            'VMEDIA.POLICYINVENTORY': "vmedia.PolicyInventory",
            'VMRC.CONSOLE': "vmrc.Console",
            'VNIC.ETHADAPTERPOLICY': "vnic.EthAdapterPolicy",
            'VNIC.ETHADAPTERPOLICYINVENTORY': "vnic.EthAdapterPolicyInventory",
            'VNIC.ETHIF': "vnic.EthIf",
            'VNIC.ETHIFINVENTORY': "vnic.EthIfInventory",
            'VNIC.ETHNETWORKPOLICY': "vnic.EthNetworkPolicy",
            'VNIC.ETHNETWORKPOLICYINVENTORY': "vnic.EthNetworkPolicyInventory",
            'VNIC.ETHQOSPOLICY': "vnic.EthQosPolicy",
            'VNIC.ETHQOSPOLICYINVENTORY': "vnic.EthQosPolicyInventory",
            'VNIC.ETHVETHINVENTORY': "vnic.EthVethInventory",
            'VNIC.ETHVNICINVENTORY': "vnic.EthVnicInventory",
            'VNIC.FCADAPTERPOLICY': "vnic.FcAdapterPolicy",
            'VNIC.FCADAPTERPOLICYINVENTORY': "vnic.FcAdapterPolicyInventory",
            'VNIC.FCIF': "vnic.FcIf",
            'VNIC.FCIFINVENTORY': "vnic.FcIfInventory",
            'VNIC.FCNETWORKPOLICY': "vnic.FcNetworkPolicy",
            'VNIC.FCNETWORKPOLICYINVENTORY': "vnic.FcNetworkPolicyInventory",
            'VNIC.FCQOSPOLICY': "vnic.FcQosPolicy",
            'VNIC.FCQOSPOLICYINVENTORY': "vnic.FcQosPolicyInventory",
            'VNIC.FCVETHINVENTORY': "vnic.FcVethInventory",
            'VNIC.FCVHBAPOLICYINVENTORY': "vnic.FcVhbaPolicyInventory",
            'VNIC.ISCSIADAPTERPOLICY': "vnic.IscsiAdapterPolicy",
            'VNIC.ISCSIADAPTERPOLICYINVENTORY': "vnic.IscsiAdapterPolicyInventory",
            'VNIC.ISCSIBOOTPOLICY': "vnic.IscsiBootPolicy",
            'VNIC.ISCSIBOOTPOLICYINVENTORY': "vnic.IscsiBootPolicyInventory",
            'VNIC.ISCSISTATICTARGETPOLICY': "vnic.IscsiStaticTargetPolicy",
            'VNIC.ISCSISTATICTARGETPOLICYINVENTORY': "vnic.IscsiStaticTargetPolicyInventory",
            'VNIC.LANCONNECTIVITYPOLICY': "vnic.LanConnectivityPolicy",
            'VNIC.LANCONNECTIVITYPOLICYINVENTORY': "vnic.LanConnectivityPolicyInventory",
            'VNIC.LANSETTINGS': "vnic.LanSettings",
            'VNIC.LCPSTATUS': "vnic.LcpStatus",
            'VNIC.SANCONNECTIVITYPOLICY': "vnic.SanConnectivityPolicy",
            'VNIC.SANCONNECTIVITYPOLICYINVENTORY': "vnic.SanConnectivityPolicyInventory",
            'VNIC.SANSETTINGS': "vnic.SanSettings",
            'VNIC.SCPSTATUS': "vnic.ScpStatus",
            'VNIC.VHBATEMPLATE': "vnic.VhbaTemplate",
            'VNIC.VIFIDPOOL': "vnic.VifIdPool",
            'VNIC.VNICTEMPLATE': "vnic.VnicTemplate",
            'VRF.VRF': "vrf.Vrf",
            'WEBHOOK.ENDPOINT': "webhook.Endpoint",
            'WEBHOOK.SCHEMA': "webhook.Schema",
            'WORKFLOW.ANSIBLEBATCHEXECUTOR': "workflow.AnsibleBatchExecutor",
            'WORKFLOW.BATCHAPIEXECUTOR': "workflow.BatchApiExecutor",
            'WORKFLOW.CATALOG': "workflow.Catalog",
            'WORKFLOW.CATALOGITEMDEFINITION': "workflow.CatalogItemDefinition",
            'WORKFLOW.CATALOGSERVICEREQUEST': "workflow.CatalogServiceRequest",
            'WORKFLOW.CUSTOMDATATYPEDEFINITION': "workflow.CustomDataTypeDefinition",
            'WORKFLOW.ERRORRESPONSEHANDLER': "workflow.ErrorResponseHandler",
            'WORKFLOW.POWERSHELLBATCHAPIEXECUTOR': "workflow.PowerShellBatchApiExecutor",
            'WORKFLOW.ROLLBACKWORKFLOW': "workflow.RollbackWorkflow",
            'WORKFLOW.SERVICEITEMACTIONDEFINITION': "workflow.ServiceItemActionDefinition",
            'WORKFLOW.SERVICEITEMACTIONINSTANCE': "workflow.ServiceItemActionInstance",
            'WORKFLOW.SERVICEITEMATTRIBUTE': "workflow.ServiceItemAttribute",
            'WORKFLOW.SERVICEITEMDEFINITION': "workflow.ServiceItemDefinition",
            'WORKFLOW.SERVICEITEMHEALTHCHECKDEFINITION': "workflow.ServiceItemHealthCheckDefinition",
            'WORKFLOW.SERVICEITEMHEALTHCHECKEXECUTION': "workflow.ServiceItemHealthCheckExecution",
            'WORKFLOW.SERVICEITEMINSTANCE': "workflow.ServiceItemInstance",
            'WORKFLOW.SERVICEITEMOUTPUT': "workflow.ServiceItemOutput",
            'WORKFLOW.SSHBATCHEXECUTOR': "workflow.SshBatchExecutor",
            'WORKFLOW.TASKDEBUGLOG': "workflow.TaskDebugLog",
            'WORKFLOW.TASKDEFINITION': "workflow.TaskDefinition",
            'WORKFLOW.TASKINFO': "workflow.TaskInfo",
            'WORKFLOW.TASKMETADATA': "workflow.TaskMetadata",
            'WORKFLOW.TEMPLATEEVALUATION': "workflow.TemplateEvaluation",
            'WORKFLOW.TEMPLATEFUNCTIONMETA': "workflow.TemplateFunctionMeta",
            'WORKFLOW.TEMPLATEPARSER': "workflow.TemplateParser",
            'WORKFLOW.UIDISPLAYMETADATA': "workflow.UiDisplayMetadata",
            'WORKFLOW.VARIABLE': "workflow.Variable",
            'WORKFLOW.WORKFLOWDEFINITION': "workflow.WorkflowDefinition",
            'WORKFLOW.WORKFLOWINFO': "workflow.WorkflowInfo",
            'WORKFLOW.WORKFLOWMETADATA': "workflow.WorkflowMetadata",
            'WORKLOAD.BLUEPRINT': "workload.Blueprint",
            'WORKLOAD.DEPLOYMENTINPUT': "workload.DeploymentInput",
            'WORKLOAD.WORKLOADDEFINITION': "workload.WorkloadDefinition",
            'WORKLOAD.WORKLOADDEPLOYMENT': "workload.WorkloadDeployment",
            'WORKLOAD.WORKLOADINSTANCE': "workload.WorkloadInstance",
            'WORKSPACE.FOLDER': "workspace.Folder",
        },
    }

    validations = {
        ('cluster_uuid',): {
            'regex': {
                'pattern': r'^$|^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$',  # noqa: E501
            },
        },
        ('uuid',): {
            'regex': {
                'pattern': r'^$|^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'selector': (str,),  # noqa: E501
            'link': (str,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'device_mo_id': (str,),  # noqa: E501
            'dn': (str,),  # noqa: E501
            'rn': (str,),  # noqa: E501
            'is_upgraded': (bool,),  # noqa: E501
            'model': (str,),  # noqa: E501
            'presence': (str,),  # noqa: E501
            'revision': (str,),  # noqa: E501
            'serial': (str,),  # noqa: E501
            'vendor': (str,),  # noqa: E501
            'previous_fru': (EquipmentFruRelationship,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'part_number': (str,),  # noqa: E501
            'protocol': (str,),  # noqa: E501
            'speed': (int,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'storage_utilization': (StorageBaseCapacity,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'version': (str,),  # noqa: E501
            'base_disk_model': (str,),  # noqa: E501
            'cluster_uuid': (str,),  # noqa: E501
            'container_type': (str,),  # noqa: E501
            'disk_bay': (int,),  # noqa: E501
            'disk_serial_number': (str,),  # noqa: E501
            'disk_shelf_id': (str,),  # noqa: E501
            'disk_shelf_model': (str,),  # noqa: E501
            'disk_shelf_name': (str,),  # noqa: E501
            'disk_type': (str,),  # noqa: E501
            'node_name': (str,),  # noqa: E501
            'state': (str,),  # noqa: E501
            'uuid': (str,),  # noqa: E501
            'array': (StorageNetAppClusterRelationship,),  # noqa: E501
            'array_controller': (StorageNetAppNodeRelationship,),  # noqa: E501
            'disk_pool': ([StorageNetAppAggregateRelationship], none_type,),  # noqa: E501
            'events': ([StorageNetAppDiskEventRelationship], none_type,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'mo.MoRef': MoMoRef,
            'storage.NetAppBaseDisk': StorageNetAppBaseDisk,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'selector': 'Selector',  # noqa: E501
        'link': 'link',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'device_mo_id': 'DeviceMoId',  # noqa: E501
        'dn': 'Dn',  # noqa: E501
        'rn': 'Rn',  # noqa: E501
        'is_upgraded': 'IsUpgraded',  # noqa: E501
        'model': 'Model',  # noqa: E501
        'presence': 'Presence',  # noqa: E501
        'revision': 'Revision',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'vendor': 'Vendor',  # noqa: E501
        'previous_fru': 'PreviousFru',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'part_number': 'PartNumber',  # noqa: E501
        'protocol': 'Protocol',  # noqa: E501
        'speed': 'Speed',  # noqa: E501
        'status': 'Status',  # noqa: E501
        'storage_utilization': 'StorageUtilization',  # noqa: E501
        'type': 'Type',  # noqa: E501
        'version': 'Version',  # noqa: E501
        'base_disk_model': 'BaseDiskModel',  # noqa: E501
        'cluster_uuid': 'ClusterUuid',  # noqa: E501
        'container_type': 'ContainerType',  # noqa: E501
        'disk_bay': 'DiskBay',  # noqa: E501
        'disk_serial_number': 'DiskSerialNumber',  # noqa: E501
        'disk_shelf_id': 'DiskShelfId',  # noqa: E501
        'disk_shelf_model': 'DiskShelfModel',  # noqa: E501
        'disk_shelf_name': 'DiskShelfName',  # noqa: E501
        'disk_type': 'DiskType',  # noqa: E501
        'node_name': 'NodeName',  # noqa: E501
        'state': 'State',  # noqa: E501
        'uuid': 'Uuid',  # noqa: E501
        'array': 'Array',  # noqa: E501
        'array_controller': 'ArrayController',  # noqa: E501
        'disk_pool': 'DiskPool',  # noqa: E501
        'events': 'Events',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
    }

    read_only_vars = {
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
        'device_mo_id',  # noqa: E501
        'dn',  # noqa: E501
        'rn',  # noqa: E501
        'is_upgraded',  # noqa: E501
        'model',  # noqa: E501
        'presence',  # noqa: E501
        'revision',  # noqa: E501
        'serial',  # noqa: E501
        'vendor',  # noqa: E501
        'name',  # noqa: E501
        'part_number',  # noqa: E501
        'protocol',  # noqa: E501
        'speed',  # noqa: E501
        'status',  # noqa: E501
        'type',  # noqa: E501
        'version',  # noqa: E501
        'base_disk_model',  # noqa: E501
        'cluster_uuid',  # noqa: E501
        'container_type',  # noqa: E501
        'disk_bay',  # noqa: E501
        'disk_serial_number',  # noqa: E501
        'disk_shelf_id',  # noqa: E501
        'disk_shelf_model',  # noqa: E501
        'disk_shelf_name',  # noqa: E501
        'disk_type',  # noqa: E501
        'node_name',  # noqa: E501
        'state',  # noqa: E501
        'uuid',  # noqa: E501
        'disk_pool',  # noqa: E501
        'events',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """StorageNetAppBaseDiskRelationship - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "mo.MoRef", must be one of ["mo.MoRef", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            moid (str): The Moid of the referenced REST resource.. [optional]  # noqa: E501
            selector (str): An OData $filter expression which describes the REST resource to be referenced. This field may be set instead of 'moid' by clients. 1. If 'moid' is set this field is ignored. 1. If 'selector' is set and 'moid' is empty/absent from the request, Intersight determines the Moid of the resource matching the filter expression and populates it in the MoRef that is part of the object instance being inserted/updated to fulfill the REST request. An error is returned if the filter matches zero or more than one REST resource. An example filter string is: Serial eq '3AA8B7T11'.. [optional]  # noqa: E501
            link (str): A URL to an instance of the 'mo.MoRef' class.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            is_upgraded (bool): This field indicates the compute status of the catalog values for the associated component or hardware.. [optional] if omitted the server will use the default value of False  # noqa: E501
            model (str): This field displays the model number of the associated component or hardware.. [optional]  # noqa: E501
            presence (str): This field indicates the presence (equipped) or absence (absent) of the associated component or hardware.. [optional]  # noqa: E501
            revision (str): This field displays the revised version of the associated component or hardware (if any).. [optional]  # noqa: E501
            serial (str): This field displays the serial number of the associated component or hardware.. [optional]  # noqa: E501
            vendor (str): This field displays the vendor information of the associated component or hardware.. [optional]  # noqa: E501
            previous_fru (EquipmentFruRelationship): [optional]  # noqa: E501
            name (str): Disk name available in storage array.. [optional]  # noqa: E501
            part_number (str): Storage disk part number.. [optional]  # noqa: E501
            protocol (str): Storage protocol used in disk for communication. Possible values are SAS, SATA and NVMe. * `Unknown` - Disk protocol is unknown. * `SAS` - Serial Attached SCSI protocol (SAS) used in disk. * `NVMe` - Non-volatile memory express (NVMe) protocol used in disk. * `SATA` - Serial Advanced Technology Attachment (SATA) used in disk.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            speed (int): Disk speed for read or write operation measured in rpm.. [optional]  # noqa: E501
            status (str): Storage disk health status. * `Unknown` - Component status is not available. * `Ok` - Component is healthy and no issues found. * `Degraded` - Functioning, but not at full capability due to a non-fatal failure. * `Critical` - Not functioning or requiring immediate attention. * `Offline` - Component is installed, but powered off. * `Identifying` - Component is in initialization process. * `NotAvailable` - Component is not installed or not available. * `Updating` - Software update is in progress. * `Unrecognized` - Component is not recognized. It may be because the component is not installed properly or it is not supported.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            storage_utilization (StorageBaseCapacity): [optional]  # noqa: E501
            type (str): Storage disk type - it can be SSD, HDD, NVRAM. * `Unknown` - Default unknown disk type. * `SSD` - Storage disk with Solid state disk. * `HDD` - Storage disk with Hard disk drive. * `NVRAM` - Storage disk with Non-volatile random-access memory type. * `SATA` - Disk drive implementation with Serial Advanced Technology Attachment (SATA). * `BSAS` - Bridged SAS-SATA disks with added hardware to enable them to be plugged into a SAS-connected storage shelf. * `FC` - Storage disk with Fiber Channel. * `FSAS` - Near Line SAS. NL-SAS drives are enterprise SATA drives with a SAS interface, head, media, androtational speed of traditional enterprise-class SATA drives with the fully capable SAS interfacetypical for classic SAS drives. * `LUN` - Logical Unit Number refers to a logical disk. * `MSATA` - SATA disk in multi-disk carrier storage shelf. * `SAS` - Storage disk with serial attached SCSI. * `VMDISK` - Virtual machine Data Disk.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            version (str): Storage disk version number.. [optional]  # noqa: E501
            base_disk_model (str): The NetApp base disk model.. [optional]  # noqa: E501
            cluster_uuid (str): Unique identity of the device.. [optional]  # noqa: E501
            container_type (str): Supported container type for NetApp disk. * `Unknown` - Default container type is currently unknown. * `Aggregate` - Disk is used as a physical disk in an aggregate. * `Broken` - Disk is in a broken pool. * `Label Maintenance` - Disk is in online label maintenance list. * `Foreign` - Array LUN has been marked foreign. * `Maintenance` - Disk is in maintenance center. * `Mediator` - A mediator disk is a disk used on non-shared HA systems hosted by an external node which is used to communicate the viability of the storage failover between non-shared HA nodes. * `Shared` - Disk is partitioned or in a storage pool. * `Remote` - Disk belongs to a remote cluster. * `Spare` - The disk is a spare disk. * `Unassigned` - Disk ownership has not been assigned. * `Unsupported` - The disk is not supported.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            disk_bay (int): NetApp base disk shelf bay.. [optional]  # noqa: E501
            disk_serial_number (str): NetApp base disk serial number.. [optional]  # noqa: E501
            disk_shelf_id (str): NetApp base disk shelf id.. [optional]  # noqa: E501
            disk_shelf_model (str): NetApp base disk shelf model.. [optional]  # noqa: E501
            disk_shelf_name (str): NetApp base disk shelf name.. [optional]  # noqa: E501
            disk_type (str): The type of the NetApp disk. * `Unknown` - Default unknown disk type. * `SSDNVM` - Solid state disk with Non-Volatile Memory Express protocol enabled. * `ATA` - Advanced Technology Attachment is a type of disk drive that integrates the drive controller directly on the drive itself. * `FCAL` - For the FC-AL disk connection type, disk shelves are connected to the controller in a loop. * `BSAS` - Bridged SAS-SATA disks with added hardware to enable them to be plugged into a SAS-connected storage shelf. * `FSAS` - Near Line SAS. NL-SAS drives are enterprise SATA drives with a SAS interface, head, media, and rotational speed of traditional enterprise-class SATA drives with the fully capable SAS interface typical for classic SAS drives. * `LUN` - Logical Unit Number refers to a logical disk. * `SAS` - Storage disk with serial attached SCSI. * `MSATA` - SATA disk in multi-disk carrier storage shelf. * `SSD` - Storage disk with Solid state disk. * `VMDISK` - Virtual machine Data Disk.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            node_name (str): The node name for the disk.. [optional]  # noqa: E501
            state (str): Current state of the NetApp disk. * `Present` - Storage disk state type is present. * `Copy` - Storage disk state type is copy. * `Broken` - Storage disk state type is broken. * `Maintenance` - Storage disk state type is maintenance. * `Partner` - Storage disk state type is partner. * `Pending` - Storage disk state type is pending. * `Reconstructing` - Storage disk state type is reconstructing. * `Removed` - Storage disk state type is removed. * `Spare` - Storage disk state type is spare. * `Unfail` - Storage disk state type is unfail. * `Zeroing` - Storage disk state type is zeroing.. [optional] if omitted the server will use the default value of "Present"  # noqa: E501
            uuid (str): Universally unique identifier of the NetApp Disk.. [optional]  # noqa: E501
            array (StorageNetAppClusterRelationship): [optional]  # noqa: E501
            array_controller (StorageNetAppNodeRelationship): [optional]  # noqa: E501
            disk_pool ([StorageNetAppAggregateRelationship], none_type): An array of relationships to storageNetAppAggregate resources.. [optional]  # noqa: E501
            events ([StorageNetAppDiskEventRelationship], none_type): An array of relationships to storageNetAppDiskEvent resources.. [optional]  # noqa: E501
            object_type (str): The fully-qualified name of the remote type referred by this relationship.. [optional]  # noqa: E501
        """

        class_id = "mo.MoRef" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "mo.MoRef")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """StorageNetAppBaseDiskRelationship - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "mo.MoRef", must be one of ["mo.MoRef", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            moid (str): The Moid of the referenced REST resource.. [optional]  # noqa: E501
            selector (str): An OData $filter expression which describes the REST resource to be referenced. This field may be set instead of 'moid' by clients. 1. If 'moid' is set this field is ignored. 1. If 'selector' is set and 'moid' is empty/absent from the request, Intersight determines the Moid of the resource matching the filter expression and populates it in the MoRef that is part of the object instance being inserted/updated to fulfill the REST request. An error is returned if the filter matches zero or more than one REST resource. An example filter string is: Serial eq '3AA8B7T11'.. [optional]  # noqa: E501
            link (str): A URL to an instance of the 'mo.MoRef' class.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            is_upgraded (bool): This field indicates the compute status of the catalog values for the associated component or hardware.. [optional] if omitted the server will use the default value of False  # noqa: E501
            model (str): This field displays the model number of the associated component or hardware.. [optional]  # noqa: E501
            presence (str): This field indicates the presence (equipped) or absence (absent) of the associated component or hardware.. [optional]  # noqa: E501
            revision (str): This field displays the revised version of the associated component or hardware (if any).. [optional]  # noqa: E501
            serial (str): This field displays the serial number of the associated component or hardware.. [optional]  # noqa: E501
            vendor (str): This field displays the vendor information of the associated component or hardware.. [optional]  # noqa: E501
            previous_fru (EquipmentFruRelationship): [optional]  # noqa: E501
            name (str): Disk name available in storage array.. [optional]  # noqa: E501
            part_number (str): Storage disk part number.. [optional]  # noqa: E501
            protocol (str): Storage protocol used in disk for communication. Possible values are SAS, SATA and NVMe. * `Unknown` - Disk protocol is unknown. * `SAS` - Serial Attached SCSI protocol (SAS) used in disk. * `NVMe` - Non-volatile memory express (NVMe) protocol used in disk. * `SATA` - Serial Advanced Technology Attachment (SATA) used in disk.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            speed (int): Disk speed for read or write operation measured in rpm.. [optional]  # noqa: E501
            status (str): Storage disk health status. * `Unknown` - Component status is not available. * `Ok` - Component is healthy and no issues found. * `Degraded` - Functioning, but not at full capability due to a non-fatal failure. * `Critical` - Not functioning or requiring immediate attention. * `Offline` - Component is installed, but powered off. * `Identifying` - Component is in initialization process. * `NotAvailable` - Component is not installed or not available. * `Updating` - Software update is in progress. * `Unrecognized` - Component is not recognized. It may be because the component is not installed properly or it is not supported.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            storage_utilization (StorageBaseCapacity): [optional]  # noqa: E501
            type (str): Storage disk type - it can be SSD, HDD, NVRAM. * `Unknown` - Default unknown disk type. * `SSD` - Storage disk with Solid state disk. * `HDD` - Storage disk with Hard disk drive. * `NVRAM` - Storage disk with Non-volatile random-access memory type. * `SATA` - Disk drive implementation with Serial Advanced Technology Attachment (SATA). * `BSAS` - Bridged SAS-SATA disks with added hardware to enable them to be plugged into a SAS-connected storage shelf. * `FC` - Storage disk with Fiber Channel. * `FSAS` - Near Line SAS. NL-SAS drives are enterprise SATA drives with a SAS interface, head, media, androtational speed of traditional enterprise-class SATA drives with the fully capable SAS interfacetypical for classic SAS drives. * `LUN` - Logical Unit Number refers to a logical disk. * `MSATA` - SATA disk in multi-disk carrier storage shelf. * `SAS` - Storage disk with serial attached SCSI. * `VMDISK` - Virtual machine Data Disk.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            version (str): Storage disk version number.. [optional]  # noqa: E501
            base_disk_model (str): The NetApp base disk model.. [optional]  # noqa: E501
            cluster_uuid (str): Unique identity of the device.. [optional]  # noqa: E501
            container_type (str): Supported container type for NetApp disk. * `Unknown` - Default container type is currently unknown. * `Aggregate` - Disk is used as a physical disk in an aggregate. * `Broken` - Disk is in a broken pool. * `Label Maintenance` - Disk is in online label maintenance list. * `Foreign` - Array LUN has been marked foreign. * `Maintenance` - Disk is in maintenance center. * `Mediator` - A mediator disk is a disk used on non-shared HA systems hosted by an external node which is used to communicate the viability of the storage failover between non-shared HA nodes. * `Shared` - Disk is partitioned or in a storage pool. * `Remote` - Disk belongs to a remote cluster. * `Spare` - The disk is a spare disk. * `Unassigned` - Disk ownership has not been assigned. * `Unsupported` - The disk is not supported.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            disk_bay (int): NetApp base disk shelf bay.. [optional]  # noqa: E501
            disk_serial_number (str): NetApp base disk serial number.. [optional]  # noqa: E501
            disk_shelf_id (str): NetApp base disk shelf id.. [optional]  # noqa: E501
            disk_shelf_model (str): NetApp base disk shelf model.. [optional]  # noqa: E501
            disk_shelf_name (str): NetApp base disk shelf name.. [optional]  # noqa: E501
            disk_type (str): The type of the NetApp disk. * `Unknown` - Default unknown disk type. * `SSDNVM` - Solid state disk with Non-Volatile Memory Express protocol enabled. * `ATA` - Advanced Technology Attachment is a type of disk drive that integrates the drive controller directly on the drive itself. * `FCAL` - For the FC-AL disk connection type, disk shelves are connected to the controller in a loop. * `BSAS` - Bridged SAS-SATA disks with added hardware to enable them to be plugged into a SAS-connected storage shelf. * `FSAS` - Near Line SAS. NL-SAS drives are enterprise SATA drives with a SAS interface, head, media, and rotational speed of traditional enterprise-class SATA drives with the fully capable SAS interface typical for classic SAS drives. * `LUN` - Logical Unit Number refers to a logical disk. * `SAS` - Storage disk with serial attached SCSI. * `MSATA` - SATA disk in multi-disk carrier storage shelf. * `SSD` - Storage disk with Solid state disk. * `VMDISK` - Virtual machine Data Disk.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            node_name (str): The node name for the disk.. [optional]  # noqa: E501
            state (str): Current state of the NetApp disk. * `Present` - Storage disk state type is present. * `Copy` - Storage disk state type is copy. * `Broken` - Storage disk state type is broken. * `Maintenance` - Storage disk state type is maintenance. * `Partner` - Storage disk state type is partner. * `Pending` - Storage disk state type is pending. * `Reconstructing` - Storage disk state type is reconstructing. * `Removed` - Storage disk state type is removed. * `Spare` - Storage disk state type is spare. * `Unfail` - Storage disk state type is unfail. * `Zeroing` - Storage disk state type is zeroing.. [optional] if omitted the server will use the default value of "Present"  # noqa: E501
            uuid (str): Universally unique identifier of the NetApp Disk.. [optional]  # noqa: E501
            array (StorageNetAppClusterRelationship): [optional]  # noqa: E501
            array_controller (StorageNetAppNodeRelationship): [optional]  # noqa: E501
            disk_pool ([StorageNetAppAggregateRelationship], none_type): An array of relationships to storageNetAppAggregate resources.. [optional]  # noqa: E501
            events ([StorageNetAppDiskEventRelationship], none_type): An array of relationships to storageNetAppDiskEvent resources.. [optional]  # noqa: E501
            object_type (str): The fully-qualified name of the remote type referred by this relationship.. [optional]  # noqa: E501
        """

        class_id = "mo.MoRef" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "mo.MoRef")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
          ],
          'oneOf': [
              MoMoRef,
              StorageNetAppBaseDisk,
              none_type,
          ],
        }
