"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError



class StorageNetAppBaseEventAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'NETAPPAGGREGATEEVENT': "storage.NetAppAggregateEvent",
            'NETAPPCLUSTEREVENT': "storage.NetAppClusterEvent",
            'NETAPPDATAIPINTERFACEEVENT': "storage.NetAppDataIpInterfaceEvent",
            'NETAPPDISKEVENT': "storage.NetAppDiskEvent",
            'NETAPPETHERNETPORTEVENT': "storage.NetAppEthernetPortEvent",
            'NETAPPFCINTERFACEEVENT': "storage.NetAppFcInterfaceEvent",
            'NETAPPFCPORTEVENT': "storage.NetAppFcPortEvent",
            'NETAPPIPINTERFACEEVENT': "storage.NetAppIpInterfaceEvent",
            'NETAPPLUNEVENT': "storage.NetAppLunEvent",
            'NETAPPNODEEVENT': "storage.NetAppNodeEvent",
            'NETAPPNONDATAIPINTERFACEEVENT': "storage.NetAppNonDataIpInterfaceEvent",
            'NETAPPSVMEVENT': "storage.NetAppSvmEvent",
            'NETAPPVOLUMEEVENT': "storage.NetAppVolumeEvent",
        },
        ('object_type',): {
            'NETAPPAGGREGATEEVENT': "storage.NetAppAggregateEvent",
            'NETAPPCLUSTEREVENT': "storage.NetAppClusterEvent",
            'NETAPPDATAIPINTERFACEEVENT': "storage.NetAppDataIpInterfaceEvent",
            'NETAPPDISKEVENT': "storage.NetAppDiskEvent",
            'NETAPPETHERNETPORTEVENT': "storage.NetAppEthernetPortEvent",
            'NETAPPFCINTERFACEEVENT': "storage.NetAppFcInterfaceEvent",
            'NETAPPFCPORTEVENT': "storage.NetAppFcPortEvent",
            'NETAPPIPINTERFACEEVENT': "storage.NetAppIpInterfaceEvent",
            'NETAPPLUNEVENT': "storage.NetAppLunEvent",
            'NETAPPNODEEVENT': "storage.NetAppNodeEvent",
            'NETAPPNONDATAIPINTERFACEEVENT': "storage.NetAppNonDataIpInterfaceEvent",
            'NETAPPSVMEVENT': "storage.NetAppSvmEvent",
            'NETAPPVOLUMEEVENT': "storage.NetAppVolumeEvent",
        },
        ('current_state',): {
            'UNKNOWN': "unknown",
            'NEW': "new",
            'ACKNOWLEDGED': "acknowledged",
            'RESOLVED': "resolved",
            'OBSOLETE': "obsolete",
        },
        ('impact_area',): {
            'UNKNOWN': "unknown",
            'AVAILABILITY': "availability",
            'CAPACITY': "capacity",
            'CONFIGURATION': "configuration",
            'PERFORMANCE': "performance",
            'PROTECTION': "protection",
            'SECURITY': "security",
        },
        ('impact_level',): {
            'UNKNOWN': "unknown",
            'EVENT': "event",
            'RISK': "risk",
            'INCIDENT': "incident",
            'UPGRADE': "upgrade",
        },
        ('impact_resource_type',): {
            'UNKNOWN': "unknown",
            'AGGREGATE': "aggregate",
            'CLUSTER': "cluster",
            'CLUSTER_NODE': "cluster_node",
            'DISK': "disk",
            'FCP_LIF': "fcp_lif",
            'FCP_PORT': "fcp_port",
            'LUN': "lun",
            'NETWORK_LIF': "network_lif",
            'NETWORK_PORT': "network_port",
            'VOLUME': "volume",
            'VSERVER': "vserver",
        },
        ('severity',): {
            'UNKNOWN': "unknown",
            'NORMAL': "normal",
            'INFORMATION': "information",
            'WARNING': "warning",
            'ERROR': "error",
            'CRITICAL': "critical",
        },
    }

    validations = {
        ('uuid',): {
            'regex': {
                'pattern': r'^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'cause': (str,),  # noqa: E501
            'cluster_uuid': (str,),  # noqa: E501
            'current_state': (str,),  # noqa: E501
            'duration': (str,),  # noqa: E501
            'impact_area': (str,),  # noqa: E501
            'impact_level': (str,),  # noqa: E501
            'impact_resource_name': (str,),  # noqa: E501
            'impact_resource_type': (str,),  # noqa: E501
            'impact_resource_uuid': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'node_uuid': (str,),  # noqa: E501
            'severity': (str,),  # noqa: E501
            'svm_uuid': (str,),  # noqa: E501
            'uuid': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'cause': 'Cause',  # noqa: E501
        'cluster_uuid': 'ClusterUuid',  # noqa: E501
        'current_state': 'CurrentState',  # noqa: E501
        'duration': 'Duration',  # noqa: E501
        'impact_area': 'ImpactArea',  # noqa: E501
        'impact_level': 'ImpactLevel',  # noqa: E501
        'impact_resource_name': 'ImpactResourceName',  # noqa: E501
        'impact_resource_type': 'ImpactResourceType',  # noqa: E501
        'impact_resource_uuid': 'ImpactResourceUuid',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'node_uuid': 'NodeUuid',  # noqa: E501
        'severity': 'Severity',  # noqa: E501
        'svm_uuid': 'SvmUuid',  # noqa: E501
        'uuid': 'Uuid',  # noqa: E501
    }

    read_only_vars = {
        'cause',  # noqa: E501
        'cluster_uuid',  # noqa: E501
        'current_state',  # noqa: E501
        'duration',  # noqa: E501
        'impact_area',  # noqa: E501
        'impact_level',  # noqa: E501
        'impact_resource_name',  # noqa: E501
        'impact_resource_type',  # noqa: E501
        'impact_resource_uuid',  # noqa: E501
        'name',  # noqa: E501
        'node_uuid',  # noqa: E501
        'severity',  # noqa: E501
        'svm_uuid',  # noqa: E501
        'uuid',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, class_id, object_type, *args, **kwargs):  # noqa: E501
        """StorageNetAppBaseEventAllOf - a model defined in OpenAPI

        Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            cause (str): A message describing the cause for the event.. [optional]  # noqa: E501
            cluster_uuid (str): Unique identifier of the cluster across the datacenter.. [optional]  # noqa: E501
            current_state (str): The current state of the event. * `unknown` - Default unknown current state. * `new` - The current state of the event is new. * `acknowledged` - The current state of the event is acknowledged. * `resolved` - The current state of the event is resolved. * `obsolete` - The current state of the event is obsolete.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            duration (str): Time since the event was created, in ISO8601 standard.. [optional]  # noqa: E501
            impact_area (str): Impact area of the event (availability, capacity, configuration, performance, protection, or security). * `unknown` - Default unknown impact area. * `availability` - The impact area of the event is availability. * `capacity` - The impact area of the event is capacity. * `configuration` - The impact area of the event is configuration. * `performance` - The impact area of the event is performance. * `protection` - The impact area of the event is protection. * `security` - The impact area of the event is security.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            impact_level (str): Impact level of the event (event, risk, incident, or upgrade). * `unknown` - Default unknown impact level. * `event` - The impact level of the event is event. * `risk` - The impact level of the event is risk. * `incident` - The impact level of the event is incident. * `upgrade` - The impact level of the event is upgrade.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            impact_resource_name (str): The full name of the source of the event.. [optional]  # noqa: E501
            impact_resource_type (str): Type of resource with which the event is associated. * `unknown` - Default unknown resource type. * `aggregate` - The type of resource impacted by the event is an aggregate. * `cluster` - The type of resource impacted by the event is a cluster. * `cluster_node` - The type of resource impacted by the event is a node. * `disk` - The type of resource impacted by the event is a disk. * `fcp_lif` - The type of resource impacted by the event is a FC interface. * `fcp_port` - The type of resource impacted by the event is a FC port. * `lun` - The type of resource impacted by the event is a lun. * `network_lif` - The type of resource impacted by the event is an ethernet interface. * `network_port` - The type of resource impacted by the event is an ethernet port. * `volume` - The type of resource impacted by the event is a volume. * `vserver` - The type of resource impacted by the event is a storage VM.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            impact_resource_uuid (str): The unique identifier of the impacted resource.. [optional]  # noqa: E501
            name (str): The name of the event that occurred.. [optional]  # noqa: E501
            node_uuid (str): Unique identifier of the node across the cluster.. [optional]  # noqa: E501
            severity (str): The severity of the event. * `unknown` - Default unknown severity. * `normal` - The severity of the event is normal. * `information` - The severity of the event is information. * `warning` - The severity of the event is warning. * `error` - The severity of the event is error. * `critical` - The severity of the event is critical.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            svm_uuid (str): Unique identifier of the storage VM.. [optional]  # noqa: E501
            uuid (str): Unique identifier of the event.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """StorageNetAppBaseEventAllOf - a model defined in OpenAPI

        Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            cause (str): A message describing the cause for the event.. [optional]  # noqa: E501
            cluster_uuid (str): Unique identifier of the cluster across the datacenter.. [optional]  # noqa: E501
            current_state (str): The current state of the event. * `unknown` - Default unknown current state. * `new` - The current state of the event is new. * `acknowledged` - The current state of the event is acknowledged. * `resolved` - The current state of the event is resolved. * `obsolete` - The current state of the event is obsolete.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            duration (str): Time since the event was created, in ISO8601 standard.. [optional]  # noqa: E501
            impact_area (str): Impact area of the event (availability, capacity, configuration, performance, protection, or security). * `unknown` - Default unknown impact area. * `availability` - The impact area of the event is availability. * `capacity` - The impact area of the event is capacity. * `configuration` - The impact area of the event is configuration. * `performance` - The impact area of the event is performance. * `protection` - The impact area of the event is protection. * `security` - The impact area of the event is security.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            impact_level (str): Impact level of the event (event, risk, incident, or upgrade). * `unknown` - Default unknown impact level. * `event` - The impact level of the event is event. * `risk` - The impact level of the event is risk. * `incident` - The impact level of the event is incident. * `upgrade` - The impact level of the event is upgrade.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            impact_resource_name (str): The full name of the source of the event.. [optional]  # noqa: E501
            impact_resource_type (str): Type of resource with which the event is associated. * `unknown` - Default unknown resource type. * `aggregate` - The type of resource impacted by the event is an aggregate. * `cluster` - The type of resource impacted by the event is a cluster. * `cluster_node` - The type of resource impacted by the event is a node. * `disk` - The type of resource impacted by the event is a disk. * `fcp_lif` - The type of resource impacted by the event is a FC interface. * `fcp_port` - The type of resource impacted by the event is a FC port. * `lun` - The type of resource impacted by the event is a lun. * `network_lif` - The type of resource impacted by the event is an ethernet interface. * `network_port` - The type of resource impacted by the event is an ethernet port. * `volume` - The type of resource impacted by the event is a volume. * `vserver` - The type of resource impacted by the event is a storage VM.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            impact_resource_uuid (str): The unique identifier of the impacted resource.. [optional]  # noqa: E501
            name (str): The name of the event that occurred.. [optional]  # noqa: E501
            node_uuid (str): Unique identifier of the node across the cluster.. [optional]  # noqa: E501
            severity (str): The severity of the event. * `unknown` - Default unknown severity. * `normal` - The severity of the event is normal. * `information` - The severity of the event is information. * `warning` - The severity of the event is warning. * `error` - The severity of the event is error. * `critical` - The severity of the event is critical.. [optional] if omitted the server will use the default value of "unknown"  # noqa: E501
            svm_uuid (str): Unique identifier of the storage VM.. [optional]  # noqa: E501
            uuid (str): Unique identifier of the event.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
