"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.telemetry_druid_extraction_function_bucket import TelemetryDruidExtractionFunctionBucket
    from intersight.model.telemetry_druid_extraction_function_cascade import TelemetryDruidExtractionFunctionCascade
    from intersight.model.telemetry_druid_extraction_function_inline_lookup import TelemetryDruidExtractionFunctionInlineLookup
    from intersight.model.telemetry_druid_extraction_function_inline_lookup_all_of_lookup import TelemetryDruidExtractionFunctionInlineLookupAllOfLookup
    from intersight.model.telemetry_druid_extraction_function_lower_case import TelemetryDruidExtractionFunctionLowerCase
    from intersight.model.telemetry_druid_extraction_function_partial import TelemetryDruidExtractionFunctionPartial
    from intersight.model.telemetry_druid_extraction_function_regex import TelemetryDruidExtractionFunctionRegex
    from intersight.model.telemetry_druid_extraction_function_search_query import TelemetryDruidExtractionFunctionSearchQuery
    from intersight.model.telemetry_druid_extraction_function_string_format import TelemetryDruidExtractionFunctionStringFormat
    from intersight.model.telemetry_druid_extraction_function_strlen import TelemetryDruidExtractionFunctionStrlen
    from intersight.model.telemetry_druid_extraction_function_substring import TelemetryDruidExtractionFunctionSubstring
    from intersight.model.telemetry_druid_extraction_function_time_format import TelemetryDruidExtractionFunctionTimeFormat
    from intersight.model.telemetry_druid_extraction_function_time_parsing import TelemetryDruidExtractionFunctionTimeParsing
    from intersight.model.telemetry_druid_extraction_function_upper_case import TelemetryDruidExtractionFunctionUpperCase
    from intersight.model.telemetry_druid_granularity import TelemetryDruidGranularity
    globals()['TelemetryDruidExtractionFunctionBucket'] = TelemetryDruidExtractionFunctionBucket
    globals()['TelemetryDruidExtractionFunctionCascade'] = TelemetryDruidExtractionFunctionCascade
    globals()['TelemetryDruidExtractionFunctionInlineLookup'] = TelemetryDruidExtractionFunctionInlineLookup
    globals()['TelemetryDruidExtractionFunctionInlineLookupAllOfLookup'] = TelemetryDruidExtractionFunctionInlineLookupAllOfLookup
    globals()['TelemetryDruidExtractionFunctionLowerCase'] = TelemetryDruidExtractionFunctionLowerCase
    globals()['TelemetryDruidExtractionFunctionPartial'] = TelemetryDruidExtractionFunctionPartial
    globals()['TelemetryDruidExtractionFunctionRegex'] = TelemetryDruidExtractionFunctionRegex
    globals()['TelemetryDruidExtractionFunctionSearchQuery'] = TelemetryDruidExtractionFunctionSearchQuery
    globals()['TelemetryDruidExtractionFunctionStringFormat'] = TelemetryDruidExtractionFunctionStringFormat
    globals()['TelemetryDruidExtractionFunctionStrlen'] = TelemetryDruidExtractionFunctionStrlen
    globals()['TelemetryDruidExtractionFunctionSubstring'] = TelemetryDruidExtractionFunctionSubstring
    globals()['TelemetryDruidExtractionFunctionTimeFormat'] = TelemetryDruidExtractionFunctionTimeFormat
    globals()['TelemetryDruidExtractionFunctionTimeParsing'] = TelemetryDruidExtractionFunctionTimeParsing
    globals()['TelemetryDruidExtractionFunctionUpperCase'] = TelemetryDruidExtractionFunctionUpperCase
    globals()['TelemetryDruidGranularity'] = TelemetryDruidGranularity


class TelemetryDruidExtractionFunction(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('type',): {
            'BUCKET': "bucket",
        },
        ('null_handling',): {
            'NULLSTRING': "nullString",
            'EMPTYSTRING': "emptyString",
            'RETURNNULL': "returnNull",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'type': (str,),  # noqa: E501
            'replace_missing_value': (bool,),  # noqa: E501
            'replace_missing_value_with': (str,),  # noqa: E501
            'length': (int,),  # noqa: E501
            'locale': (str,),  # noqa: E501
            'time_zone': (str,),  # noqa: E501
            'granularity': (TelemetryDruidGranularity,),  # noqa: E501
            'as_millis': (bool,),  # noqa: E501
            'time_format': (str,),  # noqa: E501
            'result_format': (str,),  # noqa: E501
            'joda': (bool,),  # noqa: E501
            'lookup': (TelemetryDruidExtractionFunctionInlineLookupAllOfLookup,),  # noqa: E501
            'retain_missing_value': (bool,),  # noqa: E501
            'injective': (bool,),  # noqa: E501
            'optimize': (bool,),  # noqa: E501
            'extraction_fns': ([TelemetryDruidExtractionFunction],),  # noqa: E501
            'null_handling': (str,),  # noqa: E501
            'size': (int,),  # noqa: E501
            'offset': (int,),  # noqa: E501
            'expr': (str,),  # noqa: E501
            'index': (int,),  # noqa: E501
            'query': (str,),  # noqa: E501
            'format': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'bucket': TelemetryDruidExtractionFunctionBucket,
            'cascade': TelemetryDruidExtractionFunctionCascade,
            'lookup': TelemetryDruidExtractionFunctionInlineLookup,
            'lower': TelemetryDruidExtractionFunctionLowerCase,
            'partial': TelemetryDruidExtractionFunctionPartial,
            'regex': TelemetryDruidExtractionFunctionRegex,
            'searchQuery': TelemetryDruidExtractionFunctionSearchQuery,
            'stringFormat': TelemetryDruidExtractionFunctionStringFormat,
            'strlen': TelemetryDruidExtractionFunctionStrlen,
            'substring': TelemetryDruidExtractionFunctionSubstring,
            'telemetry.DruidExtractionFunctionBucket': TelemetryDruidExtractionFunctionBucket,
            'telemetry.DruidExtractionFunctionCascade': TelemetryDruidExtractionFunctionCascade,
            'telemetry.DruidExtractionFunctionInlineLookup': TelemetryDruidExtractionFunctionInlineLookup,
            'telemetry.DruidExtractionFunctionLowerCase': TelemetryDruidExtractionFunctionLowerCase,
            'telemetry.DruidExtractionFunctionPartial': TelemetryDruidExtractionFunctionPartial,
            'telemetry.DruidExtractionFunctionRegex': TelemetryDruidExtractionFunctionRegex,
            'telemetry.DruidExtractionFunctionSearchQuery': TelemetryDruidExtractionFunctionSearchQuery,
            'telemetry.DruidExtractionFunctionStringFormat': TelemetryDruidExtractionFunctionStringFormat,
            'telemetry.DruidExtractionFunctionStrlen': TelemetryDruidExtractionFunctionStrlen,
            'telemetry.DruidExtractionFunctionSubstring': TelemetryDruidExtractionFunctionSubstring,
            'telemetry.DruidExtractionFunctionTimeFormat': TelemetryDruidExtractionFunctionTimeFormat,
            'telemetry.DruidExtractionFunctionTimeParsing': TelemetryDruidExtractionFunctionTimeParsing,
            'telemetry.DruidExtractionFunctionUpperCase': TelemetryDruidExtractionFunctionUpperCase,
            'time': TelemetryDruidExtractionFunctionTimeParsing,
            'timeFormat': TelemetryDruidExtractionFunctionTimeFormat,
            'upper': TelemetryDruidExtractionFunctionUpperCase,
        }
        if not val:
            return None
        return {'type': val}

    attribute_map = {
        'type': 'type',  # noqa: E501
        'replace_missing_value': 'replaceMissingValue',  # noqa: E501
        'replace_missing_value_with': 'replaceMissingValueWith',  # noqa: E501
        'length': 'length',  # noqa: E501
        'locale': 'locale',  # noqa: E501
        'time_zone': 'timeZone',  # noqa: E501
        'granularity': 'granularity',  # noqa: E501
        'as_millis': 'asMillis',  # noqa: E501
        'time_format': 'timeFormat',  # noqa: E501
        'result_format': 'resultFormat',  # noqa: E501
        'joda': 'joda',  # noqa: E501
        'lookup': 'lookup',  # noqa: E501
        'retain_missing_value': 'retainMissingValue',  # noqa: E501
        'injective': 'injective',  # noqa: E501
        'optimize': 'optimize',  # noqa: E501
        'extraction_fns': 'extractionFns',  # noqa: E501
        'null_handling': 'nullHandling',  # noqa: E501
        'size': 'size',  # noqa: E501
        'offset': 'offset',  # noqa: E501
        'expr': 'expr',  # noqa: E501
        'index': 'index',  # noqa: E501
        'query': 'query',  # noqa: E501
        'format': 'format',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """TelemetryDruidExtractionFunction - a model defined in OpenAPI

        Keyword Args:
            type (str): defaults to "bucket", must be one of ["bucket", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            replace_missing_value (bool): If the replaceMissingValue property is true, the extraction function will transform dimension values that do not match the regex pattern to a user-specified String. Default value is false.. [optional]  # noqa: E501
            replace_missing_value_with (str): Provides a hint how to handle missing values. Setting replaceMissingValueWith to \"\" has the same effect as setting it to null or omitting the property.. [optional]  # noqa: E501
            length (int): The length may be omitted for substring to return the remainder of the dimension value starting from index, or null if index greater than the length of the dimension value.. [optional]  # noqa: E501
            locale (str): [optional]  # noqa: E501
            time_zone (str): Time zone to use in IANA tz database format, e.g. Europe/Berlin (this can possibly be different than the aggregation time-zone). [optional]  # noqa: E501
            granularity (TelemetryDruidGranularity): [optional]  # noqa: E501
            as_millis (bool): boolean value, set to true to treat input strings as millis rather than ISO8601 strings. Additionally, if format is null or not specified, output will be in millis rather than ISO8601.. [optional]  # noqa: E501
            time_format (str): [optional]  # noqa: E501
            result_format (str): [optional]  # noqa: E501
            joda (bool): [optional]  # noqa: E501
            lookup (TelemetryDruidExtractionFunctionInlineLookupAllOfLookup): [optional]  # noqa: E501
            retain_missing_value (bool): Provides a hint how to handle missing values. Setting retainMissingValue to true will use the dimension's original value if it is not found in the lookup. The default values are replaceMissingValueWith = null and retainMissingValue = false which causes missing values to be treated as missing. It is illegal to set retainMissingValue = true and also specify a replaceMissingValueWith.. [optional]  # noqa: E501
            injective (bool): Override the lookup's own sense of whether or not it is injective.. [optional]  # noqa: E501
            optimize (bool): Allow optimization of lookup based extraction filter (by default optimize = true). The optimization layer will run on the Broker and it will rewrite the extraction filter as clause of selector filters.. [optional]  # noqa: E501
            extraction_fns ([TelemetryDruidExtractionFunction]): [optional]  # noqa: E501
            null_handling (str): [optional]  # noqa: E501
            size (int): The size of the buckets (optional, default 1).. [optional]  # noqa: E501
            offset (int): The offset for the buckets (optional, default 0).. [optional]  # noqa: E501
            expr (str): [optional]  # noqa: E501
            index (int): [optional]  # noqa: E501
            query (str): [optional]  # noqa: E501
            format (str): A sprintf expression. For example if you want to concat \"[\" and \"]\" before and after the actual dimension value, you need to specify \"[%s]\" as format string.. [optional]  # noqa: E501
        """

        type = "bucket" if len(kwargs.get('type','').strip()) == 0 else kwargs.get('type', "bucket")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'type': type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """TelemetryDruidExtractionFunction - a model defined in OpenAPI

        Keyword Args:
            type (str): defaults to "bucket", must be one of ["bucket", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            replace_missing_value (bool): If the replaceMissingValue property is true, the extraction function will transform dimension values that do not match the regex pattern to a user-specified String. Default value is false.. [optional]  # noqa: E501
            replace_missing_value_with (str): Provides a hint how to handle missing values. Setting replaceMissingValueWith to \"\" has the same effect as setting it to null or omitting the property.. [optional]  # noqa: E501
            length (int): The length may be omitted for substring to return the remainder of the dimension value starting from index, or null if index greater than the length of the dimension value.. [optional]  # noqa: E501
            locale (str): [optional]  # noqa: E501
            time_zone (str): Time zone to use in IANA tz database format, e.g. Europe/Berlin (this can possibly be different than the aggregation time-zone). [optional]  # noqa: E501
            granularity (TelemetryDruidGranularity): [optional]  # noqa: E501
            as_millis (bool): boolean value, set to true to treat input strings as millis rather than ISO8601 strings. Additionally, if format is null or not specified, output will be in millis rather than ISO8601.. [optional]  # noqa: E501
            time_format (str): [optional]  # noqa: E501
            result_format (str): [optional]  # noqa: E501
            joda (bool): [optional]  # noqa: E501
            lookup (TelemetryDruidExtractionFunctionInlineLookupAllOfLookup): [optional]  # noqa: E501
            retain_missing_value (bool): Provides a hint how to handle missing values. Setting retainMissingValue to true will use the dimension's original value if it is not found in the lookup. The default values are replaceMissingValueWith = null and retainMissingValue = false which causes missing values to be treated as missing. It is illegal to set retainMissingValue = true and also specify a replaceMissingValueWith.. [optional]  # noqa: E501
            injective (bool): Override the lookup's own sense of whether or not it is injective.. [optional]  # noqa: E501
            optimize (bool): Allow optimization of lookup based extraction filter (by default optimize = true). The optimization layer will run on the Broker and it will rewrite the extraction filter as clause of selector filters.. [optional]  # noqa: E501
            extraction_fns ([TelemetryDruidExtractionFunction]): [optional]  # noqa: E501
            null_handling (str): [optional]  # noqa: E501
            size (int): The size of the buckets (optional, default 1).. [optional]  # noqa: E501
            offset (int): The offset for the buckets (optional, default 0).. [optional]  # noqa: E501
            expr (str): [optional]  # noqa: E501
            index (int): [optional]  # noqa: E501
            query (str): [optional]  # noqa: E501
            format (str): A sprintf expression. For example if you want to concat \"[\" and \"]\" before and after the actual dimension value, you need to specify \"[%s]\" as format string.. [optional]  # noqa: E501
        """

        type = "bucket" if len(kwargs.get('type','').strip()) == 0 else kwargs.get('type', "bucket")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'type': type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
          ],
          'oneOf': [
              TelemetryDruidExtractionFunctionBucket,
              TelemetryDruidExtractionFunctionCascade,
              TelemetryDruidExtractionFunctionInlineLookup,
              TelemetryDruidExtractionFunctionLowerCase,
              TelemetryDruidExtractionFunctionPartial,
              TelemetryDruidExtractionFunctionRegex,
              TelemetryDruidExtractionFunctionSearchQuery,
              TelemetryDruidExtractionFunctionStringFormat,
              TelemetryDruidExtractionFunctionStrlen,
              TelemetryDruidExtractionFunctionSubstring,
              TelemetryDruidExtractionFunctionTimeFormat,
              TelemetryDruidExtractionFunctionTimeParsing,
              TelemetryDruidExtractionFunctionUpperCase,
          ],
        }
