"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.telemetry_druid_and_filter import TelemetryDruidAndFilter
    from intersight.model.telemetry_druid_bound_filter import TelemetryDruidBoundFilter
    from intersight.model.telemetry_druid_column_comparison_filter import TelemetryDruidColumnComparisonFilter
    from intersight.model.telemetry_druid_dimension_spec import TelemetryDruidDimensionSpec
    from intersight.model.telemetry_druid_equality_filter import TelemetryDruidEqualityFilter
    from intersight.model.telemetry_druid_expression_filter import TelemetryDruidExpressionFilter
    from intersight.model.telemetry_druid_extraction_function import TelemetryDruidExtractionFunction
    from intersight.model.telemetry_druid_false_filter import TelemetryDruidFalseFilter
    from intersight.model.telemetry_druid_in_filter import TelemetryDruidInFilter
    from intersight.model.telemetry_druid_interval_filter import TelemetryDruidIntervalFilter
    from intersight.model.telemetry_druid_like_filter import TelemetryDruidLikeFilter
    from intersight.model.telemetry_druid_not_filter import TelemetryDruidNotFilter
    from intersight.model.telemetry_druid_null_filter import TelemetryDruidNullFilter
    from intersight.model.telemetry_druid_or_filter import TelemetryDruidOrFilter
    from intersight.model.telemetry_druid_query_spec import TelemetryDruidQuerySpec
    from intersight.model.telemetry_druid_range_filter import TelemetryDruidRangeFilter
    from intersight.model.telemetry_druid_regex_filter import TelemetryDruidRegexFilter
    from intersight.model.telemetry_druid_search_filter import TelemetryDruidSearchFilter
    from intersight.model.telemetry_druid_selector_filter import TelemetryDruidSelectorFilter
    from intersight.model.telemetry_druid_true_filter import TelemetryDruidTrueFilter
    globals()['TelemetryDruidAndFilter'] = TelemetryDruidAndFilter
    globals()['TelemetryDruidBoundFilter'] = TelemetryDruidBoundFilter
    globals()['TelemetryDruidColumnComparisonFilter'] = TelemetryDruidColumnComparisonFilter
    globals()['TelemetryDruidDimensionSpec'] = TelemetryDruidDimensionSpec
    globals()['TelemetryDruidEqualityFilter'] = TelemetryDruidEqualityFilter
    globals()['TelemetryDruidExpressionFilter'] = TelemetryDruidExpressionFilter
    globals()['TelemetryDruidExtractionFunction'] = TelemetryDruidExtractionFunction
    globals()['TelemetryDruidFalseFilter'] = TelemetryDruidFalseFilter
    globals()['TelemetryDruidInFilter'] = TelemetryDruidInFilter
    globals()['TelemetryDruidIntervalFilter'] = TelemetryDruidIntervalFilter
    globals()['TelemetryDruidLikeFilter'] = TelemetryDruidLikeFilter
    globals()['TelemetryDruidNotFilter'] = TelemetryDruidNotFilter
    globals()['TelemetryDruidNullFilter'] = TelemetryDruidNullFilter
    globals()['TelemetryDruidOrFilter'] = TelemetryDruidOrFilter
    globals()['TelemetryDruidQuerySpec'] = TelemetryDruidQuerySpec
    globals()['TelemetryDruidRangeFilter'] = TelemetryDruidRangeFilter
    globals()['TelemetryDruidRegexFilter'] = TelemetryDruidRegexFilter
    globals()['TelemetryDruidSearchFilter'] = TelemetryDruidSearchFilter
    globals()['TelemetryDruidSelectorFilter'] = TelemetryDruidSelectorFilter
    globals()['TelemetryDruidTrueFilter'] = TelemetryDruidTrueFilter


class TelemetryDruidFilter(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('type',): {
            'EXPRESSION': "expression",
        },
        ('ordering',): {
            'LEXICOGRAPHIC': "lexicographic",
            'ALPHANUMERIC': "alphanumeric",
            'NUMERIC': "numeric",
            'STRLEN': "strlen",
            'VERSION': "version",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'type': (str,),  # noqa: E501
            'extraction_fn': (TelemetryDruidExtractionFunction,),  # noqa: E501
            'lower': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'upper': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'lower_strict': (bool,),  # noqa: E501
            'upper_strict': (bool,),  # noqa: E501
            'ordering': (str,),  # noqa: E501
            'lower_open': (bool,),  # noqa: E501
            'upper_open': (bool,),  # noqa: E501
            'escape': (str,),  # noqa: E501
            'dimension': (str,),  # noqa: E501
            'value': (str,),  # noqa: E501
            'column': (str,),  # noqa: E501
            'match_value_type': (str,),  # noqa: E501
            'match_value': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'dimensions': ([TelemetryDruidDimensionSpec],),  # noqa: E501
            'fields': ([TelemetryDruidFilter],),  # noqa: E501
            'field': (TelemetryDruidFilter,),  # noqa: E501
            'values': ([str],),  # noqa: E501
            'pattern': (str,),  # noqa: E501
            'intervals': ([str],),  # noqa: E501
            'query': (TelemetryDruidQuerySpec,),  # noqa: E501
            'expression': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'and': TelemetryDruidAndFilter,
            'bound': TelemetryDruidBoundFilter,
            'columnComparison': TelemetryDruidColumnComparisonFilter,
            'equality': TelemetryDruidEqualityFilter,
            'expression': TelemetryDruidExpressionFilter,
            'false': TelemetryDruidFalseFilter,
            'in': TelemetryDruidInFilter,
            'interval': TelemetryDruidIntervalFilter,
            'like': TelemetryDruidLikeFilter,
            'not': TelemetryDruidNotFilter,
            'null': TelemetryDruidNullFilter,
            'or': TelemetryDruidOrFilter,
            'range': TelemetryDruidRangeFilter,
            'regex': TelemetryDruidRegexFilter,
            'search': TelemetryDruidSearchFilter,
            'selector': TelemetryDruidSelectorFilter,
            'telemetry.DruidAndFilter': TelemetryDruidAndFilter,
            'telemetry.DruidBoundFilter': TelemetryDruidBoundFilter,
            'telemetry.DruidColumnComparisonFilter': TelemetryDruidColumnComparisonFilter,
            'telemetry.DruidEqualityFilter': TelemetryDruidEqualityFilter,
            'telemetry.DruidExpressionFilter': TelemetryDruidExpressionFilter,
            'telemetry.DruidFalseFilter': TelemetryDruidFalseFilter,
            'telemetry.DruidInFilter': TelemetryDruidInFilter,
            'telemetry.DruidIntervalFilter': TelemetryDruidIntervalFilter,
            'telemetry.DruidLikeFilter': TelemetryDruidLikeFilter,
            'telemetry.DruidNotFilter': TelemetryDruidNotFilter,
            'telemetry.DruidNullFilter': TelemetryDruidNullFilter,
            'telemetry.DruidOrFilter': TelemetryDruidOrFilter,
            'telemetry.DruidRangeFilter': TelemetryDruidRangeFilter,
            'telemetry.DruidRegexFilter': TelemetryDruidRegexFilter,
            'telemetry.DruidSearchFilter': TelemetryDruidSearchFilter,
            'telemetry.DruidSelectorFilter': TelemetryDruidSelectorFilter,
            'telemetry.DruidTrueFilter': TelemetryDruidTrueFilter,
            'true': TelemetryDruidTrueFilter,
        }
        if not val:
            return None
        return {'type': val}

    attribute_map = {
        'type': 'type',  # noqa: E501
        'extraction_fn': 'extractionFn',  # noqa: E501
        'lower': 'lower',  # noqa: E501
        'upper': 'upper',  # noqa: E501
        'lower_strict': 'lowerStrict',  # noqa: E501
        'upper_strict': 'upperStrict',  # noqa: E501
        'ordering': 'ordering',  # noqa: E501
        'lower_open': 'lowerOpen',  # noqa: E501
        'upper_open': 'upperOpen',  # noqa: E501
        'escape': 'escape',  # noqa: E501
        'dimension': 'dimension',  # noqa: E501
        'value': 'value',  # noqa: E501
        'column': 'column',  # noqa: E501
        'match_value_type': 'matchValueType',  # noqa: E501
        'match_value': 'matchValue',  # noqa: E501
        'dimensions': 'dimensions',  # noqa: E501
        'fields': 'fields',  # noqa: E501
        'field': 'field',  # noqa: E501
        'values': 'values',  # noqa: E501
        'pattern': 'pattern',  # noqa: E501
        'intervals': 'intervals',  # noqa: E501
        'query': 'query',  # noqa: E501
        'expression': 'expression',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """TelemetryDruidFilter - a model defined in OpenAPI

        Keyword Args:
            type (str): defaults to "expression", must be one of ["expression", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            extraction_fn (TelemetryDruidExtractionFunction): [optional]  # noqa: E501
            lower (bool, date, datetime, dict, float, int, list, str, none_type): Lower bound value to match. At least one of lower or upper must not be null.. [optional]  # noqa: E501
            upper (bool, date, datetime, dict, float, int, list, str, none_type): Upper bound value to match. At least one of lower or upper must not be null.. [optional]  # noqa: E501
            lower_strict (bool): Boolean indicating whether to perform strict comparison on the lower bound (\">\" instead of \">=\").. [optional]  # noqa: E501
            upper_strict (bool): Boolean indicating whether to perform strict comparison on the upper bound (\"<\" instead of \"<=\").. [optional]  # noqa: E501
            ordering (str): String that specifies the sorting order to use when comparing values against the bound. lexicographic - Sorts values by converting Strings to their UTF-8 byte array representations and comparing lexicographically, byte-by-byte. alphanumeric - Suitable for strings with both numeric and non-numeric content, e.g., \"file12 sorts after file2\" This ordering is not suitable for numbers with decimal points or negative numbers. For example, \"1.3\" precedes \"1.15\" in this ordering because \"15\" has more significant digits than \"3\". Negative numbers are sorted after positive numbers (because numeric characters precede the \"-\" in the negative numbers). numeric - Sorts values as numbers, supports integers and floating point values. Negative values are supported. This sorting order will try to parse all string values as numbers. Unparseable values are treated as nulls, and nulls precede numbers. When comparing two unparseable values (e.g., \"hello\" and \"world\"), this ordering will sort by comparing the unparsed strings lexicographically. strlen - Sorts values by their string lengths. When there is a tie, this comparator falls back to using the String compareTo method. version - Sorts values as versions, e.g., \"10.0 sorts after 9.0\", \"1.0.0-SNAPSHOT sorts after 1.0.0\".. [optional]  # noqa: E501
            lower_open (bool): Boolean indicating if lower bound is open in the interval of values defined by the range (\">\" instead of \">=\").. [optional]  # noqa: E501
            upper_open (bool): Boolean indicating if upper bound is open on the interval of values defined by the range (\"<\" instead of \"<=\").. [optional]  # noqa: E501
            escape (str): A string escape character that can be used to escape special characters.. [optional]  # noqa: E501
            dimension (str): Input column or virtual column name to filter.. [optional]  # noqa: E501
            value (str): The value of a dimension.. [optional]  # noqa: E501
            column (str): Input column or virtual column name to filter.. [optional]  # noqa: E501
            match_value_type (str): String specifying the type of bounds to match. For example STRING, LONG, DOUBLE, FLOAT, ARRAY<STRING>, ARRAY<LONG>, or any other Druid type. The matchValueType determines how Druid interprets the matchValue to assist in converting to the type of the matched column and also defines the type of comparison used when matching values.. [optional]  # noqa: E501
            match_value (bool, date, datetime, dict, float, int, list, str, none_type): Value to match, must not be null.. [optional]  # noqa: E501
            dimensions ([TelemetryDruidDimensionSpec]): A list of DimensionSpecs, making it possible to apply an extraction function if needed.. [optional]  # noqa: E501
            fields ([TelemetryDruidFilter]): [optional]  # noqa: E501
            field (TelemetryDruidFilter): [optional]  # noqa: E501
            values ([str]): List of string value to match.. [optional]  # noqa: E501
            pattern (str): String pattern to match - any standard Java regular expression.. [optional]  # noqa: E501
            intervals ([str]): A JSON array containing ISO-8601 interval strings that defines the time ranges to filter on.. [optional]  # noqa: E501
            query (TelemetryDruidQuerySpec): [optional]  # noqa: E501
            expression (str): Expression string to evaluate into true or false. See the Druid expression system for more details.. [optional]  # noqa: E501
        """

        type = "expression" if len(kwargs.get('type','').strip()) == 0 else kwargs.get('type', "expression")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'type': type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]
        composed_keys = set()
        for instance in self._composed_instances:
            composed_keys.update(set(instance.attribute_map.values()))

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            if var_name in composed_keys:
                continue
            setattr(self, var_name, var_value)

        return self


    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """TelemetryDruidFilter - a model defined in OpenAPI

        Keyword Args:
            type (str): defaults to "expression", must be one of ["expression", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            extraction_fn (TelemetryDruidExtractionFunction): [optional]  # noqa: E501
            lower (bool, date, datetime, dict, float, int, list, str, none_type): Lower bound value to match. At least one of lower or upper must not be null.. [optional]  # noqa: E501
            upper (bool, date, datetime, dict, float, int, list, str, none_type): Upper bound value to match. At least one of lower or upper must not be null.. [optional]  # noqa: E501
            lower_strict (bool): Boolean indicating whether to perform strict comparison on the lower bound (\">\" instead of \">=\").. [optional]  # noqa: E501
            upper_strict (bool): Boolean indicating whether to perform strict comparison on the upper bound (\"<\" instead of \"<=\").. [optional]  # noqa: E501
            ordering (str): String that specifies the sorting order to use when comparing values against the bound. lexicographic - Sorts values by converting Strings to their UTF-8 byte array representations and comparing lexicographically, byte-by-byte. alphanumeric - Suitable for strings with both numeric and non-numeric content, e.g., \"file12 sorts after file2\" This ordering is not suitable for numbers with decimal points or negative numbers. For example, \"1.3\" precedes \"1.15\" in this ordering because \"15\" has more significant digits than \"3\". Negative numbers are sorted after positive numbers (because numeric characters precede the \"-\" in the negative numbers). numeric - Sorts values as numbers, supports integers and floating point values. Negative values are supported. This sorting order will try to parse all string values as numbers. Unparseable values are treated as nulls, and nulls precede numbers. When comparing two unparseable values (e.g., \"hello\" and \"world\"), this ordering will sort by comparing the unparsed strings lexicographically. strlen - Sorts values by their string lengths. When there is a tie, this comparator falls back to using the String compareTo method. version - Sorts values as versions, e.g., \"10.0 sorts after 9.0\", \"1.0.0-SNAPSHOT sorts after 1.0.0\".. [optional]  # noqa: E501
            lower_open (bool): Boolean indicating if lower bound is open in the interval of values defined by the range (\">\" instead of \">=\").. [optional]  # noqa: E501
            upper_open (bool): Boolean indicating if upper bound is open on the interval of values defined by the range (\"<\" instead of \"<=\").. [optional]  # noqa: E501
            escape (str): A string escape character that can be used to escape special characters.. [optional]  # noqa: E501
            dimension (str): Input column or virtual column name to filter.. [optional]  # noqa: E501
            value (str): The value of a dimension.. [optional]  # noqa: E501
            column (str): Input column or virtual column name to filter.. [optional]  # noqa: E501
            match_value_type (str): String specifying the type of bounds to match. For example STRING, LONG, DOUBLE, FLOAT, ARRAY<STRING>, ARRAY<LONG>, or any other Druid type. The matchValueType determines how Druid interprets the matchValue to assist in converting to the type of the matched column and also defines the type of comparison used when matching values.. [optional]  # noqa: E501
            match_value (bool, date, datetime, dict, float, int, list, str, none_type): Value to match, must not be null.. [optional]  # noqa: E501
            dimensions ([TelemetryDruidDimensionSpec]): A list of DimensionSpecs, making it possible to apply an extraction function if needed.. [optional]  # noqa: E501
            fields ([TelemetryDruidFilter]): [optional]  # noqa: E501
            field (TelemetryDruidFilter): [optional]  # noqa: E501
            values ([str]): List of string value to match.. [optional]  # noqa: E501
            pattern (str): String pattern to match - any standard Java regular expression.. [optional]  # noqa: E501
            intervals ([str]): A JSON array containing ISO-8601 interval strings that defines the time ranges to filter on.. [optional]  # noqa: E501
            query (TelemetryDruidQuerySpec): [optional]  # noqa: E501
            expression (str): Expression string to evaluate into true or false. See the Druid expression system for more details.. [optional]  # noqa: E501
        """

        type = "expression" if len(kwargs.get('type','').strip()) == 0 else kwargs.get('type', "expression")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'type': type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
          ],
          'oneOf': [
              TelemetryDruidAndFilter,
              TelemetryDruidBoundFilter,
              TelemetryDruidColumnComparisonFilter,
              TelemetryDruidEqualityFilter,
              TelemetryDruidExpressionFilter,
              TelemetryDruidFalseFilter,
              TelemetryDruidInFilter,
              TelemetryDruidIntervalFilter,
              TelemetryDruidLikeFilter,
              TelemetryDruidNotFilter,
              TelemetryDruidNullFilter,
              TelemetryDruidOrFilter,
              TelemetryDruidRangeFilter,
              TelemetryDruidRegexFilter,
              TelemetryDruidSearchFilter,
              TelemetryDruidSelectorFilter,
              TelemetryDruidTrueFilter,
          ],
        }
